/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import oracle.bali.ewt.event.ListenerManager;
import oracle.bali.ewt.ruler.Ruler;
import oracle.bali.ewt.ruler.RulerStyle;
import oracle.bali.ewt.ruler.Tick;
import oracle.bali.share.sort.Sort;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.CommonUtils;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileRulerEvent;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileRulerListener;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileTranslationHelper;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.DebugUtility;

public class FlatFileRuler
extends Ruler {
    private static final Font _RULER_DEFAULT_FONT = CommonUtils.getMonoFont(0, 12);
    private Ruler _this;
    private Font _currFont;
    private boolean _dragInProgress = false;
    private int _charSize;
    private int _nPoints = 3;
    private int[] _yPoints = new int[]{0, 5, 0};
    private Polygon _currentPolygon;
    public Vector _vPolygons = new Vector();
    private Color _polyColor = Color.red;
    private Color _textColor = Color.blue;
    private ListenerManager _listenerManager = new ListenerManager();
    private HandleMouseEvent _handleMouseEvent;
    private HandleMouseMotionEvent _handleMouseMotionEvent;
    private boolean _debug_on = false;

    public FlatFileRuler() {
        this(_RULER_DEFAULT_FONT);
    }

    public FlatFileRuler(Font f) {
        this._this = this;
        this._currFont = f;
        this._debug_on = false;
        FlatFileTranslationHelper helper = new FlatFileTranslationHelper();
        this.setToolTipText(helper.translate("RL_rulerToolTip", null));
        RulerStyle rStyle = this.createRulerStyle(f);
        this.setShowNumbers(false);
        this.setRulerStyle(rStyle);
        this._handleMouseEvent = new HandleMouseEvent();
        this._handleMouseMotionEvent = new HandleMouseMotionEvent();
        this.addMouseListener(this._handleMouseEvent);
        this.addMouseMotionListener(this._handleMouseMotionEvent);
    }

    private void _debug(String msg) {
        if (this._debug_on) {
            DebugUtility.debug(msg);
        }
    }

    private RulerStyle createRulerStyle(Font f) {
        Tick[] ticks = new Tick[]{new Tick(40, 100), new Tick(30, 50), new Tick(20, 10)};
        FontMetrics fm = this.getFontMetrics(f);
        this._charSize = fm.charWidth('1');
        RulerStyle rStyle = new RulerStyle(ticks, (double)this._charSize * 10.0);
        return rStyle;
    }

    public void setMarkerPosition(int markerPosition) {
        boolean markerFound = false;
        this._debug("setMarkerPosition(" + markerPosition + ")");
        markerPosition = this.alignToGrid(markerPosition);
        for (int i = 0; i < this._vPolygons.size(); ++i) {
            Polygon p = (Polygon)this._vPolygons.elementAt(i);
            if (!p.contains(new Point(markerPosition, 1))) continue;
            markerFound = true;
            break;
        }
        if (!markerFound) {
            Integer old = new Integer(markerPosition);
            this.repaintCanvas(markerPosition - 1, 0, 2, this.getInnerSize().height);
            this._vPolygons.addElement(this.constructPolygon(markerPosition));
            this.repaintCanvas(markerPosition - 1, 0, 2, this.getInnerSize().height);
            boolean id = false;
            Enumeration en = this._listenerManager.getListeners();
            while (en.hasMoreElements()) {
                FlatFileRulerListener listener = (FlatFileRulerListener)en.nextElement();
                listener.rulerSet(new FlatFileRulerEvent((Component)this._this, markerPosition, 0, 0));
            }
        }
    }

    public int[] getMarkedColumns() {
        int list_size = this._vPolygons.size();
        int[] ret_list = new int[list_size];
        for (int i0 = 0; i0 < list_size; ++i0) {
            Polygon p = (Polygon)this._vPolygons.elementAt(i0);
            int[] xPoints = p.xpoints;
            for (int i = 0; i < xPoints.length - 1; ++i) {
                for (int j = i + 1; j < xPoints.length; ++j) {
                    if (xPoints[i] <= xPoints[j]) continue;
                    int temp = xPoints[i];
                    xPoints[i] = xPoints[j];
                    xPoints[j] = temp;
                }
            }
            ret_list[i0] = xPoints[1] / this._charSize;
            this._debug("getMarkedColumns().ret_list[" + i0 + "] = " + ret_list[i0]);
        }
        Sort.qSort((int[])ret_list, (int)list_size, (boolean)true);
        if (list_size > 0 && ret_list[0] < 0) {
            int[] ret_list1 = new int[list_size - 1];
            System.arraycopy(ret_list, 1, ret_list1, 0, list_size - 1);
            this._debug("getMarkedColumns() returning ret_list1");
            return ret_list1;
        }
        this._debug("getMarkedColumns() returning ret_list");
        return ret_list;
    }

    public void setMarkedColumns(int[] locations) {
        int i;
        int[] current_marks = this.getMarkedColumns();
        this._debug("setMarkedColumns(...)");
        for (i = 0; i < current_marks.length; ++i) {
            Enumeration en = this._listenerManager.getListeners();
            while (en.hasMoreElements()) {
                FlatFileRulerListener listener = (FlatFileRulerListener)en.nextElement();
                listener.rulerDeleted(new FlatFileRulerEvent((Component)this._this, current_marks[i] * this._charSize, 0, 0));
            }
        }
        this._vPolygons.removeAllElements();
        for (i = 0; i < locations.length; ++i) {
            this._debug("setting location = " + locations[i]);
            int marker_position = locations[i] * this._charSize;
            this._vPolygons.addElement(this.constructPolygon(marker_position));
            boolean id = false;
            Enumeration en = this._listenerManager.getListeners();
            while (en.hasMoreElements()) {
                FlatFileRulerListener listener = (FlatFileRulerListener)en.nextElement();
                listener.rulerSet(new FlatFileRulerEvent((Component)this._this, marker_position, 0, 0));
            }
        }
        this.repaint();
    }

    private int alignToGrid(int markerPosition) {
        int newPosition = markerPosition;
        int mod = markerPosition % this._charSize;
        int offset = this._charSize / 2;
        if (mod >= offset) {
            newPosition += this._charSize - mod;
        } else if (mod < offset) {
            newPosition -= mod;
        }
        return newPosition;
    }

    private Polygon constructPolygon(int markerPosition) {
        int[] x = new int[]{markerPosition - 5, markerPosition, markerPosition + 5};
        Polygon p = new Polygon(x, this._yPoints, this._nPoints);
        return p;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        super.paintCanvasInterior(g);
        Dimension componentSize = this.getInnerSize();
        Color defColor = g.getColor();
        Font defFont = g.getFont();
        g.setColor(this._textColor);
        g.setFont(this._currFont);
        int height = componentSize.height / 3 * 2;
        int j = 0;
        for (int xoffset = 0; xoffset < this.getScrollPosition() + 2200; xoffset += this._charSize * 10) {
            g.drawString("" + j, xoffset, height);
            j += 10;
        }
        g.setColor(defColor);
        if (this._vPolygons.size() > 0) {
            g.setColor(this._polyColor);
            for (int i = 0; i < this._vPolygons.size(); ++i) {
                Polygon p = (Polygon)this._vPolygons.elementAt(i);
                g.fillPolygon(p);
            }
            g.setColor(defColor);
        }
        g.setFont(defFont);
    }

    public void addRulerListener(FlatFileRulerListener listener) {
        this._listenerManager.addListener((EventListener)listener);
    }

    public void removeRulerListener(FlatFileRulerListener listener) {
        this._listenerManager.removeListener((EventListener)listener);
    }

    public int getNumOfMarkers() {
        return this._vPolygons.size();
    }

    public void removeAllListeners() {
        this.removeMouseListener(this._handleMouseEvent);
        this.removeMouseMotionListener(this._handleMouseMotionEvent);
    }

    private class HandleMouseMotionEvent
    extends MouseMotionAdapter {
        private HandleMouseMotionEvent() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!FlatFileRuler.this._dragInProgress) {
                int currPosition = FlatFileRuler.this.alignToGrid(e.getX());
                for (int i = 0; i < FlatFileRuler.this._vPolygons.size(); ++i) {
                    Polygon p = (Polygon)FlatFileRuler.this._vPolygons.elementAt(i);
                    if (!p.contains(new Point(currPosition, 1))) continue;
                    FlatFileRuler.this._currentPolygon = p;
                    FlatFileRuler.this._dragInProgress = true;
                    break;
                }
            }
            if (FlatFileRuler.this._currentPolygon != null) {
                Enumeration en = FlatFileRuler.this._listenerManager.getListeners();
                while (en.hasMoreElements()) {
                    FlatFileRulerListener listener = (FlatFileRulerListener)en.nextElement();
                    int newPosition = e.getX();
                    int currentPosition = ((FlatFileRuler)FlatFileRuler.this)._currentPolygon.xpoints[1];
                    listener.rulerDragged(new FlatFileRulerEvent((Component)FlatFileRuler.this._this, currentPosition, newPosition, 0));
                }
                FlatFileRuler.this._currentPolygon.translate(e.getX() - ((FlatFileRuler)FlatFileRuler.this)._currentPolygon.xpoints[1], 0);
                FlatFileRuler.this.repaint();
            }
        }
    }

    private class HandleMouseEvent
    extends MouseAdapter {
        private HandleMouseEvent() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                Polygon currentPolygon = null;
                int currPosition = FlatFileRuler.this.alignToGrid(e.getX());
                for (int i = 0; i < FlatFileRuler.this._vPolygons.size(); ++i) {
                    Polygon p = (Polygon)FlatFileRuler.this._vPolygons.elementAt(i);
                    if (!p.contains(new Point(currPosition, 1))) continue;
                    currentPolygon = p;
                    break;
                }
                if (currentPolygon != null) {
                    FlatFileRuler.this._vPolygons.removeElement(currentPolygon);
                    FlatFileRuler.this._vPolygons.trimToSize();
                    FlatFileRuler.this.repaint();
                    int[] xPoints = currentPolygon.xpoints;
                    for (int i = 0; i < xPoints.length - 1; ++i) {
                        for (int j = i + 1; j < xPoints.length; ++j) {
                            if (xPoints[i] <= xPoints[j]) continue;
                            int temp = xPoints[i];
                            xPoints[i] = xPoints[j];
                            xPoints[j] = temp;
                        }
                    }
                    Enumeration en = FlatFileRuler.this._listenerManager.getListeners();
                    while (en.hasMoreElements()) {
                        FlatFileRulerListener listener = (FlatFileRulerListener)en.nextElement();
                        listener.rulerDeleted(new FlatFileRulerEvent((Component)FlatFileRuler.this._this, xPoints[1], 0, 0));
                    }
                }
            } else {
                FlatFileRuler.this.setMarkerPosition(e.getX());
                FlatFileRuler.this.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (FlatFileRuler.this._dragInProgress) {
                int mark_position = e.getX() + 0;
                FlatFileRuler.this._currentPolygon.translate(mark_position - ((FlatFileRuler)FlatFileRuler.this)._currentPolygon.xpoints[1], 0);
                FlatFileRulerEvent evt = new FlatFileRulerEvent((Component)FlatFileRuler.this._this, ((FlatFileRuler)FlatFileRuler.this)._currentPolygon.xpoints[1], mark_position, 0);
                Enumeration en = FlatFileRuler.this._listenerManager.getListeners();
                while (en.hasMoreElements()) {
                    FlatFileRulerListener listener = (FlatFileRulerListener)en.nextElement();
                    listener.rulerDeleted(evt);
                }
                mark_position = FlatFileRuler.this.alignToGrid(e.getX());
                FlatFileRuler.this._currentPolygon.translate(mark_position - ((FlatFileRuler)FlatFileRuler.this)._currentPolygon.xpoints[1], 0);
                evt = new FlatFileRulerEvent((Component)FlatFileRuler.this._this, ((FlatFileRuler)FlatFileRuler.this)._currentPolygon.xpoints[1], mark_position, 0);
                boolean found = false;
                if (((FlatFileRuler)FlatFileRuler.this)._currentPolygon.xpoints[1] < 1) {
                    found = true;
                    FlatFileRuler.this._vPolygons.removeElement(FlatFileRuler.this._currentPolygon);
                    FlatFileRuler.this._vPolygons.trimToSize();
                }
                for (int i = 0; !found && i < FlatFileRuler.this._vPolygons.size(); ++i) {
                    Polygon p = (Polygon)FlatFileRuler.this._vPolygons.elementAt(i);
                    if (p == FlatFileRuler.this._currentPolygon || p.xpoints[1] != ((FlatFileRuler)FlatFileRuler.this)._currentPolygon.xpoints[1]) continue;
                    found = true;
                    FlatFileRuler.this._vPolygons.removeElement(FlatFileRuler.this._currentPolygon);
                    FlatFileRuler.this._vPolygons.trimToSize();
                }
                Enumeration en2 = FlatFileRuler.this._listenerManager.getListeners();
                while (en2.hasMoreElements()) {
                    FlatFileRulerListener listener = (FlatFileRulerListener)en2.nextElement();
                    if (!found) {
                        listener.rulerDragged(evt);
                        continue;
                    }
                    listener.rulerDeleted(evt);
                }
                FlatFileRuler.this.repaint();
                FlatFileRuler.this._dragInProgress = false;
                FlatFileRuler.this._currentPolygon = null;
            }
        }
    }
}

