/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.StringCharacterIterator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import oracle.bali.ewt.grid.ComboBoxInputHandler;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.SortableTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.bali.ewt.model.TwoDModelListener;
import oracle.bali.share.sort.Sort;
import oracle.tip.pc.services.translation.importer.ccb.CCBImporter;
import oracle.tip.pc.services.translation.importer.ccb.CopyBookException;
import oracle.tip.pc.services.translation.importer.dtd.DTDImportException;
import oracle.tip.pc.services.translation.importer.dtd.DTDImporter;
import oracle.tip.pc.services.translation.tools.nxsdcompiler.NXSDException;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.BooleanColumnInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.ChoiceColumnInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.ColumnInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.CommonUtils;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.DSConverter;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileValidationException;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileWizard;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.IntColumnInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.RecTypeAttributes;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.RecTypeDataSourceObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.RecTypeExplorerTreeNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.StringColumnInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WBTranslatable;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WizardInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.DebugUtility;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XMLSchemaNode;
import oracle.xml.parser.schema.XSDAnnotation;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.NodeFactory;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLParseException;
import org.xml.sax.SAXException;
import sun.io.MalformedInputException;

public class FlatFileInfo
extends WizardInfo
implements Serializable {
    public static final String NXSD_EXT_NAMESPACE_URI = "http://xmlns.oracle.com/pcbpel/nxsd/extensions";
    public static final String NXSD_NAMESPACE_URI = "http://xmlns.oracle.com/pcbpel/nxsd";
    public static final String PC_NAMESPACE_URI = "http://TargetNamespace.com/ServiceName";
    public static final String PC_NAMESPACE_PREFIX = "nxsd:version=\"NXSD\"";
    public static final int FIELD_CONDITION = 0;
    public static final int FIELD_NAME_COL = 1;
    public static final int FIELD_TYPE_COL = 2;
    public static final int FIELD_LENGTH_COL = 3;
    public static final int FIELD_START_COL = 4;
    public static final int FIELD_END_COL = 5;
    public static final int FIELD_DELIMITER = 6;
    public static final int FIELD_STYLE = 7;
    public static final int FIELD_STYLEPATTERN1 = 8;
    public static final int FIELD_STYLEPATTERN2 = 9;
    public static final int FIELD_PADSTYLE = 10;
    public static final int FIELD_PADDING = 11;
    public static final int FIELD_CONDITION_VALUE = 12;
    public static final int FIELD_DEFAULT_VALUE = 13;
    public static final int FIELD_EDIT_COL = 14;
    public static final int FIELD_STARTS_WITH = 15;
    public static final int FIELD_MIN_OCCURS = 16;
    public static final int FIELD_MAX_OCCURS = 17;
    public static final int FIELD_PREFIX_COL = 18;
    public static final int FIELD_SUFFIX_COL = 19;
    public static final int FIELD_LOOK_AHEAD = 20;
    public static final int FIELD_LOOK_FOR = 21;
    public static final int FIELD_LENGTH_STYLE = 22;
    public static final int FIELD_ARRAY = 23;
    public static final int FIELD_ARRAY_LENGTH = 24;
    public static final int FIELD_ARRAY_SEP = 25;
    public static final int FIELD_CELL_SEP = 26;
    public static final int FIELD_DATE_FORMAT = 27;
    public static final int FIELD_QUOTED_BY = 28;
    public static final int FIELD_LIST = 29;
    public static final int FIELD_LIST_SEP = 30;
    public static final int FIELD_ITEM_SEP = 31;
    public static final int FIELD_SKIP_MODE = 32;
    public static final int FIELD_SKIP = 33;
    public static final int FIELD_SKIP_UNTIL = 34;
    public static final int FIELD_VAR_NAME = 35;
    public static final int FIELD_SCAN_LENGTH = 36;
    public static final int FIELD_ASSIGN_TO = 37;
    public static final String XML_PROLOG = "<?xml version=\"1.0\" encoding = \"UTF8\"?>";
    private static String[] _enclosureLeftInitialList = new String[]{"", "\"", "'", "(", "[", "<", "|"};
    private static String[] _delimiterInitialStringList = new String[]{"FI_generalColDelimiterSpace_FlatFile", "FI_generalColDelimiterComma_FlatFile", "FI_generalColDelimiterSemicolon_FlatFile", "FI_generalColDelimiterTab_FlatFile"};
    private static String[] _delimiterInitialList;
    private static String[] _characterSetList;
    private static String[] _styleList;
    private static String[] _padStyleList;
    public static final String LTL_END = "littleEndian";
    public static final String BIG_END = "bigEndian";
    public static final String EOL = "${eol}";
    private static final String EOF = "${eof}";
    public static final String LEFT_RIGHT_SURROUNDED = "left/right surrounded";
    private boolean _debug_on = false;
    private String _fileName;
    private boolean m_standalone_testing = false;
    private String _nxsdFileName;
    private String _modifiedNXSD;
    private int _maxReadRecSize = 0;
    private int _elementNameMaxLength;
    private boolean _isDelimitedFile;
    private boolean _isFixedLengthFile;
    private boolean _isComplexFile;
    private boolean _isDTD;
    private boolean _isCCB;
    private int _skip;
    private int _sample;
    private int _processRows;
    private String _recordTerminator;
    private boolean _recordTerminatorEOL = true;
    private boolean _isRecordSize;
    private int _recordSize;
    private boolean _isMultiRecordFile;
    private boolean _enableLogicalRecords;
    private boolean _continueThis;
    private String _continueChars;
    private boolean _isFixedNumToConcat;
    private boolean _useFirstRowAsFieldNames;
    private int _concatRows;
    private String _nextLine;
    private char _rightEnclosure;
    private char _leftEnclosure;
    private boolean _isEnclosedLeft;
    private boolean _isEnclosedRight;
    private int _recordsToProcessRemain;
    private boolean _singleInstance;
    private boolean _editingNXSD;
    private String _singleRecordName;
    private String _delimiter;
    private int _classifierStartPos;
    private int _classifierEndPos;
    private String _characterSet;
    private String _ccbEncoding;
    private String _ccbRecordDelimiter = "";
    private String _fileStructureName;
    private String _namespace;
    private String _rootElement;
    private String _description;
    private FlatFileInfo _sameAs = null;
    private FlatFileWizard _flatFileWizard;
    private boolean _sampleEverything;
    private boolean _newFilePicked = false;
    private StringBuffer _appsDTD;
    private String _nxsdEncoding = "UTF8";
    private Vector _rawFieldPropertiesInfo;
    private SortableTwoDModel _recordClassifierDs;
    private Hashtable _fieldPropertiesHash;
    private static String[] _xmlDataTypes;
    private boolean _littleEndian;
    private boolean _bigEndian;
    private DefaultTreeModel _hierarchicalModel;
    private JFileChooser _fileChooser;

    public FlatFileInfo(String fileName, WBTranslatable h) {
        super(h);
        this._fileName = fileName;
        this._fileStructureName = "";
        this.init();
    }

    private void _debug(String msg) {
        DebugUtility.debug(msg);
    }

    void chooseTypeInit() {
        this.init();
        this._editingNXSD = true;
        this._fileStructureName = "";
        this._fileName = "";
        this.clearRecords();
    }

    private void init() {
        this._debug("FFI init()");
        this._sampleEverything = false;
        this._debug_on = false;
        this._editingNXSD = false;
        this._isDelimitedFile = true;
        this._isFixedLengthFile = false;
        this._isComplexFile = false;
        this._isDTD = false;
        this._isCCB = false;
        this._skip = 0;
        this._sample = 200;
        this._recordSize = 0;
        this._recordTerminator = "\\n";
        this._singleInstance = false;
        this._isMultiRecordFile = false;
        this._isFixedNumToConcat = true;
        this._enableLogicalRecords = false;
        this._continueChars = "";
        this._concatRows = 1;
        this._delimiter = ",";
        this._bigEndian = true;
        this._littleEndian = false;
        _delimiterInitialList = new String[_delimiterInitialStringList.length];
        for (int i = 0; i < _delimiterInitialStringList.length; ++i) {
            FlatFileInfo._delimiterInitialList[i] = this.translate(_delimiterInitialStringList[i]);
        }
        this._isEnclosedLeft = true;
        this._isEnclosedRight = true;
        this._leftEnclosure = (char)34;
        this._rightEnclosure = (char)34;
        this._classifierStartPos = 0;
        this._classifierEndPos = 0;
        this._recordsToProcessRemain = -1;
        this._singleRecordName = "";
        this._rootElement = "";
        this._useFirstRowAsFieldNames = false;
        this._characterSet = System.getProperty("file.encoding");
        this._ccbEncoding = "EBCDIC (cp037)";
        this._namespace = "";
        this._ccbRecordDelimiter = "";
        this._characterSet = "US-ASCII";
        this._newFilePicked = true;
        this._hierarchicalModel = null;
    }

    private void freshFileInit() {
        this._debug("FFI freshFileinit()");
        this._sampleEverything = false;
        this._debug_on = false;
        this._editingNXSD = false;
        this._skip = 0;
        this._sample = 200;
        this._recordSize = 0;
        this._recordTerminator = "\\n";
        this._singleInstance = false;
        this._namespace = "";
        this._newFilePicked = true;
        this._isFixedNumToConcat = true;
        this._enableLogicalRecords = false;
        this._continueChars = "";
        this._concatRows = 1;
        this._delimiter = ",";
        this._bigEndian = true;
        this._littleEndian = false;
        _delimiterInitialList = new String[_delimiterInitialStringList.length];
        for (int i = 0; i < _delimiterInitialStringList.length; ++i) {
            FlatFileInfo._delimiterInitialList[i] = this.translate(_delimiterInitialStringList[i]);
        }
        this._isEnclosedLeft = true;
        this._isEnclosedRight = true;
        this._leftEnclosure = (char)34;
        this._rightEnclosure = (char)34;
        this._classifierStartPos = 0;
        this._classifierEndPos = 0;
        this._recordsToProcessRemain = -1;
        this._singleRecordName = "";
        this._rootElement = "";
        this._useFirstRowAsFieldNames = false;
        this._characterSet = System.getProperty("file.encoding");
        this._characterSet = "US-ASCII";
        this._ccbEncoding = "EBCDIC (cp037)";
        this.getFlatFileWizard().getNxsdFileInfo()._nxsdFileName = "";
        this._hierarchicalModel = null;
    }

    public boolean isStandaloneTesting() {
        return this.m_standalone_testing;
    }

    public void setStandaloneTesting(boolean value) {
        this.m_standalone_testing = value;
    }

    public String getDefaultCoding() {
        return this._characterSet;
    }

    public void setDefaultCoding(String defaultCoding) {
        if (defaultCoding.equals("EBCDIC (cp037)")) {
            this._ccbEncoding = "cp037";
            this._characterSet = "US-ASCII";
        } else if (defaultCoding.equals("ascii")) {
            this._ccbEncoding = "ascii";
            this._characterSet = "US-ASCII";
        } else {
            this._characterSet = defaultCoding;
        }
    }

    public String[] getDelimiterInitialList() {
        return _delimiterInitialList;
    }

    public String getDelimiter() {
        return this._delimiter;
    }

    public void setDelimiter(String delimiter) {
        if (this._delimiter.equals(this.translate("FI_generalColDelimiterWhiteSpace_FlatFile"))) {
            this._delimiter = "  ";
        } else if (this._delimiter.equals(this.translate("FI_generalColDelimiterComma_FlatFile"))) {
            this._delimiter = ",";
        } else if (this._delimiter.equals(this.translate("FI_generalColDelimiterSemicolon_FlatFile"))) {
            this._delimiter = ";";
        } else if (this._delimiter.equals(this.translate("FI_generalColDelimiterTab_FlatFile"))) {
            this._delimiter = "\\t";
        } else if (this._delimiter.equals(this.translate("FI_generalColDelimiterSpace_FlatFile"))) {
            this._delimiter = " ";
        }
        this._delimiter = delimiter;
    }

    public void clearRecords() {
        if (this._fieldPropertiesHash != null) {
            this._fieldPropertiesHash.clear();
            this._recordClassifierDs = null;
        }
    }

    public void isDelimitedFile(boolean value) {
        this._debug("isDelimitedFile = " + value + "  old = " + this._isDelimitedFile);
        if (value != this._isDelimitedFile) {
            if (!this.isEditingNXSD()) {
                this.init();
                this._fileStructureName = "";
                this._fileName = "";
            }
            this._isDelimitedFile = value;
            if (value) {
                this._isFixedLengthFile = false;
                this._isDTD = false;
                this._isCCB = false;
            }
            this._recordClassifierDs = null;
            if (this._fieldPropertiesHash != null) {
                this._fieldPropertiesHash.clear();
            }
            this.setChanged();
            this.notifyObservers();
        }
    }

    public void isComplexFile(boolean value) {
        this._debug("isComplexFile = " + value + "  old = " + this._isComplexFile);
        if (value != this._isComplexFile) {
            if (!this.isEditingNXSD()) {
                this.init();
                this._fileStructureName = "";
                this._fileName = "";
            }
            this._isComplexFile = value;
            if (value) {
                this._isFixedLengthFile = false;
                this._isDelimitedFile = false;
                this._isDTD = false;
                this._isCCB = false;
            }
            this._recordClassifierDs = null;
            if (this._fieldPropertiesHash != null) {
                this._fieldPropertiesHash.clear();
            }
            this.setChanged();
            this.notifyObservers();
        }
    }

    public void isFixedLengthFile(boolean value) {
        this._debug("_isFixedLengthFile = " + value + "  old = " + this._isFixedLengthFile);
        if (value != this._isFixedLengthFile) {
            if (!this.isEditingNXSD()) {
                this.init();
                this._fileStructureName = "";
                this._fileName = "";
            }
            this._isFixedLengthFile = value;
            if (value) {
                this._isDelimitedFile = false;
                this._isDTD = false;
                this._isCCB = false;
            }
            this._recordClassifierDs = null;
            if (this._fieldPropertiesHash != null) {
                this._fieldPropertiesHash.clear();
            }
            this.setChanged();
            this.notifyObservers();
        }
    }

    public void isDTDFile(boolean value) {
        this._debug("isDTD = " + value + "  old = " + this._isDTD);
        if (value != this._isDTD) {
            if (!this.isEditingNXSD()) {
                this.init();
                this._fileStructureName = "";
                this._fileName = "";
            }
            this._isDTD = value;
            if (value) {
                this._isFixedLengthFile = false;
                this._isDelimitedFile = false;
                this._isCCB = false;
            }
            this._recordClassifierDs = null;
            if (this._fieldPropertiesHash != null) {
                this._fieldPropertiesHash.clear();
            }
            this.setChanged();
            this.notifyObservers();
        }
    }

    public void isCCBFile(boolean value) {
        this._debug("_isCCB = " + value + "  old = " + this._isCCB);
        if (value != this._isCCB) {
            if (!this.isEditingNXSD()) {
                this.init();
                this._fileStructureName = "";
                this._fileName = "";
            }
            this._isCCB = value;
            if (value) {
                this._isFixedLengthFile = false;
                this._isDTD = false;
                this._isDelimitedFile = false;
            }
            this._recordClassifierDs = null;
            if (this._fieldPropertiesHash != null) {
                this._fieldPropertiesHash.clear();
            }
            this.setChanged();
            this.notifyObservers();
        }
    }

    public void isSingleInstance(boolean value) {
        if (this._singleInstance != value) {
            this._singleRecordName = "";
            this._singleInstance = value;
        }
    }

    public boolean isSingleInstance() {
        return this._singleInstance;
    }

    public void isLittleEndian(boolean value) {
        this._littleEndian = value;
        this._bigEndian = !value;
    }

    public boolean isLittleEndian() {
        return this._littleEndian;
    }

    public void isBigEndian(boolean value) {
        this._bigEndian = value;
        this._littleEndian = !value;
    }

    public boolean isBigEndian() {
        return this._bigEndian;
    }

    public boolean isDelimitedFile() {
        return this._isDelimitedFile;
    }

    public boolean isComplexFile() {
        return this._isComplexFile;
    }

    public boolean isEditingNXSD() {
        return this._editingNXSD;
    }

    public boolean isDTD() {
        return this._isDTD;
    }

    public boolean isFixedLength() {
        return this._isFixedLengthFile;
    }

    public boolean isCCB() {
        return this._isCCB;
    }

    public String getFileStructureName() {
        if ((this._fileStructureName == null || this._fileStructureName.length() <= 0) && this._fileName != null) {
            int idx = this._fileName.lastIndexOf(String.valueOf(File.separatorChar));
            this._fileStructureName = this._fileName.substring(idx + 1);
        }
        return this._fileStructureName;
    }

    public void setFileStructureName(String fileStructureName) throws FlatFileValidationException {
        if (null == fileStructureName || fileStructureName.equals("TBD") || fileStructureName.equals("")) {
            String[] args = new String[]{fileStructureName};
            throw new FlatFileValidationException(this.translate("FI_setupErrFileStructureNameInvalid_API22", args));
        }
        if (null != this._fileStructureName && this._fileStructureName.equals(fileStructureName)) {
            return;
        }
        if (!this.isEditingNXSD()) {
            if (this._fieldPropertiesHash != null) {
                this._fieldPropertiesHash.clear();
            }
            this._recordClassifierDs = null;
            this.freshFileInit();
        }
        this.validateFileName(fileStructureName);
        this._fileStructureName = fileStructureName;
        this._debug("FFI new _fileStructureName " + fileStructureName);
    }

    public String getEnclosureLeft() {
        return String.valueOf(this._leftEnclosure);
    }

    public static String[] getEnclosureLeftInitialList() {
        return _enclosureLeftInitialList;
    }

    public boolean isEnclosedLeft() {
        return this._isEnclosedLeft;
    }

    public void setEnclosureLeft(String enclosureLeft) {
        if (enclosureLeft.length() > 0) {
            this._leftEnclosure = enclosureLeft.charAt(0);
            this._isEnclosedLeft = true;
        } else {
            this._leftEnclosure = '\u0000';
            this._isEnclosedLeft = false;
        }
    }

    public String getEnclosureRight() {
        return String.valueOf(this._rightEnclosure);
    }

    public void setEnclosureRight(String enclosureRight) {
        if (enclosureRight.length() > 0) {
            this._rightEnclosure = enclosureRight.charAt(0);
            this._isEnclosedRight = true;
        } else {
            this._rightEnclosure = '\u0000';
            this._isEnclosedRight = false;
        }
    }

    public String getFileName() {
        return this._fileName;
    }

    public String getNXSDFileName() {
        return this._nxsdFileName;
    }

    public void setNXSDFileName(String nxsdFile) {
        this._debug("FFI setNXSDFileName() " + nxsdFile);
        this._nxsdFileName = nxsdFile;
    }

    public void setRecordClassifierStart(int position) {
        this._debug("FFI setRecordClassifierStart() " + position);
        this._classifierStartPos = position;
    }

    public int getRecordClassifierStart() {
        return this._classifierStartPos;
    }

    public void setRecordClassifierEnd(int position) {
        this._classifierEndPos = position;
    }

    public int getRecordClassifierEnd() {
        return this._classifierEndPos;
    }

    public String getDisplayableData(String recordName) {
        String ret = "";
        Vector records = this.getLogicalRecords(recordName);
        Enumeration record_list = records.elements();
        if (record_list.hasMoreElements()) {
            ret = (String)record_list.nextElement();
            while (record_list.hasMoreElements()) {
                ret = ret + "\n";
                ret = ret + (String)record_list.nextElement();
            }
        }
        return ret;
    }

    public String getRecordData(String text) {
        String ret = "";
        Vector records = this.getLogicalRecords(null);
        Enumeration record_list = records.elements();
        while (record_list.hasMoreElements() && !(ret = (String)record_list.nextElement()).equals(text)) {
        }
        return ret;
    }

    public String getRecordSampleText(String record) {
        String ret = "";
        SortableTwoDModel recClassifiers = this.getRecordClassifierDs();
        for (int i = 0; i < recClassifiers.getRowCount(); ++i) {
            if (!recClassifiers.getData(2, i).equals(record)) continue;
            ret = (String)recClassifiers.getData(1, i);
        }
        return ret;
    }

    public String getFieldSampleText(String recname, int fieldNum) {
        try {
            ArrayTwoDModel data;
            ArrayTwoDModel fieldProps = this.getFieldPropertiesDs(recname);
            int startCol = (Integer)fieldProps.getData(4, fieldNum);
            int endCol = (Integer)fieldProps.getData(5, fieldNum);
            String sampleRecordText = this.getRecordSampleText(recname);
            RecTypeAttributes recAttr = this.getRecordAttributes(recname);
            if (recAttr != null && recAttr.isDelimited() && (data = this.getDelimitedColumnDataSource(sampleRecordText, recAttr.getDelimiter())) != null) {
                return (String)data.getData(fieldNum, 0);
            }
            if (endCol != 0) {
                return sampleRecordText.substring(startCol - 1, endCol);
            }
            return "";
        }
        catch (Exception e1) {
            return "";
        }
    }

    private Vector getLogicalRecords(String recordName) {
        this._debug("FFI getLogicalRecords() " + recordName);
        Vector logical_records = this.getLogicalRecords();
        if (this.isMultiRecord() && recordName != null && !this.isDelimitedFile()) {
            Vector classifier_values = this.getClassifierValues(recordName);
            this._maxReadRecSize = 0;
            for (int i = 0; i < logical_records.size(); ++i) {
                if (!this.recordClassifierMatches((String)logical_records.elementAt(i), classifier_values)) {
                    logical_records.removeElementAt(i);
                    --i;
                    continue;
                }
                this._maxReadRecSize = Math.max(((String)logical_records.elementAt(i)).length(), this._maxReadRecSize);
            }
        }
        return logical_records;
    }

    private boolean recordClassifierMatches(String record, Vector classifier_values) {
        if (record.length() >= this._classifierEndPos && this._classifierStartPos > 0 && this._classifierEndPos >= this._classifierStartPos) {
            String record_classifier_value = record.substring(this._classifierStartPos - 1, this._classifierEndPos);
            int idx = classifier_values.indexOf(record_classifier_value);
            return idx != -1;
        }
        return false;
    }

    private String readLine(BufferedReader in) throws IOException {
        if (this._isRecordSize && this._recordSize > 0) {
            char[] buffer = new char[this._recordSize];
            int num_read = in.read(buffer, 0, this._recordSize);
            if (num_read == -1) {
                return null;
            }
            return new String(buffer, 0, num_read);
        }
        if (!(this._recordTerminator.equalsIgnoreCase("<CR>") || this._recordTerminator.equals("\\n") || this._recordTerminator.equals("\\r\\n") || this._recordTerminator.equals(this._delimiter) && this._singleInstance)) {
            String term = this._recordTerminator;
            char[] buffer = new char[1];
            int num_read = in.read(buffer);
            if (num_read == -1) {
                return null;
            }
            String phys_record = new String(buffer);
            while ((num_read = in.read(buffer)) != -1) {
                if ((phys_record = phys_record + new String(buffer)).length() < this._recordTerminator.length() || !phys_record.endsWith(term)) continue;
                int ind = phys_record.indexOf(term);
                return phys_record.substring(0, ind);
            }
            return null;
        }
        return in.readLine();
    }

    private String readLogicalRecord(BufferedReader in) throws IOException {
        String line;
        if (this._nextLine != null) {
            line = this._nextLine;
            this._nextLine = null;
        } else {
            line = this.readLine(in);
        }
        if (line == null) {
            return null;
        }
        if (this._continueChars != null && this._continueChars.length() > 0) {
            int num_continue_chars = this._continueChars.length();
            if (this._continueThis) {
                while (line.endsWith(this._continueChars)) {
                    String next_line = this.readLine(in);
                    if (next_line == null) {
                        return line;
                    }
                    line = line + next_line;
                }
            } else {
                this._nextLine = this.readLine(in);
                while (this._nextLine != null && this._nextLine.startsWith(this._continueChars)) {
                    if (this._nextLine.length() > num_continue_chars) {
                        line = line + this._nextLine.substring(num_continue_chars);
                    }
                    this._nextLine = this.readLine(in);
                }
            }
        } else {
            String next_line;
            for (int i = 1; i < this._concatRows && (next_line = this.readLine(in)) != null; ++i) {
                line = line + next_line;
            }
        }
        return line;
    }

    private Vector getLogicalRecords() {
        this._debug("FFI getLogicalRecords() reading records now ");
        Vector<String> ret = new Vector<String>();
        try {
            BufferedReader in;
            if (this.isDTD()) {
                try {
                    DOMParser domparser = new DOMParser();
                    domparser.parseDTD((InputStream)new FileInputStream(this._fileName), null);
                    DTD dtd = domparser.getDoctype();
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    dtd.printExternalDTD(pw);
                    pw.flush();
                    pw.close();
                    BufferedReader br = new BufferedReader(new StringReader(sw.toString()));
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        ret.add(line);
                    }
                    br.close();
                    return ret;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            String coding = this._characterSet;
            if (this.getFlatFileWizard().getNxsdFileInfo()._connection == null) {
                FileInputStream in_stream = new FileInputStream(this._fileName);
                InputStreamReader r = new InputStreamReader((InputStream)in_stream, coding);
                in = new BufferedReader(r);
            } else {
                in = new BufferedReader(new StringReader(this.getAppsDTD().toString()));
            }
            this._nextLine = null;
            int curr_line = 1;
            this._maxReadRecSize = 0;
            String line = this.readLogicalRecord(in);
            String dispString = this.translate("FI_ffInfoDisplayableCharacter");
            if (this._sampleEverything) {
                this._sample = Integer.MAX_VALUE;
            }
            while (ret.size() < this._sample && line != null) {
                if (curr_line > this._skip) {
                    String dispLine = "";
                    if (!this.isDelimitedFile()) {
                        for (int i = 0; i < line.length(); ++i) {
                            if (Character.isISOControl(line.charAt(i))) {
                                if (line.charAt(i) == '\t') {
                                    dispLine = dispLine + "\\t";
                                    continue;
                                }
                                dispLine = dispLine + dispString;
                                continue;
                            }
                            if (this.isByteOrderMark(line.charAt(i))) continue;
                            dispLine = dispLine + line.charAt(i);
                        }
                        ret.addElement(dispLine);
                        if (this._maxReadRecSize < dispLine.length()) {
                            this._maxReadRecSize = dispLine.length();
                        }
                    } else {
                        ret.addElement(line);
                        if (this._maxReadRecSize < line.length()) {
                            this._maxReadRecSize = line.length();
                        }
                    }
                }
                line = this.readLogicalRecord(in);
                ++curr_line;
            }
            in.close();
        }
        catch (MalformedInputException e) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public String getFileText() {
        this._debug("FFI getLogicalRecords() reading records now ");
        StringBuffer sb = new StringBuffer();
        try {
            BufferedReader in;
            String coding = this._characterSet;
            if (this.getFlatFileWizard().getNxsdFileInfo()._connection == null) {
                FileInputStream in_stream = new FileInputStream(this._fileName);
                InputStreamReader r = new InputStreamReader((InputStream)in_stream, coding);
                in = new BufferedReader(r);
            } else {
                in = new BufferedReader(new StringReader(this.getAppsDTD().toString()));
            }
            this._nextLine = null;
            int curr_line = 1;
            this._maxReadRecSize = 0;
            String line = this.readLogicalRecord(in);
            String dispString = this.translate("FI_ffInfoDisplayableCharacter");
            if (this._sampleEverything) {
                this._sample = Integer.MAX_VALUE;
            }
            while (curr_line <= this._sample && line != null) {
                if (curr_line > this._skip) {
                    String dispLine = "";
                    if (!this.isDelimitedFile()) {
                        for (int i = 0; i < line.length(); ++i) {
                            if (Character.isISOControl(line.charAt(i))) {
                                if (line.charAt(i) == '\t') {
                                    dispLine = dispLine + "\\t";
                                    continue;
                                }
                                dispLine = dispLine + dispString;
                                continue;
                            }
                            dispLine = dispLine + line.charAt(i);
                        }
                        sb.append(dispLine);
                    } else {
                        sb.append(line);
                    }
                }
                sb.append("\n");
                if (this._maxReadRecSize < line.length()) {
                    this._maxReadRecSize = line.length();
                }
                line = this.readLogicalRecord(in);
                ++curr_line;
            }
            in.close();
        }
        catch (MalformedInputException e) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    public String getFileInputStream() {
        this._debug("FFI getLogicalRecords() reading records now ");
        StringBuffer sb = new StringBuffer();
        try {
            BufferedReader in;
            String coding = this._characterSet;
            if (this.getFlatFileWizard().getNxsdFileInfo()._connection == null) {
                FileInputStream in_stream = new FileInputStream(this._fileName);
                InputStreamReader r = new InputStreamReader((InputStream)in_stream, coding);
                in = new BufferedReader(r);
            } else {
                in = new BufferedReader(new StringReader(this.getAppsDTD().toString()));
            }
            this._nextLine = null;
            int curr_line = 1;
            this._maxReadRecSize = 0;
            String line = this.readLogicalRecord(in);
            String dispString = this.translate("FI_ffInfoDisplayableCharacter");
            if (this._sampleEverything) {
                this._sample = Integer.MAX_VALUE;
            }
            while (curr_line < this._sample && line != null) {
                if (curr_line > this._skip) {
                    String dispLine = "";
                    if (!this.isDelimitedFile()) {
                        for (int i = 0; i < line.length(); ++i) {
                            dispLine = Character.isISOControl(line.charAt(i)) ? dispLine + dispString : dispLine + line.charAt(i);
                        }
                        sb.append(dispLine);
                    } else {
                        sb.append(line);
                    }
                }
                if (this._maxReadRecSize < line.length()) {
                    this._maxReadRecSize = line.length();
                }
                line = this.readLogicalRecord(in);
                ++curr_line;
            }
            in.close();
        }
        catch (MalformedInputException e) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    private void addDataSetColumn(ArrayTwoDModel ds, int row, int col, Object value) {
        int num_cols;
        int num_rows = ds.getRowCount();
        if (row >= num_rows) {
            ds.addRows(num_rows, row - num_rows + 1);
        }
        if (col >= (num_cols = ds.getColumnCount())) {
            ds.addColumns(num_cols, col - num_cols + 1);
        }
        ds.setData(col, row, value);
    }

    private ArrayTwoDModel buildDelimitedColumns(Vector logicalRecords) {
        boolean ws_delim;
        String delimiter;
        this._debug("buildDelimitedColumns called");
        ArrayTwoDModel ret = new ArrayTwoDModel(0, 0);
        int row = 0;
        int col = 0;
        int state = 0;
        String token = "";
        if (this._delimiter.equals("\\t")) {
            delimiter = "\t";
            ws_delim = false;
        } else if (this._delimiter.length() > 1) {
            delimiter = " \t";
            ws_delim = true;
        } else {
            delimiter = this._delimiter;
            ws_delim = false;
        }
        int num_records = logicalRecords.size();
        for (int i = 0; i < num_records; ++i) {
            String record = (String)logicalRecords.elementAt(i);
            StringCharacterIterator iter = new StringCharacterIterator(record);
            if (state == 2) {
                state = 0;
            }
            char c = iter.first();
            while (c != '\uffff') {
                switch (state) {
                    case 0: {
                        if (this._isEnclosedLeft && c == this._leftEnclosure) {
                            state = 1;
                            break;
                        }
                        if (delimiter.indexOf(c) != -1) {
                            this.addDataSetColumn(ret, row, col, token);
                            ++col;
                            token = "";
                            if (!ws_delim) break;
                            state = 2;
                            break;
                        }
                        if (this.isByteOrderMark(c)) break;
                        token = token + c;
                        break;
                    }
                    case 1: {
                        if (this._isEnclosedRight && c == this._rightEnclosure || !this._isEnclosedRight && c == this._leftEnclosure) {
                            state = 0;
                            break;
                        }
                        if (this.isByteOrderMark(c)) break;
                        token = token + c;
                        break;
                    }
                    case 2: {
                        if (delimiter.indexOf(c) != -1) break;
                        if (this._isEnclosedLeft && c == this._leftEnclosure) {
                            state = 1;
                            token = "";
                            break;
                        }
                        state = 0;
                        if (this.isByteOrderMark(c)) break;
                        token = token + c;
                    }
                }
                c = iter.next();
            }
            if (state != 0) continue;
            if (token != null && !token.equals("")) {
                this.addDataSetColumn(ret, row, col, token);
            }
            ++row;
            col = 0;
            token = "";
        }
        if (state != 0) {
            this.addDataSetColumn(ret, row, col, token);
        }
        return ret;
    }

    private ArrayTwoDModel buildDelimitedColumns(Vector logicalRecords, String delimiter) {
        boolean ws_delim;
        this._debug("buildDelimitedColumns called");
        ArrayTwoDModel ret = new ArrayTwoDModel(0, 0);
        int row = 0;
        int col = 0;
        int state = 0;
        String token = "";
        if (delimiter.equals("\\t")) {
            delimiter = "\t";
            ws_delim = false;
        } else if (delimiter.length() > 1) {
            delimiter = " \t";
            ws_delim = true;
        } else {
            ws_delim = false;
        }
        int num_records = logicalRecords.size();
        for (int i = 0; i < num_records; ++i) {
            String record = (String)logicalRecords.elementAt(i);
            StringCharacterIterator iter = new StringCharacterIterator(record);
            if (state == 2) {
                state = 0;
            }
            char c = iter.first();
            while (c != '\uffff') {
                switch (state) {
                    case 0: {
                        if (this._isEnclosedLeft && c == this._leftEnclosure) {
                            state = 1;
                            break;
                        }
                        if (delimiter.indexOf(String.valueOf(c)) != -1) {
                            this.addDataSetColumn(ret, row, col, token);
                            ++col;
                            token = "";
                            if (!ws_delim) break;
                            state = 2;
                            break;
                        }
                        if (this.isByteOrderMark(c)) break;
                        token = token + c;
                        break;
                    }
                    case 1: {
                        if (this._isEnclosedRight && c == this._rightEnclosure || !this._isEnclosedRight && c == this._leftEnclosure) {
                            state = 0;
                            break;
                        }
                        if (this.isByteOrderMark(c)) break;
                        token = token + c;
                        break;
                    }
                    case 2: {
                        if (delimiter.indexOf(String.valueOf(c)) != -1) break;
                        if (this._isEnclosedLeft && c == this._leftEnclosure) {
                            state = 1;
                            token = "";
                            break;
                        }
                        state = 0;
                        if (this.isByteOrderMark(c)) break;
                        token = token + c;
                    }
                }
                c = iter.next();
            }
            if (state != 0) continue;
            if (token != null && !token.equals("")) {
                this.addDataSetColumn(ret, row, col, token);
            }
            ++row;
            col = 0;
            token = "";
        }
        if (state != 0) {
            this.addDataSetColumn(ret, row, col, token);
        }
        return ret;
    }

    public int[] getColumnWidths(TwoDModel ds) {
        int num_cols = ds.getColumnCount();
        int[] field_widths = new int[num_cols];
        for (int i = 0; i < num_cols; ++i) {
            field_widths[i] = 0;
        }
        int num_rows = ds.getRowCount();
        for (int row = 0; row < num_rows; ++row) {
            for (int col = 0; col < num_cols; ++col) {
                int length;
                String value = (String)ds.getData(col, row);
                if (value == null || (length = value.length()) <= field_widths[col]) continue;
                field_widths[col] = length;
            }
        }
        return field_widths;
    }

    public ArrayTwoDModel getFormattedColumnDataSource(String recordName) {
        ArrayTwoDModel ret;
        block17: {
            int i;
            Vector logical_records;
            block16: {
                this._debug("FFI getFormattedColumnDataSource() recordName: " + recordName);
                logical_records = this.getLogicalRecords(recordName);
                if (!this.isEditingNXSD() && this._newFilePicked && (recordName == null || recordName.equalsIgnoreCase(this.getFileStructureName())) && logical_records.size() == 1 && !this._useFirstRowAsFieldNames) {
                    this.isSingleInstance(true);
                    this._newFilePicked = false;
                }
                if (!this._isDelimitedFile) break block16;
                ret = this.buildDelimitedColumns(logical_records);
                int num_rows = ret.getRowCount();
                if (recordName == null || recordName.equalsIgnoreCase(this.getFileStructureName())) break block17;
                Vector classifier_values = this.getClassifierValues(recordName);
                int classifier_idx = this.getRecordClassifierStart() - 1;
                if (classifier_idx >= 0) {
                    for (int i2 = 0; i2 < num_rows; ++i2) {
                        String column_value = (String)ret.getData(classifier_idx, i2);
                        if (classifier_values.indexOf(column_value) != -1) continue;
                        ret.removeRows(i2, 1);
                        --i2;
                        --num_rows;
                    }
                }
                int num_cols = ret.getColumnCount();
                int max_cols = 0;
                block1: for (int i3 = 0; i3 < num_rows && num_cols != max_cols; ++i3) {
                    for (int j = num_cols - 1; j >= 0; --j) {
                        if (ret.getData(j, i3) == null) continue;
                        if (j < max_cols) continue block1;
                        max_cols = j;
                        continue block1;
                    }
                }
                if (max_cols + 1 == num_cols) break block17;
                ret.removeColumns(max_cols + 1, num_cols - max_cols - 1);
                break block17;
            }
            int[] marks = this.getColumnMarkers(recordName);
            int num_fields = marks.length;
            int max_log_record_length = 0;
            int num_records = logical_records.size();
            for (i = 0; i < num_records; ++i) {
                if (max_log_record_length >= ((String)logical_records.elementAt(i)).length()) continue;
                max_log_record_length = ((String)logical_records.elementAt(i)).length();
            }
            if (!this.isComplexFile()) {
                if (num_fields == 0 || marks[marks.length - 1] < max_log_record_length) {
                    ++num_fields;
                }
            } else if (num_fields == 0) {
                ++num_fields;
            }
            ret = new ArrayTwoDModel(num_fields, num_records);
            for (i = 0; i < num_records; ++i) {
                String record = (String)logical_records.elementAt(i);
                String value = "";
                int field_begin_pos = 0;
                for (int col = 0; col < num_fields; ++col) {
                    int field_end_pos = -1;
                    if (marks.length == 0 || marks.length != num_fields) {
                        value = record;
                    } else {
                        int n = field_end_pos = col < marks.length ? marks[col] : max_log_record_length;
                        value = field_begin_pos < record.length() ? (field_end_pos > record.length() ? record.substring(field_begin_pos) : record.substring(field_begin_pos, field_end_pos)) : "";
                    }
                    if (this.isDTD()) {
                        ret.setData(col, i, (Object)record);
                    } else {
                        ret.setData(col, i, (Object)value);
                    }
                    field_begin_pos = field_end_pos;
                }
            }
        }
        return ret;
    }

    public ArrayTwoDModel getComplexFormattedColumnDataSource(String recordName, String sampleText) {
        this._debug("FFI getFormattedColumnDataSource() recordName: " + recordName);
        if (!this.isEditingNXSD() && this._newFilePicked) {
            this._newFilePicked = false;
        }
        int[] marks = this.getColumnMarkers(recordName);
        int num_fields = marks.length;
        int max_log_record_length = sampleText.length();
        if (this.isComplexFile() && num_fields == 0) {
            ++num_fields;
        }
        ArrayTwoDModel ret = new ArrayTwoDModel(num_fields, 1);
        String record = sampleText;
        String value = null;
        int field_begin_pos = 0;
        for (int col = 0; col < num_fields; ++col) {
            int field_end_pos = -1;
            if (marks.length == 0 || marks.length != num_fields) {
                value = record;
            } else {
                int n = field_end_pos = col < marks.length ? marks[col] : max_log_record_length;
                value = field_begin_pos < record.length() ? (field_end_pos > record.length() ? record.substring(field_begin_pos) : record.substring(field_begin_pos, field_end_pos)) : "";
            }
            ret.setData(col, 0, (Object)value);
            field_begin_pos = field_end_pos;
        }
        return ret;
    }

    public ArrayTwoDModel getDelimitedColumnDataSource(String record, String delimiter) {
        this._debug("FFI getFormattedColumnDataSource() recordName: " + record);
        Vector<String> logical_records = new Vector<String>();
        logical_records.add(record);
        ArrayTwoDModel ret = this.buildDelimitedColumns(logical_records, delimiter);
        int num_rows = ret.getRowCount();
        if (record != null && !record.equalsIgnoreCase(this.getFileStructureName())) {
            int num_cols = ret.getColumnCount();
            int max_cols = 0;
            block0: for (int i = 0; i < num_rows && num_cols != max_cols; ++i) {
                for (int j = num_cols - 1; j >= 0; --j) {
                    if (ret.getData(j, i) == null) continue;
                    if (j < max_cols) continue block0;
                    max_cols = j;
                    continue block0;
                }
            }
            if (max_cols + 1 != num_cols) {
                ret.removeColumns(max_cols + 1, num_cols - max_cols - 1);
            }
        }
        return ret;
    }

    public void setColumnStartPositions(String recordName, int[] positions) {
        int field_count;
        this._debug("FFI setColumnStartPositions() recordName: " + recordName);
        Sort.qSort((int[])positions, (int)positions.length, (boolean)true);
        int record_length = this._recordSize;
        if (record_length <= 0 || this._isRecordSize && this._enableLogicalRecords) {
            record_length = this._maxReadRecSize;
        }
        if (positions.length == 0) {
            field_count = record_length == 0 ? 0 : 1;
        } else {
            if (this._isRecordSize) {
                for (field_count = positions.length; field_count > 0 && positions[field_count - 1] > record_length; --field_count) {
                }
            }
            if (field_count == 0 || positions[field_count - 1] < record_length) {
                ++field_count;
            }
        }
        ArrayTwoDModel field_props = this._isComplexFile ? new ArrayTwoDModel(this.getComplexFieldPropertiesInfo().length, field_count) : new ArrayTwoDModel(this.getFieldPropertiesInfo().length, field_count);
        int start_col = 1;
        for (int i = 0; i < field_count && i < positions.length; ++i) {
            int end_col = positions[i];
            field_props.setData(4, i, (Object)new Integer(start_col));
            field_props.setData(5, i, (Object)new Integer(end_col));
            field_props.setData(3, i, (Object)new Integer(end_col - start_col + 1));
            start_col = end_col + 1;
        }
        if (start_col <= record_length) {
            field_props.setData(4, field_count - 1, (Object)new Integer(start_col));
            field_props.setData(5, field_count - 1, (Object)new Integer(record_length));
            field_props.setData(3, field_count - 1, (Object)new Integer(record_length - start_col + 1));
        }
        this.setFieldPropertiesDs(recordName, field_props);
        this.initFieldPropertiesDs(field_props, recordName);
    }

    public int[] getColumnMarkers(String recordName) {
        this._debug("getColumnMarkers(" + recordName + ")");
        ArrayTwoDModel fields_ds = this.getFieldPropertiesDs(recordName);
        int num_fields = fields_ds.getRowCount();
        if (num_fields == 0) {
            fields_ds.addRows(0, 1);
            return new int[0];
        }
        if (num_fields == 1) {
            if (Integer.parseInt("" + fields_ds.getData(4, 0)) == 1 && Integer.parseInt("" + fields_ds.getData(3, 0)) == 1 && Integer.parseInt("" + fields_ds.getData(5, 0)) == 1) {
                return new int[0];
            }
            this.getLogicalRecords(recordName);
            if (this._maxReadRecSize >= Integer.parseInt("" + fields_ds.getData(5, 0))) {
                if (this._maxReadRecSize == 0) {
                    return new int[0];
                }
                int[] ret = new int[]{this._maxReadRecSize};
                return ret;
            }
        }
        int[] ret = new int[num_fields];
        for (int col = 0; col < num_fields; ++col) {
            ret[col] = Integer.parseInt("" + fields_ds.getData(5, col));
        }
        if (num_fields > 1) {
            Sort.qSort((int[])ret, (int)(num_fields - 1), (boolean)true);
        }
        return ret;
    }

    public String[] getUniqueValues(int columnNumber) {
        this._debug("FFI getUniqueValues() columnNumber : " + columnNumber);
        ArrayTwoDModel records = this.getFormattedColumnDataSource(null);
        Vector<String> unique_values = new Vector<String>();
        if (columnNumber > 0 && columnNumber <= records.getColumnCount()) {
            int column_idx = columnNumber - 1;
            int num_rows = records.getRowCount();
            for (int i = 0; i < num_rows; ++i) {
                String value = (String)records.getData(column_idx, i);
                if (unique_values.contains(value)) continue;
                unique_values.addElement(value);
            }
        }
        Object[] value_list = new String[unique_values.size()];
        unique_values.copyInto(value_list);
        return value_list;
    }

    public String[] getUniqueValues(int startColumn, int endColumn) {
        this._debug("FFI getUniqueValues() startColumn: " + startColumn + " endColumn " + endColumn);
        Vector records = this.getLogicalRecords(null);
        int num_rows = records.size();
        Vector<String> unique_values = new Vector<String>();
        for (int i = 0; i < num_rows; ++i) {
            String record = (String)records.elementAt(i);
            try {
                String value = record.substring(startColumn, endColumn);
                if (value.length() <= 0 || unique_values.contains(value)) continue;
                unique_values.addElement(value);
                continue;
            }
            catch (StringIndexOutOfBoundsException e) {
                // empty catch block
            }
        }
        Object[] value_list = new String[unique_values.size()];
        unique_values.copyInto(value_list);
        return value_list;
    }

    public void setSampleRecords(int sampleRecords) {
        this._debug("FFI setSampleRecords() sampleRecords : " + sampleRecords);
        this._sample = sampleRecords;
    }

    public int getSampleRecords() {
        return this._sample;
    }

    public void setSkipRecords(int skipRecords) {
        this._debug("FFI setSkipRecords() skipRecords : " + skipRecords);
        this._skip = skipRecords;
        if (this._skip < 0) {
            this._skip = 0;
        }
    }

    public int getSkipRecords() {
        return this._skip;
    }

    public boolean isRecordSize() {
        return this._isRecordSize;
    }

    public void isRecordSize(boolean value) {
        this._isRecordSize = value;
    }

    public void setRecordSize(int recordSize) {
        this._recordSize = recordSize;
        if (this._isRecordSize && recordSize != 0) {
            this._recordTerminator = "";
        }
    }

    public int getRecordSize() {
        return this._recordSize;
    }

    public int getRecordsToProcessRemain() {
        return this._recordsToProcessRemain;
    }

    public void setRecordsToProcessRemain(int recordsRemain) {
        this._recordsToProcessRemain = recordsRemain;
    }

    public void setRecordTerminator(String recordTerm) {
        if (recordTerm != null && recordTerm.equals("<CR>")) {
            recordTerm = "\\r\\n";
        } else if (recordTerm != null && recordTerm.equals("newline")) {
            recordTerm = System.getProperty("line.separator");
        }
        this._recordTerminator = recordTerm;
        if (recordTerm != null && recordTerm.equals("")) {
            this.setRecordSize(0);
            this.isRecordSize(false);
        }
    }

    public String getRecordTerminator() {
        return this._recordTerminator;
    }

    public boolean isMultiRecord() {
        return this._isMultiRecordFile;
    }

    public void isMultiRecord(boolean value) {
        if (this._isMultiRecordFile != value) {
            this._isMultiRecordFile = value;
            this._recordClassifierDs = null;
            if (this._fieldPropertiesHash != null) {
                this._fieldPropertiesHash.clear();
            }
            this.setChanged();
            this.notifyObservers();
        }
    }

    public boolean isEnableLogicalRecords() {
        return this._enableLogicalRecords;
    }

    public void isEnableLogicalRecords(boolean value) {
        this._enableLogicalRecords = value;
        this.setChanged();
        this.notifyObservers();
    }

    public void isFixedNumToConcatenate(boolean value) {
        this._isFixedNumToConcat = value;
    }

    public boolean isFixedNumToConcatenate() {
        return this._isFixedNumToConcat;
    }

    public void setConcatRows(int numberOfRows) {
        if (this._isFixedNumToConcat) {
            this._concatRows = numberOfRows;
            this._continueChars = "";
        }
    }

    public int getConcatRows() {
        return this._concatRows;
    }

    public void continueThis(boolean value) {
        this._continueThis = value;
    }

    public boolean continueThis() {
        return this._continueThis;
    }

    public void setContinueCharacters(String value, boolean onCurrentRow) {
        this._continueChars = value;
        this._continueThis = onCurrentRow;
        this._concatRows = 1;
    }

    public String getContinueCharacters() {
        return this._continueChars;
    }

    public OneDModel getColumnHeaderDataSource(String recordName) {
        ArrayTwoDModel field_props = this.getFieldPropertiesDs(recordName);
        return new columnHdrDs((TwoDModel)field_props, 1);
    }

    public OneDModel getDelimitedColumnHeaderDataSource(String text, String delimiter) {
        ArrayTwoDModel field_props = new ArrayTwoDModel(this.getFieldPropertiesInfo().length, 0);
        ArrayTwoDModel data = this.getDelimitedColumnDataSource(text, delimiter);
        int fieldCount = data.getColumnCount();
        int rowCount = field_props.getRowCount();
        if (rowCount < fieldCount) {
            field_props.addRows(rowCount, fieldCount - rowCount);
        }
        if (rowCount > fieldCount) {
            field_props.removeRows(fieldCount, rowCount - fieldCount);
        }
        try {
            for (int i = 0; i < fieldCount; ++i) {
                String testData = (String)field_props.getData(1, i);
                if (testData != null) continue;
                testData = this.translate("FI_ffInfoPrefixForGeneratedColNames") + (i + 1);
                field_props.setData(1, i, (Object)testData);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return new columnHdrDs((TwoDModel)field_props, 1);
    }

    public String[] getRecordList() {
        TreeMap recordNameMap = this.getRecordNameMap();
        String[] records = new String[recordNameMap.size()];
        recordNameMap.values().toArray(records);
        return records;
    }

    protected TreeMap getRecordNameMap() {
        TreeMap<String, String> recordNameMap = new TreeMap<String, String>();
        if (this._recordClassifierDs != null && this._recordClassifierDs.getRowCount() > 0) {
            try {
                this._recordClassifierDs.sort(2, true);
            }
            catch (Exception e) {
                // empty catch block
            }
            int rowCount = this._recordClassifierDs.getRowCount();
            String lastRecordName = "";
            String recordName = "";
            String persistedRecordName = "";
            for (int i = 0; i < rowCount; ++i) {
                String currentRenameCandidate;
                recordName = (String)this._recordClassifierDs.getData(2, i);
                persistedRecordName = (String)this._recordClassifierDs.getData(3, i);
                if (recordName.equals(lastRecordName) || this._recordClassifierDs.getData(1, i) == null) continue;
                if (persistedRecordName == null) {
                    persistedRecordName = recordName;
                }
                if ((currentRenameCandidate = (String)recordNameMap.get(persistedRecordName)) == null) {
                    recordNameMap.put(persistedRecordName, recordName);
                } else if (!currentRenameCandidate.equals(recordName)) {
                    if (currentRenameCandidate.equals(persistedRecordName)) {
                        recordNameMap.put(recordName, recordName);
                    } else if (persistedRecordName.equals(recordName)) {
                        recordNameMap.put(currentRenameCandidate, currentRenameCandidate);
                        recordNameMap.put(persistedRecordName, persistedRecordName);
                    } else {
                        recordNameMap.put(recordName, recordName);
                    }
                }
                lastRecordName = recordName;
            }
        } else {
            String newRecordName;
            String oldRecordName = newRecordName = this.getFileStructureName();
            recordNameMap.put(oldRecordName, newRecordName);
        }
        return recordNameMap;
    }

    public Vector getClassifierValues(String recordName) {
        Vector<String> classifiers = new Vector<String>();
        if (recordName == null) {
            recordName = this.getFileStructureName();
        }
        if (recordName != null) {
            SortableTwoDModel record_classifier_ds = this.getRecordClassifierDs();
            int row_count = record_classifier_ds.getRowCount();
            for (int i = 0; i < row_count; ++i) {
                String classifier_value;
                if (!recordName.equals((String)record_classifier_ds.getData(2, i)) || (classifier_value = (String)record_classifier_ds.getData(1, i)) == null) continue;
                classifiers.addElement(classifier_value);
            }
        }
        return classifiers;
    }

    public SortableTwoDModel getRecordClassifierDs() {
        if (this._recordClassifierDs == null) {
            this._recordClassifierDs = new RecordClassifierDs(this, 4, 0);
        }
        return this._recordClassifierDs;
    }

    public void copyRecordClassifierDs(ArrayTwoDModel model) {
        int dsRowCount;
        SortableTwoDModel recordClassifierDs = this.getRecordClassifierDs();
        int modelRowCount = model.getRowCount();
        if (modelRowCount < (dsRowCount = recordClassifierDs.getRowCount())) {
            model.addRows(0, dsRowCount - modelRowCount);
        }
        if (modelRowCount > dsRowCount) {
            model.removeRows(0, modelRowCount - dsRowCount);
        }
        for (int i = 0; i < dsRowCount; ++i) {
            for (int j = 1; j < 4; ++j) {
                model.setData(j - 1, i, recordClassifierDs.getData(j, i));
            }
        }
    }

    public SortableTwoDModel cloneRecordClassifierDs(SortableTwoDModel model) {
        RecordClassifierDs clonedRecordClassifierDs = new RecordClassifierDs(this, 4, 0);
        int modelRowCount = model.getRowCount();
        clonedRecordClassifierDs.addRows(0, modelRowCount);
        for (int i = 0; i < modelRowCount; ++i) {
            for (int j = 1; j < 4; ++j) {
                clonedRecordClassifierDs.setData(j, i, model.getData(j, i));
            }
        }
        return clonedRecordClassifierDs;
    }

    public void setRecordClassifierDs(SortableTwoDModel recordClassifierDs) {
        this._recordClassifierDs = recordClassifierDs;
    }

    public void addIntoRecordClassifierDs(SortableTwoDModel model) {
        if (this._recordClassifierDs == null) {
            this.setRecordClassifierDs(model);
        } else {
            int dsrowcount = this._recordClassifierDs.getRowCount();
            int newrowcount = model.getRowCount();
            this._recordClassifierDs.addRows(dsrowcount, newrowcount);
            for (int i = 0; i < newrowcount; ++i) {
                for (int j = 1; j < model.getColumnCount(); ++j) {
                    Object o = model.getData(j, i);
                    this._recordClassifierDs.setData(j, dsrowcount + i, o);
                }
            }
        }
    }

    public void removeFromRecordClassifierDs(String recordname) {
        if (this._recordClassifierDs != null) {
            int dsrowcount = this._recordClassifierDs.getRowCount();
            for (int i = 0; i < dsrowcount; ++i) {
                String recname = (String)this._recordClassifierDs.getData(2, i);
                if (!recname.equals(recordname)) continue;
                this._recordClassifierDs.removeRows(i, 1);
                break;
            }
        }
    }

    public void setRecordClassifierDs(TwoDModel model) {
        SortableTwoDModel recordClassifierDs = new SortableTwoDModel(4, model.getRowCount());
        for (int i = 0; i < model.getRowCount(); ++i) {
            for (int j = 0; j < 3; ++j) {
                recordClassifierDs.setData(j + 1, i, model.getData(j, i));
            }
        }
        this._recordClassifierDs = recordClassifierDs;
    }

    public ColumnInfo[] getFieldPropertiesInfo() {
        ColumnInfo[] rawFieldPropertiesInfo = this.getRawFieldPropertiesInfo();
        ColumnInfo[] fieldPropertiesInfo = new ColumnInfo[7];
        fieldPropertiesInfo[1] = rawFieldPropertiesInfo[0];
        fieldPropertiesInfo[2] = rawFieldPropertiesInfo[1];
        fieldPropertiesInfo[3] = rawFieldPropertiesInfo[2];
        fieldPropertiesInfo[4] = rawFieldPropertiesInfo[3];
        fieldPropertiesInfo[5] = rawFieldPropertiesInfo[4];
        fieldPropertiesInfo[6] = rawFieldPropertiesInfo[5];
        fieldPropertiesInfo[5].setVisible(false);
        fieldPropertiesInfo[5].setEditable(false);
        if (this._isComplexFile) {
            fieldPropertiesInfo[6].setVisible(false);
        }
        fieldPropertiesInfo[4].setVisible(false);
        fieldPropertiesInfo[4].setEditable(false);
        ((ComboBoxInputHandler)fieldPropertiesInfo[6].getInputHandler()).setEditable(true);
        return fieldPropertiesInfo;
    }

    public ColumnInfo[] getComplexFieldPropertiesInfo() {
        ColumnInfo[] rawFieldPropertiesInfo = this.getComplexRawFieldPropertiesInfo();
        ColumnInfo[] fieldPropertiesInfo = new ColumnInfo[]{rawFieldPropertiesInfo[0], rawFieldPropertiesInfo[1], rawFieldPropertiesInfo[2], rawFieldPropertiesInfo[3], rawFieldPropertiesInfo[4], rawFieldPropertiesInfo[5], rawFieldPropertiesInfo[6], rawFieldPropertiesInfo[7], rawFieldPropertiesInfo[8], rawFieldPropertiesInfo[9], rawFieldPropertiesInfo[10], rawFieldPropertiesInfo[11], rawFieldPropertiesInfo[12], rawFieldPropertiesInfo[13], rawFieldPropertiesInfo[14], rawFieldPropertiesInfo[15], rawFieldPropertiesInfo[16], rawFieldPropertiesInfo[17], rawFieldPropertiesInfo[18], rawFieldPropertiesInfo[19], rawFieldPropertiesInfo[20], rawFieldPropertiesInfo[21], rawFieldPropertiesInfo[22], rawFieldPropertiesInfo[23], rawFieldPropertiesInfo[24], rawFieldPropertiesInfo[25], rawFieldPropertiesInfo[26], rawFieldPropertiesInfo[27], rawFieldPropertiesInfo[28], rawFieldPropertiesInfo[29], rawFieldPropertiesInfo[30], rawFieldPropertiesInfo[31], rawFieldPropertiesInfo[32], rawFieldPropertiesInfo[33], rawFieldPropertiesInfo[34]};
        fieldPropertiesInfo[0].setVisible(false);
        fieldPropertiesInfo[3].setVisible(false);
        fieldPropertiesInfo[5].setVisible(false);
        fieldPropertiesInfo[5].setEditable(false);
        fieldPropertiesInfo[12].setVisible(false);
        fieldPropertiesInfo[12].setEditable(false);
        fieldPropertiesInfo[8].setVisible(false);
        fieldPropertiesInfo[10].setVisible(false);
        fieldPropertiesInfo[11].setVisible(false);
        fieldPropertiesInfo[9].setVisible(false);
        fieldPropertiesInfo[13].setVisible(false);
        fieldPropertiesInfo[15].setVisible(false);
        fieldPropertiesInfo[16].setVisible(false);
        fieldPropertiesInfo[17].setVisible(false);
        fieldPropertiesInfo[18].setVisible(false);
        fieldPropertiesInfo[19].setVisible(false);
        fieldPropertiesInfo[20].setVisible(false);
        fieldPropertiesInfo[21].setVisible(false);
        fieldPropertiesInfo[22].setVisible(false);
        fieldPropertiesInfo[23].setVisible(false);
        fieldPropertiesInfo[24].setVisible(false);
        fieldPropertiesInfo[25].setVisible(false);
        fieldPropertiesInfo[26].setVisible(false);
        fieldPropertiesInfo[27].setVisible(false);
        fieldPropertiesInfo[28].setVisible(false);
        fieldPropertiesInfo[29].setVisible(false);
        fieldPropertiesInfo[30].setVisible(false);
        fieldPropertiesInfo[31].setVisible(false);
        fieldPropertiesInfo[32].setVisible(false);
        fieldPropertiesInfo[33].setVisible(false);
        fieldPropertiesInfo[34].setVisible(false);
        if (this._isComplexFile) {
            fieldPropertiesInfo[6].setVisible(false);
        }
        fieldPropertiesInfo[4].setVisible(false);
        fieldPropertiesInfo[4].setEditable(false);
        return fieldPropertiesInfo;
    }

    private ColumnInfo[] getRawFieldPropertiesInfo() {
        this.initRawFieldPropertiesInfo();
        Object[] rawFieldPropertiesInfo = new ColumnInfo[this._rawFieldPropertiesInfo.size()];
        this._rawFieldPropertiesInfo.copyInto(rawFieldPropertiesInfo);
        return rawFieldPropertiesInfo;
    }

    private ColumnInfo[] getComplexRawFieldPropertiesInfo() {
        this.initComplexRawFieldPropertiesInfo();
        Object[] rawFieldPropertiesInfo = new ColumnInfo[this._rawFieldPropertiesInfo.size()];
        this._rawFieldPropertiesInfo.copyInto(rawFieldPropertiesInfo);
        return rawFieldPropertiesInfo;
    }

    private void initRawFieldPropertiesInfo() {
        this._rawFieldPropertiesInfo = new Vector(7);
        int maxSize = 0;
        maxSize = 1000;
        ColumnInfo colInfo = new StringColumnInfo(this.translate("FI_propsFieldName_FlatFile"), -999, 0);
        this._rawFieldPropertiesInfo.addElement(colInfo);
        DebugUtility.debug("FFI: initRawFieldPropertiesInfo ");
        colInfo = new ChoiceColumnInfo(this.translate("FI_propsFieldType_FlatFile"), -999, _xmlDataTypes);
        this._rawFieldPropertiesInfo.addElement(colInfo);
        maxSize = 0;
        colInfo = new IntColumnInfo(this.translate("FI_propsFieldLength_FlatFile"), -999, 1, Integer.MAX_VALUE);
        this._rawFieldPropertiesInfo.addElement(colInfo);
        maxSize = 0;
        colInfo = new IntColumnInfo(this.translate("FI_propsFieldStart_FlatFile"), -999, 1, Integer.MAX_VALUE);
        this._rawFieldPropertiesInfo.addElement(colInfo);
        colInfo = new IntColumnInfo(this.translate("FI_propsFieldEnd_FlatFile"), -999, 1, Integer.MAX_VALUE);
        this._rawFieldPropertiesInfo.addElement(colInfo);
        colInfo = new ChoiceColumnInfo(this.translate("FI_propsDelimiter_FlatFile"), -999, _delimiterInitialList);
        this._rawFieldPropertiesInfo.addElement(colInfo);
    }

    private void initComplexRawFieldPropertiesInfo() {
        this._rawFieldPropertiesInfo = new Vector(35);
        int maxSize = 0;
        maxSize = 1000;
        ColumnInfo colInfo = new BooleanColumnInfo(this.translate("CX_FieldLabel_CondField"), -999, 0);
        this._rawFieldPropertiesInfo.addElement(colInfo);
        colInfo = new StringColumnInfo(this.translate("FI_propsFieldName_FlatFile"), -999, 0);
        this._rawFieldPropertiesInfo.addElement(colInfo);
        DebugUtility.debug("FFI: initRawFieldPropertiesInfo ");
        colInfo = new ChoiceColumnInfo(this.translate("FI_propsFieldType_FlatFile"), -999, _xmlDataTypes);
        this._rawFieldPropertiesInfo.addElement(colInfo);
        maxSize = 0;
        colInfo = new IntColumnInfo(this.translate("FI_propsFieldLength_FlatFile"), -999, 1, Integer.MAX_VALUE);
        this._rawFieldPropertiesInfo.addElement(colInfo);
        maxSize = 0;
        colInfo = new IntColumnInfo(this.translate("FI_propsFieldStart_FlatFile"), -999, 1, Integer.MAX_VALUE);
        this._rawFieldPropertiesInfo.addElement(colInfo);
        colInfo = new IntColumnInfo(this.translate("FI_propsFieldEnd_FlatFile"), -999, 1, Integer.MAX_VALUE);
        this._rawFieldPropertiesInfo.addElement(colInfo);
        colInfo = new ChoiceColumnInfo(this.translate("FI_propsDelimiter_FlatFile"), -999, _delimiterInitialList);
        this._rawFieldPropertiesInfo.addElement(colInfo);
        colInfo = new ChoiceColumnInfo(this.translate("CX_FieldLabel_Style"), -999, _styleList);
        this._rawFieldPropertiesInfo.addElement(colInfo);
        colInfo = new StringColumnInfo(this.translate("CX_FieldLabel_StylePattern1"), 10, maxSize);
        this._rawFieldPropertiesInfo.addElement(colInfo);
        colInfo = new StringColumnInfo(this.translate("CX_FieldLabel_StylePattern1"), 10, maxSize);
        this._rawFieldPropertiesInfo.addElement(colInfo);
        colInfo = new ChoiceColumnInfo(this.translate("CX_FieldLabel_PadStyle"), -999, _padStyleList);
        this._rawFieldPropertiesInfo.addElement(colInfo);
        colInfo = new StringColumnInfo(this.translate("CX_FieldLabel_Padding"), 7, maxSize);
        this._rawFieldPropertiesInfo.addElement(colInfo);
        colInfo = new StringColumnInfo(this.translate("CX_FieldLabel_CondValue"), -999, 0);
        this._rawFieldPropertiesInfo.addElement(colInfo);
        colInfo = new StringColumnInfo(this.translate("CX_FieldLabel_Default"), -999, 0);
        this._rawFieldPropertiesInfo.addElement(colInfo);
        colInfo = new ColumnInfo("  ", -999);
        this._rawFieldPropertiesInfo.addElement(colInfo);
        colInfo = new StringColumnInfo(this.translate("CX_FieldLabel_StartsWith"), -999, 0);
        this._rawFieldPropertiesInfo.addElement(colInfo);
        colInfo = new StringColumnInfo(this.translate("CX_FieldLabel_MinOccurs"), -999, 0);
        this._rawFieldPropertiesInfo.addElement(colInfo);
        colInfo = new StringColumnInfo(this.translate("CX_FieldLabel_MaxOccurs"), -999, 0);
        this._rawFieldPropertiesInfo.addElement(colInfo);
        colInfo = new StringColumnInfo(this.translate("CX_FieldLabel_Prefix"), -999, 0);
        this._rawFieldPropertiesInfo.addElement(colInfo);
        colInfo = new StringColumnInfo(this.translate("CX_FieldLabel_Suffix"), -999, 0);
        this._rawFieldPropertiesInfo.addElement(colInfo);
        colInfo = new StringColumnInfo(this.translate("CX_FieldLabel_LookAhead"), -999, 0);
        this._rawFieldPropertiesInfo.addElement(colInfo);
        colInfo = new StringColumnInfo(this.translate("CX_FieldLabel_LookFor"), -999, 0);
        this._rawFieldPropertiesInfo.addElement(colInfo);
        colInfo = new StringColumnInfo(this.translate("CX_FieldLabel_LengthStyle"), -999, 0);
        this._rawFieldPropertiesInfo.addElement(colInfo);
        colInfo = new BooleanColumnInfo(this.translate("CX_FieldLabel_Array"), -999, 0);
        this._rawFieldPropertiesInfo.addElement(colInfo);
        colInfo = new StringColumnInfo(this.translate("CX_FieldLabel_ArrayLength"), -999, 0);
        this._rawFieldPropertiesInfo.addElement(colInfo);
        colInfo = new StringColumnInfo(this.translate("CX_FieldLabel_ArraySep"), -999, 0);
        this._rawFieldPropertiesInfo.addElement(colInfo);
        colInfo = new StringColumnInfo(this.translate("CX_FieldLabel_CellSep"), -999, 0);
        this._rawFieldPropertiesInfo.addElement(colInfo);
        colInfo = new StringColumnInfo(this.translate("CX_FieldLabel_DateFormat"), -999, 0);
        this._rawFieldPropertiesInfo.addElement(colInfo);
        colInfo = new StringColumnInfo(this.translate("CX_FieldLabel_QuotedBy"), -999, 0);
        this._rawFieldPropertiesInfo.addElement(colInfo);
        colInfo = new BooleanColumnInfo(this.translate("CX_FieldLabel_List"), -999, 0);
        this._rawFieldPropertiesInfo.addElement(colInfo);
        colInfo = new StringColumnInfo(this.translate("CX_FieldLabel_ListSep"), -999, 0);
        this._rawFieldPropertiesInfo.addElement(colInfo);
        colInfo = new StringColumnInfo(this.translate("CX_FieldLabel_ItemSep"), -999, 0);
        this._rawFieldPropertiesInfo.addElement(colInfo);
        colInfo = new StringColumnInfo(this.translate("CX_FieldLabel_SkipMode"), -999, 0);
        this._rawFieldPropertiesInfo.addElement(colInfo);
        colInfo = new StringColumnInfo(this.translate("CX_FieldLabel_Skip"), -999, 0);
        this._rawFieldPropertiesInfo.addElement(colInfo);
        colInfo = new StringColumnInfo(this.translate("CX_FieldLabel_SkipUntil"), -999, 0);
        this._rawFieldPropertiesInfo.addElement(colInfo);
    }

    public boolean useFirstRowAsFieldNames() {
        return this._useFirstRowAsFieldNames;
    }

    public void useFirstRowAsFieldNames(boolean value) {
        this._useFirstRowAsFieldNames = value;
        ArrayTwoDModel fields = this.getFieldPropertiesDs(null);
        int num_fields = fields.getRowCount();
        int row_count = 0;
        boolean len = false;
        String orig_name = "";
        String name = "";
        this._debug("useFirstRowAsFieldNames.num_fields = " + num_fields);
        ArrayTwoDModel data = this.getFormattedColumnDataSource(null);
        this._debug("useFirstRowAsFieldNames.data count = " + data.getRowCount());
        row_count = data.getRowCount();
        for (int i = 0; i < num_fields; ++i) {
            if (value && row_count > 0) {
                orig_name = (String)data.getData(i, 0);
                if (orig_name != null && (name = orig_name.trim()).length() > 0) {
                    this._debug("useFirstRowAsFieldNames.Setting: i = " + i + " to " + name + "[originally: " + orig_name + "]");
                    fields.setData(1, i, (Object)name);
                }
            } else {
                try {
                    fields.setData(1, i, (Object)(this.translate("FI_ffInfoPrefixForGeneratedColNames") + (i + 1)));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if ((!value || row_count <= 1) && !value && row_count <= 0) continue;
        }
    }

    public void useFirstRowAsFieldNamesEdit(boolean value) {
        this._useFirstRowAsFieldNames = value;
        ArrayTwoDModel fields = this.getFieldPropertiesDs(this._singleRecordName);
        int num_fields = fields.getRowCount();
        int row_count = 0;
        boolean len = false;
        String orig_name = "";
        String name = "";
        String testData = "";
        String testSqlData = "";
        String tmp = "";
        this._debug("useFirstRowAsFieldNames.num_fields = " + num_fields);
        ArrayTwoDModel data = this.getFormattedColumnDataSource(this._singleRecordName);
        this._debug("useFirstRowAsFieldNames.data count = " + data.getRowCount());
        row_count = data.getRowCount();
        for (int i = 0; i < num_fields; ++i) {
            if (value && row_count > 0) {
                orig_name = (String)data.getData(i, 0);
                if (orig_name != null && (name = orig_name.trim()).length() > 0) {
                    name = name.replace(' ', '_');
                    name = name.replace('-', '_');
                    this._debug("useFirstRowAsFieldNames.Setting: i = " + i + " to " + name + "[originally: " + orig_name + "]");
                    fields.setData(1, i, (Object)name);
                }
            } else {
                fields.setData(1, i, (Object)(this.translate("FI_ffInfoPrefixForGeneratedColNames") + (i + 1)));
            }
            if ((!value || row_count <= 1) && !value && row_count <= 0) continue;
        }
    }

    public ArrayTwoDModel getFieldPropertiesDs(String recordName) {
        ArrayTwoDModel fieldPropertiesDs;
        if (this._fieldPropertiesHash == null) {
            this._fieldPropertiesHash = new Hashtable();
        }
        if (recordName == null) {
            recordName = this.getFileStructureName();
        }
        if ((fieldPropertiesDs = (ArrayTwoDModel)this._fieldPropertiesHash.get(recordName.toUpperCase())) == null) {
            fieldPropertiesDs = this._isComplexFile ? new ArrayTwoDModel(this.getComplexFieldPropertiesInfo().length, 0) : new ArrayTwoDModel(this.getFieldPropertiesInfo().length, 0);
            this._fieldPropertiesHash.put(recordName.toUpperCase(), fieldPropertiesDs);
            this.initFieldPropertiesDs(fieldPropertiesDs, recordName);
        }
        return fieldPropertiesDs;
    }

    public void removeFieldPropertiesDs(String recordName) {
        if (this._fieldPropertiesHash != null) {
            this._fieldPropertiesHash.remove(recordName.toUpperCase());
        }
    }

    private void initFieldPropertiesDs(ArrayTwoDModel propertiesDs, String recordName) {
        int rowCount;
        ArrayTwoDModel data = null;
        RecTypeAttributes recAttr = null;
        data = this.isComplexFile() ? ((recAttr = this.getRecordAttributes(recordName)) != null ? (recAttr.isDelimited() ? this.getDelimitedColumnDataSource(this.getRecordSampleText(recordName), recAttr.getDelimiter()) : this.getComplexFormattedColumnDataSource(recordName, this.getRecordSampleText(recordName))) : this.getFormattedColumnDataSource(recordName)) : this.getFormattedColumnDataSource(recordName);
        int fieldCount = 0;
        if (data != null) {
            fieldCount = data.getColumnCount();
        }
        if ((rowCount = propertiesDs.getRowCount()) < fieldCount) {
            propertiesDs.addRows(rowCount, fieldCount - rowCount);
        }
        if (rowCount > fieldCount) {
            propertiesDs.removeRows(fieldCount, rowCount - fieldCount);
        }
        int[] field_widths = null;
        if (data != null) {
            field_widths = this.getColumnWidths((TwoDModel)data);
        }
        int last_end = 0;
        this._debug("Initializing field propertiesDs for " + recordName + " with " + fieldCount + " fields.");
        String testData = "";
        String testDataType = "";
        String testStyle = "";
        String testStylePattern1 = "";
        String testStylePattern2 = "";
        try {
            for (int i = 0; i < fieldCount; ++i) {
                Integer length;
                testData = (String)propertiesDs.getData(1, i);
                if (testData == null) {
                    testData = this.translate("FI_ffInfoPrefixForGeneratedColNames") + (i + 1);
                    try {
                        propertiesDs.setData(1, i, (Object)testData);
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                }
                testDataType = (String)propertiesDs.getData(2, i);
                if (this._isComplexFile) {
                    testStyle = (String)propertiesDs.getData(7, i);
                    testStylePattern1 = (String)propertiesDs.getData(8, i);
                    testStylePattern2 = (String)propertiesDs.getData(9, i);
                }
                if (testDataType == null) {
                    testDataType = "string";
                    if (this.isComplexFile()) {
                        testStyle = recAttr != null ? (recAttr.isDelimited() ? "terminated" : "fixedLength") : "fixedLength";
                    }
                    for (int j = 0; j < data.getRowCount(); ++j) {
                        String tmp = (String)data.getData(i, j);
                        if (tmp != null && !tmp.equals("")) {
                            tmp = this.stripDelimiterFromData(tmp);
                        }
                        try {
                            String[] styleArray;
                            if (tmp != null && tmp.indexOf(46) != -1) {
                                Float.parseFloat(tmp);
                                testDataType = "decimal";
                                if (!this._isComplexFile) continue;
                                styleArray = this.parseSampleData((String)data.getData(i, j));
                                if (styleArray != null) {
                                    testStyle = styleArray[0];
                                    testStylePattern1 = styleArray[1];
                                    testStylePattern2 = styleArray[2];
                                }
                                if (styleArray[1] != "" || styleArray[2] != "") continue;
                                testStyle = "";
                                testStylePattern1 = "";
                                testStylePattern2 = "";
                                continue;
                            }
                            Integer.parseInt(tmp);
                            if (tmp.startsWith("0")) continue;
                            testDataType = "int";
                            if (!this._isComplexFile) continue;
                            styleArray = this.parseSampleData((String)data.getData(i, j));
                            if (styleArray != null) {
                                testStyle = styleArray[0];
                                testStylePattern1 = styleArray[1];
                                testStylePattern2 = styleArray[2];
                            }
                            if (styleArray[1] != "" || styleArray[2] != "") continue;
                            testStyle = "";
                            testStylePattern1 = "";
                            testStylePattern2 = "";
                            continue;
                        }
                        catch (NumberFormatException e) {
                            String[] styleArray;
                            testDataType = "string";
                            if (!this._isComplexFile) break;
                            if (recAttr != null) {
                                if (recAttr.isDelimited()) {
                                    testStyle = "terminated";
                                    testStylePattern1 = "";
                                    testStylePattern2 = "";
                                    break;
                                }
                                styleArray = this.parseSampleData((String)data.getData(i, j));
                                if (styleArray == null) break;
                                testStyle = styleArray[0];
                                testStylePattern1 = styleArray[1];
                                testStylePattern2 = styleArray[2];
                                break;
                            }
                            styleArray = this.parseSampleData((String)data.getData(i, j));
                            if (styleArray == null) break;
                            testStyle = styleArray[0];
                            testStylePattern1 = styleArray[1];
                            testStylePattern2 = styleArray[2];
                            break;
                        }
                    }
                    propertiesDs.setData(2, i, (Object)testDataType);
                    if (this._isComplexFile) {
                        propertiesDs.setData(7, i, (Object)testStyle);
                        if (recAttr != null) {
                            if (recAttr.isDelimited()) {
                                propertiesDs.setData(8, i, (Object)recAttr.getDelimiter());
                                propertiesDs.setData(9, i, (Object)"");
                            } else {
                                propertiesDs.setData(8, i, (Object)testStylePattern1);
                                propertiesDs.setData(9, i, (Object)testStylePattern2);
                            }
                        } else {
                            propertiesDs.setData(8, i, (Object)testStylePattern1);
                            propertiesDs.setData(9, i, (Object)testStylePattern2);
                        }
                        propertiesDs.setData(0, i, (Object)false);
                        propertiesDs.setData(12, i, (Object)"");
                        propertiesDs.setData(13, i, (Object)"");
                        propertiesDs.setData(15, i, (Object)"");
                        propertiesDs.setData(16, i, (Object)"1");
                        propertiesDs.setData(17, i, (Object)"1");
                        propertiesDs.setData(18, i, (Object)"");
                        propertiesDs.setData(19, i, (Object)"");
                        propertiesDs.setData(20, i, (Object)"0");
                        propertiesDs.setData(21, i, (Object)"");
                        propertiesDs.setData(22, i, (Object)"Fixed");
                        propertiesDs.setData(23, i, (Object)false);
                        propertiesDs.setData(24, i, (Object)"0");
                        propertiesDs.setData(25, i, (Object)"");
                        propertiesDs.setData(26, i, (Object)"");
                        propertiesDs.setData(27, i, (Object)"");
                        propertiesDs.setData(28, i, (Object)"");
                        propertiesDs.setData(29, i, (Object)false);
                        propertiesDs.setData(30, i, (Object)"");
                        propertiesDs.setData(31, i, (Object)"");
                        propertiesDs.setData(32, i, (Object)"");
                        propertiesDs.setData(33, i, (Object)"0");
                        propertiesDs.setData(34, i, (Object)"");
                    }
                }
                if ((length = (Integer)propertiesDs.getData(3, i)) == null) {
                    if (field_widths[i] == 0) {
                        field_widths[i] = 1;
                    }
                    testData = "" + field_widths[i];
                    length = new Integer(testData);
                    propertiesDs.setData(3, i, (Object)length);
                }
                Integer testNum = null;
                Object obj = null;
                if (!(i != fieldCount - 1 || fieldCount == 1 && this._singleInstance)) {
                    String realTerminator;
                    String showTerminator = realTerminator = this.getRecordTerminator();
                    if (realTerminator.equals("\\n") || realTerminator.equals("\\r\\n")) {
                        showTerminator = this.isRecordTerminatorEOL() ? EOL : EOF;
                    }
                    if (this.isComplexFile()) {
                        if (testStylePattern1 == null || testStylePattern1.equals("")) {
                            propertiesDs.setData(7, i, (Object)"terminated");
                            propertiesDs.setData(8, i, (Object)showTerminator);
                        }
                    } else {
                        propertiesDs.setData(6, i, (Object)showTerminator);
                    }
                } else {
                    String realDelim;
                    String showDelim = realDelim = this.getDelimiter();
                    showDelim = realDelim.equals("  ") ? this.translate("DA_delimitedColDelimiterWhiteSpace_FlatFile") : (realDelim.equals(",") ? this.translate("DA_delimitedColDelimiterComma_FlatFile") : (realDelim.equals(";") ? this.translate("DA_delimitedColDelimiterSemicolon_FlatFile") : (realDelim.equals("\\t") ? this.translate("DA_delimitedColDelimiterTab_FlatFile") : (realDelim.equals(" ") ? this.translate("DA_delimitedColDelimiterSpace_FlatFile") : realDelim))));
                    propertiesDs.setData(6, i, (Object)showDelim);
                }
                if (this._isComplexFile) {
                    propertiesDs.setData(6, i, (Object)"");
                }
                if (!this.isDelimitedFile()) {
                    obj = propertiesDs.getData(4, i);
                    testNum = obj != null && obj != "" ? (Integer)obj : null;
                    if (testNum == null) {
                        testData = "" + (last_end + 1);
                        propertiesDs.setData(4, i, (Object)new Integer(testData));
                    }
                    last_end += field_widths[i];
                    obj = propertiesDs.getData(5, i);
                    testNum = obj != null && obj != "" ? (Integer)obj : null;
                    if (testNum == null) {
                        testData = "" + last_end;
                        propertiesDs.setData(5, i, (Object)new Integer(testData));
                    }
                }
                if (!this._isComplexFile) continue;
                String style = (String)propertiesDs.getData(7, i);
                propertiesDs.setData(7, i, (Object)style);
                if (style.equals("fixedLength")) {
                    propertiesDs.setData(10, i, (Object)"tail");
                    propertiesDs.setData(11, i, (Object)this.translate("FI_generalColDelimiterSpace_FlatFile"));
                } else {
                    propertiesDs.setData(10, i, (Object)"");
                    propertiesDs.setData(11, i, (Object)"");
                }
                String stylePattern1 = (String)propertiesDs.getData(8, i);
                propertiesDs.setData(8, i, (Object)stylePattern1);
                String stylePattern2 = (String)propertiesDs.getData(9, i);
                propertiesDs.setData(9, i, (Object)stylePattern2);
                String padStyle = (String)propertiesDs.getData(10, i);
                propertiesDs.setData(10, i, (Object)padStyle);
                String padding = (String)propertiesDs.getData(11, i);
                propertiesDs.setData(11, i, (Object)padding);
                String defaultValue = (String)propertiesDs.getData(13, i);
                propertiesDs.setData(13, i, (Object)defaultValue);
                String startsWithValue = (String)propertiesDs.getData(15, i);
                propertiesDs.setData(15, i, (Object)startsWithValue);
                String minOccurs = (String)propertiesDs.getData(16, i);
                propertiesDs.setData(16, i, (Object)minOccurs);
                String maxOccurs = (String)propertiesDs.getData(17, i);
                propertiesDs.setData(17, i, (Object)maxOccurs);
                String prefix = (String)propertiesDs.getData(18, i);
                propertiesDs.setData(18, i, (Object)prefix);
                String suffix = (String)propertiesDs.getData(19, i);
                propertiesDs.setData(19, i, (Object)suffix);
                String lookAhead = (String)propertiesDs.getData(20, i);
                propertiesDs.setData(20, i, (Object)lookAhead);
                String lookFor = (String)propertiesDs.getData(21, i);
                propertiesDs.setData(21, i, (Object)lookFor);
                String lengthStyle = (String)propertiesDs.getData(22, i);
                propertiesDs.setData(22, i, (Object)lengthStyle);
                Boolean array = (Boolean)propertiesDs.getData(23, i);
                propertiesDs.setData(23, i, (Object)array);
                Boolean list = (Boolean)propertiesDs.getData(29, i);
                propertiesDs.setData(29, i, (Object)list);
                String arrayLength = (String)propertiesDs.getData(24, i);
                propertiesDs.setData(24, i, (Object)arrayLength);
                String arraySep = (String)propertiesDs.getData(25, i);
                propertiesDs.setData(25, i, (Object)arraySep);
                String cellSep = (String)propertiesDs.getData(26, i);
                propertiesDs.setData(26, i, (Object)cellSep);
                String listSep = (String)propertiesDs.getData(30, i);
                propertiesDs.setData(30, i, (Object)listSep);
                String itemSep = (String)propertiesDs.getData(31, i);
                propertiesDs.setData(31, i, (Object)itemSep);
                String dateFormat = (String)propertiesDs.getData(27, i);
                propertiesDs.setData(27, i, (Object)dateFormat);
                String quotedBy = (String)propertiesDs.getData(28, i);
                propertiesDs.setData(28, i, (Object)quotedBy);
                String skipMode = (String)propertiesDs.getData(32, i);
                propertiesDs.setData(32, i, (Object)skipMode);
                String skip = (String)propertiesDs.getData(33, i);
                propertiesDs.setData(33, i, (Object)skip);
                String skipUntil = (String)propertiesDs.getData(34, i);
                propertiesDs.setData(34, i, (Object)skipUntil);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void resyncToData() {
        String[] records = this.getRecordList();
        for (int i = 0; i < records.length; ++i) {
            this.initFieldPropertiesDs(this.getFieldPropertiesDs(records[i]), records[i]);
        }
    }

    public void setFieldPropertiesDs(String recordName, ArrayTwoDModel fieldPropertiesDs) {
        if (this._fieldPropertiesHash == null) {
            this._fieldPropertiesHash = new Hashtable();
        }
        if (recordName == null) {
            recordName = this.getFileStructureName();
        }
        if (fieldPropertiesDs != null) {
            this._fieldPropertiesHash.put(recordName.toUpperCase(), fieldPropertiesDs);
        } else {
            this._fieldPropertiesHash.remove(recordName.toUpperCase());
        }
    }

    public void updateFieldPropertiesDs(String prevrecordName, String newrecordName, ArrayTwoDModel fieldPropertiesDs) {
        if (this._fieldPropertiesHash == null || prevrecordName.equals("")) {
            this.setFieldPropertiesDs(newrecordName, fieldPropertiesDs);
            return;
        }
        this._fieldPropertiesHash.remove(prevrecordName.toUpperCase());
        this._fieldPropertiesHash.put(newrecordName.toUpperCase(), fieldPropertiesDs);
    }

    public void validateFields(String recordName) throws FlatFileValidationException {
        this._debug("validateFields( " + recordName + " )");
        ArrayTwoDModel field_properties = this.getFieldPropertiesDs(recordName);
        int field_count = field_properties.getRowCount();
        Vector<String> field_names = new Vector<String>(field_count);
        for (int i = 0; i < field_count; ++i) {
            String name = (String)field_properties.getData(1, i);
            field_names.addElement(name);
        }
        this.validateFieldNames(field_names);
        if (!this._isDelimitedFile && this._isRecordSize) {
            int record_length = 0;
            int field_start = 0;
            int field_length = 0;
            record_length = this._maxReadRecSize != 0 ? this._maxReadRecSize : (this._enableLogicalRecords && this._isFixedNumToConcat && this._concatRows != 0 ? this._recordSize * this._concatRows : this._recordSize);
            if (!this._enableLogicalRecords || !this._continueThis) {
                Object obj = null;
                for (int i = 0; i < field_count; ++i) {
                    obj = field_properties.getData(4, i);
                    field_start = obj != null && obj != "" ? Integer.parseInt(obj.toString()) : 0;
                    obj = field_properties.getData(3, i);
                    if (obj != null && obj != "") {
                        field_length = Integer.parseInt(obj.toString());
                    }
                    if (field_start + field_length - 1 <= record_length) continue;
                    throw new FlatFileValidationException(this.translate("FI_struErrMsg3_API21"));
                }
            }
        }
    }

    private void validateFieldNames(Vector fieldNames) throws FlatFileValidationException {
        if (fieldNames == null) {
            return;
        }
        boolean null_error_printed = false;
        int field_count = fieldNames.size();
        for (int i = 0; i < field_count; ++i) {
            String[] args;
            String field_name;
            block6: {
                field_name = (String)fieldNames.elementAt(i);
                this._debug("validateFieldNames " + i + " [" + field_name + "]");
                args = new String[2];
                args[0] = field_name;
                try {
                    this.validateName(field_name);
                }
                catch (FlatFileValidationException e) {
                    args[1] = e.getLocalizedMessage();
                    String errMsg = new String(this.translate("FI_ffInfoErrInvalidFieldName_API24", args));
                    throw new FlatFileValidationException(errMsg);
                }
                catch (NullPointerException null_e) {
                    if (null_error_printed) break block6;
                    this._debug("validateFieldNames.If you are in test mode, this is because the underlying type system isn't initialized.");
                    null_error_printed = true;
                }
            }
            for (int j = 0; j < field_count; ++j) {
                if (i == j || !field_name.equals(fieldNames.elementAt(j))) continue;
                String errMsg = new String(this.translate("FI_ffInfoErrDupFieldName_API19", args));
                throw new FlatFileValidationException(errMsg);
            }
        }
    }

    public void validateRecords() throws FlatFileValidationException {
        for (String record_name : this.getRecordList()) {
            String[] args = new String[2];
            args[0] = record_name;
            try {
                this.validateName(record_name);
            }
            catch (FlatFileValidationException e) {
                args[1] = e.getLocalizedMessage();
                String errMsg = new String(this.translate("FI_ffInfoErrInvalidRecordName_API29", args));
                if (record_name == null || record_name.endsWith(this.getFileStructureName())) {
                    errMsg = this.translate("FI_ffInfoErrInvalidRecordName_API41");
                }
                throw new FlatFileValidationException(errMsg);
            }
        }
    }

    public void validateFileName(String name) throws FlatFileValidationException {
        File file = new File(name);
        if (this.getFlatFileWizard().getNxsdFileInfo()._connection != null) {
            this._fileName = name;
            return;
        }
        if (!file.exists()) {
            throw new FlatFileValidationException(this.translate("FI_fileNameInvalid_API38", new String[]{name}));
        }
        this._fileName = name;
    }

    public void validateName(String name) throws FlatFileValidationException {
        try {
            if (name.indexOf(":") != -1) {
                throw new FlatFileValidationException(this.translate("FI_colonFound_API43"));
            }
            XMLElement elem = new NodeFactory().createElement(name);
        }
        catch (Exception e) {
            String errMsg = e.getMessage();
            throw new FlatFileValidationException(this.translate("elementNameInvalid_API39", new String[]{name, errMsg}));
        }
    }

    public void validateChoiceElements() throws FlatFileValidationException {
        for (int i = 0; i < this._recordClassifierDs.getRowCount(); ++i) {
            RecTypeAttributes attr = (RecTypeAttributes)this._recordClassifierDs.getData(3, i);
            if (!attr.isChoice() || !attr.getChoiceValue().equals("")) continue;
            throw new FlatFileValidationException(this.translate("FI_choiceElementInvalid", new String[]{attr.getRecordName()}));
        }
    }

    public String getClassifierValuesAsString(String recName) {
        String classifier_value = "";
        Vector classifiers = this.getClassifierValues(recName);
        int classifier_count = classifiers.size();
        for (int i = 0; i < classifier_count; ++i) {
            if (i > 0) {
                classifier_value = classifier_value + ",";
            }
            classifier_value = classifier_value + (String)classifiers.elementAt(i);
        }
        return classifier_value;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public String getDescription() {
        return this._description;
    }

    public FlatFileInfo getSameAs() {
        return this._sameAs;
    }

    public String getSameAsName() {
        if (null == this._sameAs) {
            return "";
        }
        return this._sameAs.getFileStructureName();
    }

    public void initializeFrom(FlatFileInfo ffi) {
        if (null == ffi) {
            return;
        }
        this.setDescription(ffi.getDescription());
        this.isDelimitedFile(ffi.isDelimitedFile());
        this.setSkipRecords(ffi.getSkipRecords());
        this.setSampleRecords(ffi.getSampleRecords());
        this.setRecordTerminator(ffi.getRecordTerminator());
        this.isRecordSize(ffi.isRecordSize());
        this.setRecordSize(ffi.getRecordSize());
        this.isMultiRecord(ffi.isMultiRecord());
        this.isEnableLogicalRecords(ffi.isEnableLogicalRecords());
        this.setContinueCharacters(ffi.getContinueCharacters(), ffi.continueThis());
        this.isFixedNumToConcatenate(ffi.isFixedNumToConcatenate());
        this.setConcatRows(ffi.getConcatRows());
        if (ffi.isEnclosedLeft()) {
            this.setEnclosureLeft(ffi.getEnclosureLeft());
        } else {
            this.setEnclosureLeft("");
        }
        if (this.isDelimitedFile()) {
            this.setDelimiter(ffi.getDelimiter());
        }
        this.setRecordClassifierStart(ffi.getRecordClassifierStart());
        this.setRecordClassifierEnd(ffi.getRecordClassifierEnd());
        this.setDefaultCoding(ffi.getDefaultCoding());
        this.setRecordsToProcessRemain(ffi.getRecordsToProcessRemain());
        this._recordClassifierDs = this.createSortableDs((TwoDModel)ffi.getRecordClassifierDs());
        String[] records = ffi.getRecordList();
        this._fieldPropertiesHash = new Hashtable(records.length);
        if (records.length == 1 && ffi.getFileStructureName().equals(records[0])) {
            ArrayTwoDModel fieldDs = this.createArrayDs((TwoDModel)ffi.getFieldPropertiesDs(null));
            this.setFieldPropertiesDs(null, fieldDs);
        } else {
            for (int rec_idx = 0; rec_idx < records.length; ++rec_idx) {
                String record = records[rec_idx];
                ArrayTwoDModel fieldDs = this.createArrayDs((TwoDModel)ffi.getFieldPropertiesDs(record));
                this.setFieldPropertiesDs(record, fieldDs);
            }
        }
    }

    private SortableTwoDModel createSortableDs(TwoDModel source) {
        int col_count = source.getColumnCount();
        int row_count = source.getRowCount();
        SortableTwoDModel clone = new SortableTwoDModel(col_count, row_count);
        for (int row = 0; row < row_count; ++row) {
            String msg = new String("createSortableDs[" + row + "] ");
            for (int col = 0; col < col_count; ++col) {
                clone.setData(col, row, source.getData(col, row));
                if (col > 0) {
                    msg = msg + ",";
                }
                if (source.getData(col, row) == null) continue;
                msg = msg + source.getData(col, row).toString();
            }
            this._debug("createSortableDs." + msg);
        }
        return clone;
    }

    private ArrayTwoDModel createArrayDs(TwoDModel source) {
        int col_count = source.getColumnCount();
        int row_count = source.getRowCount();
        ArrayTwoDModel clone = new ArrayTwoDModel(col_count, row_count);
        for (int row = 0; row < row_count; ++row) {
            String msg = new String("createArrayDs[" + row + "] ");
            for (int col = 0; col < col_count; ++col) {
                clone.setData(col, row, source.getData(col, row));
                if (col > 0) {
                    msg = msg + ",";
                }
                if (source.getData(col, row) == null) continue;
                msg = msg + source.getData(col, row).toString();
            }
            this._debug("createArrayDs." + msg);
        }
        return clone;
    }

    FlatFileInfo updateWithExistingNxsd(FlatFileInfo ffi, String nxsdFilePath, String root) throws FlatFileValidationException {
        DebugUtility.debug((Object)this, "updateWithExistingNxsd() ");
        FlatFileInfo updatedFlatFileInfo = ffi;
        String nxsdAsString = "";
        String version = "";
        String encodingOfNXSDDoc = "UTF-8";
        String nxsd_encoding = "UTF-8";
        XMLDocument document = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            FileInputStream in_stream = new FileInputStream(nxsdFilePath);
            DOMParser parser = new DOMParser();
            parser.parse((InputStream)in_stream);
            document = parser.getDocument();
            if (document.getEncoding() != null) {
                encodingOfNXSDDoc = document.getEncoding();
            }
            document.print((OutputStream)baos, encodingOfNXSDDoc);
            nxsdAsString = baos.toString(encodingOfNXSDDoc);
            in_stream.close();
        }
        catch (FileNotFoundException e) {
            DebugUtility.debug("FFI updateNxsd :: Nxsd file not found");
        }
        catch (IOException e) {
            DebugUtility.debug("FFI updateNxsd :: Nxsd file could not be read");
        }
        catch (XMLParseException e) {
        }
        catch (SAXException e) {
            // empty catch block
        }
        try {
            String yes;
            String fileName;
            XSDAnnotation annotation;
            Vector attributes;
            String namespace;
            XMLSchemaNode schemaNode;
            XMLSchema schema = new XSDBuilder().build(document, null);
            if (schema != null && (schemaNode = schema.getSchemaByTargetNS(namespace = schema.getSchemaTargetNS())) != null && (attributes = (annotation = schemaNode.getAnnotation()).getAttributes()) != null) {
                Hashtable<String, String> attributeTable = new Hashtable<String, String>();
                for (int i = 0; i < attributes.size(); ++i) {
                    XMLAttr attr = (XMLAttr)attributes.elementAt(i);
                    attributeTable.put(attr.getName(), attr.getValue());
                    DebugUtility.debug("Name : " + attr.getName() + " = " + attr.getValue());
                }
                String string = version = attributeTable.get("nxsd:version") != null ? (String)attributeTable.get("nxsd:version") : "";
                if (version.equals("NXSD")) {
                    nxsd_encoding = (String)attributeTable.get("nxsd:encoding");
                    if (attributeTable.get("nxsd:byteOrder") != null) {
                        this.isCCBFile(true);
                        this.setNamespace(namespace);
                        if (attributeTable.get("nxsd:byteOrder").equals(BIG_END)) {
                            this.isBigEndian(true);
                        } else {
                            this.isLittleEndian(true);
                        }
                        String ccbEncoding = (String)attributeTable.get("nxsd:encoding");
                        if (ccbEncoding.equals("cp037")) {
                            this.setCcbEncoding("EBCDIC (cp037)");
                        } else {
                            this.setCcbEncoding(ccbEncoding);
                        }
                        int cell = nxsdAsString.indexOf("cellSeparatedBy");
                        if (cell != -1) {
                            int cr = nxsdAsString.indexOf("\\r\\n", cell);
                            if (cr != -1) {
                                this.setCcbRecordDelimiter("\\r\\n");
                            } else {
                                int r = nxsdAsString.indexOf("\\r", cell);
                                if (r != -1) {
                                    this.setCcbRecordDelimiter("\\r");
                                } else {
                                    this.setCcbRecordDelimiter("\\n");
                                }
                            }
                        }
                    } else {
                        this.isBigEndian(true);
                        DSConverter converter = new DSConverter();
                        updatedFlatFileInfo = converter.convertTowizardInfo(ffi, nxsdFilePath, root);
                    }
                } else if (version.equals("DTD")) {
                    this.isDTDFile(true);
                    this.setNamespace(namespace);
                }
                if (attributeTable.get("nxsd:dataLines") != null) {
                    this.setProcessRows(Integer.parseInt((String)attributeTable.get("nxsd:dataLines")));
                }
            }
            int startIndex = nxsdAsString.indexOf("<!--NXSDWIZ:");
            int endIndex = 0;
            if (startIndex != -1 && new File(fileName = nxsdAsString.substring(startIndex + 12, endIndex = nxsdAsString.indexOf(":-->", startIndex))).exists()) {
                updatedFlatFileInfo.setFileStructureName(fileName);
                if (version.equals("NXSD") && !updatedFlatFileInfo.isCCB() && !updatedFlatFileInfo.isMultiRecord()) {
                    ArrayTwoDModel ds = updatedFlatFileInfo.getFieldPropertiesDs(this._singleRecordName);
                    updatedFlatFileInfo.setFieldPropertiesDs(fileName, ds);
                }
            }
            startIndex = nxsdAsString.indexOf("<!--USE-HEADER:");
            endIndex = 0;
            if (startIndex != -1 && (yes = nxsdAsString.substring(startIndex + 15, endIndex = nxsdAsString.indexOf(":-->", startIndex))).equals("true") && version.equals("NXSD") && !updatedFlatFileInfo.isCCB()) {
                this._useFirstRowAsFieldNames = true;
            }
        }
        catch (Exception e) {
            String msg = e.getMessage();
            String newline = System.getProperty("line.separator");
            if (e instanceof NXSDException) {
                msg = ((NXSDException)e).getDescription();
                if (newline != null) {
                    msg = newline + newline + msg;
                }
            }
            throw new FlatFileValidationException(this.translate("CT_cannotEdit_API34", new String[]{msg}));
        }
        if (!this.isCCB() && nxsd_encoding != null) {
            this.setDefaultCoding(nxsd_encoding);
            updatedFlatFileInfo.setDefaultCoding(nxsd_encoding);
        }
        this.setNxsdEncoding(encodingOfNXSDDoc);
        updatedFlatFileInfo.setNxsdEncoding(encodingOfNXSDDoc);
        return updatedFlatFileInfo;
    }

    public Vector getRootElementList(String fileName) {
        Vector rootElementList = new Vector();
        try {
            rootElementList = new DSConverter().getRootElementList(fileName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rootElementList;
    }

    public String generateNXSD() throws FlatFileValidationException {
        String nxsdString = "";
        if (this.isDelimitedFile() || this.isFixedLength()) {
            try {
                this.setNxsdEncoding("UTF-8");
                DSConverter converter = new DSConverter();
                nxsdString = converter.convertToNXSD(this);
            }
            catch (Exception e) {
                String newline;
                String msg = e.getMessage();
                if (e instanceof NXSDException) {
                    msg = ((NXSDException)e).getDescription();
                }
                if ((newline = System.getProperty("line.separator")) != null) {
                    msg = newline + msg;
                }
                if (msg == null) {
                    msg = "";
                }
                throw new FlatFileValidationException(this.translate("CB_genericError_API36"));
            }
        }
        if (this.isComplexFile()) {
            try {
                this.setNxsdEncoding("UTF-8");
                DSConverter converter = new DSConverter();
                nxsdString = converter.convertToComplexNXSD(this);
            }
            catch (Exception e) {
                String newline;
                String msg = e.getMessage();
                if (e instanceof NXSDException) {
                    msg = ((NXSDException)e).getDescription();
                }
                if ((newline = System.getProperty("line.separator")) != null) {
                    msg = newline + msg;
                }
                if (msg == null) {
                    msg = "";
                }
                throw new FlatFileValidationException(this.translate("CB_genericError_API36"));
            }
        }
        if (this.isDTD()) {
            String ns = this.getNamespace() != null ? this.getNamespace() : "";
            String rootName = this.getRootElement() != null ? this.getRootElement() : "";
            String dtdlocn = this.getFileStructureName();
            Hashtable<String, String> ht = new Hashtable<String, String>(2);
            ht.put("NAMESPACE", ns);
            ht.put("ROOTNAME", rootName);
            ht.put("DTDNAME", this.getFileStructureName());
            try {
                XMLDocument xsd = null;
                xsd = this.getFlatFileWizard().getNxsdFileInfo()._connection != null ? DTDImporter.createNXSD((StringBuffer)this._appsDTD, ht) : DTDImporter.createNXSD((String)dtdlocn, ht);
                StringWriter stringWriter = new StringWriter();
                PrintWriter writer = new PrintWriter(stringWriter);
                xsd.print(writer);
                writer.flush();
                nxsdString = stringWriter.getBuffer().toString();
                nxsdString = CommonUtils.fixProlog(nxsdString, xsd.getEncoding());
                stringWriter.close();
                writer.close();
            }
            catch (Exception e) {
                String newline;
                String msg = e.getMessage();
                if (e instanceof DTDImportException) {
                    msg = ((DTDImportException)e).getDescription();
                }
                if ((newline = System.getProperty("line.separator")) != null) {
                    msg = newline + msg;
                }
                if (msg == null) {
                    msg = "";
                }
                throw new FlatFileValidationException(this.translate("DT_genericError_API37", new String[]{msg}));
            }
        }
        if (this.isCCB()) {
            try {
                String recordDelimiter;
                Hashtable<String, String> ht = new Hashtable<String, String>();
                String ns = this.getNamespace() != null ? this.getNamespace() : "";
                String rootElement = this.getRootElement() != null ? this.getRootElement() : "";
                String filePath = this.getFileStructureName();
                String byteOrder = "";
                String characterSet = this.getCcbEncoding();
                if (characterSet != null && characterSet.indexOf("EBCDIC") != -1) {
                    characterSet = "cp037";
                }
                if ((recordDelimiter = this.getCcbRecordDelimiter()).indexOf("none") != -1) {
                    recordDelimiter = "";
                } else if (recordDelimiter.equals("\\n") || recordDelimiter.equals("\\r\\n")) {
                    recordDelimiter = EOL;
                }
                byteOrder = this.isLittleEndian() ? LTL_END : BIG_END;
                ht.put("NAMESPACE", ns);
                ht.put("CHARSET", characterSet);
                ht.put("BYTEORDER", byteOrder);
                ht.put("RECDELIM", recordDelimiter);
                ht.put("ROOTNAME", rootElement);
                XMLDocument doc = CCBImporter.createNXSD((String)filePath, ht);
                StringWriter stringWriter = new StringWriter();
                PrintWriter writer = new PrintWriter(stringWriter);
                doc.print(writer);
                writer.flush();
                nxsdString = stringWriter.getBuffer().toString();
                nxsdString = CommonUtils.fixProlog(nxsdString, doc.getEncoding());
                stringWriter.close();
                writer.close();
            }
            catch (Exception e) {
                String newline;
                String msg = e.getMessage();
                if (e instanceof CopyBookException) {
                    msg = ((CopyBookException)e).getDescription();
                }
                if ((newline = System.getProperty("line.separator")) != null) {
                    msg = newline + msg;
                }
                if (msg == null) {
                    msg = "";
                }
                throw new FlatFileValidationException(this.translate("CB_genericError_API36"));
            }
        }
        return nxsdString;
    }

    public void isEditingNXSD(boolean editingNXSD) {
        this._debug("FFI isEditingNXSD() editingNXSD : " + editingNXSD);
        if (this._editingNXSD) {
            this._recordClassifierDs = null;
            if (this._fieldPropertiesHash != null) {
                this._fieldPropertiesHash.clear();
            }
        }
        if (this._editingNXSD != editingNXSD) {
            this._fileStructureName = "";
            this._fileName = "";
        }
        this._editingNXSD = editingNXSD;
    }

    public void setSingleRecordName(String singleRecordName) throws FlatFileValidationException {
        this.validateName(singleRecordName);
        this._singleRecordName = singleRecordName;
    }

    public String getSingleRecordName() {
        return this._singleRecordName;
    }

    public void setNamespace(String namespace) {
        this._namespace = namespace;
    }

    public String getNamespace() {
        return this._namespace;
    }

    public void setRootElement(String rootElement) throws FlatFileValidationException {
        this.validateName(rootElement);
        this._rootElement = rootElement;
    }

    public String getRootElement() {
        return this._rootElement;
    }

    public void setXmlDataTypes(String[] xmlDataTypes) {
        _xmlDataTypes = xmlDataTypes;
    }

    public static String[] getXmlDataTypes() {
        return _xmlDataTypes;
    }

    public void setCharacterSetList(String[] characterSetList) {
        _characterSetList = characterSetList;
    }

    public String[] getCharacterSetList() {
        return _characterSetList;
    }

    public String getByteOrder() {
        if (this._littleEndian) {
            return LTL_END;
        }
        if (this._bigEndian) {
            return BIG_END;
        }
        return null;
    }

    public void setFlatFileWizard(FlatFileWizard flatFileWizard) {
        this._flatFileWizard = flatFileWizard;
    }

    public FlatFileWizard getFlatFileWizard() {
        return this._flatFileWizard;
    }

    public void setModifiedNXSD(String modifiedNXSD) {
        this._modifiedNXSD = modifiedNXSD;
        this.setChanged();
        this.notifyObservers();
    }

    public String getModifiedNXSD() {
        return this._modifiedNXSD;
    }

    public void setSampleEverything(boolean sampleEverything) {
        this._sampleEverything = sampleEverything;
    }

    public boolean isSampleEverything() {
        return this._sampleEverything;
    }

    public String toString() {
        String retString = "";
        retString = retString + "\n _fileName: " + this._fileName;
        retString = retString + "\n _nxsdFileName: " + this._nxsdFileName;
        retString = retString + "\n skip : " + this._skip;
        retString = retString + "\n sample: " + this._sample;
        retString = retString + "\n RecTermin: " + this._recordTerminator;
        retString = retString + "\n isRecordSize: " + this._isRecordSize;
        retString = retString + "\n MultiRec: " + this._isMultiRecordFile;
        retString = retString + "\n Quotes: " + this._rightEnclosure;
        retString = retString + "\n RemainingRecords: " + this._recordsToProcessRemain;
        retString = retString + "\n littleEndian:  " + this._littleEndian;
        retString = retString + "\n bigEndian: " + this._bigEndian;
        retString = retString + "\n isSingleInstance: " + this._singleInstance;
        retString = retString + "\n isEditing: " + this._editingNXSD;
        retString = retString + "\n SingleRecordName: " + this._singleRecordName;
        retString = retString + "\n delimiter: " + this._delimiter;
        retString = retString + "\n _classifierStartPos: " + this._classifierStartPos;
        retString = retString + "\n _classifierEndPos: " + this._classifierEndPos;
        retString = retString + "\n  charSet: " + this._characterSet;
        retString = retString + "\n _ccbEncoding: " + this._ccbEncoding;
        retString = retString + "\n _fileStructureName: " + this._fileStructureName;
        retString = retString + "\n NS: " + this._namespace;
        retString = retString + "\n _rootElement: " + this._rootElement;
        retString = retString + "\n _sampleEverything: " + this._sampleEverything;
        retString = retString + "\n _recordClassifierDs: ============\n";
        for (int i = 0; this._recordClassifierDs != null && i < this._recordClassifierDs.getRowCount(); ++i) {
            retString = retString + " \nRecord: " + this._recordClassifierDs.getData(2, i);
            retString = retString + " ID: " + this._recordClassifierDs.getData(1, i);
        }
        retString = retString + "\n _fieldPropertiesHash: =========\n";
        if (this._fieldPropertiesHash != null) {
            Enumeration e = this._fieldPropertiesHash.keys();
            while (e.hasMoreElements()) {
                String recordName = (String)e.nextElement();
                retString = retString + "\n" + recordName;
                ArrayTwoDModel recordData = (ArrayTwoDModel)this._fieldPropertiesHash.get(recordName);
                for (int i = 0; i < recordData.getRowCount(); ++i) {
                    retString = retString + "\n\tField: " + recordData.getData(0, i);
                    retString = retString + "\t\tType: " + recordData.getData(1, i);
                    retString = retString + "\t\tLength: " + recordData.getData(2, i);
                    retString = retString + "\t\tStart: " + recordData.getData(3, i);
                    retString = retString + "\t\tEnd: " + recordData.getData(4, i);
                }
            }
        }
        return retString;
    }

    public void setCcbRecordDelimiter(String ccbRecordDelimiter) {
        this._ccbRecordDelimiter = ccbRecordDelimiter;
    }

    public String getCcbRecordDelimiter() {
        return this._ccbRecordDelimiter;
    }

    public void setCcbEncoding(String ccbEncoding) {
        this._ccbEncoding = ccbEncoding;
    }

    public String getCcbEncoding() {
        return this._ccbEncoding;
    }

    public void setAppsDTD(StringBuffer appsDTD) {
        this._appsDTD = appsDTD;
    }

    public StringBuffer getAppsDTD() {
        return this._appsDTD;
    }

    public void setRecordTerminatorEOL(boolean recordTerminatorEOL) {
        this._recordTerminatorEOL = recordTerminatorEOL;
    }

    public boolean isRecordTerminatorEOL() {
        return this._recordTerminatorEOL;
    }

    public void setNxsdEncoding(String nxsdEncoding) {
        this._nxsdEncoding = nxsdEncoding;
    }

    public String getNxsdEncoding() {
        return this._nxsdEncoding;
    }

    public void setProcessRows(int processRows) {
        this._processRows = processRows;
    }

    public int getProcessRows() {
        return this._processRows;
    }

    public void setFileChooser(JFileChooser chooser) {
        this._fileChooser = chooser;
    }

    public JFileChooser getFileChooser() {
        return this._fileChooser;
    }

    public RecTypeAttributes getRecordAttributes(String record) {
        try {
            int rowcount = this._recordClassifierDs.getRowCount();
            for (int i = 0; i < rowcount; ++i) {
                if (!((String)this._recordClassifierDs.getData(2, i)).equals(record)) continue;
                return (RecTypeAttributes)this._recordClassifierDs.getData(3, i);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void updateRecordClassifierDs(String prevRecName, String newRecName) {
        int rowcount = this._recordClassifierDs.getRowCount();
        for (int i = 0; i < rowcount; ++i) {
            if (!((String)this._recordClassifierDs.getData(2, i)).equals(prevRecName)) continue;
            this._recordClassifierDs.setData(2, i, (Object)newRecName);
            ((RecTypeAttributes)this._recordClassifierDs.getData(3, i)).setRecordName(newRecName);
            break;
        }
    }

    public void setHierarchicalTreeModel(DefaultTreeModel model) {
        this._hierarchicalModel = model;
    }

    public DefaultTreeModel getHierarchicalTreeModel() {
        return this._hierarchicalModel;
    }

    public boolean isRecordUsedAsField(String recordname) {
        SortableTwoDModel recModel = this.getRecordClassifierDs();
        for (int i = 0; i < recModel.getRowCount(); ++i) {
            String recname = (String)recModel.getData(2, i);
            RecTypeAttributes recAttr = (RecTypeAttributes)recModel.getData(3, i);
            if (recAttr.getType().equals(recordname)) {
                return true;
            }
            if (!recAttr.getType().equals("")) continue;
            ArrayTwoDModel fieldModel = this.getFieldPropertiesDs(recname);
            for (int j = 0; j < fieldModel.getRowCount(); ++j) {
                if (!((String)fieldModel.getData(2, j)).equals(recordname)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isRecordUsedAsChoiceField(String recordname) {
        SortableTwoDModel recModel = this.getRecordClassifierDs();
        for (int i = 0; i < recModel.getRowCount(); ++i) {
            String recname = (String)recModel.getData(2, i);
            ArrayTwoDModel fieldModel = this.getFieldPropertiesDs(recname);
            for (int j = 0; j < fieldModel.getRowCount(); ++j) {
                if (!((String)fieldModel.getData(1, j)).equals(recordname) || !((RecTypeAttributes)recModel.getData(3, i)).isChoice()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasColumnMarkersChanged(int[] prevMarkers, int[] currMarkers) {
        if (prevMarkers.length != currMarkers.length) {
            return true;
        }
        for (int i = 0; i < prevMarkers.length; ++i) {
            if (prevMarkers[i] == currMarkers[i]) continue;
            return true;
        }
        return false;
    }

    public Vector getValidRecordTypeList(String recname) {
        Vector<Object> validList = new Vector<Object>();
        SortableTwoDModel recModel = this.getRecordClassifierDs();
        for (int i = 0; i < recModel.getRowCount(); ++i) {
            if (!((RecTypeAttributes)recModel.getData(3, i)).isComplexType()) continue;
            validList.add(recModel.getData(2, i));
        }
        validList.remove(recname);
        return validList;
    }

    public Vector getRecordTypeList() {
        Vector<Object> validList = new Vector<Object>();
        SortableTwoDModel recModel = this.getRecordClassifierDs();
        for (int i = 0; i < recModel.getRowCount(); ++i) {
            validList.add(recModel.getData(2, i));
        }
        return validList;
    }

    public Vector getParentRecList(String currNodeName) {
        Vector<String> recList = new Vector<String>();
        RecTypeExplorerTreeNode currNode = this.getTreeNode(currNodeName);
        if (currNode != null) {
            TreeNode[] treeNodes = this.getHierarchicalTreeModel().getPathToRoot((TreeNode)((Object)currNode));
            for (int i = 0; i < treeNodes.length; ++i) {
                if (((RecTypeExplorerTreeNode)((Object)treeNodes[i])).isRoot()) continue;
                recList.add(((RecTypeDataSourceObject)((RecTypeExplorerTreeNode)((Object)treeNodes[i])).getNodeData()).getName());
            }
        }
        return recList;
    }

    public RecTypeExplorerTreeNode getTreeNode(String nodeName) {
        DefaultTreeModel model = this.getHierarchicalTreeModel();
        if (model != null) {
            Vector nodeList = new Vector();
            this.getAllRecTypeChildNodes((RecTypeExplorerTreeNode)((Object)this.getHierarchicalTreeModel().getRoot()), nodeList);
            Enumeration e = nodeList.elements();
            while (e.hasMoreElements()) {
                RecTypeExplorerTreeNode node = (RecTypeExplorerTreeNode)((Object)e.nextElement());
                if (!((RecTypeDataSourceObject)node.getNodeData()).getName().equals(nodeName)) continue;
                return node;
            }
        }
        return null;
    }

    private void getAllRecTypeChildNodes(RecTypeExplorerTreeNode node, Vector list) {
        Enumeration e = node.children();
        while (e.hasMoreElements()) {
            RecTypeExplorerTreeNode childNode = (RecTypeExplorerTreeNode)((Object)e.nextElement());
            if (childNode == null || ((RecTypeDataSourceObject)childNode.getNodeData()).getRecType() == 1) continue;
            list.add(childNode);
            this.getAllRecTypeChildNodes(childNode, list);
        }
    }

    private String[] parseSampleData(String data) {
        String[] styleArray = new String[]{"fixedLength", "", ""};
        if (data != null) {
            Character first_char = Character.valueOf(data.charAt(0));
            Character last_char = Character.valueOf(data.charAt(data.length() - 1));
            if (!Character.isLetterOrDigit(first_char.charValue()) && !Character.isLetterOrDigit(last_char.charValue())) {
                if (first_char == last_char) {
                    styleArray[0] = "surrounded";
                    styleArray[1] = String.valueOf(first_char);
                    styleArray[2] = "";
                    return styleArray;
                }
                styleArray[0] = LEFT_RIGHT_SURROUNDED;
                styleArray[1] = String.valueOf(first_char);
                styleArray[2] = String.valueOf(last_char);
                return styleArray;
            }
            if (!Character.isLetterOrDigit(last_char.charValue()) && Character.isLetterOrDigit(first_char.charValue()) && !last_char.equals(Character.valueOf(' '))) {
                styleArray[0] = "terminated";
                styleArray[1] = String.valueOf(last_char);
                styleArray[2] = "";
                return styleArray;
            }
        }
        return styleArray;
    }

    private String stripDelimiterFromData(String data) {
        if (data != null) {
            Character first_char = Character.valueOf(data.charAt(0));
            Character last_char = Character.valueOf(data.charAt(data.length() - 1));
            if (!Character.isLetterOrDigit(first_char.charValue()) && !Character.isLetterOrDigit(last_char.charValue())) {
                return data.substring(1, data.length() - 1);
            }
            if (!Character.isLetterOrDigit(last_char.charValue()) && Character.isLetterOrDigit(first_char.charValue()) && !last_char.equals(Character.valueOf(' '))) {
                return data.substring(0, data.length() - 1);
            }
        }
        return data;
    }

    public void addNewRecordToClassifierDs(String recname, int rectype) {
        SortableTwoDModel valueGridDs = new SortableTwoDModel(4, 0);
        valueGridDs.addRows(0, 1);
        valueGridDs.setData(1, 0, (Object)"");
        valueGridDs.setData(2, 0, (Object)recname);
        RecTypeAttributes recAttr = new RecTypeAttributes();
        recAttr.setRecordName(recname);
        recAttr.setRecType(rectype);
        valueGridDs.setData(3, 0, (Object)recAttr);
        this.removeFromRecordClassifierDs(recname);
        this.addIntoRecordClassifierDs(valueGridDs);
    }

    public boolean isFieldInRecord(String recname, String field) {
        ArrayTwoDModel fieldProps = null;
        String fldName = "";
        fieldProps = this.getFieldPropertiesDs(recname);
        for (int i = 0; i < fieldProps.getRowCount(); ++i) {
            for (int j = 0; j < fieldProps.getColumnCount(); ++j) {
                if (j != 1) continue;
                fldName = (String)fieldProps.getData(j, i);
            }
            if (!fldName.equals(field)) continue;
            return true;
        }
        return false;
    }

    public ArrayOneDModel getFieldPropertiesFromSampleText(String sampleText) {
        String testStylePattern2;
        String testStylePattern1;
        String testStyle;
        String testDataType;
        Integer length;
        ArrayOneDModel propertiesDs;
        block5: {
            propertiesDs = new ArrayOneDModel(27);
            length = 0;
            testDataType = "string";
            String tmp = sampleText;
            testStyle = "";
            testStylePattern1 = "";
            testStylePattern2 = "";
            try {
                if (tmp != null && tmp.indexOf(String.valueOf('.')) != -1) {
                    Float.parseFloat(tmp);
                    testDataType = "decimal";
                } else {
                    Integer.parseInt(tmp);
                    if (!tmp.startsWith("0")) {
                        testDataType = "int";
                    }
                }
                length = tmp.length();
            }
            catch (NumberFormatException e) {
                testDataType = "string";
                String[] styleArray = this.parseSampleData(tmp);
                if (styleArray == null) break block5;
                testStyle = styleArray[0];
                testStylePattern1 = styleArray[1];
                testStylePattern2 = styleArray[2];
            }
        }
        propertiesDs.setData(2, (Object)testDataType);
        propertiesDs.setData(7, (Object)testStyle);
        propertiesDs.setData(8, (Object)testStylePattern1);
        propertiesDs.setData(9, (Object)testStylePattern2);
        propertiesDs.setData(3, (Object)length);
        return propertiesDs;
    }

    public void resetFieldPropertiesRow(String recname, int row) {
        ArrayTwoDModel propertiesDs = this.getFieldPropertiesDs(recname);
        this.resetFieldPropertiesRow(propertiesDs, row);
    }

    public void resetFieldPropertiesRow(ArrayTwoDModel propertiesDs, int row) {
        if (propertiesDs != null) {
            propertiesDs.setData(1, row, (Object)(this.translate("FI_ffInfoPrefixForGeneratedColNames") + (row + 1)));
            propertiesDs.setData(0, row, (Object)false);
            propertiesDs.setData(12, row, (Object)"");
            propertiesDs.setData(2, row, (Object)"string");
            propertiesDs.setData(3, row, (Object)new Integer("1"));
            propertiesDs.setData(4, row, (Object)new Integer("0"));
            propertiesDs.setData(5, row, (Object)new Integer("0"));
            propertiesDs.setData(6, row, (Object)"");
            propertiesDs.setData(7, row, (Object)"");
            propertiesDs.setData(8, row, (Object)"");
            propertiesDs.setData(9, row, (Object)"");
            propertiesDs.setData(10, row, (Object)"");
            propertiesDs.setData(11, row, (Object)"");
            propertiesDs.setData(13, row, (Object)"");
            propertiesDs.setData(15, row, (Object)"");
            propertiesDs.setData(16, row, (Object)"1");
            propertiesDs.setData(17, row, (Object)"1");
            propertiesDs.setData(18, row, (Object)"");
            propertiesDs.setData(19, row, (Object)"");
            propertiesDs.setData(20, row, (Object)"0");
            propertiesDs.setData(21, row, (Object)"");
            propertiesDs.setData(22, row, (Object)"Fixed");
            propertiesDs.setData(23, row, (Object)false);
            propertiesDs.setData(24, row, (Object)"0");
            propertiesDs.setData(25, row, (Object)"");
            propertiesDs.setData(26, row, (Object)"");
            propertiesDs.setData(27, row, (Object)"");
            propertiesDs.setData(27, row, (Object)"");
            propertiesDs.setData(28, row, (Object)"");
            propertiesDs.setData(29, row, (Object)false);
            propertiesDs.setData(30, row, (Object)"");
            propertiesDs.setData(31, row, (Object)"");
            propertiesDs.setData(32, row, (Object)"");
            propertiesDs.setData(33, row, (Object)"0");
            propertiesDs.setData(34, row, (Object)"");
        }
    }

    private boolean isByteOrderMark(char ch) {
        return ch == '\ufeff' || ch == '\ufffe';
    }

    public boolean existsDupFields(String recname) {
        ArrayTwoDModel fieldProps = this.getFieldPropertiesDs(recname);
        for (int i = 0; i < fieldProps.getRowCount(); ++i) {
            String fldname = (String)fieldProps.getData(1, i);
            for (int j = 0; j < fieldProps.getRowCount(); ++j) {
                String chkFldname;
                if (j == i || !(chkFldname = (String)fieldProps.getData(1, j)).equals(fldname)) continue;
                return true;
            }
        }
        return false;
    }

    public void updateLastFieldTerminator(String recname) {
        try {
            String realTerminator;
            String showTerminator = realTerminator = this.getRecordTerminator();
            if (realTerminator.equals("\\n") || realTerminator.equals("\\r\\n")) {
                showTerminator = this.isRecordTerminatorEOL() ? EOL : EOF;
            }
            ArrayTwoDModel fldprops = this.getFieldPropertiesDs(recname);
            fldprops.setData(6, fldprops.getRowCount() - 1, (Object)showTerminator);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        _characterSetList = new String[]{"ASCII", "Big5", "Big5_HKSCS", "Big5_Solaris", "EBCDIC (cp037)", "Cp1006", "Cp1025", "Cp1026", "Cp1046", "Cp1047", "Cp1097", "Cp1098", "Cp1112", "Cp1122", "Cp1123", "Cp1124", "Cp1140", "Cp1141", "Cp1142", "Cp1143", "Cp1144", "Cp1145", "Cp1146", "Cp1147", "Cp1148", "Cp1149", "Cp1250", "Cp1251", "Cp1252", "Cp1253", "Cp1254", "Cp1255", "Cp1256", "Cp1257", "Cp1258", "Cp1381", "Cp1383", "Cp273", "Cp277", "Cp278", "Cp280", "Cp284", "Cp285", "Cp297", "Cp33722", "Cp420", "Cp424", "Cp437", "Cp500", "Cp737", "Cp775", "Cp838", "Cp850", "Cp852", "Cp855", "Cp856", "Cp857", "Cp858", "Cp860", "Cp861", "Cp862", "Cp863", "Cp864", "Cp865", "Cp866", "Cp868", "Cp869", "Cp870", "Cp871", "Cp874", "Cp875", "Cp918", "Cp921", "Cp922", "Cp930", "Cp933", "Cp935", "Cp937", "Cp939", "Cp942", "Cp942C", "Cp943", "Cp943C", "Cp948", "Cp949", "Cp949C", "Cp950", "Cp964", "Cp970", "EUC_CN", "EUC_JP", "EUC_JP_LINUX", "EUC_KR", "EUC_TW", "GB18030", "GBK", "ISCII91", "ISO2022_CN_CNS", "ISO2022_CN_GB", "ISO2022JP", "ISO2022KR", "ISO8859_1", "ISO8859_13", "ISO8859_15", "ISO8859_2", "ISO8859_3", "ISO8859_4", "ISO8859_5", "ISO8859_6", "ISO8859_7", "ISO8859_8", "ISO8859_9", "JISAutoDetect", "KOI8_R", "MacArabic", "MacCentralEurope", "MacCroatian", "MacCyrillic", "MacDingbat", "MacGreek", "MacHebrew", "MacIceland", "MacRoman", "MacRomania", "MacSymbol", "MacThai", "MacTurkish", "MacUkraine", "MS874", "MS932", "MS936", "MS949", "MS950", "MS950_HKSCS", "SJIS", "TIS620", "UnicodeBig", "UnicodeBigUnmarked", "UnicodeLittle", "UnicodeLittleUnmarked", "UTF-16", "UTF-16BE", "UTF-16LE", "UTF8"};
        _styleList = new String[]{"", "fixedLength", "terminated", "surrounded", LEFT_RIGHT_SURROUNDED};
        _padStyleList = new String[]{"", "head", "tail", "none"};
        _xmlDataTypes = new String[]{"anyURI", "base64Binary", "boolean", "byte", "date", "dateTime", "decimal", "double", "duration", "ENTITIES", "ENTITY", "float", "gDay", "gMonth", "gMonthDay", "gYear", "gYearMonth", "hexBinary", "ID", "IDREF", "IDREFS", "int", "integer", "language", "long", "Name", "NCName", "negativeInteger", "NMTOKEN", "NMTOKENS", "nonNegativeInteger", "nonPositiveInteger", "normalizedString", "NOTATION", "positiveInteger", "QName", "short", "string", "time", "token", "unsignedByte", "unsignedInt", "unsignedLong", "unsignedShort"};
    }

    class RecordClassifierDs
    extends SortableTwoDModel {
        FlatFileInfo _ffi;
        Vector _knownNames;

        RecordClassifierDs(FlatFileInfo ffi, int columns, int rows) {
            super(columns, rows);
            this._ffi = null;
            this._ffi = ffi;
            this._knownNames = new Vector();
        }

        public void setData(int columnIdx, int rowIdx, Object data) {
            if (columnIdx == 2) {
                String oldName = (String)this.getData(columnIdx, rowIdx);
                String newName = (String)data;
                if (!this._knownNames.contains(newName)) {
                    if (oldName != null && oldName.length() != 0) {
                        ArrayTwoDModel field_ds = this._ffi.getFieldPropertiesDs(oldName);
                        this._ffi.setFieldPropertiesDs(newName, field_ds);
                        FlatFileInfo.this._debug("RecordClassifierDs.setData reindexing fields from [" + oldName + "] to [" + newName + "]");
                    }
                    this._knownNames.add(newName);
                }
            }
            super.setData(columnIdx, rowIdx, data);
        }
    }

    class columnHdrDs
    extends ArrayOneDModel
    implements TwoDModelListener {
        TwoDModel _sourceDs;
        int _sourceColumn;

        columnHdrDs() {
            super(0);
        }

        columnHdrDs(TwoDModel sourceDs, int sourceColumn) {
            super(sourceDs.getRowCount());
            this._sourceDs = sourceDs;
            this._sourceColumn = sourceColumn;
            this.syncUp(0, sourceDs.getRowCount());
            this._sourceDs.addModelListener((TwoDModelListener)this);
        }

        private void syncUp(int rowStart, int rowCount) {
            for (int i = 0; i < rowCount; ++i) {
                int idx = rowStart + i;
                if (this.getItemCount() < rowStart + 1) {
                    this.addItems(idx, 1);
                }
                this.setData(idx, this._sourceDs.getData(this._sourceColumn, idx));
            }
        }

        public void columnsAdded(TwoDModelEvent e) {
        }

        public void columnsRemoved(TwoDModelEvent e) {
        }

        public void invalidateCells(TwoDModelEvent e) {
            int colStart = e.getColumnStartIndex();
            int colCount = e.getColumnCount();
            int colEnd = colStart + colCount;
            if (colStart <= this._sourceColumn && this._sourceColumn <= colEnd) {
                this.syncUp(e.getRowStartIndex(), e.getRowCount());
            }
        }

        public void invalidateColumns(TwoDModelEvent e) {
        }

        public void invalidateRows(TwoDModelEvent e) {
        }

        public void rowsAdded(TwoDModelEvent e) {
        }

        public void rowsRemoved(TwoDModelEvent e) {
        }
    }
}

