/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyVetoException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.grid.NumericSpinBoxInputHandler;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.table.TableEditListener;
import oracle.bali.ewt.table.TableEvent;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.ChoiceColumnInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.ColumnInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.CommonUtils;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileDisplayGizmo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileValidationException;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WBTranslatable;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WBTranslatablePanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.DebugUtility;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.NLSUtils;

public class FlatFileFieldProperties
extends WBTranslatablePanel
implements TableEditListener {
    private JPanel _recordSelectorPanel;
    private JLabel _recordListLbl;
    private JComboBox _recordList;
    private ArrayOneDModel _fieldGridHeaderDs;
    private ArrayTwoDModel _fieldGridDs;
    private SpreadTable _fieldGridTable;
    private Grid _fieldGrid;
    private JScrollPane _fieldGridScrollBox;
    private NumericSpinBoxInputHandler _lengthHandler;
    private JPanel _buttonPanel;
    private JButton _addButton;
    private JButton _deleteButton;
    private JPanel _nextRecTypeButtonPanel;
    private JButton _nextRecTypeButton;
    private FlatFileInfo _ff_info;
    private String _lastRecord;
    private FlatFileDisplayGizmo _dataGizmo;
    private String savedDatatype;

    FlatFileFieldProperties(WBTranslatable h) {
        super(h);
    }

    public void buildFieldProperties() {
        this.setLayout(new GridBagLayout());
        Insets stdInsets = new Insets(0, 0, 0, 0);
        this._recordSelectorPanel = new JPanel(new FlowLayout(0));
        this._recordListLbl = new JLabel(this.translate("FP_propsRecordName_FlatFile"));
        CommonUtils.setMnemonicAndAccelerator(this._recordListLbl, NLSUtils.getNLSString("FP_propsRecordName_FlatFile"));
        this._recordSelectorPanel.add(this._recordListLbl);
        this._recordList = new JComboBox();
        this._recordListLbl.setLabelFor(this._recordList);
        this._recordSelectorPanel.add(this._recordList);
        this._recordList.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    FlatFileFieldProperties.this.processRecordSelection();
                }
            }
        });
        this._nextRecTypeButton = new JButton(this.translate("CD_columnDefNextRecordTypeButton_FlatFile"));
        CommonUtils.setMnemonicAndAccelerator(this._nextRecTypeButton, NLSUtils.getNLSString("CD_columnDefNextRecordTypeButton_FlatFile"));
        ActionListener nextRecTypeButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlatFileFieldProperties.this.nextRecTypeBtnAction();
            }
        };
        this._nextRecTypeButton.addActionListener(nextRecTypeButtonListener);
        this._recordSelectorPanel.add(this._nextRecTypeButton);
        this._fieldGridDs = new ArrayTwoDModel(0, 0);
        this._fieldGridTable = new SpreadTable((TwoDModel)this._fieldGridDs, null, null);
        Grid grid = this._fieldGridTable.getGrid();
        if (grid != null) {
            grid.setName("FieldsGrid");
        }
        FlatFileFieldProperties.addComponent(this, this._recordSelectorPanel, 0, 0, 1, 1, 1.0, 1.0, 17, 2, stdInsets);
        this._fieldGridScrollBox = new JScrollPane((Component)this._fieldGridTable, 20, 30);
        FlatFileFieldProperties.addComponent(this, this._fieldGridScrollBox, 0, 1, 1, 1, 1.0, 0.9, 17, 1, stdInsets);
        this._fieldGridTable.addEditListener((TableEditListener)this);
        this._fieldGrid = this._fieldGridTable.getGrid();
        this._fieldGrid.setGridSelectionManager((GridSelectionManager)new GeneralGridSelectionManager(0, 1, 0));
    }

    public void buildButtons() {
        Insets insets = new Insets(0, 0, 0, 0);
        GridLayout gridLayout = new GridLayout();
        this._buttonPanel = new JPanel();
        this._buttonPanel.setLayout(gridLayout);
        gridLayout.setHgap(6);
        FlatFileFieldProperties.addComponent(this, this._buttonPanel, 0, 2, 1, 1, 1.0, 1.0, 15, 2, insets);
        this._addButton = new JButton(this.translate("FP_struAddBtn_FlatFile"));
        insets = new Insets(5, 2, 5, 5);
        this._buttonPanel.add(this._addButton);
        ActionListener _addButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlatFileFieldProperties.this.addBtnAction();
            }
        };
        this._addButton.addActionListener(_addButtonListener);
        this._deleteButton = new JButton(this.translate("FP_struDeleteBtn_FlatFile"));
        this._buttonPanel.add(this._deleteButton);
        ActionListener _deleteButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlatFileFieldProperties.this.deleteBtnAction();
            }
        };
        this._deleteButton.addActionListener(_deleteButtonListener);
        this._deleteButton.setEnabled(false);
    }

    public JPanel buildNextRecTypeButtonPanel() {
        this._nextRecTypeButtonPanel = new JPanel();
        this._nextRecTypeButtonPanel.setLayout(new GridBagLayout());
        this._nextRecTypeButton = new JButton(this.translate("CD_columnDefNextRecordTypeButton_FlatFile"));
        CommonUtils.setMnemonicAndAccelerator(this._nextRecTypeButton, NLSUtils.getNLSString("CD_columnDefNextRecordTypeButton_FlatFile"));
        FlatFileFieldProperties.addComponent(this._nextRecTypeButtonPanel, this._nextRecTypeButton, 1, 0, 1, 1, 0.5, 0.0, 13, 0, new Insets(0, 0, 0, 0));
        ActionListener nextRecTypeButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlatFileFieldProperties.this.nextRecTypeBtnAction();
            }
        };
        this._nextRecTypeButton.addActionListener(nextRecTypeButtonListener);
        return this._nextRecTypeButtonPanel;
    }

    public void initializeFrom(FlatFileInfo info) {
        this._ff_info = info;
        this._recordList.removeAllItems();
        String[] recordList = this._ff_info.getRecordList();
        int maxSize = 0;
        ItemListener[] ils = CommonUtils.removeComboItemListener(this._recordList);
        for (int i = 0; i < recordList.length; ++i) {
            this._recordList.addItem(recordList[i]);
            if (maxSize >= recordList[i].length()) continue;
            maxSize = recordList[i].length();
        }
        CommonUtils.addComboItemListener(this._recordList, ils);
        if (this._ff_info.getRecordList().length != 1 || !this._ff_info.getClassifierValues(this._ff_info.getRecordList()[0]).isEmpty()) {
            this._recordSelectorPanel.setVisible(true);
        } else {
            this._recordSelectorPanel.setVisible(false);
        }
        if (this._recordList.getItemCount() > 0) {
            ils = CommonUtils.removeComboItemListener(this._recordList);
            this._recordList.setSelectedIndex(0);
            CommonUtils.addComboItemListener(this._recordList, ils);
            this._lastRecord = null;
            this.processRecordSelection();
        }
    }

    public void validateFields() throws FlatFileValidationException {
        this._ff_info.validateFields(this._lastRecord);
    }

    private void processRecordSelection() {
        boolean debug_on = false;
        String debug_msg = "";
        DebugUtility.debug((Object)this, "processRecordSelection() called ");
        String recordSelected = (String)this._recordList.getSelectedItem();
        if (this._lastRecord == null || !this._lastRecord.equals(recordSelected)) {
            try {
                this._ff_info.validateFields(this._lastRecord);
            }
            catch (Exception e) {
                CommonUtils.error((Object)this, e.getMessage());
                ItemListener[] ils = CommonUtils.removeComboItemListener(this._recordList);
                this._recordList.setSelectedItem(this._lastRecord);
                CommonUtils.addComboItemListener(this._recordList, ils);
                DebugUtility.debug((Object)this, "processRecordSelection END");
                return;
            }
            ColumnInfo[] fieldPropertiesInfo = this._ff_info.getFieldPropertiesInfo();
            int fieldPropertiesCount = fieldPropertiesInfo.length;
            if (this._fieldGridHeaderDs == null || this._fieldGridHeaderDs.getItemCount() != fieldPropertiesCount) {
                this._fieldGridHeaderDs = new ArrayOneDModel(fieldPropertiesCount);
                for (int i = 1; i < fieldPropertiesCount; ++i) {
                    this._fieldGridHeaderDs.setData(i, (Object)fieldPropertiesInfo[i].getHeader());
                }
            }
            this._fieldGridDs = this._ff_info.getFieldPropertiesDs(recordSelected);
            this._fieldGridTable.setModels((TwoDModel)this._fieldGridDs, (OneDModel)this._fieldGridHeaderDs, null);
            int fieldCount = this._fieldGridDs.getRowCount();
            Font currFont = this._fieldGrid.getFont();
            if (currFont == null) {
                currFont = CommonUtils.getMonoFont(0, 12);
            }
            FontMetrics currFontMetrics = this._fieldGrid.getFontMetrics(currFont);
            this._fieldGrid.setColumnVisible(0, false);
            for (int col = 1; col < fieldPropertiesCount; ++col) {
                int dataWidth;
                if (debug_on) {
                    debug_msg = "Column: " + fieldPropertiesInfo[col].getHeader();
                }
                if (this._ff_info.isDelimitedFile()) {
                    if (3 == col) {
                        fieldPropertiesInfo[col].setVisible(false);
                    }
                }
                if (this._ff_info.isFixedLength()) {
                    if (6 == col) {
                        fieldPropertiesInfo[col].setVisible(false);
                    }
                }
                if (!fieldPropertiesInfo[col].isVisible()) {
                    if (debug_on) {
                        debug_msg = debug_msg + " *INVISIBLE*";
                    }
                    this._fieldGrid.setColumnVisible(col, false);
                    this._fieldGridTable.getColumnHeader().setItemVisible(col, false);
                    continue;
                }
                this._fieldGrid.setColumnVisible(col, true);
                this._fieldGridTable.getColumnHeader().setItemVisible(col, true);
                int maxWidth = currFontMetrics.stringWidth(fieldPropertiesInfo[col].getHeader() + "W");
                if (fieldPropertiesInfo[col] instanceof ChoiceColumnInfo) {
                    ChoiceColumnInfo info = (ChoiceColumnInfo)fieldPropertiesInfo[col];
                    Object[] choices = info.getChoices();
                    for (int i = 0; i < choices.length; ++i) {
                        dataWidth = currFontMetrics.stringWidth((String)choices[i] + "WW");
                        if (maxWidth >= dataWidth) continue;
                        maxWidth = dataWidth;
                    }
                }
                for (int row = 0; row < fieldCount; ++row) {
                    Object o = this._fieldGridDs.getData(col, row);
                    String data = null;
                    if (o != null) {
                        data = o + "W";
                    }
                    if (data == null || maxWidth >= (dataWidth = currFontMetrics.stringWidth(data))) continue;
                    maxWidth = dataWidth;
                }
                this._fieldGridTable.setColumnWidth(col, maxWidth);
                if (debug_on) {
                    debug_msg = debug_msg + " Width: " + maxWidth;
                }
                if (!fieldPropertiesInfo[col].isEditable()) continue;
                if (debug_on) {
                    debug_msg = debug_msg + " EDITABLE";
                }
                this._fieldGridTable.getGrid().setColumnCellInputHandler(col, fieldPropertiesInfo[col].getInputHandler());
            }
            if (!this._ff_info.isDelimitedFile()) {
                this._lengthHandler = (NumericSpinBoxInputHandler)this._fieldGridTable.getGrid().getColumnCellInputHandler(3);
            }
            for (int row = 0; row < fieldCount; ++row) {
                String data_type = (String)this._fieldGridDs.getData(2, row);
                this.greyOutColumns(data_type, row);
            }
            this._lastRecord = recordSelected;
            this._dataGizmo.refreshContents(this._ff_info, this._lastRecord);
        }
        DebugUtility.debug("FlatFileFieldProperties.processRecordSelection END selected Record " + this._lastRecord);
    }

    public void addBtnAction() {
        GridSelectionManager tableGridSelection = this._fieldGrid.getGridSelectionManager();
        int rowsSelected = tableGridSelection.getSelection().getRowSelection().getSelectedItemAtIndex(0);
        int row = rowsSelected > -1 ? rowsSelected + 1 : this._fieldGridDs.getRowCount();
        this._fieldGridDs.addRows(row, 1);
        this._fieldGridDs.setData(2, row, (Object)"String");
        this._fieldGridDs.setData(3, row, (Object)new Integer("1"));
        this._fieldGridDs.setData(4, row, (Object)new Integer("1"));
        this.greyOutColumns("String", row);
        try {
            tableGridSelection.setSelection(new TwoDSelection(row, true), null);
            tableGridSelection.setSelection(new TwoDSelection(row, 0), null);
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        this._fieldGridTable.getGrid().startCellEdit(0, row);
    }

    public void deleteBtnAction() {
        GridSelectionManager tableGridSelection = this._fieldGrid.getGridSelectionManager();
        int rowsSelected = tableGridSelection.getSelection().getRowSelection().getSelectedItemAtIndex(0);
        if (rowsSelected > -1) {
            int row = rowsSelected;
            this._fieldGridDs.removeRows(row, 1);
            int rowCount = this._fieldGridDs.getRowCount();
            if (rowCount > 0) {
                int nextShowRow;
                for (nextShowRow = row; nextShowRow < rowCount && !this._fieldGridTable.isRowVisible(nextShowRow); ++nextShowRow) {
                }
                try {
                    if (nextShowRow < rowCount) {
                        tableGridSelection.setSelection(new TwoDSelection(nextShowRow, true), null);
                    } else {
                        tableGridSelection.setSelection(new TwoDSelection(0, true), null);
                    }
                }
                catch (PropertyVetoException e) {
                    // empty catch block
                }
            }
        }
    }

    public void nextRecTypeBtnAction() {
        int numRecords = this._recordList.getItemCount();
        int idx = this._recordList.getSelectedIndex();
        idx = idx == numRecords - 1 ? 0 : ++idx;
        ItemListener[] ils = CommonUtils.removeComboItemListener(this._recordList);
        this._recordList.setSelectedIndex(idx);
        CommonUtils.addComboItemListener(this._recordList, ils);
        this.processRecordSelection();
    }

    public void cellEdited(TableEvent e) {
        Font currFont;
        int column;
        block9: {
            int start;
            Object o;
            int precision;
            int len;
            int row;
            block10: {
                row = e.getRow();
                column = e.getColumn();
                len = 0;
                precision = 0;
                if (column == 2) {
                    String data_type = (String)this._fieldGridDs.getData(2, row);
                    this.setDefaultFromDataType(data_type, row);
                    this.greyOutColumns(data_type, row);
                }
                if (this._ff_info.isDelimitedFile()) break block9;
                if (column == 3) break block10;
                if (column == 4) break block10;
                if (column != 2) break block9;
            }
            len = (o = this._fieldGridDs.getData(3, row)) == null || o.toString() == "" ? 0 : Integer.parseInt("" + this._fieldGridDs.getData(3, row));
            int end = start = Integer.parseInt("" + this._fieldGridDs.getData(4, row));
            if (len != 0) {
                end = start + len - 1;
            } else if (precision != 0) {
                String data_type = (String)this._fieldGridDs.getData(2, row);
                end = data_type.equals("DECIMAL") ? start + (precision / 2 + 1) - 1 : start + precision - 1;
            }
            this._fieldGridDs.setData(5, row, (Object)new Integer(end));
        }
        if ((currFont = this._fieldGrid.getFont()) == null) {
            currFont = CommonUtils.getMonoFont(0, 12);
        }
        FontMetrics currFontMetrics = this._fieldGrid.getFontMetrics(currFont);
        String recordName = this.getRecordSelected();
        ArrayTwoDModel fieldProps = this._ff_info.getFieldPropertiesDs(recordName);
        int num_columns = fieldProps.getRowCount();
        int charSize = currFontMetrics.charWidth('w');
        int maxWidth = 5 * charSize;
        String columnName = "";
        int colWidth = 0;
        for (int i = 0; i < num_columns; ++i) {
            columnName = (String)fieldProps.getData(0, i);
            colWidth = (columnName.length() + 1) * charSize;
            if (colWidth <= maxWidth) continue;
            maxWidth = colWidth;
        }
        this._fieldGridTable.setColumnWidth(column, maxWidth);
        this._dataGizmo.refreshContents(this._ff_info, recordName);
    }

    private void greyOutColumns(String data_type, int row) {
        int len = 0;
        Object o = null;
        o = this._fieldGridDs.getData(3, row);
        if (o != null && !o.toString().equals("") && !o.toString().equals("0")) {
            len = Integer.parseInt("" + o);
        }
    }

    private void greyOutSqlColumns(String data_type, String sql_data_type, int row) {
    }

    private void setDefaultFromDataType(String data_type, int row) {
    }

    public void cellEditing(TableEvent e) {
        if (this._deleteButton != null) {
            this._deleteButton.setEnabled(true);
        }
        if (e.getSource() == this._fieldGridTable) {
            String data_type;
            int row = e.getRow();
            int column = e.getColumn();
            this.savedDatatype = data_type = (String)this._fieldGridDs.getData(2, row);
            boolean cancel = false;
            boolean validSqlDataType = true;
            if (cancel && e instanceof Cancelable) {
                ((Cancelable)e).cancel();
            }
        }
    }

    public JButton getAddButton() {
        return this._addButton;
    }

    public JButton getNextRecTypeButton() {
        return this._nextRecTypeButton;
    }

    public JPanel getButtonPanel() {
        return this._buttonPanel;
    }

    public SpreadTable getFieldGrid() {
        return this._fieldGridTable;
    }

    public int getRecordCount() {
        return this._recordList.getItemCount();
    }

    public JComboBox getRecordList() {
        return this._recordList;
    }

    public String getRecordSelected() {
        return this._lastRecord;
    }

    public boolean recordListIsVisible() {
        return this._recordList.isVisible();
    }

    public void setDataGizmo(FlatFileDisplayGizmo gizmo) {
        this._dataGizmo = gizmo;
    }
}

