/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.scrolling.EWTScrollPane;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.CommonUtils;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileRuler;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileRulerEvent;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileRulerListener;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileScroller;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileTextArea;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WBTranslatableDialog;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.DebugUtility;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.NLSUtils;

public class FlatFileDisplayGizmoForDialog
extends JPanel
implements FlatFileRulerListener {
    public static final int UNKNOWN_DISPLAY_TYPE = 0;
    public static final int TEXT_ONLY_FORMAT = 1;
    public static final int RULER_FORMAT = 2;
    public static final int COLUMN_FORMAT = 3;
    public static final int ERROR_FORMAT = 4;
    private int _type = 0;
    private boolean _initialized = false;
    private FlatFileRuler _ruler;
    private FlatFileTextArea _textDisplay;
    private SpreadTable _columnDisplay;
    private WBTranslatableDialog _owner;
    private Font _displayFont;
    private JCheckBox _promptCb;
    private boolean _showPromptCheckbox;
    private WidthTextField _fieldWidths;
    private boolean _settingMarks;
    private boolean _previewing;
    private int _oldType = 0;
    private MultiLineLabel _errorDisplay;
    private boolean _allowDataColumnSelection;
    private JLabel _fileLabel;
    private boolean _debug_on = false;
    private String _delimiter;

    public FlatFileDisplayGizmoForDialog(int type, WBTranslatableDialog owner) {
        this._owner = owner;
        this._settingMarks = false;
        this._previewing = false;
        this._allowDataColumnSelection = false;
        this._delimiter = "";
        this._displayFont = CommonUtils.getMonoFont(0, 12);
        this._columnDisplay = new SpreadTable(null, null, null);
        Grid grid = this._columnDisplay.getGrid();
        if (grid != null) {
            grid.setName("DisplayGizmo");
        }
        this._ruler = new FlatFileRuler(this._displayFont);
        this._fieldWidths = new WidthTextField();
        this._fieldWidths.setToolTipText(this._owner.translate("GZ_fieldTextFieldToolTip"));
        this._fieldWidths.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlatFileDisplayGizmoForDialog.this.updateMarks();
            }
        });
        this._promptCb = new JCheckBox(this._owner.translate("GN_displayUseFirstRowPrompt_FlatFile"), false);
        this._fileLabel = new JLabel(this._owner.translate("GZ_displayTitle_FlatFile", new String[]{""}));
        this._showPromptCheckbox = false;
        this.setType(type);
    }

    public void updateMarks() {
        if (this._settingMarks) {
            this._debug("_fieldWidths->textValueChanged early break on _settingMarks");
            return;
        }
        String value = this._fieldWidths.getText();
        this._debug("_fieldWidths->textValueChanged(" + value + ")");
        int count = 0;
        StringTokenizer tokenizer = new StringTokenizer(value, ",");
        int[] widths = new int[tokenizer.countTokens()];
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            try {
                int width = Integer.parseInt(token.trim());
                widths[count++] = width;
            }
            catch (Exception ex) {}
        }
        this.bubbleSort(widths);
        int[] newWidths = this.removeRepeats(widths);
        this.updateFieldWidthsDisplay(newWidths);
        int[] marks = new int[newWidths.length];
        int pos = 0;
        for (int i = 0; i < newWidths.length; ++i) {
            marks[i] = pos + newWidths[i];
        }
        this.setMarkedColumns(marks);
    }

    private void bubbleSort(int[] numbers) {
        int array_size = numbers.length;
        for (int i = array_size - 1; i >= 0; --i) {
            for (int j = 1; j <= i; ++j) {
                if (numbers[j - 1] <= numbers[j]) continue;
                int temp = numbers[j - 1];
                numbers[j - 1] = numbers[j];
                numbers[j] = temp;
            }
        }
    }

    private int[] removeRepeats(int[] positions) {
        Vector<Integer> vec = new Vector<Integer>();
        int temp = -1;
        for (int i = 0; i < positions.length; ++i) {
            if (positions[i] == temp || positions[i] == 0) continue;
            temp = positions[i];
            vec.add(new Integer(temp));
        }
        int[] distinct = new int[vec.size()];
        int index = 0;
        Enumeration e = vec.elements();
        while (e.hasMoreElements()) {
            distinct[index] = (Integer)e.nextElement();
            ++index;
        }
        return distinct;
    }

    private void _debug(String msg) {
        DebugUtility.debug(msg);
    }

    public void allowDataColumnSelection(boolean value) {
        this._allowDataColumnSelection = value;
    }

    public boolean allowDataColumnSelection() {
        return this._allowDataColumnSelection;
    }

    public void selectColumn(int column) {
        if (this.allowDataColumnSelection() && this._columnDisplay != null) {
            if (column < 0 || column > this._columnDisplay.getGrid().getColumnCount()) {
                try {
                    this._columnDisplay.getGrid().deselectAll();
                }
                catch (PropertyVetoException e) {}
            } else {
                TwoDSelection selection = new TwoDSelection(column, false);
                try {
                    this._columnDisplay.getGrid().setSelection(selection);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                this._columnDisplay.getGrid().scrollColumnIntoView(column);
            }
        }
    }

    public void setType(int type) {
        if (4 != this._type) {
            this._oldType = this._type;
        }
        if (this._type != type) {
            this._type = type;
            this._initialized = false;
        }
    }

    public void showPromptCheckbox(boolean value) {
        this._showPromptCheckbox = value;
        this._initialized = false;
    }

    public void addPromptListener(ItemListener listener) {
        this._promptCb.addItemListener(listener);
    }

    public void refreshContents(FlatFileInfo info) {
        this.refreshContents(info, null);
    }

    public void previewContents(FlatFileInfo info, String recordName) {
        this._previewing = true;
        this.refreshContents(info, recordName);
        this._previewing = false;
    }

    public void refreshContents(FlatFileInfo info, String recordName) {
        this._debug("refreshContents( FlatFileInfo , \"" + recordName + "\")");
        String shortenedName = CommonUtils.shortenLongPath(info.getFileName());
        String toolTipLabel = this._owner.translate("GZ_displayTitle_FlatFile", new String[]{info.getFileName()});
        String label = this._owner.translate("GZ_displayTitle_FlatFile", new String[]{shortenedName});
        this._fileLabel.setText(label);
        this._fileLabel.setToolTipText(toolTipLabel);
        if (4 == this._type) {
            this.setType(this._oldType);
        }
        if (!this._initialized) {
            this.buildPanel(info);
            this._initialized = true;
        }
        switch (this._type) {
            case 1: {
                this._debug("refreshContents.TEXT_ONLY_FORMAT");
                this._textDisplay.setText(info.getDisplayableData(recordName));
                break;
            }
            case 2: {
                this._debug("refreshContents.RULER_FORMAT");
                this._textDisplay.setText(info.getDisplayableData(recordName));
                int[] marks = info.getColumnMarkers(recordName);
                this.updateFieldWidthsDisplay(marks);
                this._ruler.setScrollPosition(0);
                this.setMarkedColumns(marks);
                break;
            }
            case 3: {
                this._debug("refreshContents.COLUMN_FORMAT");
                ArrayTwoDModel display_data = info.getFormattedColumnDataSource(recordName);
                int num_columns = display_data.getColumnCount();
                int[] field_widths = info.getColumnWidths((TwoDModel)display_data);
                OneDModel display_headers = info.getColumnHeaderDataSource(recordName);
                int num_headers = display_headers.getItemCount();
                if (display_data.getRowCount() == 0) {
                    this.setType(4);
                    this.buildPanel(info);
                    this._initialized = true;
                    break;
                }
                if (num_columns != num_headers) {
                    if (this._previewing) {
                        this.setType(4);
                        this.buildPanel(info);
                        this._initialized = true;
                        String[] args = new String[]{info.getSameAsName()};
                        this._errorDisplay.setText(this._owner.translate("GZ_displayErrDataDefinitionMismatch_API27", args));
                        break;
                    }
                    if (num_headers > num_columns) {
                        num_headers = num_columns;
                    }
                }
                this._columnDisplay.setModels((TwoDModel)display_data, display_headers, null);
                FontMetrics fm = this._columnDisplay.getFontMetrics(this._displayFont);
                int charSize = fm.charWidth('1');
                for (int i = 0; i < num_headers; ++i) {
                    String header = (String)display_headers.getData(i);
                    int col_size = header.length() > field_widths[i] ? header.length() : field_widths[i];
                    int width = (col_size + 1) * charSize;
                    this._columnDisplay.setColumnWidth(i, width);
                }
                Appearance app = this._columnDisplay.getGrid().getAppearanceManager().getCellPaintingAppearance(0, 0);
                app.setBackground(UIManager.getColor(LookAndFeel.LIGHT_INTENSITY));
                app.setBackground(Color.LIGHT_GRAY);
                Header column_header = this._columnDisplay.getColumnHeader();
                for (int i = 0; i < num_headers; ++i) {
                    Appearance header_app = column_header.getItemAppearance(i);
                    header_app.setHorizontalJustify(1);
                    column_header.setItemAppearance(i, header_app);
                }
                break;
            }
        }
    }

    public void setGizmoText(FlatFileInfo info, String text) {
        this._debug("refreshContents( FlatFileInfo , \"" + text + "\")");
        String shortenedName = CommonUtils.shortenLongPath(text);
        String toolTipLabel = this._owner.translate("GZ_displayTitle_FlatFile", new String[]{text});
        String label = this._owner.translate("GZ_displayTitle_FlatFile", new String[]{shortenedName});
        this._fileLabel.setText(label);
        this._fileLabel.setToolTipText(toolTipLabel);
        if (4 == this._type) {
            this.setType(this._oldType);
        }
        if (!this._initialized) {
            this.buildPanel(info);
            this._initialized = true;
        }
        switch (this._type) {
            case 1: {
                this._debug("refreshContents.TEXT_ONLY_FORMAT");
                this._textDisplay.setText(info.getRecordData(text));
                break;
            }
            case 2: {
                this._debug("refreshContents.RULER_FORMAT");
                try {
                    this._textDisplay.setText(text);
                    this._textDisplay.repaint();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                int[] marks = info.getColumnMarkers("");
                if (marks.length == 0) {
                    marks = new int[]{text.length()};
                }
                this.updateFieldWidthsDisplay(marks);
                this._ruler.setScrollPosition(0);
                this.setMarkedColumns(marks);
                break;
            }
            case 3: {
                this._debug("refreshContents.COLUMN_FORMAT");
                ArrayTwoDModel display_data = info.getDelimitedColumnDataSource(text, this._delimiter);
                int num_columns = display_data.getColumnCount();
                int[] field_widths = info.getColumnWidths((TwoDModel)display_data);
                OneDModel display_headers = info.getDelimitedColumnHeaderDataSource(text, this._delimiter);
                int num_headers = display_headers.getItemCount();
                if (display_data.getRowCount() == 0) {
                    this.setType(4);
                    this.buildPanel(info);
                    this._initialized = true;
                    break;
                }
                if (num_columns != num_headers) {
                    if (this._previewing) {
                        this.setType(4);
                        this.buildPanel(info);
                        this._initialized = true;
                        String[] args = new String[]{info.getSameAsName()};
                        this._errorDisplay.setText(this._owner.translate("GZ_displayErrDataDefinitionMismatch_API27", args));
                        break;
                    }
                    if (num_headers > num_columns) {
                        num_headers = num_columns;
                    }
                }
                this._columnDisplay.setModels((TwoDModel)display_data, display_headers, null);
                FontMetrics fm = this._columnDisplay.getFontMetrics(this._displayFont);
                int charSize = fm.charWidth('1');
                for (int i = 0; i < num_headers; ++i) {
                    String header = (String)display_headers.getData(i);
                    int col_size = header.length() > field_widths[i] ? header.length() : field_widths[i];
                    int width = (col_size + 1) * charSize;
                    this._columnDisplay.setColumnWidth(i, width);
                }
                Appearance app = this._columnDisplay.getGrid().getAppearanceManager().getCellPaintingAppearance(0, 0);
                app.setBackground(UIManager.getColor(LookAndFeel.LIGHT_INTENSITY));
                app.setBackground(Color.LIGHT_GRAY);
                Header column_header = this._columnDisplay.getColumnHeader();
                for (int i = 0; i < num_headers; ++i) {
                    Appearance header_app = column_header.getItemAppearance(i);
                    header_app.setHorizontalJustify(1);
                    column_header.setItemAppearance(i, header_app);
                }
                break;
            }
        }
    }

    public void setEditGizmoText(FlatFileInfo info, String text, String recordname) {
        this._debug("refreshContents( FlatFileInfo , \"" + text + "\")");
        if (text.equals("")) {
            this.setVisible(false);
            return;
        }
        String shortenedName = CommonUtils.shortenLongPath(text);
        String toolTipLabel = this._owner.translate("GZ_displayTitle_FlatFile", new String[]{text});
        String label = this._owner.translate("GZ_displayTitle_FlatFile", new String[]{shortenedName});
        this._fileLabel.setText(label);
        this._fileLabel.setToolTipText(toolTipLabel);
        if (4 == this._type) {
            this.setType(this._oldType);
        }
        if (!this._initialized) {
            this.buildPanel(info);
            this._initialized = true;
        }
        switch (this._type) {
            case 1: {
                this._debug("refreshContents.TEXT_ONLY_FORMAT");
                this._textDisplay.setText(info.getRecordData(text));
                break;
            }
            case 2: {
                this._debug("refreshContents.RULER_FORMAT");
                try {
                    if (!text.equals("")) {
                        this._textDisplay.setText(text);
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                int[] marks = this.removeZeroLengthMarkedColumns(info.getColumnMarkers(recordname));
                if (marks.length == 0) {
                    marks = new int[]{text.length()};
                    info.setColumnStartPositions(recordname, marks);
                    marks = info.getColumnMarkers(recordname);
                }
                this.updateFieldWidthsDisplay(marks);
                this._ruler.setScrollPosition(0);
                this.setMarkedColumns(marks);
                break;
            }
        }
    }

    private void updateFieldWidthsDisplay(int[] marks) {
        if (this._settingMarks) {
            this._debug("updateFieldWidthsDisplay(...) early break on _settingMarks");
            return;
        }
        int num_marks = marks.length;
        String value = "";
        if (num_marks > 0) {
            value = value + marks[0];
            for (int i = 1; i < num_marks; ++i) {
                value = value + ", " + marks[i];
            }
        }
        this._debug("updateFieldWidthsDisplay([" + value + "])");
        this._fieldWidths.setText(value);
    }

    @Override
    public void rulerDragged(FlatFileRulerEvent e) {
        int[] markedColumns = this.getMarkedColumns();
        this.updateFieldWidthsDisplay(markedColumns);
    }

    @Override
    public void rulerSet(FlatFileRulerEvent e) {
        this.updateFieldWidthsDisplay(this.getMarkedColumns());
    }

    @Override
    public void rulerDeleted(FlatFileRulerEvent e) {
        this.updateFieldWidthsDisplay(this.getMarkedColumns());
    }

    public int[] getMarkedColumns() {
        return this._ruler.getMarkedColumns();
    }

    private int[] removeZeroLengthMarkedColumns(int[] markedCols) {
        ArrayList<Integer> markedColList = new ArrayList<Integer>();
        if (markedCols.length > 0) {
            for (int i = 0; i < markedCols.length; ++i) {
                if (markedCols[i] == 0) continue;
                markedColList.add(markedCols[i]);
            }
            int[] result = new int[markedColList.toArray().length];
            int i = 0;
            Iterator it = markedColList.iterator();
            while (it.hasNext()) {
                String value = it.next().toString();
                result[i] = Integer.parseInt(value);
                ++i;
            }
            return result;
        }
        return markedCols;
    }

    public JTextField getWidthsTextField() {
        return this._fieldWidths;
    }

    public int getType() {
        return this._type;
    }

    public void setMarkedColumns(int[] columns) {
        this._settingMarks = true;
        this._ruler.setMarkedColumns(columns);
        this._settingMarks = false;
        this.updateFieldWidthsDisplay(columns);
    }

    private void buildPanel(FlatFileInfo info) {
        this.removeAll();
        this.setLayout(new GridBagLayout());
        String shortenedName = CommonUtils.shortenLongPath(info.getFileName());
        String toolTipLabel = this._owner.translate("GZ_displayTitle_FlatFile", new String[]{info.getFileName()});
        String label = this._owner.translate("GZ_displayTitle_FlatFile", new String[]{shortenedName});
        this._fileLabel.setText(label);
        this._fileLabel.setToolTipText(toolTipLabel);
        switch (this._type) {
            case 1: 
            case 2: {
                this.buildPanelText(info);
                break;
            }
            case 3: {
                this.buildPanelColumns(info);
                break;
            }
            case 4: {
                this.buildPanelError(info);
                break;
            }
        }
        this.validate();
    }

    private void buildPanelText(FlatFileInfo info) {
        Insets insets;
        this._textDisplay = new FlatFileTextArea();
        this._textDisplay.setBackground(Color.LIGHT_GRAY);
        this._textDisplay.setEditable(false);
        this._textDisplay.setFont(this._displayFont);
        this._textDisplay.setTabSize(1);
        this._ruler.setBackground(Color.white);
        this._ruler.addRulerListener(this._textDisplay);
        this._ruler.addRulerListener(this);
        EWTScrollPane scroll_box = new EWTScrollPane((Component)this._textDisplay, 20, 30);
        this._textDisplay.setScrollBox(scroll_box);
        FlatFileScroller scroller = new FlatFileScroller(this._ruler);
        this._textDisplay.setScroller(scroller);
        scroll_box.getHorizontalScrollBar().addAdjustmentListener(scroller);
        FontMetrics fm = this._textDisplay.getFontMetrics(this._displayFont);
        int char_height = fm.getHeight();
        scroll_box.setAlignmentY((float)char_height);
        JScrollPane pane = new JScrollPane(this._textDisplay);
        pane.setPreferredSize(new Dimension(527, 40));
        int top_row = 0;
        if (this._showPromptCheckbox) {
            insets = new Insets(3, 3, 3, 3);
            WBTranslatableDialog.addComponent(this, this._promptCb, 0, top_row, 1, 1, 0.0, 0.0, 17, 2, insets);
            ++top_row;
        }
        if (this._type == 2) {
            insets = new Insets(0, 6, 0, 3);
            JPanel widths = new JPanel();
            widths.setLayout(new GridBagLayout());
            WBTranslatableDialog.addComponent(this, widths, 0, top_row, 1, 1, 0.0, 0.0, 17, 2, insets);
            ++top_row;
            Insets bottom3 = new Insets(0, 0, 3, 0);
            JLabel tempLabel = new JLabel(this._owner.translate("GZ_displayFieldWidths_FlatFile"));
            CommonUtils.setMnemonicAndAccelerator(tempLabel, NLSUtils.getNLSString("GZ_displayFieldWidths_FlatFile"));
            tempLabel.setLabelFor(this._fieldWidths);
            WBTranslatableDialog.addComponent(widths, tempLabel, 0, 0, 1, 1, 0.0, 0.0, 11, 2, bottom3);
            WBTranslatableDialog.addComponent(widths, this._fieldWidths, 1, 0, 1, 1, 1.0, 1.0, 11, 2, bottom3);
            pane.setColumnHeaderView((Component)((Object)this._ruler));
        }
        insets = new Insets(0, 3, 3, 3);
        WBTranslatableDialog.addComponent(this, pane, 0, top_row, 1, 1, 1.0, 1.0, 17, 1, insets);
    }

    private void buildPanelColumns(FlatFileInfo info) {
        try {
            this._columnDisplay.setFont(this._displayFont);
            this._columnDisplay.setDefaultColumnWidth(100);
            this._columnDisplay.setHorizontalSeparatorsVisible(false);
            this._columnDisplay.setVerticalSeparatorsVisible(true);
            if (this.allowDataColumnSelection()) {
                this._columnDisplay.getGrid().setGridSelectionManager((GridSelectionManager)new GeneralGridSelectionManager(1, 0, 0));
            } else {
                this._columnDisplay.getGrid().setGridSelectionManager((GridSelectionManager)new GeneralGridSelectionManager(0, 0, 0));
            }
            int top_row = 0;
            if (this._showPromptCheckbox) {
                Insets insets = new Insets(3, 3, 3, 3);
                WBTranslatableDialog.addComponent(this, this._promptCb, 0, top_row, 1, 1, 0.0, 0.0, 17, 2, insets);
                ++top_row;
            }
            JScrollPane scroll_box = new JScrollPane((Component)this._columnDisplay, 20, 30);
            Insets insets = new Insets(6, 3, 3, 3);
            WBTranslatableDialog.addComponent(this, scroll_box, 0, top_row, 2, 1, 1.0, 1.0, 17, 1, insets);
            scroll_box.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void buildPanelError(FlatFileInfo info) {
        this._errorDisplay = new MultiLineLabel(WordWrapper.getTextWrapper(), "");
        int top_row = 0;
        Insets insets = new Insets(0, 3, 3, 3);
        WBTranslatableDialog.addComponent(this, (Component)this._errorDisplay, 0, top_row, 1, 1, 1.0, 1.0, 17, 1, insets);
    }

    public void addRulerListener(FlatFileRulerListener listener) {
        if (this._ruler == null) {
            this._debug("Can't set listener for a non-existent ruler!");
            return;
        }
        this._ruler.addRulerListener(listener);
    }

    public void setDelimiter(String delimiter) {
        this._delimiter = delimiter;
    }

    public String getDelimiter() {
        return this._delimiter;
    }

    public FlatFileRuler getRuler() {
        return this._ruler;
    }

    public FlatFileTextArea getTextArea() {
        return this._textDisplay;
    }

    public SpreadTable getColumnDisplay() {
        return this._columnDisplay;
    }

    private class WidthTextField
    extends JTextField {
        @Override
        protected void processKeyEvent(KeyEvent e) {
            String old_text = this.getText();
            if (e.getID() != 400) {
                super.processKeyEvent(e);
                return;
            }
            if (e.getID() != 401) {
                super.processKeyEvent(e);
                return;
            }
            char c = e.getKeyChar();
            boolean consume = true;
            if (c == ' ' || c == ',' || c >= '0' && c <= '9') {
                consume = false;
            }
            if (consume) {
                e.consume();
            }
            super.processKeyEvent(e);
            if (!consume && !this.validateText(this.getText())) {
                Toolkit.getDefaultToolkit().beep();
                this.setText(old_text);
            }
        }

        protected boolean validateText(String text) {
            return true;
        }
    }
}

