/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.PlainDocument;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.CommonUtils;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileDisplayGizmo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileValidationException;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WBTranslatable;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WBTranslatablePanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.DebugUtility;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.NLSUtils;

public class FlatFileDelimitedAttribPanel
extends WBTranslatablePanel {
    private FlatFileInfo _ffInfo;
    private FlatFileDisplayGizmo _dataGizmo = null;
    private MultiLineLabel _dummyLabel;
    private MultiLineLabel _fieldIdLabel;
    private JLabel _delimiterLabel;
    private JComboBox _delimiterChoice;
    private JLabel _enclLabel;
    private JLabel _enclosureLeftLabel;
    private JComboBox _enclosureLeftChoice;
    private JLabel _recordTerminatorLabel;
    private JComboBox _recordTerminatorChoice;
    private WizardPage _wp;

    public FlatFileDelimitedAttribPanel(WBTranslatable t, WizardPage wp) {
        super(t);
        this._wp = wp;
        this._debug("FlatFileDelimitedAttribPanel()");
        this._delimiterLabel = new JLabel(this.translate("DA_delimitedColDelimiterHeading_FlatFile"));
        this._delimiterChoice = new JComboBox();
        this._delimiterChoice.setEditable(true);
        this._delimiterLabel.setLabelFor(this._delimiterChoice);
        CommonUtils.setMnemonicAndAccelerator(this._delimiterLabel, NLSUtils.getNLSString("DA_delimitedColDelimiterHeading_FlatFile"));
        ItemListener delimiterChangedListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    FlatFileDelimitedAttribPanel.this._debug("DA_delimiterChangedListener.getSelectedItem = " + FlatFileDelimitedAttribPanel.this._delimiterChoice.getSelectedItem());
                    FlatFileDelimitedAttribPanel.this.delimiterValueChanged((String)FlatFileDelimitedAttribPanel.this._delimiterChoice.getSelectedItem());
                }
            }
        };
        this._delimiterChoice.addItemListener(delimiterChangedListener);
        ActionListener delimiterTextListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlatFileDelimitedAttribPanel.this._debug("DA_delimiterTextListener.getSelectedItem = " + FlatFileDelimitedAttribPanel.this._delimiterChoice.getSelectedItem());
                FlatFileDelimitedAttribPanel.this.delimiterValueChanged((String)FlatFileDelimitedAttribPanel.this._delimiterChoice.getSelectedItem());
            }
        };
        this._delimiterChoice.addActionListener(delimiterTextListener);
        KeyAdapter delimiterKeyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int code = e.getKeyCode();
                if (code == 10) {
                    e.consume();
                }
            }
        };
        this._delimiterChoice.addKeyListener(delimiterKeyListener);
        JTextField editor = (JTextField)this._delimiterChoice.getEditor().getEditorComponent();
        int MAX_CHARACTERS = 1;
        Document styledDoc = editor.getDocument();
        if (styledDoc instanceof PlainDocument) {
            ((PlainDocument)styledDoc).setDocumentFilter(new ComboSizeFilter(MAX_CHARACTERS));
        }
        this._enclLabel = new JLabel(this.translate("DA_delimitedColEnclosureHeading_FlatFile"));
        this._enclosureLeftLabel = new JLabel(this.translate("DA_delimitedColEnclosureLeft_FlatFile"));
        this._enclosureLeftChoice = new JComboBox();
        this._enclosureLeftChoice.setEditable(true);
        editor = (JTextField)this._enclosureLeftChoice.getEditor().getEditorComponent();
        styledDoc = editor.getDocument();
        if (styledDoc instanceof PlainDocument) {
            ((PlainDocument)styledDoc).setDocumentFilter(new ComboSizeFilter(MAX_CHARACTERS));
        }
        this._enclLabel.setLabelFor(this._enclosureLeftChoice);
        CommonUtils.setMnemonicAndAccelerator(this._enclLabel, NLSUtils.getNLSString("DA_delimitedColEnclosureHeading_FlatFile"));
        ItemListener _enclosureLeftItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    FlatFileDelimitedAttribPanel.this._debug("enclosureLeftItemListener.getSelectedItem = " + FlatFileDelimitedAttribPanel.this._enclosureLeftChoice.getSelectedItem());
                    FlatFileDelimitedAttribPanel.this.enclosureLeftSelected();
                }
            }
        };
        this._enclosureLeftChoice.addItemListener(_enclosureLeftItemListener);
        ActionListener _enclosureLeftTextListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlatFileDelimitedAttribPanel.this._debug("enclosureLeftTextListener.getSelectedItem = " + FlatFileDelimitedAttribPanel.this._enclosureLeftChoice.getSelectedItem());
                FlatFileDelimitedAttribPanel.this.enclosureLeftChanged();
            }
        };
        this._enclosureLeftChoice.addActionListener(_enclosureLeftTextListener);
        this._recordTerminatorLabel = new JLabel(this.translate("DA_generalRecordsDelimitedBy_FlatFile"));
        this._recordTerminatorChoice = new JComboBox();
        this._recordTerminatorChoice.setEditable(true);
        this._recordTerminatorChoice.addItem("<CR>");
        this._recordTerminatorChoice.addItem("\\n");
        this._recordTerminatorLabel.setLabelFor(this._recordTerminatorChoice);
        this._fieldIdLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), this.translate("DA_generalFieldIdIntro_FlatFile"));
        this._dummyLabel = new MultiLineLabel(" ");
    }

    private void _debug(String msg) {
        if (this._debug_on) {
            DebugUtility.debug(msg);
        }
    }

    public void initPropertiesLayout() {
        this._debug("initPropertiesLayout()");
        Insets cmpInsets = new Insets(0, 3, 3, 3);
        this.setLayout(new GridBagLayout());
        FlatFileDelimitedAttribPanel.addComponent(this, this._delimiterLabel, 0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 3));
        FlatFileDelimitedAttribPanel.addComponent(this, this._delimiterChoice, 1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3));
        FlatFileDelimitedAttribPanel.addComponent(this, this._enclLabel, 0, 1, 1, 1, 0.0, 0.0, 17, 0, cmpInsets);
        FlatFileDelimitedAttribPanel.addComponent(this, this._enclosureLeftLabel, 0, 2, 1, 1, 0.0, 0.0, 17, 0, cmpInsets);
        FlatFileDelimitedAttribPanel.addComponent(this, this._enclosureLeftChoice, 1, 2, 1, 1, 1.0, 0.0, 17, 0, cmpInsets);
    }

    public void initWizardLayout() {
        this._debug("initWizardLayout()");
        Insets cmpInsets = new Insets(0, 0, 0, 0);
        Insets pnlInsets = new Insets(0, 0, 0, 0);
        Insets indentInsets = new Insets(0, 0, 0, 0);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.GRAY), this.translate("DA_fieldLevelDelimiters_borderText", new String[]{""})));
        FlatFileDelimitedAttribPanel.addComponent(this, this._delimiterLabel, 0, 0, 1, 1, 0.0, 0.0, 17, 0, indentInsets);
        FlatFileDelimitedAttribPanel.addComponent(this, this._delimiterChoice, 1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(1, 15, 2, 3));
        FlatFileDelimitedAttribPanel.addComponent(this, this._enclLabel, 0, 1, 1, 1, 0.0, 0.0, 17, 0, indentInsets);
        FlatFileDelimitedAttribPanel.addComponent(this, this._enclosureLeftChoice, 1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 15, 2, 3));
    }

    public void initializeFrom(FlatFileInfo ffi) {
        int i;
        int i2;
        String delimiter;
        int i3;
        this._debug("initializeFrom()");
        this._ffInfo = ffi;
        ActionListener[] als = this._delimiterChoice.getActionListeners();
        ItemListener[] ils = this._delimiterChoice.getItemListeners();
        for (i3 = 0; i3 < als.length; ++i3) {
            this._delimiterChoice.removeActionListener(als[i3]);
        }
        for (i3 = 0; i3 < ils.length; ++i3) {
            this._delimiterChoice.removeItemListener(ils[i3]);
        }
        String string = delimiter = this._ffInfo.getDelimiter() == null || this._ffInfo.getDelimiter().equals("") ? "  " : this._ffInfo.getDelimiter();
        if (this._delimiterChoice.getItemCount() == 0) {
            String[] choices = this._ffInfo.getDelimiterInitialList();
            for (i2 = 0; i2 < choices.length; ++i2) {
                this._delimiterChoice.addItem(choices[i2]);
            }
        }
        this.setRawDelimiterValue(delimiter);
        for (i = 0; i < als.length; ++i) {
            this._delimiterChoice.addActionListener(als[i]);
        }
        for (i = 0; i < ils.length; ++i) {
            this._delimiterChoice.addItemListener(ils[i]);
        }
        als = this._enclosureLeftChoice.getActionListeners();
        ils = this._enclosureLeftChoice.getItemListeners();
        for (i = 0; i < als.length; ++i) {
            this._enclosureLeftChoice.removeActionListener(als[i]);
        }
        for (i = 0; i < ils.length; ++i) {
            this._enclosureLeftChoice.removeItemListener(ils[i]);
        }
        String encls = this._ffInfo.getEnclosureLeft();
        if (this._enclosureLeftChoice.getItemCount() == 0) {
            FlatFileDelimitedAttribPanel flatFileDelimitedAttribPanel = this;
            String[] encChoices = flatFileDelimitedAttribPanel._ffInfo.getEnclosureLeftInitialList();
            for (int i4 = 0; i4 < encChoices.length; ++i4) {
                this._enclosureLeftChoice.addItem(encChoices[i4]);
            }
        }
        if (this._ffInfo.isEnclosedLeft()) {
            this.addValueToComboBox(this._enclosureLeftChoice, encls);
        } else {
            this._enclosureLeftChoice.setSelectedItem("");
        }
        for (i2 = 0; i2 < als.length; ++i2) {
            this._enclosureLeftChoice.addActionListener(als[i2]);
        }
        for (i2 = 0; i2 < ils.length; ++i2) {
            this._enclosureLeftChoice.addItemListener(ils[i2]);
        }
        this.addValueToComboBox(this._recordTerminatorChoice, this._ffInfo.getRecordTerminator());
        this.validate();
    }

    private void delimiterValueChanged(String newTxt) {
        this._debug("delimiterValueChanged( " + newTxt + " )");
        String oldDelim = this._ffInfo.getDelimiter();
        String newDelim = newTxt;
        if (newTxt.equals("")) {
            this._wp.setCanAdvance(false);
        } else {
            this._wp.setCanAdvance(true);
        }
        if (!oldDelim.equals(newDelim)) {
            if ((this._ffInfo.isSingleInstance() || !this._ffInfo.isMultiRecord()) && this._ffInfo.useFirstRowAsFieldNames()) {
                this._ffInfo.setSkipRecords(this._ffInfo.getSkipRecords() - 1);
                this._ffInfo.useFirstRowAsFieldNamesEdit(false);
                this._ffInfo.useFirstRowAsFieldNames(false);
            }
            if (newDelim.equals(this.translate("DA_delimitedColDelimiterWhiteSpace_FlatFile"))) {
                newDelim = "  ";
            } else if (newDelim.equals(this.translate("DA_delimitedColDelimiterComma_FlatFile"))) {
                newDelim = ",";
            } else if (newDelim.equals(this.translate("DA_delimitedColDelimiterSemicolon_FlatFile"))) {
                newDelim = ";";
            } else if (newDelim.equals(this.translate("DA_delimitedColDelimiterTab_FlatFile"))) {
                newDelim = "\\t";
            } else if (newDelim.equals(this.translate("DA_delimitedColDelimiterSpace_FlatFile"))) {
                newDelim = " ";
            }
        }
        if (!oldDelim.equals(newDelim)) {
            this.setRawDelimiterValue(newDelim);
            this._ffInfo.setDelimiter(newDelim);
            if (this._dataGizmo != null) {
                this._ffInfo.clearRecords();
                this.refreshDataGizmo();
            }
        }
    }

    private void setRawDelimiterValue(String newDelim) {
        if (newDelim.equals("  ")) {
            this._delimiterChoice.setSelectedItem(this.translate("DA_delimitedColDelimiterWhiteSpace_FlatFile"));
        } else if (newDelim.equals(",")) {
            this._delimiterChoice.setSelectedItem(this.translate("DA_delimitedColDelimiterComma_FlatFile"));
        } else if (newDelim.equals(";")) {
            this._delimiterChoice.setSelectedItem(this.translate("DA_delimitedColDelimiterSemicolon_FlatFile"));
        } else if (newDelim.equals("\\t")) {
            this._delimiterChoice.setSelectedItem(this.translate("DA_delimitedColDelimiterTab_FlatFile"));
        } else if (newDelim.equals(" ")) {
            this._delimiterChoice.setSelectedItem(this.translate("DA_delimitedColDelimiterSpace_FlatFile"));
        } else {
            this.addValueToComboBox(this._delimiterChoice, newDelim);
        }
    }

    private void enclosureLeftSelected() {
        this._debug("enclosureLeftSelected()");
        String enclosureLeft = (String)this._enclosureLeftChoice.getSelectedItem();
        this._ffInfo.setEnclosureLeft(enclosureLeft);
        if (this._dataGizmo != null) {
            this._ffInfo.clearRecords();
            this.refreshDataGizmo();
        }
    }

    private void enclosureLeftChanged() {
        this._debug("enclosureLeftChanged()");
        String enclosureLeft = (String)this._enclosureLeftChoice.getSelectedItem();
        this._ffInfo.setEnclosureLeft(enclosureLeft);
        if ((this._ffInfo.isSingleInstance() || !this._ffInfo.isMultiRecord()) && this._ffInfo.useFirstRowAsFieldNames()) {
            this._ffInfo.setSkipRecords(this._ffInfo.getSkipRecords() - 1);
            this._ffInfo.useFirstRowAsFieldNamesEdit(false);
            this._ffInfo.useFirstRowAsFieldNames(false);
        }
        this._ffInfo.setEnclosureRight(enclosureLeft);
        if (this._dataGizmo != null) {
            this._ffInfo.clearRecords();
            this.refreshDataGizmo();
        }
        if (enclosureLeft != null && enclosureLeft.length() != 0) {
            this.addValueToComboBox(this._enclosureLeftChoice, enclosureLeft);
        }
    }

    private void recordTerminatorChanged(String newTxt) {
        this._debug("recordTerminatorChanged( " + newTxt + " )");
        this._ffInfo.setRecordTerminator(newTxt);
        this.refreshDataGizmo();
        this.addValueToComboBox(this._recordTerminatorChoice, newTxt);
    }

    private void addValueToComboBox(JComboBox comboBox, String newValue) {
        boolean found = false;
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            if (newValue.compareTo((String)comboBox.getItemAt(i)) != 0) continue;
            found = true;
            break;
        }
        if (!found) {
            try {
                this._debug("addValueToComboBox( " + newValue + " )");
                comboBox.addItem(newValue);
            }
            catch (Exception e) {
                this._debug("adding stuff erred");
            }
        }
        this._debug("select string = " + newValue);
        comboBox.setSelectedItem(newValue);
    }

    public boolean validatePanel() throws FlatFileValidationException {
        if (this._ffInfo == null || this._ffInfo.getDelimiter() == null || this._ffInfo.getDelimiter().length() == 0 || this._ffInfo.getRecordTerminator() == null) {
            throw new FlatFileValidationException(this.translate("DA_generalErrDelimiter_API17"));
        }
        String enclosureRight = "";
        String enclosureLeft = "";
        String Delim = "";
        if (this._ffInfo.isEnclosedLeft()) {
            enclosureLeft = this._ffInfo.getEnclosureLeft();
        }
        if ((Delim = this._ffInfo.getDelimiter()).equals(enclosureRight) || Delim.equals(enclosureLeft)) {
            throw new FlatFileValidationException(this.translate("DA_generalErrDelimiter_API30"));
        }
        return true;
    }

    public void setAttributesEnabled(boolean enabled) {
        this._delimiterLabel.setEnabled(enabled);
        this._delimiterChoice.setEnabled(enabled);
        this._enclLabel.setEnabled(enabled);
        this._enclosureLeftLabel.setEnabled(enabled);
        this._enclosureLeftChoice.setEnabled(enabled);
    }

    public void requestFocusOnDelimiter() {
        this._delimiterChoice.requestFocus();
    }

    public void setDataGizmo(FlatFileDisplayGizmo dataGizmo) {
        this._dataGizmo = dataGizmo;
    }

    public FlatFileDisplayGizmo getDataGizmo() {
        return this._dataGizmo;
    }

    private void refreshDataGizmo() {
        if (null != this._dataGizmo) {
            this._debug("refreshDataGizmo()");
            this._dataGizmo.refreshContents(this._ffInfo);
        }
    }

    private class ComboSizeFilter
    extends DocumentFilter {
        int maxCharacters;
        boolean DEBUG = false;

        public ComboSizeFilter(int maxChars) {
            this.maxCharacters = maxChars;
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offs, String str, AttributeSet a) throws BadLocationException {
            if (this.DEBUG) {
                DebugUtility.debug("in DocumentSizeFilter's insertString method");
            }
            if (fb.getDocument().getLength() + str.length() <= this.maxCharacters) {
                super.insertString(fb, offs, str, a);
            } else {
                String passedValue = fb.getDocument() + str;
                if (passedValue.equals(FlatFileDelimitedAttribPanel.this.translate("FI_generalColDelimiterWhiteSpace_FlatFile")) || passedValue.equals(FlatFileDelimitedAttribPanel.this.translate("FI_generalColDelimiterComma_FlatFile")) || passedValue.equals(FlatFileDelimitedAttribPanel.this.translate("FI_generalColDelimiterSemicolon_FlatFile")) || passedValue.equals(FlatFileDelimitedAttribPanel.this.translate("FI_generalColDelimiterTab_FlatFile")) || passedValue.equals(FlatFileDelimitedAttribPanel.this.translate("FI_generalColDelimiterSpace_FlatFile"))) {
                    super.insertString(fb, offs, str, a);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offs, int length, String str, AttributeSet a) throws BadLocationException {
            if (this.DEBUG) {
                DebugUtility.debug("in DocumentSizeFilter's replace method");
            }
            if (fb.getDocument().getLength() + str.length() - length <= this.maxCharacters) {
                super.replace(fb, offs, length, str, a);
            } else {
                String passedValue = str;
                if (passedValue.equals(FlatFileDelimitedAttribPanel.this.translate("FI_generalColDelimiterWhiteSpace_FlatFile")) || passedValue.equals(FlatFileDelimitedAttribPanel.this.translate("FI_generalColDelimiterComma_FlatFile")) || passedValue.equals(FlatFileDelimitedAttribPanel.this.translate("FI_generalColDelimiterSemicolon_FlatFile")) || passedValue.equals(FlatFileDelimitedAttribPanel.this.translate("FI_generalColDelimiterTab_FlatFile")) || passedValue.equals(FlatFileDelimitedAttribPanel.this.translate("FI_generalColDelimiterSpace_FlatFile"))) {
                    super.replace(fb, offs, length, str, a);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }
    }
}

