/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.CommonUtils;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileDisplayGizmo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileValidationException;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileWizard;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.NxsdFileInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WBTranslatable;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WizardInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WizardPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WizardPanelValidationException;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.DebugUtility;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.NLSUtils;

public class FlatFileComplexSampleNamePanel
extends WizardPanel {
    private FlatFileInfo ff_info;
    private JLabel _nameFileNameIntro;
    private JLabel _nameFileStructureNameLbl;
    private JTextField _nameFileStructureName;
    private JLabel _nameCharacterSetLbl;
    private JComboBox _nameCharacterSetLw;
    private NumberTextField _numRowsToProcess;
    private int _numRowsToProcessSave;
    private NumericSpinBox _numRowsToSkip;
    private int _numRowsToSkipSave;
    private JCheckBox _everythingCb;
    private NumberTextField _numDataRowsToProcess;
    private JCheckBox _allDataRowsCb;
    private WizardPage _wp;
    private FlatFileDisplayGizmo _dataGizmo;
    private JPanel _gizmoPanel;
    private JLabel _namespaceLabel;
    private JTextField _namespaceField;
    private JLabel _containerNameLabel;
    private JTextField _containerNameField;
    private JButton _fileBrowseButton;

    FlatFileComplexSampleNamePanel(WBTranslatable h) {
        super(h);
    }

    @Override
    public void buildPanel(WizardPage wp) {
        this._wp = wp;
        this.setLayout(new GridBagLayout());
        Insets pnlInsets = new Insets(3, 3, 0, 3);
        Insets cmpInsets = new Insets(2, 5, 2, 2);
        this._nameFileNameIntro = new JLabel(this.translate("NM_nameIntro_FlatFile"));
        FlatFileComplexSampleNamePanel.addComponent(this, this._nameFileNameIntro, 0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(3, 3, 3, 3));
        JPanel nameFileNamePanel = new JPanel();
        nameFileNamePanel.setLayout(new GridBagLayout());
        FlatFileComplexSampleNamePanel.addComponent(this, nameFileNamePanel, 0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(1, 3, 3, 5));
        this._gizmoPanel = new JPanel();
        this._gizmoPanel.setLayout(new GridBagLayout());
        FlatFileComplexSampleNamePanel.addComponent(this, this._gizmoPanel, 0, 2, 1, 1, 1.0, 0.7, 18, 1, pnlInsets);
        this._gizmoPanel.setVisible(false);
        JPanel nameCharacterSetPanel = new JPanel();
        nameCharacterSetPanel.setLayout(new GridBagLayout());
        FlatFileComplexSampleNamePanel.addComponent(this, nameCharacterSetPanel, 0, 3, 1, 1, 1.0, 0.3, 18, 2, new Insets(1, 3, 1, 5), 0, 20);
        this._nameFileStructureNameLbl = new JLabel(this.translate("GN_nameFileStructureName_FlatFile"));
        FlatFileComplexSampleNamePanel.addComponent(nameFileNamePanel, this._nameFileStructureNameLbl, 0, 0, 1, 1, 0.0, 0.0, 17, 0, cmpInsets);
        this._nameFileStructureName = new JTextField();
        this._nameFileStructureName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                FlatFileComplexSampleNamePanel.this.handlePageAdvance();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FlatFileComplexSampleNamePanel.this.handlePageAdvance();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FlatFileComplexSampleNamePanel.this.handlePageAdvance();
            }
        });
        KeyAdapter fileNameListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int code = e.getKeyCode();
                if ((code == 10 || code == 9) && code == 10) {
                    e.consume();
                }
            }
        };
        this._nameFileStructureName.addKeyListener(fileNameListener);
        this._nameFileStructureName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextField field = (JTextField)e.getSource();
                String fileName = field.getText();
                if (fileName == null || fileName.equals("") || FlatFileComplexSampleNamePanel.this.ff_info.getFileStructureName().equals(fileName)) {
                    return;
                }
                FlatFileComplexSampleNamePanel.this._nameFileStructureName.setText(fileName);
                FlatFileComplexSampleNamePanel.this.handlePageAdvance();
                try {
                    FlatFileComplexSampleNamePanel.this.ff_info.setFileStructureName(fileName);
                }
                catch (FlatFileValidationException ex) {
                    FlatFileComplexSampleNamePanel.this.showThisError(ex);
                }
                FlatFileComplexSampleNamePanel.this.initializeFrom(FlatFileComplexSampleNamePanel.this.ff_info);
                FlatFileComplexSampleNamePanel.this.nameCharacterSetStateChanged();
            }
        });
        this._nameFileStructureNameLbl.setLabelFor(this._nameFileStructureName);
        CommonUtils.setMnemonicAndAccelerator(this._nameFileStructureNameLbl, NLSUtils.getNLSString("GN_nameFileStructureName_FlatFile"));
        int fieldWidth = new Float(240.0).intValue();
        this._nameFileStructureName.setPreferredSize(new Dimension(fieldWidth, 20));
        FlatFileComplexSampleNamePanel.addComponent(nameFileNamePanel, this._nameFileStructureName, 1, 0, 1, 1, 1.0, 0.0, 17, 2, cmpInsets);
        this._fileBrowseButton = new JButton(this.translate("GN_browseButton"));
        this._fileBrowseButton.setToolTipText(this.translate("NM_FileBrowse_toolTip"));
        this._fileBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser;
                String prjDir = ((FlatFileComplexSampleNamePanel)FlatFileComplexSampleNamePanel.this).ff_info.getFlatFileWizard().getNxsdFileInfo()._directoryName;
                if (prjDir == null) {
                    prjDir = "";
                }
                if ((chooser = FlatFileComplexSampleNamePanel.this.ff_info.getFileChooser()) == null) {
                    chooser = new JFileChooser(prjDir);
                    chooser.setDialogTitle(FlatFileComplexSampleNamePanel.this.translate("NM_flatFileDialog_title"));
                }
                int returnVal = chooser.showOpenDialog(FlatFileComplexSampleNamePanel.this.getParentFrame());
                FlatFileComplexSampleNamePanel.this.ff_info.setFileChooser(chooser);
                String fileName = "";
                String directory = "";
                if (returnVal != 0) {
                    return;
                }
                fileName = chooser.getSelectedFile().getName();
                directory = chooser.getSelectedFile().getParent() + File.separator;
                if (directory != null && fileName != null) {
                    FlatFileComplexSampleNamePanel.this._nameFileStructureName.setText(directory + fileName);
                    FlatFileComplexSampleNamePanel.this.handlePageAdvance();
                    try {
                        FlatFileComplexSampleNamePanel.this.ff_info.setFileStructureName(directory + fileName);
                    }
                    catch (FlatFileValidationException ex) {
                        FlatFileComplexSampleNamePanel.this.showThisError(ex);
                    }
                    FlatFileComplexSampleNamePanel.this.initializeFrom(FlatFileComplexSampleNamePanel.this.ff_info);
                    FlatFileComplexSampleNamePanel.this.nameCharacterSetStateChanged();
                }
            }
        });
        CommonUtils.setMnemonicAndAccelerator(this._fileBrowseButton, NLSUtils.getNLSString("GN_browseButton"));
        FlatFileComplexSampleNamePanel.addComponent(nameFileNamePanel, this._fileBrowseButton, 2, 0, 1, 1, 1.0, 0.0, 17, 0, cmpInsets);
        this._dataGizmo = new FlatFileDisplayGizmo(1, this);
        FlatFileComplexSampleNamePanel.addComponent(this._gizmoPanel, this._dataGizmo, 0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(1, 1, 1, 1));
        JLabel numRowsToSkipLabel = new JLabel(this.translate("NM_fileOrgNumRowsToSkip_FlatFile"));
        FlatFileComplexSampleNamePanel.addComponent(nameCharacterSetPanel, numRowsToSkipLabel, 0, 0, 1, 1, 0.2, 0.0, 17, 0, cmpInsets);
        this._numRowsToSkip = new NumericSpinBox(0, 1000);
        numRowsToSkipLabel.setLabelFor((Component)this._numRowsToSkip);
        numRowsToSkipLabel.setToolTipText(this.translate("NM_skipRowsTooltip"));
        ChangeListener skipRowsListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FlatFileComplexSampleNamePanel.this.skipRowsChanged(FlatFileComplexSampleNamePanel.this._numRowsToSkip.getIntValue());
            }
        };
        CommonUtils.setMnemonicAndAccelerator(numRowsToSkipLabel, NLSUtils.getNLSString("NM_fileOrgNumRowsToSkip_FlatFile"));
        this._numRowsToSkip.addChangeListener(skipRowsListener);
        KeyAdapter skipRowsKeyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int code = e.getKeyCode();
                if (code == 10) {
                    e.consume();
                }
            }
        };
        this._numRowsToSkip.addKeyListener((KeyListener)skipRowsKeyListener);
        this._numRowsToSkip.setToolTipText(this.translate("NM_skipRowsTooltip"));
        FlatFileComplexSampleNamePanel.addComponent(nameCharacterSetPanel, (Component)this._numRowsToSkip, 1, 0, 1, 1, 0.2, 0.0, 17, 0, cmpInsets);
        JLabel numRowsToProcessLabel = new JLabel(this.translate("NM_nameNumRowsToProcess_FlatFile"));
        CommonUtils.setMnemonicAndAccelerator(numRowsToProcessLabel, NLSUtils.getNLSString("NM_nameNumRowsToProcess_FlatFile"));
        FlatFileComplexSampleNamePanel.addComponent(nameCharacterSetPanel, numRowsToProcessLabel, 0, 1, 1, 1, 0.0, 0.0, 17, 2, cmpInsets);
        this._numRowsToProcess = new NumberTextField(4);
        this._numRowsToProcess.setSigned(false);
        this._numRowsToProcess.setDecimal(false);
        numRowsToProcessLabel.setLabelFor((Component)this._numRowsToProcess);
        FlatFileComplexSampleNamePanel.addComponent(nameCharacterSetPanel, (Component)this._numRowsToProcess, 1, 1, 1, 1, 0.3, 0.1, 17, 2, cmpInsets);
        this._numRowsToProcess.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FlatFileComplexSampleNamePanel.this.numberRowsChanged(FlatFileComplexSampleNamePanel.this._numRowsToProcess.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FlatFileComplexSampleNamePanel.this.numberRowsChanged(FlatFileComplexSampleNamePanel.this._numRowsToProcess.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this._numRowsToProcess.setToolTipText(this.translate("NM_rowsToSampleToolTip"));
        numRowsToProcessLabel.setToolTipText(this.translate("NM_rowsToSampleToolTip"));
        this._everythingCb = new JCheckBox(this.translate("sampleEverything_label"));
        this._everythingCb.setToolTipText(this.translate("NM_rowsToSampleToolTip"));
        CommonUtils.setMnemonicAndAccelerator(this._everythingCb, NLSUtils.getNLSString("sampleEverything_label"));
        FlatFileComplexSampleNamePanel.addComponent(nameCharacterSetPanel, this._everythingCb, 2, 1, 1, 1, 0.3, 0.1, 17, 0, cmpInsets);
        this._everythingCb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (1 == e.getStateChange()) {
                    FlatFileComplexSampleNamePanel.this.sampleEverything(true);
                }
                if (2 == e.getStateChange()) {
                    FlatFileComplexSampleNamePanel.this.sampleEverything(false);
                }
            }
        });
        JLabel numDataRowsToProcessLabel = new JLabel(this.translate("NM_nameNumDataRowsToProcess_FlatFile"));
        CommonUtils.setMnemonicAndAccelerator(numDataRowsToProcessLabel, NLSUtils.getNLSString("NM_nameNumDataRowsToProcess_FlatFile"));
        FlatFileComplexSampleNamePanel.addComponent(nameCharacterSetPanel, numDataRowsToProcessLabel, 0, 2, 1, 1, 0.0, 0.0, 17, 2, cmpInsets);
        this._numDataRowsToProcess = new NumberTextField(4);
        this._numDataRowsToProcess.setSigned(false);
        this._numDataRowsToProcess.setDecimal(false);
        numDataRowsToProcessLabel.setLabelFor((Component)this._numDataRowsToProcess);
        FlatFileComplexSampleNamePanel.addComponent(nameCharacterSetPanel, (Component)this._numDataRowsToProcess, 1, 2, 1, 1, 0.3, 0.1, 17, 2, cmpInsets);
        this._numDataRowsToProcess.setToolTipText(this.translate("NM_dataRowsToProcessToolTip"));
        numDataRowsToProcessLabel.setToolTipText(this.translate("NM_dataRowsToProcessToolTip"));
        this._allDataRowsCb = new JCheckBox(this.translate("sampleEverything_label"));
        this._allDataRowsCb.setToolTipText(this.translate("NM_rowsToSampleToolTip"));
        CommonUtils.setMnemonicAndAccelerator(this._allDataRowsCb, NLSUtils.getNLSString("sampleEverything_label"));
        FlatFileComplexSampleNamePanel.addComponent(nameCharacterSetPanel, this._allDataRowsCb, 2, 2, 1, 1, 0.3, 0.1, 17, 0, cmpInsets);
        this._allDataRowsCb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (1 == e.getStateChange()) {
                    FlatFileComplexSampleNamePanel.this._numDataRowsToProcess.setEditable(false);
                }
                if (2 == e.getStateChange()) {
                    FlatFileComplexSampleNamePanel.this._numDataRowsToProcess.setEditable(true);
                }
            }
        });
        this._allDataRowsCb.setSelected(true);
        this._numDataRowsToProcess.setEditable(false);
        this._nameCharacterSetLbl = new JLabel(this.translate("GN_nameCharacterSet_FlatFile"));
        this._nameCharacterSetLbl.setToolTipText(this.translate("NM_characterSet_tooltip"));
        FlatFileComplexSampleNamePanel.addComponent(nameCharacterSetPanel, this._nameCharacterSetLbl, 0, 3, 1, 1, 0.0, 0.0, 17, 2, cmpInsets);
        this._nameCharacterSetLw = new JComboBox();
        this._nameCharacterSetLw.setToolTipText(this.translate("NM_characterSet_tooltip"));
        this._nameCharacterSetLbl.setLabelFor(this._nameCharacterSetLw);
        CommonUtils.setMnemonicAndAccelerator(this._nameCharacterSetLbl, NLSUtils.getNLSString("GN_nameCharacterSet_FlatFile"));
        FlatFileComplexSampleNamePanel.addComponent(nameCharacterSetPanel, this._nameCharacterSetLw, 1, 3, 1, 1, 1.0, 0.0, 17, 0, cmpInsets);
        ItemListener _nameCharacterSetListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    FlatFileComplexSampleNamePanel.this.nameCharacterSetStateChanged();
                }
            }
        };
        this._nameCharacterSetLw.addItemListener(_nameCharacterSetListener);
        this._namespaceLabel = new JLabel(this.translate("GN_namespace_label"));
        CommonUtils.setMnemonicAndAccelerator(this._namespaceLabel, NLSUtils.getNLSString("GN_namespace_label"));
        this._namespaceLabel.setToolTipText(this.translate("FO_namespaceSample_TooTip"));
        FlatFileComplexSampleNamePanel.addComponent(nameCharacterSetPanel, this._namespaceLabel, 0, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 2, 2));
        this._namespaceField = new JTextField(40);
        this._namespaceLabel.setLabelFor(this._namespaceField);
        FlatFileComplexSampleNamePanel.addComponent(nameCharacterSetPanel, this._namespaceField, 1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 2, 2));
        this._namespaceField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                FlatFileComplexSampleNamePanel.this.handlePageAdvance();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FlatFileComplexSampleNamePanel.this.handlePageAdvance();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FlatFileComplexSampleNamePanel.this.handlePageAdvance();
            }
        });
        this._namespaceField.setToolTipText(this.translate("FO_namespaceSample_TooTip"));
        this._containerNameLabel = new JLabel(this.translate("CT_exisitingRootElement_label"));
        CommonUtils.setMnemonicAndAccelerator(this._containerNameLabel, NLSUtils.getNLSString("CT_exisitingRootElement_label"));
        FlatFileComplexSampleNamePanel.addComponent(nameCharacterSetPanel, this._containerNameLabel, 0, 5, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 2, 2));
        this._containerNameField = new JTextField(40);
        this._containerNameLabel.setToolTipText(this.translate("EP_containerName_tooltip"));
        this._containerNameField.setToolTipText(this.translate("EP_containerName_tooltip"));
        this._containerNameLabel.setLabelFor(this._containerNameField);
        FlatFileComplexSampleNamePanel.addComponent(nameCharacterSetPanel, this._containerNameField, 1, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 2, 2));
        this._containerNameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                FlatFileComplexSampleNamePanel.this.handlePageAdvance();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FlatFileComplexSampleNamePanel.this.handlePageAdvance();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FlatFileComplexSampleNamePanel.this.handlePageAdvance();
            }
        });
    }

    private void skipRowsChanged(int newNumber) {
        if (this._numRowsToSkipSave != newNumber) {
            if ((this.ff_info.isSingleInstance() || !this.ff_info.isMultiRecord()) && this.ff_info.useFirstRowAsFieldNames()) {
                this.ff_info.setSkipRecords(this.ff_info.getSkipRecords() - 1);
                this.ff_info.useFirstRowAsFieldNamesEdit(false);
                this.ff_info.useFirstRowAsFieldNames(false);
            }
            this._numRowsToSkipSave = newNumber;
            this.ff_info.setSkipRecords(this._numRowsToSkipSave);
            if (!this.ff_info.isEditingNXSD()) {
                this.ff_info.clearRecords();
                this.ff_info.setHierarchicalTreeModel(null);
            }
            this._dataGizmo.refreshContents(this.ff_info);
        }
    }

    private void sampleEverything(boolean value) {
        this.ff_info.setSampleEverything(value);
        this._numRowsToProcess.setEditable(!value);
        if (!value) {
            this.numberRowsChanged(this._numRowsToProcess.getText());
        } else {
            this.ff_info.resyncToData();
            this._dataGizmo.refreshContents(this.ff_info);
        }
    }

    private void numberRowsChanged(String newTxt) {
        int newInt = 0;
        if (newTxt != null && newTxt.length() != 0 && this._numRowsToProcessSave != (newInt = Integer.parseInt(newTxt))) {
            if ((this.ff_info.isSingleInstance() || !this.ff_info.isMultiRecord()) && this.ff_info.useFirstRowAsFieldNames()) {
                this.ff_info.setSkipRecords(this.ff_info.getSkipRecords() - 1);
                this.ff_info.useFirstRowAsFieldNamesEdit(false);
                this.ff_info.useFirstRowAsFieldNames(false);
            }
            if (newTxt != null && newTxt.length() != 0) {
                newInt = Integer.parseInt(newTxt);
            }
            this._numRowsToProcessSave = newInt;
            this.ff_info.setSampleRecords(this._numRowsToProcessSave);
            this.ff_info.resyncToData();
            this._dataGizmo.refreshContents(this.ff_info);
        }
    }

    private void showThisError(WizardPanelValidationException e) {
        e.showError(this.getParentFrame(), this);
    }

    private void handlePageAdvance() {
        String sampleFileName = this._nameFileStructureName.getText() != null ? this._nameFileStructureName.getText().trim() : "";
        String containerName = "";
        String namespace = this._namespaceField.getText().trim();
        containerName = this._containerNameField.getText().trim();
        if (sampleFileName.equals("")) {
            this._wp.setCanAdvance(false);
            return;
        }
        this._wp.setCanAdvance(true);
        if (this.ff_info.isMultiRecord()) {
            if (containerName.equals("") || namespace.equals("")) {
                this._wp.setCanAdvance(false);
            } else {
                this._wp.setCanAdvance(true);
            }
        }
    }

    @Override
    public Component getFirstSelectableComponent() {
        return this._nameFileStructureName;
    }

    @Override
    public void validate(WizardInfo info, Frame f) throws WizardPanelValidationException {
        FlatFileInfo ff_info = (FlatFileInfo)info;
        String fileName = this._nameFileStructureName.getText();
        if (!this._allDataRowsCb.isSelected() && !this._numDataRowsToProcess.getText().equals("")) {
            ff_info.setProcessRows(Integer.parseInt(this._numDataRowsToProcess.getText()));
        } else {
            ff_info.setProcessRows(0);
        }
        if (!ff_info.isEditingNXSD()) {
            ff_info.setNxsdEncoding(ff_info.getDefaultCoding());
        }
        try {
            ff_info.setFileStructureName(fileName);
        }
        catch (FlatFileValidationException e) {
            e.showError(f, this);
            this._nameFileStructureName.requestFocus();
            throw e;
        }
        try {
            String namespace;
            String string = namespace = this._namespaceField.getText() != null ? this._namespaceField.getText().trim() : "";
            if (namespace.lastIndexOf("/") == namespace.length() - 1) {
                namespace = namespace.substring(0, namespace.length() - 1);
            }
            if (namespace.equals("http://xmlns.oracle.com/pcbpel/nxsd/extensions") || namespace.equals("http://xmlns.oracle.com/pcbpel/nxsd")) {
                throw new FlatFileValidationException(this.translate("EP_Invalid_namespace_API44", new String[]{namespace}));
            }
            ff_info.setNamespace(namespace);
            String rootElement = this._containerNameField.getText();
            if (rootElement == null || rootElement.trim().equals("")) {
                throw new FlatFileValidationException(this.translate("FO_recNameMissingMultipleRec_API5"));
            }
            ff_info.setRootElement(rootElement);
        }
        catch (FlatFileValidationException fe) {
            fe.showError(f, this);
            String rootElement = this._containerNameField.getText();
            if (rootElement == null || rootElement.trim().equals("")) {
                this._containerNameField.requestFocus();
            }
            throw fe;
        }
    }

    @Override
    public String getHelpTopicName() {
        return "flatfile_name";
    }

    @Override
    public void initializeFrom(WizardInfo info) {
        int numprocessrows;
        int i;
        int i2;
        String prevContainer;
        String prevNS;
        String sampleFileName;
        this.ff_info = (FlatFileInfo)info;
        DebugUtility.debug((Object)this.ff_info, " FlatFileSampleNamePanel initialize");
        String string = sampleFileName = this.ff_info.getFileStructureName() != null ? this.ff_info.getFileStructureName().trim() : "";
        if (sampleFileName.equals("")) {
            this._wp.setCanAdvance(false);
        } else {
            try {
                this._dataGizmo.showFileLabel(false);
                this._dataGizmo.refreshContents(this.ff_info);
                String o = this._dataGizmo.getTextDisplay().getText();
                if (o == null || o.equals("")) {
                    String[] args = new String[]{sampleFileName};
                    this.showThisError(new FlatFileValidationException(this.translate("FI_setupErrFileStructureNameInvalid_API22", args)));
                    this._wp.setCanAdvance(false);
                    this._gizmoPanel.setVisible(false);
                } else {
                    this._wp.setCanAdvance(true);
                    this._gizmoPanel.setVisible(true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this._nameFileStructureName.setText(sampleFileName);
        if (this.ff_info.isEditingNXSD()) {
            this._nameFileStructureName.setEditable(false);
            this._fileBrowseButton.setEnabled(false);
        } else {
            this._nameFileStructureName.setEditable(true);
            this._fileBrowseButton.setEnabled(true);
        }
        FlatFileWizard ffWizard = this.ff_info.getFlatFileWizard();
        int pageCount = ffWizard.getPageCount();
        int pageIndex = ffWizard.getCurrentPageIndex();
        WizardPage wp = ffWizard.getSelectedPage();
        wp.setLabel(this.translate("NX_pageTitle_FlatFile", new String[]{"" + pageIndex, "" + (pageCount -= 2)}));
        wp.setPageTitle(this.translate("NM_nameTitle_FileDescr_FlatFile"));
        DebugUtility.debug(this.translate("NM_nameTitle_FileDescr_FlatFile").toUpperCase());
        String string2 = prevNS = this.ff_info.getNamespace() != null ? this.ff_info.getNamespace().trim() : "";
        if (prevNS.equals("")) {
            NxsdFileInfo nxsdFileInfo = ffWizard.getNxsdFileInfo();
            String serviceName = nxsdFileInfo._serviceName;
            try {
                if (serviceName != null) {
                    serviceName = URLEncoder.encode(serviceName, "UTF8");
                    serviceName = serviceName.replace('%', '-');
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            prevNS = "http://TargetNamespace.com/ServiceName";
            if (serviceName != null && !serviceName.equals("")) {
                prevNS = prevNS.replaceAll("ServiceName", serviceName);
            }
            this._namespaceField.setText(prevNS);
        } else {
            this._namespaceField.setText(prevNS);
        }
        String string3 = prevContainer = this.ff_info.getRootElement() != null ? this.ff_info.getRootElement().trim() : "";
        if (prevContainer.trim().equals("")) {
            this._containerNameField.setText(this.translate("GN_containerNameDefault"));
        } else {
            this._containerNameField.setText(prevContainer);
        }
        ActionListener[] als = this._nameCharacterSetLw.getActionListeners();
        ItemListener[] ils = this._nameCharacterSetLw.getItemListeners();
        for (i2 = 0; i2 < als.length; ++i2) {
            this._nameCharacterSetLw.removeActionListener(als[i2]);
        }
        for (i2 = 0; i2 < ils.length; ++i2) {
            this._nameCharacterSetLw.removeItemListener(ils[i2]);
        }
        if (this._nameCharacterSetLw.getItemCount() == 0) {
            for (i2 = 0; i2 < this.ff_info.getCharacterSetList().length; ++i2) {
                String item = this.ff_info.getCharacterSetList()[i2];
                this._nameCharacterSetLw.addItem(item);
            }
        }
        String defaultCoding = this.ff_info.getDefaultCoding();
        this._nameCharacterSetLw.setSelectedItem(defaultCoding);
        for (i = 0; i < als.length; ++i) {
            this._nameCharacterSetLw.addActionListener(als[i]);
        }
        for (i = 0; i < ils.length; ++i) {
            this._nameCharacterSetLw.addItemListener(ils[i]);
        }
        this._numRowsToProcessSave = this.ff_info.getSampleRecords();
        if (!this.ff_info.isSampleEverything()) {
            this._numRowsToProcess.setNumber((Number)new Integer(this._numRowsToProcessSave));
        }
        if ((numprocessrows = this.ff_info.getProcessRows()) > 0) {
            this._numDataRowsToProcess.setNumber((Number)numprocessrows);
            this._allDataRowsCb.setSelected(false);
        }
        this._nameCharacterSetLw.invalidate();
        this._numRowsToSkipSave = this.ff_info.getSkipRecords();
        this._numRowsToSkip.setIntValue(this._numRowsToSkipSave);
    }

    private void nameCharacterSetStateChanged() {
        this.ff_info.setDefaultCoding((String)this._nameCharacterSetLw.getSelectedItem());
        this._dataGizmo.refreshContents(this.ff_info);
    }
}

