/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.plaf.FontUIResource;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.tip.tools.ide.common.resource.MessageBundleUtil;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.treeexplorer.NodeText;
import oracle.tip.tools.ide.common.ui.treeexplorer.TextInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileDisplayGizmo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileValidationException;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileWizard;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.RecTypeExplorer;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.RecTypeExplorerTreeNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WBTranslatable;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WizardInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WizardPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WizardPanelValidationException;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.DebugUtility;

public class FlatFileComplexRecCreatePanel
extends WizardPanel {
    protected static Icon SCHEMA_ICON = UIHelper.loadIcon((String)"images/schema.png", UIHelper.class);
    private FlatFileInfo ff_info;
    private MultiLineLabel _introText;
    private RecTypeExplorer treeExplorer;
    private JTextArea _textPane;
    private JLabel _nameFileNameIntro;
    private JTextField _nameFileStructureName;
    private JComboBox _nameCharacterSetLw;
    private NumberTextField _numRowsToProcess;
    private int _numRowsToProcessSave;
    private int _numRowsToSkipSave;
    private WizardPage _wp;
    private FlatFileDisplayGizmo _dataGizmo;
    private WBTranslatable _helper;
    private JFrame _parent;

    FlatFileComplexRecCreatePanel(WBTranslatable h) {
        super(h);
        this._helper = h;
        this._parent = UIHelper.getFrame((Component)this);
    }

    @Override
    public void buildPanel(WizardPage wp) {
        this._wp = wp;
        this.setLayout(new GridBagLayout());
        Insets pnlInsets = new Insets(3, 3, 3, 3);
        Insets cmpInsets = new Insets(2, 5, 2, 2);
        this._introText = new MultiLineLabel(WordWrapper.getTextWrapper(), this.translate("CX_ComplexSchemaPanelIntro"));
        this._nameFileNameIntro = new JLabel(this._helper.translate("CX_RecordTypesIntro"));
        this.treeExplorer = new RecTypeExplorer();
        this.treeExplorer.setLabelText(this._helper.translate("CX_RecordTypeTreeLabel"));
        FlatFileComplexRecCreatePanel.addComponent(this, (Component)((Object)this.treeExplorer), 0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(2, 2, 2, 2));
        JPanel textPanel = this.createEditorPanel();
        textPanel.setVisible(true);
        JPanel groupPanel = new JPanel(new GridBagLayout());
        FlatFileComplexRecCreatePanel.addComponent(groupPanel, (Component)this._introText, 0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 2, 8, 2));
        FlatFileComplexRecCreatePanel.addComponent(groupPanel, textPanel, 0, 1, 1, 1, 1.0, 0.0, 15, 2, new Insets(10, 2, 0, 2));
        FlatFileComplexRecCreatePanel.addComponent(this, groupPanel, 1, 0, 1, 1, 1.0, 0.0, 13, 1, cmpInsets);
    }

    private void skipRowsChanged(int newNumber) {
        if (this._numRowsToSkipSave != newNumber) {
            if ((this.ff_info.isSingleInstance() || !this.ff_info.isMultiRecord()) && this.ff_info.useFirstRowAsFieldNames()) {
                this.ff_info.setSkipRecords(this.ff_info.getSkipRecords() - 1);
                this.ff_info.useFirstRowAsFieldNamesEdit(false);
                this.ff_info.useFirstRowAsFieldNames(false);
            }
            this._numRowsToSkipSave = newNumber;
            this.ff_info.setSkipRecords(this._numRowsToSkipSave);
            if (!this.ff_info.isEditingNXSD()) {
                this.ff_info.clearRecords();
            }
            this._dataGizmo.refreshContents(this.ff_info);
        }
    }

    private void sampleEverything(boolean value) {
        this.ff_info.setSampleEverything(value);
        this._numRowsToProcess.setEditable(!value);
        if (!value) {
            this.numberRowsChanged(this._numRowsToProcess.getText());
        } else {
            this.ff_info.resyncToData();
            this._dataGizmo.refreshContents(this.ff_info);
        }
    }

    private void numberRowsChanged(String newTxt) {
        int newInt = 0;
        if ((this.ff_info.isSingleInstance() || !this.ff_info.isMultiRecord()) && this.ff_info.useFirstRowAsFieldNames()) {
            this.ff_info.setSkipRecords(this.ff_info.getSkipRecords() - 1);
            this.ff_info.useFirstRowAsFieldNamesEdit(false);
            this.ff_info.useFirstRowAsFieldNames(false);
        }
        if (newTxt != null && newTxt.length() != 0) {
            newInt = Integer.parseInt(newTxt);
        }
        this._numRowsToProcessSave = newInt;
        this.ff_info.setSampleRecords(this._numRowsToProcessSave);
        this.ff_info.resyncToData();
        this._dataGizmo.refreshContents(this.ff_info);
    }

    private void showThisError(WizardPanelValidationException e) {
        e.showError(this.getParentFrame(), this);
    }

    private void handlePageAdvance() {
        String sampleText;
        String string = sampleText = this._textPane.getText() != null ? this._textPane.getText().trim() : "";
        if (sampleText.equals("")) {
            this._wp.setCanAdvance(false);
        } else {
            this._wp.setCanAdvance(true);
        }
    }

    @Override
    public Component getFirstSelectableComponent() {
        return this._nameFileStructureName;
    }

    @Override
    public void validate(WizardInfo info, Frame f) throws WizardPanelValidationException {
        try {
            this.ff_info.setHierarchicalTreeModel((DefaultTreeModel)this.treeExplorer.getTree().getModel());
            DebugUtility.debug((Object)this.ff_info, "FlatFileComplexRecCreatePanel validate ");
            if (!this.treeExplorer.globalElementsExist()) {
                throw new FlatFileValidationException(this._helper.translate("CX_Exception_GlobalElementsNotFound"));
            }
            this.treeExplorer.validComplexTypes();
            this.ff_info.validateChoiceElements();
            String nxsdString = ((FlatFileInfo)info).generateNXSD();
            this.ff_info.setModifiedNXSD(nxsdString);
        }
        catch (FlatFileValidationException e) {
            e.showError(f, this);
            throw e;
        }
    }

    @Override
    public String getHelpTopicName() {
        return "flatfile_name";
    }

    @Override
    public void initializeFrom(WizardInfo info) {
        String sampleFileText;
        this.ff_info = (FlatFileInfo)info;
        DebugUtility.debug((Object)this.ff_info, " FlatFileComplexRecCreatePanel initialize");
        this.initializeTree();
        String string = sampleFileText = this.ff_info.getFileText() != null ? this.ff_info.getFileText() : "";
        if (sampleFileText.equals("")) {
            this._wp.setCanAdvance(false);
        } else {
            this._textPane.setText(sampleFileText);
            this._textPane.setAutoscrolls(true);
            this._textPane.setCaretPosition(0);
            this._wp.setCanAdvance(true);
        }
        FlatFileWizard ffWizard = this.ff_info.getFlatFileWizard();
        int pageCount = ffWizard.getPageCount();
        int pageIndex = ffWizard.getCurrentPageIndex();
        WizardPage wp = ffWizard.getSelectedPage();
        wp.setPageTitle(this.translate("NM_complexRecCreateTitle_FlatFile"));
        wp.setLabel(this.translate("NX_pageTitle_FlatFile", new String[]{"" + pageIndex, "" + (pageCount -= 2)}));
        DebugUtility.debug(this.translate("NM_complexRecCreateTitle_FlatFile").toUpperCase());
    }

    private void nameCharacterSetStateChanged() {
        this.ff_info.setDefaultCoding((String)this._nameCharacterSetLw.getSelectedItem());
        this._dataGizmo.refreshContents(this.ff_info);
    }

    private JPanel createEditorPanel() {
        JLabel descLabel = new JLabel(this._helper.translate("CX_RecCreateSampleFileIntro"));
        this._textPane = new JTextArea();
        JPanel panel = new JPanel();
        this._textPane.setCaretPosition(0);
        this._textPane.setDragEnabled(true);
        this._textPane.setEditable(false);
        this._textPane.setFont(new FontUIResource("Courier New", 0, 11));
        panel.setLayout(new GridBagLayout());
        UIHelper.addComponent((Container)panel, (Component)descLabel, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        UIHelper.addComponent((Container)panel, (Component)new JScrollPane(this._textPane), (int)0, (int)1, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(5, 0, 0, 0), (int)200, (int)165, (double)1.0, (double)0.0);
        return panel;
    }

    private void initializeTree() {
        try {
            if (this.ff_info.getHierarchicalTreeModel() != null) {
                this.treeExplorer.getTree().setModel(this.ff_info.getHierarchicalTreeModel());
                if (this.ff_info.isEditingNXSD()) {
                    this.treeExplorer.getTree().setSelectionRow(0);
                    this.treeExplorer.addTreeDropTargetListener(this._helper, this.ff_info, UIHelper.getFrame((Component)((Object)this.treeExplorer)));
                }
                RecTypeExplorerTreeNode root = (RecTypeExplorerTreeNode)((Object)this.treeExplorer.getTree().getModel().getRoot());
                root.setName(this.ff_info.getRootElement());
                DefaultTreeModel model = (DefaultTreeModel)this.treeExplorer.getTree().getModel();
                model.setRoot((TreeNode)((Object)root));
                return;
            }
            this.setSchemaTreeRoot();
            this.treeExplorer.getTree().setSelectionRow(0);
            this.treeExplorer.addTreeDropTargetListener(this._helper, this.ff_info, UIHelper.getFrame((Component)((Object)this.treeExplorer)));
            this.treeExplorer.showExplorerPanel();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void enableUserInput(final boolean bEnable) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                FlatFileComplexRecCreatePanel.this._parent.getContentPane().setVisible(!bEnable);
                if (bEnable) {
                    FlatFileComplexRecCreatePanel.this._parent.setCursor(Cursor.getDefaultCursor());
                } else {
                    FlatFileComplexRecCreatePanel.this._parent.setCursor(Cursor.getPredefinedCursor(3));
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    private void setSchemaTreeRoot() {
        TextInfo info1 = new TextInfo(Color.black, TextInfo.PLAIN_FONT, this.ff_info.getRootElement());
        TextInfo info2 = new TextInfo(Color.black, TextInfo.PLAIN_FONT, this.ff_info.getRootElement());
        TextInfo[] expanded = new TextInfo[]{info1};
        TextInfo[] compact = new TextInfo[]{info2};
        NodeText nodeText = new NodeText(expanded, compact);
        Icon[] icons = new Icon[]{SCHEMA_ICON};
        RecTypeExplorerTreeNode root = new RecTypeExplorerTreeNode(icons, nodeText, (Object)MessageBundleUtil.getCommonString((String)"TC_DISPLAY_XML_TYPES", (String)"Displays available XML types in the system."));
        DefaultTreeModel model = (DefaultTreeModel)this.treeExplorer.getTree().getModel();
        model.setRoot((TreeNode)((Object)root));
    }
}

