/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.beans.PropertyVetoException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.grid.BooleanInputHandler;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.CheckPainter;
import oracle.bali.ewt.grid.ComboBoxInputHandler;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.grid.NullInputHandler;
import oracle.bali.ewt.grid.NumericSpinBoxInputHandler;
import oracle.bali.ewt.grid.TwoIconPainter;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.table.TableEditListener;
import oracle.bali.ewt.table.TableEvent;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.ChoiceColumnInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.ColumnInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.CommonUtils;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileDisplayGizmo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileValidationException;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.RecTypeAttributes;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WBTranslatable;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WBTranslatablePanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.DebugUtility;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.NLSUtils;

public class FlatFileComplexFieldProperties
extends WBTranslatablePanel
implements TableEditListener {
    private JComboBox _recordList;
    private ArrayOneDModel _fieldGridHeaderDs;
    private ArrayTwoDModel _fieldGridDs;
    private SpreadTable _fieldGridTable;
    private Grid _fieldGrid;
    private JScrollPane _fieldGridScrollBox;
    private NumericSpinBoxInputHandler _lengthHandler;
    private JPanel _buttonPanel;
    private JButton _addButton;
    private JButton _deleteButton;
    private JPanel _nextRecTypeButtonPanel;
    private JButton _nextRecTypeButton;
    private FlatFileInfo _ff_info;
    private String _lastRecord;
    private FlatFileDisplayGizmo _dataGizmo;
    private String savedDatatype;
    private static final String FIELD_EDIT_ICN = "images/edit16.png";

    public FlatFileComplexFieldProperties(WBTranslatable h) {
        super(h);
    }

    public void buildFieldProperties() {
        this.setLayout(new GridBagLayout());
        this.buildButtons();
        this._fieldGridDs = new ArrayTwoDModel(0, 0);
        this._fieldGridTable = new SpreadTable((TwoDModel)this._fieldGridDs, null, null);
        Grid grid = this._fieldGridTable.getGrid();
        if (grid != null) {
            grid.setName("FieldsGrid");
        }
        this._fieldGridScrollBox = new JScrollPane((Component)this._fieldGridTable, 20, 30);
        JPanel fieldGridPanel = new JPanel(new GridLayout(1, 1));
        fieldGridPanel.add(this._fieldGridScrollBox);
        fieldGridPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), this.translate("DA_fieldLevelDelimiters_borderText")));
        fieldGridPanel.setPreferredSize(new Dimension(300, 50));
        FlatFileComplexFieldProperties.addComponent(this, fieldGridPanel, 0, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 3, 3, 250), 0, 55);
        this._fieldGridTable.addEditListener((TableEditListener)this);
        this._fieldGrid = this._fieldGridTable.getGrid();
        this._fieldGrid.setGridSelectionManager((GridSelectionManager)new GeneralGridSelectionManager(0, 1, 0));
        this.setVisible(false);
    }

    public void buildButtons() {
        Insets insets = new Insets(0, 3, 0, 250);
        GridLayout gridLayout = new GridLayout(1, 1, 10, 1);
        this._buttonPanel = new JPanel();
        this._buttonPanel.setLayout(gridLayout);
        gridLayout.setHgap(6);
        FlatFileComplexFieldProperties.addComponent(this, this._buttonPanel, 0, 0, 1, 1, 1.0, 1.0, 13, 0, insets);
        this._addButton = UIHelper.createModelerButton((Icon)new ImageIcon(UIHelper.loadImage((String)"images/add16.png", UIHelper.class)));
        this._addButton.setToolTipText(this.translate("FP_struAddBtn_FlatFile"));
        insets = new Insets(5, 2, 5, 5);
        this._buttonPanel.add(this._addButton);
        ActionListener _addButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlatFileComplexFieldProperties.this.addBtnAction();
            }
        };
        this._addButton.addActionListener(_addButtonListener);
        this._deleteButton = UIHelper.createModelerButton((Icon)new ImageIcon(UIHelper.loadImage((String)"images/delete.png", UIHelper.class)));
        this._deleteButton.setToolTipText(this.translate("FP_struDeleteBtn_FlatFile"));
        this._buttonPanel.add(this._deleteButton);
        ActionListener _deleteButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlatFileComplexFieldProperties.this.deleteBtnAction();
            }
        };
        this._deleteButton.addActionListener(_deleteButtonListener);
        this._deleteButton.setEnabled(false);
    }

    public JPanel buildNextRecTypeButtonPanel() {
        this._nextRecTypeButtonPanel = new JPanel();
        this._nextRecTypeButtonPanel.setLayout(new GridBagLayout());
        this._nextRecTypeButton = new JButton(this.translate("CD_columnDefNextRecordTypeButton_FlatFile"));
        CommonUtils.setMnemonicAndAccelerator(this._nextRecTypeButton, NLSUtils.getNLSString("CD_columnDefNextRecordTypeButton_FlatFile"));
        FlatFileComplexFieldProperties.addComponent(this._nextRecTypeButtonPanel, this._nextRecTypeButton, 1, 0, 1, 1, 0.5, 0.0, 13, 0, new Insets(0, 0, 0, 0));
        ActionListener nextRecTypeButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlatFileComplexFieldProperties.this.nextRecTypeBtnAction();
            }
        };
        this._nextRecTypeButton.addActionListener(nextRecTypeButtonListener);
        return this._nextRecTypeButtonPanel;
    }

    public void initializeFrom(FlatFileInfo info) {
        this._ff_info = info;
    }

    public void validateFields() throws FlatFileValidationException {
        this._ff_info.validateFields(this._lastRecord);
    }

    public void processRecordSelection() {
        boolean debug_on = false;
        String debug_msg = "";
        DebugUtility.debug((Object)this, "processRecordSelection() called ");
        String recordSelected = (String)this._recordList.getSelectedItem();
        if (this._lastRecord == null || !this._lastRecord.equals(recordSelected)) {
            try {
                this._ff_info.validateFields(this._lastRecord);
            }
            catch (Exception e) {
                CommonUtils.error((Object)this, e.getMessage());
                ItemListener[] ils = CommonUtils.removeComboItemListener(this._recordList);
                this._recordList.setSelectedItem(this._lastRecord);
                CommonUtils.addComboItemListener(this._recordList, ils);
                DebugUtility.debug((Object)this, "processRecordSelection END");
                return;
            }
            ColumnInfo[] fieldPropertiesInfo = this._ff_info.getFieldPropertiesInfo();
            int fieldPropertiesCount = fieldPropertiesInfo.length;
            if (this._fieldGridHeaderDs == null || this._fieldGridHeaderDs.getItemCount() != fieldPropertiesCount) {
                this._fieldGridHeaderDs = new ArrayOneDModel(fieldPropertiesCount);
                for (int i = 0; i < fieldPropertiesCount; ++i) {
                    this._fieldGridHeaderDs.setData(i, (Object)fieldPropertiesInfo[i].getHeader());
                }
            }
            this._fieldGridDs = this._ff_info.getFieldPropertiesDs(recordSelected);
            this._fieldGridTable.setModels((TwoDModel)this._fieldGridDs, (OneDModel)this._fieldGridHeaderDs, null);
            int fieldCount = this._fieldGridDs.getRowCount();
            Font currFont = this._fieldGrid.getFont();
            if (currFont == null) {
                currFont = CommonUtils.getMonoFont(0, 12);
            }
            FontMetrics currFontMetrics = this._fieldGrid.getFontMetrics(currFont);
            for (int col = 0; col < fieldPropertiesCount; ++col) {
                int dataWidth;
                if (debug_on) {
                    debug_msg = "Column: " + fieldPropertiesInfo[col].getHeader();
                }
                if (this._ff_info.isDelimitedFile()) {
                    if (3 == col) {
                        fieldPropertiesInfo[col].setVisible(false);
                    }
                }
                if (this._ff_info.isFixedLength()) {
                    if (6 == col) {
                        fieldPropertiesInfo[col].setVisible(false);
                    }
                }
                if (!fieldPropertiesInfo[col].isVisible()) {
                    if (debug_on) {
                        debug_msg = debug_msg + " *INVISIBLE*";
                    }
                    this._fieldGrid.setColumnVisible(col, false);
                    this._fieldGridTable.getColumnHeader().setItemVisible(col, false);
                    continue;
                }
                this._fieldGrid.setColumnVisible(col, true);
                this._fieldGridTable.getColumnHeader().setItemVisible(col, true);
                int maxWidth = currFontMetrics.stringWidth(fieldPropertiesInfo[col].getHeader() + "W");
                if (fieldPropertiesInfo[col] instanceof ChoiceColumnInfo) {
                    ChoiceColumnInfo info = (ChoiceColumnInfo)fieldPropertiesInfo[col];
                    Object[] choices = info.getChoices();
                    for (int i = 0; i < choices.length; ++i) {
                        dataWidth = currFontMetrics.stringWidth((String)choices[i] + "WW");
                        if (maxWidth >= dataWidth) continue;
                        maxWidth = dataWidth;
                    }
                }
                for (int row = 0; row < fieldCount; ++row) {
                    Object o = this._fieldGridDs.getData(col, row);
                    String data = null;
                    if (o != null) {
                        data = o + "W";
                    }
                    if (data == null || maxWidth >= (dataWidth = currFontMetrics.stringWidth(data))) continue;
                    maxWidth = dataWidth;
                }
                this._fieldGridTable.setColumnWidth(col, maxWidth);
                if (debug_on) {
                    debug_msg = debug_msg + " Width: " + maxWidth;
                }
                if (!fieldPropertiesInfo[col].isEditable()) continue;
                if (debug_on) {
                    debug_msg = debug_msg + " EDITABLE";
                }
                this._fieldGridTable.getGrid().setColumnCellInputHandler(col, fieldPropertiesInfo[col].getInputHandler());
            }
            if (!this._ff_info.isDelimitedFile()) {
                this._lengthHandler = (NumericSpinBoxInputHandler)this._fieldGridTable.getGrid().getColumnCellInputHandler(3);
            }
            this._lastRecord = recordSelected;
            this._dataGizmo.refreshContents(this._ff_info, this._lastRecord);
        }
        DebugUtility.debug("FlatFileFieldProperties.processRecordSelection END selected Record " + this._lastRecord);
    }

    public void processRecordSelection(String recordSelected) {
        boolean debug_on = false;
        String debug_msg = "";
        DebugUtility.debug((Object)this, "processRecordSelection() called ");
        RecTypeAttributes recAttr = this._ff_info.getRecordAttributes(recordSelected);
        if (this._lastRecord == null || !this._lastRecord.equals(recordSelected)) {
            try {
                this._ff_info.validateFields(recordSelected);
            }
            catch (Exception e) {
                CommonUtils.error((Object)this, e.getMessage());
                return;
            }
            ColumnInfo[] fieldPropertiesInfo = this._ff_info.getComplexFieldPropertiesInfo();
            int fieldPropertiesCount = fieldPropertiesInfo.length;
            if (this._fieldGridHeaderDs == null || this._fieldGridHeaderDs.getItemCount() != fieldPropertiesCount) {
                this._fieldGridHeaderDs = new ArrayOneDModel(fieldPropertiesCount);
                for (int i = 0; i < fieldPropertiesCount; ++i) {
                    this._fieldGridHeaderDs.setData(i, (Object)fieldPropertiesInfo[i].getHeader());
                }
            }
            this._fieldGridDs = this._ff_info.getFieldPropertiesDs(recordSelected);
            this._fieldGridTable.setModels((TwoDModel)this._fieldGridDs, (OneDModel)this._fieldGridHeaderDs, null);
            this._fieldGridTable.getGrid().setColumnPainter(0, CheckPainter.getPainter());
            this._fieldGridTable.getGrid().setColumnCellInputHandler(0, (CellInputHandler)((BooleanInputHandler)BooleanInputHandler.getCellInputHandler()));
            this._fieldGridTable.getGrid().setColumnPainter(14, (Painter)new TwoIconPainter(UIHelper.loadIcon((String)FIELD_EDIT_ICN, UIHelper.class), UIHelper.loadIcon((String)FIELD_EDIT_ICN, UIHelper.class)));
            this._fieldGridTable.getGrid().setColumnCellInputHandler(14, (CellInputHandler)((NullInputHandler)NullInputHandler.getCellInputHandler()));
            int fieldCount = this._fieldGridDs.getRowCount();
            Font currFont = this._fieldGrid.getFont();
            if (currFont == null) {
                currFont = CommonUtils.getMonoFont(0, 12);
            }
            FontMetrics currFontMetrics = this._fieldGrid.getFontMetrics(currFont);
            for (int col = 0; col < fieldPropertiesCount; ++col) {
                if (debug_on) {
                    debug_msg = "Column: " + fieldPropertiesInfo[col].getHeader();
                }
                if (recAttr != null && recAttr.isDelimited()) {
                    if (3 == col) {
                        fieldPropertiesInfo[col].setVisible(false);
                    }
                }
                if (this._ff_info.isFixedLength()) {
                    if (6 == col) {
                        fieldPropertiesInfo[col].setVisible(false);
                    }
                }
                if (!fieldPropertiesInfo[col].isVisible()) {
                    if (debug_on) {
                        debug_msg = debug_msg + " *INVISIBLE*";
                    }
                    this._fieldGrid.setColumnVisible(col, false);
                    this._fieldGridTable.getColumnHeader().setItemVisible(col, false);
                    continue;
                }
                this._fieldGrid.setColumnVisible(col, true);
                this._fieldGridTable.getColumnHeader().setItemVisible(col, true);
                int maxWidth = currFontMetrics.stringWidth(fieldPropertiesInfo[col].getHeader() + "W");
                for (int row = 0; row < fieldCount; ++row) {
                    int dataWidth;
                    Object o = this._fieldGridDs.getData(col, row);
                    String data = null;
                    if (o != null) {
                        data = o + "W";
                    }
                    if (data == null || maxWidth >= (dataWidth = currFontMetrics.stringWidth(data))) continue;
                    maxWidth = dataWidth;
                }
                this._fieldGridTable.setColumnWidth(col, maxWidth);
                if (debug_on) {
                    debug_msg = debug_msg + " Width: " + maxWidth;
                }
                if (!fieldPropertiesInfo[col].isEditable()) continue;
                if (debug_on) {
                    debug_msg = debug_msg + " EDITABLE";
                }
                try {
                    this._fieldGridTable.getGrid().setColumnCellInputHandler(col, fieldPropertiesInfo[col].getInputHandler());
                    continue;
                }
                catch (Exception ih_e) {
                    this._fieldGridTable.getGrid().setColumnCellInputHandler(col, NullInputHandler.getCellInputHandler());
                }
            }
            Vector recTypeList = this._ff_info.getValidRecordTypeList(recordSelected);
            Enumeration enum_rectype = recTypeList.elements();
            ComboBoxInputHandler typeComboHandler = (ComboBoxInputHandler)this._fieldGridTable.getGrid().getColumnCellInputHandler(2);
            FlatFileComplexFieldProperties flatFileComplexFieldProperties = this;
            Object[] typeChoices = flatFileComplexFieldProperties._ff_info.getXmlDataTypes();
            while (enum_rectype.hasMoreElements()) {
                typeChoices = this.addArrayElement((String[])typeChoices, (String)enum_rectype.nextElement());
            }
            typeComboHandler.setItems(typeChoices);
            this._lastRecord = recordSelected;
        }
        DebugUtility.debug("FlatFileFieldProperties.processRecordSelection END selected Record " + this._lastRecord);
        this._fieldGridTable.revalidate();
    }

    public void addBtnAction() {
        GridSelectionManager tableGridSelection = this._fieldGrid.getGridSelectionManager();
        int rowsSelected = tableGridSelection.getSelection().getRowSelection().getSelectedItemAtIndex(0);
        int row = rowsSelected > -1 ? rowsSelected + 1 : this._fieldGridDs.getRowCount();
        this._fieldGridDs.addRows(row, 1);
        this._ff_info.resetFieldPropertiesRow(this._fieldGridDs, row);
        try {
            tableGridSelection.setSelection(new TwoDSelection(row, true), null);
            tableGridSelection.setSelection(new TwoDSelection(row, 0), null);
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        this._fieldGridTable.getGrid().startCellEdit(0, row);
    }

    public void deleteBtnAction() {
        GridSelectionManager tableGridSelection = this._fieldGrid.getGridSelectionManager();
        int rowsSelected = tableGridSelection.getSelection().getRowSelection().getSelectedItemAtIndex(0);
        if (rowsSelected > -1) {
            int row = rowsSelected;
            this._fieldGridDs.removeRows(row, 1);
            int rowCount = this._fieldGridDs.getRowCount();
            if (rowCount > 0) {
                int nextShowRow;
                for (nextShowRow = row; nextShowRow < rowCount && !this._fieldGridTable.isRowVisible(nextShowRow); ++nextShowRow) {
                }
                try {
                    if (nextShowRow < rowCount) {
                        tableGridSelection.setSelection(new TwoDSelection(nextShowRow, true), null);
                    } else {
                        tableGridSelection.setSelection(new TwoDSelection(0, true), null);
                    }
                }
                catch (PropertyVetoException e) {
                    // empty catch block
                }
            }
        }
    }

    public void nextRecTypeBtnAction() {
        int numRecords = this._recordList.getItemCount();
        int idx = this._recordList.getSelectedIndex();
        idx = idx == numRecords - 1 ? 0 : ++idx;
        ItemListener[] ils = CommonUtils.removeComboItemListener(this._recordList);
        this._recordList.setSelectedIndex(idx);
        CommonUtils.addComboItemListener(this._recordList, ils);
        this.processRecordSelection();
    }

    public void cellEdited(TableEvent e) {
        int column;
        block12: {
            int start;
            Object o;
            int precision;
            int len;
            int row;
            block13: {
                row = e.getRow();
                column = e.getColumn();
                len = 0;
                precision = 0;
                if (column == 2) {
                    String data_type = (String)this._fieldGridDs.getData(2, row);
                }
                if (this._ff_info.isDelimitedFile()) break block12;
                if (column == 3) break block13;
                if (column == 4) break block13;
                if (column != 2) break block12;
            }
            len = (o = this._fieldGridDs.getData(3, row)) == null || o.toString() == "" ? 0 : Integer.parseInt("" + this._fieldGridDs.getData(3, row));
            String data_type = (String)this._fieldGridDs.getData(2, row);
            String style = (String)this._fieldGridDs.getData(7, row);
            int end = start = Integer.parseInt("" + this._fieldGridDs.getData(4, row));
            if (len != 0) {
                end = start + len - 1;
            } else if (precision != 0) {
                end = data_type.equals("DECIMAL") ? start + (precision / 2 + 1) - 1 : start + precision - 1;
            }
            this._fieldGridDs.setData(5, row, (Object)new Integer(end));
            FlatFileComplexFieldProperties flatFileComplexFieldProperties = this;
            if (!Arrays.asList(flatFileComplexFieldProperties._ff_info.getXmlDataTypes()).contains(data_type)) {
                this._fieldGridDs.setData(3, row, (Object)new Integer(0));
                this._fieldGridDs.setData(7, row, (Object)"");
                this._fieldGridDs.setData(8, row, (Object)"");
                this._fieldGridDs.setData(9, row, (Object)"");
                this._fieldGridDs.setData(10, row, (Object)"");
                this._fieldGridDs.setData(11, row, (Object)"");
                this._fieldGridDs.setData(13, row, (Object)"");
                this._fieldGridDs.setData(22, row, (Object)"Fixed");
            }
            if (data_type.equals("string") && style.equals("")) {
                this._fieldGridDs.setData(7, row, (Object)"fixedLength");
                this._fieldGridDs.setData(10, row, (Object)"tail");
                this._fieldGridDs.setData(11, row, (Object)this.translate("FI_generalColDelimiterSpace_FlatFile"));
            }
            if (!data_type.equals("string")) {
                if (this._fieldGridDs.getData(7, row).equals("fixedLength")) {
                    this._fieldGridDs.setData(7, row, (Object)"");
                }
                this._fieldGridDs.setData(10, row, (Object)"");
                this._fieldGridDs.setData(11, row, (Object)"");
            }
            if (data_type.equals("date") || data_type.equals("dateTime")) {
                this._fieldGridDs.setData(27, row, (Object)"MM/dd/yy");
            }
        }
        this.resizeColumns(column);
    }

    public void cellEditing(TableEvent e) {
        if (this._deleteButton != null) {
            this._deleteButton.setEnabled(true);
        }
        if (e.getSource() == this._fieldGridTable) {
            String data_type;
            int row = e.getRow();
            int column = e.getColumn();
            this.savedDatatype = data_type = (String)this._fieldGridDs.getData(2, row);
            boolean cancel = false;
            if (cancel && e instanceof Cancelable) {
                ((Cancelable)e).cancel();
            }
            this.resizeColumns(column);
        }
    }

    public JButton getAddButton() {
        return this._addButton;
    }

    public JButton getNextRecTypeButton() {
        return this._nextRecTypeButton;
    }

    public JPanel getButtonPanel() {
        return this._buttonPanel;
    }

    public SpreadTable getFieldGrid() {
        return this._fieldGridTable;
    }

    public int getRecordCount() {
        return this._recordList.getItemCount();
    }

    public JComboBox getRecordList() {
        return this._recordList;
    }

    public String getRecordSelected() {
        return this._lastRecord;
    }

    public boolean recordListIsVisible() {
        return this._recordList.isVisible();
    }

    public void setDataGizmo(FlatFileDisplayGizmo gizmo) {
        this._dataGizmo = gizmo;
    }

    public void resetLastRecord() {
        this._lastRecord = "";
    }

    public void resetColumnData(int colNum) {
        for (int i = 0; i < this._fieldGridDs.getRowCount(); ++i) {
            this._fieldGridDs.setData(colNum, i, null);
        }
    }

    public void resizeColumns(int colNum) {
        Font currFont = this._fieldGrid.getFont();
        if (currFont == null) {
            currFont = CommonUtils.getMonoFont(0, 12);
        }
        FontMetrics currFontMetrics = this._fieldGrid.getFontMetrics(currFont);
        String recordName = this.getRecordSelected();
        ArrayTwoDModel fieldProps = this._ff_info.getFieldPropertiesDs(recordName);
        int num_columns = fieldProps.getRowCount();
        int charSize = currFontMetrics.charWidth('w');
        int maxWidth = 5 * charSize;
        String columnName = "";
        int colWidth = 0;
        for (int i = 0; i < num_columns; ++i) {
            try {
                columnName = (String)fieldProps.getData(colNum, i);
                colWidth = (columnName.length() + 1) * charSize;
            }
            catch (Exception e1) {
                // empty catch block
            }
            if (colWidth <= maxWidth) continue;
            maxWidth = colWidth;
        }
        this._fieldGridTable.setColumnWidth(colNum, maxWidth);
    }

    private String[] addArrayElement(String[] strarray, String name) {
        String[] newarray = new String[strarray.length + 1];
        for (int i = 0; i < strarray.length; ++i) {
            newarray[i] = strarray[i];
        }
        newarray[strarray.length] = name;
        return newarray;
    }

    public void setFieldGridHeaderDs(ArrayOneDModel fieldGridHeaderDs) {
        this._fieldGridHeaderDs = fieldGridHeaderDs;
    }

    public ArrayOneDModel getFieldGridHeaderDs() {
        return this._fieldGridHeaderDs;
    }

    public ArrayTwoDModel getFieldGridDs() {
        return this._fieldGridDs;
    }
}

