/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.tree.TreeNode;
import oracle.tip.pc.services.translation.tools.nxsdcompiler.ComplexTypeDecl;
import oracle.tip.pc.services.translation.tools.nxsdcompiler.ElementDecl;
import oracle.tip.pc.services.translation.tools.nxsdcompiler.ModelGroupDecl;
import oracle.tip.pc.services.translation.tools.nxsdcompiler.NXSDCompiler;
import oracle.tip.pc.services.translation.tools.nxsdcompiler.NXSDDefinition;
import oracle.tip.pc.services.translation.tools.nxsdcompiler.NXSDException;
import oracle.tip.pc.services.translation.tools.nxsdcompiler.NXSDStyleInfo;
import oracle.tip.pc.services.translation.tools.nxsdcompiler.Particle;
import oracle.tip.pc.services.translation.tools.nxsdcompiler.SchemaComponent;
import oracle.tip.pc.services.translation.tools.nxsdcompiler.SimpleTypeDecl;
import oracle.tip.pc.services.translation.tools.nxsdcompiler.Type;
import oracle.tip.tools.ide.common.resource.MessageBundleUtil;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.util.StringUtil;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.ComplexNXSDGenerator;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.NXSDGenerator;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.RecTypeAttributes;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.RecTypeExplorerTreeNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.RecTypeTreeModel;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XMLSchemaNode;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDNode;

public class DSConverter {
    private HashMap _complexTypeMap;
    private Vector _elementUsedList;
    private boolean _choiceFlag = false;

    public String convertToNXSD(FlatFileInfo wizardInfo) throws NXSDException {
        ElementDecl container;
        NXSDDefinition def = new NXSDDefinition();
        NXSDGenerator wizardProxy = new NXSDGenerator(wizardInfo);
        def.setTargetNamespace(wizardProxy.getNamespace());
        def.setEncoding(wizardProxy.getEncoding());
        def.setEncodingOfNxsdDoc(wizardProxy.getNxsdEncoding());
        def.setByteOrder(wizardProxy.getByteOrder());
        def.setHeaderLines(wizardProxy.getHeaderLines());
        if (wizardProxy.getDataLines() > 0) {
            def.setDataLines(String.valueOf(wizardProxy.getDataLines()));
        }
        def.setLinesTerminatedBy(wizardProxy.getLinesTerminatedBy());
        if (wizardProxy.isSingleRecord()) {
            def.addGlobalDeclaration((SchemaComponent)this.getRecord(wizardProxy, 0));
        } else if (wizardProxy.isSingleTypeRecords()) {
            container = new ElementDecl();
            container.setName(wizardProxy.getContainerName());
            ComplexTypeDecl containerCT = new ComplexTypeDecl();
            container.setTypeDefinition((Type)containerCT);
            ModelGroupDecl containerMG = new ModelGroupDecl();
            containerCT.setModelGroup(containerMG);
            containerMG.setModelGroupType((short)5);
            ElementDecl record = this.getRecord(wizardProxy, 0);
            containerMG.addParticle((Particle)record);
            record.setMinOccurs(1);
            record.setMaxOccurs(0x7FFFFFF8);
            def.addGlobalDeclaration((SchemaComponent)container);
        } else if (wizardProxy.isMultipleTypeRecords()) {
            container = new ElementDecl();
            container.setName(wizardProxy.getContainerName());
            NXSDStyleInfo styleInfo = new NXSDStyleInfo();
            if (wizardProxy.isChoiceConditionFixedLen()) {
                styleInfo.setChoiceCondition("fixedLength");
                styleInfo.setLength(wizardProxy.getChoiceConditionLen());
            } else if (wizardProxy.isChoiceConditionDelimited()) {
                styleInfo.setChoiceCondition("terminated");
                styleInfo.setTerminatedBy(wizardProxy.getChoiceConditionTerminatedBy());
            }
            ComplexTypeDecl containerCT = new ComplexTypeDecl();
            container.setTypeDefinition((Type)containerCT);
            ModelGroupDecl containerMG = new ModelGroupDecl();
            containerCT.setModelGroup(containerMG);
            containerMG.setStyleInfo(styleInfo);
            containerMG.setModelGroupType((short)6);
            containerMG.setMinOccurs(1);
            containerMG.setMaxOccurs(0x7FFFFFF8);
            ElementDecl particle = null;
            for (int i = 0; i < wizardProxy.getRecordTypeCount(); ++i) {
                particle = this.getRecord(wizardProxy, i);
                if (particle.getStyleInfo() == null) {
                    particle.setStyleInfo(new NXSDStyleInfo());
                }
                particle.getStyleInfo().setConditionValue(wizardProxy.getConditionValue(i));
                containerMG.addParticle((Particle)particle);
            }
            def.addGlobalDeclaration((SchemaComponent)container);
        }
        NXSDCompiler compiler = new NXSDCompiler();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        compiler.compileFromDef(def, (OutputStream)baos);
        String encodedNxsd = "";
        try {
            encodedNxsd = baos.toString(def.getEncodingOfNxsdDoc());
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        return encodedNxsd;
    }

    public String convertToComplexNXSD(FlatFileInfo wizardInfo) throws NXSDException {
        NXSDDefinition def = new NXSDDefinition();
        this._complexTypeMap = new HashMap();
        this._elementUsedList = new Vector();
        ComplexNXSDGenerator wizardProxy = new ComplexNXSDGenerator(wizardInfo);
        this._choiceFlag = this.choiceRecsExist(wizardProxy);
        def.setTargetNamespace(wizardProxy.getNamespace());
        def.setEncoding(wizardProxy.getEncoding());
        def.setEncodingOfNxsdDoc(wizardProxy.getNxsdEncoding());
        def.setByteOrder(wizardProxy.getByteOrder());
        def.setHeaderLines(wizardProxy.getHeaderLines());
        if (wizardProxy.getDataLines() > 0) {
            def.setDataLines(String.valueOf(wizardProxy.getDataLines()));
        }
        def.setLinesTerminatedBy(wizardProxy.getLinesTerminatedBy());
        if (wizardProxy.isComplexType()) {
            ElementDecl container = new ElementDecl();
            container.setName(wizardProxy.getContainerName());
            NXSDStyleInfo styleInfo = new NXSDStyleInfo();
            ComplexTypeDecl containerCT = new ComplexTypeDecl();
            container.setTypeDefinition((Type)containerCT);
            ComplexTypeDecl containerComplexType = new ComplexTypeDecl();
            containerComplexType.setName(wizardProxy.getContainerName());
            ModelGroupDecl containerMG = new ModelGroupDecl();
            containerCT.setModelGroup(containerMG);
            containerMG.setStyleInfo(styleInfo);
            containerMG.setModelGroupType((short)5);
            if (this._choiceFlag) {
                containerMG.setModelGroupType((short)6);
                RecTypeAttributes attr = wizardProxy.getChoiceAttributes();
                if (attr != null) {
                    containerMG.setMinOccurs(attr.getMinOccurs());
                    containerMG.setMaxOccurs(attr.getOccurs());
                    containerMG.setStyleInfo(this.getChoiceStyleInfo(attr));
                }
            }
            SchemaComponent particle = null;
            for (int i = 0; i < wizardProxy.getRecordTypeCount(); ++i) {
                short recordType;
                if (wizardProxy.isChoiceRecord(i)) {
                    boolean bl = true;
                }
                if ((recordType = wizardProxy.getRecordAttributes(i).getRecType() == 9 ? (short)2 : (wizardProxy.getRecordAttributes(i).getRecType() == 99 ? (short)6 : 1)) == 6 || (particle = this.getComplexRecord(wizardProxy, i, recordType)) == null) continue;
                if (particle.getStyleInfo() == null) {
                    if (particle instanceof ComplexTypeDecl) {
                        ((ComplexTypeDecl)particle).setStyleInfo(new NXSDStyleInfo());
                    } else if (particle instanceof ElementDecl) {
                        ((ElementDecl)particle).setStyleInfo(new NXSDStyleInfo());
                    }
                }
                if (wizardProxy.isChoiceRecord(i)) {
                    particle.getStyleInfo().setConditionValue(wizardProxy.getChoiceConditionValue(i));
                }
                if (recordType == 1) {
                    if (this._choiceFlag) {
                        if (!wizardProxy.isChoiceRecord(i)) continue;
                        containerMG.addParticle((Particle)particle);
                        continue;
                    }
                    containerMG.addParticle((Particle)particle);
                    continue;
                }
                if (this._complexTypeMap.containsKey(wizardProxy.getRecordName(i))) continue;
                this._complexTypeMap.put(wizardProxy.getRecordName(i), particle);
            }
            def.addGlobalDeclaration((SchemaComponent)container);
            Iterator i = this._complexTypeMap.values().iterator();
            while (i.hasNext()) {
                def.addGlobalDeclaration((SchemaComponent)i.next());
            }
        }
        NXSDCompiler compiler = new NXSDCompiler();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        compiler.compileFromDef(def, (OutputStream)baos);
        String encodedNxsd = "";
        try {
            encodedNxsd = baos.toString(def.getEncodingOfNxsdDoc());
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        return encodedNxsd;
    }

    private NXSDStyleInfo getChoiceStyleInfo(RecTypeAttributes attr) {
        NXSDStyleInfo styleInfo = new NXSDStyleInfo();
        if (attr != null) {
            if (attr.getChoiceType().equals("F")) {
                styleInfo.setChoiceCondition("fixedLength");
                styleInfo.setLength(Integer.valueOf(attr.getLength()).toString());
            } else if (attr.getChoiceType().equals("D")) {
                styleInfo.setChoiceCondition("terminated");
                styleInfo.setTerminatedBy(attr.getStylePattern1());
            } else if (attr.getChoiceType().equals("V")) {
                styleInfo.setChoiceCondition(this.getConvertedVarName(attr.getVarName()));
                styleInfo.setLookAhead(attr.getLookAhead());
                styleInfo.setScanLength(attr.getScanLength());
                styleInfo.setAssignTo(this.getConvertedVarName(attr.getAssignTo()));
            }
        }
        return styleInfo;
    }

    private ElementDecl getRecord(NXSDGenerator wizardProxy, int record) {
        NXSDStyleInfo styleInfo = null;
        ElementDecl element = new ElementDecl();
        element.setName(wizardProxy.getRecordName(record));
        if (wizardProxy.isFixedLengthType()) {
            styleInfo = new NXSDStyleInfo();
            styleInfo.setStyle("array");
            styleInfo.setCellSeparatedBy(wizardProxy.getRecordSeparator(0));
            element.setStyleInfo(styleInfo);
        }
        ComplexTypeDecl complexType = new ComplexTypeDecl();
        element.setTypeDefinition((Type)complexType);
        ModelGroupDecl modelGroup = new ModelGroupDecl();
        complexType.setModelGroup(modelGroup);
        modelGroup.setModelGroupType((short)5);
        ElementDecl particle = null;
        SimpleTypeDecl simpleType = null;
        int fields = wizardProxy.getFieldCount(record);
        for (int i = 0; i < fields; ++i) {
            particle = new ElementDecl();
            particle.setName(wizardProxy.getFieldName(record, i));
            simpleType = new SimpleTypeDecl();
            particle.setTypeDefinition((Type)simpleType);
            simpleType.setBaseType(SimpleTypeDecl.getType((String)wizardProxy.getFieldType(record, i)));
            styleInfo = new NXSDStyleInfo();
            if (wizardProxy.isFixedLengthType()) {
                styleInfo.setStyle("fixedLength");
                styleInfo.setLength("" + wizardProxy.getFieldLength(record, i));
            } else if (wizardProxy.isDelimitedType()) {
                styleInfo.setStyle("terminated");
                styleInfo.setTerminatedBy(wizardProxy.getFieldTerminator(record, i));
                if (!wizardProxy.getFieldQuotedBy(record, i).equals("")) {
                    styleInfo.setQuotedBy(wizardProxy.getFieldQuotedBy(record, i));
                }
            }
            particle.setStyleInfo(styleInfo);
            modelGroup.addParticle((Particle)particle);
        }
        return element;
    }

    private SchemaComponent getComplexRecord(ComplexNXSDGenerator wizardProxy, int record, short schemaComponent) {
        NXSDStyleInfo styleInfo = null;
        ComplexTypeDecl complexType = null;
        ElementDecl element = null;
        ComplexTypeDecl globalComplexType = null;
        if (schemaComponent == 1) {
            RecTypeAttributes recAttributes = wizardProxy.getRecordAttributes(record);
            element = new ElementDecl();
            element.setName(wizardProxy.getRecordName(record));
            styleInfo = new NXSDStyleInfo();
            styleInfo = this.fillStyleInfo(wizardProxy, record);
            if (recAttributes.getOccurs() == 0x7FFFFFF8) {
                element.setMaxOccurs(0x7FFFFFF8);
            } else if (recAttributes.getOccurs() > 1) {
                element.setMaxOccurs(recAttributes.getOccurs());
            }
            if (recAttributes.isArray() && !recAttributes.getArrayLength().equals("0")) {
                element.setMaxOccurs(new Integer(recAttributes.getArrayLength()).intValue());
            }
            if (recAttributes.getMinOccurs() == 0) {
                element.setMinOccurs(0);
            }
            element.setStyleInfo(styleInfo);
            if (Arrays.asList(FlatFileInfo.getXmlDataTypes()).contains(recAttributes.getType())) {
                SimpleTypeDecl simpleType = new SimpleTypeDecl();
                element.setTypeDefinition((Type)simpleType);
                simpleType.setBaseType(SimpleTypeDecl.getType((String)recAttributes.getType()));
            } else {
                complexType = new ComplexTypeDecl();
                element.setTypeDefinition((Type)complexType);
                if (!recAttributes.getType().equals("")) {
                    complexType.setName(recAttributes.getType());
                }
            }
        } else {
            globalComplexType = new ComplexTypeDecl();
            globalComplexType.setName(wizardProxy.getRecordName(record));
            styleInfo = new NXSDStyleInfo();
            styleInfo = this.fillStyleInfo(wizardProxy, record);
            globalComplexType.setStyleInfo(styleInfo);
        }
        ModelGroupDecl modelGroup = new ModelGroupDecl();
        modelGroup.setModelGroupType((short)5);
        ElementDecl particle = null;
        SimpleTypeDecl simpleType = null;
        if (wizardProxy.getRecordAttributes(record).getType().equals("")) {
            int fields = wizardProxy.getFieldCount(record);
            for (int i = 0; i < fields; ++i) {
                particle = new ElementDecl();
                particle.setName(wizardProxy.getFieldName(record, i));
                if (wizardProxy.getFieldMinOccurs(record, i).equals("0")) {
                    particle.setMinOccurs(0);
                }
                if (!wizardProxy.getFieldDefault(record, i).equals("")) {
                    particle.setDefaultVal(wizardProxy.getFieldDefault(record, i));
                }
                String fldType = wizardProxy.getFieldType(record, i);
                if (Arrays.asList(FlatFileInfo.getXmlDataTypes()).contains(fldType)) {
                    simpleType = new SimpleTypeDecl();
                    particle.setTypeDefinition((Type)simpleType);
                    int maxOccurs = -1;
                    if (!wizardProxy.getFieldMaxOccurs(record, i).equals("1")) {
                        maxOccurs = wizardProxy.getFieldMaxOccurs(record, i).equals("UNBOUNDED") ? 0x7FFFFFF8 : Integer.parseInt(wizardProxy.getFieldMaxOccurs(record, i));
                        particle.setMaxOccurs(maxOccurs);
                    }
                    simpleType.setBaseType(SimpleTypeDecl.getType((String)wizardProxy.getFieldType(record, i)));
                    styleInfo = this.fillStyleInfo(wizardProxy, record, i);
                } else {
                    String fieldType = wizardProxy.getFieldType(record, i);
                    styleInfo = new NXSDStyleInfo();
                    if (!wizardProxy.getFieldMaxOccurs(record, i).equals("1")) {
                        if (wizardProxy.getFieldMaxOccurs(record, i).equals("UNBOUNDED")) {
                            particle.setMaxOccurs(0x7FFFFFF8);
                        } else {
                            int maxOccurs = Integer.parseInt(wizardProxy.getFieldMaxOccurs(record, i));
                            particle.setMaxOccurs(maxOccurs);
                        }
                    }
                    if (wizardProxy.isFieldArray(record, i)) {
                        styleInfo.setStyle("array");
                        if (!wizardProxy.getFieldArrayLength(record, i).equals("0")) {
                            styleInfo.setArrayLength(wizardProxy.getFieldArrayLength(record, i));
                        }
                        styleInfo.setCellSeparatedBy(wizardProxy.getFieldCellSep(record, i));
                        if (!wizardProxy.getFieldArraySep(record, i).equals("")) {
                            styleInfo.setArrayTerminatedBy(wizardProxy.getFieldArraySep(record, i));
                        }
                    }
                    if (wizardProxy.isFieldList(record, i)) {
                        styleInfo.setStyle("list");
                        if (!wizardProxy.getFieldItemSep(record, i).equals("")) {
                            styleInfo.setItemSeparatedBy(wizardProxy.getFieldItemSep(record, i));
                        }
                        if (!wizardProxy.getFieldListSep(record, i).equals("")) {
                            styleInfo.setListTerminatedBy(wizardProxy.getFieldListSep(record, i));
                        }
                    }
                    ComplexTypeDecl fieldComplexType = new ComplexTypeDecl();
                    particle.setTypeDefinition((Type)fieldComplexType);
                    if (!Arrays.asList(FlatFileInfo.getXmlDataTypes()).contains(fieldType)) {
                        fieldComplexType.setName(fieldType);
                    }
                }
                if (!wizardProxy.getFieldMinOccurs(record, i).equals("1")) {
                    particle.setMinOccurs(Integer.parseInt(wizardProxy.getFieldMinOccurs(record, i)));
                }
                if (((Boolean)wizardProxy.getFieldDataSource(record).getData(0, i)).booleanValue()) continue;
                particle.setStyleInfo(styleInfo);
                modelGroup.addParticle((Particle)particle);
            }
        }
        if (schemaComponent == 1) {
            if (wizardProxy.getRecordAttributes(record).getType().equals("")) {
                complexType.setModelGroup(modelGroup);
            }
            return element;
        }
        globalComplexType.setModelGroup(modelGroup);
        return globalComplexType;
    }

    public Vector getRootElementList(String nxsdFile) {
        Vector<String> rootElements = new Vector<String>();
        try {
            XSDBuilder builder = new XSDBuilder();
            XMLSchema schema = builder.build((InputStream)new FileInputStream(nxsdFile), null);
            XMLSchemaNode schemaNode = schema.getSchemaByTargetNS(schema.getSchemaTargetNS());
            XSDNode[] globalElements = schemaNode.getElementSet();
            for (int i = 0; i < globalElements.length; ++i) {
                rootElements.add(globalElements[i].getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rootElements;
    }

    public FlatFileInfo convertTowizardInfo(FlatFileInfo wizardInfo, String nxsdFile, String root) throws NXSDException {
        NXSDCompiler compiler = new NXSDCompiler();
        NXSDDefinition def = new NXSDDefinition();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(nxsdFile);
        }
        catch (Exception e) {
            // empty catch block
        }
        compiler.compileToDef(def, (InputStream)fis);
        if (def.getGlobalDeclarations().length > 1) {
            if (root == null) {
                throw new NXSDException(11301);
            }
            for (int i = 0; i < def.getGlobalDeclarations().length; ++i) {
                ElementDecl globalElementDecl;
                if (!(def.getGlobalDeclarations()[i] instanceof ElementDecl) || !root.equals((globalElementDecl = (ElementDecl)def.getGlobalDeclarations()[i]).getName())) continue;
                def.setRootElement(globalElementDecl);
                break;
            }
            if (def.getRootElement() == null) {
                throw new NXSDException(11301);
            }
        } else if (def.getGlobalDeclarations()[0] instanceof ElementDecl) {
            def.setRootElement((ElementDecl)def.getGlobalDeclarations()[0]);
        } else {
            throw new NXSDException(11301);
        }
        if (this.isComplexTypeInNativeDefinition(def)) {
            return this.doConvertToComplexwizardInfo(wizardInfo, def);
        }
        return this.doConvertTowizardInfo(wizardInfo, def);
    }

    private FlatFileInfo doConvertTowizardInfo(FlatFileInfo flatFileInfo, NXSDDefinition def) throws NXSDException {
        NXSDGenerator wizardProxy = new NXSDGenerator(flatFileInfo);
        try {
            wizardProxy.setNxsdEncoding(def.getEncodingOfNxsdDoc());
            wizardProxy.setNamespace(def.getTargetNamespace());
            wizardProxy.setHeaderLines(def.getHeaderLines());
            ComplexTypeDecl complexType = (ComplexTypeDecl)def.getRootElement().getTypeDefinition();
            ElementDecl child = (ElementDecl)complexType.getModelGroup().getParticles()[0];
            if (child.getTypeDefinition().getComponentType() == 3) {
                wizardProxy.setRecordType((short)0);
                if (child.getStyleInfo().getStyle().equals("fixedLength")) {
                    wizardProxy.setFieldStyle((short)3);
                } else if (child.getStyleInfo().getStyle().equals("terminated")) {
                    wizardProxy.setFieldStyle((short)4);
                }
                this.fillRecord(wizardProxy, def.getRootElement(), 0);
            } else {
                wizardProxy.setContainerName(def.getRootElement().getName());
                ElementDecl grandChild = (ElementDecl)((ComplexTypeDecl)child.getTypeDefinition()).getModelGroup().getParticles()[0];
                if (grandChild.getStyleInfo().getStyle().equals("fixedLength")) {
                    wizardProxy.setFieldStyle((short)3);
                } else if (grandChild.getStyleInfo().getStyle().equals("terminated")) {
                    wizardProxy.setFieldStyle((short)4);
                }
                if (child.getStyleInfo().getConditionValue() != null) {
                    wizardProxy.setRecordType((short)2);
                    wizardProxy.setChoiceCondition(((ComplexTypeDecl)def.getRootElement().getTypeDefinition()).getModelGroup().getStyleInfo().getChoiceCondition());
                    wizardProxy.setChoiceConditionLen(((ComplexTypeDecl)def.getRootElement().getTypeDefinition()).getModelGroup().getStyleInfo().getLength());
                    wizardProxy.setChoiceConditionTerminatedBy(((ComplexTypeDecl)def.getRootElement().getTypeDefinition()).getModelGroup().getStyleInfo().getTerminatedBy());
                    Particle[] records = ((ComplexTypeDecl)def.getRootElement().getTypeDefinition()).getModelGroup().getParticles();
                    ElementDecl record = null;
                    for (int i = 0; i < records.length; ++i) {
                        record = (ElementDecl)records[i];
                        this.fillRecord(wizardProxy, record, i);
                    }
                } else {
                    wizardProxy.setRecordType((short)1);
                    this.fillRecord(wizardProxy, child, 0);
                    wizardProxy.setRecordDelimiter(child.getStyleInfo().getCellSeparatedBy());
                }
            }
        }
        catch (Exception e) {
            throw new NXSDException(11302, new Object[]{e.getMessage()}, (Throwable)e);
        }
        return flatFileInfo;
    }

    private FlatFileInfo doConvertToComplexwizardInfo(FlatFileInfo flatFileInfo, NXSDDefinition def) throws NXSDException {
        ComplexNXSDGenerator wizardProxy = new ComplexNXSDGenerator(flatFileInfo);
        try {
            wizardProxy.setNxsdEncoding(def.getEncodingOfNxsdDoc());
            wizardProxy.setNamespace(def.getTargetNamespace());
            wizardProxy.setHeaderLines(def.getHeaderLines());
            wizardProxy.setContainerName(def.getRootElement().getName());
            RecTypeTreeModel treeModel = new RecTypeTreeModel((TreeNode)((Object)new RecTypeExplorerTreeNode(MessageBundleUtil.getCommonString((String)"UI_TE_TREE_EXPLORER", (String)"Generic Tree Explorer"))));
            wizardProxy.setSchemaTreeModel(treeModel);
            wizardProxy.setSchemaTreeRoot();
            wizardProxy.setRecordType((short)2);
            int recordNum = 0;
            ModelGroupDecl modelGrp = ((ComplexTypeDecl)def.getRootElement().getTypeDefinition()).getModelGroup();
            short grpType = modelGrp.getModelGroupType();
            if (grpType == 6) {
                this.fillComplexRecord(wizardProxy, (SchemaComponent)modelGrp, recordNum);
                wizardProxy.addSchemaTreeBranch(recordNum);
                ++recordNum;
            }
            Particle[] records = ((ComplexTypeDecl)def.getRootElement().getTypeDefinition()).getModelGroup().getParticles();
            ElementDecl record = null;
            int recNum = 0;
            for (recNum = 0; recNum < records.length; ++recNum) {
                record = (ElementDecl)records[recNum];
                this.fillComplexRecord(wizardProxy, (SchemaComponent)record, recNum + recordNum);
                if (recordNum > 0) {
                    wizardProxy.addSchemaTreeChoiceElement(recNum + recordNum);
                    continue;
                }
                wizardProxy.addSchemaTreeBranch(recNum + recordNum);
            }
            SchemaComponent[] complexTypes = def.getGlobalDeclarations();
            ComplexTypeDecl complexTypeRecord = null;
            for (int j = 0; j < complexTypes.length; ++j) {
                if (!(complexTypes[j] instanceof ComplexTypeDecl)) continue;
                complexTypeRecord = (ComplexTypeDecl)complexTypes[j];
                this.fillComplexRecord(wizardProxy, (SchemaComponent)complexTypeRecord, recNum + recordNum);
                wizardProxy.addSchemaTreeBranch(recNum + recordNum);
                ++recNum;
            }
        }
        catch (Exception e) {
            throw new NXSDException(11302, new Object[]{e.getMessage()}, (Throwable)e);
        }
        return flatFileInfo;
    }

    private void fillRecord(NXSDGenerator wizardProxy, ElementDecl element, int recordNum) {
        Particle[] fields = ((ComplexTypeDecl)element.getTypeDefinition()).getModelGroup().getParticles();
        wizardProxy.setRecordName(recordNum, element.getName(), fields.length);
        wizardProxy.setChoiceValue(recordNum, element.getStyleInfo().getConditionValue());
        ElementDecl field = null;
        for (int i = 0; i < fields.length; ++i) {
            field = (ElementDecl)fields[i];
            wizardProxy.setFieldName(recordNum, i, field.getName());
            wizardProxy.setFieldType(recordNum, i, ((SimpleTypeDecl)field.getTypeDefinition()).getBaseTypeAsString());
            wizardProxy.setFieldLength(recordNum, i, field.getStyleInfo().getLength());
            wizardProxy.setFieldTerminator(recordNum, i, field.getStyleInfo().getTerminatedBy());
            wizardProxy.setFieldQuotedBy(recordNum, i, field.getStyleInfo().getQuotedBy());
        }
    }

    private void fillComplexRecord(ComplexNXSDGenerator wizardProxy, SchemaComponent component, int recordNum) {
        RecTypeAttributes recAttr;
        ElementDecl element = null;
        ComplexTypeDecl complexType = null;
        ModelGroupDecl choiceDecl = null;
        Particle[] fields = null;
        if (component instanceof ElementDecl) {
            element = (ElementDecl)component;
            recAttr = this.populateRecordAttributes((SchemaComponent)element);
            if (element.getTypeDefinition().getName() == null) {
                fields = ((ComplexTypeDecl)element.getTypeDefinition()).getModelGroup().getParticles();
            }
            if (fields != null) {
                wizardProxy.setRecordName(recordNum, element.getName(), recAttr, fields.length);
            } else {
                wizardProxy.setRecordName(recordNum, element.getName(), recAttr, 1);
            }
        } else if (component instanceof ModelGroupDecl) {
            choiceDecl = (ModelGroupDecl)component;
            recAttr = this.populateRecordAttributes((SchemaComponent)choiceDecl);
            wizardProxy.setChoiceRecord(recordNum, "choice", recAttr);
        } else {
            complexType = (ComplexTypeDecl)component;
            recAttr = this.populateRecordAttributes((SchemaComponent)complexType);
            fields = complexType.getModelGroup().getParticles();
            wizardProxy.setRecordName(recordNum, complexType.getName(), recAttr, fields.length);
        }
        if (fields != null) {
            ElementDecl field = null;
            for (int i = 0; i < fields.length; ++i) {
                field = (ElementDecl)fields[i];
                wizardProxy.initFieldProperties(recordNum, i);
                wizardProxy.setFieldName(recordNum, i, field.getName());
                wizardProxy.setFieldType(recordNum, i, field.getTypeDefinition().getName());
                if (wizardProxy.getFieldType(recordNum, i).equals("date") || wizardProxy.getFieldType(recordNum, i).equals("dateTime")) {
                    wizardProxy.setFieldDateFormat(recordNum, i, field.getStyleInfo().getDateFormat());
                }
                wizardProxy.setFieldLength(recordNum, i, field.getStyleInfo().getLength());
                String fieldStyle = field.getStyleInfo().getStyle();
                wizardProxy.setFieldStyle(recordNum, i, fieldStyle);
                if (fieldStyle != null) {
                    if (fieldStyle.equals("surrounded")) {
                        if (field.getStyleInfo().getLeftSurroundedBy() != null && field.getStyleInfo().getRightSurroundedBy() != null) {
                            wizardProxy.setFieldStylePattern1(recordNum, i, field.getStyleInfo().getLeftSurroundedBy());
                            wizardProxy.setFieldStylePattern2(recordNum, i, field.getStyleInfo().getRightSurroundedBy());
                        } else {
                            wizardProxy.setFieldStylePattern1(recordNum, i, field.getStyleInfo().getSurroundedBy());
                        }
                    } else if (fieldStyle.equals("terminated")) {
                        wizardProxy.setFieldStylePattern1(recordNum, i, field.getStyleInfo().getTerminatedBy());
                    } else if (fieldStyle.equals("array")) {
                        wizardProxy.setFieldArray(recordNum, i, true);
                    } else if (fieldStyle.equals("list")) {
                        wizardProxy.setFieldList(recordNum, i, true);
                    }
                }
                wizardProxy.setFieldPadStyle(recordNum, i, field.getStyleInfo().getPadStyle());
                wizardProxy.setFieldPadding(recordNum, i, field.getStyleInfo().getPaddedBy());
                wizardProxy.setFieldDefault(recordNum, i, field.getDefaultVal());
                wizardProxy.setFieldStartsWith(recordNum, i, field.getStyleInfo().getStartsWith());
                wizardProxy.setFieldPrefix(recordNum, i, field.getStyleInfo().getPrefixWith());
                wizardProxy.setFieldSuffix(recordNum, i, field.getStyleInfo().getSuffixWith());
                wizardProxy.setFieldLookAhead(recordNum, i, field.getStyleInfo().getLookAhead());
                wizardProxy.setFieldLookFor(recordNum, i, field.getStyleInfo().getLookFor());
                wizardProxy.setFieldMinOccurs(recordNum, i, new Integer(field.getMinOccurs()).toString());
                wizardProxy.setFieldMaxOccurs(recordNum, i, new Integer(field.getMaxOccurs()).toString());
                wizardProxy.setFieldArrayLength(recordNum, i, field.getStyleInfo().getArrayLength());
                wizardProxy.setFieldArraySep(recordNum, i, field.getStyleInfo().getArrayTerminatedBy());
                wizardProxy.setFieldCellSep(recordNum, i, field.getStyleInfo().getCellSeparatedBy());
                wizardProxy.setFieldQuotedBy(recordNum, i, field.getStyleInfo().getQuotedBy());
                wizardProxy.setFieldItemSep(recordNum, i, field.getStyleInfo().getItemSeparatedBy());
                wizardProxy.setFieldListSep(recordNum, i, field.getStyleInfo().getListTerminatedBy());
                wizardProxy.setFieldSkipMode(recordNum, i, field.getStyleInfo().getSkipMode());
                wizardProxy.setFieldSkip(recordNum, i, field.getStyleInfo().getSkip());
                wizardProxy.setFieldSkipUntil(recordNum, i, field.getStyleInfo().getSkipUntil());
            }
        }
    }

    private NXSDStyleInfo fillStyleInfo(ComplexNXSDGenerator wizardProxy, int recordNum, int fieldNum) {
        NXSDStyleInfo styleInfo = null;
        styleInfo = new NXSDStyleInfo();
        if (!Arrays.asList(FlatFileInfo.getXmlDataTypes()).contains(wizardProxy.getFieldType(recordNum, fieldNum))) {
            RecTypeAttributes recAttr = wizardProxy.getRecordAttributes(recordNum);
            if (recAttr.isArray()) {
                styleInfo.setStyle("array");
                if (!recAttr.getArrayLength().equals("0")) {
                    styleInfo.setArrayLength(recAttr.getArrayLength());
                }
                styleInfo.setArrayTerminatedBy(this.translateSpecialCharToXSDFormat(recAttr.getArraySeparator()));
                if (!recAttr.getCellSeparator().equals("")) {
                    styleInfo.setCellSeparatedBy(this.translateSpecialCharToXSDFormat(recAttr.getCellSeparator()));
                }
            }
            if (recAttr.isList()) {
                styleInfo.setStyle("list");
                styleInfo.setListTerminatedBy(this.translateSpecialCharToXSDFormat(recAttr.getListSeparator()));
                styleInfo.setItemSeparatedBy(this.translateSpecialCharToXSDFormat(recAttr.getItemSeparator()));
            }
        } else {
            if (wizardProxy.getFieldStyle(recordNum, fieldNum) == "fixedLength") {
                styleInfo.setStyle("fixedLength");
                styleInfo.setLength("" + wizardProxy.getFieldLength(recordNum, fieldNum));
            } else if (wizardProxy.getFieldStyle(recordNum, fieldNum) == "terminated") {
                styleInfo.setStyle("terminated");
                styleInfo.setTerminatedBy(wizardProxy.getFieldStylePattern(recordNum, fieldNum)[0]);
                if (!wizardProxy.getFieldQuotedBy(recordNum, fieldNum).equals("")) {
                    styleInfo.setQuotedBy(wizardProxy.getFieldQuotedBy(recordNum, fieldNum));
                }
            } else if (wizardProxy.getFieldStyle(recordNum, fieldNum) == "surrounded") {
                styleInfo.setStyle("surrounded");
                styleInfo.setSurroundedBy(wizardProxy.getFieldStylePattern(recordNum, fieldNum)[0]);
            } else if (wizardProxy.getFieldStyle(recordNum, fieldNum) == "left/right surrounded") {
                styleInfo.setStyle("surrounded");
                styleInfo.setLeftSurroundedBy(wizardProxy.getFieldStylePattern(recordNum, fieldNum)[0]);
                styleInfo.setRightSurroundedBy(wizardProxy.getFieldStylePattern(recordNum, fieldNum)[1]);
            }
            if (!wizardProxy.getFieldPadStyle(recordNum, fieldNum).equals("")) {
                styleInfo.setPadStyle(wizardProxy.getFieldPadStyle(recordNum, fieldNum));
                styleInfo.setPaddedBy(wizardProxy.getFieldPadding(recordNum, fieldNum));
            }
            if (!wizardProxy.getFieldStartsWith(recordNum, fieldNum).equals("")) {
                styleInfo.setStartsWith(wizardProxy.getFieldStartsWith(recordNum, fieldNum));
            }
            if (wizardProxy.getFieldLengthStyle(recordNum, fieldNum).equals("Identifier")) {
                styleInfo.setIdentifierLength(String.valueOf(wizardProxy.getFieldLength(recordNum, fieldNum)));
            }
            if (!wizardProxy.getFieldPrefix(recordNum, fieldNum).equals("")) {
                styleInfo.setPrefixWith(wizardProxy.getFieldPrefix(recordNum, fieldNum));
            }
            if (!wizardProxy.getFieldSuffix(recordNum, fieldNum).equals("")) {
                styleInfo.setSuffixWith(wizardProxy.getFieldSuffix(recordNum, fieldNum));
            }
            if (!wizardProxy.getFieldLookAhead(recordNum, fieldNum).equals("0")) {
                styleInfo.setLookAhead(wizardProxy.getFieldLookAhead(recordNum, fieldNum));
                styleInfo.setLookFor(wizardProxy.getFieldLookFor(recordNum, fieldNum));
            }
            if (wizardProxy.getFieldType(recordNum, fieldNum).equals("date") || wizardProxy.getFieldType(recordNum, fieldNum).equals("dateTime")) {
                styleInfo.setDateFormat(wizardProxy.getFieldDateFormat(recordNum, fieldNum));
            }
            if (!wizardProxy.getFieldSkipMode(recordNum, fieldNum).equals("")) {
                styleInfo.setSkipMode(wizardProxy.getFieldSkipMode(recordNum, fieldNum));
                if (!wizardProxy.getFieldSkip(recordNum, fieldNum).equals("0")) {
                    styleInfo.setSkip(wizardProxy.getFieldSkip(recordNum, fieldNum));
                }
                if (!wizardProxy.getFieldSkipUntil(recordNum, fieldNum).equals("")) {
                    styleInfo.setSkipUntil(wizardProxy.getFieldSkipUntil(recordNum, fieldNum));
                }
            }
        }
        return styleInfo;
    }

    private NXSDStyleInfo fillStyleInfo(ComplexNXSDGenerator wizardProxy, int recordNum) {
        NXSDStyleInfo styleInfo = null;
        styleInfo = new NXSDStyleInfo();
        RecTypeAttributes recAttr = wizardProxy.getRecordAttributes(recordNum);
        if (recAttr.isArray()) {
            styleInfo.setStyle("array");
            if (!recAttr.getArrayLength().equals("0")) {
                styleInfo.setArrayLength(recAttr.getArrayLength());
            }
            if (!recAttr.getArraySeparator().equals("")) {
                styleInfo.setArrayTerminatedBy(this.translateSpecialCharToXSDFormat(recAttr.getArraySeparator()));
            }
            if (!recAttr.getCellSeparator().equals("")) {
                styleInfo.setCellSeparatedBy(this.translateSpecialCharToXSDFormat(recAttr.getCellSeparator()));
            }
        }
        if (recAttr.isList()) {
            styleInfo.setStyle("list");
            if (!recAttr.getListSeparator().equals("")) {
                styleInfo.setListTerminatedBy(this.translateSpecialCharToXSDFormat(recAttr.getListSeparator()));
            }
            styleInfo.setItemSeparatedBy(this.translateSpecialCharToXSDFormat(recAttr.getItemSeparator()));
        }
        if (recAttr.getStyle() == "fixedLength") {
            styleInfo.setStyle("fixedLength");
            styleInfo.setLength("" + recAttr.getLength());
        } else if (recAttr.getStyle() == "terminated") {
            styleInfo.setStyle("terminated");
            styleInfo.setTerminatedBy(this.translateSpecialCharToXSDFormat(recAttr.getStylePattern1()));
            if (!recAttr.getQuotedBy().equals("")) {
                styleInfo.setQuotedBy(this.translateSpecialCharToXSDFormat(recAttr.getQuotedBy()));
            }
        } else if (recAttr.getStyle() == "surrounded") {
            styleInfo.setStyle("surrounded");
            styleInfo.setSurroundedBy(this.translateSpecialCharToXSDFormat(recAttr.getStylePattern1()));
        } else if (recAttr.getStyle() == "left/right surrounded") {
            styleInfo.setStyle("surrounded");
            styleInfo.setLeftSurroundedBy(this.translateSpecialCharToXSDFormat(recAttr.getStylePattern1()));
            styleInfo.setRightSurroundedBy(this.translateSpecialCharToXSDFormat(recAttr.getStylePattern2()));
        }
        if (!recAttr.getPadStyle().equals("")) {
            styleInfo.setPadStyle(recAttr.getPadStyle());
            styleInfo.setPaddedBy(this.translateSpecialCharToXSDFormat(recAttr.getPadding()));
        }
        if (!recAttr.getStartsWith().equals("")) {
            styleInfo.setStartsWith(this.translateSpecialCharToXSDFormat(recAttr.getStartsWith()));
        }
        if (recAttr.getLengthStyle().equals("Identifier")) {
            styleInfo.setIdentifierLength(String.valueOf(recAttr.getLength()));
        }
        if (!recAttr.getPrefix().equals("")) {
            styleInfo.setPrefixWith(this.translateSpecialCharToXSDFormat(recAttr.getPrefix()));
        }
        if (!recAttr.getSuffix().equals("")) {
            styleInfo.setSuffixWith(this.translateSpecialCharToXSDFormat(recAttr.getSuffix()));
        }
        if (!recAttr.getLookAhead().equals("0")) {
            styleInfo.setLookAhead(recAttr.getLookAhead());
            styleInfo.setLookFor(this.translateSpecialCharToXSDFormat(recAttr.getLookFor()));
        }
        if (recAttr.getType().equals("date") || recAttr.getType().equals("dateTime")) {
            styleInfo.setDateFormat(recAttr.getDateFormat());
        }
        if (!recAttr.getSkipMode().equals("")) {
            styleInfo.setSkipMode(recAttr.getSkipMode());
            if (!recAttr.getSkip().equals("0")) {
                styleInfo.setSkip(recAttr.getSkip());
            }
            if (!recAttr.getSkipUntil().equals("")) {
                styleInfo.setSkipUntil(recAttr.getSkipUntil());
            }
        }
        return styleInfo;
    }

    private RecTypeAttributes populateRecordAttributes(SchemaComponent element) {
        RecTypeAttributes recAttr = new RecTypeAttributes();
        if (element instanceof ElementDecl) {
            ElementDecl elementDecl = (ElementDecl)element;
            recAttr.setRecType(0);
            if (elementDecl.getTypeDefinition().getName() != null) {
                recAttr.setType(elementDecl.getTypeDefinition().getName());
            }
            if (recAttr.getType().equals("date") || recAttr.getType().equals("dateTime")) {
                recAttr.setDateFormat(elementDecl.getStyleInfo().getDateFormat());
            }
            recAttr.setMinOccurs(elementDecl.getMinOccurs());
            recAttr.setOccurs(elementDecl.getMaxOccurs());
            if (elementDecl.getStyleInfo() != null) {
                if (elementDecl.getStyleInfo().getConditionValue() != null) {
                    recAttr.setChoiceValue(elementDecl.getStyleInfo().getConditionValue());
                    recAttr.setChoice(true);
                }
                if (elementDecl.getStyleInfo().getStartsWith() != null) {
                    recAttr.setStartsWith(elementDecl.getStyleInfo().getStartsWith());
                }
                if (elementDecl.getStyleInfo().getArrayLength() != null || elementDecl.getStyleInfo().getArrayTerminatedBy() != null || elementDecl.getStyleInfo().getCellSeparatedBy() != null) {
                    recAttr.setArray(true);
                    if (elementDecl.getStyleInfo().getArrayTerminatedBy() != null) {
                        recAttr.setArraySeparator(elementDecl.getStyleInfo().getArrayTerminatedBy());
                    }
                    if (elementDecl.getStyleInfo().getCellSeparatedBy() != null) {
                        recAttr.setCellSeparator(elementDecl.getStyleInfo().getCellSeparatedBy());
                    }
                    if (elementDecl.getStyleInfo().getArrayLength() != null) {
                        recAttr.setArrayLength(elementDecl.getStyleInfo().getArrayLength());
                    }
                }
                if (elementDecl.getStyleInfo().getListTerminatedBy() != null || elementDecl.getStyleInfo().getItemSeparatedBy() != null) {
                    recAttr.setList(true);
                    if (elementDecl.getStyleInfo().getListTerminatedBy() != null) {
                        recAttr.setListSeparator(elementDecl.getStyleInfo().getListTerminatedBy());
                    }
                    if (elementDecl.getStyleInfo().getItemSeparatedBy() != null) {
                        recAttr.setItemSeparator(elementDecl.getStyleInfo().getItemSeparatedBy());
                    }
                }
                if (elementDecl.getStyleInfo().getStyle() != null) {
                    recAttr.setStyle(elementDecl.getStyleInfo().getStyle());
                    if (elementDecl.getStyleInfo().getStyle().equals("terminated")) {
                        recAttr.setStylePattern1(elementDecl.getStyleInfo().getTerminatedBy());
                    } else if (elementDecl.getStyleInfo().getStyle().equals("surrounded")) {
                        recAttr.setStylePattern1(elementDecl.getStyleInfo().getSurroundedBy());
                    }
                }
                if (elementDecl.getStyleInfo().getLookAhead() != null) {
                    recAttr.setLookAhead(elementDecl.getStyleInfo().getLookAhead());
                    if (elementDecl.getStyleInfo().getLookFor() != null) {
                        recAttr.setLookFor(elementDecl.getStyleInfo().getLookFor());
                    }
                }
                if (elementDecl.getStyleInfo().getSkipMode() != null) {
                    recAttr.setSkipMode(elementDecl.getStyleInfo().getSkipMode());
                    if (elementDecl.getStyleInfo().getSkip() != null) {
                        recAttr.setSkip(elementDecl.getStyleInfo().getSkip());
                    }
                    if (elementDecl.getStyleInfo().getSkipUntil() != null) {
                        recAttr.setSkipUntil(elementDecl.getStyleInfo().getSkipUntil());
                    }
                }
            }
            recAttr.setRecordName(elementDecl.getName());
        } else if (element instanceof ModelGroupDecl) {
            ModelGroupDecl choiceDecl = (ModelGroupDecl)element;
            NXSDStyleInfo choiceStyleInfo = choiceDecl.getStyleInfo();
            recAttr.setRecType(99);
            recAttr.setRecordName("choice");
            recAttr.setMinOccurs(choiceDecl.getMinOccurs());
            recAttr.setOccurs(choiceDecl.getMaxOccurs());
            if (choiceStyleInfo.getChoiceCondition().equals("terminated")) {
                recAttr.setChoiceType("D");
                recAttr.setStylePattern1(choiceStyleInfo.getTerminatedBy());
            } else if (choiceStyleInfo.getChoiceCondition().equals("fixedLength")) {
                recAttr.setChoiceType("F");
                recAttr.setLength(Integer.parseInt(choiceStyleInfo.getLength()));
            } else if (!choiceStyleInfo.getChoiceCondition().equals("")) {
                recAttr.setChoiceType("V");
                recAttr.setVarName(choiceStyleInfo.getChoiceCondition());
                recAttr.setLookAhead(choiceStyleInfo.getLookAhead());
                recAttr.setScanLength(choiceStyleInfo.getScanLength());
                recAttr.setAssignTo(choiceStyleInfo.getAssignTo());
            } else {
                recAttr.setChoiceType("A");
            }
        } else {
            recAttr.setRecType(9);
            recAttr.setRecordName(((ComplexTypeDecl)element).getName());
            NXSDStyleInfo choiceStyleInfo = ((ComplexTypeDecl)element).getStyleInfo();
            if (choiceStyleInfo.getListTerminatedBy() != null || choiceStyleInfo.getItemSeparatedBy() != null) {
                recAttr.setList(true);
                if (choiceStyleInfo.getListTerminatedBy() != null) {
                    recAttr.setListSeparator(choiceStyleInfo.getListTerminatedBy());
                }
                if (choiceStyleInfo.getItemSeparatedBy() != null) {
                    recAttr.setItemSeparator(choiceStyleInfo.getItemSeparatedBy());
                }
            }
        }
        return recAttr;
    }

    private boolean isComplexTypeInNativeDefinition(NXSDDefinition def) {
        for (int i = 0; i < def.getGlobalDeclarations().length; ++i) {
            if (!(def.getGlobalDeclarations()[i] instanceof ComplexTypeDecl)) continue;
            return true;
        }
        return false;
    }

    private String translateSpecialCharToXSDFormat(String ch) {
        if (ch.contains("\"")) {
            return StringUtil.replaceAll(ch, "\"", "&quot;");
        }
        if (ch.contains("<")) {
            return StringUtil.replaceAll(ch, "<", "&lt;");
        }
        if (ch.contains(">")) {
            return StringUtil.replaceAll(ch, ">", "&gt;");
        }
        if (ch.contains("&")) {
            return StringUtil.replaceAll(ch, "'", "&amp;");
        }
        return ch;
    }

    private boolean choiceRecsExist(ComplexNXSDGenerator proxy) {
        for (int i = 0; i < proxy.getRecordTypeCount(); ++i) {
            if (!proxy.isChoiceRecord(i)) continue;
            return true;
        }
        return false;
    }

    private String getConvertedVarName(String src) {
        if (src.startsWith("${")) {
            return src;
        }
        return "${" + src.trim() + "}";
    }
}

