/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd;

import java.awt.Color;
import java.awt.Point;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.SortableTwoDModel;
import oracle.tip.tools.ide.common.ui.treeexplorer.NodeText;
import oracle.tip.tools.ide.common.ui.treeexplorer.TextInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.AbstractTreeTransferHandler;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.RecTypeAttributes;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.RecTypeDataSourceObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.RecTypeExplorerTreeNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.RecTypeStringTransferHandler;

public class DNDTreeTransferHandler
extends AbstractTreeTransferHandler {
    protected FlatFileInfo mm_Info;

    public DNDTreeTransferHandler(JTree tree, int action) {
        super(tree, action, false);
    }

    public DNDTreeTransferHandler(JTree tree, RecTypeStringTransferHandler th, int action) {
        super(tree, th, action, false);
        this.mm_Info = th.getFlatFileInfo();
    }

    @Override
    public boolean canPerformAction(JTree target, DefaultMutableTreeNode draggedNode, int action, Point location) {
        TreePath pathTarget = target.getPathForLocation(location.x, location.y);
        if (pathTarget == null) {
            target.setSelectionPath(null);
            return false;
        }
        target.setSelectionPath(pathTarget);
        if (action == 1) {
            RecTypeDataSourceObject nodedata = null;
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)pathTarget.getLastPathComponent();
            Object o = ((RecTypeExplorerTreeNode)((Object)parentNode)).getNodeData();
            if (o instanceof RecTypeDataSourceObject) {
                nodedata = (RecTypeDataSourceObject)o;
            }
            if (draggedNode != null) {
                return !parentNode.isRoot() && parentNode != draggedNode && !nodedata.getName().equals("<new_element>") && nodedata.getRecType() != 99;
            }
            return !parentNode.isRoot() && nodedata.getRecType() != 99;
        }
        if (action == 2) {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)pathTarget.getLastPathComponent();
            return !draggedNode.isRoot() && parentNode != draggedNode.getParent() && !draggedNode.isNodeDescendant(parentNode);
        }
        return false;
    }

    @Override
    public boolean executeDrop(JTree target, DefaultMutableTreeNode draggedNode, DefaultMutableTreeNode newParentNode, int action) {
        if (action == 1) {
            DefaultTreeModel model = (DefaultTreeModel)target.getModel();
            TreePath treePath = new TreePath(newParentNode.getPath());
            target.scrollPathToVisible(treePath);
            target.setSelectionPath(treePath);
            try {
                this.synchronizeNodeProperties(newParentNode, ((RecTypeDataSourceObject)((RecTypeExplorerTreeNode)((Object)draggedNode)).getNodeData()).getName());
            }
            catch (Exception e1) {
                return false;
            }
            model.nodeStructureChanged(newParentNode);
            target.expandPath(treePath);
            return true;
        }
        if (action == 2) {
            draggedNode.removeFromParent();
            ((DefaultTreeModel)target.getModel()).insertNodeInto(draggedNode, newParentNode, newParentNode.getChildCount());
            TreePath treePath = new TreePath(draggedNode.getPath());
            target.scrollPathToVisible(treePath);
            target.setSelectionPath(treePath);
            return true;
        }
        return false;
    }

    public static RecTypeExplorerTreeNode makeDeepCopy(DefaultMutableTreeNode node) {
        RecTypeExplorerTreeNode srcnode = (RecTypeExplorerTreeNode)((Object)node);
        RecTypeExplorerTreeNode copy = new RecTypeExplorerTreeNode(srcnode.getIcons(), srcnode.getNodeText(), srcnode.getNodeData());
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            copy.add((MutableTreeNode)((Object)DNDTreeTransferHandler.makeDeepCopy((DefaultMutableTreeNode)((Object)((RecTypeExplorerTreeNode)((Object)e.nextElement()))))));
        }
        return copy;
    }

    private void synchronizeNodeProperties(DefaultMutableTreeNode currNode, String copiedNodeName) {
        RecTypeExplorerTreeNode parentNode;
        String fldName = "";
        String currNodeName = ((RecTypeDataSourceObject)((RecTypeExplorerTreeNode)((Object)currNode)).getNodeData()).getName();
        int currNodeRecType = ((RecTypeDataSourceObject)((RecTypeExplorerTreeNode)((Object)currNode)).getNodeData()).getRecType();
        ((RecTypeDataSourceObject)((RecTypeExplorerTreeNode)((Object)currNode)).getNodeData()).setDataType(copiedNodeName);
        TextInfo t1 = new TextInfo();
        t1.setText(currNodeName + " - " + ((RecTypeDataSourceObject)((RecTypeExplorerTreeNode)((Object)currNode)).getNodeData()).getDataType());
        t1.setFont(TextInfo.PLAIN_FONT);
        t1.setColor(Color.black);
        NodeText nodeTxt = new NodeText(new TextInfo[]{t1}, new TextInfo[]{t1});
        ((RecTypeExplorerTreeNode)((Object)currNode)).setNodeText(nodeTxt);
        if (currNodeRecType == 0 || currNodeRecType == 9) {
            this.copyRecordClassifier(copiedNodeName, currNodeName);
        }
        if (!(parentNode = (RecTypeExplorerTreeNode)((Object)currNode.getParent())).isRoot()) {
            ArrayTwoDModel fieldProps = this.mm_Info.getFieldPropertiesDs(((RecTypeDataSourceObject)parentNode.getNodeData()).getName());
            for (int i = 0; i < fieldProps.getRowCount(); ++i) {
                fldName = (String)fieldProps.getData(1, i);
                if (!fldName.equals(currNodeName)) continue;
                this.mm_Info.resetFieldPropertiesRow(fieldProps, i);
                fieldProps.setData(1, i, (Object)fldName);
                fieldProps.setData(2, i, (Object)copiedNodeName);
                break;
            }
        }
    }

    private void copyRecordClassifier(String src_record, String tgt_record) {
        SortableTwoDModel valueGridDs = new SortableTwoDModel(4, 0);
        valueGridDs.addRows(0, 1);
        valueGridDs.setData(1, 0, (Object)"");
        valueGridDs.setData(2, 0, (Object)tgt_record);
        RecTypeAttributes srcRecAttr = this.mm_Info.getRecordAttributes(src_record);
        RecTypeAttributes tgtRecAttr = this.mm_Info.getRecordAttributes(tgt_record);
        if (tgtRecAttr != null) {
            tgtRecAttr.setType(srcRecAttr.getRecordName());
        } else {
            tgtRecAttr = new RecTypeAttributes();
            tgtRecAttr.setRecordName(tgt_record);
            tgtRecAttr.setType(srcRecAttr.getRecordName());
            tgtRecAttr.setDelimiter(srcRecAttr.getDelimiter());
            tgtRecAttr.setOccurs(1);
            tgtRecAttr.setMinOccurs(1);
        }
        valueGridDs.setData(3, 0, (Object)tgtRecAttr);
        this.mm_Info.removeFromRecordClassifierDs(tgt_record);
        this.mm_Info.removeFieldPropertiesDs(tgt_record);
        this.mm_Info.addIntoRecordClassifierDs(valueGridDs);
        this.mm_Info.getFieldPropertiesDs(tgt_record);
    }
}

