/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd;

import java.awt.Color;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.SortableTwoDModel;
import oracle.tip.tools.ide.common.resource.MessageBundleUtil;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.treeexplorer.NodeText;
import oracle.tip.tools.ide.common.ui.treeexplorer.TextInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.util.StringUtil;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileTranslationHelper;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileValidationException;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.RecTypeAttributes;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.RecTypeDataSourceObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.RecTypeExplorerTreeNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.NLSUtils;

public class ComplexNXSDGenerator {
    public static final short SINGLE_RECORD = 0;
    public static final short SINGLE_TYPE_RECORDS = 1;
    public static final short MULTIPLE_TYPE_RECORDS = 2;
    public static final short FIXED_LENGTH_TYPE = 3;
    public static final short DELIMITED_TYPE = 4;
    public static final String LENGTH_IDENTIFIER = "Identifier";
    public static final String LENGTH_FIXED = "Fixed";
    private static final String EOL = "${eol}";
    private static final String EOF = "${eof}";
    public static final int FIELD_PROPERTY_COUNT = 35;
    private FlatFileInfo fFlatFileInfo;
    private Vector _localRecordVector = new Vector();

    public ComplexNXSDGenerator(FlatFileInfo wizardInfo) {
        this.fFlatFileInfo = wizardInfo;
    }

    public String getNxsdEncoding() {
        return this.fFlatFileInfo.getNxsdEncoding();
    }

    public String getNamespace() {
        return this.fFlatFileInfo.getNamespace();
    }

    public String getEncoding() {
        return this.fFlatFileInfo.getDefaultCoding();
    }

    public String getByteOrder() {
        return null;
    }

    public int getHeaderLines() {
        return this.fFlatFileInfo.getSkipRecords();
    }

    public int getDataLines() {
        return this.fFlatFileInfo.getProcessRows();
    }

    public String getLinesTerminatedBy() {
        String realTerminator;
        String showTerminator = realTerminator = this.fFlatFileInfo.getRecordTerminator();
        if (realTerminator.equals("\\n") || realTerminator.equals("\\r\\n")) {
            showTerminator = this.fFlatFileInfo.isRecordTerminatorEOL() ? EOL : EOF;
        }
        return showTerminator;
    }

    public boolean isFixedLengthType() {
        return this.fFlatFileInfo.isFixedLength();
    }

    public boolean isDelimitedType() {
        return this.fFlatFileInfo.isDelimitedFile();
    }

    public boolean isComplexType() {
        return this.fFlatFileInfo.isComplexFile();
    }

    public boolean isSingleRecord() {
        return this.fFlatFileInfo.isSingleInstance();
    }

    public boolean isSingleTypeRecords() {
        return !this.fFlatFileInfo.isSingleInstance() && !this.fFlatFileInfo.isMultiRecord();
    }

    public boolean isMultipleTypeRecords() {
        return !this.fFlatFileInfo.isSingleInstance() && this.fFlatFileInfo.isMultiRecord();
    }

    public String getContainerName() {
        return this.fFlatFileInfo.getRootElement();
    }

    public String getRecordName(int record) {
        if (!this.fFlatFileInfo.isMultiRecord()) {
            return this.fFlatFileInfo.getSingleRecordName();
        }
        return (String)this.fFlatFileInfo.getRecordClassifierDs().getData(2, record);
    }

    public int getRecordIndex(String record) {
        SortableTwoDModel recClassifiers = this.fFlatFileInfo.getRecordClassifierDs();
        try {
            int rowcount = recClassifiers.getRowCount();
            for (int i = 0; i < rowcount; ++i) {
                if (!((String)recClassifiers.getData(2, i)).equals(record)) continue;
                return i;
            }
        }
        catch (Exception e) {
            return -1;
        }
        return -1;
    }

    public RecTypeAttributes getRecordAttributes(int record) {
        if (this.fFlatFileInfo.isMultiRecord()) {
            return this.fFlatFileInfo.getRecordAttributes(this.getRecordName(record));
        }
        return null;
    }

    public RecTypeAttributes getRecordAttributes(String recordName) {
        if (this.fFlatFileInfo.isMultiRecord()) {
            return this.fFlatFileInfo.getRecordAttributes(recordName);
        }
        return null;
    }

    public boolean isChoiceConditionFixedLen() {
        return this.fFlatFileInfo.isFixedLength();
    }

    public String getChoiceConditionLen() {
        return "" + this.fFlatFileInfo.getRecordClassifierEnd();
    }

    public boolean isChoiceConditionDelimited() {
        return this.fFlatFileInfo.isDelimitedFile();
    }

    public String getChoiceConditionTerminatedBy() {
        return this.fFlatFileInfo.getDelimiter();
    }

    public String getChoiceConditionValue(int record) {
        RecTypeAttributes recAttr;
        if (this.isChoiceRecord(record) && !(recAttr = this.getRecordAttributes(record)).getChoiceValue().equals("")) {
            return recAttr.getChoiceValue();
        }
        return "";
    }

    public RecTypeAttributes getChoiceAttributes() {
        RecTypeAttributes recAttr = this.getRecordAttributes("choice");
        return recAttr;
    }

    public boolean isChoiceRecord(int record) {
        return this.getRecordAttributes(record).isChoice();
    }

    public boolean isListRecord(int record) {
        return this.getRecordAttributes(record).isList();
    }

    public boolean isArrayRecord(int record) {
        return this.getRecordAttributes(record).isArray();
    }

    public int getRecordTypeCount() {
        return this.fFlatFileInfo.getRecordClassifierDs().getRowCount();
    }

    public String getRecordSeparator(int record) {
        String realTerminator;
        String showTerminator = realTerminator = this.fFlatFileInfo.getRecordTerminator();
        if (realTerminator.equals("\\n") || realTerminator.equals("\\r\\n")) {
            showTerminator = this.fFlatFileInfo.isRecordTerminatorEOL() ? EOL : EOF;
        }
        return showTerminator;
    }

    public int getFieldCount(int record) {
        ArrayTwoDModel dataSource = this.getFieldDataSource(record);
        int fieldCount = dataSource.getRowCount();
        return fieldCount;
    }

    public String getFieldName(int record, int field) {
        ArrayTwoDModel dataSource = this.getFieldDataSource(record);
        return dataSource.getData(1, field).toString();
    }

    public String getFieldType(int record, int field) {
        ArrayTwoDModel dataSource = this.getFieldDataSource(record);
        return dataSource.getData(2, field).toString();
    }

    public String getFieldStyle(int record, int field) {
        ArrayTwoDModel dataSource = this.getFieldDataSource(record);
        try {
            return dataSource.getData(7, field).toString();
        }
        catch (Exception e1) {
            return "";
        }
    }

    public String[] getFieldStylePattern(int record, int field) {
        String[] stylePatterns = new String[]{"", ""};
        ArrayTwoDModel dataSource = this.getFieldDataSource(record);
        stylePatterns[0] = this.translateSpecialCharToXSDFormat(dataSource.getData(8, field).toString());
        stylePatterns[1] = this.translateSpecialCharToXSDFormat(dataSource.getData(9, field).toString());
        return stylePatterns;
    }

    public String getFieldPadStyle(int record, int field) {
        ArrayTwoDModel dataSource = this.getFieldDataSource(record);
        return dataSource.getData(10, field).toString();
    }

    public String getFieldPadding(int record, int field) {
        ArrayTwoDModel dataSource = this.getFieldDataSource(record);
        return this.translateSpecialCharToXSDFormat(this.translatePaddingCode(dataSource.getData(11, field).toString()));
    }

    public String getFieldTerminator(int record, int field) {
        String delimiter;
        ArrayTwoDModel dataSource = this.getFieldDataSource(record);
        int fieldCount = dataSource.getRowCount();
        if (fieldCount == field + 1) {
            String realTerminator;
            String showTerminator = realTerminator = this.fFlatFileInfo.getRecordTerminator();
            if (realTerminator.equals("\\n") || realTerminator.equals("\\r\\n")) {
                showTerminator = this.fFlatFileInfo.isRecordTerminatorEOL() ? EOL : EOF;
            }
            return showTerminator;
        }
        String realDelim = delimiter = dataSource.getData(6, field).toString();
        if (delimiter != null && !delimiter.equals("")) {
            realDelim = delimiter.equals(NLSUtils.getNLSString("DA_delimitedColDelimiterWhiteSpace_FlatFile")) ? "  " : (delimiter.equals(NLSUtils.getNLSString("DA_delimitedColDelimiterComma_FlatFile")) ? "," : (delimiter.equals(NLSUtils.getNLSString("DA_delimitedColDelimiterSemicolon_FlatFile")) ? ";" : (delimiter.equals(NLSUtils.getNLSString("DA_delimitedColDelimiterTab_FlatFile")) ? "\\t" : (delimiter.equals(NLSUtils.getNLSString("DA_delimitedColDelimiterSpace_FlatFile")) ? " " : delimiter))));
        }
        return realDelim;
    }

    public int getFieldLength(int record, int field) {
        ArrayTwoDModel dataSource = this.getFieldDataSource(record);
        Integer intObj = new Integer(dataSource.getData(3, field).toString());
        return intObj;
    }

    public String getFieldDefault(int record, int field) {
        ArrayTwoDModel dataSource = this.getFieldDataSource(record);
        return this.translateSpecialCharToXSDFormat(dataSource.getData(13, field).toString());
    }

    public String getFieldStartsWith(int record, int field) {
        ArrayTwoDModel dataSource = this.getFieldDataSource(record);
        return this.translateSpecialCharToXSDFormat(dataSource.getData(15, field).toString());
    }

    public String getFieldMinOccurs(int record, int field) {
        ArrayTwoDModel dataSource = this.getFieldDataSource(record);
        return dataSource.getData(16, field).toString();
    }

    public String getFieldMaxOccurs(int record, int field) {
        ArrayTwoDModel dataSource = this.getFieldDataSource(record);
        return dataSource.getData(17, field).toString();
    }

    public boolean isFieldArray(int record, int field) {
        ArrayTwoDModel dataSource = this.getFieldDataSource(record);
        return (Boolean)dataSource.getData(23, field);
    }

    public String getFieldArrayLength(int record, int field) {
        ArrayTwoDModel dataSource = this.getFieldDataSource(record);
        return (String)dataSource.getData(24, field);
    }

    public String getFieldArraySep(int record, int field) {
        ArrayTwoDModel dataSource = this.getFieldDataSource(record);
        return this.translateSpecialCharToXSDFormat((String)dataSource.getData(25, field));
    }

    public String getFieldCellSep(int record, int field) {
        ArrayTwoDModel dataSource = this.getFieldDataSource(record);
        return this.translateSpecialCharToXSDFormat((String)dataSource.getData(26, field));
    }

    public String getFieldSkipMode(int record, int field) {
        ArrayTwoDModel dataSource = this.getFieldDataSource(record);
        return (String)dataSource.getData(32, field);
    }

    public String getFieldSkip(int record, int field) {
        ArrayTwoDModel dataSource = this.getFieldDataSource(record);
        return (String)dataSource.getData(33, field);
    }

    public String getFieldSkipUntil(int record, int field) {
        ArrayTwoDModel dataSource = this.getFieldDataSource(record);
        return this.translateSpecialCharToXSDFormat((String)dataSource.getData(34, field));
    }

    public boolean isFieldList(int record, int field) {
        ArrayTwoDModel dataSource = this.getFieldDataSource(record);
        return (Boolean)dataSource.getData(29, field);
    }

    public String getFieldListSep(int record, int field) {
        ArrayTwoDModel dataSource = this.getFieldDataSource(record);
        return this.translateSpecialCharToXSDFormat((String)dataSource.getData(30, field));
    }

    public String getFieldItemSep(int record, int field) {
        ArrayTwoDModel dataSource = this.getFieldDataSource(record);
        return this.translateSpecialCharToXSDFormat((String)dataSource.getData(31, field));
    }

    public String getFieldDateFormat(int record, int field) {
        ArrayTwoDModel dataSource = this.getFieldDataSource(record);
        return dataSource.getData(27, field).toString();
    }

    public String getFieldPrefix(int record, int field) {
        ArrayTwoDModel dataSource = this.getFieldDataSource(record);
        return this.translateSpecialCharToXSDFormat(dataSource.getData(18, field).toString());
    }

    public String getFieldSuffix(int record, int field) {
        ArrayTwoDModel dataSource = this.getFieldDataSource(record);
        return this.translateSpecialCharToXSDFormat(dataSource.getData(19, field).toString());
    }

    public String getFieldLookAhead(int record, int field) {
        ArrayTwoDModel dataSource = this.getFieldDataSource(record);
        return dataSource.getData(20, field).toString();
    }

    public String getFieldLookFor(int record, int field) {
        ArrayTwoDModel dataSource = this.getFieldDataSource(record);
        return this.translateSpecialCharToXSDFormat(dataSource.getData(21, field).toString());
    }

    public String getFieldLengthStyle(int record, int field) {
        ArrayTwoDModel dataSource = this.getFieldDataSource(record);
        return dataSource.getData(22, field).toString();
    }

    public String getFieldQuotedBy(int record, int field) {
        ArrayTwoDModel dataSource = this.getFieldDataSource(record);
        return this.translateSpecialCharToXSDFormat(dataSource.getData(28, field).toString());
    }

    public void setRecordType(short recordType) {
        if (recordType == 0) {
            this.fFlatFileInfo.isSingleInstance(true);
            this.fFlatFileInfo.isMultiRecord(false);
            this.fFlatFileInfo.setRecordClassifierStart(0);
        } else if (recordType == 1) {
            this.fFlatFileInfo.isSingleInstance(false);
            this.fFlatFileInfo.isMultiRecord(false);
            this.fFlatFileInfo.setRecordClassifierStart(0);
        } else {
            this.fFlatFileInfo.isSingleInstance(false);
            this.fFlatFileInfo.isMultiRecord(true);
            this.fFlatFileInfo.isComplexFile(true);
        }
    }

    public void setFieldStyle(short fieldStyle) {
        if (fieldStyle == 3) {
            this.fFlatFileInfo.isFixedLengthFile(true);
        } else {
            this.fFlatFileInfo.isDelimitedFile(true);
        }
    }

    public void setFieldStyle(int recordNum, int fieldNum, String style) {
        ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs((String)this._localRecordVector.elementAt(recordNum));
        dataSource.setData(7, fieldNum, (Object)style);
    }

    public void setFieldStylePattern1(int recordNum, int fieldNum, String stylepattern1) {
        ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs((String)this._localRecordVector.elementAt(recordNum));
        dataSource.setData(8, fieldNum, (Object)stylepattern1);
    }

    public void setFieldStylePattern2(int recordNum, int fieldNum, String stylepattern2) {
        ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs((String)this._localRecordVector.elementAt(recordNum));
        dataSource.setData(9, fieldNum, (Object)stylepattern2);
    }

    public void setContainerName(String containerName) throws FlatFileValidationException {
        if (containerName != null) {
            this.fFlatFileInfo.setRootElement(containerName);
        }
    }

    public void setRecordName(int recordNum, String recordName, RecTypeAttributes recattr, int fieldCount) {
        try {
            ArrayTwoDModel fieldPropertiesDs = new ArrayTwoDModel(35, fieldCount);
            this.fFlatFileInfo.setFieldPropertiesDs(recordName.toUpperCase(), fieldPropertiesDs);
            this._localRecordVector.add(recordNum, recordName);
            SortableTwoDModel source = this.fFlatFileInfo.getRecordClassifierDs();
            source.addRows(source.getRowCount(), 1);
            source.setData(1, recordNum, (Object)"");
            source.setData(2, recordNum, (Object)recordName);
            source.setData(3, recordNum, (Object)recattr);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void setChoiceRecord(int recordNum, String recordName, RecTypeAttributes recattr) {
        try {
            this._localRecordVector.add(recordNum, recordName);
            SortableTwoDModel source = this.fFlatFileInfo.getRecordClassifierDs();
            source.addRows(source.getRowCount(), 1);
            source.setData(1, recordNum, (Object)"");
            source.setData(2, recordNum, (Object)recordName);
            source.setData(3, recordNum, (Object)recattr);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void setChoiceCondition(String condition) {
    }

    public void setChoiceConditionLen(String length) {
        if (length != null) {
            this.fFlatFileInfo.setRecordClassifierEnd(Integer.parseInt(length.trim()));
        }
        this.fFlatFileInfo.setRecordClassifierStart(0);
    }

    public void setChoiceConditionTerminatedBy(String terminatedBy) {
        if (terminatedBy != null) {
            this.fFlatFileInfo.setDelimiter(terminatedBy);
        }
    }

    public void setChoiceValue(int recordNum, String choiceValue) {
        if (choiceValue != null) {
            RecTypeAttributes recAttr = this.getRecordAttributes(recordNum);
            recAttr.setChoice(true);
            recAttr.setChoiceValue(choiceValue);
        }
    }

    public void setRecordDelimiter(String delimiter) {
        if (delimiter != null) {
            if (delimiter.equals(EOL)) {
                this.fFlatFileInfo.setRecordTerminator("\\n");
                this.fFlatFileInfo.setRecordTerminatorEOL(true);
            } else if (delimiter.equals(EOF)) {
                this.fFlatFileInfo.setRecordTerminator("\\n");
                this.fFlatFileInfo.setRecordTerminatorEOL(false);
            } else {
                this.fFlatFileInfo.setRecordTerminator(delimiter);
            }
        }
    }

    public void setFieldName(int recordNum, int fieldNum, String fieldName) {
        ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs((String)this._localRecordVector.elementAt(recordNum));
        dataSource.setData(1, fieldNum, (Object)fieldName);
    }

    public void setFieldType(int recordNum, int fieldNum, String fieldType) {
        ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs((String)this._localRecordVector.elementAt(recordNum));
        dataSource.setData(2, fieldNum, (Object)fieldType);
    }

    public void setFieldArray(int recordNum, int fieldNum, boolean array) {
        ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs((String)this._localRecordVector.elementAt(recordNum));
        dataSource.setData(23, fieldNum, (Object)array);
    }

    public void setFieldArrayLength(int recordNum, int fieldNum, String arrayLength) {
        ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs((String)this._localRecordVector.elementAt(recordNum));
        if (arrayLength != null) {
            dataSource.setData(24, fieldNum, (Object)arrayLength);
        }
    }

    public void setFieldArraySep(int recordNum, int fieldNum, String arraySep) {
        ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs((String)this._localRecordVector.elementAt(recordNum));
        if (arraySep != null) {
            dataSource.setData(25, fieldNum, (Object)arraySep);
        }
    }

    public void setFieldCellSep(int recordNum, int fieldNum, String cellSep) {
        ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs((String)this._localRecordVector.elementAt(recordNum));
        if (cellSep != null) {
            dataSource.setData(26, fieldNum, (Object)cellSep);
        }
    }

    public void setFieldSkipMode(int recordNum, int fieldNum, String skipMode) {
        ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs((String)this._localRecordVector.elementAt(recordNum));
        if (skipMode != null) {
            dataSource.setData(32, fieldNum, (Object)skipMode);
        }
    }

    public void setFieldSkip(int recordNum, int fieldNum, String skip) {
        ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs((String)this._localRecordVector.elementAt(recordNum));
        if (skip != null) {
            dataSource.setData(33, fieldNum, (Object)skip);
        }
    }

    public void setFieldSkipUntil(int recordNum, int fieldNum, String skipUntil) {
        ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs((String)this._localRecordVector.elementAt(recordNum));
        if (skipUntil != null) {
            dataSource.setData(34, fieldNum, (Object)skipUntil);
        }
    }

    public void setFieldList(int recordNum, int fieldNum, boolean list) {
        ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs((String)this._localRecordVector.elementAt(recordNum));
        dataSource.setData(29, fieldNum, (Object)list);
    }

    public void setFieldListSep(int recordNum, int fieldNum, String listSep) {
        ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs((String)this._localRecordVector.elementAt(recordNum));
        if (listSep != null) {
            dataSource.setData(30, fieldNum, (Object)listSep);
            dataSource.setData(29, fieldNum, (Object)true);
        }
    }

    public void setFieldItemSep(int recordNum, int fieldNum, String itemSep) {
        ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs((String)this._localRecordVector.elementAt(recordNum));
        if (itemSep != null) {
            dataSource.setData(31, fieldNum, (Object)itemSep);
        }
    }

    public void setFieldDefault(int recordNum, int fieldNum, String fielddefault) {
        ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs((String)this._localRecordVector.elementAt(recordNum));
        if (fielddefault != null) {
            dataSource.setData(13, fieldNum, (Object)fielddefault);
        }
    }

    public void setFieldLookAhead(int recordNum, int fieldNum, String lookAhead) {
        ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs((String)this._localRecordVector.elementAt(recordNum));
        if (lookAhead != null) {
            dataSource.setData(20, fieldNum, (Object)lookAhead);
        }
    }

    public void setFieldLookFor(int recordNum, int fieldNum, String lookfor) {
        ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs((String)this._localRecordVector.elementAt(recordNum));
        if (lookfor != null) {
            dataSource.setData(21, fieldNum, (Object)lookfor);
        }
    }

    public void setFieldMinOccurs(int recordNum, int fieldNum, String minoccurs) {
        ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs((String)this._localRecordVector.elementAt(recordNum));
        if (minoccurs.equals("-1")) {
            dataSource.setData(16, fieldNum, (Object)"1");
        } else if (minoccurs != null) {
            dataSource.setData(16, fieldNum, (Object)minoccurs);
        }
    }

    public void setFieldMaxOccurs(int recordNum, int fieldNum, String maxoccurs) {
        ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs((String)this._localRecordVector.elementAt(recordNum));
        if (maxoccurs.equals("unbounded")) {
            dataSource.setData(17, fieldNum, (Object)"UNBOUNDED");
            dataSource.setData(23, fieldNum, (Object)true);
        } else if (maxoccurs.equals(new Integer(0x7FFFFFF8).toString())) {
            dataSource.setData(17, fieldNum, (Object)"UNBOUNDED");
        } else if (maxoccurs != null) {
            dataSource.setData(17, fieldNum, (Object)maxoccurs);
        }
    }

    public void setFieldPadStyle(int recordNum, int fieldNum, String padstyle) {
        ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs((String)this._localRecordVector.elementAt(recordNum));
        if (padstyle != null) {
            dataSource.setData(10, fieldNum, (Object)padstyle);
        }
    }

    public void setFieldPadding(int recordNum, int fieldNum, String padding) {
        ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs((String)this._localRecordVector.elementAt(recordNum));
        if (padding != null) {
            dataSource.setData(11, fieldNum, (Object)this.getPaddingCode(padding));
        }
    }

    public void setFieldStartsWith(int recordNum, int fieldNum, String startswith) {
        ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs((String)this._localRecordVector.elementAt(recordNum));
        if (startswith != null) {
            dataSource.setData(15, fieldNum, (Object)startswith);
        }
    }

    public void setFieldSuffix(int recordNum, int fieldNum, String suffix) {
        ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs((String)this._localRecordVector.elementAt(recordNum));
        if (suffix != null) {
            dataSource.setData(19, fieldNum, (Object)suffix);
        }
    }

    public void setFieldDateFormat(int recordNum, int fieldNum, String dateformat) {
        ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs((String)this._localRecordVector.elementAt(recordNum));
        if (dateformat != null) {
            dataSource.setData(27, fieldNum, (Object)dateformat);
        }
    }

    public void setFieldPrefix(int recordNum, int fieldNum, String prefix) {
        ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs((String)this._localRecordVector.elementAt(recordNum));
        if (prefix != null) {
            dataSource.setData(18, fieldNum, (Object)prefix);
        }
    }

    public void setFieldLength(int recordNum, int fieldNum, String len) {
        if (len != null) {
            ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs((String)this._localRecordVector.elementAt(recordNum));
            dataSource.setData(3, fieldNum, (Object)new Integer(len));
            int start_col = 0;
            int end_col = 0;
            try {
                if (fieldNum == 0) {
                    start_col = 1;
                    end_col = Integer.parseInt(len);
                } else {
                    String prevEndLen = (String)dataSource.getData(5, fieldNum - 1);
                    if (prevEndLen != null) {
                        start_col = Integer.parseInt(prevEndLen) + 1;
                        end_col = Integer.parseInt(prevEndLen) + Integer.parseInt(len);
                    }
                }
                dataSource.setData(4, fieldNum, (Object)start_col);
                dataSource.setData(5, fieldNum, (Object)end_col);
            }
            catch (Exception e1) {
                dataSource.setData(4, fieldNum, (Object)new Integer(0));
                dataSource.setData(5, fieldNum, (Object)new Integer(0));
            }
        }
    }

    public void setFieldTerminator(int recordNum, int fieldNum, String terminatedBy) {
        if (terminatedBy == null) {
            return;
        }
        ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs((String)this._localRecordVector.elementAt(recordNum));
        int fieldCount = dataSource.getRowCount();
        if (fieldNum == fieldCount - 1 && terminatedBy != null) {
            if (terminatedBy.equals(EOL)) {
                this.fFlatFileInfo.setRecordTerminator("\\n");
                this.fFlatFileInfo.setRecordTerminatorEOL(true);
            } else if (terminatedBy.equals(EOF)) {
                this.fFlatFileInfo.setRecordTerminator("\\n");
                this.fFlatFileInfo.setRecordTerminatorEOL(false);
            } else {
                this.fFlatFileInfo.setRecordTerminator(terminatedBy);
            }
        }
        String showDelim = this.convertDelimiterToDisplayString(terminatedBy);
        dataSource.setData(6, fieldNum, (Object)showDelim);
    }

    public void setNamespace(String namespace) {
        if (namespace != null) {
            this.fFlatFileInfo.setNamespace(namespace);
        }
    }

    public void setNxsdEncoding(String encoding) {
        if (encoding != null) {
            this.fFlatFileInfo.setNxsdEncoding(encoding);
        }
    }

    public void setHeaderLines(int headers) {
        if (headers > -1) {
            this.fFlatFileInfo.setSkipRecords(headers);
        }
    }

    public void setFieldQuotedBy(int record, int fieldNum, String quotedBy) {
        ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs((String)this._localRecordVector.elementAt(record));
        if (quotedBy != null) {
            dataSource.setData(28, fieldNum, (Object)quotedBy);
        }
    }

    private String convertDelimiterToDisplayString(String realDelim) {
        if (realDelim == null) {
            return "";
        }
        String showDelim = realDelim;
        showDelim = realDelim.equals("  ") ? NLSUtils.getNLSString("DA_delimitedColDelimiterWhiteSpace_FlatFile") : (realDelim.equals(",") ? NLSUtils.getNLSString("DA_delimitedColDelimiterComma_FlatFile") : (realDelim.equals(";") ? NLSUtils.getNLSString("DA_delimitedColDelimiterSemicolon_FlatFile") : (realDelim.equals("\\t") ? NLSUtils.getNLSString("DA_delimitedColDelimiterTab_FlatFile") : (realDelim.equals(" ") ? NLSUtils.getNLSString("DA_delimitedColDelimiterSpace_FlatFile") : (realDelim.equals("\\n") || realDelim.equals("\\r\\n") ? EOL : realDelim)))));
        return showDelim;
    }

    public ArrayTwoDModel getFieldDataSource(int record) {
        return this.fFlatFileInfo.getFieldPropertiesDs((String)this.fFlatFileInfo.getRecordClassifierDs().getData(2, record));
    }

    public boolean isRecordUsedAsField(int record) {
        return this.fFlatFileInfo.isRecordUsedAsField(this.getRecordName(record));
    }

    public DefaultTreeModel getSchemaTreeModel() {
        return this.fFlatFileInfo.getHierarchicalTreeModel();
    }

    public void setSchemaTreeModel(DefaultTreeModel model) {
        this.fFlatFileInfo.setHierarchicalTreeModel(model);
    }

    public void setSchemaTreeRoot() {
        TextInfo info1 = new TextInfo(Color.black, TextInfo.PLAIN_FONT, this.fFlatFileInfo.getRootElement());
        TextInfo info2 = new TextInfo(Color.black, TextInfo.PLAIN_FONT, this.fFlatFileInfo.getRootElement());
        TextInfo[] expanded = new TextInfo[]{info1};
        TextInfo[] compact = new TextInfo[]{info2};
        NodeText nodeText = new NodeText(expanded, compact);
        Icon[] icons = new Icon[]{new ImageIcon(UIHelper.loadImage((String)"images/schema.png", UIHelper.class))};
        RecTypeExplorerTreeNode root = new RecTypeExplorerTreeNode(icons, nodeText, (Object)MessageBundleUtil.getCommonString((String)"TC_DISPLAY_XML_TYPES", (String)"Displays available XML types in the system."));
        this.fFlatFileInfo.getHierarchicalTreeModel().setRoot((TreeNode)((Object)root));
    }

    public void addSchemaTreeBranch(int recordnum) {
        RecTypeExplorerTreeNode branch = this.createSchemaTreeBranch(recordnum);
        ((RecTypeExplorerTreeNode)((Object)this.fFlatFileInfo.getHierarchicalTreeModel().getRoot())).add((MutableTreeNode)((Object)branch));
    }

    public void addSchemaTreeChoiceElement(int recordnum) {
        RecTypeExplorerTreeNode branch = this.createSchemaTreeBranch(recordnum);
        this.fFlatFileInfo.getTreeNode("choice").add((MutableTreeNode)((Object)branch));
    }

    private RecTypeExplorerTreeNode createSchemaTreeBranch(int recordNum) {
        RecTypeAttributes recAttr = this.getRecordAttributes(recordNum);
        String dataType = recAttr.getType();
        if (dataType == null) {
            dataType = "";
        }
        int recType = recAttr.getRecType();
        String nodeDisplayName = "";
        ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs((String)this._localRecordVector.elementAt(recordNum));
        nodeDisplayName = !dataType.equals("") ? recAttr.getRecordName() + " - " + dataType : recAttr.getRecordName();
        TextInfo info1 = new TextInfo(Color.black, TextInfo.PLAIN_FONT, nodeDisplayName);
        TextInfo info2 = new TextInfo(Color.black, TextInfo.PLAIN_FONT, nodeDisplayName);
        TextInfo[] expanded = new TextInfo[]{info1};
        TextInfo[] compact = new TextInfo[]{info2};
        NodeText nodeTxt = new NodeText(expanded, compact);
        Icon[] icons = null;
        icons = recType == 9 ? new Icon[]{new ImageIcon(UIHelper.loadImage((String)"images/complextype.gif", UIHelper.class))} : (recType == 99 ? new Icon[]{new ImageIcon(UIHelper.loadImage((String)"images/xml_choice.gif", UIHelper.class))} : new Icon[]{new ImageIcon(UIHelper.loadImage((String)"images/element.png", UIHelper.class))});
        RecTypeDataSourceObject dso = new RecTypeDataSourceObject(recType, recAttr.getRecordName(), dataType, recAttr.getOccurs(), recAttr.getMinOccurs(), recAttr.isChoice());
        RecTypeExplorerTreeNode parentNode = new RecTypeExplorerTreeNode(icons[0], recAttr.getRecordName(), (Object)dso);
        parentNode.setNodeText(nodeTxt);
        if (recType != 99 && dataType.equals("")) {
            for (int i = 0; i < dataSource.getRowCount(); ++i) {
                String fldName = (String)dataSource.getData(1, i);
                String fldType = (String)dataSource.getData(2, i);
                int minOccurs = new Integer((String)dataSource.getData(16, i));
                int maxOccurs = -1;
                maxOccurs = dataSource.getData(17, i).equals("UNBOUNDED") ? 0x7FFFFFF8 : new Integer((String)dataSource.getData(17, i));
                boolean choice = (Boolean)dataSource.getData(0, i);
                info1 = new TextInfo(Color.black, TextInfo.PLAIN_FONT, fldName + " - " + fldType);
                info2 = new TextInfo(Color.black, TextInfo.PLAIN_FONT, fldName + " - " + fldType);
                expanded = new TextInfo[]{info1};
                compact = new TextInfo[]{info2};
                nodeTxt = new NodeText(expanded, compact);
                icons = new Icon[]{new ImageIcon(UIHelper.loadImage((String)"images/element.png", UIHelper.class))};
                dso = new RecTypeDataSourceObject(1, fldName, fldType, maxOccurs, minOccurs, choice);
                RecTypeExplorerTreeNode fieldNode = new RecTypeExplorerTreeNode(icons[0], fldName, (Object)dso);
                fieldNode.setNodeText(nodeTxt);
                parentNode.add((MutableTreeNode)((Object)fieldNode));
            }
        }
        return parentNode;
    }

    public void initFieldProperties(int recordNum, int fieldNum) {
        ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs((String)this._localRecordVector.elementAt(recordNum));
        this.fFlatFileInfo.resetFieldPropertiesRow(dataSource, fieldNum);
    }

    private String translatePaddingCode(String paddingCode) {
        FlatFileTranslationHelper h = new FlatFileTranslationHelper();
        if (paddingCode.equals(h.translate("FI_generalColDelimiterSpace_FlatFile"))) {
            return " ";
        }
        return paddingCode;
    }

    private String getPaddingCode(String padding) {
        FlatFileTranslationHelper h = new FlatFileTranslationHelper();
        if (padding.equals(" ")) {
            return h.translate("FI_generalColDelimiterSpace_FlatFile");
        }
        return padding;
    }

    private String translateSpecialCharToXSDFormat(String ch) {
        if (ch.contains("\"")) {
            return StringUtil.replaceAll(ch, "\"", "&quot;");
        }
        if (ch.contains("<")) {
            return StringUtil.replaceAll(ch, "<", "&lt;");
        }
        if (ch.contains(">")) {
            return StringUtil.replaceAll(ch, ">", "&gt;");
        }
        if (ch.contains("&")) {
            return StringUtil.replaceAll(ch, "'", "&amp;");
        }
        return ch;
    }
}

