/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.ide.help.HelpSystem;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.CommonUtils;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.RecTypeAttributes;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WBTranslatable;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WBTranslatableDialog;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.NLSUtils;

public class ComplexFieldPropertiesDialog
extends WBTranslatableDialog
implements ActionListener {
    public static final int OK = 0;
    public static final int CANCEL = 2;
    private static final String EOL = "${eol}";
    private static final String LENGTH_IDENTIFIER = "Identifier";
    private static final String LENGTH_FIXED = "Fixed";
    private JLabel jFieldPreviewLabel = new JLabel();
    private JTextField jFieldPreview = new JTextField();
    private JLabel jNameLabel = new JLabel();
    private JTextField jName = new JTextField();
    private JLabel jTypeLabel = new JLabel();
    private JComboBox jTypeCombo = new JComboBox();
    private JLabel jStyleLabel = new JLabel();
    private JComboBox jStyleCombo = new JComboBox();
    private JComboBox jStylePattern1Combo = new JComboBox();
    private JLabel jPattern1Label = new JLabel();
    private JComboBox jStylePattern2Combo = new JComboBox();
    private JLabel jPattern2Label = new JLabel();
    private JLabel jPadStyleLabel = new JLabel();
    private JComboBox jPadStyleCombo = new JComboBox();
    private JLabel jPaddingLabel = new JLabel();
    private JComboBox jPadding = new JComboBox();
    private JLabel jDefaultLabel = new JLabel();
    private JTextField jDefaultValue = new JTextField();
    private JCheckBox jConditionCB = new JCheckBox();
    private JLabel jConditionTypeLabel = new JLabel();
    private JTextField jCondType = new JTextField();
    private JLabel jConditionValueLabel = new JLabel();
    private JTextField jCondValue = new JTextField();
    private JLabel jStartsWithLabel = new JLabel();
    private JTextField jStartsWith = new JTextField();
    private JLabel jPrefixLabel = new JLabel();
    private JTextField jPrefix = new JTextField();
    private JLabel jSuffixLabel = new JLabel();
    private JTextField jSuffix = new JTextField();
    private JLabel jMinOccursLabel = new JLabel();
    private JComboBox jMinOccursCombo = new JComboBox();
    private JLabel jMaxOccursLabel = new JLabel();
    private JComboBox jMaxOccursCombo = new JComboBox();
    private JLabel jLookForLabel = new JLabel();
    private JTextField jLookFor = new JTextField();
    private JLabel jLengthStyleLabel = new JLabel();
    private JComboBox jLengthStyleCombo = new JComboBox();
    private JLabel jLengthLabel = new JLabel();
    private JSpinner jLengthSpinner = new JSpinner();
    private JLabel jLookAheadLabel = new JLabel();
    private JSpinner jLookAheadSpinner = new JSpinner();
    private JLabel jDateFormatLabel = new JLabel();
    private JComboBox jDateFormatCombo = new JComboBox();
    private JComboBox jCellSepCombo = new JComboBox();
    private JLabel jCellSepLabel = new JLabel();
    private JComboBox jArraySepCombo = new JComboBox();
    private JLabel jArraySepLabel = new JLabel();
    private JCheckBox jArrayCB = new JCheckBox();
    private JLabel jArrayLengthLabel = new JLabel();
    private JSpinner jArrayLengthSpinner = new JSpinner();
    private JLabel jQuotedByLabel = new JLabel();
    private JComboBox jQuotedByCombo = new JComboBox();
    private JCheckBox jListCB = new JCheckBox();
    private JComboBox jItemSepCombo = new JComboBox();
    private JLabel jItemSepLabel = new JLabel();
    private JComboBox jListSepCombo = new JComboBox();
    private JLabel jListSepLabel = new JLabel();
    private JLabel jSkipModeLabel = new JLabel();
    private JComboBox jSkipModeCombo = new JComboBox();
    private JLabel jSkipLabel = new JLabel();
    private JSpinner jSkipSpinner = new JSpinner();
    private JLabel jSkipUntilLabel = new JLabel();
    private JComboBox jSkipUntilCombo = new JComboBox();
    private JPanel mainPanel;
    private static String[] _styleList = new String[]{"", "fixedLength", "terminated", "surrounded", "left/right surrounded"};
    private static String[] _padStyleList = new String[]{"", "head", "tail", "none"};
    private static String[] _paddingList = new String[]{"FI_generalColDelimiterSpace_FlatFile"};
    private static String[] _dataTypeList = new String[]{"", "anyURI", "base64Binary", "boolean", "byte", "date", "dateTime", "decimal", "double", "duration", "ENTITIES", "ENTITY", "float", "gDay", "gMonth", "gMonthDay", "gYear", "gYearMonth", "hexBinary", "ID", "IDREF", "IDREFS", "int", "integer", "language", "long", "Name", "NCName", "negativeInteger", "NMTOKEN", "NMTOKENS", "nonNegativeInteger", "nonPositiveInteger", "normalizedString", "NOTATION", "positiveInteger", "QName", "short", "string", "time", "token", "unsignedByte", "unsignedInt", "unsignedLong", "unsignedShort"};
    private static String[] _dateFormatList = new String[]{"MM/dd/yy", "dd/MM/yy", "MM-dd-yyyy", "dd*MM*yyyy", "MM/dd/yyyy hh:mm", "MM/dd/yyyy hh:mm:ss"};
    private static String[] _quotedByList = new String[]{"", "\"", "'", "(", "[", "<", "|"};
    private static String[] _skipModeList = new String[]{"", "after", "before"};
    protected int m_retVal = 2;
    protected boolean m_editMode = false;
    protected WBTranslatable _translatable;
    protected FlatFileInfo _ffInfo;
    protected String _record;
    protected ArrayTwoDModel _fieldProps;
    protected RecTypeAttributes _recAttr;
    protected int _fieldRow;
    private String _fldname;

    public ComplexFieldPropertiesDialog(JFrame f, WBTranslatable h) {
        super(f, h, h.translate("CX_EditFieldDetails"), true);
        this._translatable = h;
        this.createControls();
        this.layoutControls();
    }

    public void dispose() {
        super.dispose();
    }

    public void enableUserInput(final boolean bEnable) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Component glass = ComplexFieldPropertiesDialog.this.getGlassPane();
                glass.setVisible(!bEnable);
                if (bEnable) {
                    glass.setCursor(Cursor.getDefaultCursor());
                } else {
                    glass.setCursor(Cursor.getPredefinedCursor(3));
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    protected void createControls() {
        int i;
        this.jFieldPreviewLabel.setText(this._translatable.translate("CX_FieldLabel_SampleText"));
        this.jFieldPreviewLabel.setLabelFor(this.jFieldPreview);
        this.jFieldPreview.setEditable(false);
        this.jNameLabel.setText(this._translatable.translate("CX_FieldLabel_FieldName"));
        this.jNameLabel.setLabelFor(this.jName);
        CommonUtils.setMnemonicAndAccelerator(this.jNameLabel, NLSUtils.getNLSString("CX_FieldLabel_FieldName"));
        this.jTypeLabel.setText(this._translatable.translate("CX_FieldLabel_Type"));
        this.jTypeLabel.setLabelFor(this.jTypeCombo);
        CommonUtils.setMnemonicAndAccelerator(this.jTypeLabel, NLSUtils.getNLSString("CX_FieldLabel_Type"));
        this.jStyleLabel.setText(this._translatable.translate("CX_FieldLabel_Style"));
        this.jStyleLabel.setLabelFor(this.jStyleCombo);
        CommonUtils.setMnemonicAndAccelerator(this.jStyleLabel, NLSUtils.getNLSString("CX_FieldLabel_Style"));
        this.jPattern1Label.setText(this._translatable.translate("CX_FieldLabel_StylePattern1"));
        this.jPattern1Label.setLabelFor(this.jStylePattern1Combo);
        CommonUtils.setMnemonicAndAccelerator(this.jPattern1Label, NLSUtils.getNLSString("CX_FieldLabel_StylePattern1"));
        this.jPattern2Label.setText(this._translatable.translate("CX_FieldLabel_StylePattern2"));
        this.jPattern2Label.setLabelFor(this.jStylePattern2Combo);
        CommonUtils.setMnemonicAndAccelerator(this.jPattern2Label, NLSUtils.getNLSString("CX_FieldLabel_StylePattern2"));
        this.jPadStyleLabel.setText(this._translatable.translate("CX_FieldLabel_PadStyle"));
        this.jPadStyleLabel.setLabelFor(this.jPadStyleCombo);
        CommonUtils.setMnemonicAndAccelerator(this.jPadStyleLabel, NLSUtils.getNLSString("CX_FieldLabel_PadStyle"));
        this.jPadding.setEditable(true);
        this.jPadStyleCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (((String)e.getItem()).equals("none") || ((String)e.getItem()).equals("")) {
                    ComplexFieldPropertiesDialog.this.jPadding.setSelectedItem("");
                }
            }
        });
        this.jPaddingLabel.setText(this._translatable.translate("CX_FieldLabel_Padding"));
        this.jPaddingLabel.setLabelFor(this.jPadding);
        CommonUtils.setMnemonicAndAccelerator(this.jPaddingLabel, NLSUtils.getNLSString("CX_FieldLabel_Padding"));
        this.jDefaultLabel.setText(this._translatable.translate("CX_FieldLabel_Default"));
        this.jDefaultLabel.setLabelFor(this.jDefaultValue);
        CommonUtils.setMnemonicAndAccelerator(this.jDefaultLabel, NLSUtils.getNLSString("CX_FieldLabel_Default"));
        this.jLengthLabel.setText(this._translatable.translate("CX_FieldLabel_Length"));
        this.jLengthLabel.setLabelFor(this.jLengthSpinner);
        CommonUtils.setMnemonicAndAccelerator(this.jLengthLabel, NLSUtils.getNLSString("CX_FieldLabel_Length"));
        this.jLengthStyleLabel.setText(this._translatable.translate("CX_FieldLabel_LengthStyle"));
        this.jLengthStyleLabel.setLabelFor(this.jLengthStyleCombo);
        CommonUtils.setMnemonicAndAccelerator(this.jLengthStyleLabel, NLSUtils.getNLSString("CX_FieldLabel_LengthStyle"));
        this.jLengthStyleCombo.addItem(LENGTH_FIXED);
        this.jLengthStyleCombo.addItem(LENGTH_IDENTIFIER);
        this.jLengthStyleCombo.setSelectedItem(LENGTH_FIXED);
        this.jConditionCB.setText(this._translatable.translate("CX_FieldLabel_CondField"));
        this.jConditionCB.setEnabled(false);
        this.jConditionValueLabel.setText(this._translatable.translate("CX_FieldLabel_CondValue"));
        this.jConditionValueLabel.setLabelFor(this.jCondValue);
        CommonUtils.setMnemonicAndAccelerator(this.jConditionValueLabel, NLSUtils.getNLSString("CX_FieldLabel_CondValue"));
        this.jConditionTypeLabel.setText(this._translatable.translate("CX_FieldLabel_ChoiceType"));
        this.jConditionTypeLabel.setLabelFor(this.jCondType);
        CommonUtils.setMnemonicAndAccelerator(this.jConditionTypeLabel, NLSUtils.getNLSString("CX_FieldLabel_ChoiceType"));
        this.jCondType.setEnabled(false);
        this.jStartsWithLabel.setText(this._translatable.translate("CX_FieldLabel_StartsWith"));
        this.jStartsWithLabel.setLabelFor(this.jStartsWith);
        CommonUtils.setMnemonicAndAccelerator(this.jStartsWithLabel, NLSUtils.getNLSString("CX_FieldLabel_StartsWith"));
        this.jPrefixLabel.setText(this._translatable.translate("CX_FieldLabel_Prefix"));
        this.jPrefixLabel.setLabelFor(this.jPrefix);
        CommonUtils.setMnemonicAndAccelerator(this.jPrefixLabel, NLSUtils.getNLSString("CX_FieldLabel_Prefix"));
        this.jSuffixLabel.setText(this._translatable.translate("CX_FieldLabel_Suffix"));
        this.jSuffixLabel.setLabelFor(this.jSuffix);
        CommonUtils.setMnemonicAndAccelerator(this.jSuffixLabel, NLSUtils.getNLSString("CX_FieldLabel_Suffix"));
        this.jMinOccursLabel.setText(this._translatable.translate("CX_FieldLabel_MinOccurs"));
        this.jMinOccursLabel.setLabelFor(this.jMinOccursCombo);
        this.jMinOccursCombo.addItem("0");
        this.jMinOccursCombo.addItem("1");
        this.jMinOccursCombo.setSelectedItem("1");
        CommonUtils.setMnemonicAndAccelerator(this.jMinOccursLabel, NLSUtils.getNLSString("CX_FieldLabel_MinOccurs"));
        this.jMaxOccursLabel.setText(this._translatable.translate("CX_FieldLabel_MaxOccurs"));
        this.jMaxOccursLabel.setLabelFor(this.jMaxOccursCombo);
        this.jMaxOccursCombo.addItem("1");
        this.jMaxOccursCombo.addItem("UNBOUNDED");
        this.jMaxOccursCombo.setSelectedItem("1");
        this.jMaxOccursCombo.setEditable(true);
        this.jMaxOccursCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                String maxOccurs = (String)e.getItem();
                ComplexFieldPropertiesDialog.this.handleMaxOccursSelection(maxOccurs);
            }
        });
        CommonUtils.setMnemonicAndAccelerator(this.jMaxOccursLabel, NLSUtils.getNLSString("CX_FieldLabel_MaxOccurs"));
        this.jCellSepCombo.setEnabled(false);
        this.jCellSepCombo.setEditable(true);
        this.jCellSepCombo.addItem(EOL);
        this.jCellSepCombo.setSelectedItem("");
        this.jCellSepLabel.setText(this._translatable.translate("CX_FieldLabel_CellSep"));
        this.jCellSepLabel.setLabelFor(this.jCellSepCombo);
        CommonUtils.setMnemonicAndAccelerator(this.jCellSepLabel, NLSUtils.getNLSString("CX_FieldLabel_CellSep"));
        this.jArraySepCombo.setEnabled(false);
        this.jArraySepCombo.setEditable(true);
        this.jArraySepCombo.addItem(EOL);
        this.jArraySepCombo.setSelectedItem("");
        this.jArraySepLabel.setText(this._translatable.translate("CX_FieldLabel_ArraySep"));
        this.jArraySepLabel.setLabelFor(this.jArraySepCombo);
        CommonUtils.setMnemonicAndAccelerator(this.jArraySepLabel, NLSUtils.getNLSString("CX_FieldLabel_ArraySep"));
        this.jArrayCB.setText(this._translatable.translate("CX_FieldLabel_Array"));
        this.jArrayCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ComplexFieldPropertiesDialog.this.jArrayCB_itemStateChanged(e);
            }
        });
        this.jArrayLengthLabel.setText(this._translatable.translate("CX_FieldLabel_ArrayLength"));
        this.jArrayLengthLabel.setLabelFor(this.jArrayLengthSpinner);
        CommonUtils.setMnemonicAndAccelerator(this.jArrayLengthLabel, NLSUtils.getNLSString("CX_FieldLabel_ArrayLength"));
        this.jArrayLengthSpinner.setEnabled(false);
        this.jLookAheadLabel.setText(this._translatable.translate("CX_FieldLabel_LookAhead"));
        this.jLookAheadLabel.setLabelFor(this.jLookAheadSpinner);
        CommonUtils.setMnemonicAndAccelerator(this.jLookAheadLabel, NLSUtils.getNLSString("CX_FieldLabel_LookAhead"));
        this.jLookForLabel.setText(this._translatable.translate("CX_FieldLabel_LookFor"));
        this.jLookForLabel.setLabelFor(this.jLookFor);
        CommonUtils.setMnemonicAndAccelerator(this.jLookForLabel, NLSUtils.getNLSString("CX_FieldLabel_LookFor"));
        this.jDateFormatLabel.setText(this._translatable.translate("CX_FieldLabel_DateFormat"));
        this.jDateFormatLabel.setLabelFor(this.jDateFormatCombo);
        this.jDateFormatCombo.setEditable(true);
        CommonUtils.setMnemonicAndAccelerator(this.jDateFormatLabel, NLSUtils.getNLSString("CX_FieldLabel_DateFormat"));
        this.jQuotedByLabel.setText(this._translatable.translate("CX_FieldLabel_QuotedBy"));
        this.jQuotedByLabel.setLabelFor(this.jQuotedByCombo);
        this.jQuotedByCombo.setEditable(true);
        CommonUtils.setMnemonicAndAccelerator(this.jQuotedByLabel, NLSUtils.getNLSString("CX_FieldLabel_QuotedBy"));
        this.jItemSepCombo.setEnabled(false);
        this.jItemSepCombo.setEditable(true);
        this.jItemSepCombo.addItem(EOL);
        this.jItemSepCombo.setSelectedItem("");
        this.jItemSepLabel.setText(this._translatable.translate("CX_FieldLabel_ItemSep"));
        this.jItemSepLabel.setLabelFor(this.jItemSepCombo);
        CommonUtils.setMnemonicAndAccelerator(this.jItemSepLabel, NLSUtils.getNLSString("CX_FieldLabel_ItemSep"));
        this.jListSepCombo.setEnabled(false);
        this.jListSepCombo.setEditable(true);
        this.jListSepCombo.addItem(EOL);
        this.jListSepCombo.setSelectedItem("");
        this.jListSepLabel.setText(this._translatable.translate("CX_FieldLabel_ListSep"));
        this.jListSepLabel.setLabelFor(this.jListSepCombo);
        CommonUtils.setMnemonicAndAccelerator(this.jListSepLabel, NLSUtils.getNLSString("CX_FieldLabel_ListSep"));
        this.jListCB.setText(this._translatable.translate("CX_FieldLabel_List"));
        CommonUtils.setMnemonicAndAccelerator(this.jListCB, NLSUtils.getNLSString("CX_FieldLabel_List"));
        this.jListCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ComplexFieldPropertiesDialog.this.jListCB_itemStateChanged(e);
            }
        });
        this.jSkipModeLabel.setText(this._translatable.translate("CX_FieldLabel_SkipMode"));
        this.jSkipModeLabel.setLabelFor(this.jSkipModeCombo);
        CommonUtils.setMnemonicAndAccelerator(this.jSkipModeLabel, NLSUtils.getNLSString("CX_FieldLabel_SkipMode"));
        this.jSkipLabel.setText(this._translatable.translate("CX_FieldLabel_Skip"));
        this.jSkipLabel.setLabelFor(this.jSkipSpinner);
        CommonUtils.setMnemonicAndAccelerator(this.jSkipLabel, NLSUtils.getNLSString("CX_FieldLabel_Skip"));
        this.jSkipUntilLabel.setText(this._translatable.translate("CX_FieldLabel_SkipUntil"));
        this.jSkipUntilLabel.setLabelFor(this.jSkipUntilCombo);
        CommonUtils.setMnemonicAndAccelerator(this.jSkipUntilLabel, NLSUtils.getNLSString("CX_FieldLabel_SkipUntil"));
        this.jSkipUntilCombo.setEditable(true);
        this.jSkipUntilCombo.addItem(EOL);
        this.jSkipUntilCombo.setSelectedItem("");
        this.initFieldAttributes();
        for (i = 0; i < _dataTypeList.length; ++i) {
            this.jTypeCombo.addItem(_dataTypeList[i]);
        }
        for (i = 0; i < _paddingList.length; ++i) {
            this.jPadding.addItem(this.translate(_paddingList[i]));
        }
        for (i = 0; i < _dateFormatList.length; ++i) {
            this.jDateFormatCombo.addItem(_dateFormatList[i]);
        }
        for (i = 0; i < _quotedByList.length; ++i) {
            this.jQuotedByCombo.addItem(_quotedByList[i]);
        }
        for (i = 0; i < _skipModeList.length; ++i) {
            this.jSkipModeCombo.addItem(_skipModeList[i]);
        }
        ItemListener typeChangedListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ComplexFieldPropertiesDialog.this.handleTypeSelection();
                }
            }
        };
        this.jTypeCombo.addItemListener(typeChangedListener);
        ItemListener lengthStyleChangedListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (ComplexFieldPropertiesDialog.this.jLengthStyleCombo.getSelectedItem().equals(ComplexFieldPropertiesDialog.LENGTH_IDENTIFIER)) {
                        ComplexFieldPropertiesDialog.this.jLengthLabel.setText("Identifier Length");
                    } else {
                        ComplexFieldPropertiesDialog.this.jLengthLabel.setText("Length");
                    }
                }
            }
        };
        this.jLengthStyleCombo.addItemListener(lengthStyleChangedListener);
        for (int i2 = 0; i2 < _styleList.length; ++i2) {
            this.jStyleCombo.addItem(_styleList[i2]);
        }
        ItemListener styleChangedListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ComplexFieldPropertiesDialog.this.handleStyleSelection();
                }
            }
        };
        this.jStyleCombo.addItemListener(styleChangedListener);
        for (int i3 = 0; i3 < _padStyleList.length; ++i3) {
            this.jPadStyleCombo.addItem(_padStyleList[i3]);
        }
        ItemListener padStyleChangedListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ComplexFieldPropertiesDialog.this.jPadding.setEnabled(true);
                }
            }
        };
        this.jPadStyleCombo.addItemListener(padStyleChangedListener);
        this.jListCB.addActionListener(this);
    }

    protected void layoutControls() {
        this.mainPanel = new JPanel(new GridBagLayout());
        this.mainPanel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.setContent(this.mainPanel);
        JPanel attrPanel = new JPanel(new GridBagLayout());
        UIHelper.addComponent((Container)attrPanel, (Component)this.jFieldPreviewLabel, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 24, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jFieldPreview, (int)1, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 0, 0, 0), (int)100, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jNameLabel, (int)0, (int)1, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 33, 0, 4), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jName, (int)1, (int)1, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 0, 0, 0), (int)100, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jTypeLabel, (int)0, (int)2, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 40, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jTypeCombo, (int)1, (int)2, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jDateFormatLabel, (int)2, (int)2, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 58, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jDateFormatCombo, (int)3, (int)2, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jStyleLabel, (int)0, (int)3, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 58, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jStyleCombo, (int)1, (int)3, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jPattern1Label, (int)2, (int)3, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 3, 0, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jStylePattern1Combo, (int)3, (int)3, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jPattern2Label, (int)4, (int)3, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 0, 0, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jStylePattern2Combo, (int)5, (int)3, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jLengthStyleLabel, (int)0, (int)4, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 25, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jLengthStyleCombo, (int)1, (int)4, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jLengthLabel, (int)2, (int)4, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 28, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jLengthSpinner, (int)3, (int)4, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 0, 0, 0), (int)10, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jPadStyleLabel, (int)0, (int)5, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 33, 0, 0), (int)10, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jPadStyleCombo, (int)1, (int)5, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jPaddingLabel, (int)2, (int)5, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 28, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jPadding, (int)3, (int)5, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jDefaultLabel, (int)0, (int)6, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 18, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jDefaultValue, (int)1, (int)6, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 0, 0, 0), (int)100, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jQuotedByLabel, (int)2, (int)6, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 20, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jQuotedByCombo, (int)3, (int)6, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jStartsWithLabel, (int)0, (int)7, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 28, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jStartsWith, (int)1, (int)7, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 0, 0, 0), (int)100, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jPrefixLabel, (int)0, (int)8, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 28, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jPrefix, (int)1, (int)8, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 0, 0, 0), (int)100, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jSuffixLabel, (int)0, (int)9, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 28, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jSuffix, (int)1, (int)9, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 0, 0, 0), (int)100, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jMinOccursLabel, (int)0, (int)10, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 30, 0, 0), (int)10, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jMinOccursCombo, (int)1, (int)10, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jMaxOccursLabel, (int)0, (int)11, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 28, 0, 0), (int)10, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jMaxOccursCombo, (int)1, (int)11, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jArrayCB, (int)2, (int)11, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jArrayLengthLabel, (int)0, (int)12, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 28, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jArrayLengthSpinner, (int)1, (int)12, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 0, 0, 0), (int)10, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jCellSepLabel, (int)2, (int)12, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 10, 0, 0), (int)10, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jCellSepCombo, (int)3, (int)12, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jArraySepLabel, (int)4, (int)12, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 10, 0, 0), (int)10, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jArraySepCombo, (int)5, (int)12, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jListCB, (int)1, (int)13, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jItemSepLabel, (int)2, (int)13, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 20, 0, 0), (int)10, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jItemSepCombo, (int)3, (int)13, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jListSepLabel, (int)4, (int)13, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 10, 0, 0), (int)10, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jListSepCombo, (int)5, (int)13, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jLookAheadLabel, (int)0, (int)14, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 30, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jLookAheadSpinner, (int)1, (int)14, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 0, 0, 0), (int)10, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jLookForLabel, (int)2, (int)14, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 43, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jLookFor, (int)3, (int)14, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 0, 0, 0), (int)100, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jConditionCB, (int)1, (int)15, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jConditionTypeLabel, (int)2, (int)15, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jCondType, (int)3, (int)15, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 0, 0, 0), (int)40, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jConditionValueLabel, (int)4, (int)15, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(3, 5, 0, 7), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jCondValue, (int)5, (int)15, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(3, 0, 0, 0), (int)40, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jSkipModeLabel, (int)0, (int)16, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 40, 3, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jSkipModeCombo, (int)1, (int)16, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 0, 3, 7), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jSkipLabel, (int)2, (int)16, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 65, 3, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jSkipSpinner, (int)3, (int)16, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 0, 3, 0), (int)10, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jSkipUntilLabel, (int)4, (int)16, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 40, 3, 0), (int)10, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)attrPanel, (Component)this.jSkipUntilCombo, (int)5, (int)16, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 0, 3, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)this.mainPanel, (Component)attrPanel, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        this.setSize(400, 330);
        UIHelper.centerInScreen((Component)((Object)this));
    }

    public void handleOK() {
        this.m_retVal = 0;
        if (!this.validateAttributes()) {
            return;
        }
        this.updateFieldProperties();
        if (this._ffInfo.existsDupFields(this._record)) {
            CommonUtils.error((Object)this, this._translatable.translate("CX_FldPropDlgValidation"));
            this.jName.setText(this._fldname);
            this._fieldProps.setData(1, this._fieldRow, (Object)this._fldname);
            return;
        }
        if (this.m_editMode) {
            this.m_editMode = false;
        }
        this.dispose();
    }

    public void handleCancel() {
        this.m_retVal = 2;
        if (!this.m_editMode) {
            this.m_editMode = false;
        }
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.jListCB) {
            this.handleListCBSelection();
        }
    }

    protected void dismissDialog(boolean cancelled) {
        if (!cancelled) {
            this.handleOK();
        } else {
            this.handleCancel();
        }
    }

    public void cancelOccurred(JDialog dlg) {
        this.handleCancel();
    }

    public int display(FlatFileInfo info, String samplerecord, String record, int fieldRow) {
        this._ffInfo = info;
        this._record = record;
        this._fieldRow = fieldRow;
        if (!this._ffInfo.isStandaloneTesting()) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this.mainPanel, "bpmjdev_adp_wiz_nfb_file_edit_field_dtls1");
        }
        this.jFieldPreview.setText(samplerecord);
        this.jFieldPreview.setPreferredSize(new Dimension(100, 20));
        this._fieldProps = this._ffInfo.getFieldPropertiesDs(record);
        this._fldname = (String)this._fieldProps.getData(1, fieldRow);
        this.setFieldAttributes(this._fieldProps, fieldRow);
        this.pack();
        UIHelper.centerInScreen((Component)((Object)this));
        this.setVisible(true);
        return this.m_retVal;
    }

    public int display(FlatFileInfo info, String samplerecord, String record) {
        this._ffInfo = info;
        this._record = record;
        if (!this._ffInfo.isStandaloneTesting()) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this.mainPanel, "bpmjdev_adp_wiz_nfb_file_edit_field_dtls1");
        }
        this.jFieldPreview.setText(samplerecord);
        this._recAttr = this._ffInfo.getRecordAttributes(record);
        this.setRecordAttributes(this._recAttr);
        this.setVisible(true);
        return this.m_retVal;
    }

    public int display(FlatFileInfo info, String samplerecord, String record, RecTypeAttributes recAttr) {
        this._ffInfo = info;
        this._record = record;
        if (!this._ffInfo.isStandaloneTesting()) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this.mainPanel, "bpmjdev_adp_wiz_nfb_file_edit_field_dtls1");
        }
        this.jFieldPreview.setText(samplerecord);
        this._recAttr = recAttr;
        this.setRecordAttributes(this._recAttr);
        this.pack();
        UIHelper.centerInScreen((Component)((Object)this));
        this.setVisible(true);
        return this.m_retVal;
    }

    public void setEditMode(boolean bEditMode) {
        this.m_editMode = bEditMode;
    }

    private void initFieldAttributes() {
        this.jFieldPreview.setEditable(false);
        this.jPattern1Label.setVisible(false);
        this.jStylePattern1Combo.setVisible(false);
        this.jStylePattern2Combo.setVisible(false);
        this.jPattern2Label.setVisible(false);
        this.jLengthLabel.setVisible(false);
        this.jLengthSpinner.setVisible(false);
        this.jStylePattern1Combo.addItem(EOL);
        this.jStylePattern1Combo.setEditable(true);
        this.jStylePattern2Combo.addItem(EOL);
        this.jStylePattern2Combo.setEditable(true);
    }

    private void handleStyleSelection() {
        if (((String)this.jStyleCombo.getSelectedItem()).equals("fixedLength")) {
            this.jLengthLabel.setVisible(true);
            this.jLengthSpinner.setVisible(true);
            this.jLengthStyleLabel.setVisible(true);
            this.jLengthStyleCombo.setVisible(true);
            this.jStylePattern1Combo.setVisible(false);
            this.jPattern1Label.setVisible(false);
            this.jStylePattern1Combo.setSelectedItem("");
            this.jStylePattern2Combo.setVisible(false);
            this.jPattern2Label.setVisible(false);
            this.jStylePattern2Combo.setSelectedItem("");
            this.jQuotedByLabel.setVisible(false);
            this.jQuotedByCombo.setVisible(false);
            this.jPadStyleCombo.setSelectedItem("tail");
            this.jPadding.setSelectedItem(this.translate(_paddingList[0]));
        } else {
            this.jLengthLabel.setVisible(false);
            this.jLengthSpinner.setVisible(false);
            this.jLengthSpinner.setValue(0);
            this.jLengthStyleLabel.setVisible(false);
            this.jLengthStyleCombo.setVisible(false);
            this.jPadStyleCombo.setSelectedItem("");
            this.jPadding.setSelectedItem("");
            this.jQuotedByLabel.setVisible(false);
            this.jQuotedByCombo.setVisible(false);
            if (((String)this.jStyleCombo.getSelectedItem()).equals("terminated")) {
                this.jStylePattern1Combo.setVisible(true);
                this.jPattern1Label.setVisible(true);
                this.jPattern1Label.setText("Terminated By");
                this.jStylePattern2Combo.setVisible(false);
                this.jPattern2Label.setVisible(false);
                this.jStylePattern2Combo.setSelectedItem("");
                this.jQuotedByLabel.setVisible(true);
                this.jQuotedByCombo.setVisible(true);
            } else {
                this.jStylePattern1Combo.setVisible(false);
                this.jPattern1Label.setVisible(false);
                this.jStylePattern1Combo.setSelectedItem("");
                this.jQuotedByLabel.setVisible(false);
                this.jQuotedByCombo.setVisible(false);
                if (((String)this.jStyleCombo.getSelectedItem()).equals("surrounded")) {
                    this.jStylePattern1Combo.setVisible(true);
                    this.jPattern1Label.setVisible(true);
                    this.jPattern1Label.setText(this._translatable.translate("CX_FieldLabel_Surrounded"));
                    this.jStylePattern2Combo.setVisible(false);
                    this.jPattern2Label.setVisible(false);
                    this.jStylePattern2Combo.setSelectedItem("");
                } else {
                    this.jStylePattern1Combo.setVisible(false);
                    this.jPattern1Label.setVisible(false);
                    this.jStylePattern1Combo.setSelectedItem("");
                    if (((String)this.jStyleCombo.getSelectedItem()).equals("left/right surrounded")) {
                        this.jStylePattern1Combo.setVisible(true);
                        this.jPattern1Label.setVisible(true);
                        this.jPattern1Label.setText(this._translatable.translate("CX_FieldLabel_LeftSurrounded"));
                        this.jStylePattern2Combo.setVisible(true);
                        this.jPattern2Label.setVisible(true);
                        this.jPattern2Label.setText(this._translatable.translate("CX_FieldLabel_RightSurrounded"));
                    } else {
                        this.jStylePattern1Combo.setVisible(false);
                        this.jPattern1Label.setVisible(false);
                        this.jStylePattern1Combo.setSelectedItem("");
                        this.jStylePattern2Combo.setVisible(false);
                        this.jPattern2Label.setVisible(false);
                        this.jStylePattern2Combo.setSelectedItem("");
                    }
                }
            }
        }
        this.pack();
    }

    private void handleTypeSelection() {
        if (!Arrays.asList(_dataTypeList).contains(this.jTypeCombo.getSelectedItem())) {
            this.resetAllAttributes();
            this.setVisibleAllAttributes(false);
            this.jMaxOccursLabel.setVisible(true);
            this.jMaxOccursCombo.setVisible(true);
            this.jArrayLengthLabel.setVisible(true);
            this.jArrayLengthSpinner.setVisible(true);
            this.jArraySepLabel.setVisible(true);
            this.jArraySepCombo.setVisible(true);
            this.jCellSepLabel.setVisible(true);
            this.jCellSepCombo.setVisible(true);
            this.jLookAheadLabel.setVisible(true);
            this.jLookAheadSpinner.setVisible(true);
            this.jLookForLabel.setVisible(true);
            this.jLookFor.setVisible(true);
            this.jConditionCB.setVisible(true);
            this.jConditionValueLabel.setVisible(true);
            this.jCondValue.setVisible(true);
            this.jStartsWithLabel.setVisible(true);
            this.jStartsWith.setVisible(true);
        } else {
            if (this.jTypeCombo.getSelectedItem().equals("date") || this.jTypeCombo.getSelectedItem().equals("dateTime")) {
                this.jDateFormatLabel.setVisible(true);
                this.jDateFormatCombo.setVisible(true);
            } else {
                this.jDateFormatLabel.setVisible(false);
                this.jDateFormatCombo.setVisible(false);
            }
            if (this.jTypeCombo.getSelectedItem().equals("string")) {
                this.jLengthStyleLabel.setVisible(true);
                this.jLengthStyleCombo.setVisible(true);
                this.jLengthLabel.setVisible(true);
                this.jLengthSpinner.setVisible(true);
            } else {
                this.jLengthStyleLabel.setVisible(false);
                this.jLengthStyleCombo.setVisible(false);
                this.jLengthLabel.setVisible(false);
                this.jLengthSpinner.setVisible(false);
            }
            this.jConditionCB.setVisible(true);
            this.jConditionValueLabel.setVisible(true);
            this.jCondValue.setVisible(true);
            this.jDefaultLabel.setVisible(true);
            this.jDefaultValue.setVisible(true);
            this.jPaddingLabel.setVisible(true);
            this.jPadding.setVisible(true);
            this.jPadStyleCombo.setVisible(true);
            this.jPadStyleLabel.setVisible(true);
            this.jStyleCombo.setVisible(true);
            this.jStyleLabel.setVisible(true);
        }
        this.pack();
    }

    private void handleMaxOccursSelection(String maxOccurs) {
        if (maxOccurs.equals("UNBOUNDED")) {
            this.jArrayCB.setEnabled(true);
            this.jListCB.setEnabled(true);
        } else if (maxOccurs.equals("1")) {
            this.jArrayCB.setSelected(false);
            this.jArrayCB.setEnabled(false);
            this.jListCB.setSelected(false);
            this.jListCB.setEnabled(false);
        } else {
            this.jArrayCB.setSelected(false);
            this.jArrayCB.setEnabled(false);
            this.jListCB.setEnabled(false);
            this.jListCB.setSelected(false);
        }
    }

    private void handleListCBSelection() {
        if (this.jListCB.isSelected()) {
            this.jItemSepCombo.setEnabled(true);
            this.jListSepCombo.setEnabled(true);
        } else {
            this.jItemSepCombo.setEnabled(false);
            this.jListSepCombo.setEnabled(false);
        }
    }

    private void setVisibleAllAttributes(boolean show) {
        this.jConditionCB.setVisible(show);
        this.jConditionValueLabel.setVisible(show);
        this.jCondValue.setVisible(show);
        this.jDefaultLabel.setVisible(show);
        this.jDefaultValue.setVisible(show);
        this.jLengthStyleLabel.setVisible(show);
        this.jLengthStyleCombo.setVisible(show);
        this.jLengthLabel.setVisible(show);
        this.jLengthSpinner.setVisible(show);
        this.jPaddingLabel.setVisible(show);
        this.jPadding.setVisible(show);
        this.jPadStyleCombo.setVisible(show);
        this.jPadStyleLabel.setVisible(show);
        this.jPattern1Label.setVisible(show);
        this.jPattern2Label.setVisible(show);
        this.jStyleCombo.setVisible(show);
        this.jStyleLabel.setVisible(show);
        this.jStylePattern1Combo.setVisible(show);
        this.jStylePattern2Combo.setVisible(show);
        this.jStartsWithLabel.setVisible(show);
        this.jStartsWith.setVisible(show);
        this.jMinOccursLabel.setVisible(show);
        this.jMinOccursCombo.setVisible(show);
        this.jMaxOccursLabel.setVisible(show);
        this.jMaxOccursCombo.setVisible(show);
        this.jPrefixLabel.setVisible(show);
        this.jPrefix.setVisible(show);
        this.jSuffixLabel.setVisible(show);
        this.jSuffix.setVisible(show);
        this.jLookAheadLabel.setVisible(show);
        this.jLookAheadSpinner.setVisible(show);
        this.jLookForLabel.setVisible(show);
        this.jLookFor.setVisible(show);
        this.jDateFormatLabel.setVisible(show);
        this.jDateFormatCombo.setVisible(show);
        this.jArrayLengthLabel.setVisible(show);
        this.jArrayLengthSpinner.setVisible(show);
        this.jArraySepLabel.setVisible(show);
        this.jArraySepCombo.setVisible(show);
        this.jCellSepLabel.setVisible(show);
        this.jCellSepCombo.setVisible(show);
        this.jQuotedByLabel.setVisible(show);
        this.jQuotedByCombo.setVisible(show);
        this.jListCB.setVisible(show);
        this.jItemSepLabel.setVisible(show);
        this.jItemSepCombo.setVisible(show);
        this.jListSepLabel.setVisible(show);
        this.jListSepCombo.setVisible(show);
    }

    private void resetAllAttributes() {
        this.jConditionCB.setSelected(false);
        this.jCondValue.setText("");
        this.jDefaultValue.setText("");
        this.jLengthSpinner.setValue(0);
        this.jPadding.setSelectedItem("");
        this.jPadStyleCombo.setSelectedItem("");
        this.jStyleCombo.setSelectedItem("");
        this.jStylePattern1Combo.setSelectedItem("");
        this.jStylePattern2Combo.setSelectedItem("");
        this.jStartsWith.setText("");
        this.jPrefix.setText("");
        this.jSuffix.setText("");
        this.jMinOccursCombo.setSelectedItem("1");
        this.jMaxOccursCombo.setSelectedItem("1");
        this.jLookAheadSpinner.setValue(0);
        this.jLookFor.setText("");
        this.jDateFormatCombo.setSelectedItem("");
        this.jArrayCB.setSelected(false);
        this.jArrayLengthSpinner.setValue(0);
        this.jArraySepCombo.setSelectedItem("");
        this.jCellSepCombo.setSelectedItem("");
        this.jQuotedByCombo.setSelectedItem("");
        this.jListCB.setSelected(false);
        this.jItemSepCombo.setSelectedItem("");
        this.jListSepCombo.setSelectedItem("");
        this.jSkipModeCombo.setSelectedItem("");
        this.jSkipSpinner.setValue(0);
        this.jSkipUntilCombo.setSelectedItem("");
    }

    private void setFieldAttributes(ArrayTwoDModel fieldProps, int fieldRow) {
        String fieldName = (String)fieldProps.getData(1, fieldRow);
        String fieldType = (String)fieldProps.getData(2, fieldRow);
        Vector recTypeList = this._ffInfo.getValidRecordTypeList(this._record);
        Enumeration enum_rectype = recTypeList.elements();
        while (enum_rectype.hasMoreElements()) {
            this.jTypeCombo.addItem((String)enum_rectype.nextElement());
        }
        String style = (String)fieldProps.getData(7, fieldRow);
        String stylePattern1 = (String)fieldProps.getData(8, fieldRow);
        String stylePattern2 = (String)fieldProps.getData(9, fieldRow);
        int length = (Integer)fieldProps.getData(3, fieldRow);
        boolean condition = (Boolean)fieldProps.getData(0, fieldRow);
        String condvalue = (String)fieldProps.getData(12, fieldRow);
        String padstyle = (String)fieldProps.getData(10, fieldRow);
        String padding = (String)fieldProps.getData(11, fieldRow);
        String defaultvalue = (String)fieldProps.getData(13, fieldRow);
        String startsWith = (String)fieldProps.getData(15, fieldRow);
        String minOccurs = (String)fieldProps.getData(16, fieldRow);
        String maxOccurs = (String)fieldProps.getData(17, fieldRow);
        String prefix = (String)fieldProps.getData(18, fieldRow);
        String suffix = (String)fieldProps.getData(19, fieldRow);
        String lookAhead = (String)fieldProps.getData(20, fieldRow);
        String lookFor = (String)fieldProps.getData(21, fieldRow);
        String lengthStyle = (String)fieldProps.getData(22, fieldRow);
        Boolean array = (Boolean)fieldProps.getData(23, fieldRow);
        String arrayLength = (String)fieldProps.getData(24, fieldRow);
        String arraySep = (String)fieldProps.getData(25, fieldRow);
        String cellSep = (String)fieldProps.getData(26, fieldRow);
        String quotedBy = (String)fieldProps.getData(28, fieldRow);
        Boolean list = (Boolean)fieldProps.getData(29, fieldRow);
        String itemSep = (String)fieldProps.getData(31, fieldRow);
        String listSep = (String)fieldProps.getData(30, fieldRow);
        String skipMode = (String)fieldProps.getData(32, fieldRow);
        String skip = (String)fieldProps.getData(33, fieldRow);
        String skipUntil = (String)fieldProps.getData(34, fieldRow);
        this.jName.setText(fieldName);
        this.jTypeCombo.setSelectedItem(fieldType);
        this.jStyleCombo.setSelectedItem(style);
        this.jStylePattern1Combo.setSelectedItem(stylePattern1);
        this.jStylePattern2Combo.setSelectedItem(stylePattern2);
        if (!condition) {
            this.jConditionCB.setVisible(false);
            this.jConditionTypeLabel.setVisible(false);
            this.jCondType.setVisible(false);
            this.jConditionValueLabel.setVisible(false);
            this.jCondValue.setVisible(false);
        } else {
            this.jConditionCB.setSelected(condition);
            this.jCondValue.setText(condvalue);
        }
        this.jLengthStyleCombo.setSelectedItem(lengthStyle);
        this.jLengthSpinner.setValue(length);
        this.jPadStyleCombo.setSelectedItem(padstyle);
        this.jPadding.setSelectedItem(padding);
        this.jDefaultValue.setText(defaultvalue);
        this.jStartsWith.setText(startsWith);
        if (minOccurs.equals("-1")) {
            minOccurs = "1";
        }
        this.jMinOccursCombo.setSelectedItem(minOccurs);
        if (maxOccurs.equals("-1")) {
            maxOccurs = "1";
        }
        this.jMaxOccursCombo.setSelectedItem(maxOccurs);
        if (maxOccurs.equals("1")) {
            this.jArrayCB.setSelected(false);
            this.jArrayCB.setEnabled(false);
            this.jListCB.setSelected(false);
            this.jListCB.setEnabled(false);
        } else if (maxOccurs.equals("UNBOUNDED")) {
            this.jArrayCB.setEnabled(true);
            this.jListCB.setEnabled(true);
        } else {
            this.jArrayCB.setSelected(false);
            this.jArrayCB.setEnabled(false);
            this.jListCB.setSelected(false);
            this.jListCB.setEnabled(false);
        }
        this.jPrefix.setText(prefix);
        this.jSuffix.setText(suffix);
        if (lookAhead != null) {
            this.jLookAheadSpinner.setValue(Integer.parseInt(lookAhead));
        } else {
            this.jLookAheadSpinner.setValue(new Integer(0));
        }
        this.jLookFor.setText(lookFor);
        this.jArrayCB.setSelected(array);
        if (arrayLength != null) {
            this.jArrayLengthSpinner.setValue(Integer.parseInt(arrayLength));
        } else {
            this.jArrayLengthSpinner.setValue(new Integer(0));
        }
        this.jArraySepCombo.setSelectedItem(arraySep);
        this.jCellSepCombo.setSelectedItem(cellSep);
        this.jQuotedByCombo.setSelectedItem(quotedBy);
        this.jListCB.setSelected(list);
        this.jListSepCombo.setSelectedItem(listSep);
        this.jItemSepCombo.setSelectedItem(itemSep);
        this.jSkipModeCombo.setSelectedItem(skipMode);
        if (skip != null) {
            this.jSkipSpinner.setValue(Integer.parseInt(skip));
        } else {
            this.jSkipSpinner.setValue(new Integer(0));
        }
        this.jSkipUntilCombo.setSelectedItem(skipUntil);
    }

    private void setRecordAttributes(RecTypeAttributes recProps) {
        String fieldName = recProps.getRecordName();
        String fieldType = recProps.getType();
        Vector recTypeList = this._ffInfo.getValidRecordTypeList(this._record);
        Enumeration enum_rectype = recTypeList.elements();
        while (enum_rectype.hasMoreElements()) {
            this.jTypeCombo.addItem((String)enum_rectype.nextElement());
        }
        String style = recProps.getStyle();
        String stylePattern1 = recProps.getStylePattern1();
        String stylePattern2 = recProps.getStylePattern2();
        int length = recProps.getLength();
        boolean condition = recProps.isChoice();
        String condType = recProps.getChoiceType();
        String condvalue = recProps.getChoiceValue();
        String padstyle = recProps.getPadStyle();
        String padding = recProps.getPadding();
        String defaultvalue = recProps.getDefaultValue();
        String startsWith = recProps.getStartsWith();
        String minOccurs = String.valueOf(recProps.getMinOccurs());
        String maxOccurs = "";
        maxOccurs = recProps.getOccurs() == 0x7FFFFFF8 ? "UNBOUNDED" : String.valueOf(recProps.getOccurs());
        String prefix = recProps.getPrefix();
        String suffix = recProps.getSuffix();
        String lookAhead = recProps.getLookAhead();
        String lookFor = recProps.getLookFor();
        String lengthStyle = recProps.getLengthStyle();
        Boolean array = recProps.isArray();
        String arrayLength = recProps.getArrayLength();
        String arraySep = recProps.getArraySeparator();
        String cellSep = recProps.getCellSeparator();
        String quotedBy = recProps.getQuotedBy();
        Boolean list = recProps.isList();
        String listSep = recProps.getListSeparator();
        String itemSep = recProps.getItemSeparator();
        String skipMode = recProps.getSkipMode();
        String skip = recProps.getSkip();
        String skipUntil = recProps.getSkipUntil();
        this.jName.setText(fieldName);
        this.jTypeCombo.setSelectedItem(fieldType);
        this.jStyleCombo.setSelectedItem(style);
        this.jStylePattern1Combo.setSelectedItem(stylePattern1);
        this.jStylePattern2Combo.setSelectedItem(stylePattern2);
        if (!condition) {
            this.jConditionCB.setVisible(false);
            this.jConditionTypeLabel.setVisible(false);
            this.jCondType.setVisible(false);
            this.jConditionValueLabel.setVisible(false);
            this.jCondValue.setVisible(false);
        } else {
            this.jConditionCB.setSelected(condition);
            this.jCondType.setText(condType);
            this.jCondValue.setText(condvalue);
        }
        this.jLengthStyleCombo.setSelectedItem(lengthStyle);
        this.jLengthSpinner.setValue(length);
        this.jPadStyleCombo.setSelectedItem(padstyle);
        this.jPadding.setSelectedItem(padding);
        this.jDefaultValue.setText(defaultvalue);
        this.jStartsWith.setText(startsWith);
        if (minOccurs.equals("-1")) {
            minOccurs = "1";
        }
        this.jMinOccursCombo.setSelectedItem(minOccurs);
        if (maxOccurs.equals("-1")) {
            maxOccurs = "1";
        }
        this.jMaxOccursCombo.setSelectedItem(maxOccurs);
        this.jPrefix.setText(prefix);
        this.jSuffix.setText(suffix);
        if (lookAhead != null) {
            this.jLookAheadSpinner.setValue(Integer.parseInt(lookAhead));
        } else {
            this.jLookAheadSpinner.setValue(new Integer(0));
        }
        this.jLookFor.setText(lookFor);
        this.jArrayCB.setSelected(array);
        if (arrayLength != null) {
            this.jArrayLengthSpinner.setValue(Integer.parseInt(arrayLength));
        } else {
            this.jArrayLengthSpinner.setValue(new Integer(0));
        }
        this.jArraySepCombo.setSelectedItem(arraySep);
        this.jCellSepCombo.setSelectedItem(cellSep);
        this.jQuotedByCombo.setSelectedItem(quotedBy);
        this.jListCB.setSelected(list);
        this.jListSepCombo.setSelectedItem(listSep);
        this.jItemSepCombo.setSelectedItem(itemSep);
        this.jSkipModeCombo.setSelectedItem(skipMode);
        if (skip != null) {
            this.jSkipSpinner.setValue(Integer.parseInt(skip));
        } else {
            this.jSkipSpinner.setValue(new Integer(0));
        }
        this.jSkipUntilCombo.setSelectedItem(skipUntil);
    }

    private void updateFieldProperties() {
        if (this._fieldProps != null) {
            this._fieldProps.setData(0, this._fieldRow, (Object)this.jConditionCB.isSelected());
            this._fieldProps.setData(12, this._fieldRow, (Object)this.jCondValue.getText());
            this._fieldProps.setData(1, this._fieldRow, (Object)this.jName.getText());
            this._fieldProps.setData(2, this._fieldRow, (Object)((String)this.jTypeCombo.getSelectedItem()));
            this._fieldProps.setData(3, this._fieldRow, (Object)((Integer)this.jLengthSpinner.getValue()));
            this._fieldProps.setData(7, this._fieldRow, (Object)((String)this.jStyleCombo.getSelectedItem()));
            this._fieldProps.setData(8, this._fieldRow, (Object)((String)this.jStylePattern1Combo.getSelectedItem()));
            this._fieldProps.setData(9, this._fieldRow, (Object)((String)this.jStylePattern2Combo.getSelectedItem()));
            this._fieldProps.setData(13, this._fieldRow, (Object)this.jDefaultValue.getText());
            this._fieldProps.setData(10, this._fieldRow, (Object)((String)this.jPadStyleCombo.getSelectedItem()));
            this._fieldProps.setData(11, this._fieldRow, (Object)((String)this.jPadding.getSelectedItem()));
            this._fieldProps.setData(15, this._fieldRow, (Object)this.jStartsWith.getText());
            this._fieldProps.setData(16, this._fieldRow, (Object)((String)this.jMinOccursCombo.getSelectedItem()));
            this._fieldProps.setData(17, this._fieldRow, (Object)((String)this.jMaxOccursCombo.getSelectedItem()));
            this._fieldProps.setData(18, this._fieldRow, (Object)this.jPrefix.getText());
            this._fieldProps.setData(19, this._fieldRow, (Object)this.jSuffix.getText());
            this._fieldProps.setData(20, this._fieldRow, (Object)((Integer)this.jLookAheadSpinner.getValue()).toString());
            this._fieldProps.setData(21, this._fieldRow, (Object)this.jLookFor.getText());
            this._fieldProps.setData(22, this._fieldRow, this.jLengthStyleCombo.getSelectedItem());
            this._fieldProps.setData(23, this._fieldRow, (Object)this.jArrayCB.isSelected());
            this._fieldProps.setData(24, this._fieldRow, (Object)((Integer)this.jArrayLengthSpinner.getValue()).toString());
            this._fieldProps.setData(25, this._fieldRow, this.jArraySepCombo.getSelectedItem());
            this._fieldProps.setData(26, this._fieldRow, this.jCellSepCombo.getSelectedItem());
            this._fieldProps.setData(27, this._fieldRow, this.jDateFormatCombo.getSelectedItem());
            this._fieldProps.setData(28, this._fieldRow, this.jQuotedByCombo.getSelectedItem());
            this._fieldProps.setData(29, this._fieldRow, (Object)this.jListCB.isSelected());
            this._fieldProps.setData(30, this._fieldRow, this.jListSepCombo.getSelectedItem());
            this._fieldProps.setData(31, this._fieldRow, this.jItemSepCombo.getSelectedItem());
            this._fieldProps.setData(32, this._fieldRow, this.jSkipModeCombo.getSelectedItem());
            this._fieldProps.setData(33, this._fieldRow, (Object)((Integer)this.jSkipSpinner.getValue()).toString());
            this._fieldProps.setData(34, this._fieldRow, this.jSkipUntilCombo.getSelectedItem());
        } else {
            this._recAttr.setChoice(this.jConditionCB.isSelected());
            this._recAttr.setChoiceValue(this.jCondValue.getText());
            this._recAttr.setRecordName(this.jName.getText());
            this._recAttr.setType((String)this.jTypeCombo.getSelectedItem());
            this._recAttr.setLength((Integer)this.jLengthSpinner.getValue());
            this._recAttr.setStyle((String)this.jStyleCombo.getSelectedItem());
            this._recAttr.setStylePattern1((String)this.jStylePattern1Combo.getSelectedItem());
            this._recAttr.setStylePattern2((String)this.jStylePattern2Combo.getSelectedItem());
            this._recAttr.setDefaultValue(this.jDefaultValue.getText());
            this._recAttr.setPadStyle((String)this.jPadStyleCombo.getSelectedItem());
            this._recAttr.setPadding((String)this.jPadding.getSelectedItem());
            this._recAttr.setStartsWith(this.jStartsWith.getText());
            this._recAttr.setMinOccurs(Integer.parseInt((String)this.jMinOccursCombo.getSelectedItem()));
            int maxoccurs = 1;
            maxoccurs = this.jMaxOccursCombo.getSelectedItem().equals("UNBOUNDED") ? 0x7FFFFFF8 : Integer.parseInt((String)this.jMinOccursCombo.getSelectedItem());
            this._recAttr.setOccurs(maxoccurs);
            this._recAttr.setPrefix(this.jPrefix.getText());
            this._recAttr.setSuffix(this.jSuffix.getText());
            this._recAttr.setLookAhead(((Integer)this.jLookAheadSpinner.getValue()).toString());
            this._recAttr.setLookFor(this.jLookFor.getText());
            this._recAttr.setLengthStyle((String)this.jLengthStyleCombo.getSelectedItem());
            this._recAttr.setArrayLength(((Integer)this.jArrayLengthSpinner.getValue()).toString());
            this._recAttr.setArraySeparator((String)this.jArraySepCombo.getSelectedItem());
            this._recAttr.setCellSeparator((String)this.jCellSepCombo.getSelectedItem());
            this._recAttr.setDateFormat((String)this.jDateFormatCombo.getSelectedItem());
            this._recAttr.setQuotedBy((String)this.jQuotedByCombo.getSelectedItem());
            this._recAttr.setList(this.jListCB.isSelected());
            this._recAttr.setItemSeparator((String)this.jItemSepCombo.getSelectedItem());
            this._recAttr.setListSeparator((String)this.jListSepCombo.getSelectedItem());
            this._recAttr.setSkipMode((String)this.jSkipModeCombo.getSelectedItem());
            this._recAttr.setSkip(((Integer)this.jSkipSpinner.getValue()).toString());
            this._recAttr.setSkipUntil((String)this.jSkipUntilCombo.getSelectedItem());
        }
    }

    public RecTypeAttributes getRecAttributes() {
        return this._recAttr;
    }

    private void jArrayCB_itemStateChanged(ItemEvent e) {
        if (((JCheckBox)e.getSource()).isSelected()) {
            this.jCellSepCombo.setEnabled(true);
            this.jArraySepCombo.setEnabled(true);
            this.jArrayLengthSpinner.setEnabled(true);
            this.jListCB.setSelected(false);
        } else {
            this.jCellSepCombo.setSelectedItem("");
            this.jCellSepCombo.setEnabled(false);
            this.jArraySepCombo.setSelectedItem("");
            this.jArraySepCombo.setEnabled(false);
            this.jArrayLengthSpinner.setEnabled(false);
            this.jArrayLengthSpinner.setValue(0);
        }
    }

    private void jListCB_itemStateChanged(ItemEvent e) {
        if (((JCheckBox)e.getSource()).isSelected()) {
            this.jListSepCombo.setEnabled(true);
            this.jItemSepCombo.setEnabled(true);
            this.jArrayCB.setSelected(false);
        } else {
            this.jListSepCombo.setSelectedItem("");
            this.jListSepCombo.setEnabled(false);
            this.jItemSepCombo.setSelectedItem("");
            this.jItemSepCombo.setEnabled(false);
        }
    }

    private boolean validateAttributes() {
        if (this.jArrayCB.isSelected()) {
            if (((String)this.jArraySepCombo.getSelectedItem()).equals("") & ((String)this.jCellSepCombo.getSelectedItem()).equals("") & ((Integer)this.jArrayLengthSpinner.getValue()).equals(0)) {
                CommonUtils.error((Object)this, this._translatable.translate("CX_FldPropDlgArrayValidation"));
                return false;
            }
            if (!((String)this.jArraySepCombo.getSelectedItem()).equals("") & !((String)this.jCellSepCombo.getSelectedItem()).equals("") && ((String)this.jArraySepCombo.getSelectedItem()).equals((String)this.jCellSepCombo.getSelectedItem())) {
                CommonUtils.error((Object)this, this._translatable.translate("CX_FldPropDlgArrayValidation1"));
                return false;
            }
        }
        if (this.jListCB.isSelected()) {
            if (((String)this.jItemSepCombo.getSelectedItem()).equals("")) {
                CommonUtils.error((Object)this, this._translatable.translate("CX_FldPropDlgListValidation"));
                return false;
            }
            if (((String)this.jListSepCombo.getSelectedItem()).equals((String)this.jItemSepCombo.getSelectedItem())) {
                CommonUtils.error((Object)this, this._translatable.translate("CX_FldPropDlgListValidation2"));
                return false;
            }
        }
        if (this.jConditionCB.isSelected() && this.jCondValue.getText().equals("")) {
            CommonUtils.error((Object)this, this._translatable.translate("CX_FldPropDlgCondValidation"));
            return false;
        }
        if (!((String)this.jSkipModeCombo.getSelectedItem()).equals("") && (Integer)this.jSkipSpinner.getValue() == 0 & ((String)this.jSkipUntilCombo.getSelectedItem()).equals("")) {
            CommonUtils.error((Object)this, this._translatable.translate("CX_FldPropDlgSkipValidation"));
            return false;
        }
        return true;
    }
}

