/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.image.ImageProducer;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.table.SpreadTable;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WhAlert;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.DebugUtility;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.NLSUtils;

public class CommonUtils {
    public static Hashtable startupInfobusMsgs = new Hashtable();
    public static Frame _mainFrame = null;
    public static Hashtable windowTable = new Hashtable();
    private static final String DEBUGSEP = "debugSep";
    private static final Hashtable m_imageCache = new Hashtable(200);
    private static final String PROPERTYINSPECTOR = "LaunchPropertyInspector";
    private static final String PROPERTYINSPECTOR2 = "LaunchPropertyInspector2";
    public static final int MIN_FONT_SIZE = 12;
    private static final String MONOFONT = "Monospaced";
    public static final int TREE = 1;
    public static final int EDITOR = 2;
    public static final int PALETTE = 3;
    public static final int DRAG = 4;
    public static final int LABEL = 5;
    private static final String TYPE_OBJECT_ALREADY_DELETED = "TypeObjectAlreadyDeleted";

    public static String getCommonError(String token) {
        return NLSUtils.getNLSString(token);
    }

    public static String getCommonError(String token, Object[] args) {
        return NLSUtils.getNLSString(token, args);
    }

    public static String getCommonLang(String token) {
        return NLSUtils.getNLSString(token);
    }

    public static String getCommonLang(String token, Object[] args) {
        return NLSUtils.getNLSString(token, args);
    }

    public static synchronized void setConsoleFrame(Frame mainFrame) {
        _mainFrame = mainFrame;
    }

    public static synchronized Frame getConsoleFrame() {
        return _mainFrame;
    }

    public static synchronized Hashtable getWindowList() {
        return windowTable;
    }

    public static final Component getParentFrameOrDialog(Object c) {
        if (c instanceof Component) {
            Component cc = (Component)c;
            if (cc instanceof Frame) {
                return (Frame)cc;
            }
            if (cc instanceof Dialog) {
                return (Dialog)cc;
            }
            while ((cc = cc.getParent()) != null) {
                if (cc instanceof Frame) {
                    return (Frame)cc;
                }
                if (!(cc instanceof Dialog)) continue;
                return (Dialog)cc;
            }
        }
        Frame parent = CommonUtils.getConsoleFrame();
        Frame[] frames = Frame.getFrames();
        for (int i = 0; i < frames.length; ++i) {
            if (frames[i].getFocusOwner() == null) continue;
            parent = frames[i];
            break;
        }
        return parent;
    }

    public static Frame getParentFrame(Object c) {
        Frame parentFrame = null;
        Dialog parentDialog = null;
        Window parentWindow = (Window)CommonUtils.getParentFrameOrDialog(c);
        if (parentWindow instanceof Dialog) {
            parentDialog = (Dialog)parentWindow;
            while (parentWindow != null && !((parentWindow = parentWindow.getOwner()) instanceof Frame)) {
            }
        }
        if (parentWindow instanceof Frame) {
            parentFrame = (Frame)parentWindow;
        }
        return parentFrame;
    }

    public static final void error(Object obj, Exception e) {
        WhAlert alert = new WhAlert((Dialog)CommonUtils.getParentFrameOrDialog(obj), e.getMessage(), 0, 8);
        alert.setCenterOver(CommonUtils.getParentFrameOrDialog(obj));
        alert.setTitle("Error");
        alert.runAlert();
    }

    public static final void error(Object obj, String msg) {
        WhAlert alert = new WhAlert((Dialog)CommonUtils.getParentFrameOrDialog(obj), msg, 0, 8);
        alert.setCenterOver(CommonUtils.getParentFrameOrDialog(obj));
        alert.setTitle("Error");
        alert.runAlert();
    }

    public static final void debug(String s) {
        DebugUtility.debug(s);
    }

    public static final void debug(Object obj, String s) {
        DebugUtility.debug(obj, s);
    }

    public static final void debug(Object obj, Exception ex) {
        DebugUtility.debug(obj, ex);
    }

    public static final void debug(Object obj, String s, Exception ex) {
        DebugUtility.debug(obj, s, ex);
    }

    public static void setMnemonicAndAccelerator(JComponent component, String rtsString) {
        int idx = NLSUtils.getMnemonicIndex(rtsString);
        if (idx >= 0) {
            char ch = rtsString.charAt(idx + 1);
            if (component instanceof JLabel) {
                ((JLabel)component).setDisplayedMnemonic(ch);
            } else if (component instanceof AbstractButton) {
                ((AbstractButton)component).setDisplayedMnemonicIndex(idx);
                ((AbstractButton)component).setMnemonic(ch);
            }
        }
    }

    public static final String translateResourceString(String rtsString) {
        return NLSUtils.translateResourceString(rtsString);
    }

    public static final String getResourceString(String directory, String s) {
        return NLSUtils.getResourceString(directory, s);
    }

    public static final String getResourceString(String directory, String s, Object[] args) {
        return NLSUtils.getResourceString(directory, s, args);
    }

    public static Object getContentFromURL(String relPath) throws Exception {
        Component tempComp = new Component(){};
        if (relPath == null) {
            return null;
        }
        URL frameURL = null;
        try {
            frameURL = tempComp.getClass().getClassLoader().getResource(relPath);
        }
        catch (NullPointerException npe) {
            frameURL = ClassLoader.getSystemResource(relPath);
        }
        if (frameURL == null) {
            frameURL = tempComp.getClass().getResource(relPath);
        }
        if (frameURL == null) {
            return null;
        }
        return frameURL.getContent();
    }

    public static Image getIcon(String relPath) {
        Image icon = null;
        Component tempComp = new Component(){};
        Image image = icon = relPath != null ? (Image)m_imageCache.get(relPath) : null;
        if (icon != null) {
            return icon;
        }
        try {
            Object content = CommonUtils.getContentFromURL(relPath);
            if (content instanceof Image) {
                icon = (Image)content;
            } else if (content instanceof ImageProducer) {
                icon = tempComp.createImage((ImageProducer)content);
            } else if (content instanceof InputStream) {
                int increment;
                InputStream stream = (InputStream)content;
                int numBytes = stream.available();
                byte[] imageBuffer = new byte[numBytes];
                int total = 0;
                do {
                    if ((increment = stream.read(imageBuffer, total, numBytes - total)) <= 0) continue;
                    total += increment;
                } while (total < numBytes && increment > 0);
                stream.close();
                if (imageBuffer != null) {
                    icon = tempComp.getToolkit().createImage(imageBuffer);
                }
            }
        }
        catch (Exception ioe) {
            CommonUtils.myDebug("Cannot find image " + relPath);
            CommonUtils.myDebug(ioe);
        }
        if (icon != null) {
            ImageUtils.loadImage((Image)icon);
        }
        return icon;
    }

    public static Icon getIcon1(String relPath) {
        Component tempComp = new Component(){};
        Icon icon = null;
        try {
            Object content = CommonUtils.getContentFromURL(relPath);
            if (content instanceof Icon) {
                icon = (Icon)content;
            }
        }
        catch (Exception ioe) {
            CommonUtils.myDebug("Cannot find image " + relPath);
            CommonUtils.myDebug(ioe);
        }
        m_imageCache.put(relPath, icon);
        return icon;
    }

    public static Image getIconFromNLS(String nlsKey) {
        return CommonUtils.getIcon(NLSUtils.getNLSString(nlsKey));
    }

    public static Image getIconFromResource(String nlsPath, String nlsKey) {
        return CommonUtils.getIcon(CommonUtils.getResourceString(nlsPath, nlsKey));
    }

    public static Image getIcon(String type, int context) {
        return null;
    }

    public static String getPropertyInspectorString() {
        return PROPERTYINSPECTOR;
    }

    public static String getPropertyInspectorString2() {
        return PROPERTYINSPECTOR2;
    }

    public static String getEditorString(String type) {
        return null;
    }

    public static String getCopyLikeWizard(String type) {
        return null;
    }

    public static String getWizardString(String type) {
        return null;
    }

    public static String getLabelString(String type) {
        return null;
    }

    public static String getHelpString(String type) {
        return null;
    }

    public static void setDefaultCursor(Component component) {
        component.setCursor(Cursor.getPredefinedCursor(0));
    }

    public static void setDefaultCursor(Component component, int parentLevel) {
        Component c = CommonUtils.getParentFrameOrDialog(component, parentLevel);
        c.setCursor(Cursor.getPredefinedCursor(0));
    }

    public static void setWaitCursor(Component component) {
        component.setCursor(Cursor.getPredefinedCursor(3));
    }

    public static void setWaitCursor(Component component, int parentLevel) {
        Component c = CommonUtils.getParentFrameOrDialog(component, parentLevel);
        c.setCursor(Cursor.getPredefinedCursor(3));
    }

    public static final Component getParentFrameOrDialog(Object c, int parentLevel) {
        if (c instanceof Component) {
            Component cc = (Component)c;
            if (cc instanceof Frame) {
                return (Frame)cc;
            }
            if (cc instanceof Dialog) {
                return (Dialog)cc;
            }
            while ((cc = cc.getParent()) != null) {
                if (cc instanceof Frame) {
                    return (Frame)cc;
                }
                if (!(cc instanceof Dialog)) continue;
                return (Dialog)cc;
            }
        }
        Frame parent = CommonUtils.getConsoleFrame();
        return parent;
    }

    public static void adjustColumnWidth(SpreadTable spreadtable) {
        Grid myGrid = spreadtable.getGrid();
        int myRowCount = myGrid.getRowCount();
        int myColumnCount = myGrid.getColumnCount();
        for (int myColumn = 0; myColumn < myColumnCount; ++myColumn) {
            int width = spreadtable.getColumnWidth(myColumn);
            Painter painter = spreadtable.getGrid().getColumnPainter(myColumn);
            for (int i = 0; i < myRowCount; ++i) {
                PaintContext context = myGrid.getCellPaintContext(myColumn, i);
                Dimension prefSize = painter.getPreferredSize(context);
                if (prefSize.width <= width) continue;
                width = prefSize.width;
            }
            spreadtable.setColumnWidth(myColumn, width);
        }
    }

    public static boolean wildcardSearch(String tosearch, String pattern, String wildcard) {
        if (wildcard == null) {
            wildcard = CommonUtils.getCommonLang("defaultWildCard");
        }
        if (pattern.indexOf(wildcard) == -1) {
            return tosearch.equals(pattern);
        }
        StringTokenizer tokenizer = new StringTokenizer(pattern, wildcard);
        String oneToken = null;
        int index = 0;
        int tokenCount = tokenizer.countTokens();
        for (int count = 0; count < tokenCount; ++count) {
            oneToken = tokenizer.nextToken();
            index = tosearch.indexOf(oneToken, index);
            if (index == -1) {
                return false;
            }
            if (count == 0 && index >= 1 && !pattern.startsWith(wildcard)) {
                return false;
            }
            index += oneToken.length();
        }
        return index >= tosearch.length() || pattern.endsWith(wildcard);
    }

    public static Font getDefaultFont() {
        return CommonUtils.getDefaultFont(1, 1);
    }

    public static Font getDefaultFont(int style, int size) {
        if (size < 12) {
            throw new IllegalArgumentException(CommonUtils.getCommonLang("CU_smallFont_API33"));
        }
        Font prefered = CommonUtils.getDefaultFont();
        return new Font(prefered.getName(), style, size);
    }

    public static Font getDefaultFont(int style) {
        Font prefered = CommonUtils.getDefaultFont();
        return new Font(prefered.getName(), style, prefered.getSize());
    }

    public static Font getMonoFont() {
        Font prefered = CommonUtils.getDefaultFont();
        return new Font(MONOFONT, prefered.getStyle(), prefered.getSize());
    }

    public static Font getMonoFont(int style, int size) {
        if (size < 12) {
            throw new IllegalArgumentException(CommonUtils.getCommonLang("CU_smallFont_API33"));
        }
        return new Font(MONOFONT, style, size);
    }

    private static void myDebug(String a) {
        CommonUtils.debug(CommonUtils.class, a);
    }

    private static void myDebug(Exception a) {
        CommonUtils.debug(CommonUtils.class, a);
    }

    private static void myDebug(String str, Exception exc) {
        CommonUtils.debug(CommonUtils.class, str, exc);
    }

    private static String translateMuMsg(String key, Object[] args) {
        return NLSUtils.getNLSString(key, args);
    }

    private static String translateMuMsg(String key) {
        return NLSUtils.getNLSString(key);
    }

    private static String translateFolderMsg(String key, Object[] args) {
        return NLSUtils.getNLSString(key, args);
    }

    private static String translateFolderMsg(String key) {
        return NLSUtils.getNLSString(key);
    }

    public static String shortenLongPath(String longName) {
        String separator = File.separator;
        String displayPath = longName;
        if (longName != null) {
            StringTokenizer st = new StringTokenizer(longName, separator);
            int levels = st.countTokens();
            int count = 0;
            String dir = "";
            if (levels > 5) {
                displayPath = "";
                while (st.hasMoreTokens()) {
                    dir = st.nextToken();
                    if (++count != 3 && count != 4 && count != 5) {
                        displayPath = displayPath + dir + separator;
                        continue;
                    }
                    if (count != 3) continue;
                    displayPath = displayPath + "..." + separator;
                }
            }
        }
        if (displayPath.length() > 1) {
            int lastSlash = displayPath.lastIndexOf(separator);
            if (++lastSlash == displayPath.length()) {
                displayPath = displayPath.substring(0, displayPath.length() - 1);
            }
        }
        return displayPath;
    }

    public static ItemListener[] removeComboItemListener(JComboBox combo) {
        ItemListener[] ils = combo.getItemListeners();
        for (int i = 0; i < ils.length; ++i) {
            combo.removeItemListener(ils[i]);
        }
        return ils;
    }

    public static void addComboItemListener(JComboBox combo, ItemListener[] ils) {
        for (int i = 0; i < ils.length; ++i) {
            combo.addItemListener(ils[i]);
        }
    }

    public static ActionListener[] removeComboActionListener(JComboBox combo) {
        ActionListener[] ils = combo.getActionListeners();
        for (int i = 0; i < ils.length; ++i) {
            combo.removeActionListener(ils[i]);
        }
        return ils;
    }

    public static void addComboActionListener(JComboBox combo, ActionListener[] ils) {
        for (int i = 0; i < ils.length; ++i) {
            combo.addActionListener(ils[i]);
        }
    }

    public static ItemListener[] removeCheckboxItemListener(JCheckBox combo) {
        ItemListener[] ils = combo.getItemListeners();
        for (int i = 0; i < ils.length; ++i) {
            combo.removeItemListener(ils[i]);
        }
        return ils;
    }

    public static void addCheckboxItemListener(JCheckBox combo, ItemListener[] ils) {
        for (int i = 0; i < ils.length; ++i) {
            combo.addItemListener(ils[i]);
        }
    }

    public static String getNewEncoding(String nxsdAsString) {
        String encoding = "UTF-8";
        if (nxsdAsString != null) {
            int equalIndex;
            String prolog;
            int encodingIndex;
            int startIndex = nxsdAsString.indexOf("<?xml");
            int endIndex = nxsdAsString.indexOf("?>");
            String str = "";
            if (startIndex != -1 && endIndex != -1 && (encodingIndex = (prolog = nxsdAsString.substring(startIndex, endIndex)).indexOf("encoding")) != -1 && (equalIndex = prolog.indexOf(61, encodingIndex)) != -1) {
                int endQuote;
                str = prolog.substring(equalIndex);
                int startQuote = str.indexOf("\"");
                if (startQuote == -1) {
                    startQuote = str.indexOf("'");
                }
                if ((endQuote = str.indexOf("\"", startQuote + 1)) == -1) {
                    endQuote = str.indexOf("'", startQuote + 1);
                }
                if (startQuote != -1 && endQuote != -1 && endIndex > startQuote) {
                    encoding = str.substring(startQuote + 1, endQuote);
                    return encoding;
                }
            }
        }
        return encoding;
    }

    public static String fixProlog(String nxsdAsString, String encoding) {
        if (nxsdAsString != null) {
            int startIndex = nxsdAsString.indexOf("<?xml");
            int endIndex = nxsdAsString.indexOf("?>");
            String temp = "";
            if (startIndex != -1 && endIndex != -1 && endIndex + 2 < nxsdAsString.length()) {
                nxsdAsString = nxsdAsString.substring(endIndex + 3);
            }
        }
        String standardProlog = "<?xml version=\"1.0\" encoding=\"" + encoding + "\" ?>\n";
        nxsdAsString = standardProlog + nxsdAsString;
        return nxsdAsString;
    }
}

