/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.SortableTwoDModel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.help.HelpSystem;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.CommonUtils;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.RecTypeAttributes;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WBTranslatable;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WBTranslatableDialog;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.NLSUtils;

public class ChoicePropertiesDialog
extends WBTranslatableDialog
implements ActionListener {
    public static final int OK = 0;
    public static final int CANCEL = 2;
    private static final String ADHOC = "A";
    private static final String FIXED = "F";
    private static final String DELIMITED = "D";
    private static final String VARIABLE = "V";
    private MultiLineLabel introLabel;
    private JRadioButton jFixedOption = new JRadioButton();
    private JLabel jLengthLabel = new JLabel();
    private JSpinner jLengthSpinner = new JSpinner();
    private JRadioButton jDelimOption = new JRadioButton();
    private JRadioButton jVarOption = new JRadioButton();
    private JRadioButton jAdhocOption = new JRadioButton();
    private ButtonGroup optGroup;
    private JLabel jVarNameLabel = new JLabel();
    private JTextField jVarName = new JTextField();
    private JLabel jLookAheadLabel = new JLabel();
    private JSpinner jLookAheadSpinner = new JSpinner();
    private JLabel jScanLengthLabel = new JLabel();
    private JSpinner jScanLengthSpinner = new JSpinner();
    private JLabel jAssignToLabel = new JLabel();
    private JTextField jAssignTo = new JTextField();
    private JLabel jDelimByLabel = new JLabel();
    private JComboBox jDelimByCombo = new JComboBox();
    private JLabel jMinOccursLabel = new JLabel();
    private JComboBox jMinOccursCombo = new JComboBox();
    private JLabel jMaxOccursLabel = new JLabel();
    private JComboBox jMaxOccursCombo = new JComboBox();
    private JPanel mainPanel;
    private static String[] _delimiterList = new String[]{"FI_generalColDelimiterSpace_FlatFile", "FI_generalColDelimiterComma_FlatFile", "FI_generalColDelimiterSemicolon_FlatFile", "FI_generalColDelimiterWhiteSpace_FlatFile", "FI_generalColDelimiterTab_FlatFile"};
    protected int m_retVal = 2;
    protected boolean m_editMode = false;
    protected WBTranslatable _translatable;
    protected FlatFileInfo _ffInfo;
    protected String _record = "choice";
    protected ArrayTwoDModel _fieldProps;
    protected RecTypeAttributes _recAttr;
    protected int _fieldRow;
    private String _choiceType;

    public ChoicePropertiesDialog(JFrame f, WBTranslatable h) {
        super(f, h, h.translate("CX_ChoiceDlg_Title"), true);
        this._translatable = h;
        this.createControls();
        this.layoutControls();
    }

    public void enableUserInput(final boolean bEnable) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Component glass = ChoicePropertiesDialog.this.getGlassPane();
                glass.setVisible(!bEnable);
                if (bEnable) {
                    glass.setCursor(Cursor.getDefaultCursor());
                } else {
                    glass.setCursor(Cursor.getPredefinedCursor(3));
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public int getReturnValue() {
        return this.m_retVal;
    }

    protected void createControls() {
        String introTxt = this._translatable.translate("CX_ChoiceDlg_IntroText");
        this.introLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), introTxt);
        this.jAdhocOption.setText(this._translatable.translate("CX_ChoiceDlg_AdhocOption"));
        CommonUtils.setMnemonicAndAccelerator(this.jAdhocOption, NLSUtils.getNLSString("CX_ChoiceDlg_AdhocOption"));
        this.jAdhocOption.setToolTipText(this._translatable.translate("CX_ChoiceDlg_AdhocOption"));
        this.jFixedOption.setText(this._translatable.translate("CX_ChoiceDlg_FixedOption"));
        CommonUtils.setMnemonicAndAccelerator(this.jFixedOption, NLSUtils.getNLSString("CX_ChoiceDlg_FixedOption"));
        this.jFixedOption.setToolTipText(this._translatable.translate("CX_ChoiceDlg_FixedOption"));
        this.jDelimOption.setText(this._translatable.translate("CX_ChoiceDlg_DelimOption"));
        CommonUtils.setMnemonicAndAccelerator(this.jDelimOption, NLSUtils.getNLSString("CX_ChoiceDlg_DelimOption"));
        this.jDelimOption.setToolTipText(this._translatable.translate("CX_ChoiceDlg_DelimOption"));
        this.jVarOption.setText(this._translatable.translate("CX_ChoiceDlg_VarOption"));
        CommonUtils.setMnemonicAndAccelerator(this.jVarOption, NLSUtils.getNLSString("CX_ChoiceDlg_VarOption"));
        this.jVarOption.setToolTipText(this._translatable.translate("CX_ChoiceDlg_VarOption"));
        this.optGroup = new ButtonGroup();
        this.optGroup.add(this.jAdhocOption);
        this.optGroup.add(this.jFixedOption);
        this.optGroup.add(this.jDelimOption);
        this.optGroup.add(this.jVarOption);
        this.jAdhocOption.setSelected(true);
        this._choiceType = ADHOC;
        this.jAdhocOption.addActionListener(this);
        this.jFixedOption.addActionListener(this);
        this.jDelimOption.addActionListener(this);
        this.jVarOption.addActionListener(this);
        this.jLengthLabel.setText(this._translatable.translate("CX_ChoiceDlg_Length"));
        this.jLengthLabel.setLabelFor(this.jLengthSpinner);
        CommonUtils.setMnemonicAndAccelerator(this.jLengthLabel, NLSUtils.getNLSString("CX_ChoiceDlg_Length"));
        this.jLengthSpinner.setToolTipText(this._translatable.translate("CX_ChoiceDlg_Length"));
        this.jDelimByLabel.setText(this._translatable.translate("CX_FieldLabel_DelimBy"));
        this.jDelimByLabel.setLabelFor(this.jDelimByCombo);
        CommonUtils.setMnemonicAndAccelerator(this.jDelimByLabel, NLSUtils.getNLSString("CX_FieldLabel_DelimBy"));
        this.jDelimByCombo.setToolTipText(this._translatable.translate("CX_FieldLabel_DelimBy"));
        this.jVarNameLabel.setText(this._translatable.translate("CX_FieldLabel_VarName"));
        this.jVarNameLabel.setLabelFor(this.jVarName);
        CommonUtils.setMnemonicAndAccelerator(this.jVarNameLabel, NLSUtils.getNLSString("CX_FieldLabel_VarName"));
        this.jVarName.setToolTipText(this._translatable.translate("CX_FieldLabel_VarName"));
        this.jLookAheadLabel.setText(this._translatable.translate("CX_FieldLabel_LookAhead"));
        this.jLookAheadLabel.setLabelFor(this.jLookAheadSpinner);
        CommonUtils.setMnemonicAndAccelerator(this.jLookAheadLabel, NLSUtils.getNLSString("CX_FieldLabel_LookAhead"));
        this.jLookAheadSpinner.setToolTipText(this._translatable.translate("CX_FieldLabel_LookAhead"));
        this.jScanLengthLabel.setText(this._translatable.translate("CX_FieldLabel_ScanLength"));
        this.jScanLengthLabel.setLabelFor(this.jScanLengthSpinner);
        CommonUtils.setMnemonicAndAccelerator(this.jScanLengthLabel, NLSUtils.getNLSString("CX_FieldLabel_ScanLength"));
        this.jScanLengthSpinner.setToolTipText(this._translatable.translate("CX_FieldLabel_ScanLength"));
        this.jAssignToLabel.setText(this._translatable.translate("CX_FieldLabel_AssignTo"));
        this.jAssignToLabel.setLabelFor(this.jAssignTo);
        CommonUtils.setMnemonicAndAccelerator(this.jAssignToLabel, NLSUtils.getNLSString("CX_FieldLabel_AssignTo"));
        this.jAssignTo.setToolTipText(this._translatable.translate("CX_FieldLabel_AssignTo"));
        this.jMinOccursLabel.setText(this._translatable.translate("CX_FieldLabel_MinOccurs"));
        this.jMinOccursLabel.setLabelFor(this.jMinOccursCombo);
        this.jMinOccursCombo.addItem("0");
        this.jMinOccursCombo.addItem("1");
        this.jMinOccursCombo.setSelectedItem("1");
        CommonUtils.setMnemonicAndAccelerator(this.jMinOccursLabel, NLSUtils.getNLSString("CX_FieldLabel_MinOccurs"));
        this.jMinOccursCombo.setToolTipText(this._translatable.translate("CX_FieldLabel_MinOccurs"));
        this.jMaxOccursLabel.setText(this._translatable.translate("CX_FieldLabel_MaxOccurs"));
        this.jMaxOccursLabel.setLabelFor(this.jMaxOccursCombo);
        this.jMaxOccursCombo.addItem("1");
        this.jMaxOccursCombo.addItem("UNBOUNDED");
        this.jMaxOccursCombo.setSelectedItem("1");
        this.jMaxOccursCombo.setEditable(true);
        CommonUtils.setMnemonicAndAccelerator(this.jMaxOccursLabel, NLSUtils.getNLSString("CX_FieldLabel_MaxOccurs"));
        this.jMaxOccursCombo.setToolTipText(this._translatable.translate("CX_FieldLabel_MaxOccurs"));
        this.initFieldAttributes();
        for (int i = 0; i < _delimiterList.length; ++i) {
            this.jDelimByCombo.addItem(this.translate(_delimiterList[i]));
        }
        this.jDelimByCombo.setEditable(true);
    }

    protected void layoutControls() {
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        this.mainPanel = new JPanel(new GridBagLayout());
        this.mainPanel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.setContent(this.mainPanel);
        JPanel optionPanel = new JPanel(new GridBagLayout());
        optionPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.GRAY), this.translate("CX_FieldLabel_ChoiceType")));
        JPanel minMaxOccursPanel = new JPanel(new GridBagLayout());
        UIHelper.addComponent((Container)optionPanel, (Component)this.jAdhocOption, (int)0, (int)0, (int)1, (int)1, (int)18, (int)0, (Insets)new Insets(5, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)optionPanel, (Component)this.jFixedOption, (int)0, (int)1, (int)1, (int)1, (int)18, (int)0, (Insets)new Insets(10, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)optionPanel, (Component)this.jLengthLabel, (int)0, (int)1, (int)1, (int)1, (int)18, (int)0, (Insets)new Insets(10, 120, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)optionPanel, (Component)this.jLengthSpinner, (int)0, (int)1, (int)1, (int)1, (int)18, (int)0, (Insets)new Insets(10, 170, 0, 0), (int)10, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)optionPanel, (Component)this.jDelimOption, (int)0, (int)2, (int)1, (int)1, (int)18, (int)0, (Insets)new Insets(10, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)optionPanel, (Component)this.jDelimByLabel, (int)0, (int)2, (int)1, (int)1, (int)18, (int)0, (Insets)new Insets(10, 100, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)optionPanel, (Component)this.jDelimByCombo, (int)0, (int)2, (int)1, (int)1, (int)18, (int)0, (Insets)new Insets(10, 170, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)optionPanel, (Component)this.jVarOption, (int)0, (int)3, (int)1, (int)1, (int)18, (int)0, (Insets)new Insets(10, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        JPanel varAttrPanel = new JPanel(new GridBagLayout());
        UIHelper.addComponent((Container)varAttrPanel, (Component)this.jVarNameLabel, (int)0, (int)0, (int)1, (int)1, (int)18, (int)0, (Insets)new Insets(5, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)varAttrPanel, (Component)this.jVarName, (int)1, (int)0, (int)1, (int)1, (int)18, (int)0, (Insets)new Insets(5, 5, 0, 0), (int)30, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)varAttrPanel, (Component)this.jLookAheadLabel, (int)2, (int)0, (int)1, (int)1, (int)18, (int)0, (Insets)new Insets(5, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)varAttrPanel, (Component)this.jLookAheadSpinner, (int)3, (int)0, (int)1, (int)1, (int)18, (int)0, (Insets)new Insets(5, 5, 0, 0), (int)10, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)varAttrPanel, (Component)this.jScanLengthLabel, (int)4, (int)0, (int)1, (int)1, (int)18, (int)0, (Insets)new Insets(5, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)varAttrPanel, (Component)this.jScanLengthSpinner, (int)5, (int)0, (int)1, (int)1, (int)18, (int)0, (Insets)new Insets(5, 5, 0, 0), (int)10, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)varAttrPanel, (Component)this.jAssignToLabel, (int)6, (int)0, (int)1, (int)1, (int)18, (int)0, (Insets)new Insets(5, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)varAttrPanel, (Component)this.jAssignTo, (int)7, (int)0, (int)1, (int)1, (int)18, (int)0, (Insets)new Insets(5, 5, 0, 0), (int)40, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)optionPanel, (Component)varAttrPanel, (int)0, (int)4, (int)1, (int)1, (int)18, (int)0, (Insets)new Insets(0, 20, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)minMaxOccursPanel, (Component)this.jMinOccursLabel, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)minMaxOccursPanel, (Component)this.jMinOccursCombo, (int)1, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 3, 0, 0), (int)20, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)minMaxOccursPanel, (Component)this.jMaxOccursLabel, (int)2, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)minMaxOccursPanel, (Component)this.jMaxOccursCombo, (int)3, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(5, 3, 0, 0), (int)20, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)this.mainPanel, (Component)this.introLabel, (int)0, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(5, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)this.mainPanel, (Component)optionPanel, (int)0, (int)1, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(15, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)this.mainPanel, (Component)minMaxOccursPanel, (int)0, (int)2, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(15, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        this.setSize(500, 370);
        UIHelper.centerInScreen((Component)((Object)this));
    }

    public void handleOK() {
        this.m_retVal = 0;
        if (!this.validateAttributes()) {
            return;
        }
        if (!this.m_editMode) {
            Vector<String> unique_values = new Vector<String>();
            unique_values.add(this._record);
            Object[] value_list = new String[1];
            unique_values.copyInto(value_list);
            this.setClassifierValues((String[])value_list);
        } else {
            this.updateInfoRecordAttributes(this._record);
            this.m_editMode = false;
        }
        this.dispose();
    }

    private void setClassifierValues(String[] classifierValues) {
        SortableTwoDModel _valueGridDs = new SortableTwoDModel(4, 0);
        _valueGridDs.addRows(0, classifierValues.length);
        String[] record_names = new String[classifierValues.length];
        for (int i = 0; i < classifierValues.length; ++i) {
            _valueGridDs.setData(1, i, (Object)classifierValues[i]);
            record_names[i] = this._record;
            _valueGridDs.setData(2, i, (Object)record_names[i]);
            RecTypeAttributes recAttr = this.getChoiceAttributes();
            recAttr.setRecType(99);
            _valueGridDs.setData(3, i, (Object)recAttr);
        }
        this._ffInfo.removeFromRecordClassifierDs(this._record);
        this._ffInfo.addIntoRecordClassifierDs(_valueGridDs);
        this.addRecordToHash();
    }

    private void updateInfoRecordAttributes(String recname) {
        SortableTwoDModel recModel = this._ffInfo.getRecordClassifierDs();
        for (int i = 0; i < recModel.getRowCount(); ++i) {
            if (!((String)recModel.getData(2, i)).equals(recname)) continue;
            RecTypeAttributes attr = this.getChoiceAttributes();
            recModel.setData(3, i, (Object)attr);
            break;
        }
    }

    private void addRecordToHash() {
        SortableTwoDModel recClassifiers = this._ffInfo.getRecordClassifierDs();
        if (recClassifiers != null) {
            String aRecord = "";
            for (int i = 0; i < recClassifiers.getRowCount(); ++i) {
                aRecord = (String)recClassifiers.getData(2, i);
                if (aRecord == null || aRecord.trim().equals("")) continue;
                this._ffInfo.getFieldPropertiesDs(aRecord);
            }
        }
    }

    public String getDelimiterAsString(String comboTxt) {
        String newDelim = comboTxt;
        if (newDelim.equals(this.translate("DA_delimitedColDelimiterWhiteSpace_FlatFile"))) {
            newDelim = "  ";
        } else if (newDelim.equals(this.translate("DA_delimitedColDelimiterComma_FlatFile"))) {
            newDelim = ",";
        } else if (newDelim.equals(this.translate("DA_delimitedColDelimiterSemicolon_FlatFile"))) {
            newDelim = ";";
        } else if (newDelim.equals(this.translate("DA_delimitedColDelimiterTab_FlatFile"))) {
            newDelim = "\\t";
        } else if (newDelim.equals(this.translate("DA_delimitedColDelimiterSpace_FlatFile"))) {
            newDelim = " ";
        }
        return newDelim;
    }

    private String getDelimiterAsComboItem(String delimiter) {
        String newDelim = delimiter;
        if (newDelim.equals("  ")) {
            newDelim = this.translate("DA_delimitedColDelimiterWhiteSpace_FlatFile");
        } else if (newDelim.equals(",")) {
            newDelim = this.translate("DA_delimitedColDelimiterComma_FlatFile");
        } else if (newDelim.equals(";")) {
            newDelim = this.translate("DA_delimitedColDelimiterSemicolon_FlatFile");
        } else if (newDelim.equals("\\t")) {
            newDelim = this.translate("DA_delimitedColDelimiterTab_FlatFile");
        } else if (newDelim.equals(" ")) {
            newDelim = this.translate("DA_delimitedColDelimiterSpace_FlatFile");
        } else if (newDelim == "") {
            newDelim = this.translate("CX_Mixed");
        }
        return newDelim;
    }

    public void handleCancel() {
        this.m_retVal = 2;
        if (!this.m_editMode) {
            this.m_editMode = false;
        }
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.jFixedOption) {
            this.handleChoiceTypeSelection(FIXED);
        } else if (src == this.jDelimOption) {
            this.handleChoiceTypeSelection(DELIMITED);
        } else if (src == this.jVarOption) {
            this.handleChoiceTypeSelection(VARIABLE);
        } else if (src == this.jAdhocOption) {
            this.handleChoiceTypeSelection(ADHOC);
        }
    }

    protected void dismissDialog(boolean cancelled) {
        if (!cancelled) {
            this.handleOK();
        } else {
            this.handleCancel();
        }
    }

    public void cancelOccurred(JDialog dlg) {
        this.handleCancel();
    }

    public int display(FlatFileInfo info, boolean bEditMode) {
        this._ffInfo = info;
        this.m_editMode = bEditMode;
        if (!this._ffInfo.isStandaloneTesting()) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this.mainPanel, "bpmjdev_adp_wiz_nfb_choice_optn_type");
        }
        if (this.m_editMode) {
            this.setChoiceAttributes(this._ffInfo.getRecordAttributes(this._record));
        }
        this.setVisible(true);
        return this.m_retVal;
    }

    private void initFieldAttributes() {
        this.jLengthSpinner.setEnabled(false);
        this.jDelimByCombo.setEnabled(false);
        this.jVarName.setEnabled(false);
        this.jLookAheadSpinner.setEnabled(false);
        this.jScanLengthSpinner.setEnabled(false);
        this.jAssignTo.setEnabled(false);
    }

    private void handleChoiceTypeSelection(String choiceType) {
        this._choiceType = choiceType;
        if (choiceType.equals(FIXED)) {
            this.jLengthSpinner.setEnabled(true);
            this.jDelimByCombo.setEnabled(false);
            this.jVarName.setEnabled(false);
            this.jLookAheadSpinner.setEnabled(false);
            this.jScanLengthSpinner.setEnabled(false);
            this.jAssignTo.setEnabled(false);
        } else if (choiceType.equals(DELIMITED)) {
            this.jLengthSpinner.setEnabled(false);
            this.jDelimByCombo.setEnabled(true);
            this.jVarName.setEnabled(false);
            this.jLookAheadSpinner.setEnabled(false);
            this.jScanLengthSpinner.setEnabled(false);
            this.jAssignTo.setEnabled(false);
        } else if (choiceType.equals(VARIABLE)) {
            this.jLengthSpinner.setEnabled(false);
            this.jDelimByCombo.setEnabled(false);
            this.jVarName.setEnabled(true);
            this.jLookAheadSpinner.setEnabled(true);
            this.jScanLengthSpinner.setEnabled(true);
            this.jAssignTo.setEnabled(true);
        } else {
            this.jLengthSpinner.setEnabled(false);
            this.jDelimByCombo.setEnabled(false);
            this.jVarName.setEnabled(false);
            this.jLookAheadSpinner.setEnabled(false);
            this.jScanLengthSpinner.setEnabled(false);
            this.jAssignTo.setEnabled(false);
        }
    }

    public RecTypeAttributes getChoiceAttributes() {
        RecTypeAttributes recAttr = new RecTypeAttributes();
        recAttr.setRecordName(this._record);
        recAttr.setChoiceType(this._choiceType);
        if (this._choiceType.equals(DELIMITED)) {
            recAttr.setStylePattern1(this.getDelimiterAsString((String)this.jDelimByCombo.getSelectedItem()));
        } else if (this._choiceType.equals(FIXED)) {
            recAttr.setLength((Integer)this.jLengthSpinner.getValue());
        } else if (this._choiceType.equals(VARIABLE)) {
            recAttr.setVarName(this.jVarName.getText());
            recAttr.setLookAhead(((Integer)this.jLookAheadSpinner.getValue()).toString());
            recAttr.setScanLength(((Integer)this.jScanLengthSpinner.getValue()).toString());
            recAttr.setAssignTo(this.jAssignTo.getText());
        }
        recAttr.setMinOccurs(Integer.parseInt((String)this.jMinOccursCombo.getSelectedItem()));
        recAttr.setOccurs(this.getMaxOccurs());
        return recAttr;
    }

    public void setChoiceAttributes(RecTypeAttributes recAttr) {
        if (recAttr.getChoiceType().equals(ADHOC)) {
            this.jAdhocOption.setSelected(true);
        } else if (recAttr.getChoiceType().equals(FIXED)) {
            this.jFixedOption.setSelected(true);
            this.jLengthSpinner.setValue(recAttr.getLength());
        } else if (recAttr.getChoiceType().equals(DELIMITED)) {
            this.jDelimOption.setSelected(true);
            this.jDelimByCombo.setSelectedItem(this.getDelimiterAsComboItem(recAttr.getStylePattern1()));
        } else if (recAttr.getChoiceType().equals(VARIABLE)) {
            this.jVarOption.setSelected(true);
            this.jVarName.setText(recAttr.getVarName());
            this.jLookAheadSpinner.setValue(Integer.parseInt(recAttr.getLookAhead()));
            this.jScanLengthSpinner.setValue(Integer.parseInt(recAttr.getScanLength()));
            this.jAssignTo.setText(recAttr.getAssignTo());
        }
        String minOccurs = String.valueOf(recAttr.getMinOccurs());
        String maxOccurs = "";
        maxOccurs = recAttr.getOccurs() == 0x7FFFFFF8 ? "UNBOUNDED" : String.valueOf(recAttr.getOccurs());
        this.jMinOccursCombo.setSelectedItem(minOccurs);
        this.jMaxOccursCombo.setSelectedItem(maxOccurs);
        this.handleChoiceTypeSelection(recAttr.getChoiceType());
    }

    private boolean validateAttributes() {
        if (this.jFixedOption.isSelected()) {
            if (((Integer)this.jLengthSpinner.getValue()).equals(0)) {
                CommonUtils.error((Object)this, this._translatable.translate("CX_ChoiceDlgFixedValidation"));
                return false;
            }
        } else if (this.jDelimOption.isSelected()) {
            if (((String)this.jDelimByCombo.getSelectedItem()).equals("")) {
                CommonUtils.error((Object)this, this._translatable.translate("CX_ChoiceDlgDelimValidation"));
                return false;
            }
        } else if (this.jVarOption.isSelected() && this.jVarName.getText().equals("")) {
            CommonUtils.error((Object)this, this._translatable.translate("CX_ChoiceDlgVarValidation"));
            return false;
        }
        return true;
    }

    public int getMaxOccurs() {
        if (((String)this.jMaxOccursCombo.getSelectedItem()).equals("1")) {
            return 1;
        }
        if (((String)this.jMaxOccursCombo.getSelectedItem()).equals("UNBOUNDED")) {
            return 0x7FFFFFF8;
        }
        return new Integer((String)this.jMaxOccursCombo.getSelectedItem());
    }
}

