/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd;

import java.awt.AlphaComposite;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.tip.tools.ide.common.ui.treeexplorer.TransferableNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.RecTypeDataSourceObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.RecTypeExplorerTreeNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.RecTypeStringTransferHandler;

public abstract class AbstractTreeTransferHandler
implements DragGestureListener,
DragSourceListener,
DropTargetListener {
    private JTree tree;
    private DragSource dragSource;
    private DropTarget dropTarget;
    private static DefaultMutableTreeNode draggedNode;
    private DefaultMutableTreeNode draggedNodeParent;
    private static BufferedImage image;
    private Rectangle rect2D = new Rectangle();
    private boolean drawImage;
    private TransferHandler thandler;
    Insets autoscrollInsets = new Insets(20, 20, 20, 20);

    protected AbstractTreeTransferHandler(JTree tree, int action, boolean drawIcon) {
        this.tree = tree;
        this.drawImage = drawIcon;
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(tree, action, this);
        this.dropTarget = new DropTarget(tree, action, this);
    }

    protected AbstractTreeTransferHandler(JTree tr, RecTypeStringTransferHandler th, int action, boolean drawIcon) {
        this.tree = tr;
        this.thandler = th;
        this.drawImage = drawIcon;
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this.tree, action, this);
        this.dropTarget = new DropTarget(this.tree, action, this);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        if (dsde.getDropSuccess() && dsde.getDropAction() == 2 && this.draggedNodeParent != null) {
            ((DefaultTreeModel)this.tree.getModel()).nodeStructureChanged(this.draggedNodeParent);
        }
    }

    @Override
    public final void dragEnter(DragSourceDragEvent dsde) {
        int action = dsde.getDropAction();
        if (action == 1) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
        } else if (action == 2) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        } else {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    @Override
    public final void dragOver(DragSourceDragEvent dsde) {
        int action = dsde.getDropAction();
        if (action == 1) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
        } else if (action == 2) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        } else {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    @Override
    public final void dropActionChanged(DragSourceDragEvent dsde) {
        int action = dsde.getDropAction();
        if (action == 1) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
        } else if (action == 2) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        } else {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    @Override
    public final void dragExit(DragSourceEvent dse) {
        dse.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
    }

    @Override
    public final void dragGestureRecognized(DragGestureEvent dge) {
        Cursor cursor = null;
        TreePath path = this.tree.getSelectionPath();
        if (path != null) {
            draggedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            RecTypeDataSourceObject draggedNodeData = (RecTypeDataSourceObject)((RecTypeExplorerTreeNode)((Object)draggedNode)).getNodeData();
            if (draggedNodeData.getRecType() == 0 || draggedNodeData.getRecType() == 1 || draggedNodeData.getRecType() == 99) {
                draggedNode = null;
                return;
            }
            if (this.drawImage) {
                Rectangle pathBounds = this.tree.getPathBounds(path);
                JComponent lbl = (JComponent)this.tree.getCellRenderer().getTreeCellRendererComponent(this.tree, draggedNode, false, this.tree.isExpanded(path), ((DefaultTreeModel)this.tree.getModel()).isLeaf(path.getLastPathComponent()), 0, false);
                lbl.setBounds(pathBounds);
                image = new BufferedImage(lbl.getWidth(), lbl.getHeight(), 3);
                Graphics2D graphics = image.createGraphics();
                graphics.setComposite(AlphaComposite.getInstance(3, 0.5f));
                lbl.setOpaque(false);
                lbl.paint(graphics);
                graphics.dispose();
                cursor = this.selectCursor(dge.getDragAction());
            }
            this.dragSource.startDrag(dge, cursor, (Transferable)new TransferableNode(draggedNode), this);
        }
    }

    @Override
    public final void dragEnter(DropTargetDragEvent dtde) {
        Point pt = dtde.getLocation();
        int action = dtde.getDropAction();
        if (this.drawImage) {
            if (image == null) {
                this.setSelectedNodeImage(dtde);
            }
            this.paintImage(pt);
        }
        if (this.canPerformAction(this.tree, draggedNode, action, pt)) {
            dtde.acceptDrag(action);
        } else {
            dtde.rejectDrag();
            draggedNode = null;
        }
    }

    @Override
    public final void dragExit(DropTargetEvent dte) {
        if (this.drawImage) {
            this.clearImage();
        }
    }

    @Override
    public final void dragOver(DropTargetDragEvent dtde) {
        Point pt = dtde.getLocation();
        int action = dtde.getDropAction();
        this.autoscroll(pt);
        if (this.drawImage) {
            if (image == null) {
                this.setSelectedNodeImage(dtde);
            }
            this.paintImage(pt);
        }
        if (this.canPerformAction(this.tree, draggedNode, action, pt)) {
            dtde.acceptDrag(action);
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public final void dropActionChanged(DropTargetDragEvent dtde) {
        Point pt = dtde.getLocation();
        int action = dtde.getDropAction();
        if (this.drawImage) {
            if (image == null) {
                this.setSelectedNodeImage(dtde);
            }
            this.paintImage(pt);
        }
        if (this.canPerformAction(this.tree, draggedNode, action, pt)) {
            dtde.acceptDrag(action);
        } else {
            dtde.rejectDrag();
            draggedNode = null;
        }
    }

    @Override
    public final void drop(DropTargetDropEvent dtde) {
        try {
            if (this.drawImage) {
                this.clearImage();
            }
            int action = dtde.getDropAction();
            Transferable transferable = dtde.getTransferable();
            TreePath pathTarget = null;
            Point pt = dtde.getLocation();
            pathTarget = this.tree.getPathForLocation(pt.x, pt.y);
            if (transferable.isDataFlavorSupported(TransferableNode.NODE_FLAVOR) && this.canPerformAction(this.tree, draggedNode, action, pt)) {
                DefaultMutableTreeNode newParentNode;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)transferable.getTransferData(TransferableNode.NODE_FLAVOR);
                if (this.executeDrop(this.tree, node, newParentNode = (DefaultMutableTreeNode)pathTarget.getLastPathComponent(), action)) {
                    dtde.acceptDrop(action);
                    dtde.dropComplete(true);
                    draggedNode = null;
                    return;
                }
            } else {
                if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    ((RecTypeStringTransferHandler)this.thandler).importData(this.tree, transferable, pathTarget);
                    dtde.acceptDrop(action);
                    dtde.dropComplete(true);
                    return;
                }
                dtde.rejectDrop();
                dtde.dropComplete(false);
                draggedNode = null;
            }
        }
        catch (Exception e) {
            System.out.println(e);
            dtde.rejectDrop();
            dtde.dropComplete(false);
            draggedNode = null;
        }
    }

    private final void paintImage(Point pt) {
        this.tree.paintImmediately(this.rect2D.getBounds());
        this.rect2D.setRect((int)pt.getX(), (int)pt.getY(), image.getWidth(), image.getHeight());
        this.tree.getGraphics().drawImage(image, (int)pt.getX(), (int)pt.getY(), this.tree);
    }

    private final void clearImage() {
        this.tree.paintImmediately(this.rect2D.getBounds());
    }

    private Cursor selectCursor(int action) {
        return action == 2 ? DragSource.DefaultMoveDrop : DragSource.DefaultCopyDrop;
    }

    public abstract boolean canPerformAction(JTree var1, DefaultMutableTreeNode var2, int var3, Point var4);

    public abstract boolean executeDrop(JTree var1, DefaultMutableTreeNode var2, DefaultMutableTreeNode var3, int var4);

    private void setSelectedNodeImage(DropTargetDragEvent dtde) {
        Cursor cursor = null;
        TreePath path = this.tree.getSelectionPath();
        if (path != null) {
            DefaultMutableTreeNode droppedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (this.drawImage) {
                Rectangle pathBounds = this.tree.getPathBounds(path);
                JComponent lbl = (JComponent)this.tree.getCellRenderer().getTreeCellRendererComponent(this.tree, droppedNode, false, this.tree.isExpanded(path), ((DefaultTreeModel)this.tree.getModel()).isLeaf(path.getLastPathComponent()), 0, false);
                lbl.setBounds(pathBounds);
                image = new BufferedImage(lbl.getWidth(), lbl.getHeight(), 3);
                Graphics2D graphics = image.createGraphics();
                graphics.setComposite(AlphaComposite.getInstance(3, 0.5f));
                lbl.setOpaque(false);
                lbl.paint(graphics);
                graphics.dispose();
                cursor = this.selectCursor(dtde.getDropAction());
            }
        }
    }

    private void autoscroll(Point cursorLocation) {
        Insets insets = this.autoscrollInsets;
        Rectangle outer = this.tree.getVisibleRect();
        Rectangle inner = new Rectangle(outer.x + insets.left, outer.y + insets.top, outer.width - (insets.left + insets.right), outer.height - (insets.top + insets.bottom));
        if (!inner.contains(cursorLocation)) {
            Rectangle scrollRect = new Rectangle(cursorLocation.x - insets.left, cursorLocation.y - insets.top, insets.left + insets.right, insets.top + insets.bottom);
            this.tree.scrollRectToVisible(scrollRect);
        }
    }

    static {
        image = null;
    }
}

