/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import oracle.javatools.db.Column;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.tip.adapter.db.toplinkext.NameEnquoter;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.DBAdapterOfflineTablesImporter;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterUtil;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.util.DBMetaDataChangeRecord;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.internal.helper.DatabaseTable;

public class TableReImporter
implements Runnable {
    XRAdapterWizardContext ascontext;
    AdapterWizardContext m_wcontext;
    Connection connectionUsed;
    Vector<DBMetaDataChangeRecord> changes = new Vector();
    boolean finished = false;
    int myNumber;
    static int takeANumber = 0;

    public TableReImporter(AdapterWizardContext context, XRAdapterWizardContext ascontext) {
        this.m_wcontext = context;
        this.ascontext = ascontext;
        this.connectionUsed = context._connection;
        this.myNumber = ++takeANumber;
    }

    public Vector<DBMetaDataChangeRecord> getChanges() {
        if (this.ascontext._reimportedTables.size() == 0) {
            return this.changes;
        }
        RelationalDescriptor owner = null;
        RelationalDescriptor goodDesc = null;
        RelationalDescriptor badDesc = null;
        Iterator<DBMetaDataChangeRecord> iter = this.changes.iterator();
        while (iter.hasNext()) {
            DBMetaDataChangeRecord rec = iter.next();
            owner = rec.owner;
            if (owner == goodDesc) continue;
            if (owner == badDesc) {
                iter.remove();
                continue;
            }
            if (this.ascontext._reimportedTables.contains(owner.getTables().get(0))) {
                badDesc = owner;
                iter.remove();
                continue;
            }
            goodDesc = owner;
        }
        return this.changes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForFinish(long maxWait) {
        if (this.finished) {
            return true;
        }
        try {
            TableReImporter tableReImporter = this;
            synchronized (tableReImporter) {
                if (this.finished) {
                    return true;
                }
                this.wait(maxWait);
                return this.finished;
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    public Connection getConnectionUsed() {
        return this.connectionUsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.connectionUsed = this.m_wcontext._connection;
        if (this.connectionUsed == null || this.ascontext._orProject == null) {
            return;
        }
        DBAdapterOfflineTablesImporter tableImporter = new DBAdapterOfflineTablesImporter();
        NameEnquoter enquoter = null;
        Collection descriptorsColl = this.ascontext._orProject.getDescriptors().values();
        RelationalDescriptor[] descriptors = descriptorsColl.toArray(new RelationalDescriptor[descriptorsColl.size()]);
        String[] tableNames = this.tableNamesFromDescriptors(this.m_wcontext._connection, descriptors);
        Table[] tables = tableImporter.generate(this.m_wcontext, tableNames);
        int j = 0;
        for (int i = 0; i < tableNames.length; ++i) {
            if (i >= tables.length) {
                this.changes.add(DBMetaDataChangeRecord.tableRemoved(tableNames[i], descriptors[i]));
                continue;
            }
            if (new DatabaseTable(tables[j].getName()).equals(new DatabaseTable(tableNames[i]))) {
                if (tables[j].getColumns().length == 0) {
                    String enquoted;
                    if (enquoter == null) {
                        try {
                            enquoter = new NameEnquoter(this.connectionUsed);
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                            try {
                                enquoter = new NameEnquoter((Connection)null);
                            }
                            catch (SQLException notPossible) {
                                // empty catch block
                            }
                        }
                    }
                    if (tableNames[i].equals(enquoted = enquoter.enquoteName(tableNames[i]))) {
                        this.changes.add(DBMetaDataChangeRecord.tableRemoved(tableNames[i], descriptors[i]));
                    }
                    ++j;
                    continue;
                }
                Vector<DBMetaDataChangeRecord> tableChanges = new Vector<DBMetaDataChangeRecord>();
                this.compareTableToProperties(tables[j++], tableNames[i], descriptors[i], tableChanges);
                if (tableChanges.size() <= 0) continue;
                this.changes.add(DBMetaDataChangeRecord.tableChanged(tableNames[i], descriptors[i]));
                this.changes.addAll(tableChanges);
                continue;
            }
            this.changes.add(DBMetaDataChangeRecord.tableRemoved(tableNames[i], descriptors[i]));
        }
        TableReImporter tableReImporter = this;
        synchronized (tableReImporter) {
            this.finished = true;
            this.notifyAll();
        }
    }

    public void compareTableToProperties(Table table, String tableName, RelationalDescriptor owner, Vector<DBMetaDataChangeRecord> changes) {
        String key;
        String propsColumnName;
        Column[] tableColumns = table.getColumns();
        int i = 0;
        int c = 0;
        Vector<DBMetaDataChangeRecord> columnChanges = new Vector<DBMetaDataChangeRecord>();
        Vector<String> columnNamesVector = new Vector<String>();
        while ((propsColumnName = this.ascontext._dtProps.getProperty(key = tableName + ":db_column_" + i++)) != null) {
            columnNamesVector.add(propsColumnName);
        }
        String[] columnNames = new String[columnNamesVector.size()];
        columnNames = columnNamesVector.toArray(columnNames);
        i = 0;
        while (i < columnNames.length || c < tableColumns.length) {
            int lookAhead;
            if (i >= columnNames.length) {
                changes.add(DBMetaDataChangeRecord.columnAdded(tableColumns[c], i, owner));
                ++c;
                continue;
            }
            if (c >= tableColumns.length) {
                changes.add(DBMetaDataChangeRecord.columnRemoved(columnNames[i], i, owner));
                ++i;
                continue;
            }
            String propsColumnName2 = columnNames[i];
            String tableColumnName = tableColumns[c].getName();
            if (propsColumnName2.equals(tableColumnName)) {
                this.compareColumn(tableColumns[c], tableName, columnNames[i], columnChanges);
                if (columnChanges.size() > 0) {
                    changes.add(DBMetaDataChangeRecord.columnChanged(tableColumns[c], i, owner));
                    changes.addAll(columnChanges);
                    columnChanges.clear();
                }
                ++i;
                ++c;
                continue;
            }
            boolean wasColumnRemoved = false;
            for (lookAhead = i + 1; lookAhead < columnNames.length; ++lookAhead) {
                if (!columnNames[lookAhead].equals(tableColumnName)) continue;
                wasColumnRemoved = true;
                break;
            }
            while (wasColumnRemoved && i < lookAhead) {
                changes.add(DBMetaDataChangeRecord.columnRemoved(columnNames[i], i, owner));
                ++i;
            }
            if (wasColumnRemoved) continue;
            boolean wasColumnAdded = false;
            for (lookAhead = c + 1; lookAhead < tableColumns.length; ++lookAhead) {
                if (!tableColumns[lookAhead].getName().equals(propsColumnName2)) continue;
                wasColumnAdded = true;
                break;
            }
            while (wasColumnAdded && c < lookAhead) {
                changes.add(DBMetaDataChangeRecord.columnAdded(tableColumns[c], i, owner));
                ++c;
            }
            if (wasColumnAdded) continue;
            this.compareColumn(tableColumns[c], tableName, columnNames[i], columnChanges);
            if (columnChanges.size() > 0) {
                columnChanges.clear();
                changes.add(DBMetaDataChangeRecord.columnRemoved(columnNames[i], i, owner));
                changes.add(DBMetaDataChangeRecord.columnAdded(tableColumns[c], i, owner));
            }
            changes.add(DBMetaDataChangeRecord.columnRenamed(columnNames[i], tableColumns[c], i, owner));
            ++i;
            ++c;
        }
    }

    private Integer getInteger(Object value) {
        if (value == null) {
            return null;
        }
        if (Number.class.isAssignableFrom(value.getClass())) {
            return new Integer(((Number)value).intValue());
        }
        try {
            return Integer.parseInt((String)value);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public void compareColumn(Column column, String tableName, String columnName, Vector<DBMetaDataChangeRecord> changes) {
        String baseKey = tableName + "." + columnName;
        String dataTypeName = null;
        try {
            dataTypeName = DataTypeHelper.getDataType((DataTypeUsage)column.getDataTypeUsage()).getName();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        Object fieldSizeObj = column.getDataTypeUsage().getAttributeValue("size");
        Integer size = this.getInteger(fieldSizeObj);
        Object fieldPrecisionObj = column.getDataTypeUsage().getAttributeValue("precision");
        Integer precision = this.getInteger(fieldPrecisionObj);
        Object fieldScaleObj = column.getDataTypeUsage().getAttributeValue("scale");
        Integer subSize = this.getInteger(fieldScaleObj);
        String notNull = String.valueOf(column.isNotNull());
        String oldDataTypeName = this.ascontext._dtProps.getProperty(baseKey + ":db_column_type");
        Integer oldSize = this.getInteger(this.ascontext._dtProps.getProperty(baseKey + ":db_column_size"));
        Integer oldSubSize = this.getInteger(this.ascontext._dtProps.getProperty(baseKey + ":db_column_scale"));
        Integer oldPrecision = this.getInteger(this.ascontext._dtProps.getProperty(baseKey + ":db_column_precision"));
        String oldNotNull = this.ascontext._dtProps.getProperty(baseKey + ":db_column_not_null");
        Class dataType = XRAdapterUtil.getJavaTypeFromSQLType(dataTypeName, size != null ? size : precision, subSize, null);
        Class oldDataType = XRAdapterUtil.getJavaTypeFromSQLType(oldDataTypeName, oldSize != null ? oldSize : oldPrecision, oldSubSize, null);
        if (!(dataType == oldDataType || Number.class.isAssignableFrom(dataType) && Number.class.isAssignableFrom(oldDataType))) {
            changes.add(DBMetaDataChangeRecord.newColumnDataType(oldDataTypeName, dataTypeName, null));
        }
        if (("VARCHAR".equalsIgnoreCase(dataTypeName) || "VARCHAR2".equalsIgnoreCase(dataTypeName) || "CHAR".equalsIgnoreCase(dataTypeName)) && oldSize != null && size != null && size > 0 && oldSize.intValue() != size.intValue()) {
            changes.add(DBMetaDataChangeRecord.newColumnSize(oldSize.toString(), size.toString(), null));
        }
        if (notNull != null && oldNotNull != null && !notNull.equals(oldNotNull)) {
            changes.add(DBMetaDataChangeRecord.newColumnNotNull(oldNotNull, notNull, null));
        }
    }

    public String[] tableNamesFromDescriptors(Connection connection, RelationalDescriptor[] descriptors) {
        Vector<String> tableNames = new Vector<String>(descriptors.length);
        for (int i = 0; i < descriptors.length; ++i) {
            DatabaseTable dbTable;
            RelationalDescriptor desc = descriptors[i];
            if (desc.getTables().size() <= 0 || this.ascontext._reimportedTables.contains(dbTable = (DatabaseTable)desc.getTables().get(0))) continue;
            tableNames.add(dbTable.getQualifiedName());
        }
        return tableNames.toArray(new String[tableNames.size()]);
    }
}

