/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.util;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Vector;
import oracle.tip.adapter.db.DBActivationSpec;
import oracle.tip.adapter.db.api.TopLinkReadSpec;
import oracle.tip.adapter.db.api.TopLinkSpec;
import oracle.tip.adapter.db.inbound.PollingStrategy;
import oracle.tip.adapter.db.ox.TopLinkClassLoader;
import oracle.tip.adapter.db.ox.TopLinkXMLProjectInitializer;
import oracle.tip.adapter.db.toplinkext.FakeDatabaseAccessor;
import oracle.tip.adapter.db.toplinkext.NameEnquoter;
import oracle.tip.adapter.db.util.ArtifactsUtil;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ModifyQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.factories.XMLProjectReader;
import org.eclipse.persistence.sessions.factories.XMLProjectWriter;

public class ShowMeTheSQLUtil {
    protected static ShowMeTheSQLUtil instance;
    protected ClassLoader loader;
    protected Hashtable parameterTypeIndex;
    protected String prePollingSQL;
    protected String postPollingSQL;

    protected ShowMeTheSQLUtil() {
    }

    public static ShowMeTheSQLUtil instance() {
        if (instance == null) {
            instance = new ShowMeTheSQLUtil();
            instance.setLoader((ClassLoader)ArtifactsUtil.getLoader());
        }
        return instance;
    }

    public ClassLoader getLoader() {
        if (this.loader == null) {
            this.loader = new TopLinkClassLoader();
        }
        return this.loader;
    }

    public String extractSQL(Project project, RelationalDescriptor descriptor, String queryName, TopLinkReadSpec spec, NameEnquoter nameEnquoter) throws Exception {
        this.prePollingSQL = null;
        this.postPollingSQL = null;
        StringWriter writer = new StringWriter();
        XMLProjectWriter.write((Project)project, (Writer)writer);
        StringReader reader = new StringReader(writer.toString());
        Project clonedProject = XMLProjectReader.read((Reader)reader, (ClassLoader)ArtifactsUtil.getLoader());
        RelationalDescriptor desc = (RelationalDescriptor)clonedProject.getDescriptor(descriptor.getJavaClass());
        TopLinkXMLProjectInitializer initializer = new TopLinkXMLProjectInitializer();
        DatabaseSessionImpl session = new DatabaseSessionImpl(clonedProject);
        session.setAccessor((Accessor)new FakeDatabaseAccessor());
        session.dontLogMessages();
        initializer.initialize(clonedProject, (TopLinkSpec)spec, desc.getJavaClass(), nameEnquoter);
        for (RelationalDescriptor next : clonedProject.getDescriptors().values()) {
        }
        session.login();
        initializer.resolveCycles(desc, clonedProject);
        if (spec != null) {
            initializer.initializeQuery(desc, spec, (AbstractSession)session, true, false);
        }
        DatabaseQuery query = null;
        if (spec instanceof DBActivationSpec) {
            DBActivationSpec activationSpec = (DBActivationSpec)spec;
            activationSpec = (DBActivationSpec)activationSpec.clone();
            activationSpec.setSequencingDataSourceName(null);
            if (activationSpec.getPollingStrategy().equals("ExternalSequencingPollingStrategy")) {
                activationSpec.setPollingStrategy("SequencingPollingStrategy");
            }
            PollingStrategy pollingStrategy = activationSpec.createPollingStrategy();
            pollingStrategy.initialize(activationSpec, (Session)session, desc, this.loader);
            query = pollingStrategy.getPollingQuery();
            DatabaseRecord[] pointer = new DatabaseRecord[1];
            DatabaseQuery prePollingQuery = pollingStrategy.getPrePollingQuery(pointer);
            if (prePollingQuery != null) {
                this.prePollingSQL = this.extractSQL((AbstractSession)session, prePollingQuery, pointer[0]);
            }
            pointer[0] = null;
            DatabaseQuery postPollingQuery = pollingStrategy.getPostPollingQuery((AbstractSession)session, pointer);
            if (postPollingQuery != null) {
                this.postPollingSQL = this.extractSQL((AbstractSession)session, postPollingQuery, pointer[0]);
            }
        } else {
            query = desc.getQueryManager().getQuery(queryName);
        }
        return this.extractSQL((AbstractSession)session, query, null);
    }

    public String extractSQL(AbstractSession session, DatabaseQuery query, DatabaseRecord arguments) throws Exception {
        block6: {
            if (!(session instanceof DatabaseSession) || !(session.getAccessor() instanceof FakeDatabaseAccessor)) {
                AbstractSession realSession = session;
                DatabaseSessionImpl fakeSession = new DatabaseSessionImpl();
                fakeSession.setLogin(realSession.getLogin());
                fakeSession.setAccessor((Accessor)new FakeDatabaseAccessor());
                fakeSession.addDescriptors(realSession.getProject());
                fakeSession.connect();
                session = fakeSession;
                query = (DatabaseQuery)query.clone();
            }
            if (query == null) {
                return null;
            }
            if (query.getSQLString() != null) {
                return query.getSQLString();
            }
            try {
                session.beginTransaction();
                DatabaseRecord fakeArguments = arguments;
                if (fakeArguments == null) {
                    fakeArguments = this.buildFakeArguments(query);
                }
                query.prepareCall((Session)session, (Record)fakeArguments);
                session.commitTransaction();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (query.getCall() != null) break block6;
                throw e;
            }
        }
        this.inferParameterTypes(query);
        DatabasePlatform noBindingPlatform = (DatabasePlatform)session.getPlatform().clone();
        session.getPlatform().copyInto((Platform)noBindingPlatform);
        noBindingPlatform.setShouldBindAllParameters(false);
        return this.makeSqlUserFriendly(query, noBindingPlatform);
    }

    public DatabaseRecord buildFakeArguments(DatabaseQuery query) {
        DatabaseRecord record = new DatabaseRecord(query.getArguments().size());
        for (int i = 0; i < query.getArguments().size(); ++i) {
            record.put((String)query.getArguments().get(i), null);
        }
        return record;
    }

    public void inferParameterTypes(DatabaseQuery query) {
        this.parameterTypeIndex = new Hashtable();
        SQLCall call = (SQLCall)query.getCall();
        if (call == null) {
            return;
        }
        Vector parameters = call.getParameters();
        if (parameters == null) {
            return;
        }
        for (int i = 0; i < parameters.size(); ++i) {
            DatabaseMapping mapping;
            ParameterExpression exp;
            Object parameter = parameters.get(i);
            if (!(parameter instanceof ParameterExpression) || !((exp = (ParameterExpression)parameter).getLocalBase() instanceof QueryKeyExpression) || (mapping = ((QueryKeyExpression)exp.getLocalBase()).getMapping()) == null) continue;
            this.parameterTypeIndex.put(exp.getField().getName(), mapping.getAttributeClassification());
        }
    }

    public String makeSqlUserFriendly(DatabaseQuery query, DatabasePlatform noBindingPlatform) {
        SQLCall call = (SQLCall)query.getCall();
        if (call == null) {
            return null;
        }
        String queryString = call.getQueryString();
        if (queryString.indexOf("?") == -1) {
            return queryString;
        }
        if (call.getParameters().isEmpty()) {
            return queryString;
        }
        int lastIndex = 0;
        int parameterIndex = 0;
        CharArrayWriter writer = new CharArrayWriter(queryString.length() + 50);
        try {
            Vector parameterFields = call.getParameters();
            while (lastIndex != -1) {
                String token;
                int tokenIndex = queryString.indexOf("?", lastIndex);
                if (tokenIndex == -1) {
                    token = queryString.substring(lastIndex, queryString.length());
                    lastIndex = -1;
                } else {
                    token = queryString.substring(lastIndex, tokenIndex);
                }
                writer.write(token);
                if (tokenIndex == -1) continue;
                Integer parameterType = (Integer)call.getParameterTypes().elementAt(parameterIndex);
                if (parameterType == DatasourceCall.TRANSLATION) {
                    Object parameter = parameterFields.elementAt(parameterIndex);
                    if (parameter instanceof ParameterExpression) {
                        ParameterExpression exp = (ParameterExpression)parameter;
                        writer.write("#");
                        writer.write(exp.getField().getName());
                    } else {
                        DatabaseField field = (DatabaseField)parameter;
                        writer.write("#");
                        writer.write(field.getName());
                    }
                } else if (parameterType == DatasourceCall.LITERAL) {
                    noBindingPlatform.appendParameter((Call)call, (Writer)writer, parameterFields.get(parameterIndex));
                } else if (parameterType == DatasourceCall.MODIFY || parameterType == DatasourceCall.CUSTOM_MODIFY) {
                    DatabaseField field = (DatabaseField)parameterFields.elementAt(parameterIndex);
                    DatabaseRecord modifyRow = (DatabaseRecord)((ModifyQuery)query).getModifyRow();
                    Object value = modifyRow.get(field);
                    if (value != null) {
                        noBindingPlatform.appendParameter((Call)call, (Writer)writer, value);
                    } else {
                        writer.write("#");
                        writer.write(field.getName());
                    }
                }
                lastIndex = tokenIndex + 1;
                ++parameterIndex;
            }
        }
        catch (IOException notgonnahappen) {
            // empty catch block
        }
        return ((Object)writer).toString();
    }

    public void setLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public void setParameterTypeIndex(Hashtable parameterTypeIndex) {
        this.parameterTypeIndex = parameterTypeIndex;
    }

    public Hashtable getParameterTypeIndex() {
        return this.parameterTypeIndex;
    }

    public String getPrePollingSQL() {
        return this.prePollingSQL;
    }

    public String getPostPollingSQL() {
        return this.postPollingSQL;
    }
}

