/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.util;

import java.sql.Connection;
import java.util.Vector;
import oracle.tip.adapter.db.sp.xsd.IXSDProcedure;
import oracle.tip.adapter.db.sp.xsd.oracle.DatabaseBrowser;
import oracle.tip.adapter.db.sp.xsd.oracle.XSDParameter;
import oracle.tip.adapter.db.sp.xsd.oracle.XSDProcedure;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterUtil;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.structures.ArrayMapping;
import org.eclipse.persistence.mappings.structures.ObjectArrayMapping;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDataTypeDescriptor;
import org.eclipse.persistence.mappings.structures.StructureMapping;
import org.eclipse.persistence.sessions.Project;

public class OracleADTUtil {
    public static DatabaseMapping expandUserDefinedTypesStub(Project project, RelationalDescriptor desc, DirectToFieldMapping mapping, String columnTypeName, Connection sqlConnection, String schemaName, ClassLoader loader) {
        try {
            DatabaseTable structure = new DatabaseTable(columnTypeName);
            if (structure.getTableQualifier() != null && structure.getTableQualifier().length() > 0) {
                columnTypeName = structure.getName();
                schemaName = structure.getTableQualifier();
            }
            XSDProcedure proc = new XSDProcedure(schemaName, null, "dummyProcName");
            DatabaseBrowser databaseBrowser = new DatabaseBrowser(sqlConnection, (IXSDProcedure)proc);
            proc.addParameter(mapping.getField().getName(), columnTypeName, null, null, "IN", "1", "1", 0);
            databaseBrowser.expandParameters(proc.getInParameters());
            XSDParameter param = (XSDParameter)proc.getInParameters().get(0);
            if (param.getChildren() == null || param.getChildren().size() == 0) {
                mapping.setAttributeClassification(Object.class);
                mapping.setAttributeClassificationName(Object.class.getCanonicalName());
                return mapping;
            }
            String customTypeXmlName = XRAdapterUtil.toXmlName(new DatabaseTable(columnTypeName).getName(), true);
            Class<?> attributeClassification = loader.loadClass(Helper.getPackageName((Class)desc.getJavaClass()) + "." + customTypeXmlName);
            DatabaseMapping userTypesMapping = OracleADTUtil.expandUserDefinedTypesMapping(project, desc, param, mapping.getAttributeName(), attributeClassification, columnTypeName, mapping.getField().getQualifiedName(), loader);
            return userTypesMapping;
        }
        catch (Exception e) {
            System.out.println("Could not expand custom types");
            e.printStackTrace();
            mapping.setAttributeClassification(Object.class);
            mapping.setAttributeClassificationName(Object.class.getCanonicalName());
            return mapping;
        }
    }

    protected static DatabaseMapping expandUserDefinedTypesMapping(Project project, RelationalDescriptor desc, XSDParameter param, String attributeName, Class attributeClassification, String columnTypeName, String fieldName, ClassLoader loader) throws Exception {
        fieldName = new DatabaseField(fieldName).getName();
        StructureMapping mapping = null;
        if ("Struct".equals(param.getDBType())) {
            StructureMapping sMapping = new StructureMapping();
            sMapping.setReferenceClass((Class)attributeClassification);
            sMapping.setReferenceClassName(attributeClassification.getName());
            sMapping.setFieldName(fieldName);
            mapping = sMapping;
        } else if ("Array".equals(param.getDBType())) {
            XSDParameter item = null;
            if (param.getChildren() == null || param.getChildren().size() == 0) {
                return null;
            }
            item = (XSDParameter)param.getChildren().get(0);
            if (item.getChildren() == null || item.getChildren().size() == 0) {
                ArrayMapping aMapping = new ArrayMapping();
                aMapping.setStructureName(param.getSQLType());
                aMapping.setFieldName(fieldName);
                aMapping.setAttributeElementClass(XRAdapterUtil.getJavaTypeFromSQLType(item.getDBType(), null, null, null));
                mapping = aMapping;
            } else {
                String vArrayStructureName = param.getSQLType();
                param = item;
                columnTypeName = param.getSQLType();
                String customTypeXmlName = XRAdapterUtil.toXmlName(new DatabaseTable(columnTypeName).getName(), true);
                attributeClassification = loader.loadClass(Helper.getPackageName((Class)attributeClassification) + "." + customTypeXmlName);
                ObjectArrayMapping oaMapping = new ObjectArrayMapping();
                oaMapping.setReferenceClass(attributeClassification);
                oaMapping.setReferenceClassName(attributeClassification.getCanonicalName());
                oaMapping.setStructureName(vArrayStructureName);
                oaMapping.setFieldName(fieldName);
                mapping = oaMapping;
            }
        }
        if (mapping != null) {
            mapping.setAttributeName(attributeName);
            mapping.setDescriptor((ClassDescriptor)desc);
            if (!(mapping instanceof ArrayMapping)) {
                OracleADTUtil.expandUserDefinedType(param, project, attributeClassification, columnTypeName, loader);
            }
        }
        return mapping;
    }

    protected static RelationalDescriptor expandUserDefinedType(XSDParameter param, Project project, Class javaClass, String columnTypeName, ClassLoader loader) throws Exception {
        if (project.getDescriptor(javaClass) != null) {
            return (RelationalDescriptor)project.getDescriptor(javaClass);
        }
        ObjectRelationalDataTypeDescriptor descriptor = new ObjectRelationalDataTypeDescriptor();
        descriptor.setJavaClass(javaClass);
        descriptor.setJavaClassName(javaClass.getName());
        descriptor.descriptorIsAggregate();
        descriptor.setStructureName(columnTypeName);
        Vector<DirectToFieldMapping> mappings = new Vector<DirectToFieldMapping>();
        Vector columns = param.getChildren();
        for (int i = 0; i < columns.size(); ++i) {
            XSDParameter columnParam = (XSDParameter)columns.get(i);
            DirectToFieldMapping mapping = null;
            String attributeName = XRAdapterUtil.toXmlName(columnParam.getName(), false);
            String fieldName = columnParam.getName();
            String structureName = columnParam.getSQLType();
            descriptor.addFieldOrdering(fieldName);
            if (columnParam.getChildren() != null && columnParam.getChildren().size() > 0) {
                String customTypeXmlName = XRAdapterUtil.toXmlName(new DatabaseTable(structureName).getName(), true);
                Class<?> attributeClassification = loader.loadClass(Helper.getPackageName((Class)javaClass) + "." + customTypeXmlName);
                mapping = OracleADTUtil.expandUserDefinedTypesMapping(project, (RelationalDescriptor)descriptor, columnParam, attributeName, attributeClassification, structureName, fieldName, loader);
            } else {
                DirectToFieldMapping dtfMapping = new DirectToFieldMapping();
                dtfMapping.setAttributeClassification(XRAdapterUtil.getJavaTypeFromSQLType(columnParam.getDBType(), null, null, null));
                dtfMapping.setAttributeClassificationName(dtfMapping.getAttributeClassification().getCanonicalName());
                dtfMapping.setAttributeName(attributeName);
                dtfMapping.setFieldName(fieldName);
                mapping = dtfMapping;
            }
            mappings.add(mapping);
        }
        descriptor.setMappings(mappings);
        project.addDescriptor((ClassDescriptor)descriptor);
        return descriptor;
    }
}

