/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.util;

import java.util.ResourceBundle;
import java.util.Vector;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import org.eclipse.persistence.descriptors.RelationalDescriptor;

public class DBMetaDataChangeRecord {
    Object oldValue;
    Object newValue;
    int type;
    RelationalDescriptor owner;
    int columnPosition;
    static String[] translations = null;
    static String translations_to = null;
    static String translations_reconcile = null;
    static String translations_reimport = null;
    public static String translations_title = null;
    public static final int COLUMN_ADDED = 0;
    public static final int COLUMN_REMOVED = 1;
    public static final int COLUMN_RENAMED = 2;
    public static final int COLUMN_CHANGED = 3;
    public static final int NEW_DATATYPE = 4;
    public static final int NEW_SIZE = 5;
    public static final int NEW_SUB_SIZE = 6;
    public static final int NEW_PRECISION = 7;
    public static final int NEW_NOT_NULL = 8;
    public static final int TABLE_REMOVED = 9;
    public static final int TABLE_CHANGED = 10;
    public static final boolean[] isReconcilableChange = new boolean[]{true, true, true, true, true, true, true, true, true, false, true};

    private DBMetaDataChangeRecord(Object oldValue, Object newValue, int type, RelationalDescriptor owner) {
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.type = type;
        this.owner = owner;
    }

    public static void init(AdapterWizardContext context) {
        ResourceBundle bundle = context._bundle;
        translations = new String[]{bundle.getString("DB_RI_COLUMN_ADDED"), bundle.getString("DB_RI_COLUMN_REMOVED"), bundle.getString("DB_RI_COLUMN_RENAMED"), bundle.getString("DB_RI_COLUMN_CHANGED"), bundle.getString("DB_RI_NEW_DATATYPE"), bundle.getString("DB_RI_NEW_SIZE"), bundle.getString("DB_RI_NEW_SUB_SIZE"), bundle.getString("DB_RI_NEW_PRECISION"), bundle.getString("DB_RI_NEW_NOT_NULL"), bundle.getString("DB_RI_TABLE_REMOVED"), bundle.getString("DB_RI_TABLE_CHANGED")};
        translations_to = bundle.getString("DB_RI_TO");
        translations_reconcile = bundle.getString("DB_RI_PLEASE_RECONCILE");
        translations_reimport = bundle.getString("DB_RI_PLEASE_REIMPORT");
        translations_title = bundle.getString("DB_RI_TITLE");
    }

    public static DBMetaDataChangeRecord columnAdded(Column newColumn, int position, RelationalDescriptor owner) {
        DBMetaDataChangeRecord record = new DBMetaDataChangeRecord(null, newColumn, 0, owner);
        record.columnPosition = position;
        return record;
    }

    public static DBMetaDataChangeRecord columnRemoved(String columnName, int position, RelationalDescriptor owner) {
        DBMetaDataChangeRecord record = new DBMetaDataChangeRecord(null, columnName, 1, owner);
        record.columnPosition = position;
        return record;
    }

    public static DBMetaDataChangeRecord columnRenamed(String oldName, Column newColumn, int position, RelationalDescriptor owner) {
        DBMetaDataChangeRecord record = new DBMetaDataChangeRecord(oldName, newColumn, 2, owner);
        record.columnPosition = position;
        return record;
    }

    public static DBMetaDataChangeRecord columnChanged(Column column, int position, RelationalDescriptor owner) {
        DBMetaDataChangeRecord record = new DBMetaDataChangeRecord(null, column, 3, owner);
        record.columnPosition = position;
        return record;
    }

    public static DBMetaDataChangeRecord newColumnDataType(String oldValue, String newValue, RelationalDescriptor owner) {
        return new DBMetaDataChangeRecord(oldValue, newValue, 4, owner);
    }

    public static DBMetaDataChangeRecord newColumnSize(String oldValue, String newValue, RelationalDescriptor owner) {
        return new DBMetaDataChangeRecord(oldValue, newValue, 5, owner);
    }

    public static DBMetaDataChangeRecord newColumnSubSize(String oldValue, String newValue, RelationalDescriptor owner) {
        return new DBMetaDataChangeRecord(oldValue, newValue, 6, owner);
    }

    public static DBMetaDataChangeRecord newColumnPrecision(String oldValue, String newValue, RelationalDescriptor owner) {
        return new DBMetaDataChangeRecord(oldValue, newValue, 7, owner);
    }

    public static DBMetaDataChangeRecord newColumnNotNull(String oldValue, String newValue, RelationalDescriptor owner) {
        return new DBMetaDataChangeRecord(oldValue, newValue, 8, owner);
    }

    public static DBMetaDataChangeRecord tableRemoved(Object table, RelationalDescriptor owner) {
        return new DBMetaDataChangeRecord(null, table, 9, owner);
    }

    public static DBMetaDataChangeRecord tableChanged(Object table, RelationalDescriptor owner) {
        return new DBMetaDataChangeRecord(null, table, 10, owner);
    }

    boolean isReconcilableChange() {
        return isReconcilableChange[this.type];
    }

    private static String getName(Object value) {
        if (value instanceof DBObject) {
            DBObject dbObject = (DBObject)value;
            return dbObject.getName();
        }
        if (value == null) {
            return "n/a";
        }
        return value.toString();
    }

    public static String summarizeChanges(Vector<DBMetaDataChangeRecord> changes, AdapterWizardContext context) {
        if (translations == null) {
            DBMetaDataChangeRecord.init(context);
        }
        StringBuffer buffer = new StringBuffer();
        boolean areChangesReconcilable = true;
        String finalString = null;
        for (DBMetaDataChangeRecord change : changes) {
            if (!change.isReconcilableChange()) {
                areChangesReconcilable = false;
            }
            buffer.append("\n");
            buffer.append(translations[change.type]);
            if (change.type == 2 || change.type >= 4 && change.type <= 8) {
                buffer.append(DBMetaDataChangeRecord.getName(change.oldValue));
                buffer.append(translations_to);
            }
            buffer.append(DBMetaDataChangeRecord.getName(change.newValue));
        }
        finalString = areChangesReconcilable ? translations_reimport + buffer.toString() : translations_reimport + buffer.toString();
        return finalString;
    }
}

