/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.ui;

import java.util.Collections;
import java.util.List;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.MWQueryable;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.TopLinkDescriptorUtilities;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.ui.QueryableTreeNode;
import oracle.toplink.workbench.utility.filters.Filter;
import oracle.toplink.workbench.utility.filters.NullFilter;
import oracle.toplink.workbench.utility.node.Node;
import org.eclipse.persistence.descriptors.RelationalDescriptor;

final class QueryableTreeModel
implements TreeModel {
    private DefaultMutableTreeNode rootDescriptor;
    private Filter queryableFilter;
    private List queryableObjects;

    QueryableTreeModel(DefaultMutableTreeNode root) {
        this(root, NullFilter.instance());
    }

    QueryableTreeModel(DefaultMutableTreeNode root, Filter queryableFilter) {
        this.rootDescriptor = root;
        this.queryableFilter = queryableFilter;
        this.queryableObjects = this.buildQueryableObjects();
    }

    protected Filter getQueryableFilter() {
        return this.queryableFilter;
    }

    @Override
    public Object getRoot() {
        return this.rootDescriptor;
    }

    RelationalDescriptor getDescriptor() {
        return (RelationalDescriptor)((DefaultMutableTreeNode)this.getRoot()).getUserObject();
    }

    List buildQueryableObjects() {
        List<MWQueryable> list = TopLinkDescriptorUtilities.getQueryables(this.getDescriptor(), this.queryableFilter);
        Collections.sort(list, Node.DEFAULT_COMPARATOR);
        return list;
    }

    @Override
    public Object getChild(Object parent, int index) {
        MWQueryable queryableObject = QueryableTreeNode.class.isAssignableFrom(parent.getClass()) ? ((MWQueryable)((QueryableTreeNode)parent).getUserObject()).subQueryableElementAt(index, this.queryableFilter) : (MWQueryable)this.queryableObjects.get(index);
        if (((DefaultMutableTreeNode)parent).getChildCount() > index) {
            return ((DefaultMutableTreeNode)parent).getChildAt(index);
        }
        QueryableTreeNode childNode = new QueryableTreeNode(queryableObject, !queryableObject.isLeaf(this.queryableFilter));
        ((DefaultMutableTreeNode)parent).add(childNode);
        return childNode;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == this.getRoot()) {
            return this.queryableObjects.size();
        }
        return ((QueryableTreeNode)parent).getQueryable().subQueryableElements(this.queryableFilter).size();
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node == this.getRoot()) {
            return false;
        }
        return ((QueryableTreeNode)node).isLeaf(this.queryableFilter);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == this.getRoot()) {
            return this.queryableObjects.indexOf(((QueryableTreeNode)child).getQueryable());
        }
        List<MWQueryable> children = ((QueryableTreeNode)child).getQueryable().subQueryableElements(this.queryableFilter);
        if (children != null && children.size() > 0) {
            return children.indexOf(((QueryableTreeNode)child).getQueryable());
        }
        return 0;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
    }
}

