/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Stack;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.MWQueryable;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.MWQueryableArgumentElement;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.ui.QueryableTreeModel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.ui.QueryableTreeNode;
import oracle.toplink.workbench.framework.context.WorkbenchContext;
import oracle.toplink.workbench.framework.resources.ResourceRepository;
import oracle.toplink.workbench.uitools.swing.Tree;

final class QueryableTree
extends Tree {
    private WorkbenchContext context;

    QueryableTree(QueryableTreeModel newModel, WorkbenchContext context) {
        super((TreeModel)newModel);
        this.initialize(context);
    }

    private FocusListener buildFocusListener() {
        return new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                TreePath[] paths = QueryableTree.this.getSelectionPaths();
                if (paths == null) {
                    return;
                }
                for (int index = 0; index < paths.length; ++index) {
                    Rectangle pathBounds = QueryableTree.this.getUI().getPathBounds((JTree)((Object)QueryableTree.this), paths[index]);
                    QueryableTree.this.repaint(pathBounds.x, pathBounds.y, pathBounds.width, pathBounds.height);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                this.focusGained(e);
            }
        };
    }

    private TreeSelectionListener buildTreeSelectionListener() {
        return new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath treePath = e.getNewLeadSelectionPath();
                if (treePath != null) {
                    TreePath[] paths = new TreePath[treePath.getPathCount() - 1];
                    int count = paths.length - 1;
                    paths[count--] = treePath;
                    treePath = treePath.getParentPath();
                    Object rootNode = QueryableTree.this.getModel().getRoot();
                    while (rootNode != treePath.getLastPathComponent()) {
                        paths[count--] = treePath;
                        treePath = treePath.getParentPath();
                    }
                    QueryableTree.this.setSelectionPaths(paths);
                }
            }
        };
    }

    public TreePath getSelectionPath() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return null;
        }
        return paths[paths.length - 1];
    }

    private void initialize(WorkbenchContext context) {
        this.context = context;
        this.setRowHeight(0);
        this.setEditable(true);
        this.setAutoscrolls(true);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.addFocusListener(this.buildFocusListener());
        QueryableTreeCell treeCell = new QueryableTreeCell();
        this.setCellEditor(treeCell);
        this.setCellRenderer(treeCell);
        this.addTreeSelectionListener(this.buildTreeSelectionListener());
    }

    protected void processMouseEvent(MouseEvent e) {
        TreePath path;
        Rectangle pathBounds;
        if (this.isEditing() && e.getButton() == 1 && !(pathBounds = this.getPathBounds(path = this.getEditingPath())).contains(e.getX(), e.getY())) {
            this.stopEditing();
        }
        super.processMouseEvent(e);
    }

    private ResourceRepository resourceRepository() {
        return this.context.getApplicationContext().getResourceRepository();
    }

    void setSelectedQueryableArgumentElement(MWQueryableArgumentElement element) {
        if (element == null) {
            return;
        }
        Stack<MWQueryableArgumentElement> joinedElementsStack = new Stack<MWQueryableArgumentElement>();
        while (element != null) {
            joinedElementsStack.add(element);
            element = element.getJoinedQueryableElement();
        }
        QueryableTreeModel treeModel = (QueryableTreeModel)this.getModel();
        MWQueryableArgumentElement nextElement = (MWQueryableArgumentElement)((Object)joinedElementsStack.pop());
        if (nextElement.getQueryable() == null) {
            return;
        }
        int index = treeModel.buildQueryableObjects().indexOf(nextElement.getQueryable());
        if (index == -1) {
            return;
        }
        int count = 0;
        int selectionIndex = index;
        QueryableTreeNode node = (QueryableTreeNode)treeModel.getChild(treeModel.getRoot(), index);
        node.setAllowsNull(nextElement.isAllowsNull());
        this.expandRow(index);
        MWQueryable queryable = nextElement.getQueryable();
        while (!joinedElementsStack.empty()) {
            ++count;
            nextElement = (MWQueryableArgumentElement)((Object)joinedElementsStack.pop());
            if (nextElement.getQueryable() == null || !treeModel.getQueryableFilter().accept((Object)nextElement.getQueryable())) {
                return;
            }
            index = queryable.subQueryableElements(treeModel.getQueryableFilter()).indexOf(nextElement.getQueryable());
            node = (QueryableTreeNode)treeModel.getChild(node, index);
            node.setAllowsNull(nextElement.isAllowsNull());
            selectionIndex = selectionIndex + index + 1;
            this.expandRow(selectionIndex);
            queryable = nextElement.getQueryable();
        }
        this.setSelectionRow(selectionIndex);
    }

    private final class QueryableTreeCell
    extends AbstractCellEditor
    implements TreeCellEditor,
    TreeCellRenderer {
        private QueryableNodeCheckBoxPanel editor;
        private Object value;

        QueryableTreeCell() {
            this.initialize();
        }

        private QueryableNodeCheckBoxPanel createQueryKeyPanel() {
            return new QueryableNodeCheckBoxPanel();
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
            this.editor.update(tree, true, expanded, leaf, row, true);
            this.editor.populate((QueryableTreeNode)value, true);
            this.value = value;
            return this.editor;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int rowIndex, boolean hasFocus) {
            if (tree.getModel().getRoot() == value) {
                return new JLabel();
            }
            QueryableTreeNode node = (QueryableTreeNode)value;
            hasFocus = QueryableTree.this.isPathSelected(new TreePath(node.getPath()));
            QueryableNodeCheckBoxPanel checkBoxPanel = this.createQueryKeyPanel();
            checkBoxPanel.update(tree, selected, expanded, leaf, rowIndex, hasFocus);
            checkBoxPanel.populate((QueryableTreeNode)value, selected);
            checkBoxPanel.invalidate();
            return checkBoxPanel;
        }

        private void initialize() {
            this.editor = this.createQueryKeyPanel();
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            TreePath path = null;
            MouseEvent mouseEvent = null;
            if (e instanceof MouseEvent) {
                mouseEvent = (MouseEvent)e;
                path = QueryableTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            } else {
                path = QueryableTree.this.getSelectionPath();
            }
            if (path == null) {
                return false;
            }
            QueryableTreeNode node = (QueryableTreeNode)path.getLastPathComponent();
            MWQueryable queryable = (MWQueryable)node.getUserObject();
            if (!queryable.allowsOuterJoin()) {
                return false;
            }
            if (mouseEvent == null) {
                return true;
            }
            JCheckBox checkBox = this.editor.allowsNullCheckBox;
            this.editor.populate(node, true);
            int x_checkBox = ((QueryableNodeCheckBoxPanel)this.editor).queryableLabel.getPreferredSize().width + 8;
            int x_allowsNullCheckBox = QueryableTree.this.getPathBounds((TreePath)path).x + x_checkBox + checkBox.getBorder().getBorderInsets((Component)checkBox).left;
            return mouseEvent.getX() >= x_allowsNullCheckBox;
        }
    }

    private final class QueryableNodeCheckBoxPanel
    extends JPanel {
        private JCheckBox allowsNullCheckBox;
        private DefaultTreeCellRenderer queryableLabel;
        private QueryableTreeNode queryableNode;

        protected QueryableNodeCheckBoxPanel() {
            super(new GridBagLayout());
            this.initialize();
        }

        protected ActionListener buildAllowsNullAction() {
            return new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    QueryableNodeCheckBoxPanel.this.queryableNode.setAllowsNull(QueryableNodeCheckBoxPanel.this.allowsNullCheckBox.isSelected());
                    QueryableTree.this.stopEditing();
                }
            };
        }

        private DefaultTreeCellRenderer buildQueryableLabel() {
            return new DefaultTreeCellRenderer(){

                @Override
                public Color getBackgroundSelectionColor() {
                    if (!QueryableTree.this.hasFocus() && !QueryableTree.this.isEditing()) {
                        return UIManager.getColor("Panel.background");
                    }
                    return super.getBackgroundSelectionColor();
                }

                @Override
                public Color getBorderSelectionColor() {
                    if (!QueryableTree.this.hasFocus() && !QueryableTree.this.isEditing()) {
                        return UIManager.getColor("Panel.background");
                    }
                    return super.getBorderSelectionColor();
                }

                @Override
                public Dimension getPreferredSize() {
                    Dimension size = super.getPreferredSize();
                    size.height += 2;
                    return size;
                }
            };
        }

        private void initialize() {
            this.setOpaque(false);
            GridBagConstraints constraints = new GridBagConstraints();
            this.queryableLabel = this.buildQueryableLabel();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 0;
            constraints.anchor = 21;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)this.queryableLabel, constraints);
            this.allowsNullCheckBox = new JCheckBox();
            this.allowsNullCheckBox.setMargin(new Insets(0, 0, 0, 0));
            this.allowsNullCheckBox.setOpaque(false);
            this.allowsNullCheckBox.addActionListener(this.buildAllowsNullAction());
            constraints.gridx = 1;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 0;
            constraints.anchor = 10;
            constraints.insets = new Insets(0, 8, 0, 0);
            this.add((Component)this.allowsNullCheckBox, constraints);
        }

        protected void populate(QueryableTreeNode queryableNode, boolean selected) {
            this.queryableNode = queryableNode;
            MWQueryable queryable = (MWQueryable)queryableNode.getUserObject();
            this.allowsNullCheckBox.setVisible(queryable.allowsOuterJoin());
            this.allowsNullCheckBox.setEnabled(selected);
            this.allowsNullCheckBox.setSelected(queryableNode.isAllowsNull());
            this.queryableLabel.setText(queryable.getName());
            this.queryableLabel.setIcon(QueryableTree.this.resourceRepository().getIcon(queryable.iconKey()));
            if (queryable.usesAnyOf()) {
                this.allowsNullCheckBox.setText(QueryableTree.this.resourceRepository().getString("ALLOWS_NONE_CHECK_BOX_LABEL_IN_QUERYABLE_TREE", new Object[0]));
                this.allowsNullCheckBox.setMnemonic(QueryableTree.this.resourceRepository().getMnemonic("ALLOWS_NONE_CHECK_BOX_LABEL_IN_QUERYABLE_TREE"));
                this.allowsNullCheckBox.setDisplayedMnemonicIndex(QueryableTree.this.resourceRepository().getMnemonicIndex("ALLOWS_NONE_CHECK_BOX_LABEL_IN_QUERYABLE_TREE"));
            } else {
                this.allowsNullCheckBox.setText(QueryableTree.this.resourceRepository().getString("ALLOWS_NULL_CHECK_BOX_LABEL_IN_QUERYABLE_TREE", new Object[0]));
                this.allowsNullCheckBox.setMnemonic(QueryableTree.this.resourceRepository().getMnemonic("ALLOWS_NULL_CHECK_BOX_LABEL_IN_QUERYABLE_TREE"));
                this.allowsNullCheckBox.setDisplayedMnemonicIndex(QueryableTree.this.resourceRepository().getMnemonicIndex("ALLOWS_NULL_CHECK_BOX_LABEL_IN_QUERYABLE_TREE"));
            }
        }

        protected void update(JTree tree, boolean selected, boolean expanded, boolean leaf, int rowIndex, boolean hasFocus) {
            this.queryableLabel.getTreeCellRendererComponent(tree, null, selected, expanded, leaf, rowIndex, hasFocus);
        }
    }
}

