/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.controls.DoubleClickTrigger;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.MWQueryable;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.MWQueryableArgument;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.ui.AbstractDialog;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.ui.QueryableTree;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.ui.QueryableTreeModel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.ui.QueryableTreeNode;
import oracle.toplink.workbench.framework.context.WorkbenchContext;
import oracle.toplink.workbench.utility.filters.Filter;
import org.eclipse.persistence.descriptors.ClassDescriptor;

final class QueryableEditDialog
extends AbstractDialog {
    private MWQueryableArgument argument;
    private QueryableTree queryKeyTree;

    QueryableEditDialog(MWQueryableArgument argument, WorkbenchContext context) {
        super(context, (Dialog)context.getCurrentWindow());
        this.argument = argument;
    }

    private MouseAdapter buildDoubleClickMouseListener() {
        return new MouseAdapter(){
            DoubleClickTrigger trigger = new DoubleClickTrigger();

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path;
                if (this.trigger.isDoubleClick(e) && (path = QueryableEditDialog.this.queryKeyTree.getPathForLocation(e.getX(), e.getY())) != null) {
                    QueryableEditDialog.this.clickOK();
                }
            }
        };
    }

    @Override
    protected JComponent buildMainPanel() {
        this.getOKAction().setEnabled(false);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.queryKeyTree = new QueryableTree(new QueryableTreeModel(new DefaultMutableTreeNode(this.getDescriptor()), this.buildQueryableFilter()), this.getWorkbenchContext());
        this.queryKeyTree.addTreeSelectionListener(this.buildTreeSelectionHandler());
        this.queryKeyTree.setSelectedQueryableArgumentElement(this.argument.getQueryableArgumentElement());
        this.queryKeyTree.addMouseListener(this.buildDoubleClickMouseListener());
        panel.add((Component)new JScrollPane((Component)((Object)this.queryKeyTree)), "Center");
        return panel;
    }

    private Filter buildQueryableFilter() {
        return new Filter(){

            public boolean accept(Object o) {
                return ((MWQueryable)o).isTraversableForQueryExpression();
            }
        };
    }

    private TreeSelectionListener buildTreeSelectionHandler() {
        return new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                QueryableEditDialog.this.updateOKButton();
            }
        };
    }

    @Override
    protected void cancelPressed() {
        ((DefaultMutableTreeNode)this.queryKeyTree.getModel().getRoot()).removeAllChildren();
        super.cancelPressed();
    }

    private ClassDescriptor getDescriptor() {
        return this.argument.getParentQuery().getDescriptor();
    }

    @Override
    protected String helpTopicId() {
        return "dialogEditQueryable";
    }

    @Override
    protected void initialize(WorkbenchContext workbenchContext) {
        super.initialize(workbenchContext);
        this.setTitle(this.resourceRepository().getString("CHOOSE_QUERY_KEY_DIALOG_TITLE_TITLE", new Object[0]));
        this.setDescription("CHOOSE_QUERY_KEY_DIALOG_DESCRIPTION");
        this.setDescriptionTitle("CHOOSE_QUERY_KEY_DIALOG_DESCRIPTION_TITLE");
    }

    @Override
    protected Dimension initialSize() {
        Dimension size = super.initialSize();
        size.width += 75;
        size.height += 100;
        return size;
    }

    @Override
    protected boolean preConfirm() {
        TreePath selectionPath = this.queryKeyTree.getSelectionPath();
        ArrayList<MWQueryable> queryablePath = new ArrayList<MWQueryable>();
        ArrayList<Boolean> allowsNull = new ArrayList<Boolean>();
        QueryableTreeNode selectedNode = (QueryableTreeNode)selectionPath.getLastPathComponent();
        allowsNull.add(selectedNode.isAllowsNull());
        MWQueryable queryableObject = selectedNode.getQueryable();
        queryablePath.add(queryableObject);
        selectionPath = selectionPath.getParentPath();
        while (selectionPath.getPathCount() > 1) {
            selectedNode = (QueryableTreeNode)selectionPath.getLastPathComponent();
            allowsNull.add(new Boolean(selectedNode.isAllowsNull()));
            MWQueryable joinedQueryable = selectedNode.getQueryable();
            queryablePath.add(joinedQueryable);
            selectionPath = selectionPath.getParentPath();
        }
        this.argument.setQueryableArgument(queryablePath.iterator(), allowsNull.iterator());
        ((DefaultMutableTreeNode)this.queryKeyTree.getModel().getRoot()).removeAllChildren();
        return super.preConfirm();
    }

    private void updateOKButton() {
        this.getOKAction().setEnabled(this.queryKeyTree.getSelectionCount() > 0);
    }
}

