/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.ui;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.text.Document;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.MWQueryableArgument;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.ui.ArgumentPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.ui.QueryableEditDialog;
import oracle.toplink.workbench.framework.context.WorkbenchContextHolder;
import oracle.toplink.workbench.uitools.app.FilteringPropertyValueModel;
import oracle.toplink.workbench.uitools.app.PropertyAspectAdapter;
import oracle.toplink.workbench.uitools.app.PropertyValueModel;
import oracle.toplink.workbench.uitools.app.ValueModel;
import oracle.toplink.workbench.uitools.app.swing.DocumentAdapter;

final class QueryableArgumentPanel
extends ArgumentPanel {
    private JTextField queryKeyTextField;
    private JButton editQueryKeyButton;

    QueryableArgumentPanel(PropertyValueModel argumentHolder, WorkbenchContextHolder contextHolder, Collection enablingComponents) {
        super(argumentHolder, contextHolder);
        this.initialize(enablingComponents);
    }

    protected MWQueryableArgument getQueryableArgument() {
        return (MWQueryableArgument)this.getArgument();
    }

    private void initialize(Collection enablingComponents) {
        GridBagConstraints constraints = new GridBagConstraints();
        this.queryKeyTextField = this.buildQueryableTextField();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add(this.queryKeyTextField, constraints);
        this.editQueryKeyButton = this.buildButton("QUERY_KEY_EDIT_BUTTON_ON_SECOND_ARGUMENT_PANEL");
        this.editQueryKeyButton.addActionListener(this.buildEditQueryKeyAction());
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 0, 0);
        this.add(this.editQueryKeyButton, constraints);
        enablingComponents.add(this.editQueryKeyButton);
    }

    private JTextField buildQueryableTextField() {
        JTextField textField = new JTextField();
        textField.setDocument((Document)new DocumentAdapter(this.buildQueryableHolder()));
        textField.setEditable(false);
        return textField;
    }

    private PropertyValueModel buildQueryableHolder() {
        return new PropertyAspectAdapter((ValueModel)this.getArgumentHolder(), "queryableArgumentElement"){

            protected Object getValueFromSubject() {
                return ((MWQueryableArgument)this.subject).displayString();
            }
        };
    }

    @Override
    protected PropertyValueModel buildQueryArgumentHolder(PropertyValueModel argumentHolder) {
        return new FilteringPropertyValueModel(argumentHolder){

            protected boolean accept(Object value) {
                return value instanceof MWQueryableArgument;
            }
        };
    }

    private ActionListener buildEditQueryKeyAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                QueryableArgumentPanel.this.editQueryKey();
            }
        };
    }

    private void editQueryKey() {
        QueryableEditDialog queryKeyDialog = new QueryableEditDialog(this.getQueryableArgument(), this.getWorkbenchContext());
        queryKeyDialog.show();
    }
}

