/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.ui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collection;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.MWQueryParameterArgument;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.ui.ArgumentPanel;
import oracle.toplink.workbench.framework.context.WorkbenchContextHolder;
import oracle.toplink.workbench.uitools.app.FilteringPropertyValueModel;
import oracle.toplink.workbench.uitools.app.ListAspectAdapter;
import oracle.toplink.workbench.uitools.app.ListValueModel;
import oracle.toplink.workbench.uitools.app.PropertyAspectAdapter;
import oracle.toplink.workbench.uitools.app.PropertyValueModel;
import oracle.toplink.workbench.uitools.app.ValueModel;
import oracle.toplink.workbench.uitools.app.swing.ComboBoxModelAdapter;
import oracle.toplink.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.queries.DatabaseQuery;

final class ParameterArgumentPanel
extends ArgumentPanel
implements ActionListener,
KeyListener {
    private PropertyValueModel queryAggumentHolder;
    private static final String PARAMETER_NAME_PREFIX = "arg";
    JButton addButton;
    JTextField textField;
    JComboBox parameterComboBox;

    ParameterArgumentPanel(PropertyValueModel argumentHolder, WorkbenchContextHolder contextHolder, Collection enablingComponents) {
        super(argumentHolder, contextHolder);
        this.initialize(enablingComponents);
    }

    private void initialize(Collection enablingComponents) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        this.parameterComboBox = this.buildParameterComboBox();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add(this.parameterComboBox, constraints);
        enablingComponents.add(this.parameterComboBox);
        this.textField = new JTextField(0);
        this.textField.addKeyListener(this);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add(this.textField, constraints);
        this.addButton = this.buildButton("ADD_EXPRESSION_BUTTON");
        this.addButton.addActionListener(this);
        this.addButton.setEnabled(false);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 0, 0);
        this.add(this.addButton, constraints);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.addButton) {
            DatabaseQuery query = (DatabaseQuery)this.getQueryHolder().getValue();
            String newParamName = this.textField.getText();
            if (!query.getArguments().contains(newParamName)) {
                query.addArgument(newParamName);
            }
            ((MWQueryParameterArgument)this.getArgument()).setQueryParameter(newParamName);
            this.textField.setText(null);
            this.addButton.setEnabled(false);
            this.parameterComboBox.setModel(new ComboBoxModelAdapter(this.buildParametersCollectionHolder(), this.buildParameterHolder()));
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }

    @Override
    public void keyReleased(KeyEvent ke) {
        if (this.textField.getText() != null && this.textField.getText().length() > 0) {
            this.addButton.setEnabled(true);
        } else {
            this.addButton.setEnabled(false);
        }
    }

    @Override
    public void keyPressed(KeyEvent ke) {
    }

    private JComboBox buildParameterComboBox() {
        JComboBox comboBox = new JComboBox(new ComboBoxModelAdapter(this.buildParametersCollectionHolder(), this.buildParameterHolder()));
        comboBox.setRenderer(this.buildParametersListCellRenderer());
        return comboBox;
    }

    private ListValueModel buildParametersCollectionHolder() {
        return new ListAspectAdapter((ValueModel)this.getQueryHolder()){

            protected ListIterator getValueFromSubject() {
                return ((DatabaseQuery)this.subject).getArguments().listIterator();
            }
        };
    }

    private PropertyValueModel buildParameterHolder() {
        return new PropertyAspectAdapter((ValueModel)this.getArgumentHolder(), "queryParameter"){

            protected Object getValueFromSubject() {
                return ((MWQueryParameterArgument)this.subject).getQueryParameter();
            }

            protected void setValueOnSubject(Object value) {
                ((MWQueryParameterArgument)this.subject).setQueryParameter((String)value);
            }
        };
    }

    @Override
    protected PropertyValueModel buildQueryArgumentHolder(PropertyValueModel argumentHolder) {
        return new FilteringPropertyValueModel(argumentHolder){

            protected boolean accept(Object value) {
                return value instanceof MWQueryParameterArgument;
            }
        };
    }

    private ListCellRenderer buildParametersListCellRenderer() {
        return new SimpleListCellRenderer(){

            protected String buildText(Object value) {
                return value == null ? ParameterArgumentPanel.this.resourceRepository().getString("NONE_SELECTED", new Object[0]) : (String)value;
            }
        };
    }
}

