/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.ui;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.MWLiteralArgument;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.ui.ArgumentPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.ui.JavaClassCellRendererAdapter;
import oracle.toplink.workbench.framework.context.WorkbenchContextHolder;
import oracle.toplink.workbench.uitools.PatternHelper;
import oracle.toplink.workbench.uitools.app.CollectionValueModel;
import oracle.toplink.workbench.uitools.app.FilteringPropertyValueModel;
import oracle.toplink.workbench.uitools.app.PropertyAspectAdapter;
import oracle.toplink.workbench.uitools.app.PropertyValueModel;
import oracle.toplink.workbench.uitools.app.SimpleCollectionValueModel;
import oracle.toplink.workbench.uitools.app.ValueModel;
import oracle.toplink.workbench.uitools.app.swing.ComboBoxModelAdapter;
import oracle.toplink.workbench.uitools.app.swing.DocumentAdapter;
import oracle.toplink.workbench.uitools.cell.AdaptableListCellRenderer;
import oracle.toplink.workbench.uitools.cell.CellRendererAdapter;

final class LiteralArgumentPanel
extends ArgumentPanel {
    private JTextField literalTextField;
    private PropertyValueModel typeHolder;

    LiteralArgumentPanel(PropertyValueModel argumentHolder, WorkbenchContextHolder contextHolder, Collection enablingComponents) {
        super(argumentHolder, contextHolder);
        this.initialize(enablingComponents);
    }

    private void initialize(Collection enablingComponents) {
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel typeLabel = this.buildLabel("TYPE_LABEL:");
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add(typeLabel, constraints);
        enablingComponents.add(typeLabel);
        JComboBox typeChooser = this.buildTypeChooser();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 0, 0);
        this.add(typeChooser, constraints);
        typeLabel.setLabelFor(typeChooser);
        enablingComponents.add(typeChooser);
        JLabel valueLabel = this.buildLabel("VALUE_LABEL:");
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 0, 0, 0);
        this.add(valueLabel, constraints);
        enablingComponents.add(valueLabel);
        this.literalTextField = this.buildLiteralTextField();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 0, 0);
        this.add(this.literalTextField, constraints);
        valueLabel.setLabelFor(this.literalTextField);
        enablingComponents.add(this.literalTextField);
    }

    private JComboBox buildTypeChooser() {
        JComboBox chooser = new JComboBox(this.buildAttributeTypeComboBoxModel());
        chooser.setRenderer(new AdaptableListCellRenderer((CellRendererAdapter)new JavaClassCellRendererAdapter(this.resourceRepository())));
        return chooser;
    }

    private ComboBoxModel buildAttributeTypeComboBoxModel() {
        this.typeHolder = this.buildTypeHolder();
        return new ComboBoxModelAdapter(this.buildTypesCollectionHolder(), this.typeHolder);
    }

    private CollectionValueModel<Class> buildTypesCollectionHolder() {
        return new SimpleCollectionValueModel(this.buildBasicTypes());
    }

    public List<Class> buildBasicTypes() {
        ArrayList<Class> result = new ArrayList<Class>();
        result.add(BigDecimal.class);
        result.add(BigInteger.class);
        result.add(Blob.class);
        result.add(Boolean.class);
        result.add(byte[].class);
        result.add(Byte.class);
        result.add(Byte[].class);
        result.add(Calendar.class);
        result.add(char[].class);
        result.add(Character.class);
        result.add(Character[].class);
        result.add(Clob.class);
        result.add(Date.class);
        result.add(java.util.Date.class);
        result.add(Double.class);
        result.add(Float.class);
        result.add(Integer.class);
        result.add(Long.class);
        result.add(Number.class);
        result.add(Short.class);
        result.add(String.class);
        result.add(Time.class);
        result.add(Timestamp.class);
        return result;
    }

    private PropertyValueModel buildTypeHolder() {
        return new PropertyAspectAdapter((ValueModel)this.getArgumentHolder(), "type"){

            protected Object getValueFromSubject() {
                return ((MWLiteralArgument)this.subject).getLiteralType();
            }

            protected void setValueOnSubject(Object value) {
                ((MWLiteralArgument)this.subject).setType((Class)value);
            }
        };
    }

    private JTextField buildLiteralTextField() {
        JTextField textField = new JTextField(0);
        final PropertyValueModel literalHolder = this.buildLiteralHolder();
        textField.setDocument((Document)new DocumentAdapter(literalHolder));
        this.typeHolder.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Class type = (Class)evt.getNewValue();
                if (type != null) {
                    if (type == Integer.class || type == BigInteger.class || type == Long.class || type == Short.class) {
                        LiteralArgumentPanel.this.literalTextField.setDocument((Document)new DocumentAdapter(literalHolder, PatternHelper.pattern((int)7)));
                    } else if (type == BigDecimal.class || type == Double.class || type == Float.class) {
                        LiteralArgumentPanel.this.literalTextField.setDocument((Document)new DocumentAdapter(literalHolder, PatternHelper.pattern((int)10)));
                    } else {
                        LiteralArgumentPanel.this.literalTextField.setDocument((Document)new DocumentAdapter(literalHolder, PatternHelper.pattern((int)0)));
                    }
                }
            }
        });
        return textField;
    }

    private PropertyValueModel buildLiteralHolder() {
        return new PropertyAspectAdapter((ValueModel)this.getArgumentHolder(), "value"){

            protected Object getValueFromSubject() {
                return ((MWLiteralArgument)this.subject).getValue();
            }

            protected void setValueOnSubject(Object value) {
                ((MWLiteralArgument)this.subject).setValue((String)value);
            }
        };
    }

    @Override
    protected PropertyValueModel buildQueryArgumentHolder(PropertyValueModel argumentHolder) {
        return new FilteringPropertyValueModel(argumentHolder){

            protected boolean accept(Object value) {
                return value instanceof MWLiteralArgument;
            }
        };
    }
}

