/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ListIterator;
import javax.swing.tree.DefaultTreeModel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.MWBasicExpression;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.MWCompoundExpression;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.MWExpression;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.ui.BasicExpressionTreeNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.ui.ExpressionTreeNode;
import oracle.toplink.workbench.utility.events.ListChangeEvent;
import oracle.toplink.workbench.utility.events.ListChangeListener;

final class CompoundExpressionTreeNode
extends ExpressionTreeNode
implements ListChangeListener,
PropertyChangeListener {
    CompoundExpressionTreeNode(MWCompoundExpression compoundExpression) {
        this(compoundExpression, null);
    }

    CompoundExpressionTreeNode(MWCompoundExpression compoundExpression, DefaultTreeModel model) {
        super(compoundExpression, true, model);
    }

    MWCompoundExpression getCompoundExpression() {
        return (MWCompoundExpression)this.getUserObject();
    }

    private ExpressionTreeNode addNodeForExpression(MWExpression expression) {
        ExpressionTreeNode node = MWBasicExpression.class.isAssignableFrom(expression.getClass()) ? new BasicExpressionTreeNode((MWBasicExpression)expression, this.getModel()) : new CompoundExpressionTreeNode((MWCompoundExpression)expression, this.getModel());
        this.getModel().insertNodeInto(node, this, this.getChildCount());
        return node;
    }

    @Override
    public void initializeChildren() {
        ListIterator expressions = this.getCompoundExpression().expressions();
        while (expressions.hasNext()) {
            MWExpression expression = (MWExpression)expressions.next();
            ExpressionTreeNode node = this.addNodeForExpression(expression);
            node.initializeChildren();
        }
    }

    @Override
    protected void engageListeners() {
        this.getCompoundExpression().addListChangeListener(this);
        this.getCompoundExpression().addPropertyChangeListener(this);
    }

    public void itemsReplaced(ListChangeEvent event) {
    }

    public void itemsAdded(ListChangeEvent event) {
        ListIterator stream = event.items();
        while (stream.hasNext()) {
            this.addNodeForExpression((MWExpression)stream.next());
        }
    }

    public void itemsRemoved(ListChangeEvent event) {
        ExpressionTreeNode node = (ExpressionTreeNode)this.getChildAt(event.getIndex());
        node.disengageListeners();
        this.getModel().removeNodeFromParent(node);
    }

    public void listChanged(ListChangeEvent event) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (propertyName == "operatorType") {
            this.getModel().nodeChanged(this);
        }
    }

    @Override
    protected void disengageListeners() {
        this.getCompoundExpression().removeListChangeListener(this);
        this.getCompoundExpression().removePropertyChangeListener(this);
        while (this.getChildCount() > 0) {
            ExpressionTreeNode node = (ExpressionTreeNode)this.getFirstChild();
            node.disengageListeners();
            this.getModel().removeNodeFromParent(node);
        }
        this.setUserObject(null);
    }
}

