/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingConstants;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import javax.swing.tree.TreeModel;
import oracle.toplink.workbench.framework.HelpManager;
import oracle.toplink.workbench.framework.context.ApplicationContext;
import oracle.toplink.workbench.framework.context.WindowWorkbenchContext;
import oracle.toplink.workbench.framework.context.WorkbenchContext;
import oracle.toplink.workbench.framework.resources.ResourceRepository;
import oracle.toplink.workbench.framework.ui.view.old.AbstractPanel;
import oracle.toplink.workbench.framework.uitools.old.SwingComponentFactory;
import oracle.toplink.workbench.uitools.ComponentAligner;
import oracle.toplink.workbench.uitools.PostExecution;
import oracle.toplink.workbench.uitools.UITools;
import oracle.toplink.workbench.uitools.app.PropertyValueModel;
import oracle.toplink.workbench.uitools.app.SimplePropertyValueModel;
import oracle.toplink.workbench.uitools.app.ValueModel;
import oracle.toplink.workbench.uitools.app.swing.TriStateCheckBoxModelAdapter;
import oracle.toplink.workbench.uitools.swing.DialogHeader;
import oracle.toplink.workbench.uitools.swing.LabelArea;
import oracle.toplink.workbench.uitools.swing.LinkLabelBuilder;
import oracle.toplink.workbench.uitools.swing.TriStateCheckBox;
import oracle.toplink.workbench.utility.events.AWTChangeNotifier;
import oracle.toplink.workbench.utility.iterators.NullIterator;
import oracle.toplink.workbench.utility.node.Node;
import oracle.toplink.workbench.utility.node.NodeModel;
import oracle.toplink.workbench.utility.preferences.Preferences;

public abstract class AbstractDialog<T extends NodeModel>
extends JDialog
implements SwingConstants {
    private JLabel accessibleLabel;
    private boolean built;
    private Map<Action, JButton> buttons;
    private Action cancelAction;
    private AbstractPanel container;
    private WorkbenchContext context;
    private JPanel customButtonPanel;
    private Object[] descriptionArguments;
    private String descriptionIconKey;
    private String descriptionKey;
    private Object[] descriptionTitleArguments;
    private String descriptionTitleKey;
    DialogHeader dialogHeader;
    private Action helpAction;
    private Component initialFocusComponent;
    private Action okAction;
    private JPanel rightButtonPanel;
    private PropertyValueModel<T> subjectHolder;
    private boolean wasConfirmed;
    public static final String INITIAL_FOCUS_COMPONENT = "initial-focus-component";

    protected AbstractDialog(WorkbenchContext context) {
        this(context, (String)null);
    }

    protected AbstractDialog(WorkbenchContext context, Dialog owner) {
        this(context, null, owner);
    }

    protected AbstractDialog(WorkbenchContext context, String title) {
        super((Frame)context.getCurrentWindow(), title, true);
        this.initialize(context);
    }

    protected AbstractDialog(WorkbenchContext context, String title, Dialog owner) {
        super(owner, title, true);
        this.initialize(context);
    }

    protected final void addAlignLeft(ComponentAligner group) {
        this.getAlignLeftGroup().add(group);
    }

    protected final void addAlignLeft(JComponent component) {
        this.getAlignLeftGroup().add((Component)component);
    }

    protected final void addAlignRight(ComponentAligner group) {
        this.getAlignRightGroup().add(group);
    }

    protected final void addAlignRight(JComponent component) {
        this.getAlignRightGroup().add((Component)component);
    }

    private void addCustomAction(Action customAction, JPanel panel, ComponentAligner aligner) {
        JButton button = new JButton(customAction);
        panel.add(button);
        aligner.add((Component)button);
        this.buttons.put(customAction, button);
    }

    protected final void addHelpTopicId(JComponent component, String topicId) {
        this.helpManager().addTopicID(component, topicId);
    }

    protected final void addPaneForAlignLeft(AbstractPanel panel) {
        this.getAlignLeftGroup().add(panel.getAlignLeftGroup());
    }

    protected final void addPaneForAlignment(AbstractPanel panel) {
        this.addPaneForAlignLeft(panel);
        this.addPaneForAlignRight(panel);
    }

    protected final void addPaneForAlignRight(AbstractPanel panel) {
        this.getAlignRightGroup().add(panel.getAlignRightGroup());
    }

    private void attachToWaitCursor() {
    }

    protected final JButton buildBrowseButton(String key, Accessible labeler) {
        return SwingComponentFactory.buildBrowseButton((String)key, (ResourceRepository)this.resourceRepository(), (Accessible)labeler);
    }

    protected final JButton buildButton(String key) {
        return SwingComponentFactory.buildButton((String)key, (ResourceRepository)this.resourceRepository());
    }

    protected JComponent buildButtonPanel() {
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        ComponentAligner aligner = new ComponentAligner();
        JPanel leftButtonPanel = new JPanel(new GridLayout(1, 0, 5, 5));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 5, 0, 0);
        JButton helpButton = new JButton(this.helpAction);
        this.buttons.put(this.helpAction, helpButton);
        SwingComponentFactory.setTextFor((AbstractButton)helpButton, (String)this.helpButtonKey(), (ResourceRepository)this.resourceRepository());
        leftButtonPanel.add(helpButton);
        aligner.add((Component)helpButton);
        buttonPanel.add((Component)leftButtonPanel, constraints);
        Box leftCenterButtonPanelSpace = Box.createHorizontalBox();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 10, 0, 0);
        buttonPanel.add((Component)leftCenterButtonPanelSpace, constraints);
        this.customButtonPanel = this.buildCustomButtonPanel(aligner);
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 13;
        constraints.insets = new Insets(0, 0, 0, 5);
        buttonPanel.add((Component)this.customButtonPanel, constraints);
        this.rightButtonPanel = new JPanel(new GridLayout(1, 0, 5, 5));
        constraints.gridx = 4;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 13;
        constraints.insets = new Insets(0, 0, 0, 5);
        JButton okButton = new JButton(this.okAction);
        this.buttons.put(this.okAction, okButton);
        this.rightButtonPanel.add(okButton);
        aligner.add((Component)okButton);
        JButton cancelButton = new JButton(this.cancelAction);
        this.buttons.put(this.cancelAction, cancelButton);
        if (this.cancelButtonIsVisible()) {
            this.rightButtonPanel.add(cancelButton);
            aligner.add((Component)cancelButton);
        }
        buttonPanel.add((Component)this.rightButtonPanel, constraints);
        this.setDefaultAction(this.okAction);
        return buttonPanel;
    }

    protected Action buildCancelAction() {
        return new AbstractAction(this.buildCancelText()){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDialog.this.cancelPressed();
            }
        };
    }

    protected String buildCancelText() {
        return this.resourceRepository().getString("DIALOG.CANCEL_BUTTON_TEXT", new Object[0]);
    }

    protected final JCheckBox buildCheckBox(String key, ButtonModel buttonModel) {
        return SwingComponentFactory.buildCheckBox((String)key, (ButtonModel)buttonModel, (ResourceRepository)this.resourceRepository());
    }

    private ComponentAdapter buildComponentListener() {
        return new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                JDialog dialog = (JDialog)e.getComponent();
                Dimension newPreferredSize = dialog.getMinimumSize();
                Dimension currentSize = dialog.getSize();
                int height = currentSize.height;
                int width = currentSize.width;
                if (newPreferredSize.width > width) {
                    width = newPreferredSize.width;
                }
                if (newPreferredSize.height > height) {
                    height = newPreferredSize.height;
                }
                if (width != currentSize.width || height != currentSize.height) {
                    dialog.setSize(width, height);
                }
            }
        };
    }

    protected Iterator<Action> buildCustomActions() {
        return NullIterator.instance();
    }

    protected JPanel buildCustomButtonPanel(ComponentAligner aligner) {
        JPanel container = new JPanel(new GridLayout(1, 0, 5, 5));
        Iterator<Action> stream = this.buildCustomActions();
        while (stream.hasNext()) {
            this.addCustomAction(stream.next(), container, aligner);
        }
        return container;
    }

    protected DialogHeader buildDescriptionPanel() {
        return new DialogHeader();
    }

    private DialogHeader buildDialogHeader() {
        DialogHeader dialogHeader = this.buildDescriptionPanel();
        if (this.descriptionKey != null) {
            dialogHeader.setHeaderDescription(this.resourceRepository().getString(this.descriptionKey, this.descriptionArguments));
        }
        if (this.descriptionIconKey != null) {
            dialogHeader.setHeaderImage(this.resourceRepository().getIcon(this.descriptionIconKey));
        }
        if (this.descriptionTitleKey != null) {
            dialogHeader.setHeaderTitle(this.resourceRepository().getString(this.descriptionTitleKey, this.descriptionTitleArguments));
        }
        return dialogHeader;
    }

    protected Action buildHelpAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDialog.this.helpPressed();
            }
        };
    }

    protected final LinkLabelBuilder.Link buildHelpLink(String key, String topicId) {
        return new LinkLabelBuilder.NavigatableLink(this.resourceRepository().getString(key, new Object[0]), topicId){

            public void navigate() {
                AbstractDialog.this.helpManager().showTopic(this.getHref());
            }
        };
    }

    protected final JLabel buildLabel(String key) {
        return SwingComponentFactory.buildLabel((String)key, (ResourceRepository)this.resourceRepository());
    }

    protected final LabelArea buildLabelArea(String key) {
        return SwingComponentFactory.buildLabelArea((String)key, (ResourceRepository)this.resourceRepository());
    }

    protected final LabelArea buildLink(String key, LinkLabelBuilder.Link ... links) {
        return SwingComponentFactory.buildLink((String)key, (ResourceRepository)this.resourceRepository(), (LinkLabelBuilder.Link[])links);
    }

    protected final LabelArea buildLink(String key, String iconKey, LinkLabelBuilder.Link ... links) {
        return SwingComponentFactory.buildLink((String)key, (String)iconKey, (ResourceRepository)this.resourceRepository(), (LinkLabelBuilder.Link[])links);
    }

    protected abstract JComponent buildMainPanel();

    protected final JLabel buildMultiLineLabel(String key, Object ... arguments) {
        return SwingComponentFactory.buildMultiLineLabel((String)key, (ResourceRepository)this.resourceRepository(), (Object[])arguments);
    }

    protected Action buildOKAction() {
        return new AbstractAction(this.buildOKText()){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDialog.this.okPressed();
            }
        };
    }

    protected String buildOKText() {
        return this.resourceRepository().getString("DIALOG.OK_BUTTON_TEXT", new Object[0]);
    }

    protected final Border buildPaneTitledBorder(String key) {
        return SwingComponentFactory.buildPaneTitledBorder((String)key, (ResourceRepository)this.resourceRepository());
    }

    protected final JRadioButton buildRadioButton(String key, ButtonModel buttonModel) {
        return SwingComponentFactory.buildRadioButton((String)key, (ButtonModel)buttonModel, (ResourceRepository)this.resourceRepository());
    }

    protected final LabelArea buildScrollableLabelArea(String key) {
        return SwingComponentFactory.buildScrollableLabelArea((String)key, (ResourceRepository)this.resourceRepository());
    }

    protected final LabelArea buildScrollableLink(String key, LinkLabelBuilder.Link ... links) {
        return SwingComponentFactory.buildScrollableLink((String)key, (ResourceRepository)this.resourceRepository(), (LinkLabelBuilder.Link[])links);
    }

    protected final LabelArea buildScrollableLink(String key, String iconKey, LinkLabelBuilder.Link ... links) {
        return SwingComponentFactory.buildScrollableLink((String)key, (String)iconKey, (ResourceRepository)this.resourceRepository(), (LinkLabelBuilder.Link[])links);
    }

    protected final JSpinner buildSpinnerDate(SpinnerDateModel model) {
        return SwingComponentFactory.buildSpinnerDate((SpinnerDateModel)model);
    }

    protected final JSpinner buildSpinnerNumber(SpinnerNumberModel model) {
        return SwingComponentFactory.buildSpinnerNumber((SpinnerNumberModel)model);
    }

    protected final JSpinner buildSpinnerNumber(SpinnerNumberModel model, int columns) {
        return SwingComponentFactory.buildSpinnerNumber((SpinnerNumberModel)model, (int)columns);
    }

    protected T buildStateObject() {
        return null;
    }

    protected final JTable buildTable(TableModel tableModel) {
        return SwingComponentFactory.buildTable((TableModel)tableModel);
    }

    protected final JTable buildTable(TableModel tableModel, ListSelectionModel listSelectionModel) {
        return SwingComponentFactory.buildTable((TableModel)tableModel, (ListSelectionModel)listSelectionModel);
    }

    protected final JTable buildTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        return SwingComponentFactory.buildTable((TableModel)tableModel, (TableColumnModel)tableColumnModel, (ListSelectionModel)listSelectionModel);
    }

    protected final JTextField buildTextField(Document document) {
        return SwingComponentFactory.buildTextField((Document)document);
    }

    protected final Border buildTitledBorder(String key) {
        return SwingComponentFactory.buildTitledBorder((String)key, (ResourceRepository)this.resourceRepository());
    }

    protected final JToggleButton buildToggleButton(String key) {
        return SwingComponentFactory.buildToggleButton((String)key, (ResourceRepository)this.resourceRepository());
    }

    protected final JTree buildTree(TreeModel model) {
        return SwingComponentFactory.buildTree((TreeModel)model);
    }

    protected final TriStateCheckBox buildTriStateCheckBox(String key, TriStateCheckBoxModelAdapter model) {
        return SwingComponentFactory.buildTriStateCheckBox((String)key, (TriStateCheckBox.TriStateButtonModel)model, (ResourceRepository)this.resourceRepository());
    }

    Node.Validator buildValidator() {
        return NodeModel.NULL_VALIDATOR;
    }

    protected WindowListener buildWindowListener() {
        return new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                AbstractDialog.this.removeWindowListener(this);
                AbstractDialog.this.windowOpened();
            }
        };
    }

    protected boolean cancelButtonIsVisible() {
        return true;
    }

    protected void cancelPressed() {
        this.wasConfirmed = false;
        this.dispose();
    }

    protected void click(Action action) {
        this.getButtonFor(action).doClick();
    }

    protected void clickCancel() {
        this.click(this.cancelAction);
    }

    protected void clickOK() {
        this.click(this.okAction);
    }

    protected final Window currentWindow() {
        return this.getWorkbenchContext().getCurrentWindow();
    }

    private void deatachFromWaitCursor() {
    }

    protected boolean descriptionPaneSupported() {
        return this.descriptionKey != null || this.descriptionTitleKey != null;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.deatachFromWaitCursor();
    }

    private ComponentAligner getAlignLeftGroup() {
        return this.container.getAlignLeftGroup();
    }

    private ComponentAligner getAlignRightGroup() {
        return this.container.getAlignRightGroup();
    }

    protected final ApplicationContext getApplicationContext() {
        return this.context.getApplicationContext();
    }

    protected JButton getButtonFor(Action action) {
        return this.buttons.get(action);
    }

    @Override
    public JComponent getContentPane() {
        return (JComponent)super.getContentPane();
    }

    protected Action getCancelAction() {
        return this.cancelAction;
    }

    protected Action getHelpAction() {
        return this.helpAction;
    }

    protected Action getOKAction() {
        return this.okAction;
    }

    protected final ValueModel<T> getSubjectHolder() {
        return this.subjectHolder;
    }

    protected final WorkbenchContext getWorkbenchContext() {
        return this.context;
    }

    protected final Insets groupBoxMargin() {
        return SwingComponentFactory.groupBoxMargin();
    }

    protected String helpButtonKey() {
        return "ABSTRACT_DIALOG_HELP_BUTTON_TEXT";
    }

    protected final HelpManager helpManager() {
        return this.getApplicationContext().getHelpManager();
    }

    protected void helpPressed() {
        this.helpManager().showTopic(this.getContentPane());
    }

    protected abstract String helpTopicId();

    protected Component initialFocusComponent() {
        return this.initialFocusComponent;
    }

    protected void initialize() {
        this.buttons = new HashMap<Action, JButton>();
        this.wasConfirmed = false;
        this.setDefaultCloseOperation(2);
        this.initializeActions();
        this.initializeDefaultKeyboardActions();
        this.addWindowListener(this.buildWindowListener());
        this.attachToWaitCursor();
        this.addComponentListener(this.buildComponentListener());
        this.subjectHolder = new SimplePropertyValueModel();
    }

    protected void initialize(WorkbenchContext workbenchContext) {
        this.context = new WindowWorkbenchContext(workbenchContext, (Window)this);
        this.initialize();
    }

    protected void initializeActions() {
        this.okAction = this.buildOKAction();
        this.cancelAction = this.buildCancelAction();
        this.helpAction = this.buildHelpAction();
    }

    protected void initializeContentPane() {
        GridBagConstraints constraints = new GridBagConstraints();
        JComponent contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.container = new AbstractPanel(new GridBagLayout(), this.getApplicationContext()){};
        this.container.setOpaque(false);
        contentPane.add((Component)this.container, "Center");
        if (this.descriptionPaneSupported()) {
            this.dialogHeader = this.buildDialogHeader();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            constraints.anchor = 10;
            constraints.insets = new Insets(0, 0, 0, 0);
            this.container.add((Component)this.dialogHeader, (Object)constraints);
            this.helpManager().addTopicID((JComponent)this.dialogHeader, this.helpTopicId());
        }
        JComponent mainPanel = this.buildMainPanel();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 0, 5);
        this.container.add((Component)mainPanel, (Object)constraints);
        this.helpManager().addTopicID(mainPanel, this.helpTopicId());
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(10, 5, 10, 5);
        this.container.add((Component)new JSeparator(), (Object)constraints);
        JComponent buttonPanel = this.buildButtonPanel();
        buttonPanel.setBorder(new EmptyBorder(0, 0, 5, 0));
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.container.add((Component)buttonPanel, (Object)constraints);
        StatusBarPane statusBarPane = new StatusBarPane();
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.container.add((Component)statusBarPane, (Object)constraints);
    }

    protected void initializeDefaultKeyboardActions() {
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.getRootPane().getActionMap().put("cancel", this.cancelAction);
    }

    protected Dimension initialSize() {
        this.pack();
        return this.getSize();
    }

    private void installSubject() {
        T subject = this.buildStateObject();
        if (subject != null) {
            subject.setValidator(this.buildValidator());
            subject.setChangeNotifier(AWTChangeNotifier.instance());
        }
        this.subjectHolder.setValue(subject);
    }

    protected void okConfirmed() {
        this.wasConfirmed = true;
        this.dispose();
    }

    protected void okPressed() {
        if (this.preConfirm()) {
            this.okConfirmed();
        }
    }

    protected boolean preConfirm() {
        return true;
    }

    protected final Preferences preferences() {
        return this.getApplicationContext().getPreferences();
    }

    protected void prepareToShow() {
        this.setSize(this.initialSize());
        this.setLocationRelativeTo(this.getParent());
    }

    protected final ResourceRepository resourceRepository() {
        return this.getApplicationContext().getResourceRepository();
    }

    protected void setDefaultAction(Action action) {
        this.getRootPane().setDefaultButton(this.getButtonFor(action));
    }

    public void setDescription(String descriptionKey) {
        this.setDescription(descriptionKey, new Object[0]);
    }

    public void setDescription(String descriptionKey, Object ... arguments) {
        if (this.dialogHeader == null) {
            this.descriptionKey = descriptionKey;
            this.descriptionArguments = arguments;
        } else {
            this.dialogHeader.setHeaderDescription(this.resourceRepository().getString(descriptionKey, arguments));
        }
    }

    public void setDescriptionIcon(String descriptionIconKey) {
        if (this.dialogHeader == null) {
            this.descriptionIconKey = descriptionIconKey;
        } else {
            this.dialogHeader.setHeaderImage(this.resourceRepository().getIcon(descriptionIconKey));
        }
    }

    public void setDescriptionTitle(String descriptionTitleKey) {
        this.setDescriptionTitle(descriptionTitleKey, new Object[0]);
    }

    public void setDescriptionTitle(String descriptionTitleKey, Object ... aguments) {
        if (this.dialogHeader == null) {
            this.descriptionTitleKey = descriptionTitleKey;
            this.descriptionTitleArguments = aguments;
        } else {
            this.dialogHeader.setHeaderTitle(this.resourceRepository().getString(descriptionTitleKey, aguments));
        }
    }

    protected final void setInitialFocusComponent(Component initialFocusComponent) {
        this.initialFocusComponent = initialFocusComponent;
    }

    @Override
    public void show() {
        if (!this.built) {
            this.initializeContentPane();
            this.built = true;
            this.installSubject();
        }
        this.wasConfirmed = false;
        this.helpManager().addTopicID(this.getContentPane(), this.helpTopicId());
        this.prepareToShow();
        super.show();
    }

    public final void showDialog() {
        UITools.show((Dialog)this);
    }

    public final void showDialog(PostExecution<? extends AbstractDialog<T>> execution) {
        UITools.show((Dialog)this, execution);
    }

    public T subject() {
        return (T)((NodeModel)this.subjectHolder.getValue());
    }

    protected void updateAccessibleMessage(String message) {
        if (this.accessibleLabel != null) {
            this.accessibleLabel.setText(message);
        }
    }

    public boolean wasCanceled() {
        return !this.wasConfirmed();
    }

    public boolean wasConfirmed() {
        return this.wasConfirmed;
    }

    protected void windowOpened() {
        Component component = this.initialFocusComponent();
        if (component != null) {
            component.requestFocusInWindow();
            this.initialFocusComponent = null;
        }
    }

    private class StatusBarPane
    extends JPanel {
        public StatusBarPane() {
            super(new BorderLayout());
        }

        private void buildStatusBar() {
            AbstractDialog.this.accessibleLabel = new AccessibleLabel();
            AbstractDialog.this.accessibleLabel.setVisible(false);
            StatusBar statusBar = new StatusBar();
            statusBar.setVisible(false);
            statusBar.add(AbstractDialog.this.accessibleLabel);
            this.add((Component)statusBar, "Center");
            this.validate();
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleStatusBarPane();
                this.buildStatusBar();
            }
            return this.accessibleContext;
        }

        private class StatusBar
        extends JPanel {
            private StatusBar() {
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                if (this.accessibleContext == null) {
                    this.accessibleContext = new AccessibleStatusBar();
                }
                return this.accessibleContext;
            }

            protected class AccessibleStatusBar
            extends JPanel.AccessibleJPanel {
                protected AccessibleStatusBar() {
                    super(StatusBar.this);
                }

                @Override
                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.STATUS_BAR;
                }
            }
        }

        protected class AccessibleStatusBarPane
        extends JPanel.AccessibleJPanel {
            protected AccessibleStatusBarPane() {
                super(StatusBarPane.this);
            }
        }

        private class AccessibleLabel
        extends JLabel {
            private AccessibleLabel() {
            }

            @Override
            public void setText(String text) {
                String oldText = this.getText();
                super.setText(text);
                if (this.accessibleContext != null) {
                    this.accessibleContext.firePropertyChange("AccessibleName", oldText, text);
                }
            }
        }
    }
}

