/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.tip.adapter.db.DBAdapterConstants;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.DatabaseMappingQueryable;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.DirectCollectionMappingQueryable;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.DirectMapMappingQueryable;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.DirectToFieldMappingQueryable;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.MWQueryable;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.ManyToManyMappingQueryable;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.OneToManyMappingQueryable;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.OneToOneMappingQueryable;
import oracle.toplink.workbench.utility.filters.Filter;
import oracle.toplink.workbench.utility.filters.NullFilter;
import oracle.toplink.workbench.utility.iterators.CloneListIterator;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.DirectMapMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;

public class TopLinkDescriptorUtilities {
    public static List<MWQueryable> getQueryables(RelationalDescriptor descriptor, Filter queryableFilter) {
        ArrayList<MWQueryable> queryables = new ArrayList<MWQueryable>();
        Iterator<DatabaseMapping> mappings = TopLinkDescriptorUtilities.mappingsIncludingInherited(descriptor);
        while (mappings.hasNext()) {
            DatabaseMapping mapping = mappings.next();
            MWQueryable queryable = TopLinkDescriptorUtilities.adaptMapping(mapping);
            if (!queryableFilter.accept((Object)queryable)) continue;
            queryables.add(queryable);
        }
        return queryables;
    }

    private static MWQueryable adaptMapping(DatabaseMapping mapping) {
        if (mapping.isDirectToFieldMapping()) {
            return new DirectToFieldMappingQueryable((DirectToFieldMapping)mapping);
        }
        if (mapping.isOneToOneMapping()) {
            return new OneToOneMappingQueryable((OneToOneMapping)mapping);
        }
        if (mapping.isDirectMapMapping()) {
            return new DirectMapMappingQueryable((DirectMapMapping)mapping);
        }
        if (mapping.isDirectCollectionMapping()) {
            return new DirectCollectionMappingQueryable((DirectCollectionMapping)mapping);
        }
        if (mapping.isOneToManyMapping()) {
            return new OneToManyMappingQueryable((OneToManyMapping)mapping);
        }
        if (mapping.isManyToManyMapping()) {
            return new ManyToManyMappingQueryable((ManyToManyMapping)mapping);
        }
        return new DatabaseMappingQueryable(mapping);
    }

    public static Iterator<DatabaseMapping> mappingsIncludingInherited(RelationalDescriptor descriptor) {
        return new CloneListIterator(TopLinkDescriptorUtilities.getMappingsIncludingInherited(descriptor));
    }

    protected static List<DatabaseMapping> getMappingsIncludingInherited(RelationalDescriptor descriptor) {
        Vector<DatabaseMapping> allMappings = new Vector<DatabaseMapping>();
        if (descriptor.getInheritancePolicyOrNull() != null) {
            RelationalDescriptor parentDescriptor = (RelationalDescriptor)descriptor.getInheritancePolicy().getParentDescriptor();
            if (descriptor.getInheritancePolicy().getParentDescriptor() != null) {
                allMappings.addAll(TopLinkDescriptorUtilities.getMappingsIncludingInherited(parentDescriptor));
            }
        }
        Vector mappings = descriptor.getMappings();
        for (int i = 0; i < mappings.size(); ++i) {
            if (!DBAdapterConstants.isAUseAtRuntimeMapping((DatabaseMapping)((DatabaseMapping)mappings.get(i)))) continue;
            allMappings.add((DatabaseMapping)mappings.get(i));
        }
        return allMappings;
    }

    public static MWQueryable queryableNamed(RelationalDescriptor descriptor, String queryableName) {
        for (MWQueryable queryable : TopLinkDescriptorUtilities.getQueryables(descriptor, NullFilter.instance())) {
            if (!queryable.getName().equals(queryableName)) continue;
            return queryable;
        }
        return null;
    }

    public static MWQueryable firstQueryable(RelationalDescriptor descriptor) {
        for (MWQueryable queryable : TopLinkDescriptorUtilities.getQueryables(descriptor, NullFilter.instance())) {
            if (!queryable.isLeaf(NullFilter.instance())) continue;
            return queryable;
        }
        return null;
    }
}

