/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model;

import java.util.Iterator;
import java.util.List;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.MWQueryable;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.MWQueryableArgument;
import oracle.toplink.workbench.mappingsmodel.query.relational.MWOrderingItem;
import oracle.toplink.workbench.utility.node.AbstractNodeModel;
import oracle.toplink.workbench.utility.node.Node;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;

public final class MWQueryableArgumentElement
extends AbstractNodeModel {
    private MWQueryable queryable;
    private volatile MWQueryableArgumentElement joinedQueryableElement;
    private volatile boolean allowsNull;
    public static final String ALLOWS_NULL_PROPERTY = "allowsNull";

    private MWQueryableArgumentElement() {
    }

    MWQueryableArgumentElement(MWQueryableArgument argument, MWQueryable queryable) {
        this(argument);
        this.queryable = queryable;
    }

    MWQueryableArgumentElement(MWQueryableArgumentElement argument, MWQueryable queryable) {
        this(argument);
        this.queryable = queryable;
    }

    MWQueryableArgumentElement(MWQueryableArgument argument) {
        super((Node)argument);
    }

    MWQueryableArgumentElement(MWQueryableArgumentElement argument) {
        super((Node)argument);
    }

    MWQueryableArgumentElement(MWOrderingItem orderingItem, MWQueryable queryable) {
        super((Node)orderingItem);
        this.queryable = queryable;
    }

    public MWQueryable getQueryable() {
        return this.queryable;
    }

    void setQueryableToNull() {
        this.queryable = null;
        this.joinedQueryableElement = null;
    }

    public boolean isAllowsNull() {
        return this.allowsNull;
    }

    public void setAllowsNull(boolean allowsNull) {
        boolean oldAllowsNull = this.isAllowsNull();
        this.allowsNull = allowsNull;
        this.firePropertyChanged(ALLOWS_NULL_PROPERTY, oldAllowsNull, allowsNull);
    }

    public MWQueryableArgumentElement getJoinedQueryableElement() {
        return this.joinedQueryableElement;
    }

    void setJoinedQueryable(Iterator joinedQueryables, Iterator allowsNull) {
        MWQueryable queryable = (MWQueryable)joinedQueryables.next();
        joinedQueryables.remove();
        this.joinedQueryableElement = new MWQueryableArgumentElement(this, queryable);
        if (allowsNull.hasNext()) {
            this.joinedQueryableElement.setAllowsNull((Boolean)allowsNull.next());
            allowsNull.remove();
        }
        if (joinedQueryables.hasNext()) {
            this.joinedQueryableElement.setJoinedQueryable(joinedQueryables, allowsNull);
        }
    }

    public String displayString() {
        StringBuffer displayString = new StringBuffer();
        if (this.getJoinedQueryableElement() != null) {
            displayString.append(this.getJoinedQueryableElement().displayString());
            displayString.append('.');
        }
        if (this.getQueryable() != null) {
            displayString.append(this.getQueryable().getName());
            if (this.allowsNull) {
                if (this.getQueryable().usesAnyOf()) {
                    displayString.append("(Allows None)");
                } else {
                    displayString.append("(Allows Null)");
                }
            }
        } else {
            displayString.append("<null>");
        }
        return displayString.toString();
    }

    public void toString(StringBuffer sb) {
        if (this.getJoinedQueryableElement() != null) {
            sb.append(this.getJoinedQueryableElement().displayString() + ".");
        }
        if (this.getQueryable() != null) {
            sb.append(this.getQueryable().getName());
            if (this.allowsNull) {
                if (this.getQueryable().usesAnyOf()) {
                    sb.append("(Allows None)");
                } else {
                    sb.append("(Allows Null)");
                }
            }
        }
    }

    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.queryable);
        if (this.joinedQueryableElement != null) {
            children.add(this.joinedQueryableElement);
        }
    }

    Expression convertToRuntime(ExpressionBuilder builder) {
        builder.derivedExpressions = null;
        if (this.getJoinedQueryableElement() != null) {
            Expression joinedExpression = this.getJoinedQueryableElement().convertToRuntime(builder);
            return this.buildExpressionFrom(joinedExpression);
        }
        return this.buildExpressionFrom((Expression)builder);
    }

    private Expression buildExpressionFrom(Expression expression) {
        String name = "";
        if (this.getQueryable() != null) {
            name = this.getQueryable().getName();
        }
        if (this.getQueryable() != null && !this.getQueryable().usesAnyOf()) {
            if (!this.allowsNull) {
                return expression.get(name);
            }
            return expression.getAllowingNull(name);
        }
        if (!this.allowsNull) {
            return expression.anyOf(name);
        }
        return expression.anyOfAllowingNone(name);
    }
}

