/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.MWArgument;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.MWBasicExpression;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.MWQueryable;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.MWQueryableArgumentElement;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.MWQueryableArgumentParent;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.TopLinkDescriptorUtilities;
import oracle.toplink.workbench.utility.filters.NullFilter;
import oracle.toplink.workbench.utility.iterators.NullIterator;
import oracle.toplink.workbench.utility.node.Node;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;

public final class MWQueryableArgument
extends MWArgument {
    private volatile MWQueryableArgumentElement queryableArgumentElement;
    public static final String QUERYABLE_ARGUMENT_ELEMENT_PROPERTY = "queryableArgumentElement";

    private MWQueryableArgument() {
    }

    MWQueryableArgument(MWQueryableArgumentParent parent) {
        super(parent);
    }

    MWQueryableArgument(MWQueryableArgumentParent parent, MWQueryable queryable) {
        this(parent);
        this.setQueryableArgument(queryable);
    }

    MWQueryableArgument(MWQueryableArgumentParent parent, Iterator queryables) {
        this(parent);
        this.setQueryableArgument(queryables);
    }

    MWQueryableArgument(MWQueryableArgumentParent parent, Iterator queryables, Iterator allowsNull) {
        this(parent);
        this.setQueryableArgument(queryables, allowsNull);
    }

    protected void addChildrenTo(List<Node> children) {
        super.addChildrenTo(children);
        children.add((Node)this.queryableArgumentElement);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.queryableArgumentElement = new MWQueryableArgumentElement(this);
    }

    @Override
    public String getType() {
        return "queryKey";
    }

    public String displayString() {
        return this.getQueryableArgumentElement().displayString();
    }

    @Override
    public void undoChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == QUERYABLE_ARGUMENT_ELEMENT_PROPERTY) {
            this.setQueryableArgumentElement((MWQueryableArgumentElement)((Object)oldValue));
        }
    }

    public MWQueryableArgumentElement getQueryableArgumentElement() {
        return this.queryableArgumentElement;
    }

    public void setQueryableArgument(MWQueryable queryable) {
        ArrayList<MWQueryable> queryables = new ArrayList<MWQueryable>();
        queryables.add(queryable);
        this.setQueryableArgument(queryables.iterator());
    }

    public void setQueryableArgument(Iterator queryables, Iterator allowsNull) {
        if (!queryables.hasNext()) {
            throw new UnsupportedOperationException();
        }
        MWQueryable queryable = (MWQueryable)queryables.next();
        queryables.remove();
        MWQueryableArgumentElement queryableArgumentElement = new MWQueryableArgumentElement(this, queryable);
        if (allowsNull.hasNext()) {
            queryableArgumentElement.setAllowsNull((Boolean)allowsNull.next());
            allowsNull.remove();
        }
        if (queryables.hasNext()) {
            queryableArgumentElement.setJoinedQueryable(queryables, allowsNull);
        }
        this.setQueryableArgumentElement(queryableArgumentElement);
    }

    public void setQueryableArgument(Iterator queryables) {
        this.setQueryableArgument(queryables, NullIterator.instance());
    }

    private void setQueryableArgumentElement(MWQueryableArgumentElement element) {
        MWQueryableArgumentElement oldElement = this.getQueryableArgumentElement();
        this.queryableArgumentElement = element;
        this.firePropertyChanged(QUERYABLE_ARGUMENT_ELEMENT_PROPERTY, (Object)oldElement, (Object)element);
        this.getQueryableArgumentParent().propertyChanged(this, QUERYABLE_ARGUMENT_ELEMENT_PROPERTY, (Object)oldElement, (Object)element);
    }

    @Override
    public void toString(StringBuffer sb) {
        super.toString(sb);
        sb.append((Object)this.getQueryableArgumentElement());
    }

    @Override
    Expression runtimeExpression(ExpressionBuilder builder) {
        return this.queryableArgumentElement.convertToRuntime(builder);
    }

    static MWQueryableArgument convertFromRuntime(MWBasicExpression bldrExpression, QueryKeyExpression runtimeExpression) {
        MWQueryableArgument newArgument = new MWQueryableArgument(bldrExpression);
        ArrayList<String> queryableNames = new ArrayList<String>();
        ArrayList<Boolean> allowsNullList = new ArrayList<Boolean>();
        queryableNames.add(0, runtimeExpression.getName());
        allowsNullList.add(0, runtimeExpression.shouldUseOuterJoin());
        while (runtimeExpression.getBaseExpression().isQueryKeyExpression()) {
            runtimeExpression = (QueryKeyExpression)runtimeExpression.getBaseExpression();
            queryableNames.add(0, runtimeExpression.getName());
            allowsNullList.add(runtimeExpression.shouldUseOuterJoin());
        }
        String currentQueryableName = (String)queryableNames.remove(0);
        RelationalDescriptor descriptor = (RelationalDescriptor)newArgument.getQueryableArgumentParent().getParentQuery().getDescriptor();
        MWQueryable currentQueryable = TopLinkDescriptorUtilities.queryableNamed(descriptor, currentQueryableName);
        ArrayList<MWQueryable> queryables = new ArrayList<MWQueryable>();
        queryables.add(0, currentQueryable);
        while (queryableNames.size() > 0) {
            Iterator<MWQueryable> subQueryableElements = currentQueryable.subQueryableElements(NullFilter.instance()).iterator();
            String queryableName = (String)queryableNames.remove(0);
            while (subQueryableElements.hasNext()) {
                MWQueryable queryable = subQueryableElements.next();
                if (!queryable.getName().equals(queryableName)) continue;
                currentQueryable = queryable;
                break;
            }
            queryables.add(0, currentQueryable);
        }
        newArgument.setQueryableArgument(queryables.iterator(), allowsNullList.iterator());
        return newArgument;
    }
}

