/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model;

import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.MWArgument;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.MWBasicExpression;
import oracle.toplink.workbench.utility.node.Node;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.helper.ConversionManager;

public final class MWLiteralArgument
extends MWArgument {
    private volatile Class type;
    public static final String TYPE_PROPERTY = "type";
    private volatile String value;
    public static final String VALUE_PROPERTY = "value";

    MWLiteralArgument(MWBasicExpression expression, Class type, String value) {
        super(expression);
        this.type = type;
        this.value = value;
    }

    MWLiteralArgument(MWBasicExpression expression) {
        super(expression);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.type = String.class;
        this.value = "";
    }

    private MWBasicExpression getBasicExpression() {
        return (MWBasicExpression)this.getParent();
    }

    @Override
    public String getType() {
        return "literal";
    }

    @Override
    public void operatorTypeChanged() {
        if (this.getBasicExpression().operatorIsStringType()) {
            this.setType(String.class);
        }
    }

    public Class getLiteralType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public void undoChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == TYPE_PROPERTY) {
            this.setType((Class)oldValue);
        } else if (propertyName == VALUE_PROPERTY) {
            this.setValue((String)oldValue);
        }
    }

    public void setType(Class type) {
        Class oldType = this.getLiteralType();
        this.type = type;
        this.firePropertyChanged(TYPE_PROPERTY, oldType, this.getLiteralType());
        this.getBasicExpression().getRootCompoundExpression().propertyChanged(this, TYPE_PROPERTY, oldType, type);
    }

    public void setValue(String value) {
        Object oldValue = this.getValue();
        this.value = value;
        this.firePropertyChanged(VALUE_PROPERTY, oldValue, this.getValue());
        this.getBasicExpression().getRootCompoundExpression().propertyChanged(this, VALUE_PROPERTY, oldValue, value);
    }

    public String displayString() {
        return "\"" + this.getValue() + "\"";
    }

    @Override
    public void toString(StringBuffer sb) {
        super.toString(sb);
        sb.append("type = ");
        sb.append(this.getLiteralType().getName());
        sb.append(", value = ");
        sb.append(this.getValue());
    }

    @Override
    Expression runtimeExpression(ExpressionBuilder builder) {
        return new ConstantExpression(this.value(), (Expression)builder);
    }

    private Object value() {
        ConversionManager conversionManager = ConversionManager.getDefaultManager();
        try {
            return conversionManager.convertObject((Object)this.value, this.type);
        }
        catch (ConversionException ce) {
            return null;
        }
    }

    static MWLiteralArgument convertFromRuntime(MWBasicExpression bldrExpression, ConstantExpression runtimeExpression) {
        ConversionManager conversionManager = ConversionManager.getDefaultManager();
        Object value = runtimeExpression.getValue();
        Class<?> type = value.getClass();
        MWLiteralArgument argument = new MWLiteralArgument(bldrExpression);
        argument.setType(type);
        argument.setValue((String)conversionManager.convertObject(value, String.class));
        return argument;
    }
}

