/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model;

import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import java.util.Vector;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.MWBasicExpression;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.MWExpression;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.Undoable;
import oracle.toplink.workbench.utility.events.ChangeNotifier;
import oracle.toplink.workbench.utility.events.DefaultChangeNotifier;
import oracle.toplink.workbench.utility.iterators.CloneListIterator;
import oracle.toplink.workbench.utility.node.Node;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.expressions.LogicalExpression;
import org.eclipse.persistence.queries.DatabaseQuery;

public final class MWCompoundExpression
extends MWExpression {
    private List expressions;
    public static final String EXPRESSIONS_LIST = "expressions";
    public static final String AND = "AND";
    public static final String OR = "OR";
    public static final String NAND = "NAND";
    public static final String NOR = "NOR";
    private DatabaseQuery databaseQuery;
    private Stack changes;
    public static final String ADD_EXPRESSION = "addExpression";
    public static final String REMOVE_EXPRESSION = "removeExpression";
    public static final String CLEARED_EXPRESSIONS = "clearedExpressions";
    private ChangeNotifier changeNotifier;

    public MWCompoundExpression(DatabaseQuery parent) {
        super(null, AND);
        this.databaseQuery = parent;
        this.changeNotifier = DefaultChangeNotifier.instance();
    }

    public MWCompoundExpression(MWCompoundExpression parent) {
        super(parent, AND);
    }

    protected void checkParent(Node parent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        List list = this.expressions;
        synchronized (list) {
            children.addAll(this.expressions);
        }
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.expressions = new Vector();
    }

    protected void initialize() {
        super.initialize();
        this.changes = new Stack();
    }

    private void addExpression(MWExpression expression) {
        this.expressions.add(expression);
        this.fireItemAdded(EXPRESSIONS_LIST, this.expressions.lastIndexOf(expression), expression);
        this.getRootCompoundExpression().propertyChanged(this, ADD_EXPRESSION, expression);
    }

    public ChangeNotifier getChangeNotifier() {
        if (this.changeNotifier != null) {
            return this.changeNotifier;
        }
        return super.getChangeNotifier();
    }

    public MWBasicExpression addBasicExpression() {
        MWBasicExpression expression = new MWBasicExpression(this, "EQUAL");
        this.addExpression(expression);
        return expression;
    }

    public MWCompoundExpression addSubCompoundExpression() {
        MWCompoundExpression expression = new MWCompoundExpression(this);
        this.addExpression(expression);
        expression.addBasicExpression();
        return expression;
    }

    public int expressionsSize() {
        return this.expressions.size();
    }

    public ListIterator expressions() {
        return new CloneListIterator(this.expressions);
    }

    public MWExpression getExpression(int index) {
        return (MWExpression)this.expressions.get(index);
    }

    @Override
    public String getIndex() {
        if (this.getParentCompoundExpression() == null) {
            return "";
        }
        return this.getParentCompoundExpression().getIndex() + Integer.toString(this.getParentCompoundExpression().getIndexOf(this)) + ".";
    }

    int getIndexOf(MWExpression expression) {
        ListIterator expressions = this.expressions();
        int index = 1;
        while (expressions.hasNext()) {
            if (expressions.next() == expression) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public void clearExpressions() {
        for (int i = 0; i < this.expressions.size(); ++i) {
            this.removeExpression((MWExpression)this.expressions.get(i));
        }
    }

    public void removeExpression(MWExpression expression) {
        int oldIndex = this.expressions.lastIndexOf(expression);
        expression.clearExpressions();
        this.expressions.remove(expression);
        this.fireItemRemoved(EXPRESSIONS_LIST, oldIndex, expression);
        this.getRootCompoundExpression().propertyChanged(this, REMOVE_EXPRESSION, expression);
    }

    public String displayString() {
        return this.getOperatorType();
    }

    @Override
    public MWCompoundExpression getParentCompoundExpression() {
        return (MWCompoundExpression)this.getParent();
    }

    public DatabaseQuery getParentQuery() {
        if (this.getParent() == null) {
            return this.databaseQuery;
        }
        return ((MWCompoundExpression)this.getParent()).getParentQuery();
    }

    @Override
    public MWCompoundExpression getRootCompoundExpression() {
        if (this.getParent() == null) {
            return this;
        }
        return ((MWCompoundExpression)this.getParent()).getRootCompoundExpression();
    }

    @Override
    void recalculateQueryables() {
        ListIterator expressions = this.expressions();
        while (expressions.hasNext()) {
            ((MWExpression)expressions.next()).recalculateQueryables();
        }
    }

    public void clearChanges() {
        this.changes.clear();
    }

    @Override
    public void undoChange(String propertyName, Object oldValue, Object newValue) {
        super.undoChange(propertyName, oldValue, newValue);
        if (propertyName == ADD_EXPRESSION) {
            this.removeExpression((MWExpression)newValue);
        } else if (propertyName == REMOVE_EXPRESSION) {
            this.addExpression((MWExpression)newValue);
        } else if (propertyName == CLEARED_EXPRESSIONS) {
            // empty if block
        }
    }

    void propertyChanged(Undoable container, String propertyName, Object oldValue, Object newValue) {
        this.changes.push(new PropertyChangeHolder(container, propertyName, oldValue, newValue));
    }

    void propertyChanged(Undoable container, String propertyName, Object newValue) {
        this.changes.push(new PropertyChangeHolder(container, propertyName, newValue));
    }

    public void restoreChanges() {
        Stack allChanges = new Stack();
        allChanges.addAll(this.changes);
        while (!allChanges.isEmpty()) {
            PropertyChangeHolder changeObject = (PropertyChangeHolder)allChanges.pop();
            changeObject.undoChange();
        }
        this.clearChanges();
    }

    @Override
    public void toString(StringBuffer sb) {
        super.toString(sb);
        sb.append("operator = ");
        sb.append(this.getOperatorType());
        sb.append(", expressions = ");
        sb.append('(');
        ListIterator stream = this.expressions();
        while (stream.hasNext()) {
            MWExpression expression = (MWExpression)stream.next();
            sb.append(expression);
            if (!stream.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(')');
    }

    @Override
    public Expression buildRuntimeExpression(ExpressionBuilder builder) {
        int operator;
        Expression finalExpression = null;
        boolean useNot = false;
        if (this.getOperatorType() == AND) {
            operator = 1;
        } else if (this.getOperatorType() == OR) {
            operator = 2;
        } else if (this.getOperatorType() == NAND) {
            operator = 1;
            useNot = true;
        } else {
            operator = 2;
            useNot = true;
        }
        if (this.expressionsSize() > 0) {
            finalExpression = builder.and(((MWExpression)this.expressions.get(0)).buildRuntimeExpression(builder));
            for (int i = 0; i < this.expressionsSize() - 1; ++i) {
                Expression nextExpression = ((MWExpression)this.expressions.get(i + 1)).buildRuntimeExpression(builder);
                finalExpression = operator == 1 ? builder.and(finalExpression).and(nextExpression) : builder.or(finalExpression).or(nextExpression);
            }
        }
        if (useNot) {
            return finalExpression.not();
        }
        return finalExpression;
    }

    public static MWCompoundExpression convertFromRuntime(DatabaseQuery query, Expression selectionCriteria) {
        MWCompoundExpression compoundExpression = new MWCompoundExpression(query);
        compoundExpression.initializeFromRuntime(selectionCriteria);
        return compoundExpression;
    }

    static MWCompoundExpression convertFromRuntime(MWCompoundExpression parent, Expression selectionCriteria) {
        MWCompoundExpression compoundExpression = new MWCompoundExpression(parent);
        compoundExpression.initializeFromRuntime(selectionCriteria);
        return compoundExpression;
    }

    private void initializeFromRuntime(Expression selectionCriteria) {
        if (selectionCriteria == null) {
            return;
        }
        if (selectionCriteria.isRelationExpression()) {
            this.addExpression(MWBasicExpression.convertFromRuntime(this, selectionCriteria));
            this.setOperatorType(AND);
        } else {
            ExpressionOperator runtimeOperator = selectionCriteria.getOperator();
            boolean usesNot = false;
            if (runtimeOperator == ExpressionOperator.getOperator((Integer)new Integer(3))) {
                selectionCriteria = ((FunctionExpression)selectionCriteria).getBaseExpression();
                usesNot = true;
                runtimeOperator = selectionCriteria.getOperator();
            }
            if (runtimeOperator == ExpressionOperator.getOperator((Integer)new Integer(1))) {
                if (!usesNot) {
                    this.setOperatorType(AND);
                } else {
                    this.setOperatorType(NAND);
                }
            } else if (runtimeOperator == ExpressionOperator.getOperator((Integer)new Integer(2))) {
                if (!usesNot) {
                    this.setOperatorType(OR);
                } else {
                    this.setOperatorType(NOR);
                }
            } else {
                if (selectionCriteria.isFunctionExpression()) {
                    this.addExpression(MWBasicExpression.convertFromRuntime(this, selectionCriteria));
                    return;
                }
                if (selectionCriteria.isRelationExpression()) {
                    this.addExpression(MWBasicExpression.convertFromRuntime(this, selectionCriteria));
                    if (!usesNot) {
                        this.setOperatorType(AND);
                    } else {
                        this.setOperatorType(NAND);
                    }
                    return;
                }
            }
            Expression firstChild = ((LogicalExpression)selectionCriteria).getFirstChild();
            if (firstChild.isRelationExpression() || firstChild.isFunctionExpression() && firstChild.getOperator() != ExpressionOperator.getOperator((Integer)new Integer(3))) {
                this.addExpression(MWBasicExpression.convertFromRuntime(this, firstChild));
            } else {
                this.addExpression(MWCompoundExpression.convertFromRuntime(this, firstChild));
            }
            Expression secondChild = ((LogicalExpression)selectionCriteria).getSecondChild();
            if (secondChild.isRelationExpression() || secondChild.isFunctionExpression() && secondChild.getOperator() != ExpressionOperator.getOperator((Integer)new Integer(3))) {
                this.addExpression(MWBasicExpression.convertFromRuntime(this, secondChild));
            } else {
                this.addExpression(MWCompoundExpression.convertFromRuntime(this, secondChild));
            }
        }
    }

    public Node.Validator getValidator() {
        return NULL_VALIDATOR;
    }

    private class PropertyChangeHolder {
        private String propertyChangeName;
        private Undoable container;
        private Object oldValue;
        private Object newValue;

        private PropertyChangeHolder(Undoable container, String propertyName, Object oldValue, Object newValue) {
            this.container = container;
            this.propertyChangeName = propertyName;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        private PropertyChangeHolder(Undoable container, String propertyName, Object newValue) {
            this(container, propertyName, null, newValue);
        }

        protected void undoChange() {
            this.container.undoChange(this.propertyChangeName, this.oldValue, this.newValue);
        }
    }
}

