/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model;

import java.util.List;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.MWArgument;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.MWCompoundExpression;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.MWExpression;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.MWLiteralArgument;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.MWNullArgument;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.MWQueryParameterArgument;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.MWQueryable;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.MWQueryableArgument;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.MWQueryableArgumentParent;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.TopLinkDescriptorUtilities;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.Undoable;
import oracle.toplink.workbench.utility.node.Node;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionOperator;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.expressions.RelationExpression;
import org.eclipse.persistence.queries.DatabaseQuery;

public final class MWBasicExpression
extends MWExpression
implements MWQueryableArgumentParent {
    private volatile MWQueryableArgument firstArgument;
    public static final String FIRST_ARUGMENT_PROPERTY = "firstArgument";
    private volatile MWArgument secondArgument;
    public static final String SECOND_ARGUMENT_PROPERTY = "secondArgument";
    public static final String EQUAL = "EQUAL";
    public static final String EQUALS_IGNORE_CASE = "EQUALS IGNORE CASE";
    public static final String GREATER_THAN = "GREATER THAN";
    public static final String GREATER_THAN_EQUAL = "GREATER THAN EQUAL";
    public static final String LESS_THAN = "LESS THAN";
    public static final String LESS_THAN_EQUAL = "LESS THAN EQUAL";
    public static final String LIKE = "LIKE";
    public static final String LIKE_IGNORE_CASE = "LIKE IGNORE CASE";
    public static final String NOT_EQUAL = "NOT EQUAL";
    public static final String NOT_LIKE = "NOT LIKE";
    public static final String IS_NULL = "IS NULL";
    public static final String NOT_NULL = "NOT NULL";

    protected MWBasicExpression() {
    }

    MWBasicExpression(MWCompoundExpression parent, String operator) {
        super(parent, operator);
    }

    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.firstArgument);
        children.add(this.secondArgument);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.firstArgument = this.createDefaultQueryableArgument();
        this.secondArgument = this.createDefaultLiteralArgument();
    }

    private RelationalDescriptor getOwningDescriptor() {
        return (RelationalDescriptor)this.getParentQuery().getDescriptor();
    }

    MWQueryableArgument createDefaultQueryableArgument() {
        MWQueryable queryable = TopLinkDescriptorUtilities.firstQueryable(this.getOwningDescriptor());
        return new MWQueryableArgument((MWQueryableArgumentParent)this, queryable);
    }

    @Override
    void recalculateQueryables() {
        this.getFirstArgument().recalculateQueryables();
        this.getSecondArgument().recalculateQueryables();
    }

    public String displayString() {
        String displayString = this.getFirstArgument().displayString() + " " + this.getOperatorType();
        displayString = displayString + " " + this.getSecondArgument().displayString();
        return displayString;
    }

    public MWQueryableArgument getFirstArgument() {
        return this.firstArgument;
    }

    @Override
    public String getIndex() {
        return this.getParentCompoundExpression().getIndex() + Integer.toString(this.getParentCompoundExpression().getIndexOf(this)) + ".";
    }

    @Override
    public DatabaseQuery getParentQuery() {
        return this.getParentCompoundExpression().getParentQuery();
    }

    @Override
    public MWCompoundExpression getParentCompoundExpression() {
        return (MWCompoundExpression)this.getParent();
    }

    @Override
    public MWCompoundExpression getRootCompoundExpression() {
        return this.getParentCompoundExpression().getRootCompoundExpression();
    }

    public MWArgument getSecondArgument() {
        return this.secondArgument;
    }

    private void setSecondArgument(MWArgument secondArgument) {
        if (this.operatorIsUnary(this.getOperatorType()) && !(secondArgument instanceof MWNullArgument)) {
            return;
        }
        MWArgument oldSecondArgument = this.getSecondArgument();
        this.secondArgument = secondArgument;
        this.firePropertyChanged(SECOND_ARGUMENT_PROPERTY, oldSecondArgument, this.getSecondArgument());
        this.getRootCompoundExpression().propertyChanged(this, SECOND_ARGUMENT_PROPERTY, oldSecondArgument, secondArgument);
    }

    public void setSecondArgumentToLiteral() {
        if (this.getSecondArgument().getType() != "literal") {
            this.setSecondArgument(this.createDefaultLiteralArgument());
        }
    }

    public void setSecondArgumentToParameter() {
        if (this.getSecondArgument().getType() != "parameter") {
            this.setSecondArgument(this.createDefaultQueryParameterArgument());
        }
    }

    public void setSecondArgumentToQueryable() {
        if (this.getSecondArgument().getType() != "queryKey") {
            this.setSecondArgument(this.createDefaultQueryableArgument());
        }
    }

    private MWLiteralArgument createDefaultLiteralArgument() {
        return new MWLiteralArgument(this);
    }

    private MWQueryParameterArgument createDefaultQueryParameterArgument() {
        String parameter = null;
        if (this.getParentQuery().getArguments().size() > 0) {
            parameter = (String)this.getParentQuery().getArguments().get(0);
        }
        return new MWQueryParameterArgument(this, parameter);
    }

    @Override
    public void clearExpressions() {
    }

    @Override
    public void undoChange(String propertyName, Object oldValue, Object newValue) {
        super.undoChange(propertyName, oldValue, newValue);
        if (propertyName == FIRST_ARUGMENT_PROPERTY) {
            this.setFirstArgument((MWQueryableArgument)oldValue);
        }
        if (propertyName == SECOND_ARGUMENT_PROPERTY) {
            this.setSecondArgument((MWArgument)oldValue);
        }
    }

    @Override
    public void propertyChanged(Undoable container, String propertyName, Object oldValue, Object newValue) {
        this.getRootCompoundExpression().propertyChanged(container, propertyName, oldValue, newValue);
    }

    protected void setFirstArgument(MWQueryableArgument firstArgument) {
        MWQueryableArgument oldFirstArgument = this.getFirstArgument();
        this.firstArgument = firstArgument;
        this.firePropertyChanged(FIRST_ARUGMENT_PROPERTY, oldFirstArgument, this.getFirstArgument());
        this.getRootCompoundExpression().propertyChanged(this, FIRST_ARUGMENT_PROPERTY, oldFirstArgument, firstArgument);
    }

    private boolean operatorIsUnary(String operator) {
        return operator == IS_NULL || operator == NOT_NULL;
    }

    private boolean operatorTypeHasChangedBetweenBinaryAndUnary(String oldOperatorType, String operatorType) {
        if (!this.operatorIsUnary(oldOperatorType)) {
            return this.operatorIsUnary(operatorType);
        }
        return !this.operatorIsUnary(operatorType);
    }

    @Override
    public void setOperatorType(String operatorType) {
        String oldOperatorType = this.getOperatorType();
        super.setOperatorType(operatorType);
        if (this.operatorTypeHasChangedBetweenBinaryAndUnary(oldOperatorType, operatorType)) {
            if (this.operatorIsUnary(operatorType)) {
                this.setSecondArgument(new MWNullArgument(this));
            } else {
                this.setSecondArgumentToLiteral();
            }
        }
        if (this.operatorIsStringType()) {
            this.getSecondArgument().operatorTypeChanged();
        }
    }

    public boolean operatorIsStringType() {
        return this.getOperatorType() == EQUALS_IGNORE_CASE || this.getOperatorType() == LIKE || this.getOperatorType() == LIKE_IGNORE_CASE || this.getOperatorType() == NOT_LIKE;
    }

    @Override
    public void toString(StringBuffer sb) {
        super.toString(sb);
        sb.append("firstArgument = ");
        sb.append(this.getFirstArgument());
        sb.append(", operator = ");
        sb.append(this.getOperatorType());
    }

    @Override
    Expression buildRuntimeExpression(ExpressionBuilder builder) {
        Expression firstExpression = this.getFirstArgument().runtimeExpression(builder);
        Expression secondExpression = this.getSecondArgument().runtimeExpression(builder);
        if (this.getOperatorType() == EQUAL) {
            return firstExpression.equal(secondExpression);
        }
        if (this.getOperatorType() == GREATER_THAN) {
            return firstExpression.greaterThan(secondExpression);
        }
        if (this.getOperatorType() == GREATER_THAN_EQUAL) {
            return firstExpression.greaterThanEqual(secondExpression);
        }
        if (this.getOperatorType() == LESS_THAN) {
            return firstExpression.lessThan(secondExpression);
        }
        if (this.getOperatorType() == LESS_THAN_EQUAL) {
            return firstExpression.lessThanEqual(secondExpression);
        }
        if (this.getOperatorType() == NOT_EQUAL) {
            return firstExpression.notEqual(secondExpression);
        }
        if (this.getOperatorType() == EQUALS_IGNORE_CASE) {
            return firstExpression.equalsIgnoreCase(secondExpression);
        }
        if (this.getOperatorType() == LIKE) {
            return firstExpression.like(secondExpression);
        }
        if (this.getOperatorType() == LIKE_IGNORE_CASE) {
            return firstExpression.likeIgnoreCase(secondExpression);
        }
        if (this.getOperatorType() == NOT_LIKE) {
            return firstExpression.notLike(secondExpression);
        }
        if (this.getOperatorType() == IS_NULL) {
            return firstExpression.isNull();
        }
        if (this.getOperatorType() == NOT_NULL) {
            return firstExpression.notNull();
        }
        throw new IllegalStateException("Operator type: " + this.getOperatorType() + " is not supported");
    }

    static MWBasicExpression convertFromRuntime(MWCompoundExpression parent, Expression expression) {
        ExpressionOperator runtimeOperator = expression.getOperator();
        String bldrOperator = EQUAL;
        if (runtimeOperator == ExpressionOperator.getOperator((Integer)new Integer(4))) {
            bldrOperator = EQUAL;
        } else if (runtimeOperator == ExpressionOperator.getOperator((Integer)new Integer(5))) {
            bldrOperator = NOT_EQUAL;
        } else if (runtimeOperator == ExpressionOperator.getOperator((Integer)new Integer(7))) {
            bldrOperator = LESS_THAN;
        } else if (runtimeOperator == ExpressionOperator.getOperator((Integer)new Integer(8))) {
            bldrOperator = LESS_THAN_EQUAL;
        } else if (runtimeOperator == ExpressionOperator.getOperator((Integer)new Integer(9))) {
            bldrOperator = GREATER_THAN;
        } else if (runtimeOperator == ExpressionOperator.getOperator((Integer)new Integer(10))) {
            bldrOperator = GREATER_THAN_EQUAL;
        } else if (runtimeOperator == ExpressionOperator.getOperator((Integer)new Integer(11))) {
            bldrOperator = LIKE;
        } else if (runtimeOperator == ExpressionOperator.getOperator((Integer)new Integer(12))) {
            bldrOperator = NOT_LIKE;
        } else if (runtimeOperator == ExpressionOperator.getOperator((Integer)new Integer(17))) {
            bldrOperator = IS_NULL;
        } else if (runtimeOperator == ExpressionOperator.getOperator((Integer)new Integer(18))) {
            bldrOperator = NOT_NULL;
        }
        MWBasicExpression bldrExpression = new MWBasicExpression(parent, bldrOperator);
        if (bldrOperator == NOT_NULL || bldrOperator == IS_NULL) {
            Expression firstChildExpression = ((FunctionExpression)expression).getBaseExpression();
            bldrExpression.setFirstArgument(MWQueryableArgument.convertFromRuntime(bldrExpression, (QueryKeyExpression)firstChildExpression));
        } else {
            Expression firstChildExpression = ((RelationExpression)expression).getFirstChild();
            if (firstChildExpression.isFunctionExpression()) {
                firstChildExpression = ((FunctionExpression)firstChildExpression).getBaseExpression();
                if (bldrExpression.getOperatorType() == EQUAL) {
                    bldrExpression.setOperatorType(EQUALS_IGNORE_CASE);
                } else {
                    bldrExpression.setOperatorType(LIKE_IGNORE_CASE);
                }
            }
            bldrExpression.setFirstArgument(MWQueryableArgument.convertFromRuntime(bldrExpression, (QueryKeyExpression)firstChildExpression));
            Expression secondChildExpression = ((RelationExpression)expression).getSecondChild();
            if (secondChildExpression.isFunctionExpression()) {
                secondChildExpression = ((FunctionExpression)secondChildExpression).getBaseExpression();
            }
            if (secondChildExpression.isQueryKeyExpression()) {
                bldrExpression.setSecondArgument(MWQueryableArgument.convertFromRuntime(bldrExpression, (QueryKeyExpression)secondChildExpression));
            } else if (secondChildExpression.isConstantExpression()) {
                bldrExpression.setSecondArgument(MWLiteralArgument.convertFromRuntime(bldrExpression, (ConstantExpression)secondChildExpression));
            } else if (secondChildExpression.isParameterExpression()) {
                bldrExpression.setSecondArgument(MWQueryParameterArgument.convertFromRuntime(bldrExpression, (ParameterExpression)secondChildExpression));
            }
        }
        return bldrExpression;
    }
}

