/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.wsdl.WSDLException;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.share.nls.StringUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.tip.adapter.db.DBActivationSpec;
import oracle.tip.adapter.db.DBReadInteractionSpec;
import oracle.tip.adapter.db.api.TopLinkReadSpec;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterUtil;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.model.MWCompoundExpression;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.ui.ExpressionBuilderDialog;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.eb.ui.UiQueryBundle;
import oracle.toplink.workbench.addin.TopLinkAddin;
import oracle.toplink.workbench.framework.context.WindowWorkbenchContext;
import oracle.toplink.workbench.framework.context.WorkbenchContext;
import oracle.toplink.workbench.framework.resources.IconResourceFileNameMap;
import oracle.toplink.workbench.mappingsplugin.MappingsPluginIconResourceFileNameMap;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;

public class XRAdapterWhereClausePage
extends techAdapterWizardPage
implements ActionListener,
ListSelectionListener,
XRAdapterPage {
    private MultiLineLabel instructionsLabel;
    private JTextArea sqlTextArea;
    private JLabel sqlTextLabel;
    private JButton editButton;
    private Color enabledSQLColour;
    private Color disabledSQLColour;
    private Color normalSQLColour;
    private Color errorSQLColour;
    private JLabel parametersLabel;
    private JList parametersList;
    private JButton removeButton;
    private JButton addButton;
    private JCheckBox returnSingleResultSetCheckBox;
    private String defaultSQLString = null;
    private boolean reenableNextAndFinish = false;
    public static final String s_ReturnSingleResultSet = "ReturnSingleResultSet";
    public static final String s_true = "true";
    public static final String s_false = "false";
    private XRAdapterWizardContext ascontext;

    public XRAdapterWhereClausePage(AdapterWizardContext context, ImageWizardPage page) {
        try {
            this.setContextAndPage(context, page);
            this.ascontext = (XRAdapterWizardContext)context._ascontext;
            this.ascontext._whereClausePage = this;
            this.initialize();
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)this.m_wcontext._parentFrame, (Exception)e);
        }
    }

    public void initialize() {
        this.setLayout(new GridBagLayout());
        this.disabledSQLColour = (Color)UIManager.getDefaults().get("TextField.inactiveBackground");
        this.enabledSQLColour = (Color)UIManager.getDefaults().get("TextArea.background");
        this.normalSQLColour = new JTextArea().getForeground();
        this.errorSQLColour = Color.RED;
        String instructionsText = this.getTranslatedString("DB_WC_INTRO_PROMPT_PARAMS");
        this.instructionsLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), instructionsText);
        this.parametersList = new JList();
        this.parametersList.setModel(new DefaultListModel());
        this.parametersList.setCellRenderer(new ParameterRenderer());
        this.parametersList.addListSelectionListener(this);
        String parametersString = this.getTranslatedString("DB_WC_PARAMS");
        this.parametersLabel = new JLabel(StringUtils.stripMnemonic((String)parametersString));
        this.parametersLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)parametersString));
        this.parametersLabel.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)parametersString));
        this.parametersLabel.setLabelFor(this.parametersList);
        String addString = this.getTranslatedString("DB_WC_ADD");
        this.addButton = new JButton(StringUtils.stripMnemonic((String)addString));
        this.addButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)addString));
        this.addButton.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)addString));
        this.addButton.addActionListener(this);
        String removeString = this.getTranslatedString("DB_WC_REMOVE");
        this.removeButton = new JButton(StringUtils.stripMnemonic((String)removeString));
        this.removeButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)removeString));
        this.removeButton.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)removeString));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(this);
        String editButtonString = this.getTranslatedString("DB_WC_EDIT");
        this.editButton = new JButton(StringUtils.stripMnemonic((String)editButtonString));
        this.editButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)editButtonString));
        this.editButton.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)editButtonString));
        this.editButton.addActionListener(this);
        String sqlTextLabelString = this.getTranslatedString("DB_WC_SQL");
        this.sqlTextLabel = new JLabel(StringUtils.stripMnemonic((String)sqlTextLabelString));
        this.sqlTextLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)sqlTextLabelString));
        this.sqlTextLabel.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)sqlTextLabelString));
        this.sqlTextLabel.setLabelFor(this.sqlTextArea);
        this.sqlTextArea = new JTextArea();
        this.sqlTextArea.setLineWrap(true);
        this.sqlTextArea.setWrapStyleWord(true);
        if (!this.ascontext._isOutboundSelectOp) {
            this.sqlTextArea.setEditable(false);
            this.sqlTextArea.setBackground(this.disabledSQLColour);
        }
        String returnSingleResultSetString = this.getTranslatedString("DB_WC_SINGLE_RESULT");
        this.returnSingleResultSetCheckBox = new JCheckBox(StringUtils.stripMnemonic((String)returnSingleResultSetString), false);
        this.returnSingleResultSetCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)returnSingleResultSetString));
        this.returnSingleResultSetCheckBox.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)returnSingleResultSetString));
        this.returnSingleResultSetCheckBox.addActionListener(this);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 4;
        constraints.gridheight = 1;
        this.add((Component)this.instructionsLabel, constraints);
        int topBorder = 30;
        constraints.anchor = 18;
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.insets = new Insets(30, 0, 0, 12);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.parametersLabel, constraints);
        constraints.anchor = 18;
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.insets = new Insets(30, 0, 0, 12);
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)new JScrollPane(this.parametersList), constraints);
        constraints.anchor = 11;
        constraints.gridx = 2;
        constraints.gridy = 1;
        constraints.insets = new Insets(30, 0, 0, 12);
        constraints.fill = 2;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.addButton, constraints);
        constraints.anchor = 11;
        constraints.gridx = 3;
        constraints.gridy = 1;
        constraints.insets = new Insets(30, 0, 0, 0);
        constraints.fill = 2;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.removeButton, constraints);
        topBorder = 12;
        constraints.anchor = 18;
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.insets = new Insets(topBorder, 0, 0, 12);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.sqlTextLabel, constraints);
        constraints.anchor = 11;
        constraints.gridx = 3;
        constraints.gridy = 3;
        constraints.insets = new Insets(topBorder, 0, 0, 0);
        constraints.fill = 2;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.editButton, constraints);
        constraints.anchor = 10;
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.insets = new Insets(topBorder, 0, 0, 12);
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        JScrollPane scrollPane = new JScrollPane(this.sqlTextArea);
        this.add((Component)scrollPane, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.insets = new Insets(12, 0, 0, 0);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        this.add((Component)this.returnSingleResultSetCheckBox, constraints);
        if (this.m_wcontext._read_service != null) {
            this.populateUIForEdit();
            XRAdapterUtil.refreshSQLPanes(this.m_wcontext);
        }
    }

    private void populateUIForEdit() {
        Object returnSingleResultSetProp = this.ascontext._dtProps.get("return_single_result_set");
        if (returnSingleResultSetProp == null) {
            return;
        }
        String returnSingleResultSet = returnSingleResultSetProp.toString();
        if (returnSingleResultSet.equals(s_true)) {
            this.returnSingleResultSetCheckBox.setSelected(true);
        } else {
            this.returnSingleResultSetCheckBox.setSelected(false);
        }
    }

    private WorkbenchContext buildWorkbenchContext() {
        WorkbenchContext workbenchContext = TopLinkAddin.getAddin().buildWorkbenchContext();
        workbenchContext = workbenchContext.buildExpandedResourceRepositoryContext(UiQueryBundle.class);
        workbenchContext = workbenchContext.buildExpandedResourceRepositoryContext((IconResourceFileNameMap)new MappingsPluginIconResourceFileNameMap());
        return new WindowWorkbenchContext(workbenchContext, (Window)this.m_wcontext._parentFrame);
    }

    public void setSQL(String sql, boolean error) {
        this.sqlTextArea.setForeground(error ? this.errorSQLColour : this.normalSQLColour);
        this.sqlTextArea.setText(sql);
        this.defaultSQLString = sql;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DatabaseQuery query;
        XRAdapterWizardContext context;
        if (e.getSource() == this.editButton) {
            XRAdapterWizardContext.setStaticORProject(this.ascontext._orProject);
            MWCompoundExpression mwExpression = MWCompoundExpression.convertFromRuntime(this.ascontext._query, this.ascontext._query.getSelectionCriteria());
            ExpressionBuilderDialog dialog = new ExpressionBuilderDialog(mwExpression, 0, this.buildWorkbenchContext());
            dialog.show();
            if (dialog.wasConfirmed()) {
                Expression expression = mwExpression.buildRuntimeExpression(new ExpressionBuilder());
                this.ascontext._query.setSelectionCriteria(expression);
                this.populateParametersList();
                XRAdapterUtil.refreshSQLPanes(this.m_wcontext);
            }
        }
        if (e.getSource() == this.addButton) {
            context = (XRAdapterWizardContext)this.m_wcontext._ascontext;
            query = context._query;
            String dialogTitle = this.getTranslatedString("DB_WC_ADDPARAM_TITLE");
            String dialogText = this.getTranslatedString("DB_WC_ADDPARAM_TEXT");
            String paramName = JOptionPane.showInputDialog(this, dialogText, dialogTitle, -1);
            if (paramName != null && !query.getArguments().contains(paramName)) {
                query.addArgument(paramName, String.class);
                this.populateParametersList();
            }
        }
        if (e.getSource() == this.removeButton) {
            context = (XRAdapterWizardContext)this.m_wcontext._ascontext;
            query = context._query;
            Object[] selectedValues = this.parametersList.getSelectedValues();
            for (int i = 0; i < selectedValues.length; ++i) {
                Object param = selectedValues[i];
                context.paramsToDelete.add(param);
                int index = query.getArguments().indexOf(param);
                if (index <= -1) continue;
                query.getArgumentTypes().remove(index);
                query.getArguments().remove(index);
            }
            this.populateParametersList();
            XRAdapterUtil.refreshSQLPanes(this.m_wcontext);
        }
        if (e.getSource() == this.returnSingleResultSetCheckBox) {
            XRAdapterUtil.refreshSQLPanes(this.m_wcontext);
        }
    }

    public void populateParametersList() {
        DefaultListModel model = (DefaultListModel)this.parametersList.getModel();
        model.removeAllElements();
        XRAdapterWizardContext context = (XRAdapterWizardContext)this.m_wcontext._ascontext;
        DatabaseQuery query = context._query;
        Iterator it = query.getArguments().iterator();
        while (it.hasNext()) {
            model.addElement(it.next());
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        this.removeButton.setEnabled(!this.parametersList.isSelectionEmpty());
    }

    @Override
    public void buildWSDL() throws WSDLException {
        String returnSingleResultSet;
        String string = returnSingleResultSet = this.returnSingleResultSetCheckBox.isSelected() ? s_true : s_false;
        if (this.ascontext._inboundSelectOp != null) {
            this.ascontext._inboundSelectOp.setAttributeValue(s_ReturnSingleResultSet, returnSingleResultSet);
        } else if (this.ascontext._outboundSelectOp != null) {
            this.ascontext._outboundSelectOp.setAttributeValue(s_ReturnSingleResultSet, returnSingleResultSet);
        }
    }

    @Override
    public void wizardValidatePage(WizardEvent event) {
        if (this.defaultSQLString != null && !this.defaultSQLString.equals(this.sqlTextArea.getText())) {
            this.ascontext._query.setSQLString(this.sqlTextArea.getText());
        }
    }

    @Override
    public void buildSpec(TopLinkReadSpec spec) {
        String returnSingleResultSet = this.returnSingleResultSetCheckBox.isSelected() ? s_true : s_false;
        this.ascontext._dtProps.put("return_single_result_set", returnSingleResultSet);
        if (spec instanceof DBActivationSpec) {
            DBActivationSpec activationSpec = (DBActivationSpec)spec;
            activationSpec.setReturnSingleResultSet(returnSingleResultSet);
        }
        if (spec instanceof DBReadInteractionSpec) {
            DBReadInteractionSpec interactionSpec = (DBReadInteractionSpec)spec;
            interactionSpec.setReturnSingleResultSet(returnSingleResultSet);
        }
    }

    private class ParameterRenderer
    extends DefaultListCellRenderer {
        private ParameterRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            return label;
        }
    }
}

