/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr;

import java.awt.Component;
import java.awt.Window;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Connection;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.Wizard;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;
import oracle.integration.platform.blocks.adapter.fw.metadata.migration.JcaMigrationHelper;
import oracle.integration.platform.blocks.adapter.fw.metadata.migration.JcaMigrationResult;
import oracle.integration.platform.blocks.adapter.fw.metadata.migration.JcaParsedResult;
import oracle.j2ee.ws.wsdl.extensions.schema.Constants;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.tip.adapter.db.DBActivationSpec;
import oracle.tip.adapter.db.DBAdapterConstants;
import oracle.tip.adapter.db.DBReadInteractionSpec;
import oracle.tip.adapter.db.api.TopLinkReadSpec;
import oracle.tip.adapter.db.util.ArtifactsUtil;
import oracle.tip.tools.ide.pm.addin.application.PMProjectSettings;
import oracle.tip.tools.ide.pm.addin.model.XMLNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.DatabaseConnectionInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.ImportSchema;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.util.SQLRefresher;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLParseException;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.platform.database.DB2Platform;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.platform.database.InformixPlatform;
import org.eclipse.persistence.platform.database.MySQLPlatform;
import org.eclipse.persistence.platform.database.SQLServerPlatform;
import org.eclipse.persistence.platform.database.SybasePlatform;
import org.eclipse.persistence.platform.database.oracle.Oracle10Platform;
import org.eclipse.persistence.platform.database.oracle.Oracle9Platform;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.factories.XMLProjectReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class XRAdapterUtil {
    public static final String OR_MAPPINGS_FILENAME_SUFFIX = "-or-mappings.xml";
    public static final String OX_MAPPINGS_FILENAME_SUFFIX = "-ox-mappings.xml";
    public static final String DESIGN_TIME_PROPS_FILENAME_SUFFIX = "-properties.xml";
    public static final String DTPROPS_DB_TABLE_TYPE_SUFFIX = ":db_table_type";
    public static final String DTPROPS_DB_COL_TYPE_SUFFIX = ":db_column_type";
    public static final String DTPROPS_DB_COL_SQL_TYPE_SUFFIX = ":db_column_sql_type";
    public static final String DTPROPS_DB_COL_SIZE_SUFFIX = ":db_column_size";
    public static final String DTPROPS_DB_COL_PRECISION_SUFFIX = ":db_column_precision";
    public static final String DTPROPS_DB_COL_SCALE_SUFFIX = ":db_column_scale";
    public static final String DTPROPS_DB_COL_NOT_NULL_SUFFIX = ":db_column_not_null";
    public static final String DTPROPS_DB_COL_SUFFIX = ":db_column_";
    public static final String DTPROPS_PK_COL_SUFFIX = ":pk_column_";
    public static final String ROOT_DESCRIPTOR_ALIAS = "root_descriptor_alias";
    public static final String COLLECTION_SUFFIX = "Collection";
    public static final String RETURN_SINGLE_RESULT_SET = "return_single_result_set";
    public static AdapterWizardContext m_wcontext;
    protected static Map sqlTypeToJavaTypeMap;

    public static void setFinishPage(techAdapterWizardPage wizPage) {
        wizPage.addFinishPage();
        MessageFormat msgformat = new MessageFormat(wizPage.getTranslatedString("DB_FN_PROMPT"));
        Object[] args = new Object[]{XRAdapterUtil.getServiceName(wizPage.m_wcontext)};
        String finishPrompt = msgformat.format(args);
        msgformat = new MessageFormat(wizPage.getTranslatedString("DB_FN_SUMMARY"));
        args = new Object[]{wizPage.m_wcontext._write_wsdl_name};
        String finishInfo = msgformat.format(args);
        wizPage.setFinishPageContents(finishPrompt, finishInfo);
    }

    public static String toXmlName(String dbName, boolean forClass) {
        String converted = dbName;
        char[] chars = new char[converted.length()];
        converted.getChars(0, chars.length, chars, 0);
        char[] finalWord = new char[converted.length() + 1];
        boolean startOfWord = forClass;
        boolean lastWasDigit = false;
        boolean atStart = true;
        int pos = 0;
        int i = 0;
        for (i = 0; i < chars.length; ++i) {
            if (chars[i] == '\"' || chars[i] == '\'') continue;
            if (atStart && !Character.isLetter(chars[i])) {
                finalWord[pos++] = 95;
                if (!Character.isDigit(chars[i])) continue;
                finalWord[pos++] = chars[i];
                continue;
            }
            atStart = false;
            if (!Character.isLetter(chars[i]) && !Character.isDigit(chars[i])) {
                if (!startOfWord) {
                    startOfWord = true;
                } else {
                    finalWord[pos++] = 95;
                }
                lastWasDigit = false;
                continue;
            }
            if (Character.isDigit(chars[i])) {
                lastWasDigit = true;
                finalWord[pos++] = chars[i];
                continue;
            }
            if (startOfWord || lastWasDigit) {
                startOfWord = false;
                lastWasDigit = false;
                finalWord[pos++] = Character.toUpperCase(chars[i]);
                continue;
            }
            finalWord[pos++] = Character.toLowerCase(chars[i]);
        }
        return new String(finalWord, 0, pos);
    }

    public static String getJavaClassNameFromTable(DatabaseTable table) {
        return XRAdapterUtil.toXmlName(table.getName(), true);
    }

    public static String getJavaAttributeNameFromColumn(DatabaseField field) {
        return XRAdapterUtil.toXmlName(field.getName(), false);
    }

    public static Class getJavaTypeFromSQLType(String name, Integer size, Integer subSize, DatabasePlatform platform) {
        name = name.substring(name.indexOf(58) + 1).toUpperCase();
        Class result = null;
        while (true) {
            if ((name.equals("NUMBER") || name.equals("NUMERIC")) && size != null && subSize != null && size != 0 && subSize == 0) {
                if (size != null && size < 10) {
                    return Integer.class;
                }
                if (size < 19) {
                    return Long.class;
                }
            }
            if (platform != null) {
                result = (Class)platform.getClassTypes().get(name);
            }
            if (result == null) {
                result = (Class)XRAdapterUtil.sqlTypeToJavaTypeMap().get(name);
            }
            if (result != null || name.indexOf(" IDENTITY") <= -1) break;
            name = name.substring(0, name.indexOf(" IDENTITY")).trim();
        }
        if (result == null && name.indexOf("TIMESTAMP(") > -1) {
            result = ClassConstants.TIMESTAMP;
        }
        if (result == null) {
            result = ClassConstants.OBJECT;
        }
        return result;
    }

    public static Map sqlTypeToJavaTypeMap() {
        if (sqlTypeToJavaTypeMap == null) {
            sqlTypeToJavaTypeMap = XRAdapterUtil.buildSqlTypeToJavaTypeMap();
        }
        return sqlTypeToJavaTypeMap;
    }

    protected static Map buildSqlTypeToJavaTypeMap() {
        HashMap<String, Class> result = new HashMap<String, Class>();
        Class byteClass = ClassConstants.APBYTE;
        Class charClass = ClassConstants.APCHAR;
        try {
            result.put("VARCHAR", String.class);
            result.put("NVARCHAR", String.class);
            result.put("VARCHAR2", String.class);
            result.put("NVARCHAR2", String.class);
            result.put("TEXT", String.class);
            result.put("MEMO", String.class);
            result.put("CHAR", String.class);
            result.put("NCHAR", String.class);
            result.put("NUMERIC", BigDecimal.class);
            result.put("NUMBER", BigDecimal.class);
            result.put("BIT", Boolean.class);
            result.put("TINYINT", Byte.class);
            result.put("SMALLINT", Short.class);
            result.put("INTEGER", BigInteger.class);
            result.put("INT", Integer.class);
            result.put("BIGINT", BigInteger.class);
            result.put("LONG", String.class);
            result.put("REAL", Double.class);
            result.put("FLOAT", Double.class);
            result.put("FLOAT16", Double.class);
            result.put("FLOAT32", Double.class);
            result.put("DOUBLE", Double.class);
            result.put("DOUBLE PRECIS", Double.class);
            result.put("DATE", Timestamp.class);
            result.put("DATETIME", Timestamp.class);
            result.put("TIME", Time.class);
            result.put("TIMESTAMP", Timestamp.class);
            result.put("TIMESTAMPTZ", Calendar.class);
            result.put("TIMESTAMPLTZ", Calendar.class);
            result.put("TIMESTAMP(6)", Timestamp.class);
            result.put("TIMESTAMP(6) WITH TIME ZONE", Calendar.class);
            result.put("TIMESTAMP(6) WITH LOCAL TIME ZONE", Calendar.class);
            result.put("TIMESTAMP WITH TIME ZONE", Calendar.class);
            result.put("TIMESTAMP WITH LOCAL TIME ZONE", Calendar.class);
            result.put("BLOB", byteClass);
            result.put("CLOB", charClass);
            result.put("NCLOB", charClass);
            result.put("RAW", byteClass);
            result.put("FLOAT(16)", Double.class);
            result.put("FLOAT(32)", Double.class);
            result.put("SHORT", Short.class);
            result.put("BYTE", Byte.class);
            result.put("LONGVARBINARY", byteClass);
            result.put("LONGTEXT", charClass);
            result.put("BINARY", byteClass);
            result.put("LONG RAW", byteClass);
            result.put("IMAGE", byteClass);
            result.put("LONGVARCHAR", charClass);
            result.put("VARBINARY", byteClass);
            result.put("ROWID", Object.class);
            result.put("NUMBER(1) DEFAULT 0", Boolean.class);
            result.put("SMALLINT DEFAULT 0", Boolean.class);
            result.put("SERIAL", Integer.class);
            result.put("DECIMAL", BigDecimal.class);
            result.put("TEXT", charClass);
            result.put("NTEXT", charClass);
            result.put("BOOLEAN", Boolean.class);
            result.put("CHARACTER", String.class);
            result.put("CHARACTER VARYING", String.class);
            result.put("BIGINT", BigInteger.class);
            result.put("GRAPHIC", byteClass);
            result.put("VARGRAPHIC", byteClass);
            result.put("DBCLOB", byteClass);
            result.put("CHAR () FOR BIT DATA", byteClass);
            result.put("VARCHAR () FOR BIT DATA", byteClass);
            result.put("LONG VARCHAR FOR BIT DATA", byteClass);
            result.put("UNIQUEIDENTIFIER", BigDecimal.class);
            result.put("SMALLDATETIME", Timestamp.class);
            result.put("MONEY", BigDecimal.class);
            result.put("SMALLMONEY", BigDecimal.class);
            result.put("UNICHAR", String.class);
            result.put("UNIVARCHAR", String.class);
            result.put("SYSNAME", String.class);
            result.put("NATIONAL CHARACTER", String.class);
            result.put("NATIONAL CHAR", String.class);
            result.put("NATIONAL CHARACTER VARYING", String.class);
            result.put("NATIONAL CHAR VARYING", String.class);
            result.put("NCHAR VARYING", String.class);
            result.put("BIT VARYING", byteClass);
        }
        catch (Throwable t) {
            ExceptionDialog.showExceptionDialog((Component)XRAdapterUtil.m_wcontext._parentFrame, (Throwable)t);
        }
        return result;
    }

    public static void readTopLinkProjectFiles(AdapterWizardContext context) {
        XRAdapterWizardContext ascontext = (XRAdapterWizardContext)context._ascontext;
        try {
            File orFile = new File(context.getFilePath(), context._read_service_name + OR_MAPPINGS_FILENAME_SUFFIX);
            ascontext._orProject = XMLProjectReader.read((String)orFile.getPath(), (ClassLoader)ArtifactsUtil.getLoader());
            XRAdapterUtil.initORProject(ascontext._orProject, context);
            for (RelationalDescriptor descriptor : ascontext._orProject.getDescriptors().values()) {
                if (descriptor.getTables().size() > 0) {
                    ascontext.tablesToDescriptors.put(descriptor.getTables().get(0), descriptor);
                    continue;
                }
                ascontext.tablesToDescriptors.put("no-table", descriptor);
            }
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)XRAdapterUtil.m_wcontext._parentFrame, (Exception)e);
        }
    }

    public static String getExistingXSDImportURI(AdapterWizardContext context) throws Exception {
        String schemaURI = null;
        Definition def1 = context._read_definition;
        Types typ1 = def1.getTypes();
        if (typ1 != null) {
            List typL = typ1.getExtensibilityElements();
            for (Object exel : typL) {
                org.w3c.dom.Node node;
                if (exel instanceof ImportSchema) {
                    ImportSchema impsch = (ImportSchema)exel;
                    schemaURI = ((ImportSchema)exel).getLocation();
                    break;
                }
                if (!(exel instanceof UnknownExtensibilityElement)) continue;
                UnknownExtensibilityElement uee = (UnknownExtensibilityElement)exel;
                for (node = uee.getElement().getFirstChild(); node != null && !(node instanceof Element); node = node.getNextSibling()) {
                }
                schemaURI = ((Element)node).getAttribute("schemaLocation");
                break;
            }
        }
        return schemaURI;
    }

    public static URL getXSDFileURL(AdapterWizardContext context, XRAdapterWizardContext ascontext, String name) {
        URL xsdFileURL = null;
        if (ascontext._oldXsdFilePath != null) {
            xsdFileURL = URLFactory.newURL((String)(context.getFilePath() + File.separator + ascontext._oldXsdFilePath));
        } else {
            try {
                new File(context.getSchemaFilePath()).mkdir();
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
            }
            xsdFileURL = URLFactory.newURL((String)(context.getSchemaFilePath() + File.separator + name));
        }
        return xsdFileURL;
    }

    public static boolean writeTopLinkProjectFiles(AdapterWizardContext context) {
        XRAdapterWizardContext ascontext = (XRAdapterWizardContext)context._ascontext;
        Project orProject = ascontext._orProject;
        String toplinkXmlFileName = context._write_service_name + OR_MAPPINGS_FILENAME_SUFFIX;
        String descriptorName = ascontext._rootDescriptor.getJavaClassName();
        String xsdFileName = context._write_encoded_service_name + "_table.xsd";
        String topNamespace = DBAdapterConstants.xsdNamespace((String)XRAdapterUtil.getPackageName(context));
        String targetDir = context.getFilePath();
        Properties properties = ascontext._dtProps;
        boolean isForInbound = context._isInboundOperation;
        URL xsdFileURL = XRAdapterUtil.getXSDFileURL(context, ascontext, xsdFileName);
        boolean useTopLinkOToX = false;
        ArtifactsUtil artUtil = new ArtifactsUtil(orProject, toplinkXmlFileName, descriptorName, xsdFileName, topNamespace, targetDir, properties, isForInbound, useTopLinkOToX);
        if (ascontext._isOutboundSelectOp) {
            artUtil.setQueryNames(new String[]{ascontext._query.getName()});
        } else {
            artUtil.setQueryNames(new String[0]);
        }
        artUtil.setNeedsEmptyElement(ascontext._operationPage.isSynchPostSelected());
        artUtil.setHasNonCollectionRootElement(ascontext._operationPage.isQueryByExampleSelected());
        try {
            File orMappingsFile = new File(context.getFilePath(), context._write_service_name + OR_MAPPINGS_FILENAME_SUFFIX);
            artUtil.writeMappingsXml();
            URL orMappingsFileURL = orMappingsFile.toURL();
            Node orMappingsNode = NodeFactory.findOrCreate(XMLNode.class, (URL)orMappingsFileURL);
            PMProjectSettings.addToProject(context._project, orMappingsNode);
            context.addURL(orMappingsFileURL);
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)XRAdapterUtil.m_wcontext._parentFrame, (Exception)e);
            return false;
        }
        try {
            artUtil.setXsdFileURL(xsdFileURL);
            artUtil.writeXSD();
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)XRAdapterUtil.m_wcontext._parentFrame, (Exception)e);
            return false;
        }
        return true;
    }

    public static boolean writeDesignTimePropertiesFile(AdapterWizardContext context) {
        XRAdapterWizardContext ascontext = (XRAdapterWizardContext)context._ascontext;
        File propsFile = new File(context.getFilePath(), context._write_service_name + DESIGN_TIME_PROPS_FILENAME_SUFFIX);
        try {
            FileOutputStream os = new FileOutputStream(propsFile);
            ascontext._dtProps.storeToXML(os, null);
            os.close();
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)XRAdapterUtil.m_wcontext._parentFrame, (Exception)e);
            return false;
        }
        return true;
    }

    public static void readDesignTimePropertiesFile(AdapterWizardContext context) {
        XRAdapterWizardContext ascontext = (XRAdapterWizardContext)context._ascontext;
        File propsFile = new File(context.getFilePath(), context._read_service_name + DESIGN_TIME_PROPS_FILENAME_SUFFIX);
        try {
            FileInputStream is = new FileInputStream(propsFile);
            ascontext._dtProps.loadFromXML(is);
            is.close();
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)XRAdapterUtil.m_wcontext._parentFrame, (Exception)e);
        }
    }

    public static String getPackageName(AdapterWizardContext context) {
        XRAdapterWizardContext ascontext = (XRAdapterWizardContext)context._ascontext;
        Object packageName = null;
        if (ascontext._orProject != null && ascontext._orProject.getDescriptors().size() > 0) {
            ClassDescriptor desc = (ClassDescriptor)ascontext._orProject.getDescriptors().values().iterator().next();
            return Helper.getPackageName((Class)desc.getJavaClass());
        }
        return context._write_service_name;
    }

    public static ClassDescriptor getDescriptorByTableName(Project project, String tableName) {
        for (ClassDescriptor desc : project.getDescriptors().values()) {
            String descTableName = desc.getAlias();
            if (!descTableName.equals(tableName)) continue;
            return desc;
        }
        return null;
    }

    public static ClassDescriptor getOXDescriptorForORDescriptor(Project oxProject, ClassDescriptor orDescriptor) {
        return oxProject.getDescriptor(orDescriptor.getJavaClass());
    }

    public static ClassDescriptor getDescriptorByClassName(Project project, String className) {
        for (ClassDescriptor desc : project.getDescriptors().values()) {
            String descClassName = desc.getJavaClassName();
            if (!descClassName.equals(className)) continue;
            return desc;
        }
        return null;
    }

    public static void removeDescriptorForTableName(AdapterWizardContext context, String tableNameToRemove) {
        XRAdapterWizardContext ascontext = (XRAdapterWizardContext)context._ascontext;
        ClassDescriptor orDescToRemove = XRAdapterUtil.getDescriptorByTableName(ascontext._orProject, tableNameToRemove);
        Vector mappings = orDescToRemove.getMappings();
        for (int i = 0; i < mappings.size(); ++i) {
            DatabaseMapping mapping = (DatabaseMapping)mappings.get(i);
            if (!mapping.isForeignReferenceMapping() || mapping.isOneToOneMapping() && ((OneToOneMapping)mapping).isForeignKeyRelationship()) continue;
            mappings.remove(i);
            --i;
            ForeignReferenceMapping frMapping = (ForeignReferenceMapping)mapping;
            XRAdapterUtil.relationshipRemoved(frMapping, (RelationalDescriptor)ascontext._orProject.getDescriptor(frMapping.getReferenceClass()), ascontext._orProject);
        }
        XRAdapterUtil.removeDescriptor(ascontext._orProject, orDescToRemove);
        for (RelationalDescriptor orDesc : ascontext._orProject.getDescriptors().values()) {
            Vector<ForeignReferenceMapping> mappingsToRemove = new Vector<ForeignReferenceMapping>();
            for (DatabaseMapping orMapping : orDesc.getMappings()) {
                ForeignReferenceMapping frMapping;
                if (!(orMapping instanceof ForeignReferenceMapping) || !(frMapping = (ForeignReferenceMapping)orMapping).getReferenceClassName().equals(orDescToRemove.getJavaClassName())) continue;
                mappingsToRemove.add(frMapping);
            }
            for (ForeignReferenceMapping frMapping : mappingsToRemove) {
                orDesc.getMappings().remove(frMapping);
                if (!frMapping.isOneToOneMapping() || !((OneToOneMapping)frMapping).isForeignKeyRelationship()) continue;
                XRAdapterUtil.relationshipRemoved(frMapping, orDesc, ascontext._orProject);
            }
        }
        Vector tables = orDescToRemove.getTables();
        Properties dbProps = ascontext._dtProps;
        block4: for (int i = 0; i < tables.size(); ++i) {
            DatabaseTable table = (DatabaseTable)tables.get(i);
            String tableName = table.getQualifiedName();
            boolean tryShortNameToo = true;
            int counter = 0;
            while (true) {
                String key = tableName + DTPROPS_DB_COL_SUFFIX + String.valueOf(counter);
                String value = dbProps.getProperty(key);
                boolean killTableType = true;
                if (value == null) {
                    if (counter != 0 || !tryShortNameToo) continue block4;
                    tryShortNameToo = false;
                    tableName = table.getName();
                    continue;
                }
                dbProps.remove(key);
                String baseKey = tableName + "." + value;
                if (killTableType) {
                    dbProps.remove(tableName + DTPROPS_DB_TABLE_TYPE_SUFFIX);
                    killTableType = false;
                }
                dbProps.remove(baseKey + DTPROPS_DB_COL_NOT_NULL_SUFFIX);
                dbProps.remove(baseKey + DTPROPS_DB_COL_PRECISION_SUFFIX);
                dbProps.remove(baseKey + DTPROPS_DB_COL_SCALE_SUFFIX);
                dbProps.remove(baseKey + DTPROPS_DB_COL_SIZE_SUFFIX);
                dbProps.remove(baseKey + DTPROPS_DB_COL_SQL_TYPE_SUFFIX);
                dbProps.remove(baseKey + DTPROPS_DB_COL_TYPE_SUFFIX);
                ++counter;
            }
        }
    }

    public static void removeDescriptor(Project project, ClassDescriptor desc) {
        Vector orderedDescriptors = project.getOrderedDescriptors();
        project.setAliasDescriptors(null);
        project.setDescriptors(new HashMap());
        orderedDescriptors.remove(desc);
        project.setOrderedDescriptors(orderedDescriptors);
    }

    public static ArrayList getColumnNamesFromDBProperties(Vector<DatabaseTable> tables, Properties dbProps) {
        ArrayList<Object> listToReturn = new ArrayList<Object>();
        block0: for (int i = 0; i < tables.size(); ++i) {
            DatabaseTable table = tables.get(i);
            String tableName = table.getQualifiedName();
            boolean tryShortNameToo = true;
            int counter = 0;
            while (true) {
                Object value;
                if ((value = dbProps.get(tableName + DTPROPS_DB_COL_SUFFIX + String.valueOf(counter))) == null) {
                    if (counter != 0 || !tryShortNameToo) continue block0;
                    tryShortNameToo = false;
                    tableName = table.getName();
                    continue;
                }
                listToReturn.add(value);
                ++counter;
            }
        }
        return listToReturn;
    }

    public static String getServiceName(AdapterWizardContext context) {
        if (context._write_service_name != null) {
            String serviceName = context._write_service_name.replaceAll(" ", "_");
            return serviceName;
        }
        String serviceName = context._read_service_name.replaceAll(" ", "_");
        return serviceName;
    }

    public static String guessDatabasePlatformClassName(DatabaseConnectionInfo dbConnInfo) {
        return XRAdapterUtil.guessDatabasePlatform(dbConnInfo).getClass().getName();
    }

    public static DatabasePlatform guessDatabasePlatform(DatabaseConnectionInfo dbConnInfo) {
        Object platform = null;
        if (dbConnInfo == null) {
            return new Oracle10Platform();
        }
        String driverClassName = dbConnInfo.getDriverClassName();
        if (driverClassName == null || driverClassName.indexOf("OracleDriver") > -1) {
            // empty if block
        }
        if (driverClassName != null && driverClassName.indexOf("DB2Driver") > -1) {
            return new DB2Platform();
        }
        if (driverClassName != null && driverClassName.indexOf("SQLServerDriver") > -1) {
            return new SQLServerPlatform();
        }
        if (driverClassName != null && driverClassName.indexOf("SybaseDriver") > -1) {
            return new SybasePlatform();
        }
        if (driverClassName != null && driverClassName.indexOf("com.mysql.jdbc.Driver") > -1) {
            return new MySQLPlatform();
        }
        Connection conn = dbConnInfo.getConnection();
        try {
            if (conn != null && conn.getMetaData().getDatabaseProductName().toUpperCase().indexOf("INFORMIX") > -1) {
                return new InformixPlatform();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return new Oracle9Platform();
    }

    public static void initORProject(Project project, AdapterWizardContext context) {
        DatabaseLogin login = new DatabaseLogin();
        login.setPlatform((Platform)XRAdapterUtil.guessDatabasePlatform(context.dbConnectionInfo));
        login.setUserName(null);
        login.setPassword(null);
        login.setConnectionString(null);
        login.setDriverClassName(null);
        project.setLogin(login);
        for (RelationalDescriptor desc : project.getDescriptors().values()) {
            for (DatabaseMapping mapping : desc.getMappings()) {
                AbstractDirectMapping adMapping;
                if (!mapping.isAbstractDirectMapping() || (adMapping = (AbstractDirectMapping)mapping).getAttributeClassification() != null || adMapping.getAttributeClassificationName() == null || adMapping.getAttributeClassificationName().length() <= 0) continue;
                try {
                    adMapping.setAttributeClassification(Class.forName(adMapping.getAttributeClassificationName()));
                }
                catch (ClassNotFoundException cnfe) {}
            }
        }
    }

    public static void relationshipAdded(ForeignReferenceMapping frMapping, RelationalDescriptor desc) {
        OneToOneMapping mapping;
        Collection<Object> fkFields = null;
        if (frMapping.isOneToOneMapping() && ((OneToOneMapping)frMapping).isForeignKeyRelationship()) {
            mapping = (OneToOneMapping)frMapping;
            fkFields = mapping.getForeignKeyFields();
        } else if (frMapping.isOneToOneMapping()) {
            mapping = (OneToOneMapping)frMapping;
            fkFields = mapping.getSourceToTargetKeyFields().values();
        } else {
            mapping = (OneToManyMapping)frMapping;
            fkFields = mapping.getTargetForeignKeyFields();
        }
        for (DatabaseField databaseField : fkFields) {
            DatabaseMapping mapping2 = DBAdapterConstants.getMappingForField((RelationalDescriptor)desc, (DatabaseField)databaseField);
            if (mapping2 == null || !mapping2.isDirectToFieldMapping()) continue;
            mapping2.setProperty((Object)"fkPlaceholder", (Object)"true");
            mapping2.setIsReadOnly(true);
        }
    }

    public static void relationshipRemoved(ForeignReferenceMapping frMapping, RelationalDescriptor desc, Project topLinkProject) {
        OneToOneMapping mapping;
        Collection<Object> fkFields = null;
        if (frMapping.isOneToOneMapping() && frMapping.isForeignReferenceMapping()) {
            mapping = (OneToOneMapping)frMapping;
            fkFields = mapping.getForeignKeyFields();
        } else if (frMapping.isOneToOneMapping()) {
            mapping = (OneToOneMapping)frMapping;
            fkFields = mapping.getSourceToTargetKeyFields().values();
        } else {
            mapping = (OneToManyMapping)frMapping;
            fkFields = mapping.getTargetForeignKeyFields();
        }
        for (DatabaseField databaseField : fkFields) {
            ForeignReferenceMapping externalMapping = DBAdapterConstants.getExternalMappingForField((Class)desc.getJavaClass(), (Project)topLinkProject, (DatabaseField)databaseField);
            if (externalMapping != null) {
                return;
            }
            DatabaseMapping mapping2 = DBAdapterConstants.getMappingForField((RelationalDescriptor)desc, (DatabaseField)databaseField);
            if (mapping2 == null || DBAdapterConstants.isAUseAtRuntimeMapping((DatabaseMapping)mapping2)) continue;
            mapping2.getProperties().remove("fkPlaceholder");
            mapping2.setIsReadOnly(false);
        }
    }

    public static void dumpWSDL(AdapterWizardContext context) {
        try {
            JcaMigrationHelper helper = new JcaMigrationHelper();
            System.out.println("===========================================================");
            System.out.println("===========================================================");
            System.out.println("===========================================================");
            Definition def = context._write_definition;
            System.out.println("Def: " + def);
            Definition defFromMemory = XRAdapterUtil.readFromMemory(def);
            XRAdapterUtil.writeWSDL("result.wsdl", defFromMemory);
            JcaMigrationResult[] result = helper.migrate(def);
            System.out.println("\nWSDL = \n" + result[0].getSerializedDefinition());
            System.out.println("Binding = " + result[0].getJcaBindingFileName() + "\n" + result[0].getSerializedJcaBinding());
            XRAdapterUtil.writeResults(result[0], ".");
            XRAdapterUtil.readResults(helper, result[0], ".");
        }
        catch (Throwable t) {
            ExceptionDialog.showExceptionDialog((Component)XRAdapterUtil.m_wcontext._parentFrame, (Throwable)t);
        }
    }

    private static void writeResults(JcaMigrationResult result, String dir) throws IOException, WSDLException {
        String fileWSDL = dir + File.separator + "sca_" + result.getWSDLFileName();
        String fileBind = dir + File.separator + result.getJcaBindingFileName();
        XRAdapterUtil.writeFile(fileWSDL, result.getSerializedDefinition());
        XRAdapterUtil.writeFile(fileBind, result.getSerializedJcaBinding());
    }

    private static void writeFile(String fileName, String contents) throws IOException {
        File f = new File(fileName);
        FileOutputStream fos = new FileOutputStream(f);
        fos.write(contents.getBytes());
        fos.close();
    }

    private static void readResults(JcaMigrationHelper helper, JcaMigrationResult result, String dir) throws Exception {
        String fileWSDL = dir + File.separator + "sca_" + result.getWSDLFileName();
        String fileBind = dir + File.separator + result.getJcaBindingFileName();
        Definition def = XRAdapterUtil.readWSDL(fileWSDL);
        FileInputStream bind = new FileInputStream(fileBind);
        JcaParsedResult parsed = helper.parse(def, (InputStream)bind);
        String resultWSDL = dir + File.separator + "parsed_" + result.getWSDLFileName();
        XRAdapterUtil.writeWSDL(resultWSDL, parsed.getDefinition());
        XRAdapterUtil.readWSDL(resultWSDL);
    }

    private static Definition readWSDL(String wsdlName) throws WSDLException {
        String wsdlFacImpl = "oracle.j2ee.ws.wsdl.factory.WSDLFactoryImpl";
        WSDLFactory factory = WSDLFactory.newInstance((String)wsdlFacImpl);
        WSDLReader reader = factory.newWSDLReader();
        File file = new File(wsdlName);
        return reader.readWSDL(file.toURI().toString());
    }

    private static Definition readFromMemory(Definition def) throws WSDLException, XMLParseException, SAXException, IOException {
        String wsdlFacImpl = "oracle.j2ee.ws.wsdl.factory.WSDLFactoryImpl";
        WSDLFactory factory = WSDLFactory.newInstance((String)wsdlFacImpl);
        WSDLReader reader = factory.newWSDLReader();
        reader.setFeature("javax.wsdl.importDocuments", false);
        ExtensionRegistry extensionRegistry = factory.newPopulatedExtensionRegistry();
        extensionRegistry.mapExtensionTypes(Types.class, Constants.QNAME_SCHEMA_2001, UnknownExtensibilityElement.class);
        extensionRegistry.registerDeserializer(Types.class, Constants.QNAME_SCHEMA_2001, extensionRegistry.getDefaultDeserializer());
        extensionRegistry.registerSerializer(Types.class, Constants.QNAME_SCHEMA_2001, extensionRegistry.getDefaultSerializer());
        reader.setExtensionRegistry(extensionRegistry);
        InputStream defStream = XRAdapterUtil.writeToStream(def);
        DOMParser parser = new DOMParser();
        parser.parse(defStream);
        return reader.readWSDL((String)null, (Document)parser.getDocument());
    }

    private static InputStream writeToStream(Definition def) throws WSDLException, IOException {
        String wsdlFacImpl = "oracle.j2ee.ws.wsdl.factory.WSDLFactoryImpl";
        WSDLFactory fac = WSDLFactory.newInstance((String)wsdlFacImpl);
        WSDLWriter writer = fac.newWSDLWriter();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        writer.writeWSDL(def, (OutputStream)baos);
        return new ByteArrayInputStream(baos.toByteArray());
    }

    private static void writeWSDL(String wsdlName, Definition def) throws WSDLException, IOException {
        String wsdlFacImpl = "oracle.j2ee.ws.wsdl.factory.WSDLFactoryImpl";
        WSDLFactory fac = WSDLFactory.newInstance((String)wsdlFacImpl);
        WSDLWriter writer = fac.newWSDLWriter();
        File f = new File(wsdlName);
        FileOutputStream fos = new FileOutputStream(f);
        writer.writeWSDL(def, (OutputStream)fos);
        fos.close();
    }

    public static void refreshSQLPanes(AdapterWizardContext context) {
        XRAdapterUtil.refreshSQLPanes(context, false);
    }

    public static void refreshSQLPanes(AdapterWizardContext context, boolean sqlMustChange) {
        XRAdapterWizardContext ascontext = (XRAdapterWizardContext)context._ascontext;
        if (!ascontext._isOutboundSelectOp && !context._isInboundOperation) {
            return;
        }
        DBActivationSpec spec = new DBActivationSpec();
        JcaOperation jcaOp = ascontext._inboundSelectOp;
        for (RelationalDescriptor desc : ascontext._orProject.getDescriptors().values()) {
            if (desc.getPrimaryKeyFieldNames().size() != 0 || desc.getTableName() == null) continue;
            return;
        }
        if (ascontext._isOutboundSelectOp) {
            spec = new DBReadInteractionSpec();
            jcaOp = ascontext._outboundSelectOp;
        }
        Wizard wizard = XRAdapterUtil.m_wcontext._wizard;
        int pageCount = wizard.getPageCount();
        for (int pageNum = 0; pageNum < pageCount; ++pageNum) {
            ImageWizardPage wizPage = (ImageWizardPage)wizard.getPageAt(pageNum);
            Component comp = wizPage.getInteractiveArea();
            if (!(comp instanceof XRAdapterPage)) continue;
            XRAdapterPage xrPage = (XRAdapterPage)((Object)comp);
            xrPage.buildSpec((TopLinkReadSpec)spec);
        }
        int originalNumArguments = ascontext._query.getArguments().size();
        if (sqlMustChange && ascontext._query.getSQLString() != null) {
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression expression = builder.get("boo").equal((Object)"ba boom");
            ascontext._query.setSelectionCriteria(expression);
            ascontext._query.setSelectionCriteria(null);
        }
        SQLRefresher refresher = new SQLRefresher(m_wcontext, (TopLinkReadSpec)spec, originalNumArguments);
        new Thread(refresher).start();
    }
}

