/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.wsdl.WSDLException;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.share.nls.StringUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.tip.adapter.db.DBActivationSpec;
import oracle.tip.adapter.db.api.TopLinkReadSpec;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterUtil;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterWizardContext;
import org.eclipse.persistence.descriptors.RelationalDescriptor;

public class XRAdapterSequencingPage
extends techAdapterWizardPage
implements DocumentListener,
ActionListener,
XRAdapterPage {
    protected MultiLineLabel instructionsLabel;
    protected JLabel sequencingTableLabel;
    protected JTextField sequencingTableField;
    protected JButton browseTablesButton;
    protected JLabel sequencingTableKeyColumnLabel;
    protected JTextField sequencingTableKeyColumnField;
    protected JLabel sequencingTableValueColumnLabel;
    protected JTextField sequencingTableValueColumnField;
    protected JLabel sequencingColumnLabel;
    protected JComboBox sequencingColumnComboBox;
    public static final String s_SequencingTable = "SequencingTable";
    public static final String s_SequencingColumn = "SequencingColumn";
    public static final String s_SequencingTableKeyColumn = "SequencingTableKeyColumn";
    public static final String s_SequencingTableValueColumn = "SequencingTableValueColumn";
    public static final String s_SequencingColumnType = "SequencingColumnType";
    public static final String s_SequencingTableKey = "SequencingTableKey";
    protected XRAdapterWizardContext ascontext;

    public XRAdapterSequencingPage(AdapterWizardContext context, ImageWizardPage page) {
        try {
            this.setContextAndPage(context, page);
            this.ascontext = (XRAdapterWizardContext)context._ascontext;
            this.m_page.setCanAdvance(false);
            this.initialize();
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)this.m_wcontext._parentFrame, (Exception)e);
        }
    }

    public void initialize() {
        this.setLayout(new GridBagLayout());
        MessageFormat msgformat = new MessageFormat(this.getTranslatedString("DB_LR_INTRO_PROMPT"));
        Object[] args = new Object[]{this.ascontext._rootDescriptor.getTableName()};
        String instructionsText = msgformat.format(args);
        this.instructionsLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), instructionsText);
        this.sequencingTableField = new JTextField();
        this.sequencingTableField.getDocument().addDocumentListener(this);
        String sequencingTableString = this.getTranslatedString("DB_LR_SEQ_TABLE");
        this.sequencingTableLabel = new JLabel(StringUtils.stripMnemonic((String)sequencingTableString));
        this.sequencingTableLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)sequencingTableString));
        this.sequencingTableLabel.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)sequencingTableString));
        this.sequencingTableLabel.setLabelFor(this.sequencingTableField);
        String browseTablesButtonString = this.getTranslatedString("DB_LR_BROWSE");
        this.browseTablesButton = new JButton(StringUtils.stripMnemonic((String)browseTablesButtonString));
        this.browseTablesButton.addActionListener(this);
        this.browseTablesButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)browseTablesButtonString));
        this.browseTablesButton.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)browseTablesButtonString));
        this.sequencingTableKeyColumnField = new JTextField();
        this.sequencingTableKeyColumnField.getDocument().addDocumentListener(this);
        String sequencingTableKeyColumn = this.getTranslatedString("DB_LR_SEQ_NAME_FIELD");
        this.sequencingTableKeyColumnLabel = new JLabel(StringUtils.stripMnemonic((String)sequencingTableKeyColumn));
        this.sequencingTableKeyColumnLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)sequencingTableKeyColumn));
        this.sequencingTableKeyColumnLabel.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)sequencingTableKeyColumn));
        this.sequencingTableKeyColumnLabel.setLabelFor(this.sequencingTableKeyColumnField);
        this.sequencingTableValueColumnField = new JTextField();
        this.sequencingTableValueColumnField.getDocument().addDocumentListener(this);
        String sequencingTableValueColumnString = this.getTranslatedString("DB_LR_SEQ_VALUE_FIELD");
        this.sequencingTableValueColumnLabel = new JLabel(StringUtils.stripMnemonic((String)sequencingTableValueColumnString));
        this.sequencingTableValueColumnLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)sequencingTableValueColumnString));
        this.sequencingTableValueColumnLabel.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)sequencingTableValueColumnString));
        this.sequencingTableValueColumnLabel.setLabelFor(this.sequencingTableValueColumnField);
        this.sequencingColumnComboBox = new JComboBox();
        this.refreshSequencingColumnChoices();
        this.sequencingColumnComboBox.setEditable(true);
        this.sequencingColumnComboBox.addActionListener(this);
        JTextField comboBoxTextField = (JTextField)this.sequencingColumnComboBox.getEditor().getEditorComponent();
        comboBoxTextField.getDocument().addDocumentListener(this);
        String sequencingColumnString = this.getTranslatedString("DB_LR_SEQ_ID_FIELD");
        this.sequencingColumnLabel = new JLabel(StringUtils.stripMnemonic((String)sequencingColumnString));
        this.sequencingColumnLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)sequencingColumnString));
        this.sequencingColumnLabel.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)sequencingColumnString));
        this.sequencingColumnLabel.setLabelFor(this.sequencingColumnComboBox);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 3;
        constraints.gridheight = 1;
        this.add((Component)this.instructionsLabel, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.insets = new Insets(30, 0, 0, 12);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.sequencingTableLabel, constraints);
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.insets = new Insets(30, 0, 0, 0);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        this.add((Component)this.sequencingTableField, constraints);
        constraints.anchor = 17;
        constraints.gridx = 2;
        constraints.gridy = 3;
        constraints.insets = new Insets(30, 0, 0, 0);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.insets = new Insets(12, 0, 0, 12);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.sequencingTableKeyColumnLabel, constraints);
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 4;
        constraints.insets = new Insets(12, 0, 0, 0);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        this.add((Component)this.sequencingTableKeyColumnField, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.insets = new Insets(12, 0, 0, 12);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.sequencingTableValueColumnLabel, constraints);
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 5;
        constraints.insets = new Insets(12, 0, 0, 0);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        this.add((Component)this.sequencingTableValueColumnField, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 6;
        constraints.insets = new Insets(30, 0, 0, 12);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.sequencingColumnLabel, constraints);
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 6;
        constraints.insets = new Insets(30, 0, 0, 0);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        this.add((Component)this.sequencingColumnComboBox, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 7;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 3;
        constraints.gridheight = 1;
        this.add((Component)new JPanel(), constraints);
        this.setSequencingColumn();
        if (this.m_wcontext._read_service != null && this.ascontext._afterReadPage.selectedAfterReadStrategy().equals("SequencingPollingStrategy")) {
            this.populateUIForEdit();
        }
    }

    public void refreshSequencingColumnChoices() {
        RelationalDescriptor descriptor = this.ascontext._rootDescriptor;
        ArrayList columns = XRAdapterUtil.getColumnNamesFromDBProperties(descriptor.getTables(), this.ascontext._dtProps);
        Object[] masterTableFieldNames = columns.toArray();
        Arrays.sort(masterTableFieldNames);
        this.sequencingColumnComboBox.setModel(new DefaultComboBoxModel<Object>(masterTableFieldNames));
    }

    public void populateUIForEdit() {
        JcaOperation jop = this.m_wcontext._read_jca_operation;
        this.sequencingTableField.setText(jop.getAttributeValue(s_SequencingTable));
        this.sequencingTableKeyColumnField.setText(jop.getAttributeValue(s_SequencingTableKeyColumn));
        this.sequencingTableValueColumnField.setText(jop.getAttributeValue(s_SequencingTableValueColumn));
        this.sequencingColumnComboBox.setSelectedItem(jop.getAttributeValue(s_SequencingColumn));
        this.checkToEnableNext();
    }

    private void setSequencingColumn() {
        Object[] pkFieldNames = this.ascontext._rootDescriptor.getPrimaryKeyFieldNames().toArray();
        for (int i = 0; i < pkFieldNames.length; ++i) {
            Object pkFieldName = pkFieldNames[i];
            for (int j = 0; j < this.sequencingColumnComboBox.getItemCount(); ++j) {
                if (!this.sequencingColumnComboBox.getItemAt(j).equals(pkFieldName)) continue;
                this.sequencingColumnComboBox.setSelectedIndex(j);
                return;
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.checkToEnableNext();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.checkToEnableNext();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.checkToEnableNext();
    }

    protected void checkToEnableNext() {
        boolean idFieldSet;
        String table = this.sequencingTableField.getText();
        String name = this.sequencingTableKeyColumnField.getText();
        String value = this.sequencingTableValueColumnField.getText();
        boolean tableSet = table != null && table.trim().length() > 0;
        boolean nameSet = name != null && name.trim().length() > 0;
        boolean valueSet = value != null && value.trim().length() > 0;
        JTextField comboboxTextField = (JTextField)this.sequencingColumnComboBox.getEditor().getEditorComponent();
        boolean bl = idFieldSet = !comboboxTextField.getText().trim().equals("");
        if (tableSet && nameSet && valueSet && idFieldSet) {
            this.m_page.setCanAdvance(true);
        } else {
            this.m_page.setCanAdvance(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.checkToEnableNext();
    }

    @Override
    public void wizardValidatePage(WizardEvent event) {
        XRAdapterWizardContext context = (XRAdapterWizardContext)this.m_wcontext._ascontext;
        context._sequencingColumn = this.sequencingColumnComboBox.getSelectedItem().toString();
        context._pollingOptionsPage.refreshOrderByFieldChoices();
        XRAdapterUtil.refreshSQLPanes(this.m_wcontext);
    }

    @Override
    public void buildWSDL() throws WSDLException {
        if (!this.sequencingTableField.getText().equals("") || this.ascontext._inboundSelectOp.getAttributeValue(s_SequencingTable) != null) {
            this.ascontext._inboundSelectOp.setAttributeValue(s_SequencingTable, this.sequencingTableField.getText());
        }
        this.ascontext._inboundSelectOp.setAttributeValue(s_SequencingColumn, this.sequencingColumnComboBox.getSelectedItem().toString());
        if (!this.sequencingTableKeyColumnField.getText().equals("") || this.ascontext._inboundSelectOp.getAttributeValue(s_SequencingTableKeyColumn) != null) {
            this.ascontext._inboundSelectOp.setAttributeValue(s_SequencingTableKeyColumn, this.sequencingTableKeyColumnField.getText());
        }
        if (!this.sequencingTableValueColumnField.getText().equals("") || this.ascontext._inboundSelectOp.getAttributeValue(s_SequencingTableValueColumn) != null) {
            this.ascontext._inboundSelectOp.setAttributeValue(s_SequencingTableValueColumn, this.sequencingTableValueColumnField.getText());
        }
        this.ascontext._inboundSelectOp.setAttributeValue(s_SequencingTableKey, this.ascontext._rootDescriptor.getTableName());
    }

    @Override
    public void buildSpec(TopLinkReadSpec spec) {
        if (spec instanceof DBActivationSpec) {
            DBActivationSpec activationSpec = (DBActivationSpec)spec;
            if (this.sequencingColumnComboBox.getSelectedItem() == null) {
                activationSpec.setSequencingColumn("");
            } else {
                activationSpec.setSequencingColumn(this.sequencingColumnComboBox.getSelectedItem().toString());
            }
            activationSpec.setSequencingTableKey(this.ascontext._rootDescriptor.getTableName());
            if (!this.sequencingTableField.getText().equals("")) {
                activationSpec.setSequencingTable(this.sequencingTableField.getText());
            } else {
                activationSpec.setSequencingTable(null);
            }
            if (!this.sequencingTableKeyColumnField.getText().equals("")) {
                activationSpec.setSequencingTableKeyColumn(this.sequencingTableKeyColumnField.getText());
            } else {
                activationSpec.setSequencingTableKeyColumn(null);
            }
            if (!this.sequencingTableValueColumnField.getText().equals("")) {
                activationSpec.setSequencingTableValueColumn(this.sequencingTableValueColumnField.getText());
            } else {
                activationSpec.setSequencingTableValueColumn(null);
            }
        }
    }
}

