/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.SchemaObjectDescriptor;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Namespace;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Synonym;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.db.panels.DatabaseFinder;
import oracle.tip.adapter.db.DBAdapterConstants;
import oracle.tip.adapter.db.api.TopLinkReadSpec;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.AppsAdapterContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.ImportSchema;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterAdvancedOptionsPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterAfterReadPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterDescriptorGenerator;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterImportSelectionPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterPrimaryKeysPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterRelationshipsPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterSelectAttributesPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterUtil;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterWhereClausePage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.util.DBMetaDataChangeRecord;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.util.TableReImporter;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDataTypeDescriptor;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;

public class XRAdapterSelectTablesPage
extends techAdapterWizardPage
implements ActionListener,
ListSelectionListener,
XRAdapterPage {
    private MultiLineLabel instructionsLabel;
    private JList tableList;
    private JButton importTablesButton;
    private JButton removeTablesButton;
    private JLabel noTablesLabel;
    private JPanel cardPanel;
    private CardLayout cardLayout;
    private ArrayList fkConstraints;
    private XRAdapterWizardContext ascontext;
    public static final String TREE_CARD = "TreeCard";
    public static final String NO_TABLES_CARD = "NoTablesCard";

    public XRAdapterSelectTablesPage(AdapterWizardContext context, ImageWizardPage page) {
        try {
            this.setContextAndPage(context, page);
            this.ascontext = (XRAdapterWizardContext)context._ascontext;
            this.m_page.setCanAdvance(false);
            if (this.m_wcontext._read_service != null) {
                if (!this.m_wcontext._service_type.equals("Apps") || !AppsAdapterContext.isListModified) {
                    XRAdapterWizardContext ascontext = (XRAdapterWizardContext)context._ascontext;
                    if (ascontext._orProject == null) {
                        XRAdapterUtil.readTopLinkProjectFiles(context);
                        XRAdapterUtil.readDesignTimePropertiesFile(context);
                    }
                }
            }
            this.initializeUI();
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)this.m_wcontext._parentFrame, (Exception)e);
        }
    }

    private void initializeUI() {
        this.setLayout(new GridBagLayout());
        this.noTablesLabel = new JLabel(this.getTranslatedString("DB_ST_NO_TABLES_IMPORTED"), 0);
        this.noTablesLabel.setBorder((Border)UIManager.get("ScrollPane.border"));
        String instructionsText = this.m_wcontext._service_type.equals("Apps") ? this.getTranslatedString("OA_ST_INTRO_PROMPT") : this.getTranslatedString("DB_ST_INTRO_PROMPT");
        this.instructionsLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), instructionsText);
        this.tableList = new JList();
        this.tableList.setSelectionMode(0);
        this.tableList.setCellRenderer(new DatabaseTableListCellRenderer());
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        this.cardPanel.add((Component)new JScrollPane(this.tableList), TREE_CARD);
        this.cardPanel.add((Component)this.noTablesLabel, NO_TABLES_CARD);
        this.cardLayout.show(this.cardPanel, NO_TABLES_CARD);
        String importTablesButtonString = this.getTranslatedString("DB_ST_IMPORT_TABLES");
        this.importTablesButton = new JButton(StringUtils.stripMnemonic((String)importTablesButtonString));
        this.importTablesButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)importTablesButtonString));
        this.importTablesButton.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)importTablesButtonString));
        this.importTablesButton.addActionListener(this);
        String removeTablesButtonString = this.getTranslatedString("DB_ST_REMOVE_TABLES");
        this.removeTablesButton = new JButton(StringUtils.stripMnemonic((String)removeTablesButtonString));
        this.removeTablesButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)removeTablesButtonString));
        this.removeTablesButton.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)removeTablesButtonString));
        this.removeTablesButton.addActionListener(this);
        this.removeTablesButton.setEnabled(false);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        this.add((Component)this.instructionsLabel, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.insets = new Insets(30, 0, 0, 0);
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        this.add((Component)this.cardPanel, constraints);
        if (!this.m_wcontext._service_type.equals("Apps")) {
            constraints.anchor = 17;
            constraints.gridx = 0;
            constraints.gridy = 2;
            constraints.insets = new Insets(12, 0, 0, 12);
            constraints.fill = 0;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            this.add((Component)this.importTablesButton, constraints);
            constraints.anchor = 17;
            constraints.gridx = 1;
            constraints.gridy = 2;
            constraints.insets = new Insets(12, 0, 0, 0);
            constraints.fill = 0;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            this.add((Component)this.removeTablesButton, constraints);
        }
        this.buildTableList(this.m_wcontext._read_service == null);
        if (this.m_wcontext._read_service != null) {
            if (!this.m_wcontext._service_type.equals("Apps") || !AppsAdapterContext.isListModified) {
                this.populateUIForEdit();
            }
        }
        if (this.ascontext._orProject == null || this.ascontext._orProject.getDescriptors().size() == 1) {
            // empty if block
        }
        this.tableList.addListSelectionListener(this);
    }

    private void populateUIForEdit() {
        String queryName;
        this.ascontext._rootDescriptorAlias = this.ascontext._dtProps.getProperty("root_descriptor_alias");
        this.ascontext._rootDescriptor = (RelationalDescriptor)this.ascontext._orProject.getDescriptorForAlias(this.ascontext._rootDescriptorAlias);
        this.ascontext._rootDescriptorElementName = Helper.getShortClassName((Class)this.ascontext._rootDescriptor.getJavaClass());
        JcaOperation jop = null;
        if (this.ascontext._inboundSelectOp != null) {
            jop = this.ascontext._inboundSelectOp;
        } else if (this.ascontext._outboundSelectOp != null) {
            jop = this.ascontext._outboundSelectOp;
        } else if (this.ascontext._outboundQueryByExampleOp != null) {
            jop = this.ascontext._outboundQueryByExampleOp;
        }
        if (jop != null && (queryName = jop.getAttributeValue("QueryName")) != null) {
            this.ascontext._query = this.ascontext._rootDescriptor.getQueryManager().getQuery(queryName);
            if (this.ascontext._query == null) {
                this.ascontext._query = new ReadAllQuery();
                this.ascontext._rootDescriptor.getQueryManager().addQuery(queryName, this.ascontext._query);
            }
        }
        this.tableList.setSelectedValue(this.ascontext._rootDescriptor, true);
        this.removeTablesButton.setEnabled(true);
        if (this.ascontext.tableReImporter == null || this.ascontext.tableReImporter.getConnectionUsed() != this.m_wcontext._connection) {
            this.ascontext.tableReImporter = new TableReImporter(this.m_wcontext, this.ascontext);
            if (this.m_wcontext._connection != null && !this.ascontext._dtProps.isEmpty()) {
                new Thread(this.ascontext.tableReImporter).start();
            }
        }
        if (this.ascontext._oldXsdFilePath == null) {
            try {
                this.ascontext._oldXsdFilePath = XRAdapterUtil.getExistingXSDImportURI(this.m_wcontext);
            }
            catch (Exception e) {
                ExceptionDialog.showExceptionDialog((Window)this.m_wcontext._parentFrame, (Exception)e);
            }
        }
        this.addFollowingPages();
    }

    private void buildTableList() {
        this.buildTableList(false);
    }

    private void buildTableList(boolean initButNotForEdit) {
        DefaultListModel<RelationalDescriptor> model = new DefaultListModel<RelationalDescriptor>();
        RelationalDescriptor rootDescriptor = null;
        if (this.ascontext._orProject == null) {
            return;
        }
        for (RelationalDescriptor desc : this.ascontext._orProject.getDescriptors().values()) {
            model.addElement(desc);
            if (!desc.getAlias().equals(this.ascontext._rootDescriptorAlias)) continue;
            rootDescriptor = desc;
        }
        this.tableList.setModel(model);
        if (rootDescriptor != null) {
            this.tableList.setSelectedValue(rootDescriptor, true);
            this.removeTablesButton.setEnabled(true);
            this.tableList.requestFocus();
            this.m_wizard.setMustFinish(true);
            this.m_page.setCanAdvance(true);
            if (initButNotForEdit) {
                this.addFollowingPages();
            }
        }
        if (this.ascontext._orProject.getDescriptors().size() > 0) {
            this.cardLayout.show(this.cardPanel, TREE_CARD);
        }
    }

    private DBObject resolveSynonymTarget(Synonym synonym) {
        try {
            DBObject synonymTarget = synonym.getReference().resolveID();
            if (synonymTarget instanceof Synonym) {
                Synonym anotherSynonym = (Synonym)synonymTarget;
                return this.resolveSynonymTarget(anotherSynonym);
            }
            if (synonymTarget instanceof Relation) {
                return synonymTarget;
            }
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)this.m_wcontext._parentFrame, (Exception)e);
        }
        return null;
    }

    private boolean isForeignKeyColumn(Column col) {
        for (FKConstraint fkCon : this.fkConstraints) {
            Column[] fkCols = fkCon.getColumns();
            for (int i = 0; i < fkCols.length; ++i) {
                if (!col.equals((Object)fkCols[i]) || !col.getParent().equals(fkCols[i].getParent())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isPrimaryKeyColumn(Column col) {
        DBObject parent = col.getParent();
        PKConstraint pkCon = null;
        DBObject[] ownedObjects = parent.getOwnedObjects();
        for (int i = 0; i < ownedObjects.length; ++i) {
            if (!(ownedObjects[i] instanceof PKConstraint)) continue;
            pkCon = (PKConstraint)ownedObjects[i];
        }
        if (pkCon == null) {
            return false;
        }
        Column[] pkCols = pkCon.getColumns();
        for (int i = 0; i < pkCols.length; ++i) {
            if (!col.equals((Object)pkCols[i])) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        Object[] toRemove;
        if (event.getSource() == this.importTablesButton) {
            try {
                this.setCursor(new Cursor(3));
                Namespace n = new Namespace();
                DBObjectProvider dbProvider = DBObjectProviderFactory.findProvider((Object)this.m_wcontext.dbConnectionInfo.getConnectionName());
                n.put("DBObjectProvider", (Object)DatabaseFinder.findDatabase((String)this.m_wcontext.dbConnectionInfo.getConnectionName()));
                XRAdapterImportSelectionPanel panel = new XRAdapterImportSelectionPanel(this.m_wcontext._connection);
                panel.setHelpID("bpmjdev_adp_wiz_db_importtbl");
                TDialogLauncher launcher = new TDialogLauncher((Component)this.m_wcontext._parentFrame, this.getTranslatedString("DB_IT_TITLE"), (Traversable)panel, n);
                boolean ok = launcher.showDialog();
                if (!ok) {
                    return;
                }
                this.setCursor(new Cursor(3));
                SchemaObjectDescriptor[] tableDescriptors = (SchemaObjectDescriptor[])n.get("SelectDBObjectsPanel.SELECTED_OBJECTS");
                Object[] tableNames = new String[tableDescriptors.length];
                for (int i = 0; i < tableDescriptors.length; ++i) {
                    tableNames[i] = tableDescriptors[i].getSchema() != null ? tableDescriptors[i].getSchema() + "." + tableDescriptors[i].getName() : tableDescriptors[i].getName();
                }
                XRAdapterDescriptorGenerator.instance().generate(this.m_wcontext, null, tableNames);
                this.buildTableList();
                if (this.tableList.getSelectedValues().length == 0 && tableNames.length == 1) {
                    this.tableList.setSelectedValue(this.tableList.getModel().getElementAt(0), true);
                    this.valueChanged(null);
                }
            }
            finally {
                this.setCursor(new Cursor(0));
            }
        }
        if (event.getSource() == this.removeTablesButton && (toRemove = this.tableList.getSelectedValues()) != null) {
            for (int i = 0; i < toRemove.length; ++i) {
                RelationalDescriptor orDescToRemove = (RelationalDescriptor)toRemove[i];
                XRAdapterUtil.removeDescriptorForTableName(this.m_wcontext, orDescToRemove.getAlias());
                this.buildTableList();
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.tableList.getSelectedValues().length == 0) {
            this.m_page.setCanAdvance(false);
            this.removeTablesButton.setEnabled(false);
        } else {
            this.removeTablesButton.setEnabled(true);
            RelationalDescriptor selectedDesc = (RelationalDescriptor)this.tableList.getSelectedValue();
            if (selectedDesc.getTableName() == null) {
                this.m_page.setCanAdvance(false);
                return;
            }
            String queryName = this.m_wcontext._write_service_name + "Select";
            ReadAllQuery raq = new ReadAllQuery();
            raq.setReferenceClass(selectedDesc.getJavaClass());
            raq.setReferenceClassName(selectedDesc.getJavaClassName());
            raq.setDescriptor((ClassDescriptor)selectedDesc);
            selectedDesc.getQueryManager().addQuery(queryName, (DatabaseQuery)raq);
            this.ascontext._rootDescriptor = selectedDesc;
            this.ascontext._query = raq;
            this.ascontext._rootDescriptorAlias = selectedDesc.getAlias();
            this.ascontext._rootDescriptorElementName = Helper.getShortClassName((Class)selectedDesc.getJavaClass());
            this.ascontext._dtProps.setProperty("root_descriptor_alias", selectedDesc.getAlias());
            this.removePages();
            this.addFollowingPages();
        }
    }

    private void addFollowingPages() {
        for (RelationalDescriptor orDesc : this.ascontext._orProject.getDescriptors().values()) {
            if (orDesc.isAggregateDescriptor() || orDesc.isAggregateCollectionDescriptor() || orDesc.getPrimaryKeyFieldNames().size() != 0) continue;
            ImageWizardPage tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("DB_PK_TITLE"));
            if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_db_primkey");
            }
            new XRAdapterPrimaryKeysPage(this.m_wcontext, tempwp, orDesc);
        }
        ImageWizardPage tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("DB_RE_TITLE"));
        if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_db_rel");
        }
        new XRAdapterRelationshipsPage(this.m_wcontext, tempwp);
        tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("DB_SA_TITLE"));
        if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_db_selatt");
        }
        this.ascontext._selectAttributesPage = new XRAdapterSelectAttributesPage(this.m_wcontext, tempwp);
        if (this.m_wcontext._isInboundOperation) {
            tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("DB_AR_TITLE"));
            if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_db_aread");
            }
            XRAdapterAfterReadPage arPage = new XRAdapterAfterReadPage(this.m_wcontext, tempwp);
        }
        if (this.ascontext._isOutboundSelectOp) {
            tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("DB_WC_TITLE"));
            if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_db_where");
            }
            XRAdapterWhereClausePage whereClausePage = new XRAdapterWhereClausePage(this.m_wcontext, tempwp);
        }
        if (!this.m_wcontext._isInboundOperation) {
            tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("DB_AO_TITLE"));
            if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_db_ao");
            }
            XRAdapterAdvancedOptionsPage advancedOptionsPage = new XRAdapterAdvancedOptionsPage(this.m_wcontext, tempwp);
            XRAdapterUtil.setFinishPage(this);
        }
        this.m_page.setCanAdvance(true);
    }

    @Override
    public void buildWSDL() throws WSDLException {
        String schemaFileName = this.ascontext._oldXsdFilePath;
        if (schemaFileName == null) {
            schemaFileName = this.m_wcontext.IMPORT_SCHEMA_RELATIVE_LOC + this.m_wcontext._write_encoded_service_name + "_table.xsd";
        }
        Types types = this.m_wcontext.getWriteTypes();
        ImportSchema impSchema = (ImportSchema)this.m_wcontext._extReg.createExtension(ImportSchema.PARENT_CLASS, ImportSchema.FIELD_ELEMENT_TYPE);
        impSchema.setContext(this.m_wcontext);
        String topNamespace = DBAdapterConstants.xsdNamespace((String)XRAdapterUtil.getPackageName(this.m_wcontext));
        impSchema.setNamespace(topNamespace);
        impSchema.setLocation(schemaFileName);
        types.addExtensibilityElement((ExtensibilityElement)impSchema);
    }

    @Override
    public void buildSpec(TopLinkReadSpec spec) {
        RelationalDescriptor selectedDesc = (RelationalDescriptor)this.tableList.getSelectedValue();
        String serviceName = this.m_wcontext._write_service_name;
        if (this.m_wcontext._read_service != null) {
            serviceName = this.m_wcontext._read_service_name;
        }
        if (this.ascontext._query != null && this.ascontext._query.getName() != null) {
            spec.setQueryName(this.ascontext._query.getName());
        } else {
            spec.setQueryName(serviceName + "Select");
        }
        spec.setDescriptorName(selectedDesc.getJavaClassName());
        spec.setMappingsMetaDataURL(this.m_wcontext.getFilePath() + File.pathSeparator + serviceName + "-or-mappings.xml");
        spec.setOXMappingsMetaDataURL(this.m_wcontext.getFilePath() + File.pathSeparator + serviceName + "-ox-mappings.xml");
    }

    @Override
    public void wizardValidatePage(WizardEvent event) {
        if (this.ascontext.tableReImporter != null) {
            Vector<DBMetaDataChangeRecord> changes;
            if (this.ascontext.tableReImporter.getConnectionUsed() != this.m_wcontext._connection) {
                this.ascontext.tableReImporter = new TableReImporter(this.m_wcontext, this.ascontext);
                new Thread(this.ascontext.tableReImporter).start();
            }
            this.setCursor(new Cursor(3));
            if (this.ascontext.tableReImporter.waitForFinish(5000L) && (changes = this.ascontext.tableReImporter.getChanges()).size() > 0) {
                DBMetaDataChangeRecord.init(this.m_wcontext);
                String summary = DBMetaDataChangeRecord.summarizeChanges(changes, this.m_wcontext);
                JOptionPane.showMessageDialog(this.m_wcontext._parentFrame, summary, DBMetaDataChangeRecord.translations_title, 2);
            }
            this.setCursor(new Cursor(0));
        }
    }

    private class DatabaseTableListCellRenderer
    extends DefaultListCellRenderer {
        private DatabaseTableListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel superLabel = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof RelationalDescriptor) {
                RelationalDescriptor desc = (RelationalDescriptor)value;
                String tableName = desc.getTableName();
                if (tableName == null && desc instanceof ObjectRelationalDataTypeDescriptor) {
                    ObjectRelationalDataTypeDescriptor orDesc = (ObjectRelationalDataTypeDescriptor)desc;
                    tableName = orDesc.getStructureName();
                }
                String qualifiedTableName = desc.getAlias();
                superLabel.setText(tableName);
                String tableType = (String)((XRAdapterSelectTablesPage)XRAdapterSelectTablesPage.this).ascontext._dtProps.get(qualifiedTableName + ":db_table_type");
                if (tableType == null) {
                    superLabel.setIcon(DBTypeDisplayRegistry.getNodeIcon((String)"DATATYPE"));
                    return superLabel;
                }
                if (tableType.equals("SYNONYM")) {
                    superLabel.setIcon(DBTypeDisplayRegistry.getNodeIcon((String)"SYNONYM"));
                } else if (tableType.equals("VIEW")) {
                    superLabel.setIcon(DBTypeDisplayRegistry.getNodeIcon((String)"VIEW"));
                } else {
                    superLabel.setIcon(DBTypeDisplayRegistry.getNodeIcon((String)"TABLE"));
                }
            }
            return superLabel;
        }
    }
}

