/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.share.nls.StringUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.tip.adapter.db.api.TopLinkReadSpec;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterUtil;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterWizardContext;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.structures.StructureMapping;

public class XRAdapterSelectAttributesPage
extends techAdapterWizardPage
implements ActionListener,
XRAdapterPage {
    private MultiLineLabel instructionsLabel;
    private JButton selectAllButton;
    private JButton deselectAllButton;
    private JTree attributesTree;
    private HashSet shownDescriptors;
    private XRAdapterWizardContext ascontext;
    private boolean sqlMustChange = false;

    public XRAdapterSelectAttributesPage(AdapterWizardContext context, ImageWizardPage page) {
        try {
            this.ascontext = (XRAdapterWizardContext)context._ascontext;
            this.shownDescriptors = new HashSet();
            this.setContextAndPage(context, page);
            this.initialize();
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)this.m_wcontext._parentFrame, (Exception)e);
        }
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        String instructionsText = this.getTranslatedString("DB_SA_INTRO_PROMPT");
        this.instructionsLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), instructionsText);
        this.attributesTree = new JTree();
        this.attributesTree.setShowsRootHandles(true);
        this.attributesTree.setCellRenderer(new MyCellRenderer());
        this.attributesTree.addMouseListener(new MyMouseAdapter());
        this.initializeTree();
        String selectAllButtonString = this.getTranslatedString("DB_SA_SELECT_ALL");
        this.selectAllButton = new JButton(StringUtils.stripMnemonic((String)selectAllButtonString));
        this.selectAllButton.addActionListener(this);
        this.selectAllButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)selectAllButtonString));
        this.selectAllButton.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)selectAllButtonString));
        String deselectAllButtonString = this.getTranslatedString("DB_SA_DESELECT_ALL");
        this.deselectAllButton = new JButton(StringUtils.stripMnemonic((String)deselectAllButtonString));
        this.deselectAllButton.addActionListener(this);
        this.deselectAllButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)deselectAllButtonString));
        this.deselectAllButton.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)deselectAllButtonString));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        this.add((Component)this.instructionsLabel, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.insets = new Insets(30, 0, 0, 0);
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 3;
        constraints.gridheight = 1;
        this.add((Component)new JScrollPane(this.attributesTree), constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.insets = new Insets(12, 0, 0, 12);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.selectAllButton, constraints);
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.insets = new Insets(12, 0, 0, 12);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.deselectAllButton, constraints);
    }

    public void initializeTree() {
        RelationalDescriptor descriptor = this.ascontext._rootDescriptor;
        this.attributesTree.setModel(new DefaultTreeModel(new MyTreeNode(descriptor, descriptor)));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setSelected((MyTreeNode)this.attributesTree.getModel().getRoot(), e.getSource() == this.selectAllButton);
        this.sqlMustChange = true;
        this.repaint();
    }

    @Override
    public void buildSpec(TopLinkReadSpec spec) {
    }

    @Override
    public void wizardValidatePage(WizardEvent event) {
        if (this.ascontext._isOutboundSelectOp) {
            XRAdapterUtil.refreshSQLPanes(this.m_wcontext, this.sqlMustChange);
            this.sqlMustChange = false;
        }
    }

    private void setSelected(MyTreeNode node, boolean selected) {
        if (!node.isLockedSelected() && node.getUserObject() instanceof DatabaseMapping) {
            DatabaseMapping mapping = (DatabaseMapping)node.getUserObject();
            if (selected) {
                mapping.getProperties().remove("enabled");
            } else {
                mapping.getProperties().put("enabled", "false");
            }
        }
        int childCount = node.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            MyTreeNode childNode = (MyTreeNode)node.getChildAt(i);
            this.setSelected(childNode, selected);
        }
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private MyMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int selRow = XRAdapterSelectAttributesPage.this.attributesTree.getRowForLocation(e.getX(), e.getY());
            TreePath selPath = XRAdapterSelectAttributesPage.this.attributesTree.getPathForLocation(e.getX(), e.getY());
            if (selRow != -1 && e.getClickCount() == 1 && selPath.getLastPathComponent() instanceof MyTreeNode) {
                MyTreeNode checkBoxNode = (MyTreeNode)selPath.getLastPathComponent();
                boolean oldSelected = checkBoxNode.isSelected();
                if (checkBoxNode.isLockedSelected()) {
                    boolean wasSelected = false;
                    Enumeration<TreeNode> children = checkBoxNode.children();
                    while (children.hasMoreElements()) {
                        MyTreeNode child = (MyTreeNode)children.nextElement();
                        if (child.isLockedSelected() || !child.isSelected()) continue;
                        wasSelected = true;
                    }
                    oldSelected = wasSelected;
                }
                XRAdapterSelectAttributesPage.this.setSelected(checkBoxNode, !oldSelected);
                XRAdapterSelectAttributesPage.this.sqlMustChange = true;
                XRAdapterSelectAttributesPage.this.repaint();
            }
        }
    }

    private class MyTreeNode
    extends DefaultMutableTreeNode {
        private boolean childrenDefined;
        RelationalDescriptor descriptor;

        public MyTreeNode(RelationalDescriptor d, Object nodeValue) {
            super(nodeValue);
            this.childrenDefined = false;
            this.descriptor = d;
        }

        public boolean isSelected() {
            Object userObject = this.getUserObject();
            if (userObject instanceof RelationalDescriptor) {
                return true;
            }
            if (userObject instanceof DatabaseMapping) {
                DatabaseMapping mapping = (DatabaseMapping)userObject;
                Object isEnabled = mapping.getProperties().get("enabled");
                return isEnabled == null || isEnabled.equals("true");
            }
            return false;
        }

        @Override
        public boolean isLeaf() {
            if (this.getUserObject() instanceof RelationalDescriptor) {
                return false;
            }
            if (this.getUserObject() instanceof DirectToFieldMapping) {
                return true;
            }
            if (this.getUserObject() instanceof ForeignReferenceMapping) {
                return false;
            }
            return !(this.getUserObject() instanceof StructureMapping);
        }

        @Override
        public int getChildCount() {
            if (!this.childrenDefined) {
                this.defineChildren();
            }
            return super.getChildCount();
        }

        public void defineChildren() {
            MyTreeNode node;
            DatabaseMapping m;
            Iterator mappingsIt;
            RelationalDescriptor descriptor;
            ForeignReferenceMapping mapping;
            this.childrenDefined = true;
            if (this.getUserObject() instanceof RelationalDescriptor) {
                RelationalDescriptor descriptor2 = (RelationalDescriptor)this.getUserObject();
                for (DatabaseMapping m2 : descriptor2.getMappings()) {
                    if (m2.getProperty((Object)"fkPlaceholder") != null) continue;
                    MyTreeNode node2 = new MyTreeNode(descriptor2, m2);
                    this.add(node2);
                    XRAdapterSelectAttributesPage.this.shownDescriptors.add(descriptor2.getJavaClassName());
                }
                XRAdapterSelectAttributesPage.this.shownDescriptors.add(descriptor2.getJavaClassName());
            }
            if (this.getUserObject() instanceof ForeignReferenceMapping) {
                mapping = (ForeignReferenceMapping)this.getUserObject();
                descriptor = (RelationalDescriptor)XRAdapterUtil.getDescriptorByClassName(((XRAdapterSelectAttributesPage)XRAdapterSelectAttributesPage.this).ascontext._orProject, mapping.getReferenceClassName());
                mappingsIt = descriptor.getMappings().iterator();
                if (XRAdapterSelectAttributesPage.this.shownDescriptors.contains(descriptor.getJavaClassName())) {
                    return;
                }
                while (mappingsIt.hasNext()) {
                    m = (DatabaseMapping)mappingsIt.next();
                    if (m.getProperty((Object)"fkPlaceholder") != null) continue;
                    node = new MyTreeNode(descriptor, m);
                    this.add(node);
                }
                XRAdapterSelectAttributesPage.this.shownDescriptors.add(descriptor.getJavaClassName());
            }
            if (this.getUserObject() instanceof StructureMapping) {
                mapping = (StructureMapping)this.getUserObject();
                descriptor = (RelationalDescriptor)XRAdapterUtil.getDescriptorByClassName(((XRAdapterSelectAttributesPage)XRAdapterSelectAttributesPage.this).ascontext._orProject, mapping.getReferenceClassName());
                mappingsIt = descriptor.getMappings().iterator();
                if (XRAdapterSelectAttributesPage.this.shownDescriptors.contains(descriptor.getJavaClassName())) {
                    return;
                }
                while (mappingsIt.hasNext()) {
                    m = (DatabaseMapping)mappingsIt.next();
                    node = new MyTreeNode(descriptor, m);
                    this.add(node);
                    XRAdapterSelectAttributesPage.this.shownDescriptors.add(descriptor.getJavaClassName());
                }
            }
        }

        public boolean isLockedSelected() {
            MyTreeNode parent = (MyTreeNode)this.getParent();
            if (parent == null) {
                return true;
            }
            if (this.getUserObject() instanceof DatabaseMapping) {
                DatabaseMapping mapping = (DatabaseMapping)this.getUserObject();
                if (mapping.getDescriptor().getPrimaryKeyFields().contains(mapping.getField())) {
                    return true;
                }
                if (mapping.isForeignReferenceMapping()) {
                    return true;
                }
                if (parent.getUserObject() instanceof StructureMapping) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public String toString() {
            if (this.getUserObject() instanceof RelationalDescriptor) {
                RelationalDescriptor descriptor = (RelationalDescriptor)this.getUserObject();
                return descriptor.getTableName();
            }
            if (this.getUserObject() instanceof DatabaseMapping) {
                DatabaseMapping mapping = (DatabaseMapping)this.getUserObject();
                return mapping.getAttributeName();
            }
            return super.toString();
        }
    }

    private class MyCellRenderer
    extends DefaultTreeCellRenderer {
        private MyCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof MyTreeNode) {
                MyTreeNode checkBoxNode = (MyTreeNode)value;
                JCheckBox checkBox = new JCheckBox(value.toString());
                checkBox.setBackground(XRAdapterSelectAttributesPage.this.attributesTree.getBackground());
                checkBox.setSelected(checkBoxNode.isSelected());
                checkBox.setEnabled(!checkBoxNode.isLockedSelected());
                return checkBox;
            }
            JLabel superLabel = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            superLabel.setIcon(null);
            return superLabel;
        }
    }
}

