/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.tip.adapter.db.DBAdapterConstants;
import oracle.tip.adapter.db.api.TopLinkReadSpec;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterCreateRelationshipsPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterUtil;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterWizardContext;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;

public class XRAdapterRelationshipsPage
extends techAdapterWizardPage
implements ActionListener,
ListSelectionListener,
XRAdapterPage {
    private MultiLineLabel instructionsLabel;
    private JList relationshipsList;
    private JLabel noRelationshipsLabel;
    private JPanel cardPanel;
    private CardLayout cardLayout;
    public static final String LIST_CARD = "ListCard";
    public static final String NO_RELATIONSHIPS_CARD = "NoRelationshipsCard";
    private JButton createRelationshipButton;
    private JButton removeRelationshipButton;
    private JButton renameRelationshipButton;
    private HashMap classNameDescriptorMap;
    private XRAdapterWizardContext ascontext;

    public XRAdapterRelationshipsPage(AdapterWizardContext context, ImageWizardPage page) {
        try {
            this.setContextAndPage(context, page);
            this.ascontext = (XRAdapterWizardContext)context._ascontext;
            this.classNameDescriptorMap = new HashMap();
            for (RelationalDescriptor desc : this.ascontext._orProject.getDescriptors().values()) {
                this.classNameDescriptorMap.put(desc.getJavaClassName(), desc);
            }
            this.initialize();
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)this.m_wcontext._parentFrame, (Exception)e);
        }
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        String instructionsText = this.getTranslatedString("DB_RE_INTRO_PROMPT");
        this.instructionsLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), instructionsText);
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        this.relationshipsList = new JList();
        this.relationshipsList.setModel(new DefaultListModel());
        this.relationshipsList.setCellRenderer(new RelationshipRenderer());
        this.relationshipsList.setSelectionMode(0);
        this.relationshipsList.addListSelectionListener(this);
        this.noRelationshipsLabel = new JLabel(this.getTranslatedString("DB_RE_NO_RELATIONSHIPS"), 0);
        this.noRelationshipsLabel.setBorder((Border)UIManager.get("ScrollPane.border"));
        this.cardPanel.add((Component)new JScrollPane(this.relationshipsList), LIST_CARD);
        this.cardPanel.add((Component)this.noRelationshipsLabel, NO_RELATIONSHIPS_CARD);
        this.displayRelationships();
        String modifyRelationshipsButtonString = this.getTranslatedString("DB_RE_CREATE_REL");
        this.createRelationshipButton = new JButton(StringUtils.stripMnemonic((String)modifyRelationshipsButtonString));
        this.createRelationshipButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)modifyRelationshipsButtonString));
        this.createRelationshipButton.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)modifyRelationshipsButtonString));
        this.createRelationshipButton.addActionListener(this);
        String removeRelationshipButtonString = this.getTranslatedString("DB_RE_REMOVE_REL");
        this.removeRelationshipButton = new JButton(StringUtils.stripMnemonic((String)removeRelationshipButtonString));
        this.removeRelationshipButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)removeRelationshipButtonString));
        this.removeRelationshipButton.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)removeRelationshipButtonString));
        this.removeRelationshipButton.setEnabled(false);
        this.removeRelationshipButton.addActionListener(this);
        String renameRelationshipButtonString = this.getTranslatedString("DB_RE_RENAME_REL");
        this.renameRelationshipButton = new JButton(StringUtils.stripMnemonic((String)renameRelationshipButtonString));
        this.renameRelationshipButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)renameRelationshipButtonString));
        this.renameRelationshipButton.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)renameRelationshipButtonString));
        this.renameRelationshipButton.setEnabled(false);
        this.renameRelationshipButton.addActionListener(this);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 3;
        constraints.gridheight = 1;
        this.add((Component)this.instructionsLabel, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.insets = new Insets(30, 0, 0, 0);
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 3;
        constraints.gridheight = 1;
        this.add((Component)this.cardPanel, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.insets = new Insets(12, 0, 0, 12);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.createRelationshipButton, constraints);
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.insets = new Insets(12, 0, 0, 12);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.removeRelationshipButton, constraints);
        constraints.anchor = 17;
        constraints.gridx = 2;
        constraints.gridy = 2;
        constraints.insets = new Insets(12, 0, 0, 0);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.renameRelationshipButton, constraints);
    }

    private void displayRelationships() {
        DefaultListModel model = (DefaultListModel)this.relationshipsList.getModel();
        model.removeAllElements();
        ArrayList<RelationshipInfo> relationships = new ArrayList<RelationshipInfo>();
        for (RelationalDescriptor desc : this.ascontext._orProject.getDescriptors().values()) {
            for (DatabaseMapping mapping : desc.getMappings()) {
                if (!(mapping instanceof ForeignReferenceMapping)) continue;
                RelationshipInfo info = new RelationshipInfo(desc, (ForeignReferenceMapping)mapping);
                relationships.add(info);
            }
        }
        Collections.sort(relationships);
        Iterator infosIterator = relationships.iterator();
        while (infosIterator.hasNext()) {
            model.addElement(infosIterator.next());
        }
        if (model.getSize() == 0) {
            this.cardLayout.show(this.cardPanel, NO_RELATIONSHIPS_CARD);
        } else {
            this.cardLayout.show(this.cardPanel, LIST_CARD);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.removeRelationshipButton.setEnabled(!this.relationshipsList.isSelectionEmpty());
        this.renameRelationshipButton.setEnabled(!this.relationshipsList.isSelectionEmpty());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        RelationshipInfo info;
        if (e.getSource() == this.createRelationshipButton) {
            JEWTDialog d = new JEWTDialog(this.m_wcontext._parentFrame, this.getTranslatedString("DB_CR_TITLE"), 7);
            XRAdapterCreateRelationshipsPanel panel = new XRAdapterCreateRelationshipsPanel(this.m_wcontext, d);
            if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "bpmjdev_adp_wiz_db_crel");
            }
            d.setResizable(true);
            d.setContent((Component)panel);
            d.setOKButtonEnabled(false);
            d.setCancelButtonText(this.getTranslatedString("DB_CR_CANCEL"));
            boolean ok = d.runDialog();
            if (!ok) {
                return;
            }
            boolean isOneToOne = panel.isOneToOneSelected() || panel.isTargetOneToOneSelected();
            boolean isForeignKeyOnSource = panel.isOneToOneSelected();
            RelationalDescriptor sourceDesc = panel.getDescriptorOne();
            RelationalDescriptor targetDesc = panel.getDescriptorTwo();
            Object[] primaryKeys = null;
            primaryKeys = isForeignKeyOnSource ? targetDesc.getPrimaryKeyFieldNames().toArray() : sourceDesc.getPrimaryKeyFieldNames().toArray();
            String[] fkFields = panel.getFKFieldsArray();
            Class targetClass = targetDesc.getJavaClass();
            String attributeName = DBAdapterConstants.urlEncodeName((String)panel.getAttributeName());
            OneToOneMapping orMapping = null;
            if (isOneToOne) {
                OneToOneMapping orOneToOneMapping = new OneToOneMapping();
                orOneToOneMapping.setReferenceClassName(targetDesc.getJavaClassName());
                orOneToOneMapping.setReferenceClass(targetClass);
                orOneToOneMapping.setAttributeName(attributeName);
                orOneToOneMapping.setIsPrivateOwned(panel.isPrivateOwnedRelationship());
                orOneToOneMapping.getProperties().put("enabled", "true");
                orOneToOneMapping.setUsesBatchReading(true);
                for (int i = 0; i < fkFields.length; ++i) {
                    if (isForeignKeyOnSource) {
                        orOneToOneMapping.addForeignKeyFieldName(sourceDesc.getTableName() + "." + fkFields[i], (String)primaryKeys[i]);
                        continue;
                    }
                    orOneToOneMapping.addTargetForeignKeyFieldName(targetDesc.getTableName() + "." + fkFields[i], (String)primaryKeys[i]);
                }
                sourceDesc.addMapping((DatabaseMapping)orOneToOneMapping);
                orMapping = orOneToOneMapping;
            } else {
                OneToManyMapping orOneToManyMapping = new OneToManyMapping();
                orOneToManyMapping.setReferenceClassName(targetDesc.getJavaClassName());
                orOneToManyMapping.setReferenceClass(targetClass);
                orOneToManyMapping.setAttributeName(attributeName);
                orOneToManyMapping.setContainerPolicy(ContainerPolicy.buildPolicyFor(IndirectList.class));
                orOneToManyMapping.setIsPrivateOwned(panel.isPrivateOwnedRelationship());
                orOneToManyMapping.setUsesBatchReading(true);
                orOneToManyMapping.getProperties().put("enabled", "true");
                for (int i = 0; i < fkFields.length; ++i) {
                    orOneToManyMapping.addTargetForeignKeyFieldName(targetDesc.getTableName() + "." + fkFields[i], (String)primaryKeys[i]);
                }
                orMapping = orOneToManyMapping;
                sourceDesc.addMapping((DatabaseMapping)orOneToManyMapping);
            }
            if (isOneToOne && isForeignKeyOnSource) {
                XRAdapterUtil.relationshipAdded((ForeignReferenceMapping)orMapping, sourceDesc);
            } else {
                XRAdapterUtil.relationshipAdded((ForeignReferenceMapping)orMapping, targetDesc);
            }
            if (this.ascontext._selectAttributesPage != null) {
                this.ascontext._selectAttributesPage.initializeTree();
            }
            this.displayRelationships();
        }
        if (e.getSource() == this.renameRelationshipButton) {
            info = (RelationshipInfo)this.relationshipsList.getSelectedValue();
            String dialogTitle = this.getTranslatedString("DB_RE_RENAME_TITLE");
            final JEWTDialog d = new JEWTDialog(this.m_wcontext._parentFrame, dialogTitle, 7);
            final RenameRelationshipPanel panel = new RenameRelationshipPanel(info.mapping.getAttributeName());
            if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "bpmjdev_adp_wiz_db_renamerel");
            }
            d.setResizable(false);
            d.setContent((Component)panel);
            d.setOKButtonEnabled(true);
            d.setCancelButtonText(this.getTranslatedString("DB_CR_CANCEL"));
            panel.field.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.checkToEnableOK();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.checkToEnableOK();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.checkToEnableOK();
                }

                public void checkToEnableOK() {
                    String name = panel.field.getText();
                    boolean invalid = name.contains(" ") || name.equals("");
                    d.setOKButtonEnabled(!invalid);
                }
            });
            boolean ok = d.runDialog();
            if (!ok) {
                return;
            }
            String newName = panel.getRelationshipName();
            if (newName != null && !newName.equals("")) {
                info.mapping.setAttributeName(newName);
                this.ascontext._selectAttributesPage.initializeTree();
                this.displayRelationships();
            }
        }
        if (e.getSource() == this.removeRelationshipButton) {
            boolean removeRelationship;
            info = (RelationshipInfo)this.relationshipsList.getSelectedValue();
            String titleText = this.m_wcontext._bundle.getString("DB_RE_REMOVE_TITLE");
            MessageFormat msgformat = new MessageFormat(this.m_wcontext._bundle.getString("DB_RE_REMOVE_MESSAGE"));
            Object[] args = new Object[]{info.mapping.getAttributeName()};
            String messageText = msgformat.format(args);
            int returnCode = JOptionPane.showConfirmDialog(this.m_wcontext._parentFrame, messageText, titleText, 0);
            boolean bl = removeRelationship = returnCode == 0;
            if (!removeRelationship) {
                return;
            }
            info.descriptor.getMappings().remove(info.mapping);
            ForeignReferenceMapping mapping = info.mapping;
            if (info.mapping.isOneToOneMapping() && info.mapping.isForeignReferenceMapping()) {
                XRAdapterUtil.relationshipRemoved(info.mapping, (RelationalDescriptor)info.mapping.getDescriptor(), this.ascontext._orProject);
            } else {
                XRAdapterUtil.relationshipRemoved(info.mapping, (RelationalDescriptor)this.ascontext._orProject.getDescriptor(info.mapping.getReferenceClass()), this.ascontext._orProject);
            }
            this.ascontext._selectAttributesPage.initializeTree();
            this.displayRelationships();
        }
    }

    @Override
    public void buildSpec(TopLinkReadSpec spec) {
    }

    public class RelationshipRenderer
    extends DefaultListCellRenderer {
        public RelationshipRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel comp = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof RelationshipInfo) {
                RelationshipInfo relInfo = (RelationshipInfo)value;
                comp.setIcon(relInfo.getIcon());
            }
            return comp;
        }
    }

    public class RenameRelationshipPanel
    extends JPanel {
        public JLabel label;
        public JTextField field;

        public RenameRelationshipPanel(String initialValue) {
            String dialogText = XRAdapterRelationshipsPage.this.getTranslatedString("DB_RE_RENAME_TEXT");
            this.setLayout(new GridBagLayout());
            this.label = new JLabel(dialogText);
            this.field = new JTextField(initialValue);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.anchor = 17;
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.insets = new Insets(0, 0, 12, 0);
            constraints.fill = 2;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            this.add((Component)this.label, constraints);
            constraints.gridy = 1;
            this.add((Component)this.field, constraints);
        }

        public String getRelationshipName() {
            return this.field.getText();
        }
    }

    public class RelationshipInfo
    implements Comparable {
        private RelationalDescriptor descriptor;
        private ForeignReferenceMapping mapping;

        public RelationshipInfo(RelationalDescriptor d, ForeignReferenceMapping m) {
            this.descriptor = d;
            this.mapping = m;
        }

        public String toString() {
            String relationshipString = this.descriptor.getTableName();
            relationshipString = relationshipString + " has a ";
            if (this.mapping.isOneToOneMapping()) {
                relationshipString = relationshipString + "1:1";
            }
            if (this.mapping.isOneToManyMapping()) {
                relationshipString = relationshipString + "1:M";
            }
            relationshipString = relationshipString + " relationship with ";
            RelationalDescriptor refDesc = (RelationalDescriptor)XRAdapterRelationshipsPage.this.classNameDescriptorMap.get(this.mapping.getReferenceClassName());
            relationshipString = relationshipString + refDesc.getTableName();
            relationshipString = relationshipString + " (" + this.mapping.getAttributeName() + ")";
            return relationshipString;
        }

        public Icon getIcon() {
            if (this.mapping.isOneToManyMapping()) {
                return new ImageIcon(this.getClass().getResource("/mw/mapping/mapping.oneToMany.png"));
            }
            return new ImageIcon(this.getClass().getResource("/mw/mapping/mapping.oneToOne.png"));
        }

        public int compareTo(Object o) {
            if (o instanceof RelationshipInfo) {
                RelationshipInfo info = (RelationshipInfo)o;
                return this.descriptor.getTableName().compareTo(info.descriptor.getTableName());
            }
            return -1;
        }
    }
}

