/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.tip.adapter.db.api.TopLinkReadSpec;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterUtil;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterWizardContext;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;

public class XRAdapterPrimaryKeysPage
extends techAdapterWizardPage
implements XRAdapterPage {
    private MultiLineLabel instructionsLabel;
    private JTree attributesTree;
    private RelationalDescriptor _descriptor;
    private int pkFields = 0;
    private ImageWizardPage _page;
    private Vector selectedPKFields;
    private XRAdapterWizardContext ascontext;

    public XRAdapterPrimaryKeysPage(AdapterWizardContext context, ImageWizardPage page, RelationalDescriptor descriptor) {
        try {
            this.ascontext = (XRAdapterWizardContext)context._ascontext;
            this._descriptor = descriptor;
            this._page = page;
            this.setContextAndPage(context, page);
            this.m_page.setCanAdvance(false);
            this.selectedPKFields = new Vector();
            this.initialize();
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)this.m_wcontext._parentFrame, (Exception)e);
        }
    }

    public void initialize() {
        this.setLayout(new GridBagLayout());
        MessageFormat msgformat = new MessageFormat(this.getTranslatedString("DB_PK_INTRO_PROMPT"));
        Object[] args = new Object[]{this._descriptor.getTableName()};
        String instructionsText = msgformat.format(args);
        this.instructionsLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), instructionsText);
        this.attributesTree = new JTree();
        this.attributesTree.setRootVisible(true);
        this.attributesTree.setShowsRootHandles(true);
        this.attributesTree.setModel(new DefaultTreeModel(this.buildTableTreeRoot()));
        this.attributesTree.setCellRenderer(new MyCellRenderer());
        this.attributesTree.addMouseListener(new MyMouseAdapter());
        this.expandAll(this.attributesTree, true);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        this.add((Component)this.instructionsLabel, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.insets = new Insets(30, 0, 0, 0);
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        this.add((Component)new JScrollPane(this.attributesTree), constraints);
    }

    private DefaultMutableTreeNode buildTableTreeRoot() {
        RelationalDescriptor descriptor = this._descriptor;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(descriptor.getTableName());
        MyTreeNode fieldNode = null;
        DirectToFieldMapping identityMapping = this.ascontext._identityMappings.get(descriptor.getJavaClass());
        try {
            for (DatabaseMapping mapping : descriptor.getMappings()) {
                if (!(mapping instanceof DirectToFieldMapping)) continue;
                String fieldName = ((DirectToFieldMapping)mapping).getField().getName();
                if (identityMapping != null && identityMapping.getField().getName().equals(fieldName)) {
                    fieldNode = new MyTreeNode(fieldName, true);
                    ++this.pkFields;
                    identityMapping.getDescriptor().setSequenceNumberName("SEQ");
                    identityMapping.getDescriptor().setSequenceNumberField(identityMapping.getField());
                    identityMapping.getProperties().remove("enabled");
                    identityMapping.setIsReadOnly(false);
                    this.selectedPKFields.add(new DatabaseField(fieldName, identityMapping.getDescriptor().getTableName()));
                    this.m_page.setCanAdvance(true);
                } else {
                    fieldNode = new MyTreeNode(fieldName, false);
                }
                root.add(fieldNode);
            }
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)this.m_wcontext._parentFrame, (Exception)e);
        }
        return root;
    }

    public void expandAll(JTree tree, boolean expand) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        this.expandAll(tree, new TreePath(root), expand);
    }

    private void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    @Override
    public void wizardValidatePage(WizardEvent event) {
        this._descriptor.getPrimaryKeyFields().removeAll(this._descriptor.getPrimaryKeyFields());
        for (DatabaseField field : this.selectedPKFields) {
            this._descriptor.addPrimaryKeyField(field);
        }
        XRAdapterUtil.refreshSQLPanes(this.m_wcontext);
    }

    @Override
    public void buildSpec(TopLinkReadSpec spec) {
    }

    private class MyTreeNode
    extends DefaultMutableTreeNode {
        private boolean isSelected;

        public MyTreeNode(Object nodeValue) {
            super(nodeValue);
            this.isSelected = false;
        }

        public MyTreeNode(Object nodeValue, boolean selected) {
            super(nodeValue);
            this.isSelected = selected;
        }

        public void setSelected(boolean value) {
            this.isSelected = value;
        }

        public boolean isSelected() {
            return this.isSelected;
        }
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private MyMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int selRow = XRAdapterPrimaryKeysPage.this.attributesTree.getRowForLocation(e.getX(), e.getY());
            TreePath selPath = XRAdapterPrimaryKeysPage.this.attributesTree.getPathForLocation(e.getX(), e.getY());
            if (selRow != -1 && e.getClickCount() == 1 & selPath.getLastPathComponent() instanceof MyTreeNode) {
                MyTreeNode checkBoxNode;
                checkBoxNode.setSelected(!(checkBoxNode = (MyTreeNode)selPath.getLastPathComponent()).isSelected());
                XRAdapterPrimaryKeysPage.this.repaint();
                DirectToFieldMapping identityMapping = ((XRAdapterPrimaryKeysPage)XRAdapterPrimaryKeysPage.this).ascontext._identityMappings.get(XRAdapterPrimaryKeysPage.this._descriptor.getJavaClass());
                String fieldName = (String)checkBoxNode.getUserObject();
                if (checkBoxNode.isSelected()) {
                    XRAdapterPrimaryKeysPage.this.pkFields++;
                    XRAdapterPrimaryKeysPage.this.selectedPKFields.add(new DatabaseField(fieldName, XRAdapterPrimaryKeysPage.this._descriptor.getTableName()));
                    if (identityMapping != null && fieldName.equals(identityMapping.getField().getName())) {
                        identityMapping.getProperties().remove("enabled");
                        identityMapping.setIsReadOnly(false);
                        identityMapping.getDescriptor().setSequenceNumberName("SEQ");
                        identityMapping.getDescriptor().setSequenceNumberField(identityMapping.getField());
                    }
                } else {
                    XRAdapterPrimaryKeysPage.this.pkFields--;
                    XRAdapterPrimaryKeysPage.this.selectedPKFields.remove(new DatabaseField(fieldName, XRAdapterPrimaryKeysPage.this._descriptor.getTableName()));
                    if (identityMapping != null && fieldName.equals(identityMapping.getField().getName())) {
                        identityMapping.setProperty((Object)"enabled", (Object)"false");
                        identityMapping.setIsReadOnly(true);
                        identityMapping.getDescriptor().setSequenceNumberName(null);
                        identityMapping.getDescriptor().setSequenceNumberField(null);
                    }
                }
                XRAdapterPrimaryKeysPage.this.m_page.setCanAdvance(XRAdapterPrimaryKeysPage.this.pkFields > 0);
                if (!XRAdapterPrimaryKeysPage.this.m_wcontext._wizard.getNextPage((WizardPage)XRAdapterPrimaryKeysPage.this._page).getLabel().equals(XRAdapterPrimaryKeysPage.this._page.getLabel())) {
                    XRAdapterPrimaryKeysPage.this.m_wizard.setMustFinish(XRAdapterPrimaryKeysPage.this.pkFields == 0);
                }
            }
        }
    }

    private class MyCellRenderer
    extends DefaultTreeCellRenderer {
        private MyCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            MyTreeNode checkBoxNode;
            if (value instanceof MyTreeNode && (checkBoxNode = (MyTreeNode)value).getChildCount() == 0) {
                JPanel panel = new JPanel(new FlowLayout(2, 0, 2));
                panel.setOpaque(false);
                JCheckBox checkBox = new JCheckBox();
                checkBox.setSelected(checkBoxNode.isSelected());
                checkBox.setOpaque(false);
                JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                label.setIcon(DBTypeDisplayRegistry.getNodeIcon((String)"COLUMN"));
                panel.add(checkBox);
                panel.add(label);
                return panel;
            }
            JLabel superLabel = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            superLabel.setIcon(DBTypeDisplayRegistry.getNodeIcon((String)"TABLE"));
            return superLabel;
        }
    }
}

