/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.wsdl.WSDLException;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.share.nls.StringUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.tip.adapter.db.DBActivationSpec;
import oracle.tip.adapter.db.api.TopLinkReadSpec;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterUtil;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterWizardContext;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;

public class XRAdapterPollingOptionsPage
extends techAdapterWizardPage
implements ActionListener,
DocumentListener,
XRAdapterPage {
    private MultiLineLabel instructionsLabel;
    private JLabel pollingFrequencyLabel;
    private JFormattedTextField intervalNumberField;
    private JComboBox intervalUnitsComboBox;
    private JLabel maxRaiseSizeLabel;
    private JFormattedTextField maxRaiseSizeField;
    private MultiLineLabel maxTransSizeLabel;
    private JRadioButton unlimitedRadioButton;
    private JRadioButton sizeRadioButton;
    private JFormattedTextField sizeTextField;
    private JLabel orderByLabel;
    private JComboBox orderByComboBox;
    private JCheckBox delayCommitCheckBox;
    private JCheckBox distributedPollingCheckBox;
    private JCheckBox childUpdatesCheckBox;
    private JCheckBox batchDestroyCheckBox;
    private JCheckBox enableStreamingCheckBox;
    private JCheckBox schemaValidationCheckBox;
    private JLabel sqlLabel;
    private JTextArea sqlTextArea;
    private Color normalSQLColour;
    private Color errorSQLColour;
    private XRAdapterWizardContext ascontext;
    public static final String s_PollingInterval = "PollingInterval";
    public static final String s_MaxRaiseSize = "MaxRaiseSize";
    public static final String s_MaxTransactionSize = "MaxTransactionSize";
    public static final String s_SequencingColumn = "SequencingColumn";
    public static final String s_UseBatchDestroy = "UseBatchDestroy";
    public static final String s_DelayCommit = "DelayCommit";
    public static final String s_PollForChildUpdates = "PollForChildUpdates";
    public static final String s_EnableStreaming = "EnableStreaming";
    public static final String s_SchemaValidation = "SchemaValidation";
    public static final String s_true = "true";
    public static final String s_false = "false";
    public static final String s_unlimited = "unlimited";

    public XRAdapterPollingOptionsPage(AdapterWizardContext context, ImageWizardPage page) {
        try {
            this.ascontext = (XRAdapterWizardContext)context._ascontext;
            this.ascontext._pollingOptionsPage = this;
            this.setContextAndPage(context, page);
            this.initialize();
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)this.m_wcontext._parentFrame, (Exception)e);
        }
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        this.normalSQLColour = new JTextArea().getForeground();
        this.errorSQLColour = Color.RED;
        String instructionsText = this.getTranslatedString("DB_PO_INTRO_PROMPT");
        this.instructionsLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), instructionsText);
        this.intervalNumberField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.intervalNumberField.setValue(new Integer(5));
        String pollingFrequencyLabelString = this.getTranslatedString("DB_PO_POLLING_FREQUENCY");
        this.pollingFrequencyLabel = new JLabel(StringUtils.stripMnemonic((String)pollingFrequencyLabelString));
        this.pollingFrequencyLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)pollingFrequencyLabelString));
        this.pollingFrequencyLabel.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)pollingFrequencyLabelString));
        this.pollingFrequencyLabel.setLabelFor(this.intervalNumberField);
        Object[] intervalUnits = new Object[]{this.m_wcontext.TIME_MILLISECONDS, this.m_wcontext.TIME_SECONDS, this.m_wcontext.TIME_MINUTES, this.m_wcontext.TIME_HOURS};
        this.intervalUnitsComboBox = new JComboBox<Object>(intervalUnits);
        this.intervalUnitsComboBox.setSelectedItem(this.m_wcontext.TIME_SECONDS);
        this.maxRaiseSizeField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.maxRaiseSizeField.setValue(new Integer(1));
        this.maxRaiseSizeLabel = new JLabel(this.getTranslatedString("DB_PO_MAX_RAISE_SIZE"));
        String maxTransSizeLabelString = this.getTranslatedString("DB_PO_MAX_TRANS_SIZE");
        this.maxTransSizeLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), maxTransSizeLabelString);
        String unlimitedRadioButtonString = this.getTranslatedString("DB_PO_UNLIMITED");
        this.unlimitedRadioButton = new JRadioButton(StringUtils.stripMnemonic((String)unlimitedRadioButtonString));
        this.unlimitedRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)unlimitedRadioButtonString));
        this.unlimitedRadioButton.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)unlimitedRadioButtonString));
        this.unlimitedRadioButton.addActionListener(this);
        this.sizeRadioButton = new JRadioButton();
        this.sizeRadioButton.addActionListener(this);
        this.sizeTextField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        ButtonGroup maxTransSizeButtonGroup = new ButtonGroup();
        maxTransSizeButtonGroup.add(this.unlimitedRadioButton);
        maxTransSizeButtonGroup.add(this.sizeRadioButton);
        this.sizeRadioButton.setSelected(true);
        this.sizeTextField.setEnabled(true);
        this.sizeTextField.setValue(new Integer(10));
        this.orderByComboBox = new JComboBox();
        this.refreshOrderByFieldChoices();
        this.orderByComboBox.setEditable(true);
        this.orderByComboBox.addActionListener(this);
        Dimension mySize = new Dimension(150, this.orderByComboBox.getPreferredSize().height);
        this.orderByComboBox.setMaximumSize(mySize);
        this.orderByComboBox.setMinimumSize(mySize);
        this.orderByComboBox.setPreferredSize(mySize);
        String sequencingColumnString = this.getTranslatedString("DB_PO_SEQUENCING_FIELD");
        this.orderByLabel = new JLabel(StringUtils.stripMnemonic((String)sequencingColumnString));
        this.orderByLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)sequencingColumnString));
        this.orderByLabel.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)sequencingColumnString));
        this.orderByLabel.setLabelFor(this.orderByComboBox);
        String delayCommitString = this.getTranslatedString("DB_PO_DELAY_COMMIT");
        this.delayCommitCheckBox = new JCheckBox(StringUtils.stripMnemonic((String)delayCommitString), false);
        this.delayCommitCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)delayCommitString));
        this.delayCommitCheckBox.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)delayCommitString));
        this.delayCommitCheckBox.addActionListener(this);
        String distributedPollingString = this.getTranslatedString("DB_PO_DISTRIB_POLLING");
        this.distributedPollingCheckBox = new JCheckBox(StringUtils.stripMnemonic((String)distributedPollingString), false);
        this.distributedPollingCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)distributedPollingString));
        this.distributedPollingCheckBox.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)distributedPollingString));
        this.distributedPollingCheckBox.addActionListener(this);
        String childUpdatesString = this.getTranslatedString("DB_PO_CHILD_UPDATES");
        this.childUpdatesCheckBox = new JCheckBox(StringUtils.stripMnemonic((String)childUpdatesString), false);
        this.childUpdatesCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)childUpdatesString));
        this.childUpdatesCheckBox.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)childUpdatesString));
        this.childUpdatesCheckBox.addActionListener(this);
        if (!this.isSequencingPollingStrategy()) {
            this.childUpdatesCheckBox.setEnabled(false);
        }
        String batchDestroyString = this.getTranslatedString("DB_PO_BATCH_DESTROY");
        this.batchDestroyCheckBox = new JCheckBox(StringUtils.stripMnemonic((String)batchDestroyString), false);
        this.batchDestroyCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)batchDestroyString));
        this.batchDestroyCheckBox.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)batchDestroyString));
        this.batchDestroyCheckBox.addActionListener(this);
        String enableStreamingString = this.getTranslatedString("DB_PO_ENABLE_STREAMING");
        this.enableStreamingCheckBox = new JCheckBox(StringUtils.stripMnemonic((String)enableStreamingString), false);
        this.enableStreamingCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)enableStreamingString));
        this.enableStreamingCheckBox.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)enableStreamingString));
        this.enableStreamingCheckBox.addActionListener(this);
        String schemaValidationString = this.getTranslatedString("DB_PO_SCHEMA_VALIDATION");
        this.schemaValidationCheckBox = new JCheckBox(StringUtils.stripMnemonic((String)schemaValidationString), false);
        this.schemaValidationCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)schemaValidationString));
        this.schemaValidationCheckBox.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)schemaValidationString));
        this.schemaValidationCheckBox.addActionListener(this);
        String sqlLabelString = this.getTranslatedString("DB_WC_SQL");
        this.sqlLabel = new JLabel(StringUtils.stripMnemonic((String)sqlLabelString));
        this.sqlTextArea = new JTextArea();
        this.sqlTextArea.setEditable(false);
        this.sqlTextArea.setBackground((Color)UIManager.getDefaults().get("TextField.inactiveBackground"));
        this.sqlTextArea.setLineWrap(true);
        this.sqlTextArea.setWrapStyleWord(true);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 3;
        constraints.gridheight = 1;
        this.add((Component)this.instructionsLabel, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.insets = new Insets(30, 0, 0, 12);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.pollingFrequencyLabel, constraints);
        JPanel frequencyPanel = new JPanel(new GridBagLayout());
        constraints.anchor = 10;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(0, 0, 0, 6);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.ipadx = 20;
        frequencyPanel.add((Component)this.intervalNumberField, constraints);
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.fill = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.ipadx = 0;
        frequencyPanel.add((Component)this.intervalUnitsComboBox, constraints);
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.insets = new Insets(30, 0, 0, 0);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.ipadx = 0;
        this.add((Component)frequencyPanel, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.insets = new Insets(12, 0, 0, 12);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.maxRaiseSizeLabel, constraints);
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.insets = new Insets(12, 0, 0, 0);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.ipadx = 50;
        this.add((Component)this.maxRaiseSizeField, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.insets = new Insets(12, 0, 0, 12);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.ipadx = 0;
        this.add((Component)this.maxTransSizeLabel, constraints);
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.insets = new Insets(12, 0, 0, 0);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.unlimitedRadioButton, constraints);
        JPanel sizeRadioButtonPanel = new JPanel(new GridBagLayout());
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(0, 0, 0, 3);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        sizeRadioButtonPanel.add((Component)this.sizeRadioButton, constraints);
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.fill = 2;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.ipadx = 50;
        sizeRadioButtonPanel.add((Component)this.sizeTextField, constraints);
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 4;
        constraints.insets = new Insets(6, 0, 0, 0);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.ipadx = 0;
        this.add((Component)sizeRadioButtonPanel, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.insets = new Insets(12, 0, 0, 0);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.orderByLabel, constraints);
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 5;
        constraints.insets = new Insets(12, 0, 0, 0);
        constraints.fill = 2;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.orderByComboBox, constraints);
        if (this.isSequencingPollingStrategy()) {
            this.orderByComboBox.setEnabled(false);
        }
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 6;
        constraints.insets = new Insets(12, 0, 0, 6);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.delayCommitCheckBox, constraints);
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 6;
        constraints.insets = new Insets(12, 0, 0, 6);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.distributedPollingCheckBox, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 7;
        constraints.insets = new Insets(12, 0, 0, 6);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.childUpdatesCheckBox, constraints);
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 7;
        constraints.insets = new Insets(12, 0, 0, 6);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.batchDestroyCheckBox, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 8;
        constraints.insets = new Insets(12, 0, 0, 6);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.enableStreamingCheckBox, constraints);
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 8;
        constraints.insets = new Insets(12, 0, 0, 6);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.schemaValidationCheckBox, constraints);
        JPanel sqlPanel = new JPanel(new GridBagLayout());
        constraints.anchor = 18;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        sqlPanel.add((Component)this.sqlLabel, constraints);
        constraints.anchor = 10;
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.insets = new Insets(6, 0, 0, 0);
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 3;
        constraints.gridheight = 1;
        JScrollPane scrollPane = new JScrollPane(this.sqlTextArea);
        sqlPanel.add((Component)scrollPane, constraints);
        constraints.anchor = 10;
        constraints.gridx = 2;
        constraints.gridy = 1;
        constraints.insets = new Insets(30, 12, 0, 0);
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 7;
        this.add((Component)sqlPanel, constraints);
        if (this.m_wcontext._read_service != null) {
            this.populateUIForEdit();
            XRAdapterUtil.refreshSQLPanes(this.m_wcontext);
        }
        JTextField comboBoxTextField = (JTextField)this.orderByComboBox.getEditor().getEditorComponent();
        comboBoxTextField.getDocument().addDocumentListener(this);
        this.sizeTextField.getDocument().addDocumentListener(this);
    }

    private void populateUIForEdit() {
        JcaOperation jop = this.m_wcontext._read_jca_operation;
        XRAdapterWizardContext context = (XRAdapterWizardContext)this.m_wcontext._ascontext;
        RelationalDescriptor desc = context._rootDescriptor;
        String queryName = jop.getAttributeValue("QueryName");
        ObjectLevelReadQuery query = null;
        if (queryName != null) {
            query = (ObjectLevelReadQuery)desc.getQueryManager().getQuery(queryName);
        }
        if (query != null) {
            this.distributedPollingCheckBox.setSelected(query.isLockQuery());
        }
        String activationSpecType = jop.getAttributeValue("ActivationSpec");
        String interactionSpecType = jop.getAttributeValue("InteractionSpec");
        if (activationSpecType != null) {
            this.populatePollingIntervalForEdit(jop.getAttributeValue(s_PollingInterval));
            this.maxRaiseSizeField.setValue(new Integer(jop.getAttributeValue(s_MaxRaiseSize)));
            if (jop.getAttributeValue(s_MaxTransactionSize).equals(s_unlimited) || jop.getAttributeValue(s_MaxTransactionSize).equals("null")) {
                this.unlimitedRadioButton.setSelected(true);
                this.sizeTextField.setEnabled(false);
            } else {
                this.sizeRadioButton.setSelected(true);
                this.sizeTextField.setEnabled(true);
                this.sizeTextField.setValue(new Integer(jop.getAttributeValue(s_MaxTransactionSize)));
            }
            String seqFieldName = jop.getAttributeValue(s_SequencingColumn);
            if (this.ascontext._sequencingColumn != null) {
                this.orderByComboBox.setSelectedItem(this.ascontext._sequencingColumn);
                this.orderByComboBox.setEnabled(false);
            } else if (seqFieldName != null && !seqFieldName.equals("")) {
                this.orderByComboBox.setSelectedItem(seqFieldName);
            } else {
                this.orderByComboBox.setSelectedIndex(0);
            }
            if (this.batchDestroyCheckBox.isEnabled()) {
                this.batchDestroyCheckBox.setSelected(new Boolean(jop.getAttributeValue(s_UseBatchDestroy)));
            }
            if (this.delayCommitCheckBox.isEnabled()) {
                this.delayCommitCheckBox.setSelected(new Boolean(jop.getAttributeValue(s_DelayCommit)));
            }
            if (this.childUpdatesCheckBox.isEnabled()) {
                this.childUpdatesCheckBox.setSelected(new Boolean(jop.getAttributeValue(s_PollForChildUpdates)));
            }
            if (this.enableStreamingCheckBox.isEnabled()) {
                this.enableStreamingCheckBox.setSelected(new Boolean(jop.getAttributeValue(s_EnableStreaming)));
            }
            if (this.schemaValidationCheckBox.isEnabled()) {
                this.schemaValidationCheckBox.setSelected(new Boolean(jop.getAttributeValue(s_SchemaValidation)));
            }
        }
    }

    private void populatePollingIntervalForEdit(String rawPollingInterval) {
        this.pollingFrequencyLabel.setEnabled(true);
        this.intervalNumberField.setEnabled(true);
        this.intervalUnitsComboBox.setEnabled(true);
        BigDecimal pollingInterval = new BigDecimal(rawPollingInterval);
        int intVal = 0;
        if (pollingInterval.doubleValue() > (double)pollingInterval.intValue()) {
            intVal = pollingInterval.multiply(new BigDecimal(1000)).intValue();
            this.intervalUnitsComboBox.setSelectedItem(this.m_wcontext.TIME_MILLISECONDS);
        } else {
            intVal = pollingInterval.intValue();
        }
        this.intervalNumberField.setValue(new Integer(intVal));
    }

    public void refreshOrderByFieldChoices() {
        RelationalDescriptor descriptor = this.ascontext._rootDescriptor;
        ArrayList columns = XRAdapterUtil.getColumnNamesFromDBProperties(descriptor.getTables(), this.ascontext._dtProps);
        Object[] masterTableFieldNames = columns.toArray();
        Arrays.sort(masterTableFieldNames);
        Object[] comboboxContents = new Object[masterTableFieldNames.length + 1];
        comboboxContents[0] = this.getTranslatedString("DB_PO_NO_ORDERING");
        for (int i = 0; i < masterTableFieldNames.length; ++i) {
            comboboxContents[i + 1] = masterTableFieldNames[i];
        }
        this.orderByComboBox.setModel(new DefaultComboBoxModel<Object>(comboboxContents));
        if (this.ascontext._sequencingColumn != null) {
            this.orderByComboBox.setSelectedItem(this.ascontext._sequencingColumn);
        } else if (descriptor.getPrimaryKeyFields().size() == 1) {
            Vector mappings = descriptor.getMappings();
            boolean needsWorkaround = false;
            for (int i = 0; i < mappings.size(); ++i) {
                DatabaseMapping dbMapping = (DatabaseMapping)mappings.get(i);
                if (dbMapping.isCollectionMapping() && ((CollectionMapping)dbMapping).shouldUseBatchReading()) {
                    needsWorkaround = true;
                    break;
                }
                if (!dbMapping.isOneToOneMapping() || !((OneToOneMapping)dbMapping).shouldUseBatchReading() || ((OneToOneMapping)dbMapping).isForeignKeyRelationship()) continue;
                needsWorkaround = true;
                break;
            }
            if (needsWorkaround) {
                DatabaseField field = (DatabaseField)descriptor.getPrimaryKeyFields().get(0);
                String pk = field.getName();
                this.orderByComboBox.setSelectedItem(pk);
            }
        }
    }

    private boolean isSequencingPollingStrategy() {
        if (this.ascontext._afterReadPage != null) {
            return this.ascontext._afterReadPage.isSequencingPollingStrategy();
        }
        return false;
    }

    public void setSQL(String sql, boolean error) {
        this.sqlTextArea.setForeground(error ? this.errorSQLColour : this.normalSQLColour);
        this.sqlTextArea.setText(sql);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.unlimitedRadioButton) {
            this.sizeTextField.setEnabled(false);
            this.delayCommitCheckBox.setEnabled(false);
            this.delayCommitCheckBox.setSelected(false);
        }
        if (e.getSource() == this.sizeRadioButton) {
            this.sizeTextField.setEnabled(true);
            this.delayCommitCheckBox.setEnabled(true);
            this.delayCommitCheckBox.setSelected(false);
        }
        if (e.getSource() == this.childUpdatesCheckBox) {
            if (this.childUpdatesCheckBox.isSelected()) {
                this.delayCommitCheckBox.setEnabled(true);
                this.delayCommitCheckBox.setSelected(true);
            } else {
                this.delayCommitCheckBox.setEnabled(true);
                this.delayCommitCheckBox.setSelected(false);
            }
        }
        XRAdapterUtil.refreshSQLPanes(this.m_wcontext);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        XRAdapterUtil.refreshSQLPanes(this.m_wcontext);
        this.checkToEnableNext();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        XRAdapterUtil.refreshSQLPanes(this.m_wcontext);
        this.checkToEnableNext();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        XRAdapterUtil.refreshSQLPanes(this.m_wcontext);
        this.checkToEnableNext();
    }

    private void checkToEnableNext() {
        boolean idFieldSet;
        JTextField comboboxTextField = (JTextField)this.orderByComboBox.getEditor().getEditorComponent();
        boolean bl = idFieldSet = !comboboxTextField.getText().trim().equals("");
        if (idFieldSet) {
            this.m_page.setCanAdvance(true);
        } else {
            this.m_page.setCanAdvance(false);
        }
    }

    public String calculatePollingIntervalSeconds() {
        String units = (String)this.intervalUnitsComboBox.getSelectedItem();
        BigDecimal pollingInterval = new BigDecimal(this.getInt(this.intervalNumberField.getValue()));
        if (!units.equals(this.m_wcontext.TIME_SECONDS)) {
            if (units.equals(this.m_wcontext.TIME_MILLISECONDS)) {
                pollingInterval = pollingInterval.divide(new BigDecimal(1000));
            } else if (units.equals(this.m_wcontext.TIME_MINUTES)) {
                pollingInterval = pollingInterval.multiply(new BigDecimal(60));
            } else if (units.equals(this.m_wcontext.TIME_HOURS)) {
                pollingInterval = pollingInterval.multiply(new BigDecimal(3600));
            } else if (units.equals(this.m_wcontext.TIME_DAYS)) {
                pollingInterval = pollingInterval.multiply(new BigDecimal(86400));
            } else if (units.equals(this.m_wcontext.TIME_WEEKS)) {
                pollingInterval = pollingInterval.multiply(new BigDecimal(604800));
            }
        }
        return pollingInterval.toString();
    }

    @Override
    public void buildWSDL() throws WSDLException {
        this.ascontext._inboundSelectOp.setAttributeValue(s_PollingInterval, this.calculatePollingIntervalSeconds());
        this.ascontext._inboundSelectOp.setAttributeValue(s_MaxRaiseSize, String.valueOf(this.maxRaiseSizeField.getText()));
        if (this.unlimitedRadioButton.isSelected()) {
            this.ascontext._inboundSelectOp.setAttributeValue(s_MaxTransactionSize, s_unlimited);
        } else {
            this.ascontext._inboundSelectOp.setAttributeValue(s_MaxTransactionSize, String.valueOf(this.sizeTextField.getValue()));
        }
        if (this.orderByComboBox.getSelectedIndex() != 0) {
            this.ascontext._inboundSelectOp.setAttributeValue(s_SequencingColumn, this.orderByComboBox.getSelectedItem().toString());
        } else if (this.ascontext._inboundSelectOp.getAttributeValue(s_SequencingColumn) != null) {
            this.ascontext._inboundSelectOp.removeAttribute(s_SequencingColumn);
        }
        if (this.batchDestroyCheckBox.isSelected() || this.ascontext._inboundSelectOp.getAttributeValue(s_UseBatchDestroy) != null) {
            this.ascontext._inboundSelectOp.setAttributeValue(s_UseBatchDestroy, this.batchDestroyCheckBox.isSelected() ? s_true : s_false);
        }
        if (this.delayCommitCheckBox.isSelected() || this.ascontext._inboundSelectOp.getAttributeValue(s_DelayCommit) != null) {
            this.ascontext._inboundSelectOp.setAttributeValue(s_DelayCommit, this.delayCommitCheckBox.isSelected() ? s_true : s_false);
        }
        if (this.childUpdatesCheckBox.isSelected() || this.ascontext._inboundSelectOp.getAttributeValue(s_PollForChildUpdates) != null) {
            this.ascontext._inboundSelectOp.setAttributeValue(s_PollForChildUpdates, this.childUpdatesCheckBox.isSelected() ? s_true : s_false);
        }
        if (this.enableStreamingCheckBox.isSelected() || this.ascontext._inboundSelectOp.getAttributeValue(s_EnableStreaming) != null) {
            this.ascontext._inboundSelectOp.setAttributeValue(s_EnableStreaming, this.enableStreamingCheckBox.isSelected() ? s_true : s_false);
        }
        if (this.schemaValidationCheckBox.isSelected() || this.ascontext._inboundSelectOp.getAttributeValue(s_SchemaValidation) != null) {
            this.ascontext._inboundSelectOp.setAttributeValue(s_SchemaValidation, this.schemaValidationCheckBox.isSelected() ? s_true : s_false);
        }
        if (this.ascontext._inboundSelectOp.getAttributeValue("NumberOfThreads") == null) {
            this.ascontext._inboundSelectOp.setAttributeValue("NumberOfThreads", "1");
        }
    }

    @Override
    public void buildSpec(TopLinkReadSpec spec) {
        if (spec instanceof DBActivationSpec) {
            DBActivationSpec activationSpec = (DBActivationSpec)spec;
            activationSpec.setPollingInterval(this.calculatePollingIntervalSeconds());
            if (!this.maxRaiseSizeField.getText().equals("")) {
                activationSpec.setMaxRaiseSize(this.maxRaiseSizeField.getText());
            } else {
                activationSpec.setMaxRaiseSize(null);
            }
            if (this.unlimitedRadioButton.isSelected()) {
                activationSpec.setMaxTransactionSize(s_unlimited);
            } else {
                activationSpec.setMaxTransactionSize(String.valueOf(this.sizeTextField.getValue()));
            }
            if (this.orderByComboBox.getSelectedIndex() != 0) {
                activationSpec.setSequencingColumn(this.orderByComboBox.getSelectedItem().toString());
            }
            activationSpec.setUseBatchDestroy(this.batchDestroyCheckBox.isSelected() ? s_true : s_false);
            activationSpec.setDelayCommit(this.delayCommitCheckBox.isSelected() ? s_true : s_false);
            activationSpec.setPollForChildUpdates(this.childUpdatesCheckBox.isSelected() ? s_true : s_false);
            activationSpec.setEnableStreaming(this.enableStreamingCheckBox.isSelected() ? s_true : s_false);
            activationSpec.setSchemaValidation(this.schemaValidationCheckBox.isSelected() ? s_true : s_false);
            ObjectLevelReadQuery query = (ObjectLevelReadQuery)this.ascontext._query;
            if (this.distributedPollingCheckBox.isSelected()) {
                query.setShouldRefreshIdentityMapResult(true);
                query.setShouldRefreshRemoteIdentityMapResult(true);
                query.setLockMode((short)2);
            } else {
                query.setShouldRefreshIdentityMapResult(false);
                query.setShouldRefreshRemoteIdentityMapResult(false);
                query.setLockMode((short)0);
            }
        }
    }
}

