/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.tip.adapter.db.DBAdapterConstants;
import oracle.tip.adapter.db.api.TopLinkReadSpec;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.puresql.DBAdapterPureSQLPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.DBAdapterSPAdvancedOptionsPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.IDBAdapterStoredProcPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.IDatabase;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.sp.Platform;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaBinding;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.PCInboundBinding;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.PartnerLinkType;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterAdvancedOptionsPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterSelectTablesPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterUtil;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterWizardFinish;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;

public class XRAdapterOperationPage
extends techAdapterWizardPage
implements ActionListener,
XRAdapterPage {
    private MultiLineLabel instructionsLabel;
    private JLabel operationTypeLabel;
    private JRadioButton storedProcedureRadioButton;
    private JRadioButton outboundTablesRadioButton;
    private JCheckBox mergeCheckBox;
    private JCheckBox insertCheckBox;
    private JCheckBox updateCheckBox;
    private JCheckBox deleteCheckBox;
    private JCheckBox selectCheckBox;
    private JCheckBox queryByExampleCheckBox;
    private JRadioButton inboundTablesRadioButton;
    private JRadioButton executeSQLRadioButton;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private JCheckBox synchPostCheckBox;
    private XRAdapterWizardContext ascontext;
    private XRAdapterWizardFinish finishPage;
    private boolean usesOldInparameters;
    public static final String s_DmlType = "DmlType";
    public static final String s_MergeDmlType = "merge";
    public static final String s_WriteDmlType = "write";
    public static final String s_InsertDmlType = "insert";
    public static final String s_UpdateDmlType = "update";
    public static final String s_DeleteDmlType = "delete";
    public static final String s_DescriptorName = "DescriptorName";
    public static final String s_QueryName = "QueryName";
    public static final String s_OptimizeMerge = "OptimizeMerge";
    public static final String s_ORProject = "MappingsMetaDataURL";
    public static final String s_OXProject = "OXMappingsMetaDataURL";
    public static final String s_CursorWindowSize = "CursorWindowSize";
    public static final String s_DetectOmissions = "DetectOmissions";
    public static final String s_OutputCompletedXml = "OutputCompletedXml";
    public static final String s_UseDirectSql = "UseDirectSql";
    public static final String s_MaxBatchWritingSize = "MaxBatchWritingSize";
    ReAddPagesRunnable reAddPagesRunnable;

    public XRAdapterOperationPage(AdapterWizardContext context, ImageWizardPage page) {
        try {
            if (context._ascontext == null || !(context._ascontext instanceof XRAdapterWizardContext)) {
                context._ascontext = new XRAdapterWizardContext(this);
            }
            this.ascontext = (XRAdapterWizardContext)context._ascontext;
            this.finishPage = (XRAdapterWizardFinish)context._adapterWizardFinish;
            if (context._service_type.equals("Apps")) {
                this.ascontext._operationPage = this;
                context._ascontext = this.ascontext;
            }
            XRAdapterUtil.m_wcontext = context;
            this.setContextAndPage(context, page);
            this.m_page.setCanAdvance(false);
            this.initializeUI();
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)this.m_wcontext._parentFrame, (Exception)e);
        }
    }

    private void initializeUI() {
        this.setLayout(new GridBagLayout());
        String instructionsText = this.getTranslatedString("DB_OP_INTRO_PROMPT");
        this.instructionsLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), instructionsText);
        this.operationTypeLabel = new JLabel(this.getTranslatedString("DB_OP_TYPE"));
        String storedProcedureRadioButtonString = this.getTranslatedString("DB_OP_STOREDPROC");
        this.storedProcedureRadioButton = new JRadioButton(StringUtils.stripMnemonic((String)storedProcedureRadioButtonString));
        this.storedProcedureRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)storedProcedureRadioButtonString));
        this.storedProcedureRadioButton.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)storedProcedureRadioButtonString));
        this.storedProcedureRadioButton.addActionListener(this);
        String inboundTablesRadioButtonString = this.getTranslatedString("DB_OP_INBOUND");
        this.inboundTablesRadioButton = new JRadioButton(StringUtils.stripMnemonic((String)inboundTablesRadioButtonString));
        this.inboundTablesRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)inboundTablesRadioButtonString));
        this.inboundTablesRadioButton.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)inboundTablesRadioButtonString));
        this.inboundTablesRadioButton.addActionListener(this);
        String outboundTablesRadioButtonString = this.getTranslatedString("DB_OP_OUTBOUND");
        this.outboundTablesRadioButton = new JRadioButton(StringUtils.stripMnemonic((String)outboundTablesRadioButtonString));
        this.outboundTablesRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)outboundTablesRadioButtonString));
        this.outboundTablesRadioButton.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)outboundTablesRadioButtonString));
        this.outboundTablesRadioButton.addActionListener(this);
        String executeSQLRadioButtonString = this.getTranslatedString("DB_OP_EXECUTE_SQL");
        this.executeSQLRadioButton = new JRadioButton(StringUtils.stripMnemonic((String)executeSQLRadioButtonString));
        this.executeSQLRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)executeSQLRadioButtonString));
        this.executeSQLRadioButton.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)executeSQLRadioButtonString));
        this.executeSQLRadioButton.addActionListener(this);
        String upsertString = this.getTranslatedString("DB_OP_INSERTUPDATE");
        this.mergeCheckBox = new JCheckBox(StringUtils.stripMnemonic((String)upsertString), true);
        this.mergeCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)upsertString));
        this.mergeCheckBox.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)upsertString));
        this.mergeCheckBox.addActionListener(this);
        this.mergeCheckBox.setEnabled(false);
        String insertString = this.getTranslatedString("DB_OP_INSERT_ONLY");
        if (this.m_wcontext._service_type.equals("Apps")) {
            insertString = this.getTranslatedString("DB_OP_INSERT");
        }
        this.insertCheckBox = new JCheckBox(StringUtils.stripMnemonic((String)insertString), true);
        this.insertCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)insertString));
        this.insertCheckBox.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)insertString));
        this.insertCheckBox.addActionListener(this);
        this.insertCheckBox.setEnabled(false);
        String updateString = this.getTranslatedString("DB_OP_UPDATE");
        this.updateCheckBox = new JCheckBox(StringUtils.stripMnemonic((String)updateString), false);
        this.updateCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)updateString));
        this.updateCheckBox.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)updateString));
        this.updateCheckBox.addActionListener(this);
        this.updateCheckBox.setEnabled(false);
        String deleteString = this.getTranslatedString("DB_OP_DELETE");
        this.deleteCheckBox = new JCheckBox(StringUtils.stripMnemonic((String)deleteString), false);
        this.deleteCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)deleteString));
        this.deleteCheckBox.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)deleteString));
        this.deleteCheckBox.addActionListener(this);
        this.deleteCheckBox.setEnabled(false);
        String selectString = this.getTranslatedString("DB_OP_SELECT");
        this.selectCheckBox = new JCheckBox(StringUtils.stripMnemonic((String)selectString), true);
        this.selectCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)selectString));
        this.selectCheckBox.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)selectString));
        this.selectCheckBox.addActionListener(this);
        this.selectCheckBox.setEnabled(false);
        String queryByExampleString = this.getTranslatedString("DB_OP_QUERY_BY_EXAMPLE");
        this.queryByExampleCheckBox = new JCheckBox(StringUtils.stripMnemonic((String)queryByExampleString), false);
        this.queryByExampleCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)queryByExampleString));
        this.queryByExampleCheckBox.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)queryByExampleString));
        this.queryByExampleCheckBox.addActionListener(this);
        this.queryByExampleCheckBox.setEnabled(false);
        this.buttonGroup.add(this.storedProcedureRadioButton);
        this.buttonGroup.add(this.inboundTablesRadioButton);
        this.buttonGroup.add(this.outboundTablesRadioButton);
        this.buttonGroup.add(this.executeSQLRadioButton);
        String synchPostString = this.getTranslatedString("DB_OP_DO_SYNCH_POST");
        this.synchPostCheckBox = new JCheckBox(StringUtils.stripMnemonic((String)synchPostString), false);
        this.synchPostCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)synchPostString));
        this.synchPostCheckBox.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)synchPostString));
        this.synchPostCheckBox.addActionListener(this);
        this.synchPostCheckBox.setEnabled(false);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        this.add((Component)this.instructionsLabel, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.insets = new Insets(30, 0, 0, 0);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.operationTypeLabel, constraints);
        int outboundTablesRadioButtonYCoord = 2;
        Insets outboundTablesRadioButtonInsets = new Insets(0, 12, 0, 0);
        if (this.m_wcontext._service_type.equals("Apps")) {
            outboundTablesRadioButtonYCoord = 1;
            outboundTablesRadioButtonInsets = new Insets(30, 12, 0, 0);
        } else {
            constraints.anchor = 17;
            constraints.gridx = 1;
            constraints.gridy = 1;
            constraints.insets = new Insets(30, 12, 0, 0);
            constraints.fill = 0;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            this.add((Component)this.storedProcedureRadioButton, constraints);
        }
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = outboundTablesRadioButtonYCoord;
        constraints.insets = outboundTablesRadioButtonInsets;
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.outboundTablesRadioButton, constraints);
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.insets = new Insets(0, 36, 0, 0);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        if (this.m_wcontext._service_type.equals("Apps")) {
            this.mergeCheckBox.setSelected(false);
        } else {
            this.add((Component)this.mergeCheckBox, constraints);
        }
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 4;
        constraints.insets = new Insets(0, 36, 0, 0);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.insertCheckBox, constraints);
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 5;
        constraints.insets = new Insets(0, 36, 0, 0);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        if (this.m_wcontext._service_type.equals("Apps")) {
            this.updateCheckBox.setSelected(false);
        } else {
            this.add((Component)this.updateCheckBox, constraints);
        }
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 6;
        constraints.insets = new Insets(0, 36, 0, 0);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        if (this.m_wcontext._service_type.equals("Apps")) {
            this.deleteCheckBox.setSelected(false);
        } else {
            this.add((Component)this.deleteCheckBox, constraints);
        }
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 7;
        constraints.insets = new Insets(0, 36, 0, 0);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.selectCheckBox, constraints);
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 8;
        constraints.insets = new Insets(0, 36, 0, 0);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        if (this.m_wcontext._service_type.equals("Apps")) {
            this.queryByExampleCheckBox.setSelected(false);
        } else {
            this.add((Component)this.queryByExampleCheckBox, constraints);
        }
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 9;
        constraints.insets = new Insets(0, 12, 0, 0);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.inboundTablesRadioButton, constraints);
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 10;
        constraints.insets = new Insets(0, 12, 0, 0);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        if (!this.m_wcontext._service_type.equals("Apps")) {
            this.add((Component)this.executeSQLRadioButton, constraints);
        }
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 11;
        constraints.insets = new Insets(24, 0, 0, 0);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        this.add((Component)this.synchPostCheckBox, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 12;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        this.add((Component)new JPanel(), constraints);
        if (this.m_wcontext._read_service != null) {
            this.populateUIForEdit();
        }
    }

    public boolean isMergeSelected() {
        return this.outboundTablesRadioButton.isSelected() && this.mergeCheckBox.isSelected();
    }

    public boolean isInsertSelected() {
        return this.outboundTablesRadioButton.isSelected() && this.insertCheckBox.isSelected();
    }

    public boolean isUpdateSelected() {
        return this.outboundTablesRadioButton.isSelected() && this.updateCheckBox.isSelected();
    }

    public boolean isDeleteSelected() {
        return this.outboundTablesRadioButton.isSelected() && this.deleteCheckBox.isSelected();
    }

    public boolean isSelectSelected() {
        return this.outboundTablesRadioButton.isSelected() && this.selectCheckBox.isSelected();
    }

    public boolean isQueryByExampleSelected() {
        return this.outboundTablesRadioButton.isSelected() && this.queryByExampleCheckBox.isSelected();
    }

    public boolean isAnyOutboundOpSelected() {
        return this.isMergeSelected() || this.isInsertSelected() || this.isUpdateSelected() || this.isDeleteSelected() || this.isSelectSelected() || this.isQueryByExampleSelected();
    }

    public boolean isSynchPostSelected() {
        return this.inboundTablesRadioButton.isSelected() && this.synchPostCheckBox.isSelected();
    }

    private void populateUIForEdit() {
        this.m_page.setCanAdvance(true);
        JcaOperation jop = this.m_wcontext._read_jca_operation;
        String activationSpecType = jop.getAttributeValue("ActivationSpec");
        String interactionSpecType = jop.getAttributeValue("InteractionSpec");
        this.storedProcedureRadioButton.setEnabled(false);
        this.synchPostCheckBox.setSelected(false);
        if (interactionSpecType != null) {
            if (interactionSpecType.equals("oracle.tip.adapter.db.DBPureSQLInteractionSpec")) {
                this.outboundTablesRadioButton.setEnabled(false);
                this.inboundTablesRadioButton.setEnabled(false);
                this.executeSQLRadioButton.setSelected(true);
                ImageWizardPage tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("DB_SQL_TITLE"));
                if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                    HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_db_customsql");
                }
                new DBAdapterPureSQLPage(this.m_wcontext, tempwp);
                tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("DB_AO_TITLE"));
                if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                    HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_db_ao");
                }
                new XRAdapterAdvancedOptionsPage(this.m_wcontext, tempwp);
                XRAdapterUtil.setFinishPage(this);
                return;
            }
        }
        if (activationSpecType != null) {
            this.outboundTablesRadioButton.setEnabled(false);
            this.executeSQLRadioButton.setEnabled(false);
            this.inboundTablesRadioButton.setSelected(true);
            this.ascontext._inboundSelectOp = jop;
            this.synchPostCheckBox.setEnabled(true);
            if (this.ascontext._inboundSelectOp != null && this.m_wcontext._read_operation != null && this.m_wcontext._read_operation.getOutput() != null) {
                this.synchPostCheckBox.setSelected(true);
            }
            this.m_wcontext._isInboundOperation = true;
            this.ascontext._isOutboundSelectOp = false;
            this.reAddPages(true);
        }
        if (interactionSpecType != null) {
            this.m_wcontext._isInboundOperation = false;
            this.mergeCheckBox.setEnabled(true);
            this.insertCheckBox.setEnabled(true);
            this.updateCheckBox.setEnabled(true);
            this.deleteCheckBox.setEnabled(true);
            this.selectCheckBox.setEnabled(true);
            this.queryByExampleCheckBox.setEnabled(true);
            this.mergeCheckBox.setSelected(false);
            this.insertCheckBox.setSelected(false);
            this.updateCheckBox.setSelected(false);
            this.deleteCheckBox.setSelected(false);
            this.selectCheckBox.setSelected(false);
            this.queryByExampleCheckBox.setSelected(false);
            this.executeSQLRadioButton.setEnabled(false);
            this.inboundTablesRadioButton.setEnabled(false);
            this.outboundTablesRadioButton.setSelected(true);
            Definition def = this.m_wcontext._read_definition;
            Iterator bindingsIterator = def.getBindings().values().iterator();
            if (bindingsIterator.hasNext()) {
                Binding binding = (Binding)bindingsIterator.next();
                for (BindingOperation operation : binding.getBindingOperations()) {
                    for (JcaOperation jcaOperation : operation.getExtensibilityElements()) {
                        String dmlType = jcaOperation.getAttributeValue(s_DmlType);
                        if (dmlType == null) {
                            if ("true".equals(jcaOperation.getAttributeValue("IsQueryByExample"))) {
                                this.ascontext._outboundQueryByExampleOp = jcaOperation;
                                this.queryByExampleCheckBox.setSelected(true);
                                continue;
                            }
                            this.ascontext._outboundSelectOp = jcaOperation;
                            this.selectCheckBox.setSelected(true);
                            this.ascontext._isOutboundSelectOp = true;
                            for (Object message_obj : def.getMessages().values()) {
                                Message message = (Message)message_obj;
                                for (Object part_obj : message.getParts().values()) {
                                    Part part = (Part)part_obj;
                                    if (part.getName() == null || !part.getName().endsWith("_inparameters")) continue;
                                    this.usesOldInparameters = true;
                                }
                            }
                            continue;
                        }
                        if (dmlType.equals(s_MergeDmlType)) {
                            this.mergeCheckBox.setSelected(true);
                            this.ascontext._outboundMergeOp = jcaOperation;
                            continue;
                        }
                        if (dmlType.equals(s_WriteDmlType)) {
                            this.mergeCheckBox.setSelected(true);
                            this.ascontext._outboundWriteOp = jcaOperation;
                            continue;
                        }
                        if (dmlType.equals(s_InsertDmlType)) {
                            this.insertCheckBox.setSelected(true);
                            this.ascontext._outboundInsertOp = jcaOperation;
                            continue;
                        }
                        if (dmlType.equals(s_UpdateDmlType)) {
                            this.updateCheckBox.setSelected(true);
                            this.ascontext._outboundUpdateOp = jcaOperation;
                            continue;
                        }
                        if (!dmlType.equals(s_DeleteDmlType)) continue;
                        this.deleteCheckBox.setSelected(true);
                        this.ascontext._outboundDeleteOp = jcaOperation;
                    }
                }
                this.reAddPages(true);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.synchPostCheckBox) {
            return;
        }
        this.m_page.setCanAdvance(false);
        this.m_wizard.setMustFinish(true);
        if (e.getSource() instanceof JRadioButton) {
            boolean enableOutboundChoices = e.getSource() == this.outboundTablesRadioButton;
            this.mergeCheckBox.setEnabled(enableOutboundChoices);
            this.insertCheckBox.setEnabled(enableOutboundChoices);
            this.updateCheckBox.setEnabled(enableOutboundChoices);
            this.deleteCheckBox.setEnabled(enableOutboundChoices);
            this.selectCheckBox.setEnabled(enableOutboundChoices);
            this.queryByExampleCheckBox.setEnabled(enableOutboundChoices);
            this.synchPostCheckBox.setEnabled(e.getSource() == this.inboundTablesRadioButton);
            if (e.getSource() != this.inboundTablesRadioButton) {
                this.synchPostCheckBox.setSelected(false);
            }
            if (e.getSource() == this.outboundTablesRadioButton) {
                if (this.isAnyOutboundOpSelected()) {
                    this.m_page.setCanAdvance(true);
                    this.ascontext._isOutboundSelectOp = this.selectCheckBox.isSelected();
                    this.m_wcontext._isInboundOperation = false;
                    this.ascontext._isPureSQLOp = false;
                    this.reAddPages(false);
                } else {
                    this.m_page.setCanAdvance(false);
                }
            }
            if (e.getSource() == this.inboundTablesRadioButton) {
                this.m_page.setCanAdvance(true);
                this.ascontext._isOutboundSelectOp = false;
                this.m_wcontext._isInboundOperation = true;
                this.ascontext._isPureSQLOp = false;
                this.reAddPages(false);
            }
            if (e.getSource() == this.storedProcedureRadioButton) {
                this.m_wcontext._isInboundOperation = false;
                this.ascontext._isPureSQLOp = false;
                this.ascontext._isOutboundSelectOp = false;
                if (this.reAddPagesRunnable != null) {
                    this.reAddPagesRunnable.waitForFinish();
                }
                this.removePages();
                this.m_page.setCanAdvance(true);
                this.addFinishPage();
                return;
            }
            if (e.getSource() == this.executeSQLRadioButton) {
                this.m_page.setCanAdvance(true);
                this.m_wcontext._isInboundOperation = false;
                this.ascontext._isOutboundSelectOp = false;
                this.ascontext._isPureSQLOp = true;
                if (this.reAddPagesRunnable != null) {
                    this.reAddPagesRunnable.waitForFinish();
                }
                this.removePages();
                ImageWizardPage tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("DB_SQL_TITLE"));
                if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                    HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_db_cust_sql");
                }
                new DBAdapterPureSQLPage(this.m_wcontext, tempwp);
                tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("DB_AO_TITLE"));
                if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                    HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_db_ao");
                }
                new XRAdapterAdvancedOptionsPage(this.m_wcontext, tempwp);
                XRAdapterUtil.setFinishPage(this);
                this.m_wizard.setMustFinish(true);
                return;
            }
            return;
        }
        if (e.getSource() instanceof JCheckBox && this.outboundTablesRadioButton.isSelected()) {
            if (this.isAnyOutboundOpSelected()) {
                this.m_page.setCanAdvance(true);
                this.ascontext._isOutboundSelectOp = this.selectCheckBox.isSelected();
                this.m_wcontext._isInboundOperation = false;
                this.ascontext._isPureSQLOp = false;
                if (e.getSource() == this.selectCheckBox && this.selectCheckBox.isSelected() && this.ascontext._query == null && this.ascontext._rootDescriptor != null) {
                    String queryName = this.m_wcontext._write_service_name + "Select";
                    RelationalDescriptor root = this.ascontext._rootDescriptor;
                    ReadAllQuery raq = (ReadAllQuery)root.getQueryManager().getQuery(queryName);
                    if (raq == null) {
                        raq = new ReadAllQuery();
                        raq.setReferenceClass(root.getJavaClass());
                        raq.setReferenceClassName(root.getJavaClassName());
                        raq.setDescriptor((ClassDescriptor)root);
                        root.getQueryManager().addQuery(queryName, (DatabaseQuery)raq);
                    }
                    this.ascontext._query = raq;
                }
                this.reAddPages(false);
            } else {
                this.m_page.setCanAdvance(false);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reAddPages(boolean inInitialization) {
        boolean firstTime = false;
        if (this.reAddPagesRunnable == null) {
            this.reAddPagesRunnable = new ReAddPagesRunnable();
            firstTime = true;
        }
        ReAddPagesRunnable reAddPagesRunnable = this.reAddPagesRunnable;
        synchronized (reAddPagesRunnable) {
            this.reAddPagesRunnable.inInitialization = inInitialization;
            if (firstTime || this.reAddPagesRunnable.finished) {
                SwingUtilities.invokeLater(this.reAddPagesRunnable);
            } else {
                this.reAddPagesRunnable.startAgain = true;
            }
        }
    }

    @Override
    public void wizardValidatePage(WizardEvent event) {
        if (this.storedProcedureRadioButton.isSelected()) {
            IDatabase database = null;
            try {
                database = Platform.getDatabase(this.m_wcontext);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.m_wcontext._ascontext = database.getDBAdapterSPUserInput();
            ImageWizardPage tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("DB_SP_SPECIFY_STORED_PROCEDURE"));
            if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_db_ssp");
            }
            try {
                this.removePages();
                IDBAdapterStoredProcPage procPage = database.getDBAdapterStoredProcPage(this.m_wcontext, tempwp);
                ImageWizardPage tempAdv = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("DB_AO_TITLE"));
                if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                    HelpSystem.getHelpSystem().registerTopic((JComponent)tempAdv.getContent(), "bpmjdev_adp_wiz_db_ao");
                }
                DBAdapterSPAdvancedOptionsPage nextPage = new DBAdapterSPAdvancedOptionsPage(this.m_wcontext, tempAdv);
                this.m_page.setCanAdvance(true);
                this.addFinishPage();
            }
            catch (Exception ex) {
                this.addFinishPage();
                ((Cancelable)event).cancel();
            }
        } else if ((this.inboundTablesRadioButton.isSelected() || this.outboundTablesRadioButton.isSelected()) && this.reAddPagesRunnable != null) {
            this.reAddPagesRunnable.waitForFinish();
        }
    }

    @Override
    public void buildWSDL() throws WSDLException {
        boolean outputCompletedXml;
        boolean isNew;
        if (this.storedProcedureRadioButton.isSelected()) {
            return;
        }
        if (this.executeSQLRadioButton.isSelected()) {
            return;
        }
        Definition def = this.m_wcontext._write_definition;
        String topNamespace = DBAdapterConstants.xsdNamespace((String)XRAdapterUtil.getPackageName(this.m_wcontext));
        def.addNamespace("top", topNamespace);
        PortType portType = this.createPortType(this.m_wcontext._write_service_name + this.m_wcontext.PortType_suffix);
        Binding binding = def.createBinding();
        binding.setPortType(portType);
        binding.setQName(new QName(this.m_wcontext._target_namespace, this.m_wcontext._write_service_name + this.m_wcontext.Binding_suffix));
        binding.setUndefined(false);
        def.addBinding(binding);
        if (this.m_wcontext._isInboundOperation) {
            PCInboundBinding pciBinding = (PCInboundBinding)this.m_wcontext._extReg.createExtension(PCInboundBinding.PARENT_CLASS, PCInboundBinding.FIELD_ELEMENT_TYPE);
            binding.addExtensibilityElement((ExtensibilityElement)pciBinding);
        } else {
            JcaBinding jcaBinding = (JcaBinding)this.m_wcontext._extReg.createExtension(JcaBinding.PARENT_CLASS, JcaBinding.FIELD_ELEMENT_TYPE);
            binding.addExtensibilityElement((ExtensibilityElement)jcaBinding);
        }
        Port port = this.m_wcontext._write_port;
        port.setName(s_MergeDmlType + this.m_wcontext.Port_suffix);
        port.setBinding(binding);
        PartnerLinkType plt = (PartnerLinkType)this.m_wcontext._extReg.createExtension(PartnerLinkType.PARENT_CLASS, PartnerLinkType.FIELD_ELEMENT_TYPE);
        def.addExtensibilityElement((ExtensibilityElement)plt);
        plt.setContext(this.m_wcontext);
        this.m_wcontext._partnerLinkType_name = this.m_wcontext._write_service_name + this.m_wcontext.PartnerLinkType_suffix;
        this.m_wcontext._role_name = this.m_wcontext._write_service_name + this.m_wcontext.Role_suffix;
        plt.setPartnerLinkTypeName(this.m_wcontext._partnerLinkType_name);
        plt.setRoleName(this.m_wcontext._role_name);
        plt.setPortName(this.m_wcontext._write_service_name + this.m_wcontext.PortType_suffix);
        if (this.inboundTablesRadioButton.isSelected()) {
            isNew = this.ascontext._inboundSelectOp == null;
            this.ascontext._inboundSelectOp = this.addInboundOperation(binding, this.ascontext._inboundSelectOp, portType);
            if (isNew) {
                if (!this.m_wcontext._service_type.equals("Apps")) {
                    this.ascontext._inboundSelectOp.setAttributeValue("ActivationSpec", "oracle.tip.adapter.db.DBActivationSpec");
                } else {
                    this.ascontext._inboundSelectOp.setAttributeValue("ActivationSpec", "oracle.tip.adapter.apps.AppsTableReadActivationSpec");
                }
                this.ascontext._inboundSelectOp.setAttributeValue(s_DescriptorName, this.ascontext._rootDescriptor.getJavaClass().getName());
                this.ascontext._inboundSelectOp.setAttributeValue(s_QueryName, this.m_wcontext._write_service_name + "Select");
                this.ascontext._inboundSelectOp.setAttributeValue(s_ORProject, this.m_wcontext._write_service_name + "-or-mappings.xml");
            }
        }
        if (this.isMergeSelected()) {
            isNew = this.ascontext._outboundMergeOp == null;
            outputCompletedXml = this.ascontext._rootDescriptor.getSequenceNumberFieldName() != null;
            this.ascontext._outboundMergeOp = this.addWriteOperation(s_MergeDmlType, binding, this.ascontext._outboundMergeOp, outputCompletedXml, portType);
            if (isNew) {
                this.ascontext._outboundMergeOp.setAttributeValue("InteractionSpec", "oracle.tip.adapter.db.DBWriteInteractionSpec");
                this.ascontext._outboundMergeOp.setAttributeValue(s_DescriptorName, this.ascontext._rootDescriptor.getJavaClass().getName());
                this.ascontext._outboundMergeOp.setAttributeValue(s_DmlType, s_MergeDmlType);
                if (outputCompletedXml) {
                    this.ascontext._outboundMergeOp.setAttributeValue(s_OutputCompletedXml, "true");
                }
                this.ascontext._outboundMergeOp.setAttributeValue(s_ORProject, this.m_wcontext._write_service_name + "-or-mappings.xml");
            }
            if (this.ascontext._outboundWriteOp != null) {
                this.addWriteOperation(s_WriteDmlType, binding, this.ascontext._outboundWriteOp, outputCompletedXml, portType);
            }
        }
        if (this.isInsertSelected()) {
            isNew = this.ascontext._outboundInsertOp == null;
            outputCompletedXml = this.ascontext._rootDescriptor.getSequenceNumberFieldName() != null;
            this.ascontext._outboundInsertOp = this.addWriteOperation(s_InsertDmlType, binding, this.ascontext._outboundInsertOp, outputCompletedXml, portType);
            if (isNew) {
                if (!this.m_wcontext._service_type.equals("Apps")) {
                    this.ascontext._outboundInsertOp.setAttributeValue("InteractionSpec", "oracle.tip.adapter.db.DBWriteInteractionSpec");
                } else {
                    this.ascontext._outboundInsertOp.setAttributeValue("InteractionSpec", "oracle.tip.adapter.apps.AppsTableWriteInteractionSpec");
                }
                this.ascontext._outboundInsertOp.setAttributeValue(s_DescriptorName, this.ascontext._rootDescriptor.getJavaClass().getName());
                this.ascontext._outboundInsertOp.setAttributeValue(s_DmlType, s_InsertDmlType);
                if (outputCompletedXml) {
                    this.ascontext._outboundInsertOp.setAttributeValue(s_OutputCompletedXml, "true");
                }
                this.ascontext._outboundInsertOp.setAttributeValue(s_ORProject, this.m_wcontext._write_service_name + "-or-mappings.xml");
            }
        }
        if (this.isUpdateSelected()) {
            isNew = this.ascontext._outboundUpdateOp == null;
            this.ascontext._outboundUpdateOp = this.addWriteOperation(s_UpdateDmlType, binding, this.ascontext._outboundUpdateOp, false, portType);
            if (isNew) {
                this.ascontext._outboundUpdateOp.setAttributeValue("InteractionSpec", "oracle.tip.adapter.db.DBWriteInteractionSpec");
                this.ascontext._outboundUpdateOp.setAttributeValue(s_DescriptorName, this.ascontext._rootDescriptor.getJavaClass().getName());
                this.ascontext._outboundUpdateOp.setAttributeValue(s_DmlType, s_UpdateDmlType);
                this.ascontext._outboundUpdateOp.setAttributeValue(s_ORProject, this.m_wcontext._write_service_name + "-or-mappings.xml");
            }
        }
        if (this.isDeleteSelected()) {
            isNew = this.ascontext._outboundDeleteOp == null;
            this.ascontext._outboundDeleteOp = this.addWriteOperation(s_DeleteDmlType, binding, this.ascontext._outboundDeleteOp, false, portType);
            if (isNew) {
                this.ascontext._outboundDeleteOp.setAttributeValue("InteractionSpec", "oracle.tip.adapter.db.DBWriteInteractionSpec");
                this.ascontext._outboundDeleteOp.setAttributeValue(s_DescriptorName, this.ascontext._rootDescriptor.getJavaClass().getName());
                this.ascontext._outboundDeleteOp.setAttributeValue(s_DmlType, s_DeleteDmlType);
                this.ascontext._outboundDeleteOp.setAttributeValue(s_DetectOmissions, "true");
                this.ascontext._outboundDeleteOp.setAttributeValue(s_OptimizeMerge, "true");
                this.ascontext._outboundDeleteOp.setAttributeValue(s_ORProject, this.m_wcontext._write_service_name + "-or-mappings.xml");
            }
        }
        if (this.isSelectSelected()) {
            isNew = this.ascontext._outboundSelectOp == null;
            this.ascontext._outboundSelectOp = this.addReadOperation(this.m_wcontext._write_service_name + "Select", false, binding, this.ascontext._outboundSelectOp, portType);
            if (isNew) {
                if (!this.m_wcontext._service_type.equals("Apps")) {
                    this.ascontext._outboundSelectOp.setAttributeValue("InteractionSpec", "oracle.tip.adapter.db.DBReadInteractionSpec");
                } else {
                    this.ascontext._outboundSelectOp.setAttributeValue("InteractionSpec", "oracle.tip.adapter.apps.AppsTableReadInteractionSpec");
                }
                this.ascontext._outboundSelectOp.setAttributeValue(s_DescriptorName, this.ascontext._rootDescriptor.getJavaClass().getName());
                this.ascontext._outboundSelectOp.setAttributeValue(s_QueryName, this.m_wcontext._write_service_name + "Select");
                this.ascontext._outboundSelectOp.setAttributeValue(s_ORProject, this.m_wcontext._write_service_name + "-or-mappings.xml");
            }
        }
        if (this.isQueryByExampleSelected()) {
            isNew = this.ascontext._outboundQueryByExampleOp == null;
            this.ascontext._outboundQueryByExampleOp = this.addReadOperation("queryByExample", true, binding, this.ascontext._outboundQueryByExampleOp, portType);
            if (isNew) {
                if (!this.m_wcontext._service_type.equals("Apps")) {
                    this.ascontext._outboundQueryByExampleOp.setAttributeValue("InteractionSpec", "oracle.tip.adapter.db.DBReadInteractionSpec");
                } else {
                    this.ascontext._outboundQueryByExampleOp.setAttributeValue("InteractionSpec", "oracle.tip.adapter.apps.AppsTableReadInteractionSpec");
                }
                this.ascontext._outboundQueryByExampleOp.setAttributeValue(s_DescriptorName, this.ascontext._rootDescriptor.getJavaClass().getName());
                this.ascontext._outboundQueryByExampleOp.setAttributeValue("IsQueryByExample", "true");
                this.ascontext._outboundQueryByExampleOp.setAttributeValue(s_ORProject, this.m_wcontext._write_service_name + "-or-mappings.xml");
            }
        }
    }

    private JcaOperation addWriteOperation(String operationName, Binding binding, JcaOperation jop, boolean outputCompletedXml, PortType portType) throws WSDLException {
        String payLoadName = this.ascontext._rootDescriptorElementName + DBAdapterConstants.QueryResultsElementName;
        String topNamespace = DBAdapterConstants.xsdNamespace((String)XRAdapterUtil.getPackageName(this.m_wcontext));
        Definition def = this.m_wcontext._write_definition;
        if (jop != null) {
            jop.setAttributeValue(s_DescriptorName, this.ascontext._rootDescriptor.getJavaClass().getName());
        }
        boolean trulyOutputCompletedXml = outputCompletedXml;
        if (outputCompletedXml && jop != null) {
            trulyOutputCompletedXml = true;
            jop.setAttributeValue(s_OutputCompletedXml, "true");
        } else if (jop != null && Boolean.valueOf(jop.getAttributeValue(s_OutputCompletedXml)).booleanValue()) {
            jop.setAttributeValue(s_OutputCompletedXml, "false");
            trulyOutputCompletedXml = false;
        }
        Message inputMessage = def.createMessage();
        inputMessage.setQName(new QName(this.m_wcontext._target_namespace, payLoadName + this.m_wcontext.Message_suffix));
        inputMessage.setUndefined(false);
        Part partIn = def.createPart();
        partIn.setName(payLoadName);
        partIn.setElementName(new QName(topNamespace, payLoadName));
        inputMessage.addPart(partIn);
        def.addMessage(inputMessage);
        Input input = def.createInput();
        input.setMessage(inputMessage);
        Output output = null;
        if (trulyOutputCompletedXml) {
            Message outputMessage = def.createMessage();
            outputMessage.setQName(new QName(this.m_wcontext._target_namespace, payLoadName + this.m_wcontext.Message_suffix));
            outputMessage.setUndefined(false);
            Part partOut = def.createPart();
            partOut.setName(payLoadName);
            partOut.setElementName(new QName(topNamespace, payLoadName));
            outputMessage.addPart(partOut);
            def.addMessage(outputMessage);
            output = def.createOutput();
            output.setMessage(outputMessage);
        }
        Operation operation = def.createOperation();
        operation.setInput(input);
        if (output != null) {
            operation.setOutput(output);
        }
        operation.setName(operationName);
        operation.setUndefined(false);
        portType.addOperation(operation);
        BindingOperation bindingOp = def.createBindingOperation();
        bindingOp.setName(operationName);
        binding.addBindingOperation(bindingOp);
        if (jop == null) {
            jop = (JcaOperation)this.m_wcontext._extReg.createExtension(JcaOperation.PARENT_CLASS, JcaOperation.FIELD_ELEMENT_TYPE);
        }
        this.m_wcontext._write_operation_physical = bindingOp;
        this.m_wcontext._write_operation_physical.addExtensibilityElement((ExtensibilityElement)jop);
        return jop;
    }

    private JcaOperation addReadOperation(String queryName, boolean isQueryByExample, Binding binding, JcaOperation jop, PortType portType) throws WSDLException {
        String payLoadName = this.ascontext._rootDescriptorElementName + DBAdapterConstants.QueryResultsElementName;
        String topNamespace = DBAdapterConstants.xsdNamespace((String)XRAdapterUtil.getPackageName(this.m_wcontext));
        String inputMessageName = null;
        String inputPartName = null;
        String inputElementName = null;
        if (jop != null) {
            jop.setAttributeValue(s_DescriptorName, this.ascontext._rootDescriptor.getJavaClass().getName());
        }
        if (isQueryByExample) {
            inputMessageName = this.ascontext._rootDescriptorElementName + this.m_wcontext.Message_suffix;
            inputElementName = inputPartName = this.ascontext._rootDescriptorElementName;
        } else {
            String suffix = null;
            if (this.usesOldInparameters) {
                suffix = "_inparameters";
                queryName = DBAdapterConstants.getQueryName((DatabaseQuery)this.ascontext._query);
                inputElementName = queryName + "InputParameters";
            } else {
                suffix = "_inputParameters";
                inputElementName = DBAdapterConstants.getQueryName((DatabaseQuery)this.ascontext._query) + "InputParameters";
            }
            inputMessageName = queryName + suffix;
            inputPartName = queryName + suffix;
        }
        Definition def = this.m_wcontext._write_definition;
        Message inputMessage = def.createMessage();
        inputMessage.setQName(new QName(this.m_wcontext._target_namespace, inputMessageName));
        inputMessage.setUndefined(false);
        Part partIn = def.createPart();
        partIn.setName(inputPartName);
        partIn.setElementName(new QName(topNamespace, inputElementName));
        inputMessage.addPart(partIn);
        def.addMessage(inputMessage);
        Input input = def.createInput();
        input.setMessage(inputMessage);
        Message outputMessage = def.createMessage();
        outputMessage.setQName(new QName(this.m_wcontext._target_namespace, payLoadName + this.m_wcontext.Message_suffix));
        outputMessage.setUndefined(false);
        Part partOut = def.createPart();
        partOut.setName(payLoadName);
        partOut.setElementName(new QName(topNamespace, payLoadName));
        outputMessage.addPart(partOut);
        def.addMessage(outputMessage);
        Output output = def.createOutput();
        output.setMessage(outputMessage);
        Operation operation = def.createOperation();
        operation.setInput(input);
        operation.setOutput(output);
        operation.setName(queryName);
        operation.setUndefined(false);
        portType.addOperation(operation);
        BindingOperation bindingOp = def.createBindingOperation();
        bindingOp.setName(queryName);
        binding.addBindingOperation(bindingOp);
        if (jop == null) {
            jop = (JcaOperation)this.m_wcontext._extReg.createExtension(JcaOperation.PARENT_CLASS, JcaOperation.FIELD_ELEMENT_TYPE);
        }
        bindingOp.addExtensibilityElement((ExtensibilityElement)jop);
        return jop;
    }

    private JcaOperation addInboundOperation(Binding binding, JcaOperation jop, PortType portType) throws WSDLException {
        String payLoadName = this.ascontext._rootDescriptorElementName + DBAdapterConstants.QueryResultsElementName;
        String topNamespace = DBAdapterConstants.xsdNamespace((String)XRAdapterUtil.getPackageName(this.m_wcontext));
        Definition def = this.m_wcontext._write_definition;
        if (jop != null) {
            jop.setAttributeValue(s_DescriptorName, this.ascontext._rootDescriptor.getJavaClass().getName());
        }
        Message inputMessage = def.createMessage();
        inputMessage.setQName(new QName(this.m_wcontext._target_namespace, payLoadName + this.m_wcontext.Message_suffix));
        inputMessage.setUndefined(false);
        Part partIn = def.createPart();
        partIn.setName(payLoadName);
        partIn.setElementName(new QName(topNamespace, payLoadName));
        inputMessage.addPart(partIn);
        def.addMessage(inputMessage);
        Input input = def.createInput();
        input.setMessage(inputMessage);
        Operation operation = def.createOperation();
        operation.setInput(input);
        if (this.synchPostCheckBox.isSelected() && operation.getOutput() == null) {
            Message outputMessage = def.createMessage();
            outputMessage.setQName(new QName(this.m_wcontext._target_namespace, "empty" + this.m_wcontext.Message_suffix));
            outputMessage.setUndefined(false);
            Part partOut = def.createPart();
            partOut.setName("empty");
            partOut.setElementName(new QName(topNamespace, "empty"));
            outputMessage.addPart(partOut);
            def.addMessage(outputMessage);
            Output output = def.createOutput();
            output.setMessage(outputMessage);
            operation.setOutput(output);
        }
        operation.setName("receive");
        operation.setUndefined(false);
        portType.addOperation(operation);
        BindingOperation bindingOp = def.createBindingOperation();
        bindingOp.setName("receive");
        binding.addBindingOperation(bindingOp);
        if (jop == null) {
            jop = (JcaOperation)this.m_wcontext._extReg.createExtension(JcaOperation.PARENT_CLASS, JcaOperation.FIELD_ELEMENT_TYPE);
        }
        bindingOp.addExtensibilityElement((ExtensibilityElement)jop);
        return jop;
    }

    @Override
    public void buildSpec(TopLinkReadSpec spec) {
    }

    class ReAddPagesRunnable
    implements Runnable {
        boolean startAgain = false;
        boolean finished = false;
        volatile boolean inInitialization = false;

        ReAddPagesRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForFinish() {
            try {
                ReAddPagesRunnable reAddPagesRunnable = this;
                synchronized (reAddPagesRunnable) {
                    if (!this.finished) {
                        this.startAgain = false;
                        this.wait();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    if (!this.inInitialization) {
                        XRAdapterOperationPage.this.removePages();
                    }
                    ImageWizardPage tempwp = new ImageWizardPage(null, XRAdapterOperationPage.this._getImage(), XRAdapterOperationPage.this.getTranslatedString("DB_ST_TITLE"));
                    if (!AdapterWizardContext.IS_STANDALONE_TESTING && !XRAdapterOperationPage.this.m_wcontext.isStandalone()) {
                        HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_db_seltab");
                    }
                    XRAdapterOperationPage.this.m_wcontext._ascontext = XRAdapterOperationPage.this.ascontext;
                    XRAdapterOperationPage.this.m_wcontext._adapterWizardFinish = XRAdapterOperationPage.this.finishPage;
                    new XRAdapterSelectTablesPage(XRAdapterOperationPage.this.m_wcontext, tempwp);
                    continue;
                }
                finally {
                    ReAddPagesRunnable reAddPagesRunnable = this;
                    synchronized (reAddPagesRunnable) {
                        if (!this.startAgain) {
                            this.finished = true;
                            this.notifyAll();
                            break;
                        }
                        this.startAgain = false;
                    }
                    continue;
                }
                break;
            }
        }
    }
}

