/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.wsdl.WSDLException;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.share.nls.StringUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.tip.adapter.db.DBActivationSpec;
import oracle.tip.adapter.db.api.TopLinkReadSpec;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterUtil;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterWizardContext;

public class XRAdapterLogicalDeletePage
extends techAdapterWizardPage
implements DocumentListener,
ActionListener,
XRAdapterPage {
    private MultiLineLabel instructionsLabel;
    private JLabel markReadFieldLabel;
    private JComboBox markReadFieldComboBox;
    private JLabel readValueLabel;
    private JTextField readValueField;
    private JLabel unreadValueLabel;
    private JTextField unreadValueField;
    private JLabel reservedValueLabel;
    private JComboBox reservedValueField;
    public static final String s_MarkReadColumn = "MarkReadColumn";
    public static final String s_MarkReadValue = "MarkReadValue";
    public static final String s_MarkReservedValue = "MarkReservedValue";
    public static final String s_MarkUnreadValue = "MarkUnreadValue";
    private XRAdapterWizardContext ascontext;

    public XRAdapterLogicalDeletePage(AdapterWizardContext context, ImageWizardPage page) {
        try {
            this.setContextAndPage(context, page);
            this.ascontext = (XRAdapterWizardContext)context._ascontext;
            this.m_page.setCanAdvance(false);
            this.initialize();
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)this.m_wcontext._parentFrame, (Exception)e);
        }
    }

    public void initialize() {
        this.setLayout(new GridBagLayout());
        String instructionsText = this.getTranslatedString("DB_LD_INTRO_PROMPT");
        this.instructionsLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), instructionsText);
        Object[] fieldNames = XRAdapterUtil.getColumnNamesFromDBProperties(this.ascontext._rootDescriptor.getTables(), this.ascontext._dtProps).toArray();
        Arrays.sort(fieldNames);
        this.markReadFieldComboBox = new JComboBox<Object>(fieldNames);
        this.markReadFieldComboBox.setEditable(true);
        this.markReadFieldComboBox.addActionListener(this);
        JTextField comboBoxTextField = (JTextField)this.markReadFieldComboBox.getEditor().getEditorComponent();
        comboBoxTextField.getDocument().addDocumentListener(this);
        String markReadFieldLabelString = this.getTranslatedString("DB_LD_MARK_READ_FIELD");
        this.markReadFieldLabel = new JLabel(StringUtils.stripMnemonic((String)markReadFieldLabelString));
        this.markReadFieldLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)markReadFieldLabelString));
        this.markReadFieldLabel.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)markReadFieldLabelString));
        this.markReadFieldLabel.setLabelFor(this.markReadFieldComboBox);
        this.readValueField = new JTextField();
        String readValueLabelString = this.getTranslatedString("DB_LD_READ_VALUE");
        this.readValueLabel = new JLabel(StringUtils.stripMnemonic((String)readValueLabelString));
        this.readValueLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)readValueLabelString));
        this.readValueLabel.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)readValueLabelString));
        this.readValueLabel.setLabelFor(this.readValueField);
        this.unreadValueField = new JTextField();
        String unreadValueLabelString = this.getTranslatedString("DB_LD_UNREAD_VALUE");
        this.unreadValueLabel = new JLabel(StringUtils.stripMnemonic((String)unreadValueLabelString));
        this.unreadValueLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)unreadValueLabelString));
        this.unreadValueLabel.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)unreadValueLabelString));
        this.unreadValueLabel.setLabelFor(this.unreadValueField);
        this.reservedValueField = new JComboBox();
        this.reservedValueField.setEditable(true);
        this.reservedValueField.setMinimumSize(new Dimension(300, 20));
        this.reservedValueField.setMaximumSize(new Dimension(300, 20));
        this.reservedValueField.insertItemAt("", 0);
        this.reservedValueField.setSelectedIndex(0);
        this.reservedValueField.insertItemAt("R${weblogic.Name-2}-${IP-2}", 1);
        String reservedValueLabelString = this.getTranslatedString("DB_LD_RESERVED_VALUE");
        this.reservedValueLabel = new JLabel(StringUtils.stripMnemonic((String)reservedValueLabelString));
        this.reservedValueLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)reservedValueLabelString));
        this.reservedValueLabel.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)reservedValueLabelString));
        this.reservedValueLabel.setLabelFor(this.reservedValueField);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        this.add((Component)this.instructionsLabel, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.insets = new Insets(30, 0, 0, 12);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.markReadFieldLabel, constraints);
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.insets = new Insets(30, 0, 0, 0);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.markReadFieldComboBox, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.insets = new Insets(12, 0, 0, 12);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.readValueLabel, constraints);
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.insets = new Insets(12, 0, 0, 0);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.readValueField, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.insets = new Insets(12, 0, 0, 12);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.unreadValueLabel, constraints);
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.insets = new Insets(12, 0, 0, 0);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.unreadValueField, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.insets = new Insets(12, 0, 0, 12);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.reservedValueLabel, constraints);
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 4;
        constraints.insets = new Insets(12, 0, 0, 0);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.reservedValueField, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        this.add((Component)new JPanel(), constraints);
        if (this.m_wcontext._read_service != null) {
            this.populateUIForEdit();
        }
        this.readValueField.getDocument().addDocumentListener(this);
    }

    public void populateUIForEdit() {
        JcaOperation jop = this.m_wcontext._read_jca_operation;
        this.markReadFieldComboBox.setSelectedItem(jop.getAttributeValue(s_MarkReadColumn));
        this.readValueField.setText(jop.getAttributeValue(s_MarkReadValue));
        this.reservedValueField.insertItemAt(jop.getAttributeValue(s_MarkReservedValue), 0);
        this.unreadValueField.setText(jop.getAttributeValue(s_MarkUnreadValue));
        this.checkToEnableNext();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.checkToEnableNext();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.checkToEnableNext();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.checkToEnableNext();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.checkToEnableNext();
    }

    private void checkToEnableNext() {
        boolean markReadFieldSet;
        JTextField comboboxTextField = (JTextField)this.markReadFieldComboBox.getEditor().getEditorComponent();
        boolean bl = markReadFieldSet = !comboboxTextField.getText().trim().equals("");
        if (markReadFieldSet && this.readValueField.getText() != null && this.readValueField.getText().trim().length() > 0) {
            this.m_page.setCanAdvance(true);
        } else {
            this.m_page.setCanAdvance(false);
        }
    }

    @Override
    public void buildWSDL() throws WSDLException {
        this.ascontext._inboundSelectOp.setAttributeValue(s_MarkReadColumn, this.markReadFieldComboBox.getSelectedItem().toString());
        if (!this.readValueField.getText().equals("")) {
            this.ascontext._inboundSelectOp.setAttributeValue(s_MarkReadValue, this.readValueField.getText());
        } else if (this.ascontext._inboundSelectOp.getAttributeValue(s_MarkReadValue) != null) {
            this.ascontext._inboundSelectOp.removeAttribute(s_MarkReadValue);
        }
        if (this.reservedValueField.getSelectedItem() != null && !this.reservedValueField.getSelectedItem().equals("")) {
            this.ascontext._inboundSelectOp.setAttributeValue(s_MarkReservedValue, this.reservedValueField.getSelectedItem().toString());
        } else if (this.ascontext._inboundSelectOp.getAttributeValue(s_MarkReservedValue) != null) {
            this.ascontext._inboundSelectOp.removeAttribute(s_MarkReservedValue);
        }
        if (!this.unreadValueField.getText().equals("")) {
            this.ascontext._inboundSelectOp.setAttributeValue(s_MarkUnreadValue, this.unreadValueField.getText());
        } else if (this.ascontext._inboundSelectOp.getAttributeValue(s_MarkUnreadValue) != null) {
            this.ascontext._inboundSelectOp.removeAttribute(s_MarkUnreadValue);
        }
    }

    @Override
    public void buildSpec(TopLinkReadSpec spec) {
        if (spec instanceof DBActivationSpec) {
            DBActivationSpec activationSpec = (DBActivationSpec)spec;
            if (this.markReadFieldComboBox.getSelectedItem() == null) {
                activationSpec.setMarkReadColumn("");
            } else {
                activationSpec.setMarkReadColumn(this.markReadFieldComboBox.getSelectedItem().toString());
            }
            if (this.readValueField.getText().equals("")) {
                activationSpec.setMarkReadValue(this.readValueField.getText());
            } else {
                activationSpec.setMarkReadValue(this.readValueField.getText());
            }
            if (this.unreadValueField.getText().equals("")) {
                activationSpec.setMarkUnreadValue(null);
            } else {
                activationSpec.setMarkUnreadValue(this.unreadValueField.getText());
            }
            if (this.reservedValueField.getSelectedItem() == null || this.reservedValueField.getSelectedItem().equals("")) {
                activationSpec.setMarkReservedValue(null);
            } else {
                activationSpec.setMarkReservedValue(this.reservedValueField.getSelectedItem().toString());
            }
        }
    }

    @Override
    public void wizardValidatePage(WizardEvent event) {
        XRAdapterUtil.refreshSQLPanes(this.m_wcontext);
    }
}

