/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.wsdl.WSDLException;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.tip.adapter.db.DBActivationSpec;
import oracle.tip.adapter.db.api.TopLinkReadSpec;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterUtil;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterWizardContext;
import org.eclipse.persistence.descriptors.RelationalDescriptor;

public class XRAdapterFileSequencingPage
extends techAdapterWizardPage
implements DocumentListener,
ActionListener,
XRAdapterPage {
    protected MultiLineLabel instructionsLabel;
    private JLabel sequencingFileLabel;
    private JTextField sequencingFileField;
    private JButton browseButton;
    protected JLabel sequencingColumnLabel;
    protected JComboBox sequencingColumnComboBox;
    public static final String s_SequencingFileName = "SequencingFileName";
    public static final String s_SequencingColumn = "SequencingColumn";
    public static final String s_SequencingColumnType = "SequencingColumnType";
    private XRAdapterWizardContext ascontext;

    public XRAdapterFileSequencingPage(AdapterWizardContext context, ImageWizardPage page) {
        try {
            this.setContextAndPage(context, page);
            this.ascontext = (XRAdapterWizardContext)context._ascontext;
            this.m_page.setCanAdvance(false);
            this.initialize();
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)this.m_wcontext._parentFrame, (Exception)e);
        }
    }

    public void initialize() {
        this.setLayout(new GridBagLayout());
        MessageFormat msgformat = new MessageFormat(this.getTranslatedString("DB_LR_FILE_INTRO_PROMPT"));
        Object[] args = new Object[]{this.ascontext._rootDescriptor.getTableName()};
        String instructionsText = msgformat.format(args);
        this.instructionsLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), instructionsText);
        this.sequencingFileField = new JTextField();
        this.sequencingFileField.getDocument().addDocumentListener(this);
        String sequencingFileString = this.getTranslatedString("DB_LR_SEQ_FILE");
        this.sequencingFileLabel = new JLabel(StringUtils.stripMnemonic((String)sequencingFileString));
        this.sequencingFileLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)sequencingFileString));
        this.sequencingFileLabel.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)sequencingFileString));
        this.sequencingFileLabel.setLabelFor(this.sequencingFileField);
        String browseString = this.getTranslatedString("DB_LR_BROWSE");
        this.browseButton = new JButton(StringUtils.stripMnemonic((String)browseString));
        this.browseButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)browseString));
        this.browseButton.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)browseString));
        this.browseButton.addActionListener(this);
        this.sequencingColumnComboBox = new JComboBox();
        this.refreshSequencingColumnChoices();
        this.sequencingColumnComboBox.setEditable(true);
        this.sequencingColumnComboBox.addActionListener(this);
        JTextField comboBoxTextField = (JTextField)this.sequencingColumnComboBox.getEditor().getEditorComponent();
        comboBoxTextField.getDocument().addDocumentListener(this);
        String sequencingColumnString = this.getTranslatedString("DB_LR_SEQ_ID_FIELD");
        this.sequencingColumnLabel = new JLabel(StringUtils.stripMnemonic((String)sequencingColumnString));
        this.sequencingColumnLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)sequencingColumnString));
        this.sequencingColumnLabel.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)sequencingColumnString));
        this.sequencingColumnLabel.setLabelFor(this.sequencingColumnComboBox);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 3;
        constraints.gridheight = 1;
        this.add((Component)this.instructionsLabel, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.insets = new Insets(30, 0, 0, 12);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.sequencingFileLabel, constraints);
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.insets = new Insets(30, 0, 0, 6);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.sequencingFileField, constraints);
        constraints.anchor = 17;
        constraints.gridx = 2;
        constraints.gridy = 1;
        constraints.insets = new Insets(30, 0, 0, 0);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.browseButton, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.insets = new Insets(30, 0, 0, 12);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.sequencingColumnLabel, constraints);
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.insets = new Insets(30, 0, 0, 0);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        this.add((Component)this.sequencingColumnComboBox, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 3;
        constraints.gridheight = 1;
        this.add((Component)new JPanel(), constraints);
        this.setSequencingColumn();
        if (this.m_wcontext._read_service != null) {
            this.populateUIForEdit();
        }
    }

    public void refreshSequencingColumnChoices() {
        RelationalDescriptor descriptor = this.ascontext._rootDescriptor;
        ArrayList columns = XRAdapterUtil.getColumnNamesFromDBProperties(descriptor.getTables(), this.ascontext._dtProps);
        Object[] masterTableFieldNames = columns.toArray();
        Arrays.sort(masterTableFieldNames);
        this.sequencingColumnComboBox.setModel(new DefaultComboBoxModel<Object>(masterTableFieldNames));
    }

    private void setSequencingColumn() {
        Object[] pkFieldNames = this.ascontext._rootDescriptor.getPrimaryKeyFieldNames().toArray();
        for (int i = 0; i < pkFieldNames.length; ++i) {
            Object pkFieldName = pkFieldNames[i];
            for (int j = 0; j < this.sequencingColumnComboBox.getItemCount(); ++j) {
                if (!this.sequencingColumnComboBox.getItemAt(j).equals(pkFieldName)) continue;
                this.sequencingColumnComboBox.setSelectedIndex(j);
                return;
            }
        }
    }

    public void populateUIForEdit() {
        JcaOperation jop = this.m_wcontext._read_jca_operation;
        this.sequencingFileField.setText(jop.getAttributeValue(s_SequencingFileName));
        this.sequencingColumnComboBox.setSelectedItem(jop.getAttributeValue(s_SequencingColumn));
        this.checkToEnableNext();
    }

    @Override
    public String selectFile() {
        String tempstr = null;
        if (AdapterWizardContext.IS_STANDALONE_TESTING || this.m_wcontext.isStandalone()) {
            JFileChooser m_filechooser = new JFileChooser();
            m_filechooser.setFileSelectionMode(0);
            int returnVal = m_filechooser.showDialog(this, this.getTranslatedString("CM_WZ_SELECT_FILE"));
            if (returnVal == 0) {
                File file = m_filechooser.getSelectedFile();
                tempstr = file.getAbsolutePath();
            }
        } else {
            URLChooser m_urlchooser = DialogUtil.newURLChooser((URL)null);
            m_urlchooser.setSelectionScope(0);
            int ret = m_urlchooser.showOpenDialog((Component)this);
            if (ret == 0) {
                URL xslURL = m_urlchooser.getSelectedURL();
                File file1 = new File(xslURL.getFile());
                tempstr = file1.toString();
            }
        }
        return tempstr;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String temptxt;
        if (e.getSource() == this.browseButton && (temptxt = this.selectFile()) != null && temptxt.length() > 0) {
            this.sequencingFileField.setText(temptxt);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.checkToEnableNext();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.checkToEnableNext();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.checkToEnableNext();
    }

    private void checkToEnableNext() {
        boolean idFieldSet;
        String file = this.sequencingFileField.getText();
        boolean fileSet = file != null && file.trim().length() > 0;
        JTextField comboboxTextField = (JTextField)this.sequencingColumnComboBox.getEditor().getEditorComponent();
        boolean bl = idFieldSet = !comboboxTextField.getText().trim().equals("");
        if (fileSet && idFieldSet) {
            this.m_page.setCanAdvance(true);
        } else {
            this.m_page.setCanAdvance(false);
        }
    }

    @Override
    public void wizardValidatePage(WizardEvent event) {
        XRAdapterWizardContext context = (XRAdapterWizardContext)this.m_wcontext._ascontext;
        context._sequencingColumn = this.sequencingColumnComboBox.getSelectedItem().toString();
        context._pollingOptionsPage.refreshOrderByFieldChoices();
        XRAdapterUtil.refreshSQLPanes(this.m_wcontext);
    }

    @Override
    public void buildWSDL() throws WSDLException {
        if (!this.sequencingFileField.getText().equals("")) {
            this.ascontext._inboundSelectOp.setAttributeValue(s_SequencingFileName, this.sequencingFileField.getText());
        }
        this.ascontext._inboundSelectOp.setAttributeValue(s_SequencingColumn, this.sequencingColumnComboBox.getSelectedItem().toString());
    }

    @Override
    public void buildSpec(TopLinkReadSpec spec) {
        if (spec instanceof DBActivationSpec) {
            DBActivationSpec activationSpec = (DBActivationSpec)spec;
            if (!this.sequencingFileField.getText().equals("")) {
                activationSpec.setSequencingFileName(this.sequencingFileField.getText());
            } else {
                activationSpec.setSequencingFileName(null);
            }
            if (this.sequencingColumnComboBox.getSelectedItem() == null) {
                activationSpec.setSequencingColumn("");
            } else {
                activationSpec.setSequencingColumn(this.sequencingColumnComboBox.getSelectedItem().toString());
            }
        }
    }
}

