/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import javax.wsdl.WSDLException;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.share.nls.StringUtils;
import oracle.tip.adapter.db.DBActivationSpec;
import oracle.tip.adapter.db.api.TopLinkReadSpec;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterSequencingPage;

public class XRAdapterExternalSequencingPage
extends XRAdapterSequencingPage
implements DocumentListener,
ActionListener,
XRAdapterPage {
    private JLabel dataSourceNameLabel;
    private JTextField dataSourceNameField;
    private JCheckBox xaCheckBox;
    public static final String s_SequencingDataSourceName = "SequencingDataSourceName";
    public static final String s_SequencingIsXADataSource = "SequencingIsXADataSource";
    public static final String s_true = "true";
    public static final String s_false = "false";

    public XRAdapterExternalSequencingPage(AdapterWizardContext context, ImageWizardPage page) {
        super(context, page);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.dataSourceNameField = new JTextField();
        this.dataSourceNameField.getDocument().addDocumentListener(this);
        String dataSourceNameString = this.getTranslatedString("DB_LR_DS_NAME");
        this.dataSourceNameLabel = new JLabel(StringUtils.stripMnemonic((String)dataSourceNameString));
        this.dataSourceNameLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)dataSourceNameString));
        this.dataSourceNameLabel.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)dataSourceNameString));
        this.dataSourceNameLabel.setLabelFor(this.dataSourceNameField);
        String xaString = this.getTranslatedString("DB_LR_IS_XA_DS");
        this.xaCheckBox = new JCheckBox(StringUtils.stripMnemonic((String)xaString), true);
        this.xaCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)xaString));
        this.xaCheckBox.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)xaString));
        this.xaCheckBox.addActionListener(this);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.insets = new Insets(30, 0, 0, 12);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.dataSourceNameLabel, constraints);
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.insets = new Insets(30, 0, 0, 0);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        this.add((Component)this.dataSourceNameField, constraints);
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.insets = new Insets(12, 0, 0, 0);
        constraints.fill = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        this.add((Component)this.xaCheckBox, constraints);
        if (this.m_wcontext._read_service != null) {
            this.populateUIForEdit();
        }
    }

    @Override
    public void populateUIForEdit() {
        super.populateUIForEdit();
        JcaOperation jop = this.m_wcontext._read_jca_operation;
        this.dataSourceNameField.setText(jop.getAttributeValue(s_SequencingDataSourceName));
        if (jop.getAttributeValue(s_SequencingIsXADataSource) != null && jop.getAttributeValue(s_SequencingIsXADataSource).equals(s_true)) {
            this.xaCheckBox.setSelected(true);
        } else {
            this.xaCheckBox.setSelected(false);
        }
    }

    @Override
    protected void checkToEnableNext() {
        boolean idFieldSet;
        String table = this.sequencingTableField.getText();
        String name = this.sequencingTableKeyColumnField.getText();
        String value = this.sequencingTableValueColumnField.getText();
        String dataSource = this.dataSourceNameField.getText();
        boolean tableSet = table != null && table.trim().length() > 0;
        boolean nameSet = name != null && name.trim().length() > 0;
        boolean valueSet = value != null && value.trim().length() > 0;
        boolean dataSourceSet = dataSource != null && dataSource.trim().length() > 0;
        JTextField comboboxTextField = (JTextField)this.sequencingColumnComboBox.getEditor().getEditorComponent();
        boolean bl = idFieldSet = !comboboxTextField.getText().trim().equals("");
        if (tableSet && nameSet && valueSet && dataSourceSet && idFieldSet) {
            this.m_page.setCanAdvance(true);
        } else {
            this.m_page.setCanAdvance(false);
        }
    }

    @Override
    public void buildWSDL() throws WSDLException {
        super.buildWSDL();
        if (!this.dataSourceNameField.getText().equals("")) {
            this.ascontext._inboundSelectOp.setAttributeValue(s_SequencingDataSourceName, this.dataSourceNameField.getText());
        }
        this.ascontext._inboundSelectOp.setAttributeValue(s_SequencingIsXADataSource, this.xaCheckBox.isSelected() ? s_true : s_false);
    }

    @Override
    public void buildSpec(TopLinkReadSpec spec) {
        super.buildSpec(spec);
        if (spec instanceof DBActivationSpec) {
            DBActivationSpec activationSpec = (DBActivationSpec)spec;
            if (!this.dataSourceNameField.getText().equals("")) {
                activationSpec.setSequencingDataSourceName(this.dataSourceNameField.getText());
            } else {
                activationSpec.setSequencingDataSourceName(null);
            }
            activationSpec.setSequencingIsXADataSource(this.xaCheckBox.isSelected() ? s_true : s_false);
        }
    }
}

