/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr;

import java.awt.Window;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JOptionPane;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.tip.adapter.db.ox.TopLinkXMLProjectInitializer;
import oracle.tip.adapter.db.util.ArtifactsUtil;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.AppsAdapterContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.db.DBAdapterOfflineTablesImporter;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterUtil;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.util.OracleADTUtil;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDataTypeDescriptor;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLLogin;
import org.eclipse.persistence.oxm.mappings.XMLAnyCollectionMapping;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;

public class XRAdapterDescriptorGenerator
extends techAdapterWizardPage {
    private static XRAdapterDescriptorGenerator instance;
    private ArrayList fkConstraints;
    protected Project freshDescriptors = new Project();

    private XRAdapterDescriptorGenerator() {
    }

    public static XRAdapterDescriptorGenerator instance() {
        if (instance == null) {
            instance = new XRAdapterDescriptorGenerator();
        }
        return instance;
    }

    public boolean generate(AdapterWizardContext context, Object[] tableNamesForWSDL, Object[] tablesToImport) {
        if (tableNamesForWSDL != null && tableNamesForWSDL.length > 0) {
            XRAdapterWizardContext ascontext;
            if (!(context._ascontext instanceof XRAdapterWizardContext)) {
                if (context._service_type.equals("Apps")) {
                    ascontext = new XRAdapterWizardContext();
                    context._ascontext = ascontext;
                }
            }
            ascontext = (XRAdapterWizardContext)context._ascontext;
            ascontext._appsTableNames = new String[tableNamesForWSDL.length];
            for (int i = 0; i < tableNamesForWSDL.length; ++i) {
                ascontext._appsTableNames[i] = (String)tableNamesForWSDL[i];
            }
        }
        boolean toReturn = AppsAdapterContext.isListModified && tableNamesForWSDL != null ? this.generate(context, tableNamesForWSDL) : this.generate(context, tablesToImport);
        if (tableNamesForWSDL != null) {
            this.removePreviouslySelectedDescriptors(context, tableNamesForWSDL);
        }
        return toReturn;
    }

    public void initProjects(AdapterWizardContext context) {
        XRAdapterWizardContext ascontext = (XRAdapterWizardContext)context._ascontext;
        ascontext._orProject = new Project();
        ascontext._orProject.setName(context._write_service_name + "-OR");
        XRAdapterUtil.initORProject(ascontext._orProject, context);
        ascontext._oxProject = new Project();
        ascontext._oxProject.setName(context._write_service_name + "-OX");
        XMLLogin oxLogin = new XMLLogin();
        oxLogin.getProperties().remove("user");
        oxLogin.getProperties().remove("password");
        ascontext._oxProject.setLogin((Login)oxLogin);
        XMLDescriptor anyDesc = new XMLDescriptor();
        anyDesc.setJavaClassName("org.eclipse.persistence.internal.xr.CollectionHelper");
        anyDesc.setAlias("collectionHelper");
        XMLAnyCollectionMapping xacm = new XMLAnyCollectionMapping();
        xacm.setAttributeName("v");
        anyDesc.addMapping((DatabaseMapping)xacm);
        ascontext._oxProject.addDescriptor((ClassDescriptor)anyDesc);
    }

    public boolean generate(AdapterWizardContext context, Object[] tableNames) {
        int i;
        XRAdapterWizardContext ascontext = (XRAdapterWizardContext)context._ascontext;
        if (ascontext._orProject == null) {
            this.initProjects(context);
        }
        String[] tableNamesStr = null;
        if (tableNames instanceof String[]) {
            tableNamesStr = (String[])tableNames;
        } else {
            tableNamesStr = new String[tableNames.length];
            for (int i2 = 0; i2 < tableNames.length; ++i2) {
                tableNamesStr[i2] = (String)tableNames[i2];
            }
        }
        Table[] stevesTables = new DBAdapterOfflineTablesImporter().generate(context, tableNamesStr);
        for (i = 0; i < stevesTables.length; ++i) {
            boolean reimportTable = true;
            String tableName = stevesTables[i].getName();
            if (!this.descriptorExistsForTable(ascontext._orProject, tableName)) continue;
            String titleText = context._bundle.getString("DB_ST_REIMPORT_TITLE");
            MessageFormat msgformat = new MessageFormat(context._bundle.getString("DB_ST_REIMPORT_MESSAGE"));
            Object[] args = new Object[]{tableNames[i]};
            String messageText = msgformat.format(args);
            int returnCode = JOptionPane.showConfirmDialog(context._parentFrame, messageText, titleText, 0);
            boolean bl = reimportTable = returnCode == 0;
            if (reimportTable) {
                XRAdapterUtil.removeDescriptorForTableName(context, tableName);
                ascontext._reimportedTables.add(new DatabaseTable(tableName));
                continue;
            }
            stevesTables[i] = null;
        }
        this.fkConstraints = new ArrayList();
        for (i = 0; i < stevesTables.length; ++i) {
            Table table = stevesTables[i];
            if (table == null) continue;
            DBObject[] ownedObjects = table.getOwnedObjects();
            for (int x = 0; x < ownedObjects.length; ++x) {
                DBObject ownedObject = ownedObjects[x];
                if (!(ownedObject instanceof FKConstraint)) continue;
                this.fkConstraints.add(ownedObject);
            }
        }
        for (int j = 0; j < stevesTables.length; ++j) {
            Table table = stevesTables[j];
            if (table == null) continue;
            this.addDescriptor((DBObject)table, context);
        }
        this.addRelationships(context);
        TopLinkXMLProjectInitializer initializer = new TopLinkXMLProjectInitializer();
        initializer.designTimeInitialize(this.freshDescriptors, context._connection, (ClassLoader)ArtifactsUtil.getLoader());
        this.freshDescriptors = new Project();
        return true;
    }

    private void addDescriptor(DBObject dbObject, AdapterWizardContext context) {
        String dbObjectType = dbObject.getType();
        XRAdapterWizardContext ascontext = (XRAdapterWizardContext)context._ascontext;
        if (dbObject.getType() == "SYNONYM") {
            dbObject = this.resolveSynonymTarget((Synonym)dbObject, context);
        }
        SchemaObject schemaObject = (SchemaObject)dbObject;
        String userName = null;
        if (context.dbConnectionInfo != null) {
            userName = context.dbConnectionInfo.getUsername();
        }
        DatabaseTable table = new DatabaseTable(schemaObject.getName());
        if (schemaObject.getSchema() != null && schemaObject.getSchema().getName() != null && !schemaObject.getSchema().getName().equalsIgnoreCase(userName)) {
            table.setTableQualifier(schemaObject.getSchema().getName());
        }
        String shortClassName = XRAdapterUtil.toXmlName(table.getName(), true);
        String packageName = XRAdapterUtil.getPackageName(context);
        String fullClassName = packageName + "." + shortClassName;
        Class<?> javaClass = null;
        try {
            javaClass = Class.forName(fullClassName, false, (ClassLoader)ArtifactsUtil.getLoader());
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)context._parentFrame, (Exception)e);
        }
        ObjectRelationalDataTypeDescriptor orDesc = new ObjectRelationalDataTypeDescriptor();
        orDesc.setJavaClassName(fullClassName);
        orDesc.setJavaClass(javaClass);
        orDesc.setStructureName("structureName");
        orDesc.addTableName(table.getQualifiedName());
        orDesc.useWeakIdentityMap();
        orDesc.setAlias(table.getQualifiedName());
        String key = table.getQualifiedName() + ":db_table_type";
        ascontext._dtProps.setProperty(key, dbObjectType);
        try {
            DBObject[] ownedObjects = dbObject.getOwnedObjects();
            for (int i = 0; i < ownedObjects.length; ++i) {
                DBObject obj = ownedObjects[i];
                if (obj.getType() == "COLUMN") {
                    Column col = (Column)obj;
                    String colKey = table.getQualifiedName() + ":db_column_" + String.valueOf(i);
                    ascontext._dtProps.setProperty(colKey, col.getName());
                    String dataTypeName = DataTypeHelper.getDataType((DataTypeUsage)col.getDataTypeUsage()).getName();
                    Object fieldSizeObj = col.getDataTypeUsage().getAttributeValue("size");
                    Integer fieldSize = fieldSizeObj != null ? Integer.valueOf(String.valueOf(fieldSizeObj)) : null;
                    Object fieldPrecisionObj = col.getDataTypeUsage().getAttributeValue("precision");
                    Integer fieldPrecision = fieldPrecisionObj != null ? Integer.valueOf(String.valueOf(fieldPrecisionObj)) : null;
                    Object fieldScaleObj = col.getDataTypeUsage().getAttributeValue("scale");
                    Integer fieldSubSize = fieldScaleObj != null ? Integer.valueOf(String.valueOf(fieldScaleObj)) : null;
                    String notNull = String.valueOf(col.isNotNull());
                    String xAttName = XRAdapterUtil.toXmlName(col.getName(), false);
                    DirectToFieldMapping orMapping = new DirectToFieldMapping();
                    orMapping.setAttributeName(xAttName);
                    orMapping.setAttributeClassification(XRAdapterUtil.getJavaTypeFromSQLType(dataTypeName, fieldSize != null ? fieldSize : fieldPrecision, fieldSubSize, null));
                    String attClassName = orMapping.getAttributeClassification().getCanonicalName();
                    if (attClassName.contains("[")) {
                        attClassName = this.fixArrayClassName(attClassName);
                    }
                    orMapping.setAttributeClassificationName(attClassName);
                    orMapping.setField(new DatabaseField(col.getName(), dbObject.getName()));
                    if (dataTypeName.toUpperCase().indexOf(" IDENTITY") > -1) {
                        ascontext._identityMappings.put(orDesc.getJavaClass(), orMapping);
                    }
                    DirectToFieldMapping expandedOrMapping = orMapping;
                    if (orMapping.getAttributeClassification() == ClassConstants.OBJECT && schemaObject.getSchema() != null) {
                        expandedOrMapping = OracleADTUtil.expandUserDefinedTypesStub(ascontext._orProject, (RelationalDescriptor)orDesc, orMapping, dataTypeName, context._connection, schemaObject.getSchema().getName(), (ClassLoader)ArtifactsUtil.getLoader());
                    }
                    orDesc.addMapping((DatabaseMapping)expandedOrMapping);
                    key = table.getQualifiedName() + "." + col.getName() + ":db_column_type";
                    ascontext._dtProps.setProperty(key, dataTypeName);
                    if (fieldSizeObj != null) {
                        key = table.getQualifiedName() + "." + col.getName() + ":db_column_size";
                        ascontext._dtProps.setProperty(key, String.valueOf(fieldSize));
                    }
                    if (fieldScaleObj != null) {
                        key = table.getQualifiedName() + "." + col.getName() + ":db_column_scale";
                        ascontext._dtProps.setProperty(key, String.valueOf(fieldSubSize));
                    }
                    if (fieldPrecisionObj != null) {
                        key = table.getQualifiedName() + "." + col.getName() + ":db_column_precision";
                        ascontext._dtProps.setProperty(key, String.valueOf(fieldPrecision));
                    }
                    key = table.getQualifiedName() + "." + col.getName() + ":db_column_not_null";
                    ascontext._dtProps.setProperty(key, notNull);
                }
                if (!(obj instanceof UniqueConstraint) && !(obj instanceof PKConstraint)) continue;
                UniqueConstraint uniqueCon = (UniqueConstraint)obj;
                Column[] pkCols = uniqueCon.getColumns();
                for (int j = 0; j < pkCols.length; ++j) {
                    Column col = pkCols[j];
                    orDesc.addPrimaryKeyField(new DatabaseField(col.getName(), dbObject.getName()));
                }
            }
            DirectToFieldMapping identityMapping = ascontext._identityMappings.get(orDesc.getJavaClass());
            if (identityMapping != null) {
                if (identityMapping.getDescriptor().getPrimaryKeyFields().contains(identityMapping.getField())) {
                    orDesc.setSequenceNumberName("SEQ");
                    orDesc.setSequenceNumberField(identityMapping.getField());
                } else {
                    identityMapping.setProperty((Object)"enabled", (Object)"false");
                    identityMapping.setIsReadOnly(true);
                }
            }
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)context._parentFrame, (Exception)e);
        }
        ascontext._orProject.addDescriptor((ClassDescriptor)orDesc);
        ascontext._orProject.getDescriptors().clear();
        ascontext.tablesToDescriptors.put(table, orDesc);
        this.freshDescriptors.addDescriptor((ClassDescriptor)orDesc);
    }

    private String fixArrayClassName(String classNameWithArray) {
        if (classNameWithArray.contains("byte")) {
            return "[B";
        }
        if (classNameWithArray.contains("char")) {
            return "[C";
        }
        return classNameWithArray;
    }

    private void addRelationships(AdapterWizardContext context) {
        Iterator fkIt = this.fkConstraints.iterator();
        XRAdapterWizardContext ascontext = (XRAdapterWizardContext)context._ascontext;
        try {
            while (fkIt.hasNext()) {
                FKConstraint fk = (FKConstraint)fkIt.next();
                SchemaObject sourceTableSO = (SchemaObject)fk.getParent();
                PKConstraint targetPKCon = (PKConstraint)fk.getReferenceID().resolveID();
                SchemaObject targetTableSO = (SchemaObject)targetPKCon.getParent();
                DatabaseTable sourceTable = new DatabaseTable(sourceTableSO.getName(), sourceTableSO.getSchema().getName());
                DatabaseTable targetTable = new DatabaseTable(targetTableSO.getName(), targetTableSO.getSchema().getName());
                RelationalDescriptor orSourceDesc = (RelationalDescriptor)ascontext.tablesToDescriptors.get(sourceTable);
                RelationalDescriptor orTargetDesc = (RelationalDescriptor)ascontext.tablesToDescriptors.get(targetTable);
                if (orTargetDesc == null) continue;
                sourceTable = (DatabaseTable)orSourceDesc.getTables().get(0);
                targetTable = (DatabaseTable)orTargetDesc.getTables().get(0);
                Column[] fkCols = fk.getColumns();
                Column[] pkCols = targetPKCon.getColumns();
                Class targetClass = orTargetDesc.getJavaClass();
                Class sourceClass = orSourceDesc.getJavaClass();
                String oneToOneName = fk.getName();
                if (fkCols.length == 1) {
                    oneToOneName = fkCols[0].getName();
                }
                OneToOneMapping orOneToOneMapping = new OneToOneMapping();
                orOneToOneMapping.setReferenceClassName(orTargetDesc.getJavaClassName());
                orOneToOneMapping.setReferenceClass(targetClass);
                orOneToOneMapping.setAttributeName(this.generateUniqueAttributeName(orSourceDesc, orTargetDesc, oneToOneName, false));
                orOneToOneMapping.setUsesBatchReading(true);
                for (int i = 0; i < fkCols.length; ++i) {
                    orOneToOneMapping.addForeignKeyFieldName(sourceTable.getQualifiedName() + "." + fkCols[i].getName(), targetTable.getQualifiedName() + "." + pkCols[i].getName());
                }
                orSourceDesc.addMapping((DatabaseMapping)orOneToOneMapping);
                XRAdapterUtil.relationshipAdded((ForeignReferenceMapping)orOneToOneMapping, orSourceDesc);
                OneToManyMapping orOneToManyMapping = new OneToManyMapping();
                orOneToManyMapping.setReferenceClassName(orSourceDesc.getJavaClassName());
                orOneToManyMapping.setReferenceClass(sourceClass);
                for (int i = 0; i < fkCols.length; ++i) {
                    orOneToManyMapping.addTargetForeignKeyFieldName(sourceTable.getQualifiedName() + "." + fkCols[i].getName(), targetTable.getQualifiedName() + "." + pkCols[i].getName());
                }
                orOneToManyMapping.setAttributeName(this.generateUniqueAttributeName(orTargetDesc, orSourceDesc, fk.getName(), true));
                orOneToManyMapping.setContainerPolicy(ContainerPolicy.buildPolicyFor(IndirectList.class));
                orOneToManyMapping.setUsesBatchReading(true);
                orTargetDesc.addMapping((DatabaseMapping)orOneToManyMapping);
            }
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)context._parentFrame, (Exception)e);
        }
    }

    private String generateUniqueAttributeName(RelationalDescriptor sourceDesc, RelationalDescriptor targetDesc, String fkName, boolean isCollection) {
        String baseAttributeName = null;
        baseAttributeName = fkName != null && fkName.length() > 0 && !isCollection ? XRAdapterUtil.toXmlName(fkName, false) : XRAdapterUtil.toXmlName(targetDesc.getTableName(), false);
        if (isCollection) {
            baseAttributeName = baseAttributeName + "Collection";
        }
        String attributeName = baseAttributeName;
        int counter = 1;
        while (this.mappingExistsNamed(sourceDesc, attributeName)) {
            attributeName = baseAttributeName + String.valueOf(counter);
            ++counter;
        }
        return attributeName;
    }

    private boolean mappingExistsNamed(RelationalDescriptor desc, String name) {
        for (DatabaseMapping mapping : desc.getMappings()) {
            ForeignReferenceMapping frMapping;
            if (mapping == null || !(mapping instanceof ForeignReferenceMapping) || !(frMapping = (ForeignReferenceMapping)mapping).getAttributeName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private DBObject resolveSynonymTarget(Synonym synonym, AdapterWizardContext context) {
        try {
            DBObject synonymTarget = synonym.getReference().resolveID();
            if (synonymTarget instanceof Synonym) {
                Synonym anotherSynonym = (Synonym)synonymTarget;
                return this.resolveSynonymTarget(anotherSynonym, context);
            }
            if (synonymTarget instanceof Relation) {
                return synonymTarget;
            }
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)context._parentFrame, (Exception)e);
        }
        return null;
    }

    private boolean isForeignKeyColumn(Column col) {
        for (FKConstraint fkCon : this.fkConstraints) {
            Column[] fkCols = fkCon.getColumns();
            for (int i = 0; i < fkCols.length; ++i) {
                if (!col.equals((Object)fkCols[i]) || !col.getParent().equals(fkCols[i].getParent())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isPrimaryKeyColumn(Column col) {
        DBObject parent = col.getParent();
        PKConstraint pkCon = null;
        DBObject[] ownedObjects = parent.getOwnedObjects();
        for (int i = 0; i < ownedObjects.length; ++i) {
            if (!(ownedObjects[i] instanceof PKConstraint)) continue;
            pkCon = (PKConstraint)ownedObjects[i];
        }
        if (pkCon == null) {
            return false;
        }
        Column[] pkCols = pkCon.getColumns();
        for (int i = 0; i < pkCols.length; ++i) {
            if (!col.equals((Object)pkCols[i])) continue;
            return true;
        }
        return false;
    }

    private boolean descriptorExistsForTable(Project project, String tableName) {
        return XRAdapterUtil.getDescriptorByTableName(project, tableName) != null;
    }

    private void removePreviouslySelectedDescriptors(AdapterWizardContext context, Object[] tableNamesForWSDL) {
        XRAdapterWizardContext ascontext = (XRAdapterWizardContext)context._ascontext;
        Project project = ascontext._orProject;
        Iterator descIt = project.getDescriptors().values().iterator();
        ArrayList<String> descAliases = new ArrayList<String>();
        while (descIt.hasNext()) {
            ClassDescriptor descrip = (ClassDescriptor)descIt.next();
            descAliases.add(descrip.getAlias());
        }
        for (int j = 0; j < descAliases.size(); ++j) {
            boolean wasImportedThisTime = false;
            for (int i = 0; i < tableNamesForWSDL.length; ++i) {
                String temp = tableNamesForWSDL[i].toString();
                if (temp.indexOf(46) != -1 && ((String)descAliases.get(j)).indexOf(46) == -1) {
                    temp = temp.substring(temp.length() - ((String)descAliases.get(j)).length());
                }
                if (!((String)descAliases.get(j)).equals(temp)) continue;
                wasImportedThisTime = true;
                break;
            }
            if (wasImportedThisTime) continue;
            XRAdapterUtil.removeDescriptorForTableName(context, (String)descAliases.get(j));
        }
    }
}

