/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.nls.StringUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.tip.adapter.db.DBAdapterConstants;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterUtil;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterWizardContext;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.sessions.Project;

public class XRAdapterCreateRelationshipsPanel
extends JPanel
implements ActionListener,
DocumentListener {
    private MultiLineLabel instructionsLabel;
    private JLabel tableOneLabel;
    private JComboBox tableOneComboBox;
    private JLabel tableTwoLabel;
    private JComboBox tableTwoComboBox;
    private JRadioButton oneToOneRadioButton;
    private JRadioButton targetOneToOneRadioButton;
    private JRadioButton oneToManyRadioButton;
    private JRadioButton hiddenRadioButton;
    private JCheckBox isPrivateOwnedCheckBox;
    private JTable fieldAssociationsTable;
    private JLabel attributeNameLabel;
    private JTextField attributeNameField;
    private AdapterWizardContext context;
    private JEWTDialog parentDialog;
    private HashSet rootReachableDescriptors;
    private HashSet visitedDescriptors;
    private XRAdapterWizardContext ascontext;

    public XRAdapterCreateRelationshipsPanel(AdapterWizardContext ctx, JEWTDialog parent) {
        this.context = ctx;
        this.ascontext = (XRAdapterWizardContext)ctx._ascontext;
        this.parentDialog = parent;
        this.visitedDescriptors = new HashSet();
        this.rootReachableDescriptors = new HashSet();
        this.rootReachableDescriptors.add(this.ascontext._rootDescriptor);
        this.buildRootReachableTablesSet(this.ascontext._rootDescriptor, this.rootReachableDescriptors);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        Vector parentTables = this.buildTableList(true);
        parentTables.add(0, " ");
        Vector allTables = this.buildTableList(false);
        allTables.add(0, " ");
        String instructionsText = this.getTranslatedString("DB_CR_INTRO_PROMPT");
        this.instructionsLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), instructionsText);
        this.tableOneComboBox = new JComboBox(parentTables);
        this.tableOneComboBox.setRenderer(new TableNameListRenderer());
        this.tableOneComboBox.addActionListener(this);
        String tableOneLabelString = this.getTranslatedString("DB_CR_PARENT_TABLE");
        this.tableOneLabel = new JLabel(StringUtils.stripMnemonic((String)tableOneLabelString));
        this.tableOneLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)tableOneLabelString));
        this.tableOneLabel.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)tableOneLabelString));
        this.tableOneLabel.setLabelFor(this.tableOneComboBox);
        this.tableTwoComboBox = new JComboBox(allTables);
        this.tableTwoComboBox.setRenderer(new TableNameListRenderer());
        this.tableTwoComboBox.addActionListener(this);
        String tableTwoLabelString = this.getTranslatedString("DB_CR_CHILD_TABLE");
        this.tableTwoLabel = new JLabel(StringUtils.stripMnemonic((String)tableTwoLabelString));
        this.tableTwoLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)tableTwoLabelString));
        this.tableTwoLabel.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)tableTwoLabelString));
        this.tableTwoLabel.setLabelFor(this.tableTwoComboBox);
        this.oneToOneRadioButton = new JRadioButton();
        this.oneToOneRadioButton.addActionListener(this);
        this.oneToOneRadioButton.setEnabled(false);
        this.targetOneToOneRadioButton = new JRadioButton();
        this.targetOneToOneRadioButton.addActionListener(this);
        this.targetOneToOneRadioButton.setEnabled(false);
        this.oneToManyRadioButton = new JRadioButton();
        this.oneToManyRadioButton.addActionListener(this);
        this.oneToManyRadioButton.setEnabled(false);
        this.updateRadioButtonText();
        ButtonGroup group = new ButtonGroup();
        group.add(this.oneToOneRadioButton);
        group.add(this.targetOneToOneRadioButton);
        group.add(this.oneToManyRadioButton);
        this.hiddenRadioButton = new JRadioButton();
        group.add(this.hiddenRadioButton);
        this.isPrivateOwnedCheckBox = new JCheckBox("Private Owned");
        this.isPrivateOwnedCheckBox.setSelected(true);
        String tableOneName = "PARENT_TABLE";
        String tableTwoName = "CHILD_TABLE";
        Object[] columnHeaders = new Object[]{tableOneName, tableTwoName};
        Object[][] tableData = new Object[0][0];
        this.fieldAssociationsTable = new JTable(new DefaultTableModel(tableData, columnHeaders));
        this.fieldAssociationsTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
        this.fieldAssociationsTable.addFocusListener(new EmptyTableFocusListener(this.fieldAssociationsTable));
        this.populateFieldAssociationsTable();
        this.attributeNameField = new JTextField();
        this.attributeNameField.getDocument().addDocumentListener(this);
        String attributeNameLabelString = this.getTranslatedString("DB_CR_RELATIONSHIP_NAME");
        this.attributeNameLabel = new JLabel(StringUtils.stripMnemonic((String)attributeNameLabelString));
        this.attributeNameLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)attributeNameLabelString));
        this.attributeNameLabel.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)attributeNameLabelString));
        this.attributeNameLabel.setLabelFor(this.attributeNameField);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 3;
        constraints.gridheight = 1;
        this.add((Component)this.instructionsLabel, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.insets = new Insets(30, 0, 0, 12);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.tableOneLabel, constraints);
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.insets = new Insets(30, 0, 0, 0);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.tableOneComboBox, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.insets = new Insets(12, 0, 0, 12);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.tableTwoLabel, constraints);
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.insets = new Insets(12, 0, 0, 0);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.tableTwoComboBox, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.insets = new Insets(12, 0, 0, 0);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        this.add((Component)this.oneToOneRadioButton, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.insets = new Insets(12, 0, 0, 0);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        this.add((Component)this.targetOneToOneRadioButton, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.insets = new Insets(12, 0, 0, 0);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        this.add((Component)this.oneToManyRadioButton, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 6;
        constraints.insets = new Insets(12, 0, 0, 0);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        this.add((Component)this.isPrivateOwnedCheckBox, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 7;
        constraints.insets = new Insets(12, 0, 0, 0);
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        this.add((Component)new JScrollPane(this.fieldAssociationsTable), constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 8;
        constraints.insets = new Insets(12, 0, 0, 12);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.attributeNameLabel, constraints);
        constraints.anchor = 17;
        constraints.gridx = 1;
        constraints.gridy = 8;
        constraints.insets = new Insets(12, 0, 0, 0);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.attributeNameField, constraints);
    }

    private Vector buildTableList(boolean omitNonRootReachableTables) {
        Vector<RelationalDescriptor> v = new Vector<RelationalDescriptor>();
        for (RelationalDescriptor descriptor : this.ascontext._orProject.getDescriptors().values()) {
            if (omitNonRootReachableTables) {
                if (!this.rootReachableDescriptors.contains(descriptor)) continue;
                v.add(descriptor);
                continue;
            }
            v.add(descriptor);
        }
        return v;
    }

    private void buildRootReachableTablesSet(RelationalDescriptor descriptor, HashSet set) {
        if (this.visitedDescriptors.contains(descriptor)) {
            return;
        }
        this.visitedDescriptors.add(descriptor);
        for (DatabaseMapping mapping : descriptor.getMappings()) {
            if (!(mapping instanceof ForeignReferenceMapping)) continue;
            ForeignReferenceMapping refMapping = (ForeignReferenceMapping)mapping;
            String refClassName = refMapping.getReferenceClassName();
            RelationalDescriptor refDescriptor = (RelationalDescriptor)XRAdapterUtil.getDescriptorByClassName(this.ascontext._orProject, refClassName);
            set.add(refDescriptor);
            this.buildRootReachableTablesSet(refDescriptor, set);
        }
    }

    private String getTranslatedString(String messageKey) {
        return this.context._bundle.getString(messageKey);
    }

    public String getAttributeName() {
        return this.attributeNameField.getText();
    }

    public boolean isOneToOneSelected() {
        return this.oneToOneRadioButton.isSelected();
    }

    public boolean isTargetOneToOneSelected() {
        return this.targetOneToOneRadioButton.isSelected();
    }

    public boolean isOneToManySelected() {
        return this.oneToManyRadioButton.isSelected();
    }

    public boolean isPrivateOwnedRelationship() {
        return this.isPrivateOwnedCheckBox.isSelected();
    }

    private boolean isMappingTypeSelected() {
        return this.oneToOneRadioButton.isSelected() || this.oneToManyRadioButton.isSelected() || this.targetOneToOneRadioButton.isSelected();
    }

    public String[] getFKFieldsArray() {
        FKTableModel model = (FKTableModel)this.fieldAssociationsTable.getModel();
        return model.getFKFieldArray();
    }

    private String generateUniqueAttributeName(boolean isCollection) {
        if (this.tableOneComboBox.getSelectedIndex() == 0 || this.tableTwoComboBox.getSelectedIndex() == 0) {
            return "";
        }
        String baseAttributeName = XRAdapterUtil.toXmlName(this.getDescriptorTwo().getTableName(), false);
        if (isCollection) {
            baseAttributeName = baseAttributeName + "Collection";
        }
        String attributeName = baseAttributeName;
        int counter = 2;
        while (this.mappingExistsNamed(attributeName)) {
            attributeName = baseAttributeName + "_" + String.valueOf(counter);
            ++counter;
        }
        return attributeName;
    }

    private boolean mappingExistsNamed(String name) {
        for (DatabaseMapping mapping : this.getDescriptorOne().getMappings()) {
            ForeignReferenceMapping frMapping;
            DirectToFieldMapping dtfMapping;
            if (mapping == null) continue;
            if (mapping instanceof DirectToFieldMapping && (dtfMapping = (DirectToFieldMapping)mapping).getAttributeName().equals(name)) {
                return true;
            }
            if (!(mapping instanceof ForeignReferenceMapping) || !(frMapping = (ForeignReferenceMapping)mapping).getAttributeName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public RelationalDescriptor getDescriptorOne() {
        if (this.tableOneComboBox.getSelectedIndex() == 0) {
            return null;
        }
        return (RelationalDescriptor)this.tableOneComboBox.getSelectedItem();
    }

    public RelationalDescriptor getDescriptorTwo() {
        if (this.tableTwoComboBox.getSelectedIndex() == 0) {
            return null;
        }
        return (RelationalDescriptor)this.tableTwoComboBox.getSelectedItem();
    }

    private void updateRadioButtonText() {
        String tableOneName = "PARENT_TABLE";
        String tableTwoName = "CHILD_TABLE";
        if (this.tableOneComboBox.getSelectedIndex() != 0 && this.tableTwoComboBox.getSelectedIndex() != 0) {
            tableOneName = this.getDescriptorOne().getTableName();
            tableTwoName = this.getDescriptorTwo().getTableName();
        }
        MessageFormat msgformat = new MessageFormat(this.getTranslatedString("DB_CR_ONETOONE_RB"));
        Object[] args = new Object[]{tableOneName, tableTwoName};
        String oneToOneText = msgformat.format(args);
        msgformat = new MessageFormat(this.getTranslatedString("DB_CR_TARGETONETOONE_RB"));
        String targetOneToOneText = msgformat.format(args);
        msgformat = new MessageFormat(this.getTranslatedString("DB_CR_ONETOMANY_RB"));
        String oneToManyText = msgformat.format(args);
        this.oneToOneRadioButton.setText(StringUtils.stripMnemonic((String)oneToOneText));
        this.oneToOneRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)oneToOneText));
        this.oneToOneRadioButton.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)oneToOneText));
        this.targetOneToOneRadioButton.setText(StringUtils.stripMnemonic((String)targetOneToOneText));
        this.targetOneToOneRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)targetOneToOneText));
        this.targetOneToOneRadioButton.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)targetOneToOneText));
        this.oneToManyRadioButton.setText(StringUtils.stripMnemonic((String)oneToManyText));
        this.oneToManyRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)oneToManyText));
        this.oneToManyRadioButton.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)oneToManyText));
    }

    private void checkEnableOK() {
        if (this.tableOneComboBox.getSelectedIndex() == 0 || this.tableTwoComboBox.getSelectedIndex() == 0) {
            this.parentDialog.setOKButtonEnabled(false);
            this.oneToOneRadioButton.setEnabled(false);
            this.targetOneToOneRadioButton.setEnabled(false);
            this.oneToManyRadioButton.setEnabled(false);
            this.hiddenRadioButton.setSelected(true);
            this.attributeNameField.setText("");
            return;
        }
        this.oneToOneRadioButton.setEnabled(true);
        this.targetOneToOneRadioButton.setEnabled(true);
        this.oneToManyRadioButton.setEnabled(true);
        if (!this.isMappingTypeSelected()) {
            this.parentDialog.setOKButtonEnabled(false);
            return;
        }
        if (this.fieldAssociationsTable.getModel() instanceof FKTableModel) {
            FKTableModel model = (FKTableModel)this.fieldAssociationsTable.getModel();
            String[] fkFieldNames = model.getFKFieldArray();
            for (int i = 0; i < fkFieldNames.length; ++i) {
                if (!fkFieldNames[i].equals(" ")) continue;
                this.parentDialog.setOKButtonEnabled(false);
                return;
            }
        } else {
            this.parentDialog.setOKButtonEnabled(false);
            return;
        }
        this.parentDialog.setOKButtonEnabled(true);
    }

    private void populateFieldAssociationsTable() {
        if (this.tableOneComboBox.getSelectedIndex() == 0 || this.tableTwoComboBox.getSelectedIndex() == 0 || !this.isMappingTypeSelected()) {
            String tableOneName = "PARENT_TABLE";
            String tableTwoName = "CHILD_TABLE";
            Object[] columnHeaders = new Object[]{tableOneName, tableTwoName};
            Object[][] tableData = new Object[0][0];
            FKTableModel newModel = new FKTableModel(tableData, columnHeaders);
            this.fieldAssociationsTable.setModel(newModel);
            return;
        }
        try {
            int i;
            ForeignReferenceMapping candidateRelationshipPartner;
            DatabaseField field;
            Iterator iter;
            ArrayList candidateForeignKeys;
            RelationalDescriptor descOne = this.getDescriptorOne();
            RelationalDescriptor descTwo = this.getDescriptorTwo();
            Object[] primaryKeys = new Object[]{};
            Object[] foreignKeys = new Object[]{};
            if (this.isOneToOneSelected()) {
                candidateForeignKeys = XRAdapterUtil.getColumnNamesFromDBProperties(descOne.getTables(), this.ascontext._dtProps);
                iter = candidateForeignKeys.iterator();
                while (iter.hasNext()) {
                    field = new DatabaseField((String)iter.next());
                    candidateRelationshipPartner = DBAdapterConstants.getExternalMappingForField((Class)descOne.getJavaClass(), (Project)this.ascontext._orProject, (DatabaseField)field);
                    if (candidateRelationshipPartner != null && candidateRelationshipPartner.getDescriptor() != descTwo) {
                        iter.remove();
                        continue;
                    }
                    if (!(DBAdapterConstants.getMappingForField((RelationalDescriptor)descOne, (DatabaseField)field) instanceof OneToOneMapping)) continue;
                    iter.remove();
                }
                foreignKeys = candidateForeignKeys.toArray();
                primaryKeys = descTwo.getPrimaryKeyFieldNames().toArray();
            } else {
                candidateForeignKeys = XRAdapterUtil.getColumnNamesFromDBProperties(descTwo.getTables(), this.ascontext._dtProps);
                iter = candidateForeignKeys.iterator();
                while (iter.hasNext()) {
                    field = new DatabaseField((String)iter.next());
                    if (DBAdapterConstants.getExternalMappingForField((Class)descTwo.getJavaClass(), (Project)this.ascontext._orProject, (DatabaseField)field) != null) {
                        iter.remove();
                        continue;
                    }
                    candidateRelationshipPartner = DBAdapterConstants.getMappingForField((RelationalDescriptor)descTwo, (DatabaseField)field);
                    if (candidateRelationshipPartner == null || !candidateRelationshipPartner.isOneToOneMapping() || candidateRelationshipPartner.getReferenceClass().isAssignableFrom(descOne.getJavaClass())) continue;
                    iter.remove();
                }
                foreignKeys = candidateForeignKeys.toArray();
                primaryKeys = descOne.getPrimaryKeyFieldNames().toArray();
            }
            Object[][] tableData = new Object[primaryKeys.length][2];
            if (this.isOneToOneSelected()) {
                for (i = 0; i < primaryKeys.length; ++i) {
                    tableData[i][0] = " ";
                    tableData[i][1] = primaryKeys[i].toString();
                }
            } else {
                for (i = 0; i < primaryKeys.length; ++i) {
                    tableData[i][0] = primaryKeys[i].toString();
                    tableData[i][1] = " ";
                }
            }
            Object[] columnHeaders = new Object[]{descOne.getTableName(), descTwo.getTableName()};
            FKTableModel newModel = new FKTableModel(tableData, columnHeaders);
            this.fieldAssociationsTable.setModel(newModel);
            TableColumn fkCol = this.fieldAssociationsTable.getColumnModel().getColumn(this.isOneToOneSelected() ? 0 : 1);
            JComboBox<Object> fkComboBox = new JComboBox<Object>(foreignKeys);
            fkComboBox.insertItemAt(" ", 0);
            fkComboBox.setName("FKComboBox");
            fkComboBox.addActionListener(this);
            ComboBoxTableCellEditor comboBoxEditor = new ComboBoxTableCellEditor(fkComboBox);
            fkCol.setCellEditor(comboBoxEditor);
            fkCol.setCellRenderer(new ComboBoxTableCellRenderer());
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)this.context._parentFrame, (Exception)e);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComponent component = (JComponent)e.getSource();
        if (component.getName() != null && component.getName().equals("FKComboBox")) {
            this.checkEnableOK();
            return;
        }
        if (e.getSource() == this.tableOneComboBox || e.getSource() == this.tableTwoComboBox) {
            this.updateRadioButtonText();
            if (this.isMappingTypeSelected()) {
                this.attributeNameField.setText(this.generateUniqueAttributeName(this.isOneToManySelected()));
            }
            this.populateFieldAssociationsTable();
            this.checkEnableOK();
            return;
        }
        if (e.getSource() == this.oneToOneRadioButton || e.getSource() == this.targetOneToOneRadioButton || e.getSource() == this.oneToManyRadioButton) {
            this.populateFieldAssociationsTable();
            this.attributeNameField.setText(this.generateUniqueAttributeName(this.isOneToManySelected()));
            this.isPrivateOwnedCheckBox.setSelected(e.getSource() == this.targetOneToOneRadioButton || e.getSource() == this.oneToManyRadioButton);
            this.checkEnableOK();
            return;
        }
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
        this.checkEnableOK();
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.checkEnableOK();
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.checkEnableOK();
    }

    private class EmptyTableFocusListener
    implements FocusListener {
        private JTable table;

        public EmptyTableFocusListener(JTable t) {
            this.table = t;
        }

        @Override
        public void focusGained(FocusEvent evt) {
            Container cycleRoot = this.table.getFocusCycleRootAncestor();
            FocusTraversalPolicy policy = this.table.getFocusTraversalPolicy();
            if (policy == null && cycleRoot != null) {
                policy = cycleRoot.getFocusTraversalPolicy();
            }
            if (this.table.getRowCount() == 0 && policy != null) {
                Component target = policy.getComponentAfter(cycleRoot, this.table);
                if (target != null && target == evt.getOppositeComponent()) {
                    target = policy.getComponentBefore(cycleRoot, this.table);
                }
                if (target != null) {
                    target.requestFocusInWindow();
                }
            }
        }

        @Override
        public void focusLost(FocusEvent evt) {
        }
    }

    private class FKTableModel
    extends DefaultTableModel {
        private String[] fkFieldArray;

        public FKTableModel(Object[][] data, Object[] columnNames) {
            super(data, columnNames);
            this.fkFieldArray = new String[data.length];
            for (int i = 0; i < data.length; ++i) {
                this.fkFieldArray[i] = XRAdapterCreateRelationshipsPanel.this.isOneToOneSelected() ? data[i][0].toString() : data[i][1].toString();
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (col == 0) {
                return XRAdapterCreateRelationshipsPanel.this.isOneToOneSelected();
            }
            if (col == 1) {
                return XRAdapterCreateRelationshipsPanel.this.isTargetOneToOneSelected() || XRAdapterCreateRelationshipsPanel.this.isOneToManySelected();
            }
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            super.setValueAt(value, row, col);
            this.fkFieldArray[row] = value.toString();
        }

        public String[] getFKFieldArray() {
            return this.fkFieldArray;
        }
    }

    private class ComboBoxTableCellEditor
    extends DefaultCellEditor {
        private JComboBox internalComboBox;

        public ComboBoxTableCellEditor(JComboBox comboBox) {
            super(comboBox);
            this.internalComboBox = comboBox;
        }

        public JComboBox getComboBox() {
            return this.internalComboBox;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JComboBox comboBox = (JComboBox)super.getTableCellEditorComponent(table, value, isSelected, row, column);
            comboBox.setBorder(new EmptyBorder(0, 0, 0, 0));
            return comboBox;
        }
    }

    private class ComboBoxTableCellRenderer
    extends DefaultTableCellRenderer {
        private ComboBoxTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComboBox<Object> comboBox = new JComboBox<Object>(new Object[]{value});
            comboBox.setBorder(new EmptyBorder(0, 0, 0, 0));
            return comboBox;
        }
    }

    private class TableNameListRenderer
    extends DefaultListCellRenderer {
        private TableNameListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof RelationalDescriptor) {
                RelationalDescriptor desc = (RelationalDescriptor)value;
                return super.getListCellRendererComponent((JList<?>)list, desc.getTableName(), index, isSelected, cellHasFocus);
            }
            return super.getListCellRendererComponent((JList<?>)list, " ", index, isSelected, cellHasFocus);
        }
    }
}

