/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.wsdl.WSDLException;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.tip.adapter.db.DBActivationSpec;
import oracle.tip.adapter.db.api.TopLinkReadSpec;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterAdvancedOptionsPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterExternalSequencingPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterFileSequencingPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterLogicalDeletePage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterPollingOptionsPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterSequencingPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterUtil;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterWhereClausePage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterWizardContext;

public class XRAdapterAfterReadPage
extends techAdapterWizardPage
implements ActionListener,
XRAdapterPage {
    private MultiLineLabel instructionsLabel;
    private JRadioButton deleteRowRadioButton;
    private JRadioButton logicalDeleteRadioButton;
    private JRadioButton sequencingTableRadioButton;
    private JRadioButton extSequencingTableRadioButton;
    private JRadioButton fileSequencingRadioButton;
    private ButtonGroup buttonGroup = new ButtonGroup();
    public static final String s_PollingStrategy = "PollingStrategy";
    public static final String s_DeletePollingStrategy = "DeletePollingStrategy";
    public static final String s_LogicalDeletePollingStrategy = "LogicalDeletePollingStrategy";
    public static final String s_SequencingPollingStrategy = "SequencingPollingStrategy";
    public static final String s_ExternalSequencingPollingStrategy = "ExternalSequencingPollingStrategy";
    public static final String s_FileSequencingPollingStrategy = "FileSequencingPollingStrategy";
    private XRAdapterWizardContext ascontext;

    public XRAdapterAfterReadPage(AdapterWizardContext context, ImageWizardPage page) {
        try {
            this.setContextAndPage(context, page);
            this.ascontext = (XRAdapterWizardContext)context._ascontext;
            this.ascontext._afterReadPage = this;
            this.initialize();
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)this.m_wcontext._parentFrame, (Exception)e);
        }
    }

    public void initialize() {
        this.setLayout(new GridBagLayout());
        String instructionsText = this.getTranslatedString("DB_AR_INTRO_PROMPT");
        this.instructionsLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), instructionsText);
        String deleteRowRadioButtonString = this.getTranslatedString("DB_AR_DELETE_ROWS");
        this.deleteRowRadioButton = new JRadioButton(StringUtils.stripMnemonic((String)deleteRowRadioButtonString));
        this.deleteRowRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)deleteRowRadioButtonString));
        this.deleteRowRadioButton.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)deleteRowRadioButtonString));
        MessageFormat msgformat = new MessageFormat(this.getTranslatedString("DB_AR_LOGICAL_DELETE"));
        Object[] args = new Object[]{this.ascontext._rootDescriptor == null ? "" : this.ascontext._rootDescriptor.getTableName()};
        String logicalDeleteRadioButtonString = msgformat.format(args);
        this.logicalDeleteRadioButton = new JRadioButton(StringUtils.stripMnemonic((String)logicalDeleteRadioButtonString));
        this.logicalDeleteRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)logicalDeleteRadioButtonString));
        this.logicalDeleteRadioButton.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)logicalDeleteRadioButtonString));
        String sequencingTableRadioButtonString = this.getTranslatedString("DB_AR_SEQ_TABLE");
        this.sequencingTableRadioButton = new JRadioButton(StringUtils.stripMnemonic((String)sequencingTableRadioButtonString));
        this.sequencingTableRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)sequencingTableRadioButtonString));
        this.sequencingTableRadioButton.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)sequencingTableRadioButtonString));
        String extSequencingTableRadioButtonString = this.getTranslatedString("DB_AR_EXT_SEQ_TABLE");
        this.extSequencingTableRadioButton = new JRadioButton(StringUtils.stripMnemonic((String)extSequencingTableRadioButtonString));
        this.extSequencingTableRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)extSequencingTableRadioButtonString));
        this.extSequencingTableRadioButton.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)extSequencingTableRadioButtonString));
        String fileSequencingTableRadioButtonString = this.getTranslatedString("DB_AR_FILE_SEQ");
        this.fileSequencingRadioButton = new JRadioButton(StringUtils.stripMnemonic((String)fileSequencingTableRadioButtonString));
        this.fileSequencingRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)fileSequencingTableRadioButtonString));
        this.fileSequencingRadioButton.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)fileSequencingTableRadioButtonString));
        this.buttonGroup.add(this.deleteRowRadioButton);
        this.buttonGroup.add(this.logicalDeleteRadioButton);
        this.buttonGroup.add(this.sequencingTableRadioButton);
        this.buttonGroup.add(this.extSequencingTableRadioButton);
        this.buttonGroup.add(this.fileSequencingRadioButton);
        this.deleteRowRadioButton.setSelected(true);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 3;
        constraints.gridheight = 1;
        this.add((Component)this.instructionsLabel, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.insets = new Insets(30, 0, 0, 0);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.deleteRowRadioButton, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.logicalDeleteRadioButton, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.sequencingTableRadioButton, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.extSequencingTableRadioButton, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 6;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        this.add((Component)this.fileSequencingRadioButton, constraints);
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 7;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 3;
        constraints.gridheight = 1;
        this.add((Component)new JPanel(), constraints);
        if (this.m_wcontext._read_service != null) {
            this.populateUIForEdit();
        } else {
            this.addFollowingPages();
        }
        this.deleteRowRadioButton.addActionListener(this);
        this.logicalDeleteRadioButton.addActionListener(this);
        this.sequencingTableRadioButton.addActionListener(this);
        this.extSequencingTableRadioButton.addActionListener(this);
        this.fileSequencingRadioButton.addActionListener(this);
    }

    public String selectedAfterReadStrategy() {
        if (this.deleteRowRadioButton.isSelected()) {
            return s_DeletePollingStrategy;
        }
        if (this.logicalDeleteRadioButton.isSelected()) {
            return s_LogicalDeletePollingStrategy;
        }
        if (this.sequencingTableRadioButton.isSelected()) {
            return s_SequencingPollingStrategy;
        }
        if (this.extSequencingTableRadioButton.isSelected()) {
            return s_ExternalSequencingPollingStrategy;
        }
        if (this.fileSequencingRadioButton.isSelected()) {
            return s_FileSequencingPollingStrategy;
        }
        return "";
    }

    public boolean isSequencingPollingStrategy() {
        return this.sequencingTableRadioButton.isSelected() || this.extSequencingTableRadioButton.isSelected() || this.fileSequencingRadioButton.isSelected();
    }

    public void populateUIForEdit() {
        techAdapterWizardPage nextPage;
        ImageWizardPage tempwp;
        JcaOperation jop = this.m_wcontext._read_jca_operation;
        String strategy = jop.getAttributeValue(s_PollingStrategy);
        if (strategy.equals(s_DeletePollingStrategy)) {
            this.deleteRowRadioButton.setSelected(true);
        }
        if (strategy.equals(s_LogicalDeletePollingStrategy)) {
            this.logicalDeleteRadioButton.setSelected(true);
            tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("DB_LD_TITLE"));
            if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_db_logic");
            }
            nextPage = new XRAdapterLogicalDeletePage(this.m_wcontext, tempwp);
        }
        if (strategy.equals(s_SequencingPollingStrategy)) {
            this.sequencingTableRadioButton.setSelected(true);
            tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("DB_LR_TITLE"));
            if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_db_seq_table");
            }
            nextPage = new XRAdapterSequencingPage(this.m_wcontext, tempwp);
        }
        if (strategy.equals(s_ExternalSequencingPollingStrategy)) {
            this.extSequencingTableRadioButton.setSelected(true);
            tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("DB_LR_EXT_TITLE"));
            if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_db_extseq_table");
            }
            nextPage = new XRAdapterExternalSequencingPage(this.m_wcontext, tempwp);
        }
        if (strategy.equals(s_FileSequencingPollingStrategy)) {
            this.fileSequencingRadioButton.setSelected(true);
            tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("DB_LR_FILE_TITLE"));
            if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_db_seqfile");
            }
            nextPage = new XRAdapterFileSequencingPage(this.m_wcontext, tempwp);
        }
        tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("DB_PO_TITLE"));
        if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_db_polling");
        }
        nextPage = new XRAdapterPollingOptionsPage(this.m_wcontext, tempwp);
        tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("DB_WC_TITLE"));
        if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_db_where");
        }
        XRAdapterWhereClausePage whereClausePage = new XRAdapterWhereClausePage(this.m_wcontext, tempwp);
        tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("DB_AO_TITLE"));
        if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_db_ao");
        }
        XRAdapterAdvancedOptionsPage advancedOptionsPage = new XRAdapterAdvancedOptionsPage(this.m_wcontext, tempwp);
        XRAdapterUtil.setFinishPage(this);
    }

    private void clearAfterReadParameters() {
    }

    private void addFollowingPages() {
        techAdapterWizardPage nextPage;
        ImageWizardPage tempwp;
        if (this.deleteRowRadioButton.isSelected()) {
            this.ascontext._sequencingColumn = null;
        }
        if (this.sequencingTableRadioButton.isSelected()) {
            tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("DB_LR_TITLE"));
            if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_db_seq_table");
            }
            nextPage = new XRAdapterSequencingPage(this.m_wcontext, tempwp);
        }
        if (this.extSequencingTableRadioButton.isSelected()) {
            tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("DB_LR_EXT_TITLE"));
            if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_db_extseq_table");
            }
            nextPage = new XRAdapterExternalSequencingPage(this.m_wcontext, tempwp);
        }
        if (this.logicalDeleteRadioButton.isSelected()) {
            tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("DB_LD_TITLE"));
            if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_db_logic");
            }
            nextPage = new XRAdapterLogicalDeletePage(this.m_wcontext, tempwp);
            this.ascontext._sequencingColumn = null;
        }
        if (this.fileSequencingRadioButton.isSelected()) {
            tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("DB_LR_FILE_TITLE"));
            if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_db_seqfile");
            }
            nextPage = new XRAdapterFileSequencingPage(this.m_wcontext, tempwp);
        }
        tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("DB_PO_TITLE"));
        nextPage = new XRAdapterPollingOptionsPage(this.m_wcontext, tempwp);
        if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_db_polling");
        }
        tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("DB_WC_TITLE"));
        if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_db_where");
        }
        XRAdapterWhereClausePage whereClausePage = new XRAdapterWhereClausePage(this.m_wcontext, tempwp);
        tempwp = new ImageWizardPage(null, this._getImage(), this.getTranslatedString("DB_AO_TITLE"));
        if (!AdapterWizardContext.IS_STANDALONE_TESTING && !this.m_wcontext.isStandalone()) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)tempwp.getContent(), "bpmjdev_adp_wiz_db_ao");
        }
        XRAdapterAdvancedOptionsPage advancedOptionsPage = new XRAdapterAdvancedOptionsPage(this.m_wcontext, tempwp);
        XRAdapterUtil.setFinishPage(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.removePages();
        this.m_wizard.setMustFinish(true);
        this.addFollowingPages();
        if (e.getSource() == this.deleteRowRadioButton) {
            XRAdapterUtil.refreshSQLPanes(this.m_wcontext);
        }
    }

    @Override
    public void wizardValidatePage(WizardEvent event) {
        XRAdapterWizardContext context = (XRAdapterWizardContext)this.m_wcontext._ascontext;
        context._sequencingColumn = null;
        if (this.deleteRowRadioButton.isSelected()) {
            if (this.m_wcontext._read_service == null) {
                context._pollingOptionsPage.refreshOrderByFieldChoices();
            }
            XRAdapterUtil.refreshSQLPanes(this.m_wcontext);
        }
    }

    @Override
    public void buildWSDL() throws WSDLException {
        String oldPollingStrategy = null;
        if (this.m_wcontext._read_service != null && this.m_wcontext._read_jca_operation != null) {
            oldPollingStrategy = this.m_wcontext._read_jca_operation.getAttributeValue(s_PollingStrategy);
        }
        if (this.deleteRowRadioButton.isSelected()) {
            this.ascontext._inboundSelectOp.setAttributeValue(s_PollingStrategy, s_DeletePollingStrategy);
        }
        if (this.logicalDeleteRadioButton.isSelected()) {
            this.ascontext._inboundSelectOp.setAttributeValue(s_PollingStrategy, s_LogicalDeletePollingStrategy);
        }
        if (this.sequencingTableRadioButton.isSelected()) {
            this.ascontext._inboundSelectOp.setAttributeValue(s_PollingStrategy, s_SequencingPollingStrategy);
        }
        if (this.extSequencingTableRadioButton.isSelected()) {
            this.ascontext._inboundSelectOp.setAttributeValue(s_PollingStrategy, s_ExternalSequencingPollingStrategy);
        }
        if (this.fileSequencingRadioButton.isSelected()) {
            this.ascontext._inboundSelectOp.setAttributeValue(s_PollingStrategy, s_FileSequencingPollingStrategy);
        }
        if (oldPollingStrategy != null && !this.ascontext._inboundSelectOp.getAttributeValue(s_PollingStrategy).equals(oldPollingStrategy)) {
            this.stripAwayUnusedProperties();
        }
    }

    private void stripAwayUnusedProperties() {
        boolean sequencingPolling = this.fileSequencingRadioButton.isSelected() || this.sequencingTableRadioButton.isSelected() || this.extSequencingTableRadioButton.isSelected();
        boolean destructivePolling = this.deleteRowRadioButton.isSelected() || this.logicalDeleteRadioButton.isSelected();
        boolean fileSequencing = this.fileSequencingRadioButton.isSelected();
        if (!sequencingPolling) {
            this.ascontext._inboundSelectOp.removeAttribute("PollForChildUpdates");
            this.ascontext._inboundSelectOp.removeAttribute("DelayCommit");
        }
        if (!sequencingPolling || this.fileSequencingRadioButton.isSelected()) {
            this.ascontext._inboundSelectOp.removeAttribute("SequencingTable");
            this.ascontext._inboundSelectOp.removeAttribute("SequencingTableKeyColumn");
            this.ascontext._inboundSelectOp.removeAttribute("SequencingTableKey");
            this.ascontext._inboundSelectOp.removeAttribute("SequencingTableValueColumn");
        }
        if (!this.fileSequencingRadioButton.isSelected()) {
            this.ascontext._inboundSelectOp.removeAttribute("SequencingFileName");
        }
        if (!this.extSequencingTableRadioButton.isSelected()) {
            this.ascontext._inboundSelectOp.removeAttribute("SequencingDataSourceName");
            this.ascontext._inboundSelectOp.removeAttribute("SequencingIsXADataSource");
        }
        if (!destructivePolling || this.deleteRowRadioButton.isSelected() && this.ascontext._inboundSelectOp.getAttributeValue("MarkReservedValue") == null) {
            this.ascontext._inboundSelectOp.removeAttribute("MarkReadColumn");
            this.ascontext._inboundSelectOp.removeAttribute("MarkReservedValue");
            this.ascontext._inboundSelectOp.removeAttribute("MarkUnreadValue");
        }
        if (!this.logicalDeleteRadioButton.isSelected()) {
            this.ascontext._inboundSelectOp.removeAttribute("MarkReadValue");
        }
    }

    @Override
    public void buildSpec(TopLinkReadSpec spec) {
        if (spec instanceof DBActivationSpec) {
            DBActivationSpec activationSpec = (DBActivationSpec)spec;
            if (this.deleteRowRadioButton.isSelected()) {
                activationSpec.setPollingStrategy(s_DeletePollingStrategy);
            }
            if (this.logicalDeleteRadioButton.isSelected()) {
                activationSpec.setPollingStrategy(s_LogicalDeletePollingStrategy);
            }
            if (this.sequencingTableRadioButton.isSelected()) {
                activationSpec.setPollingStrategy(s_SequencingPollingStrategy);
            }
            if (this.extSequencingTableRadioButton.isSelected()) {
                activationSpec.setPollingStrategy(s_ExternalSequencingPollingStrategy);
            }
            if (this.fileSequencingRadioButton.isSelected()) {
                activationSpec.setPollingStrategy(s_FileSequencingPollingStrategy);
            }
            return;
        }
    }
}

