/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.model.Project;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.fabric.api.PropertyInfo;
import oracle.tip.tools.ide.fabric.api.SCAController;
import oracle.tip.tools.ide.fabric.api.SCAControllerImpl;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.XRAdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.xr.util.XRAdapterJDevUtil;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.queries.ReadQuery;

public class XRAdapterAdvancedOptionsPage
extends techAdapterWizardPage
implements ActionListener {
    private int initialQueryTimeout = 0;
    private int initialMaxRows = 0;
    private MultiLineLabel instructionsLabel;
    private JLabel jdbcTimeoutLabel;
    private JFormattedTextField jdbcTimeoutField;
    private JLabel jdbcMaxRowsLabel;
    private JFormattedTextField jdbcMaxRowsField;
    private JPanel nativeSequencingPanel;
    private JLabel sequencingTableLabel;
    private JComboBox sequencingTableComboBox;
    private JLabel sequencingSequenceLabel;
    private JComboBox sequencingSequenceComboBox;
    private JButton sequencingSearchButton;
    private JButton sequencingCreateButton;
    private static String NONE_ELEMENT = null;
    private JPanel retryPanel;
    private JLabel retryIntervalLabel;
    private JFormattedTextField retryIntervalField;
    private JLabel retryCountLabel;
    private JTextField retryCountField;
    private JLabel retryMaxIntervalLabel;
    private JFormattedTextField retryMaxIntervalField;
    private JLabel retryBackoffLabel;
    private JFormattedTextField retryBackoffField;
    private JPanel interactionPanel;
    private JLabel interactionLabel;
    private JCheckBox detectOmissionsCheckBox;
    private JCheckBox optimizeMergeCheckBox;
    private JCheckBox getActiveUnitOfWorkCheckBox;
    private XRAdapterWizardContext ascontext;
    public static String JCA_RETRY_INTERVAL_PROP = "jca.retry.interval";
    public static String JCA_RETRY_COUNT_PROP = "jca.retry.count";
    public static String JCA_RETRY_BACKOFF_PROP = "jca.retry.backoff";
    public static String JCA_RETRY_MAX_INTERVAL_PROP = "jca.retry.maxInterval";
    static Vector<String> sequencesOnDatabase;

    public XRAdapterAdvancedOptionsPage(AdapterWizardContext context, ImageWizardPage page) {
        try {
            if (context._ascontext instanceof XRAdapterWizardContext) {
                this.ascontext = (XRAdapterWizardContext)context._ascontext;
                this.ascontext._advancedOptionsPage = this;
            }
            this.setContextAndPage(context, page);
            this.initialize();
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)this.m_wcontext._parentFrame, (Exception)e);
        }
    }

    public void initialize() {
        this.setLayout(new GridBagLayout());
        String instructionsText = this.getTranslatedString("DB_AO_INTRO_PROMPT");
        this.instructionsLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), instructionsText);
        JPanel jdbcOptionsPanel = new JPanel(new GridBagLayout());
        jdbcOptionsPanel.setBorder(BorderFactory.createTitledBorder(this.getTranslatedString("DB_AO_JDBC_OPTIONS")));
        this.initializeJDBCOptionsPanel(jdbcOptionsPanel);
        int numOfPanels = 1;
        this.retryPanel = new JPanel(new GridBagLayout());
        this.retryPanel.setBorder(BorderFactory.createTitledBorder(this.getTranslatedString("DB_AO_RETRY")));
        this.initializeRetryPanel(this.retryPanel);
        ++numOfPanels;
        if (!this.m_wcontext._isInboundOperation) {
            this.interactionPanel = new JPanel(new GridBagLayout());
            this.interactionPanel.setBorder(BorderFactory.createTitledBorder(this.getTranslatedString("DB_AO_INTERACTION_OPTIONS")));
            this.initializeInteractionPanel(this.interactionPanel);
            ++numOfPanels;
            if (this.isOraclePlatform() && this.ascontext != null && (this.ascontext._operationPage.isMergeSelected() || this.ascontext._operationPage.isInsertSelected())) {
                this.nativeSequencingPanel = new JPanel(new GridBagLayout());
                this.nativeSequencingPanel.setBorder(BorderFactory.createTitledBorder(this.getTranslatedString("DB_AO_NATIVE_SEQUENCING")));
                this.nativeSequencingPanel.setPreferredSize(new Dimension(300, 120));
                this.initializeNativeSequencingPanel(this.nativeSequencingPanel);
                ++numOfPanels;
            }
        }
        JPanel fillerPanel = null;
        if (numOfPanels % 2 == 1) {
            fillerPanel = new JPanel();
            ++numOfPanels;
        }
        int currentPanel = 0;
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 4;
        constraints.gridheight = 1;
        this.add((Component)this.instructionsLabel, constraints);
        constraints.gridx = 2 * (currentPanel / (numOfPanels / 2));
        constraints.gridy = 1 + currentPanel++ % (numOfPanels / 2);
        constraints.insets = new Insets(12, 0, 0, 12);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        this.add((Component)jdbcOptionsPanel, constraints);
        if (this.interactionPanel != null) {
            constraints.gridx = 2 * (currentPanel / (numOfPanels / 2));
            constraints.gridy = 1 + currentPanel++ % (numOfPanels / 2);
            this.add((Component)this.interactionPanel, constraints);
        }
        if (this.retryPanel != null) {
            constraints.gridx = 2 * (currentPanel / (numOfPanels / 2));
            constraints.gridy = 1 + currentPanel++ % (numOfPanels / 2);
            this.add((Component)this.retryPanel, constraints);
        }
        if (this.nativeSequencingPanel != null) {
            constraints.gridx = 2 * (currentPanel / (numOfPanels / 2));
            constraints.gridy = 1 + currentPanel++ % (numOfPanels / 2);
            this.add((Component)this.nativeSequencingPanel, constraints);
        }
        if (fillerPanel != null) {
            constraints.gridx = 2 * (currentPanel / (numOfPanels / 2));
            constraints.gridy = 1 + currentPanel++ % (numOfPanels / 2);
            constraints.fill = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            this.add((Component)fillerPanel, constraints);
        }
        if (this.m_wcontext._read_service != null) {
            this.populateUIForEdit();
        }
    }

    private void initializeInteractionPanel(JPanel interactionPanel) {
        if (this.ascontext != null && !this.ascontext._isPureSQLOp) {
            if (this.ascontext._operationPage == null || this.ascontext._operationPage.isMergeSelected()) {
                String optimizeMergeCheckBoxString = this.getTranslatedString("DB_AO_OPTIMIZE_MERGE");
                this.optimizeMergeCheckBox = new JCheckBox(StringUtils.stripMnemonic((String)optimizeMergeCheckBoxString), false);
                this.optimizeMergeCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)optimizeMergeCheckBoxString));
                this.optimizeMergeCheckBox.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)optimizeMergeCheckBoxString));
                this.optimizeMergeCheckBox.addActionListener(this);
                this.optimizeMergeCheckBox.setSelected(true);
                this.optimizeMergeCheckBox.setEnabled(true);
                this.optimizeMergeCheckBox.setMinimumSize(new Dimension(70, 10));
            }
            if (this.ascontext._operationPage == null || this.ascontext._operationPage.isMergeSelected() || this.ascontext._operationPage.isInsertSelected() || this.ascontext._operationPage.isUpdateSelected()) {
                String detectOmissionsCheckBoxString = this.getTranslatedString("DB_AO_DETECT_OMISSIONS");
                this.detectOmissionsCheckBox = new JCheckBox(StringUtils.stripMnemonic((String)detectOmissionsCheckBoxString), false);
                this.detectOmissionsCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)detectOmissionsCheckBoxString));
                this.detectOmissionsCheckBox.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)detectOmissionsCheckBoxString));
                this.detectOmissionsCheckBox.addActionListener(this);
                this.detectOmissionsCheckBox.setSelected(true);
                this.detectOmissionsCheckBox.setEnabled(true);
                this.detectOmissionsCheckBox.setMinimumSize(new Dimension(70, 10));
            }
        }
        String getActiveUnitOfWorkCheckBoxString = this.getTranslatedString("DB_AO_GET_ACTIVE_UNIT_OF_WORK");
        this.getActiveUnitOfWorkCheckBox = new JCheckBox(StringUtils.stripMnemonic((String)getActiveUnitOfWorkCheckBoxString), false);
        this.getActiveUnitOfWorkCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)getActiveUnitOfWorkCheckBoxString));
        this.getActiveUnitOfWorkCheckBox.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)getActiveUnitOfWorkCheckBoxString));
        this.getActiveUnitOfWorkCheckBox.addActionListener(this);
        this.getActiveUnitOfWorkCheckBox.setEnabled(true);
        this.getActiveUnitOfWorkCheckBox.setMinimumSize(new Dimension(70, 10));
        int y = 0;
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 19;
        constraints.gridx = 0;
        constraints.gridy = y++;
        constraints.insets = new Insets(12, 0, 0, 12);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = this.detectOmissionsCheckBox == null && this.optimizeMergeCheckBox == null ? 1.0 : 0.0;
        constraints.ipadx = 0;
        interactionPanel.add((Component)this.getActiveUnitOfWorkCheckBox, constraints);
        if (this.detectOmissionsCheckBox != null) {
            constraints.anchor = 21;
            constraints.gridx = 0;
            constraints.gridy = y++;
            constraints.insets = new Insets(12, 0, 0, 12);
            constraints.fill = 2;
            constraints.weightx = 1.0;
            constraints.weighty = this.optimizeMergeCheckBox == null ? 1.0 : 0.0;
            constraints.ipadx = 0;
            interactionPanel.add((Component)this.detectOmissionsCheckBox, constraints);
        }
        if (this.optimizeMergeCheckBox != null) {
            constraints.anchor = 21;
            constraints.gridx = 0;
            constraints.gridy = y++;
            constraints.insets = new Insets(12, 0, 0, 12);
            constraints.fill = 2;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.ipadx = 0;
            interactionPanel.add((Component)this.optimizeMergeCheckBox, constraints);
        }
    }

    private void initializeJDBCOptionsPanel(JPanel jdbcOptionsPanel) {
        this.jdbcTimeoutField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.jdbcTimeoutField.setMinimumSize(new Dimension(50, 20));
        this.jdbcTimeoutField.setValue(new Integer(0));
        this.jdbcTimeoutLabel = new JLabel(this.getTranslatedString("DB_AO_JDBC_QUERY_TIMEOUT"));
        this.jdbcMaxRowsField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.jdbcMaxRowsField.setMinimumSize(new Dimension(50, 20));
        this.jdbcMaxRowsField.setValue(new Integer(0));
        this.jdbcMaxRowsLabel = new JLabel(this.getTranslatedString("DB_AO_JDBC_MAX_ROWS"));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(12, 0, 0, 12);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        jdbcOptionsPanel.add((Component)this.jdbcTimeoutLabel, constraints);
        constraints.anchor = 18;
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.insets = new Insets(12, 0, 0, 0);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.ipadx = 50;
        jdbcOptionsPanel.add((Component)this.jdbcTimeoutField, constraints);
        if (this.ascontext != null && (this.ascontext._isOutboundSelectOp || this.ascontext._isPureSQLOp)) {
            constraints.anchor = 18;
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.insets = new Insets(12, 0, 0, 12);
            constraints.fill = 0;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            jdbcOptionsPanel.add((Component)this.jdbcMaxRowsLabel, constraints);
            constraints.anchor = 18;
            constraints.gridx = 1;
            constraints.gridy = 1;
            constraints.insets = new Insets(12, 0, 0, 0);
            constraints.fill = 2;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.ipadx = 50;
            jdbcOptionsPanel.add((Component)this.jdbcMaxRowsField, constraints);
        }
    }

    private void initializeNativeSequencingPanel(JPanel nativeSequencingPanel) {
        this.sequencingTableComboBox = new JComboBox();
        this.sequencingTableComboBox.setEditable(false);
        this.sequencingTableComboBox.addActionListener(this);
        this.sequencingTableLabel = new JLabel(this.getTranslatedString("DB_AO_SEQUENCING_TABLE"));
        this.sequencingSequenceComboBox = new JComboBox();
        this.sequencingSequenceComboBox.setEditable(true);
        this.sequencingSequenceComboBox.setMinimumSize(new Dimension(300, 20));
        this.sequencingSequenceComboBox.setMaximumSize(new Dimension(300, 20));
        this.initSequencingInfo();
        this.sequencingSequenceLabel = new JLabel(this.getTranslatedString("DB_AO_SEQUENCING_SEQUENCE"));
        String sequencingSearchButtonString = this.getTranslatedString("DB_AO_SEQUENCING_SEARCH");
        this.sequencingSearchButton = new JButton(StringUtils.stripMnemonic((String)sequencingSearchButtonString));
        this.sequencingSearchButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)sequencingSearchButtonString));
        this.sequencingSearchButton.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)sequencingSearchButtonString));
        this.sequencingSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                XRAdapterAdvancedOptionsPage.this.searchForSequences();
            }
        });
        String sequencingCreateButtonString = this.getTranslatedString("DB_AO_SEQUENCING_CREATE");
        this.sequencingCreateButton = new JButton(StringUtils.stripMnemonic((String)sequencingCreateButtonString));
        this.sequencingCreateButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)sequencingCreateButtonString));
        this.sequencingCreateButton.setDisplayedMnemonicIndex(StringUtils.getMnemonicIndex((String)sequencingCreateButtonString));
        this.sequencingCreateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                XRAdapterAdvancedOptionsPage.this.createSequence();
            }
        });
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(12, 0, 0, 12);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        nativeSequencingPanel.add((Component)this.sequencingTableLabel, constraints);
        constraints.anchor = 18;
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.insets = new Insets(12, 0, 0, 0);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        nativeSequencingPanel.add((Component)this.sequencingTableComboBox, constraints);
        constraints.anchor = 18;
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.insets = new Insets(12, 0, 0, 12);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        nativeSequencingPanel.add((Component)this.sequencingSequenceLabel, constraints);
        constraints.anchor = 18;
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.insets = new Insets(12, 0, 0, 0);
        constraints.fill = 2;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.ipadx = 0;
        nativeSequencingPanel.add((Component)this.sequencingSequenceComboBox, constraints);
        constraints.anchor = 18;
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.insets = new Insets(12, 0, 0, 0);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.ipadx = 0;
        nativeSequencingPanel.add((Component)this.sequencingSearchButton, constraints);
        constraints.anchor = 18;
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.insets = new Insets(12, 0, 0, 0);
        constraints.fill = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.ipadx = 0;
        nativeSequencingPanel.add((Component)this.sequencingCreateButton, constraints);
    }

    private void initializeRetryPanel(JPanel retryPanel) {
        this.retryCountField = new JTextField();
        this.retryCountField.setMinimumSize(new Dimension(100, 20));
        if (this.m_wcontext._isInboundOperation) {
            this.retryCountField.setText("unlimited");
        } else {
            this.retryCountField.setText("4");
        }
        this.retryCountLabel = new JLabel(this.getTranslatedString("DB_AO_RETRY_COUNT"));
        this.retryIntervalField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.retryIntervalField.setMinimumSize(new Dimension(100, 20));
        this.retryIntervalField.setValue(new Integer(1));
        this.retryIntervalLabel = new JLabel(this.getTranslatedString("DB_AO_RETRY_INTERVAL"));
        this.retryBackoffField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.retryBackoffField.setMinimumSize(new Dimension(100, 20));
        this.retryBackoffField.setValue(new Integer(2));
        this.retryBackoffField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.retryBackoffFieldModified();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.retryBackoffFieldModified();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.retryBackoffFieldModified();
            }

            private void retryBackoffFieldModified() {
                XRAdapterAdvancedOptionsPage.this.retryMaxIntervalField.setEnabled(!"1".equals(XRAdapterAdvancedOptionsPage.this.retryBackoffField.getText()));
                XRAdapterAdvancedOptionsPage.this.retryMaxIntervalField.setEditable(!"1".equals(XRAdapterAdvancedOptionsPage.this.retryBackoffField.getText()));
            }
        });
        this.retryBackoffLabel = new JLabel(this.getTranslatedString("DB_AO_RETRY_BACKOFF"));
        this.retryMaxIntervalField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.retryMaxIntervalField.setMinimumSize(new Dimension(100, 20));
        this.retryMaxIntervalField.setValue(new Integer(120));
        this.retryMaxIntervalField.setEnabled(true);
        this.retryMaxIntervalLabel = new JLabel(this.getTranslatedString("DB_AO_RETRY_MAX_INTERVAL"));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 23;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(12, 0, 0, 12);
        constraints.fill = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.ipadx = 0;
        retryPanel.add((Component)this.retryCountLabel, constraints);
        constraints.anchor = 24;
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.ipadx = 50;
        retryPanel.add((Component)this.retryCountField, constraints);
        constraints.anchor = 21;
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.fill = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        retryPanel.add((Component)this.retryIntervalLabel, constraints);
        constraints.anchor = 22;
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.fill = 2;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        retryPanel.add((Component)this.retryIntervalField, constraints);
        constraints.anchor = 21;
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.fill = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        retryPanel.add((Component)this.retryBackoffLabel, constraints);
        constraints.anchor = 22;
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.fill = 2;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        retryPanel.add((Component)this.retryBackoffField, constraints);
        constraints.anchor = 21;
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.fill = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        retryPanel.add((Component)this.retryMaxIntervalLabel, constraints);
        constraints.anchor = 22;
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.fill = 2;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        retryPanel.add((Component)this.retryMaxIntervalField, constraints);
    }

    private void populateUIForEdit() {
        block26: {
            String maxRows;
            String queryTimeout;
            JcaOperation jop;
            block25: {
                RelationalDescriptor desc = null;
                JcaOperation anyOp = null;
                if (this.ascontext != null) {
                    desc = this.ascontext._rootDescriptor;
                    if (this.ascontext._operationPage != null) {
                        JcaOperation writeOp;
                        if (this.ascontext._outboundMergeOp != null && this.optimizeMergeCheckBox != null) {
                            this.optimizeMergeCheckBox.setSelected(Boolean.valueOf(this.ascontext._outboundMergeOp.getAttributeValue("OptimizeMerge")));
                        }
                        if ((writeOp = this.ascontext._outboundMergeOp) == null && (writeOp = this.ascontext._outboundInsertOp) == null) {
                            writeOp = this.ascontext._outboundUpdateOp;
                        }
                        if (writeOp != null && this.detectOmissionsCheckBox != null) {
                            this.detectOmissionsCheckBox.setSelected(Boolean.valueOf(writeOp.getAttributeValue("DetectOmissions")));
                        }
                        if ((anyOp = writeOp) == null && (anyOp = this.ascontext._outboundSelectOp) == null) {
                            anyOp = this.ascontext._outboundQueryByExampleOp;
                        }
                    }
                }
                if (desc != null) {
                    this.initialQueryTimeout = desc.getDescriptorQueryManager().getQueryTimeout();
                    if (this.initialQueryTimeout == -1) {
                        this.initialQueryTimeout = 0;
                    }
                    this.jdbcTimeoutField.setValue(new Integer(this.initialQueryTimeout));
                }
                if (this.ascontext != null && this.ascontext._isOutboundSelectOp && this.ascontext._query != null && this.ascontext._query.isReadQuery()) {
                    this.initialMaxRows = ((ReadQuery)this.ascontext._query).getMaxRows();
                    this.jdbcMaxRowsField.setValue(new Integer(this.initialMaxRows));
                }
                jop = this.m_wcontext._read_jca_operation;
                if (anyOp == null) {
                    anyOp = jop;
                }
                if (anyOp != null && this.getActiveUnitOfWorkCheckBox != null) {
                    this.getActiveUnitOfWorkCheckBox.setSelected(Boolean.valueOf(anyOp.getAttributeValue("GetActiveUnitOfWork")));
                }
                String interactionSpecType = jop.getAttributeValue("InteractionSpec");
                if ("oracle.tip.adapter.db.DBPureSQLInteractionSpec".equals(interactionSpecType)) break block25;
                if (!"oracle.tip.adapter.db.DBStoredProcedureInteractionSpec".equals(interactionSpecType)) break block26;
            }
            if ((queryTimeout = jop.getAttributeValue("QueryTimeout")) != null) {
                this.jdbcTimeoutField.setValue(new Integer(queryTimeout));
            }
            if ((maxRows = jop.getAttributeValue("MaxRows")) != null) {
                this.jdbcMaxRowsField.setValue(new Integer(maxRows));
            }
        }
        boolean basicPropertiesSet = false;
        SCAController scon = SCAControllerImpl.getController((Project)this.m_wcontext._project);
        PropertyInfo propInfo = scon.getCompositePropertyInfo(this.m_wcontext._composite_service_name, JCA_RETRY_INTERVAL_PROP);
        if (propInfo != null) {
            this.retryIntervalField.setText(propInfo.getValue());
            basicPropertiesSet = true;
        }
        if ((propInfo = scon.getCompositePropertyInfo(this.m_wcontext._composite_service_name, JCA_RETRY_COUNT_PROP)) != null) {
            this.retryCountField.setText(propInfo.getValue());
            if (Integer.valueOf(Integer.MAX_VALUE).toString().equals(this.retryCountField.getText()) || "-1".equals(this.retryCountField.getText())) {
                this.retryCountField.setText("unlimited");
            }
            basicPropertiesSet = true;
        }
        if ((propInfo = scon.getCompositePropertyInfo(this.m_wcontext._composite_service_name, JCA_RETRY_BACKOFF_PROP)) != null) {
            this.retryBackoffField.setText(propInfo.getValue());
        } else if (basicPropertiesSet) {
            this.retryBackoffField.setText("1");
        }
        propInfo = scon.getCompositePropertyInfo(this.m_wcontext._composite_service_name, JCA_RETRY_MAX_INTERVAL_PROP);
        if (propInfo != null) {
            this.retryMaxIntervalField.setText(propInfo.getValue());
        } else if (basicPropertiesSet) {
            this.retryMaxIntervalField.setText("");
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        SequencingTableListItem item;
        if (event.getSource() == this.retryBackoffField) {
            if (!"1".equals(this.retryBackoffField.getText())) {
                this.retryMaxIntervalField.setEnabled(true);
                this.retryMaxIntervalField.setEditable(true);
            } else {
                this.retryMaxIntervalField.setEnabled(false);
                this.retryMaxIntervalField.setEditable(false);
            }
        }
        if (event.getSource() == this.sequencingTableComboBox && (item = (SequencingTableListItem)this.sequencingTableComboBox.getSelectedItem()) != null) {
            item.gainFocus();
        }
    }

    private void advancedOptionValueCheck(String option) {
        MessageFormat msgFormat = new MessageFormat(this.getTranslatedString("DB_AO_VALUE_ERROR_MESSAGE"));
        Object[] obj = new Object[]{option};
        MultiLineOptionPane.showMessageDialog((Component)this.m_wcontext._parentFrame, (Object)msgFormat.format(obj), (String)this.getTranslatedString("DB_AO_VALUE_ERROR_TITLE"), (int)0);
    }

    @Override
    public void wizardValidatePage(WizardEvent event) {
        this.updateProjectWithSequencingInfo();
        String timeoutValue = this.jdbcTimeoutField.getText();
        int timeout = 0;
        try {
            timeout = Integer.parseInt(timeoutValue);
            if (timeout < 0) {
                this.advancedOptionValueCheck("Query Timeout");
                ((Cancelable)event).cancel();
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        String maxRowsValue = this.jdbcMaxRowsField.getText();
        int maxRows = 0;
        try {
            maxRows = Integer.parseInt(maxRowsValue);
            if (maxRows < 0) {
                this.advancedOptionValueCheck("Max Rows");
                ((Cancelable)event).cancel();
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (this.ascontext != null && this.ascontext._orProject != null && timeout != this.initialQueryTimeout) {
            org.eclipse.persistence.sessions.Project orProject = this.ascontext._orProject;
            for (ClassDescriptor desc : orProject.getDescriptors().values()) {
                desc.getDescriptorQueryManager().setQueryTimeout(timeout);
            }
        }
        if (this.ascontext != null && this.ascontext._query != null && this.ascontext._query.isReadQuery()) {
            ((ReadQuery)this.ascontext._query).setMaxRows(maxRows);
        }
    }

    @Override
    public void buildWSDL() throws WSDLException {
        block27: {
            JcaOperation jop;
            block29: {
                int maxRows;
                int timeout;
                block28: {
                    String timeoutValue = this.jdbcTimeoutField.getText();
                    timeout = 0;
                    try {
                        timeout = Integer.parseInt(timeoutValue);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    String maxRowsValue = this.jdbcMaxRowsField.getText();
                    maxRows = 0;
                    try {
                        maxRows = Integer.parseInt(maxRowsValue);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    jop = this.m_wcontext._write_jca_operation;
                    if (jop == null) break block27;
                    String interactionSpecType = jop.getAttributeValue("InteractionSpec");
                    if ("oracle.tip.adapter.db.DBPureSQLInteractionSpec".equals(interactionSpecType)) break block28;
                    if (!"oracle.tip.adapter.db.DBStoredProcedureInteractionSpec".equals(interactionSpecType)) break block29;
                }
                if (timeout != 0 || jop.getAttributeValue("QueryTimeout") != null) {
                    jop.setAttributeValue("QueryTimeout", String.valueOf(timeout));
                }
                if (maxRows != 0 || jop.getAttributeValue("MaxRows") != null) {
                    jop.setAttributeValue("MaxRows", String.valueOf(maxRows));
                }
            }
            if (this.getActiveUnitOfWorkCheckBox != null) {
                jop.setAttributeValue("GetActiveUnitOfWork", Boolean.toString(this.getActiveUnitOfWorkCheckBox.isSelected()));
            }
        }
        if (this.ascontext != null) {
            if (this.optimizeMergeCheckBox != null) {
                if (this.ascontext._outboundMergeOp != null) {
                    this.ascontext._outboundMergeOp.setAttributeValue("OptimizeMerge", Boolean.toString(this.optimizeMergeCheckBox.isSelected()));
                }
                if (this.ascontext._outboundInsertOp != null) {
                    this.ascontext._outboundInsertOp.setAttributeValue("OptimizeMerge", Boolean.toString(this.optimizeMergeCheckBox.isSelected()));
                }
                if (this.ascontext._outboundUpdateOp != null) {
                    this.ascontext._outboundUpdateOp.setAttributeValue("OptimizeMerge", Boolean.toString(this.optimizeMergeCheckBox.isSelected()));
                }
                if (this.ascontext._outboundDeleteOp != null) {
                    this.ascontext._outboundDeleteOp.setAttributeValue("OptimizeMerge", Boolean.toString(this.optimizeMergeCheckBox.isSelected()));
                }
            }
            if (this.detectOmissionsCheckBox != null) {
                if (this.ascontext._outboundMergeOp != null) {
                    this.ascontext._outboundMergeOp.setAttributeValue("DetectOmissions", Boolean.toString(this.detectOmissionsCheckBox.isSelected()));
                }
                if (this.ascontext._outboundInsertOp != null) {
                    this.ascontext._outboundInsertOp.setAttributeValue("DetectOmissions", Boolean.toString(this.detectOmissionsCheckBox.isSelected()));
                }
                if (this.ascontext._outboundUpdateOp != null) {
                    this.ascontext._outboundUpdateOp.setAttributeValue("DetectOmissions", Boolean.toString(this.detectOmissionsCheckBox.isSelected()));
                }
            }
            if (this.getActiveUnitOfWorkCheckBox != null) {
                if (this.ascontext._outboundMergeOp != null) {
                    this.ascontext._outboundMergeOp.setAttributeValue("GetActiveUnitOfWork", Boolean.toString(this.getActiveUnitOfWorkCheckBox.isSelected()));
                }
                if (this.ascontext._outboundInsertOp != null) {
                    this.ascontext._outboundInsertOp.setAttributeValue("GetActiveUnitOfWork", Boolean.toString(this.getActiveUnitOfWorkCheckBox.isSelected()));
                }
                if (this.ascontext._outboundUpdateOp != null) {
                    this.ascontext._outboundUpdateOp.setAttributeValue("GetActiveUnitOfWork", Boolean.toString(this.getActiveUnitOfWorkCheckBox.isSelected()));
                }
                if (this.ascontext._outboundDeleteOp != null) {
                    this.ascontext._outboundDeleteOp.setAttributeValue("GetActiveUnitOfWork", Boolean.toString(this.getActiveUnitOfWorkCheckBox.isSelected()));
                }
                if (this.ascontext._outboundSelectOp != null) {
                    this.ascontext._outboundSelectOp.setAttributeValue("GetActiveUnitOfWork", Boolean.toString(this.getActiveUnitOfWorkCheckBox.isSelected()));
                }
                if (this.ascontext._outboundQueryByExampleOp != null) {
                    this.ascontext._outboundQueryByExampleOp.setAttributeValue("GetActiveUnitOfWork", Boolean.toString(this.getActiveUnitOfWorkCheckBox.isSelected()));
                }
            }
        }
    }

    void initSequencingInfo() {
        DefaultComboBoxModel<SequencingTableListItem> model = new DefaultComboBoxModel<SequencingTableListItem>();
        RelationalDescriptor rootDescriptor = null;
        if (this.ascontext == null || this.ascontext._orProject == null) {
            return;
        }
        for (RelationalDescriptor desc : this.ascontext._orProject.getDescriptors().values()) {
            SequencingTableListItem modelItem = new SequencingTableListItem(desc);
            model.addElement(modelItem);
            if (!desc.getAlias().equals(this.ascontext._rootDescriptorAlias)) continue;
            rootDescriptor = desc;
            model.setSelectedItem(modelItem);
            modelItem.gainFocus();
        }
        this.sequencingTableComboBox.setModel(model);
    }

    boolean isOraclePlatform() {
        try {
            return this.m_wcontext._connection == null || this.m_wcontext._connection.getMetaData().getDatabaseProductName().toLowerCase().indexOf("oracle") > -1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void searchForSequences() {
        Vector<String> sequencesOnDatabase = new Vector<String>();
        Connection conn = this.m_wcontext._connection;
        Statement st = null;
        ResultSet result = null;
        try {
            st = conn.createStatement();
            result = st.executeQuery("SELECT SEQUENCE_NAME FROM SEQ");
            while (result.next()) {
                sequencesOnDatabase.add(result.getString(1));
            }
        }
        catch (SQLException sqle) {
        }
        finally {
            try {
                result.close();
                st.close();
            }
            catch (Exception ignore) {}
        }
        for (int i = 0; i < this.sequencingTableComboBox.getItemCount(); ++i) {
            SequencingTableListItem item = (SequencingTableListItem)this.sequencingTableComboBox.getItemAt(i);
            item.addSearchedSequences(sequencesOnDatabase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void createSequence() {
        String selectedSequence;
        block47: {
            selectedSequence = (String)this.sequencingSequenceComboBox.getSelectedItem();
            if (NONE_ELEMENT == selectedSequence) {
                JOptionPane.showMessageDialog(this.m_wcontext._parentFrame, this.getTranslatedString("DB_AO_SEQUENCING_NONE_WARNING"), this.getTranslatedString("DB_AO_SEQUENCING_CREATE_TITLE"), 0);
                return;
            }
            boolean sequenceExists = false;
            Connection conn = this.m_wcontext._connection;
            PreparedStatement st = null;
            ResultSet result = null;
            int incrementBy = 50;
            try {
                st = conn.prepareStatement("SELECT INCREMENT_BY FROM SEQ WHERE SEQUENCE_NAME = ?");
                st.setString(1, selectedSequence);
                result = st.executeQuery();
                if (result.next()) {
                    incrementBy = result.getInt(1);
                    sequenceExists = true;
                }
            }
            catch (SQLException sqle) {
                XRAdapterJDevUtil.showExceptionDialog(this.m_wcontext, sqle);
            }
            finally {
                try {
                    if (st != null) {
                        st.close();
                    }
                    if (result != null) {
                        result.close();
                    }
                }
                catch (Exception ignore) {}
            }
            String dropSQL = "DROP SEQ " + selectedSequence;
            String createSQL = "CREATE SEQUENCE " + selectedSequence + " INCREMENT BY 50 START WITH 50";
            String sqlScriptText = dropSQL + ";\n" + createSQL + ";\n";
            String confirmDialog = null;
            StringBuffer buffer = new StringBuffer();
            if (sequenceExists) {
                buffer.append(this.getTranslatedString("DB_AO_SEQUENCING_REPLACE_CONFIRM"));
                buffer.append(incrementBy);
                buffer.append(".\n");
                buffer.append(this.getTranslatedString("DB_AO_SEQUENCING_CREATE_CONFIRM"));
                buffer.append(sqlScriptText);
            } else {
                buffer.append(this.getTranslatedString("DB_AO_SEQUENCING_CREATE_CONFIRM"));
                buffer.append(createSQL);
            }
            confirmDialog = buffer.toString();
            int returnCode = JOptionPane.showConfirmDialog(this.m_wcontext._parentFrame, confirmDialog, this.getTranslatedString("DB_AO_SEQUENCING_CREATE_TITLE"), 0);
            if (returnCode != 0) {
                return;
            }
            try {
                if (sequenceExists) {
                    st = conn.prepareStatement(dropSQL);
                    st.executeUpdate();
                }
            }
            catch (SQLException ignoreDropFailed) {
            }
            finally {
                try {
                    if (st != null) {
                        st.close();
                    }
                }
                catch (Exception ignore) {}
            }
            st = conn.prepareStatement(createSQL);
            st.executeUpdate();
            try {
                if (st != null) {
                    st.close();
                }
                break block47;
            }
            catch (Exception ignore) {}
            break block47;
            catch (SQLException e) {
                try {
                    if (st != null) {
                        st.close();
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                return;
                catch (Throwable throwable) {
                    try {
                        if (st != null) {
                            st.close();
                        }
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        for (int i = 0; i < this.sequencingTableComboBox.getItemCount(); ++i) {
            SequencingTableListItem item = (SequencingTableListItem)this.sequencingTableComboBox.getItemAt(i);
            item.addNewlyCreatedSequence(selectedSequence);
        }
    }

    public void updateProjectWithSequencingInfo() {
        if (this.ascontext != null && this.ascontext._orProject != null && this.sequencingTableComboBox != null) {
            for (int i = 0; i < this.sequencingTableComboBox.getItemCount(); ++i) {
                SequencingTableListItem item = (SequencingTableListItem)this.sequencingTableComboBox.getItemAt(i);
                String sequence = item.getSelectedSequence();
                if (sequence != null) {
                    item.desc.setSequenceNumberName(item.getSelectedSequence());
                    item.desc.setSequenceNumberFieldName((String)item.desc.getPrimaryKeyFieldNames().get(0));
                    continue;
                }
                item.desc.setSequenceNumberName(null);
                item.desc.setSequenceNumberFieldName(null);
            }
        }
    }

    public void buildWSDLAfterFinish() {
        try {
            SCAController scon = SCAControllerImpl.getController((Project)this.m_wcontext._project);
            QName strQName = new QName("http://www.w3.org/2001/XMLSchema", "string");
            QName intQName = new QName("http://www.w3.org/2001/XMLSchema", "int");
            PropertyInfo propInfo = scon.getCompositePropertyInfo(this.m_wcontext._composite_service_name, JCA_RETRY_COUNT_PROP);
            if (propInfo == null) {
                propInfo = new PropertyInfo(JCA_RETRY_COUNT_PROP, intQName, false, null, PropertyInfo.OVERRIDE_MAY, null);
            } else {
                scon.deleteCompositeProperty(this.m_wcontext._composite_service_name, JCA_RETRY_COUNT_PROP);
            }
            if ("unlimited".equalsIgnoreCase(this.retryCountField.getText()) || "undefined".equalsIgnoreCase(this.retryCountField.getText()) || "indefinite".equalsIgnoreCase(this.retryCountField.getText())) {
                propInfo.setValue(Integer.valueOf(Integer.MAX_VALUE).toString());
            } else {
                propInfo.setValue(this.retryCountField.getText());
            }
            if (propInfo.getValue() != null && propInfo.getValue().length() > 0) {
                scon.addCompositeProperty(this.m_wcontext._composite_service_name, propInfo);
            }
            if ((propInfo = scon.getCompositePropertyInfo(this.m_wcontext._composite_service_name, JCA_RETRY_INTERVAL_PROP)) == null) {
                propInfo = new PropertyInfo(JCA_RETRY_INTERVAL_PROP, intQName, false, null, PropertyInfo.OVERRIDE_MAY, null);
            } else {
                scon.deleteCompositeProperty(this.m_wcontext._composite_service_name, JCA_RETRY_INTERVAL_PROP);
            }
            propInfo.setValue(this.retryIntervalField.getText());
            if (propInfo.getValue() != null && propInfo.getValue().length() > 0) {
                scon.addCompositeProperty(this.m_wcontext._composite_service_name, propInfo);
            }
            int retryBackoff = 0;
            try {
                retryBackoff = Integer.parseInt(this.retryBackoffField.getText());
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            propInfo = scon.getCompositePropertyInfo(this.m_wcontext._composite_service_name, JCA_RETRY_BACKOFF_PROP);
            if (propInfo == null && retryBackoff > 0) {
                propInfo = new PropertyInfo(JCA_RETRY_BACKOFF_PROP, intQName, false, null, PropertyInfo.OVERRIDE_MAY, null);
            } else {
                scon.deleteCompositeProperty(this.m_wcontext._composite_service_name, JCA_RETRY_BACKOFF_PROP);
            }
            if (retryBackoff > 0) {
                propInfo.setValue(this.retryBackoffField.getText());
                scon.addCompositeProperty(this.m_wcontext._composite_service_name, propInfo);
            }
            propInfo = scon.getCompositePropertyInfo(this.m_wcontext._composite_service_name, JCA_RETRY_MAX_INTERVAL_PROP);
            if (!this.retryMaxIntervalField.isEnabled()) {
                if (propInfo != null) {
                    scon.deleteCompositeProperty(this.m_wcontext._composite_service_name, JCA_RETRY_MAX_INTERVAL_PROP);
                }
            } else {
                if (propInfo == null) {
                    propInfo = new PropertyInfo(JCA_RETRY_MAX_INTERVAL_PROP, strQName, false, null, PropertyInfo.OVERRIDE_MAY, null);
                } else {
                    scon.deleteCompositeProperty(this.m_wcontext._composite_service_name, JCA_RETRY_MAX_INTERVAL_PROP);
                }
                propInfo.setValue(this.retryMaxIntervalField.getText());
                if (propInfo.getValue() != null && propInfo.getValue().length() > 0) {
                    scon.addCompositeProperty(this.m_wcontext._composite_service_name, propInfo);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class SequencingTableListItem {
        public RelationalDescriptor desc;
        DefaultComboBoxModel sequencesModel;

        public SequencingTableListItem(RelationalDescriptor descriptor) {
            this.desc = descriptor;
            this.sequencesModel = new DefaultComboBoxModel();
            if (NONE_ELEMENT == null) {
                NONE_ELEMENT = XRAdapterAdvancedOptionsPage.this.getTranslatedString("DB_AO_NONE");
            }
            if (this.desc.getSequenceNumberName() != null && this.desc.getSequenceNumberName().length() > 0) {
                this.sequencesModel.addElement(this.desc.getSequenceNumberName());
                this.sequencesModel.setSelectedItem(this.desc.getSequenceNumberName());
                this.sequencesModel.addElement(NONE_ELEMENT);
            } else {
                this.sequencesModel.addElement(NONE_ELEMENT);
                this.sequencesModel.setSelectedItem(NONE_ELEMENT);
            }
        }

        public void gainFocus() {
            XRAdapterAdvancedOptionsPage.this.sequencingSequenceComboBox.setModel(this.sequencesModel);
        }

        public void addSearchedSequences(Vector<String> searchedSequences) {
            int initialSize = this.sequencesModel.getSize();
            for (String searchedSequence : searchedSequences) {
                String upperSeq = searchedSequence.toUpperCase();
                boolean found = false;
                for (int i = 0; i < initialSize; ++i) {
                    String seq = (String)this.sequencesModel.getElementAt(i);
                    if (!seq.toUpperCase().equals(upperSeq)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.sequencesModel.addElement(searchedSequence);
            }
        }

        public void addNewlyCreatedSequence(String sequenceName) {
            String upperSeq = sequenceName.toUpperCase();
            for (int i = 0; i < this.sequencesModel.getSize(); ++i) {
                String seq = (String)this.sequencesModel.getElementAt(i);
                if (!seq.toUpperCase().equals(upperSeq)) continue;
                return;
            }
            this.sequencesModel.addElement(sequenceName);
        }

        public String getSelectedSequence() {
            String selected = (String)this.sequencesModel.getSelectedItem();
            if (selected == NONE_ELEMENT) {
                return null;
            }
            return selected;
        }

        public String toString() {
            return this.desc.getAlias();
        }
    }
}

