/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl;

import java.awt.Component;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.Wizard;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.integration.platform.blocks.adapter.fw.metadata.migration.JcaMigrationHelper;
import oracle.integration.platform.blocks.adapter.fw.metadata.migration.JcaMigrationResult;
import oracle.integration.platform.blocks.adapter.fw.metadata.migration.JcaParsedResult;
import oracle.j2ee.ws.wsdl.extensions.schema.Constants;
import oracle.tip.tools.ide.common.utils.BPELWSDLNode;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.fabric.addin.SCAProject;
import oracle.tip.tools.ide.fabric.api.BindingInfo;
import oracle.tip.tools.ide.fabric.api.BindingInfoB2B;
import oracle.tip.tools.ide.fabric.api.BindingInfoJCA;
import oracle.tip.tools.ide.fabric.api.BindingInfoWS;
import oracle.tip.tools.ide.fabric.api.InterfaceInfo;
import oracle.tip.tools.ide.fabric.api.PropertyInfo;
import oracle.tip.tools.ide.fabric.api.SCAController;
import oracle.tip.tools.ide.fabric.api.SCAControllerImpl;
import oracle.tip.tools.ide.fabric.api.WsdlInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.CommonSchemaPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.ServiceNamePage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.ServiceTypePage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b.B2BContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b.B2BWSDLComponents;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.b2b.B2BWSDLGenerator;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.file.FileAdapterContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.file.FileAdapterSchemaPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.http.HttpAdapterContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.mq.MQAdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.AdapterWsdlInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.B2BUIExtensions;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaAddress;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaBinding;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.JcaOperation;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.PCInboundBinding;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.PartnerLinkType;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.WizardWSDLFactory;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class WizardWSDLUtil {
    public static final String WSDL_CHARSET = "UTF-8";
    public static final String WSDL_FINAL = ".wsdl";
    public static final int INVALID_WSDL = -1;
    private static final String EDIT_MODE = "EDIT_MODE";
    private static final String CREATE_MODE = "CREATE_MODE";
    private static AdapterWizardContext m_wcontext;
    private WSDLFactory m_write_factory = null;
    private WizardWSDLFactory m_extention_factory = null;
    private boolean m_isDBadapter = false;
    private static boolean m_bInit;
    private static WSDLFactory s_wsdlFactory;
    private static final Boolean m_lock;

    public WizardWSDLUtil(AdapterWizardContext _wcontext) {
        m_wcontext = _wcontext;
    }

    public final int initWSDL() throws WSDLException {
        block6: {
            try {
                this.m_write_factory = WizardWSDLUtil.createWSDLFactory();
                this.m_extention_factory = new WizardWSDLFactory();
                if (WizardWSDLUtil.m_wcontext._update_wsdl_path == null) break block6;
                Definition def = null;
                FileInputStream binding = null;
                def = this.readWSDL(WizardWSDLUtil.m_wcontext._update_wsdl_path);
                Definition tmpAdapterDef = this.readWSDLFromMemory(def, EDIT_MODE, URLFactory.newURL((String)WizardWSDLUtil.m_wcontext._update_wsdl_path));
                String jcaFilePath = WizardWSDLUtil.getJCAFilePath(m_wcontext.getFilePath(), WizardWSDLUtil.m_wcontext._update_wsdl_path);
                if (jcaFilePath == null) {
                    return this.initAdapterWSDLNoJca(tmpAdapterDef);
                }
                if (jcaFilePath == null) {
                    MessageFormat msgformat = new MessageFormat(WizardWSDLUtil.m_wcontext._bundle.getString("CM_WZ_JCA_NO_REF_MSG"));
                    Object[] obj = new Object[]{WizardWSDLUtil.m_wcontext._update_wsdl_path};
                    String msg = msgformat.format(obj);
                    throw new WSDLException("OTHER_ERROR", msg);
                }
                try {
                    binding = new FileInputStream(jcaFilePath);
                }
                catch (Exception e) {
                    throw new WSDLException("OTHER_ERROR", e.getMessage());
                }
                JcaMigrationHelper helper = new JcaMigrationHelper();
                JcaParsedResult parsed = helper.parse(tmpAdapterDef, (InputStream)binding);
                Definition tempDef = parsed.getDefinition();
                Definition oldAdapterDef = this.readWSDLFromMemory(tempDef, EDIT_MODE, URLFactory.newURL((String)WizardWSDLUtil.m_wcontext._update_wsdl_path));
                return this.initAdapterWSDLContext(parsed, oldAdapterDef);
            }
            catch (Exception e) {
                e.printStackTrace();
                MessageFormat msgformat = new MessageFormat(WizardWSDLUtil.m_wcontext._bundle.getString("CM_WZ_WSDL_READ_ERROR_MSG"));
                Object[] obj = new Object[]{WizardWSDLUtil.m_wcontext._update_wsdl_path, e.getLocalizedMessage()};
                MultiLineOptionPane.showMessageDialog((Component)WizardWSDLUtil.m_wcontext._parentFrame, (Object)msgformat.format(obj), (String)WizardWSDLUtil.m_wcontext._bundle.getString("CM_WZ_WSDL_READ_ERROR_TITLE"), (int)0);
                throw new WSDLException("OTHER_ERROR", e.getMessage());
            }
        }
        return 0;
    }

    private int initAdapterWSDLContext(JcaParsedResult parsedResult, Definition def) throws Exception {
        block22: {
            try {
                this.m_write_factory = WizardWSDLUtil.createWSDLFactory();
                this.m_extention_factory = new WizardWSDLFactory();
                if (def != null) {
                    Map bindings;
                    Iterator bindingI;
                    Map services;
                    WizardWSDLUtil.m_wcontext._read_definition = def;
                    WizardWSDLUtil.m_wcontext._target_namespace = def.getTargetNamespace();
                    Element docElem = def.getDocumentationElement();
                    if (docElem != null) {
                        Text document_text = (Text)docElem.getFirstChild();
                        WizardWSDLUtil.m_wcontext._read_service_documentation = document_text.getData();
                    }
                    if ((services = def.getServices()) == null || services.size() == 0) {
                        this.showInvalidWSDL("<services>");
                        return -1;
                    }
                    Iterator servI = services.values().iterator();
                    if (servI.hasNext()) {
                        Service serv1;
                        WizardWSDLUtil.m_wcontext._read_service = serv1 = (Service)servI.next();
                        WizardWSDLUtil.m_wcontext._read_service_name = serv1.getQName().getLocalPart();
                        Map ports = serv1.getPorts();
                        block2: for (Port port1 : ports.values()) {
                            List pext = port1.getExtensibilityElements();
                            for (Object extobj : pext) {
                                if (!(extobj instanceof JcaAddress)) continue;
                                WizardWSDLUtil.m_wcontext._read_jca_address = (JcaAddress)extobj;
                                continue block2;
                            }
                        }
                        if (WizardWSDLUtil.m_wcontext._read_jca_address == null) {
                            this.showInvalidWSDL("<jca:address>");
                            return -1;
                        }
                    }
                    PortType portt = def.getPortType(parsedResult.getPortType());
                    List operations = portt.getOperations();
                    for (Operation tempOp : operations) {
                        if (!tempOp.getName().equals(parsedResult.getOperationName())) continue;
                        WizardWSDLUtil.m_wcontext._read_operation = tempOp;
                        WizardWSDLUtil.m_wcontext._read_operation_name = parsedResult.getOperationName();
                        List extElements = tempOp.getExtensibilityElements();
                        for (Object obj1 : extElements) {
                            if (!(obj1 instanceof B2BUIExtensions)) continue;
                            WizardWSDLUtil.m_wcontext._read_b2b_uiext = (B2BUIExtensions)obj1;
                        }
                    }
                    if (WizardWSDLUtil.m_wcontext._read_operation == null) {
                        this.showInvalidWSDL("<operation>");
                        return -1;
                    }
                    Map impL = def.getImports();
                    for (List implist : impL.values()) {
                        for (Import imp : implist) {
                            String impNS = imp.getNamespaceURI();
                            if (!impNS.equals(portt.getQName().getNamespaceURI())) continue;
                            WizardWSDLUtil.m_wcontext._importedWsdlInfo = new WsdlInfo(imp.getLocationURI(), portt.getQName(), parsedResult.getCallbackPortType());
                        }
                    }
                    WizardWSDLUtil.m_wcontext._write_operation_name = parsedResult.getOperationName();
                    if (parsedResult.getCallbackOperationName() != null) {
                        WizardWSDLUtil.m_wcontext._write_operation2_name = parsedResult.getCallbackOperationName();
                    }
                    if ((bindingI = (bindings = WizardWSDLUtil.m_wcontext._read_definition.getBindings()).values().iterator()).hasNext()) {
                        Binding bind1 = (Binding)bindingI.next();
                        List extElements = bind1.getExtensibilityElements();
                        WizardWSDLUtil.m_wcontext._isInboundOperation = extElements.size() > 0 && extElements.get(0) instanceof PCInboundBinding;
                        List boperations = bind1.getBindingOperations();
                        for (BindingOperation bop1 : boperations) {
                            List bextElements = bop1.getExtensibilityElements();
                            for (Object obj1 : bextElements) {
                                if (!(obj1 instanceof JcaOperation)) continue;
                                WizardWSDLUtil.m_wcontext._read_jca_operation = (JcaOperation)obj1;
                            }
                        }
                        if (WizardWSDLUtil.m_wcontext._read_jca_operation == null) {
                            this.showInvalidWSDL("<jca:operation>");
                            return -1;
                        }
                        String interspec = WizardWSDLUtil.m_wcontext._read_jca_operation.getAttributeValue("InteractionSpec");
                        if (interspec == null) {
                            interspec = WizardWSDLUtil.m_wcontext._read_jca_operation.getAttributeValue("ActivationSpec");
                        }
                        if (interspec == null) {
                            throw new WSDLException("INVALID_WSDL", WizardWSDLUtil.m_wcontext._bundle.getString("CM_WZ_WSDL_NO_INTERSPEC_ERROR"));
                        }
                        this.m_isDBadapter = AdapterWizardContext.setAdapterType(m_wcontext, interspec);
                        if (WizardWSDLUtil.m_wcontext._service_type == null) {
                            MessageFormat msgformat = new MessageFormat(WizardWSDLUtil.m_wcontext._bundle.getString("CM_WZ_WSDL_INTERSPEC_INVALID_ERROR"));
                            Object[] obj = new Object[]{interspec};
                            throw new WSDLException("INVALID_WSDL", msgformat.format(obj));
                        }
                    }
                    break block22;
                }
                return -1;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        return 0;
    }

    private int initAdapterWSDLNoJca(Definition def) throws Exception {
        block15: {
            try {
                WizardWSDLUtil.parseNoJcaDefinition(def);
                this.m_write_factory = WizardWSDLUtil.createWSDLFactory();
                this.m_extention_factory = new WizardWSDLFactory();
                if (def != null) {
                    List operations;
                    Iterator operI;
                    Map services;
                    WizardWSDLUtil.m_wcontext._read_definition = def;
                    WizardWSDLUtil.m_wcontext._target_namespace = def.getTargetNamespace();
                    Element docElem = def.getDocumentationElement();
                    if (docElem != null) {
                        Text document_text = (Text)docElem.getFirstChild();
                        WizardWSDLUtil.m_wcontext._read_service_documentation = document_text.getData();
                    }
                    if ((services = def.getServices()) == null || services.size() == 0) {
                        this.showInvalidWSDL("<services>");
                        return -1;
                    }
                    Iterator servI = services.values().iterator();
                    if (servI.hasNext()) {
                        Service serv1;
                        WizardWSDLUtil.m_wcontext._read_service = serv1 = (Service)servI.next();
                        WizardWSDLUtil.m_wcontext._read_service_name = serv1.getQName().getLocalPart();
                    }
                    Map portTypes = WizardWSDLUtil.m_wcontext._read_definition.getPortTypes();
                    Iterator porttI = portTypes.values().iterator();
                    PortType portt = null;
                    if (porttI.hasNext() && (operI = (operations = (portt = (PortType)porttI.next()).getOperations()).iterator()).hasNext()) {
                        Operation op1;
                        WizardWSDLUtil.m_wcontext._read_operation = op1 = (Operation)operI.next();
                        WizardWSDLUtil.m_wcontext._read_operation_name = WizardWSDLUtil.m_wcontext._read_operation.getName();
                        List extElements = op1.getExtensibilityElements();
                        for (Object obj1 : extElements) {
                            if (!(obj1 instanceof B2BUIExtensions)) continue;
                            WizardWSDLUtil.m_wcontext._read_b2b_uiext = (B2BUIExtensions)obj1;
                            if (WizardWSDLUtil.m_wcontext._read_operation_name.equals("send")) {
                                WizardWSDLUtil.m_wcontext._isInboundOperation = false;
                                continue;
                            }
                            WizardWSDLUtil.m_wcontext._isInboundOperation = true;
                        }
                    }
                    Map impL = def.getImports();
                    for (List implist : impL.values()) {
                        for (Import imp : implist) {
                            String impNS = imp.getNamespaceURI();
                            if (!impNS.equals(portt.getQName().getNamespaceURI())) continue;
                            WizardWSDLUtil.m_wcontext._importedWsdlInfo = new WsdlInfo(imp.getLocationURI(), portt.getQName(), null);
                        }
                    }
                    if (WizardWSDLUtil.m_wcontext._read_operation == null) {
                        this.showInvalidWSDL("<operation>");
                        return -1;
                    }
                    SCAController scon = SCAControllerImpl.getController((Project)WizardWSDLUtil.m_wcontext._project);
                    List bindingList = scon.getEndpointBindingInfo(WizardWSDLUtil.m_wcontext._read_service_name);
                    if (bindingList.get(0) instanceof BindingInfoWS) {
                        BindingInfoWS bindingInfo = (BindingInfoWS)bindingList.get(0);
                        if (bindingInfo.getSupportType().equals("http")) {
                            WizardWSDLUtil.m_wcontext._service_type = "Http";
                            WizardWSDLUtil.m_wcontext._adapter_type_icon = ServiceTypePage.httpImage;
                        }
                    } else {
                        this.m_isDBadapter = AdapterWizardContext.setAdapterType(m_wcontext, null);
                    }
                    break block15;
                }
                return -1;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        return 0;
    }

    private static String getJCAFilePath(String jcaDir, String wsdlFilePath) throws Exception {
        String TARGET = "binding.jca";
        String jcaFilePath = null;
        String piValue = SCAControllerImpl.getWsdlProcessingInstruction((String)wsdlFilePath);
        if (piValue != null) {
            String jcaFilename = piValue.trim();
            jcaFilePath = jcaFilename != null && !jcaFilename.equals("") && jcaDir != null && !jcaDir.trim().equals("") ? jcaDir + File.separator + jcaFilename : jcaFilename;
        }
        return jcaFilePath;
    }

    private void showInvalidWSDL(String missing_tag) {
        String temp_str = FileAdapterSchemaPage.string_replaceAll(WizardWSDLUtil.m_wcontext._update_wsdl_path, '/', '\\');
        String wsdl_str = temp_str.substring(temp_str.lastIndexOf("\\") + 1);
        MessageFormat msgformat = new MessageFormat(WizardWSDLUtil.m_wcontext._bundle.getString("CM_WZ_INVALID_WSDL_FOR_UPDATE"));
        Object[] obj = new Object[]{wsdl_str, missing_tag};
        MultiLineOptionPane.showMessageDialog((Component)WizardWSDLUtil.m_wcontext._parentFrame, (Object)msgformat.format(obj), (String)WizardWSDLUtil.m_wcontext._bundle.getString("CM_WZ_INVALID_WSDL_FOR_UPDATE_TITLE"), (int)3);
    }

    public final void createWSDL() throws Exception {
        WizardWSDLUtil.m_wcontext._write_definition = this.m_write_factory.newDefinition();
        WizardWSDLUtil.m_wcontext._write_definition.setExtensionRegistry(this.m_extention_factory.newPopulatedExtensionRegistry());
        WizardWSDLUtil.m_wcontext._extReg = WizardWSDLUtil.m_wcontext._write_definition.getExtensionRegistry();
        try {
            Definition def1 = WizardWSDLUtil.m_wcontext._write_definition;
            def1.setTargetNamespace(WizardWSDLUtil.m_wcontext._target_namespace);
            def1.addNamespace("tns", WizardWSDLUtil.m_wcontext._target_namespace);
            def1.setQName(new QName(WizardWSDLUtil.m_wcontext._target_namespace, WizardWSDLUtil.m_wcontext._write_service_name));
            def1.addNamespace(JcaAddress.JCA_NAMESPACE, JcaAddress.JCA_NAMESPACE_URI);
            def1.addNamespace(PartnerLinkType.PLT_NAMESPACE, PartnerLinkType.PLT_NAMESPACE_URI);
            if (WizardWSDLUtil.m_wcontext._isInboundOperation) {
                def1.addNamespace(AdapterWizardContext.PC_NAMESPACE, AdapterWizardContext.PC_NAMESPACE_URI);
            }
            Wizard _wiz = WizardWSDLUtil.m_wcontext._wizard;
            int pagecnt = _wiz.getPageCount();
            for (int pagenum = 0; pagenum < pagecnt; ++pagenum) {
                ImageWizardPage iwizpag = (ImageWizardPage)_wiz.getPageAt(pagenum);
                Component com1 = iwizpag.getInteractiveArea();
                if (!(com1 instanceof techAdapterWizardPage)) continue;
                techAdapterWizardPage tawizpag = (techAdapterWizardPage)com1;
                tawizpag.buildWSDL();
            }
            this.writeUnknownJcaOperationAttributes();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public void writeUnknownJcaOperationAttributes() {
        block7: {
            block6: {
                if (this.m_isDBadapter) break block6;
                if (WizardWSDLUtil.m_wcontext._service_type == null) break block7;
                if (WizardWSDLUtil.m_wcontext._service_type.equals("MQ")) break block6;
                if (!WizardWSDLUtil.m_wcontext._service_type.equals("Http")) break block7;
            }
            return;
        }
        if (WizardWSDLUtil.m_wcontext._read_service == null) {
            return;
        }
        if (WizardWSDLUtil.m_wcontext._write_jca_operation != null) {
            Hashtable unread = WizardWSDLUtil.m_wcontext._read_jca_operation.getUnreadAttributes();
            Enumeration keys = unread.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = (String)unread.get(key);
                WizardWSDLUtil.m_wcontext._write_jca_operation.setAttributeValue(key, value);
            }
        }
    }

    public void saveWSDLFile() {
        try {
            WizardWSDLUtil.m_wcontext._wsdlFileURL = URLFactory.newURL((String)WizardWSDLUtil.m_wcontext._write_wsdl_name);
            String wsdlFilename = WizardWSDLUtil.m_wcontext._wsdlFileURL.getFile();
            String wsdlFileShortName = new File(wsdlFilename).getName();
            JcaMigrationHelper helper = new JcaMigrationHelper();
            Definition defFromMemory = this.readWSDLFromMemory(WizardWSDLUtil.m_wcontext._write_definition, CREATE_MODE, WizardWSDLUtil.m_wcontext._wsdlFileURL);
            JcaMigrationResult[] result = helper.migrate(defFromMemory);
            String jcaFileShortName = result[0].getJcaBindingFileName();
            String jcaFilename = m_wcontext.getFilePath() + File.separator + jcaFileShortName;
            QName portTypeQName = result[0].getPortType();
            QName callBackPortTypeQName = result[0].getCallbackPortType();
            WizardWSDLUtil.writeFile(wsdlFilename, result[0].getSerializedDefinition());
            WizardWSDLUtil.writeFile(jcaFilename, result[0].getSerializedJcaBinding());
            if (WizardWSDLUtil.m_wcontext._project != null) {
                Node wsdlNode = NodeFactory.findOrCreate(BPELWSDLNode.class, (URL)WizardWSDLUtil.m_wcontext._wsdlFileURL);
                URL jcaFileURL = URLFactory.newURL((String)jcaFilename);
                Node jcaNode = NodeFactory.findOrCreate(XMLSourceNode.class, (URL)jcaFileURL);
                m_wcontext.addURL(WizardWSDLUtil.m_wcontext._wsdlFileURL);
                m_wcontext.addURL(jcaFileURL);
                SCAProject.registerNode((Project)WizardWSDLUtil.m_wcontext._project, (Node)wsdlNode);
                SCAProject.registerNode((Project)WizardWSDLUtil.m_wcontext._project, (Node)jcaNode);
                if (SCAProject.isSCAProject((Project)WizardWSDLUtil.m_wcontext._project)) {
                    SCAController scon = SCAControllerImpl.getController((Project)WizardWSDLUtil.m_wcontext._project);
                    Object scaName = null;
                    WsdlInfo wsdlInfo = new WsdlInfo(wsdlFileShortName, portTypeQName, callBackPortTypeQName);
                    if (WizardWSDLUtil.m_wcontext._service_type.equals("MQ")) {
                        MQAdapterWizardContext mqCtx = (MQAdapterWizardContext)WizardWSDLUtil.m_wcontext._ascontext;
                        if (mqCtx.operationType.equals("Solicit-response") && mqCtx.serviceType.equals("Asynchronous")) {
                            wsdlInfo = new WsdlInfo(wsdlFileShortName, callBackPortTypeQName, portTypeQName);
                        }
                    }
                    BindingInfoJCA bindingInfo = new BindingInfoJCA("jca", (QName)null, jcaFileShortName);
                    if (WizardWSDLUtil.m_wcontext._isInboundOperation) {
                        if (WizardWSDLUtil.m_wcontext._read_service == null) {
                            WizardWSDLUtil.m_wcontext._scaName = scon.addServiceEntrypoint(null, WizardWSDLUtil.m_wcontext._composite_service_name, (InterfaceInfo)wsdlInfo, (BindingInfo)bindingInfo);
                        } else {
                            scon.updateServiceEntrypoint(WizardWSDLUtil.m_wcontext._composite_service_name, WizardWSDLUtil.m_wcontext._composite_service_name, (InterfaceInfo)wsdlInfo);
                        }
                    } else if (WizardWSDLUtil.m_wcontext._read_service == null) {
                        WizardWSDLUtil.m_wcontext._scaName = scon.addExternalReference(WizardWSDLUtil.m_wcontext._composite_service_name, (InterfaceInfo)wsdlInfo, (BindingInfo)bindingInfo);
                    } else {
                        ArrayList<BindingInfoJCA> bindingList = new ArrayList<BindingInfoJCA>();
                        bindingList.add(bindingInfo);
                        scon.updateExternalReference(WizardWSDLUtil.m_wcontext._composite_service_name, WizardWSDLUtil.m_wcontext._composite_service_name, (InterfaceInfo)wsdlInfo, bindingList);
                    }
                    AdapterWsdlInfo awi = WizardWSDLUtil.getAdapterWsdlInfo(m_wcontext);
                    if (awi != null) {
                        Hashtable logicalNames;
                        Hashtable oldLogicalNames = awi._logicalNames_old;
                        if (oldLogicalNames != null) {
                            Enumeration properties = oldLogicalNames.keys();
                            while (properties.hasMoreElements()) {
                                String prop = (String)properties.nextElement();
                                String value = (String)oldLogicalNames.get(prop);
                                scon.deleteCompositeProperty(WizardWSDLUtil.m_wcontext._composite_service_name, value);
                            }
                        }
                        if ((logicalNames = awi._logicalNames) != null) {
                            Enumeration properties = logicalNames.keys();
                            while (properties.hasMoreElements()) {
                                String prop = (String)properties.nextElement();
                                String value = (String)logicalNames.get(prop);
                                QName strQName = new QName("http://www.w3.org/2001/XMLSchema", "string");
                                PropertyInfo propInfo = new PropertyInfo(prop, strQName, false, null, PropertyInfo.OVERRIDE_MAY, value);
                                scon.addCompositeProperty(WizardWSDLUtil.m_wcontext._composite_service_name, propInfo);
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageFormat msgformat = new MessageFormat(WizardWSDLUtil.m_wcontext._bundle.getString("CM_WZ_WSDL_WRITE_ERROR_MSG"));
            Object[] obj = new Object[]{WizardWSDLUtil.m_wcontext._write_wsdl_name, e.getLocalizedMessage()};
            MultiLineOptionPane.showMessageDialog((Component)WizardWSDLUtil.m_wcontext._parentFrame, (Object)msgformat.format(obj), (String)WizardWSDLUtil.m_wcontext._bundle.getString("CM_WZ_WSDL_WRITE_ERROR_TITLE"), (int)0);
        }
    }

    public void saveHttpBindingWSDLFile() {
        try {
            WizardWSDLUtil.m_wcontext._wsdlFileURL = URLFactory.newURL((String)WizardWSDLUtil.m_wcontext._write_wsdl_name);
            String wsdlFilename = WizardWSDLUtil.m_wcontext._wsdlFileURL.getFile();
            String wsdlFileShortName = new File(wsdlFilename).getName();
            JcaMigrationHelper helper = new JcaMigrationHelper();
            Definition defFromMemory = this.readWSDLFromMemory(WizardWSDLUtil.m_wcontext._write_definition, CREATE_MODE, WizardWSDLUtil.m_wcontext._wsdlFileURL);
            JcaMigrationResult[] result = helper.migrate(defFromMemory);
            QName portTypeQName = result[0].getPortType();
            Definition wsdldef = result[0].getDefinition();
            String wsdlFacImpl = "oracle.j2ee.ws.wsdl.factory.WSDLFactoryImpl";
            WSDLFactory fac = WSDLFactory.newInstance((String)wsdlFacImpl);
            WSDLWriter writer = fac.newWSDLWriter();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            writer.writeWSDL(wsdldef, (OutputStream)baos);
            WizardWSDLUtil.writeFile(wsdlFilename, baos.toString(WSDL_CHARSET));
            if (WizardWSDLUtil.m_wcontext._project != null) {
                Node wsdlNode = NodeFactory.findOrCreate(BPELWSDLNode.class, (URL)WizardWSDLUtil.m_wcontext._wsdlFileURL);
                m_wcontext.addURL(WizardWSDLUtil.m_wcontext._wsdlFileURL);
                SCAProject.registerNode((Project)WizardWSDLUtil.m_wcontext._project, (Node)wsdlNode);
                if (SCAProject.isSCAProject((Project)WizardWSDLUtil.m_wcontext._project)) {
                    SCAController scon = SCAControllerImpl.getController((Project)WizardWSDLUtil.m_wcontext._project);
                    Object scaName = null;
                    WsdlInfo wsdlInfo = new WsdlInfo(wsdlFileShortName, portTypeQName, null);
                    QName serviceQName = new QName(WizardWSDLUtil.m_wcontext._target_namespace, WizardWSDLUtil.m_wcontext._write_service_name);
                    String portName = ServiceNamePage.getCleanName(WizardWSDLUtil.m_wcontext._write_operation_name) + WizardWSDLUtil.m_wcontext.Port_suffix;
                    BindingInfoWS bindingInfo = new BindingInfoWS("ws", portName, serviceQName, wsdlFileShortName, "http");
                    if (WizardWSDLUtil.m_wcontext._isInboundOperation) {
                        if (WizardWSDLUtil.m_wcontext._read_service == null) {
                            WizardWSDLUtil.m_wcontext._scaName = scon.addServiceEntrypoint(null, WizardWSDLUtil.m_wcontext._composite_service_name, (InterfaceInfo)wsdlInfo, (BindingInfo)bindingInfo);
                        } else {
                            scon.updateServiceEntrypoint(WizardWSDLUtil.m_wcontext._composite_service_name, WizardWSDLUtil.m_wcontext._composite_service_name, (InterfaceInfo)wsdlInfo);
                        }
                    } else if (WizardWSDLUtil.m_wcontext._read_service == null) {
                        WizardWSDLUtil.m_wcontext._scaName = scon.addExternalReference(WizardWSDLUtil.m_wcontext._composite_service_name, (InterfaceInfo)wsdlInfo, (BindingInfo)bindingInfo);
                    } else {
                        ArrayList<BindingInfoWS> bindingList = new ArrayList<BindingInfoWS>();
                        bindingList.add(bindingInfo);
                        scon.updateExternalReference(WizardWSDLUtil.m_wcontext._composite_service_name, WizardWSDLUtil.m_wcontext._composite_service_name, (InterfaceInfo)wsdlInfo, bindingList);
                    }
                    HttpAdapterContext httpCtx = (HttpAdapterContext)WizardWSDLUtil.m_wcontext._ascontext;
                    PropertyInfo propInfo = new PropertyInfo();
                    propInfo.setName("http.verb");
                    if (httpCtx._isGet) {
                        propInfo.setValue("GET");
                    } else {
                        propInfo.setValue("POST");
                    }
                    scon.addBindingProperty(WizardWSDLUtil.m_wcontext._composite_service_name, (BindingInfo)bindingInfo, propInfo);
                    if (!WizardWSDLUtil.m_wcontext._isInboundOperation) {
                        propInfo.setName("endpointURI");
                        propInfo.setValue(httpCtx._endpoint);
                        scon.addBindingProperty(WizardWSDLUtil.m_wcontext._composite_service_name, (BindingInfo)bindingInfo, propInfo);
                    }
                    propInfo.setName("http.payload");
                    propInfo.setValue(httpCtx._payloadType);
                    scon.addBindingProperty(WizardWSDLUtil.m_wcontext._composite_service_name, (BindingInfo)bindingInfo, propInfo);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageFormat msgformat = new MessageFormat(WizardWSDLUtil.m_wcontext._bundle.getString("CM_WZ_WSDL_WRITE_ERROR_MSG"));
            Object[] obj = new Object[]{WizardWSDLUtil.m_wcontext._write_wsdl_name, e.getLocalizedMessage()};
            MultiLineOptionPane.showMessageDialog((Component)WizardWSDLUtil.m_wcontext._parentFrame, (Object)msgformat.format(obj), (String)WizardWSDLUtil.m_wcontext._bundle.getString("CM_WZ_WSDL_WRITE_ERROR_TITLE"), (int)0);
        }
    }

    public static AdapterWsdlInfo getAdapterWsdlInfoNoJca(AdapterWizardContext mcontext) throws Exception, WSDLException {
        String rolePortName2;
        Object exelem1;
        WSDLFactory wfact = WizardWSDLUtil.createWSDLFactory();
        Definition def1 = mcontext._write_definition;
        if (def1 == null) {
            def1 = WizardWSDLUtil.readAdapterWsdl(wfact, mcontext._wsdlFileURL);
        }
        WizardWSDLUtil.parseNoJcaDefinition(def1);
        AdapterWizardContext temp_context = mcontext;
        if (mcontext == null) {
            temp_context = new AdapterWizardContext();
        }
        boolean isInbound = mcontext._isInboundOperation;
        String requestPorttypeName = null;
        Object callbackPorttypeName = null;
        Iterator porttI = def1.getPortTypes().values().iterator();
        if (porttI.hasNext()) {
            requestPorttypeName = ((PortType)porttI.next()).getQName().getLocalPart();
        }
        PartnerLinkType plt = null;
        List extensibilityElements = def1.getExtensibilityElements();
        for (int i = 0; !(i >= extensibilityElements.size() || (exelem1 = extensibilityElements.get(i)) instanceof PartnerLinkType && ((plt = (PartnerLinkType)exelem1).getPortName().equals(requestPorttypeName) || (rolePortName2 = plt.getPortName2()) != null && rolePortName2.equals(requestPorttypeName))); ++i) {
        }
        if (plt == null) {
            return null;
        }
        String temp_my_role_name = null;
        String temp_my_portType_name = null;
        String temp_partner_role_name = null;
        String temp_partner_portType_name = null;
        if (isInbound) {
            temp_my_portType_name = requestPorttypeName;
            if (callbackPorttypeName != null) {
                temp_partner_portType_name = callbackPorttypeName;
            }
        } else {
            temp_partner_portType_name = requestPorttypeName;
            if (callbackPorttypeName != null) {
                temp_my_portType_name = callbackPorttypeName;
            }
        }
        if (temp_my_portType_name != null && temp_my_portType_name.equals(plt.getPortName())) {
            temp_my_role_name = plt.getRoleName();
            temp_partner_role_name = plt.getRoleName2();
        } else {
            temp_my_role_name = plt.getRoleName2();
            temp_partner_role_name = plt.getRoleName();
        }
        if (temp_my_role_name == null && temp_partner_role_name == null) {
            return null;
        }
        SCAProject scaproj = SCAProject.getSCAProject((Project)mcontext._project);
        String relwsdlloc = CommonSchemaPanel.convertUriRelativeProject(scaproj.getWSDLRoot(), mcontext._wsdlFileURL);
        WsdlInfo wsdlInfo = new WsdlInfo(relwsdlloc, new QName(requestPorttypeName), null);
        AdapterWsdlInfo awi = new AdapterWsdlInfo(mcontext._project, temp_context._composite_service_name, isInbound, wsdlInfo, temp_context._service_type, temp_context._adapter_sub_type);
        awi._wsdlFileURL = mcontext._wsdlFileURL;
        awi._definition = def1;
        awi._targetNamespace = def1.getTargetNamespace();
        awi._my_role_name = temp_my_role_name;
        awi._my_portType_name = temp_my_portType_name;
        awi._partner_role_name = temp_partner_role_name;
        awi._partner_portType_name = temp_partner_portType_name;
        return awi;
    }

    public void createB2BFiles() throws Exception {
        String attachWSDLRelativeFileName;
        B2BWSDLComponents wsdlComp;
        B2BContext ctx = (B2BContext)WizardWSDLUtil.m_wcontext._ascontext;
        String SCHEMA_RELATIVE_LOCATION = "xsd";
        String attachFilename = "b2bAttachments.xsd";
        String ORAMDS_ATTACHMENT = "oramds:/soa/b2b/seed/b2bAttachments.xsd";
        ctx.setDirectory(WizardWSDLUtil.m_wcontext._project.getBaseDirectory());
        String wsdlSchemaRelativePath = null;
        if (ctx.getMDSConnectionName() != null) {
            wsdlSchemaRelativePath = ctx.getDocumentDefinition().getDefinitionFilename();
        } else if (!ctx.isOpaque() && !ctx.isAny()) {
            if (!ctx.isFileSystem()) {
                String schemaURL = ctx.getDocumentDefinition().getDefinitionFilename();
                List xsdDirStructure = ctx.getXSDDirStructure(schemaURL);
                String relativeSchemaPath = ctx.getRelativeXsdDirStr(xsdDirStructure, false);
                String relativeSchemaPathForWSDL = ctx.getRelativeXsdDirStr(xsdDirStructure, true);
                String schemaFilename = ctx.getSchemaFilename(schemaURL);
                String fullSchemaFilename = ctx.getSchemaDirectory() + relativeSchemaPath + schemaFilename;
                wsdlSchemaRelativePath = "xsd" + relativeSchemaPathForWSDL + schemaFilename;
                ctx.setFullSchemaFilename(fullSchemaFilename);
                this.createXsdDirStructure(ctx, xsdDirStructure);
                FileWriter schemaFW = new FileWriter(new File(ctx.getFullSchemaFilename()));
                schemaFW.write(ctx.getSchemaContent());
                schemaFW.flush();
                schemaFW.close();
            } else {
                SCAProject m_scaproj = SCAProject.getSCAProject((Project)WizardWSDLUtil.m_wcontext._project);
                URL m_xsdDirURL = m_scaproj.getXSDRoot();
                String fullSchemaFilename = m_xsdDirURL.getPath() + File.separator + ctx.getRelativeBrowseSchemaPath();
                wsdlSchemaRelativePath = "xsd/" + ctx.getRelativeBrowseSchemaPath();
                ctx.setFullSchemaFilename(fullSchemaFilename);
            }
            if (ctx.isAttachment()) {
                this.createB2BAttachmentDoc();
            }
        }
        if (ctx.isOpaque()) {
            if (!ctx.isAttachment()) {
                wsdlComp = B2BWSDLGenerator.getB2BOpaqueWSDL(ctx.getServiceName(), ctx.getSelectedRootElement(), ctx.getSchemaTargetNamespace(), ctx.getOperation(), ctx.getOpAttributes());
            } else {
                attachWSDLRelativeFileName = "xsd/b2bAttachments.xsd";
                wsdlComp = B2BWSDLGenerator.getB2BOpaqueWSDLAttach(ctx.getServiceName(), ctx.getSelectedRootElement(), ctx.getSchemaTargetNamespace(), attachWSDLRelativeFileName, ctx.getAttachRootElement(), ctx.getAttachSchemaNamespace(), ctx.getOperation(), ctx.getOpAttributes());
            }
        } else if (ctx.isAny()) {
            if (!ctx.isAttachment()) {
                wsdlComp = B2BWSDLGenerator.getB2BAnyTypeWSDL(ctx.getServiceName(), ctx.getOperation(), ctx.getOpAttributes());
            } else {
                attachWSDLRelativeFileName = "xsd/b2bAttachments.xsd";
                wsdlComp = B2BWSDLGenerator.getB2BAnyTypeWSDLAttach(ctx.getServiceName(), attachWSDLRelativeFileName, ctx.getAttachRootElement(), ctx.getAttachSchemaNamespace(), ctx.getOperation(), ctx.getOpAttributes());
            }
        } else if (!ctx.isAttachment()) {
            wsdlComp = B2BWSDLGenerator.getB2BWSDL(ctx.getServiceName(), wsdlSchemaRelativePath, ctx.getSelectedRootElement(), ctx.getSchemaTargetNamespace(), ctx.getOperation(), ctx.getOpAttributes());
        } else {
            attachWSDLRelativeFileName = "";
            attachWSDLRelativeFileName = ctx.getMDSConnectionName() != null ? "oramds:/soa/b2b/seed/b2bAttachments.xsd" : "xsd/b2bAttachments.xsd";
            wsdlComp = B2BWSDLGenerator.getB2BWSDLAttach(ctx.getServiceName(), wsdlSchemaRelativePath, ctx.getSelectedRootElement(), ctx.getSchemaTargetNamespace(), attachWSDLRelativeFileName, ctx.getAttachRootElement(), ctx.getAttachSchemaNamespace(), ctx.getOperation(), ctx.getOpAttributes());
        }
        ctx.setPortType(wsdlComp.getPortName());
        ctx.setWSDLTargetNamespace(wsdlComp.getTargetNamespace());
        ctx.setRole(wsdlComp.getRole());
        FileWriter wsdlFW = new FileWriter(new File(ctx.getFullWSDLFilename()));
        wsdlFW.write(wsdlComp.getWSDL());
        wsdlFW.flush();
        wsdlFW.close();
        File wsdlFile = new File(ctx.getFullWSDLFilename());
        if (wsdlFile.exists()) {
            SCAController scon = SCAControllerImpl.getController((Project)WizardWSDLUtil.m_wcontext._project);
            this.createSCAComponents(scon, ctx);
        }
        UpdateMessage.fireStructureChanged((Subject)WizardWSDLUtil.m_wcontext._project);
    }

    public static AdapterWsdlInfo getB2BAdapterWSDLInfo(AdapterWizardContext ctx) throws WSDLException {
        B2BContext b_ctx = (B2BContext)ctx._ascontext;
        SCAProject scaproj = SCAProject.getSCAProject((Project)ctx._project);
        String relwsdlloc = CommonSchemaPanel.convertUriRelativeProject(scaproj.getWSDLRoot(), URLFactory.newURL((String)b_ctx.getFullWSDLFilename()));
        WsdlInfo wsdlInfo = new WsdlInfo(relwsdlloc, new QName(b_ctx.getPortType()), null);
        AdapterWsdlInfo awi = new AdapterWsdlInfo(ctx._project, b_ctx.getServiceName(), b_ctx.isInbound(), wsdlInfo, b_ctx.getServiceType(), null);
        awi._wsdlFileURL = URLFactory.newURL((String)b_ctx.getFullWSDLFilename());
        awi._isInboundService = b_ctx.isInbound();
        if (b_ctx.isInbound()) {
            awi._my_role_name = b_ctx.getRole();
            awi._my_portType_name = b_ctx.getPortType();
        } else {
            awi._partner_role_name = b_ctx.getRole();
            awi._partner_portType_name = b_ctx.getPortType();
        }
        awi._service_name = b_ctx.getServiceName();
        awi._service_type = b_ctx.getServiceType();
        return awi;
    }

    private void createB2BAttachmentDoc() {
        B2BContext ctx = (B2BContext)WizardWSDLUtil.m_wcontext._ascontext;
        String ATTACHMENT_DOCREF = "B2B--1.0--B2BAttachment--Attachment_def";
        String schemaFilename = "b2bAttachments.xsd";
        try {
            String attachXsdContent = ctx.getB2BWebServiceClient().getDocDef("B2B--1.0--B2BAttachment--Attachment_def");
            String fullSchemaFilename = ctx.getSchemaDirectory() + File.separator + "b2bAttachments.xsd";
            FileWriter schemaFW = new FileWriter(new File(fullSchemaFilename));
            schemaFW.write(attachXsdContent);
            schemaFW.flush();
            schemaFW.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createSCAComponents(SCAController scaController, B2BContext ctx) {
        if (scaController != null && ctx != null) {
            String wsdlFileShortname = new File(ctx.getWSDLFilename()).getName();
            QName portTypeQName = new QName(ctx.getWSDLTargetNamespace(), ctx.getPortType());
            WsdlInfo wsdlInfo = new WsdlInfo(wsdlFileShortname, portTypeQName, null);
            BindingInfoB2B bindingInfo = ctx.getRoutingFlag() ? new BindingInfoB2B("b2b", "DOC_ROUTING_ID--" + ctx.getDocumentDefinition().getRoutingId(), null) : new BindingInfoB2B("b2b", ctx.getDocumentDefinition().getDocRef(), null);
            if (WizardWSDLUtil.m_wcontext._read_service != null) {
                ArrayList<BindingInfoB2B> bindingList = new ArrayList<BindingInfoB2B>();
                bindingList.add(bindingInfo);
                if (ctx.isInbound()) {
                    scaController.updateServiceEntrypoint(ctx.getServiceName(), ctx.getServiceName(), (InterfaceInfo)wsdlInfo, bindingList);
                } else {
                    scaController.updateExternalReference(ctx.getServiceName(), ctx.getServiceName(), (InterfaceInfo)wsdlInfo, bindingList);
                }
            } else if (ctx.isInbound()) {
                String scaName = scaController.addServiceEntrypoint(null, ctx.getServiceName(), (InterfaceInfo)wsdlInfo, (BindingInfo)bindingInfo);
            } else {
                String scaName = scaController.addExternalReference(ctx.getServiceName(), (InterfaceInfo)wsdlInfo, (BindingInfo)bindingInfo);
            }
        }
    }

    private void createXsdDirStructure(B2BContext ctx, List relativeDir) throws Exception {
        if (relativeDir == null || relativeDir.size() < 0) {
            return;
        }
        String currPath = ctx.getSchemaDirectory();
        for (String currRelativeDir : relativeDir) {
            boolean succeeded;
            File dir;
            if (currRelativeDir == null || currRelativeDir.trim().equals("") || (dir = new File(currPath = currPath + File.separator + currRelativeDir)).exists() || (succeeded = dir.mkdir())) continue;
            throw new Exception("ERROR: An error occurred while creating the directory, " + currPath);
        }
    }

    private Definition readWSDLFromMemory(Definition def, String mode, URL wsdlURL) throws Exception {
        String defaultNS;
        ExtensionRegistry extensionRegistry = null;
        this.m_write_factory = WizardWSDLUtil.createWSDLFactory();
        WSDLReader reader = this.m_write_factory.newWSDLReader();
        boolean testit = true;
        if (!testit) {
            reader.setFeature("javax.wsdl.importDocuments", false);
        }
        if (mode.equals(CREATE_MODE)) {
            extensionRegistry = this.m_write_factory.newPopulatedExtensionRegistry();
        } else if (mode.equals(EDIT_MODE)) {
            extensionRegistry = this.m_extention_factory.newPopulatedExtensionRegistry();
        }
        if (extensionRegistry != null) {
            extensionRegistry.mapExtensionTypes(Types.class, Constants.QNAME_SCHEMA_2001, UnknownExtensibilityElement.class);
            extensionRegistry.registerDeserializer(Types.class, Constants.QNAME_SCHEMA_2001, extensionRegistry.getDefaultDeserializer());
            extensionRegistry.registerSerializer(Types.class, Constants.QNAME_SCHEMA_2001, extensionRegistry.getDefaultSerializer());
            reader.setExtensionRegistry(extensionRegistry);
        } else {
            System.out.println("ERROR: WizardWSDLUtil.readWSDLFromMemory() - extensionRegistry is null.");
        }
        InputStream defStream = this.writeToStream(def);
        DOMParser parser = new DOMParser();
        parser.parse(defStream);
        String wsdl_in = wsdlURL.toExternalForm() + "_temp";
        URL wwurl = URLFactory.newURL((String)wsdl_in);
        WizardWSDLUtil.writeXmlFile(wwurl, parser.getDocument());
        Definition newdef = reader.readWSDL((String)null, wwurl.toExternalForm());
        if (def.getPortTypes().size() == 0 && newdef.getPortTypes().size() > 0) {
            ArrayList qnameL = new ArrayList(newdef.getPortTypes().size());
            Iterator piter = newdef.getPortTypes().keySet().iterator();
            while (piter.hasNext()) {
                qnameL.add(piter.next());
            }
            int ss = qnameL.size();
            for (int ii = 0; ii < ss; ++ii) {
                newdef.removePortType((QName)qnameL.get(ii));
            }
        }
        if ((defaultNS = def.getNamespace(null)) == null || defaultNS.length() == 0) {
            newdef.addNamespace(null, null);
        }
        File tempfile = new File(wwurl.getFile());
        boolean delok = tempfile.delete();
        return newdef;
    }

    public static void writeXmlFile(URL furl, XMLDocument xmldoc) throws IOException {
        OutputStream fos = URLFileSystem.openOutputStream((URL)furl);
        xmldoc.setEncoding(WSDL_CHARSET);
        xmldoc.print(fos);
        fos.close();
    }

    private InputStream writeToStream(Definition def) throws WSDLException, IOException {
        String wsdlFacImpl = "oracle.j2ee.ws.wsdl.factory.WSDLFactoryImpl";
        WSDLFactory fac = WSDLFactory.newInstance((String)wsdlFacImpl);
        WSDLWriter writer = fac.newWSDLWriter();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        writer.writeWSDL(def, (OutputStream)baos);
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public static void writeFile(String fileName, String contents) throws IOException {
        URL furl = URLFactory.newURL((String)fileName);
        OutputStream fos = URLFileSystem.openOutputStream((URL)furl);
        OutputStreamWriter osw = new OutputStreamWriter(fos, WSDL_CHARSET);
        BufferedWriter bw = new BufferedWriter(osw);
        bw.write(contents);
        bw.close();
        osw.close();
        fos.close();
    }

    private Definition readWSDL(String wsdlName) throws WSDLException {
        this.m_write_factory = WizardWSDLUtil.createWSDLFactory();
        WSDLReader reader = this.m_write_factory.newWSDLReader();
        File file = new File(wsdlName);
        return reader.readWSDL(file.toURI().toString());
    }

    public static AdapterWsdlInfo getAdapterWsdlInfo(AdapterWizardContext _wcontext) {
        AdapterWsdlInfo awi = null;
        try {
            awi = _wcontext._adapter_sub_type != null && _wcontext._adapter_sub_type.equals("DB") ? WizardWSDLUtil.parseAdapterWsdl(_wcontext._wsdlFileURL) : (_wcontext._importedWsdlInfo != null ? WizardWSDLUtil.parseAdapterWsdl(_wcontext._write_definition, _wcontext._wsdlFileURL, false, _wcontext._importedWsdlInfo.getRequestPorttype()) : WizardWSDLUtil.parseAdapterWsdl(_wcontext._write_definition, _wcontext._wsdlFileURL));
        }
        catch (WSDLException wSDLException) {
            // empty catch block
        }
        if (awi != null) {
            awi.urlList = _wcontext.getURLs();
        }
        return awi;
    }

    public static AdapterWsdlInfo parseAdapterWsdl(URL wsdlLocation) throws WSDLException {
        return WizardWSDLUtil.parseAdapterWsdl(wsdlLocation, false, null);
    }

    public static AdapterWsdlInfo parseAdapterWsdl(URL wsdlLocation, boolean nonTechAdapterOK, QName porttype) throws WSDLException {
        WSDLFactory wfact = WizardWSDLUtil.createWSDLFactory();
        Definition def1 = WizardWSDLUtil.readAdapterWsdl(wfact, wsdlLocation);
        return WizardWSDLUtil.parseAdapterWsdl(def1, wsdlLocation, nonTechAdapterOK, porttype);
    }

    public static AdapterWsdlInfo parseAdapterWsdl(Definition def1, URL wsdlLocation) throws WSDLException {
        return WizardWSDLUtil.parseAdapterWsdl(def1, wsdlLocation, false, null);
    }

    public static AdapterWsdlInfo parseAdapterWsdl(Definition def1, URL wsdlLocation, boolean nonTechAdapterOK, QName porttype_in) throws WSDLException {
        if (wsdlLocation == null) {
            return null;
        }
        if (def1 == null) {
            return WizardWSDLUtil.parseAdapterWsdl(wsdlLocation);
        }
        Map services = def1.getServices();
        JcaAddress jcaad = null;
        if (services == null || services.size() == 0) {
            return null;
        }
        Iterator servI = services.values().iterator();
        Service serv1 = null;
        if (servI.hasNext()) {
            serv1 = (Service)servI.next();
            Map ports = serv1.getPorts();
            block0: for (Port port1 : ports.values()) {
                List pext = port1.getExtensibilityElements();
                for (Object extobj : pext) {
                    if (!(extobj instanceof JcaAddress)) continue;
                    jcaad = (JcaAddress)extobj;
                    break block0;
                }
            }
            if (jcaad == null) {
                return null;
            }
        } else {
            return null;
        }
        QName porttypeQname = porttype_in;
        if (porttypeQname == null) {
            Map portTypes = def1.getPortTypes();
            Iterator porttI = portTypes.values().iterator();
            PortType portt = (PortType)porttI.next();
            porttypeQname = portt.getQName();
        }
        BindingOperation bindingOp2 = null;
        JcaOperation jcaop = null;
        Binding defaultBinding = null;
        Map bindings = def1.getBindings();
        block2: for (Binding bind1 : bindings.values()) {
            QName pqname = bind1.getPortType().getQName();
            if (!pqname.equals(porttypeQname)) continue;
            if (defaultBinding == null) {
                defaultBinding = bind1;
            }
            List boperations = bind1.getBindingOperations();
            for (BindingOperation bindingOp2 : boperations) {
                List bextElements = bindingOp2.getExtensibilityElements();
                for (Object extobj : bextElements) {
                    if (!(extobj instanceof JcaOperation)) continue;
                    jcaop = (JcaOperation)extobj;
                    defaultBinding = bind1;
                    break block2;
                }
            }
        }
        if (jcaop == null) {
            return null;
        }
        String interspec = jcaop.getAttributeValue("InteractionSpec");
        if (interspec == null) {
            interspec = jcaop.getAttributeValue("ActivationSpec");
        }
        AdapterWizardContext temp_context = new AdapterWizardContext();
        AdapterWizardContext.setAdapterType(temp_context, interspec);
        if (temp_context._service_type == null && !nonTechAdapterOK) {
            return null;
        }
        String temp_partnerLinkType_name = null;
        boolean temp_isInboundService = false;
        String temp_my_role_name = null;
        String temp_my_portType_name = null;
        QName temp_inboundHeaderMessage = null;
        String temp_partner_role_name = null;
        String temp_partner_portType_name = null;
        QName temp_outboundHeaderMessage = null;
        String temprole1 = null;
        String temprole2 = null;
        PartnerLinkType plt = null;
        List extensibilityElements = def1.getExtensibilityElements();
        for (int i = 0; i < extensibilityElements.size(); ++i) {
            String rolePortName2;
            Object exelem1 = extensibilityElements.get(i);
            if (!(exelem1 instanceof PartnerLinkType)) continue;
            plt = (PartnerLinkType)exelem1;
            temp_partnerLinkType_name = plt.getPartnerLinkTypeName();
            temprole1 = plt.getRoleName();
            temprole2 = plt.getRoleName2();
            if (plt.getPortName().equals(porttypeQname.getLocalPart()) || (rolePortName2 = plt.getPortName2()) != null && rolePortName2.equals(porttypeQname.getLocalPart())) break;
        }
        if (plt == null || temprole1 == null) {
            return null;
        }
        if (temprole2 == null) {
            List extElements = defaultBinding.getExtensibilityElements();
            if (extElements.size() > 0 && extElements.get(0) instanceof PCInboundBinding) {
                temp_isInboundService = true;
                temp_my_role_name = temprole1;
                temp_my_portType_name = plt.getPortName();
                temp_inboundHeaderMessage = WizardWSDLUtil.getAdapterHeaderMessageForBindingOperation(def1, bindingOp2);
            } else {
                temp_isInboundService = false;
                temp_partner_role_name = temprole1;
                temp_partner_portType_name = plt.getPortName();
                temp_outboundHeaderMessage = WizardWSDLUtil.getAdapterHeaderMessageForBindingOperation(def1, bindingOp2);
            }
        } else {
            String porttypeName1 = plt.getPortName();
            String porttypeName2 = plt.getPortName2();
            Binding matchBinding = null;
            String matchRoleName = null;
            String matchPortName = null;
            String otherRoleName = null;
            String otherPortName = null;
            boolean matchPortIsInbound = false;
            boolean haveMatchingPortType = false;
            String bindingType = null;
            Iterator bindingI = bindings.values().iterator();
            while (bindingI.hasNext()) {
                Binding bind1 = (Binding)bindingI.next();
                PortType btype = bind1.getPortType();
                String btypeName = btype.getQName().getLocalPart();
                if (btypeName.equals(porttypeName1)) {
                    haveMatchingPortType = true;
                    matchPortName = porttypeName1;
                    matchRoleName = temprole1;
                    otherPortName = porttypeName2;
                    otherRoleName = temprole2;
                } else if (btypeName.equals(porttypeName2)) {
                    haveMatchingPortType = true;
                    matchPortName = porttypeName2;
                    matchRoleName = temprole2;
                    otherPortName = porttypeName1;
                    otherRoleName = temprole1;
                }
                if (!haveMatchingPortType) continue;
                matchBinding = bind1;
                List bext1 = bind1.getExtensibilityElements();
                for (Object ext1 : bext1) {
                    if (ext1 instanceof JcaBinding) {
                        matchPortIsInbound = false;
                        JcaBinding jbind = (JcaBinding)ext1;
                        bindingType = jbind.getAttributeValue("UITransmissionPrimitive");
                        temp_outboundHeaderMessage = WizardWSDLUtil.getAdapterHeaderMessageForBinding(def1, bind1);
                        temp_inboundHeaderMessage = WizardWSDLUtil.getAdapterHeaderMessageForBinding(def1, (Binding)bindingI.next());
                        continue;
                    }
                    if (!(ext1 instanceof PCInboundBinding)) continue;
                    matchPortIsInbound = true;
                    PCInboundBinding pcbind = (PCInboundBinding)ext1;
                    bindingType = pcbind.getAttributeValue("UITransmissionPrimitive");
                    temp_inboundHeaderMessage = WizardWSDLUtil.getAdapterHeaderMessageForBinding(def1, bind1);
                    temp_outboundHeaderMessage = WizardWSDLUtil.getAdapterHeaderMessageForBinding(def1, (Binding)bindingI.next());
                }
                temp_isInboundService = bindingType.equals("Solicit-response");
                if (matchPortIsInbound) {
                    temp_my_role_name = matchRoleName;
                    temp_my_portType_name = matchPortName;
                    temp_partner_role_name = otherRoleName;
                    temp_partner_portType_name = otherPortName;
                    break;
                }
                temp_my_role_name = otherRoleName;
                temp_my_portType_name = otherPortName;
                temp_partner_role_name = matchRoleName;
                temp_partner_portType_name = matchPortName;
                break;
            }
        }
        SCAProject scaproj = SCAProject.getSCAProject((Project)WizardWSDLUtil.m_wcontext._project);
        String relwsdlloc = CommonSchemaPanel.convertUriRelativeProject(scaproj.getWSDLRoot(), wsdlLocation);
        QName requestPortType = null;
        QName replyPortType = null;
        def1.getTargetNamespace();
        if (temp_isInboundService) {
            requestPortType = new QName(def1.getTargetNamespace(), temp_my_portType_name);
            if (temp_partner_portType_name != null) {
                replyPortType = new QName(def1.getTargetNamespace(), temp_partner_portType_name);
            }
        } else {
            requestPortType = new QName(def1.getTargetNamespace(), temp_partner_portType_name);
            if (temp_my_portType_name != null) {
                replyPortType = new QName(def1.getTargetNamespace(), temp_my_portType_name);
            }
        }
        WsdlInfo wsdlInfo = new WsdlInfo(relwsdlloc, requestPortType, replyPortType);
        AdapterWsdlInfo awi = new AdapterWsdlInfo(WizardWSDLUtil.m_wcontext._project, serv1.getQName().getLocalPart(), temp_isInboundService, wsdlInfo, temp_context._service_type, temp_context._adapter_sub_type);
        awi._wsdlFileURL = wsdlLocation;
        awi._definition = def1;
        awi._targetNamespace = def1.getTargetNamespace();
        awi._adapter_type_icon = temp_context._adapter_type_icon;
        awi._my_role_name = temp_my_role_name;
        awi._my_portType_name = temp_my_portType_name;
        awi._partner_role_name = temp_partner_role_name;
        awi._partner_portType_name = temp_partner_portType_name;
        WizardWSDLUtil.addFileAdapterLogicalDirs(awi, jcaop);
        WizardWSDLUtil.addOldFileAdapterLogicalDirs(awi);
        awi._allJcaOperationProperties = jcaop.getUnreadAttributes();
        for (String attrname : awi._allJcaOperationProperties.keySet()) {
            String attrvalue = (String)awi._allJcaOperationProperties.get(attrname);
            if (!attrvalue.startsWith("$")) continue;
            if (awi._logicalNames == null) {
                awi._logicalNames = new Hashtable();
            }
            awi._logicalNames.put(attrname, attrvalue.substring(1));
        }
        return awi;
    }

    public static QName getAdapterHeaderMessageForBinding(Definition def1, Binding bind1) {
        List boperations = bind1.getBindingOperations();
        Iterator boperI = boperations.iterator();
        BindingOperation bop1 = (BindingOperation)boperI.next();
        return WizardWSDLUtil.getAdapterHeaderMessageForBindingOperation(def1, bop1);
    }

    public static QName getAdapterHeaderMessageForBindingOperation(Definition def1, BindingOperation bindingOp) {
        List inputL;
        BindingInput bindinput = bindingOp.getBindingInput();
        if (bindinput != null && (inputL = bindinput.getExtensibilityElements()) != null && inputL.size() > 0) {
            ExtensibilityElement extendElem = (ExtensibilityElement)inputL.get(0);
            Element jcaheader = ((UnknownExtensibilityElement)extendElem).getElement();
            String msg = jcaheader.getAttribute("message");
            int colind = msg.indexOf(":");
            String hdrprefix = msg.substring(0, colind);
            String hdrmsg = msg.substring(colind + 1);
            String hdrUri = (String)def1.getNamespaces().get(hdrprefix);
            return new QName(hdrUri, hdrmsg, hdrprefix);
        }
        return null;
    }

    private static void addFileAdapterLogicalDirs(AdapterWsdlInfo awi, JcaOperation jcaop) {
        if (jcaop != null && awi != null) {
            String logicalTrigDirVal;
            String logicalArchDirVal;
            String logicalDirVal = jcaop.getAttributeValue("LogicalDirectory");
            List dirList = FileAdapterContext.convertDirStrToList(logicalDirVal);
            if (dirList != null && dirList.size() > 0) {
                if (awi._logicalNames == null) {
                    awi._logicalNames = new Hashtable();
                }
                for (int i = 0; i < dirList.size(); ++i) {
                    String key = (String)dirList.get(i);
                    awi._logicalNames.put(key, "");
                }
            }
            if ((logicalArchDirVal = jcaop.getAttributeValue("LogicalArchiveDirectory")) != null) {
                awi._logicalNames.put(logicalArchDirVal, "");
            }
            if ((logicalTrigDirVal = jcaop.getAttributeValue("TriggerFileLogicalDirectory")) != null) {
                awi._logicalNames.put(logicalTrigDirVal, "");
            }
        }
    }

    private static void addOldFileAdapterLogicalDirs(AdapterWsdlInfo awi) {
        if (WizardWSDLUtil.m_wcontext._logicalNames_old != null) {
            if (awi._logicalNames_old == null) {
                awi._logicalNames_old = new Hashtable();
            }
            awi._logicalNames_old.putAll(WizardWSDLUtil.m_wcontext._logicalNames_old);
        }
    }

    private static void addLogicalName(AdapterWsdlInfo awi, JcaOperation jcaop, String logNameKey) {
        String tempstr = jcaop.getAttributeValue(logNameKey);
        if (tempstr != null && tempstr.length() > 0) {
            if (awi._logicalNames == null) {
                awi._logicalNames = new Hashtable();
            }
            awi._logicalNames.put(logNameKey, tempstr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WSDLFactory createWSDLFactory() throws WSDLException {
        if (s_wsdlFactory != null) {
            return s_wsdlFactory;
        }
        Boolean bl = m_lock;
        synchronized (bl) {
            System.setProperty("javax.wsdl.factory.WSDLFactory", "oracle.j2ee.ws.wsdl.factory.WSDLFactoryImpl");
            s_wsdlFactory = WSDLFactory.newInstance();
            return s_wsdlFactory;
        }
    }

    public static Definition readAdapterWsdl(WSDLFactory wfact, URL wsdlLocation) throws WSDLException {
        Definition def1 = null;
        WizardWSDLFactory extention_factory = new WizardWSDLFactory();
        WSDLReader reader = wfact.newWSDLReader();
        reader.setExtensionRegistry(extention_factory.newPopulatedExtensionRegistry());
        reader.setFeature("javax.wsdl.verbose", false);
        reader.setFeature("javax.wsdl.importDocuments", true);
        if (wsdlLocation != null) {
            def1 = reader.readWSDL(null, wsdlLocation.toExternalForm());
        }
        return def1;
    }

    public static String getSchemaLocation(Definition def, String namespace) {
        Types type;
        String schemaLoc = null;
        String SCHEMA_ELEMENT = "schema";
        String IMPORT_ELEMENT = "import";
        String NAMESPACE_ATTRIBUTE = "namespace";
        String LOCATION_ATTRIBUTE = "schemaLocation";
        if (def != null && namespace != null && !namespace.trim().equals("") && (type = def.getTypes()) != null) {
            List typeList = type.getExtensibilityElements();
            for (Object obj : typeList) {
                String importNamespace;
                Element elem;
                NodeList nl;
                Element importElem;
                UnknownExtensibilityElement exElem;
                QName elemType;
                if (!(obj instanceof UnknownExtensibilityElement) || !SCHEMA_ELEMENT.equals((elemType = (exElem = (UnknownExtensibilityElement)obj).getElementType()).getLocalPart()) || (importElem = (Element)(nl = (elem = exElem.getElement()).getElementsByTagName(IMPORT_ELEMENT)).item(0)) == null || !namespace.equals(importNamespace = WizardWSDLUtil.getAttribute(importElem, NAMESPACE_ATTRIBUTE))) continue;
                schemaLoc = WizardWSDLUtil.getAttribute(importElem, LOCATION_ATTRIBUTE);
                break;
            }
        }
        return schemaLoc;
    }

    public static String getAttribute(Element el, String attrName) {
        String sRet = null;
        Attr attr = null;
        NamedNodeMap attrs = el.getAttributes();
        attr = (Attr)attrs.getNamedItem(attrName);
        if (attr != null) {
            sRet = attr.getValue();
        }
        WizardWSDLUtil.trace(null, true, attrName + sRet);
        return sRet;
    }

    public static void print(PrintWriter pw, String value) {
        if (value != null) {
            pw.print(value);
        }
    }

    public static void printAttribute(String name, String value, PrintWriter pw) {
        WizardWSDLUtil.printAttribute(name, value, pw, 1, false);
    }

    public static void printAttribute(String name, String value, PrintWriter pw, int padnum, boolean newline) {
        String padstr = "                                            ";
        if (value != null) {
            String tempstr = "";
            if (newline) {
                tempstr = "\n";
            }
            tempstr = tempstr + padstr.substring(0, padnum);
            tempstr = tempstr + name + "=\"" + WizardWSDLUtil.cleanString(value) + '\"';
            pw.print(tempstr);
            WizardWSDLUtil.trace(null, false, tempstr);
        }
    }

    public static void printQualifiedAttribute(QName name, String value, Definition def, PrintWriter pw) throws WSDLException {
        if (name != null) {
            WizardWSDLUtil.printAttribute(WizardWSDLUtil.getQualifiedValue(name.getNamespaceURI(), name.getLocalPart(), def), value, pw);
        }
    }

    public static void printQualifiedAttribute(QName name, QName value, Definition def, PrintWriter pw) throws WSDLException {
        if (value != null) {
            WizardWSDLUtil.printAttribute(WizardWSDLUtil.getQualifiedValue(name.getNamespaceURI(), name.getLocalPart(), def), WizardWSDLUtil.getQualifiedValue(value.getNamespaceURI(), value.getLocalPart(), def), pw);
        }
    }

    public static void printQualifiedAttribute(String name, QName value, Definition def, PrintWriter pw) throws WSDLException {
        if (value != null) {
            WizardWSDLUtil.printAttribute(name, WizardWSDLUtil.getQualifiedValue(value.getNamespaceURI(), value.getLocalPart(), def), pw);
        }
    }

    public static String getQualifiedValue(String namespaceURI, String localPart, Definition def) throws WSDLException {
        String prefix = null;
        if (namespaceURI != null && !namespaceURI.equals("")) {
            prefix = WizardWSDLUtil.getPrefix(namespaceURI, def);
        }
        return (prefix != null && !prefix.equals("") ? prefix + ":" : "") + localPart;
    }

    public static String getPrefix(String namespaceURI, Definition def) throws WSDLException {
        String prefix = def.getPrefix(namespaceURI);
        if (prefix == null) {
            throw new WSDLException("OTHER_ERROR", "Can't find prefix for '" + namespaceURI + "'. Namespace prefixes must be set on the" + " Definition object using the " + "addNamespace(...) method.");
        }
        return prefix;
    }

    public static String cleanString(String orig) {
        if (orig == null) {
            return "";
        }
        StringBuffer strBuf = new StringBuffer();
        char[] chars = orig.toCharArray();
        boolean inCDATA = false;
        for (int i = 0; i < chars.length; ++i) {
            if (!inCDATA) {
                switch (chars[i]) {
                    case '&': {
                        strBuf.append("&amp;");
                        break;
                    }
                    case '\"': {
                        strBuf.append("&quot;");
                        break;
                    }
                    case '\'': {
                        strBuf.append("&apos;");
                        break;
                    }
                    case '<': {
                        if (chars.length >= i + 9) {
                            String tempStr = new String(chars, i, 9);
                            if (tempStr.equals("<![CDATA[")) {
                                strBuf.append(tempStr);
                                i += 8;
                                inCDATA = true;
                                break;
                            }
                            strBuf.append("&lt;");
                            break;
                        }
                        strBuf.append("&lt;");
                        break;
                    }
                    case '>': {
                        strBuf.append("&gt;");
                        break;
                    }
                    default: {
                        strBuf.append(chars[i]);
                        break;
                    }
                }
                continue;
            }
            strBuf.append(chars[i]);
            if (chars[i] != '>' || chars[i - 1] != ']' || chars[i - 2] != ']') continue;
            inCDATA = false;
        }
        return strBuf.toString();
    }

    public static boolean matches(QName qname, org.w3c.dom.Node node) {
        return node != null && qname.equals(WizardWSDLUtil.newQName(node));
    }

    public static QName newQName(org.w3c.dom.Node node) {
        if (node != null) {
            return new QName(node.getNamespaceURI(), node.getLocalName());
        }
        return new QName(null, null);
    }

    private static org.w3c.dom.Node getPreviousTypedNode(org.w3c.dom.Node node, short nodeType) {
        for (node = node.getPreviousSibling(); node != null && node.getNodeType() != nodeType; node = node.getPreviousSibling()) {
        }
        return node;
    }

    private static org.w3c.dom.Node getNextTypedNode(org.w3c.dom.Node node, short nodeType) {
        for (node = node.getNextSibling(); node != null && node.getNodeType() != nodeType; node = node.getNextSibling()) {
        }
        return node;
    }

    private static String getValue(org.w3c.dom.Node node, short nodeType) {
        switch (nodeType) {
            case 1: {
                return ((Element)node).getTagName();
            }
            case 3: {
                return ((Text)node).getData();
            }
            case 7: {
                return ((ProcessingInstruction)node).getData();
            }
        }
        return "";
    }

    private static short getNodeType(org.w3c.dom.Node node) {
        if (node != null) {
            return node.getNodeType();
        }
        return -1;
    }

    private static String getXPathFromVector(Vector path) {
        StringBuffer strBuf = new StringBuffer();
        int length = path.size();
        for (int i = 0; i < length; ++i) {
            String step;
            boolean hasMatchingSiblings;
            org.w3c.dom.Node tempNode = (org.w3c.dom.Node)path.elementAt(i);
            short nodeType = WizardWSDLUtil.getNodeType(tempNode);
            String targetValue = WizardWSDLUtil.getValue(tempNode, nodeType);
            int position = 1;
            tempNode = WizardWSDLUtil.getPreviousTypedNode(tempNode, nodeType);
            while (tempNode != null) {
                if (nodeType == 1) {
                    if (WizardWSDLUtil.getValue(tempNode, nodeType).equals(targetValue)) {
                        ++position;
                    }
                } else {
                    ++position;
                }
                tempNode = WizardWSDLUtil.getPreviousTypedNode(tempNode, nodeType);
            }
            boolean bl = hasMatchingSiblings = position > 1;
            if (!hasMatchingSiblings) {
                tempNode = (org.w3c.dom.Node)path.elementAt(i);
                tempNode = WizardWSDLUtil.getNextTypedNode(tempNode, nodeType);
                while (!hasMatchingSiblings && tempNode != null) {
                    if (nodeType == 1) {
                        if (WizardWSDLUtil.getValue(tempNode, nodeType).equals(targetValue)) {
                            hasMatchingSiblings = true;
                            continue;
                        }
                        tempNode = WizardWSDLUtil.getNextTypedNode(tempNode, nodeType);
                        continue;
                    }
                    hasMatchingSiblings = true;
                }
            }
            switch (nodeType) {
                case 3: {
                    step = "text()";
                    break;
                }
                case 7: {
                    step = "processing-instruction()";
                    break;
                }
                default: {
                    step = targetValue;
                }
            }
            if (step != null && step.length() > 0) {
                strBuf.append('/' + step);
            }
            if (!hasMatchingSiblings) continue;
            strBuf.append("[" + position + "]");
        }
        return strBuf.toString();
    }

    private static Vector getVectorPathFromNode(org.w3c.dom.Node node) {
        Vector<org.w3c.dom.Node> path = new Vector<org.w3c.dom.Node>();
        while (node != null) {
            path.insertElementAt(node, 0);
            node = node.getParentNode();
        }
        return path;
    }

    public static String getXPathExprFromNode(org.w3c.dom.Node node) throws IllegalArgumentException {
        short nodeType = WizardWSDLUtil.getNodeType(node);
        switch (nodeType) {
            case 1: 
            case 3: 
            case 7: {
                return WizardWSDLUtil.getXPathFromVector(WizardWSDLUtil.getVectorPathFromNode(node));
            }
            case 9: {
                return "/";
            }
        }
        throw new IllegalArgumentException("Only works for element, text, document, and PI nodes.");
    }

    public static Element createDocumentationElement(String doctext) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element document_element = document.createElement("documentation");
            Text document_text = document.createTextNode(doctext);
            document_element.appendChild(document_text);
            return document_element;
        }
        catch (ParserConfigurationException pe) {
            return null;
        }
    }

    public static void trace(String level, boolean inbound, String value) {
        String direction = "*outbound ";
        if (inbound) {
            direction = "*inbound ";
        }
        WizardWSDLUtil.trace(level, direction + value);
    }

    public static void trace(String level, String value) {
    }

    public static void copyFile(InputStream fis, File out) throws Exception {
        FileOutputStream fos = new FileOutputStream(out);
        byte[] buf = new byte[1024];
        int i = 0;
        while ((i = fis.read(buf)) != -1) {
            fos.write(buf, 0, i);
        }
        fis.close();
        fos.close();
    }

    public static void cleanup(String wsdlPath, Project jdevProject) {
        if (wsdlPath != null) {
            try {
                String jcaFilePath = WizardWSDLUtil.getJCAFilePath(jdevProject.getBaseDirectory(), wsdlPath);
                if (jcaFilePath != null) {
                    File jcaFile = new File(jcaFilePath);
                    jcaFile.delete();
                    UpdateMessage.fireStructureChanged((Subject)jdevProject);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        String wsdl_in = "file:\\c:\\dev_esb\\wsdls\\twoPartnerLinkAdapter.wsdl";
        QName porttypeQname = new QName("http://xmlns.oracle.com/pcbpel/adapter/aq/850_X12_4010-4010/", "Enqueue_ptt");
        URL wurl = URLFactory.newURL((String)wsdl_in);
        try {
            AdapterWsdlInfo awinfo = WizardWSDLUtil.parseAdapterWsdl(wurl, true, porttypeQname);
            String breakhere = "xx";
        }
        catch (WSDLException wex) {
            wex.printStackTrace();
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOldWSDLFile() throws Exception {
        WSDLWriter wsdlWriter = this.m_write_factory.newWSDLWriter();
        File file = null;
        FileOutputStream outStream = null;
        OutputStreamWriter osw = null;
        try {
            WizardWSDLUtil.m_wcontext._wsdlFileURL = URLFactory.newURL((String)WizardWSDLUtil.m_wcontext._write_wsdl_name);
            String filestr = WizardWSDLUtil.m_wcontext._wsdlFileURL.getFile() + ".old";
            file = new File(filestr);
            outStream = new FileOutputStream(file);
            osw = new OutputStreamWriter((OutputStream)outStream, WSDL_CHARSET);
            wsdlWriter.writeWSDL(WizardWSDLUtil.m_wcontext._write_definition, (Writer)osw);
        }
        catch (Exception e) {
            System.out.println("OLD WSDL FORMAT ERROR: Error while writing old wsdl file");
            e.printStackTrace();
        }
        finally {
            if (outStream != null) {
                try {
                    osw.close();
                    outStream.close();
                }
                catch (Exception e) {
                    System.out.println("OLD WSDL FORMAT ERROR: Error while writing old wsdl file");
                    e.printStackTrace();
                }
            }
        }
    }

    private static void parseNoJcaDefinition(Definition def) throws Exception {
        List portTypes = JcaMigrationHelper.getAllPortTypes((Definition)def, (List)null);
        int portTypeCount = portTypes.size();
        boolean usePortType = portTypeCount > 1;
        for (PortType portType : portTypes) {
            String serviceName;
            String bindingName = portType.getQName().getLocalPart();
            if (bindingName.endsWith("_ptt")) {
                bindingName = bindingName.substring(0, bindingName.length() - 4);
            }
            if ((serviceName = def.getQName().getLocalPart()) == null || serviceName.equals("")) {
                serviceName = bindingName;
            }
            Binding binding = def.createBinding();
            binding.setQName(new QName(def.getTargetNamespace(), bindingName + "_binding"));
            binding.setPortType(portType);
            binding.setUndefined(false);
            def.addBinding(binding);
            def.addPortType(portType);
            Port port = def.createPort();
            port.setName(bindingName + "_pt");
            port.setBinding(binding);
            QName serviceQName = new QName(def.getTargetNamespace(), serviceName);
            Service service = def.getService(serviceQName);
            if (service == null) {
                service = def.createService();
                service.setQName(new QName(def.getTargetNamespace(), serviceName));
                def.addService(service);
            }
            service.addPort(port);
        }
    }

    public void createB2BSchemaFile(B2BContext ctx) throws Exception {
        String SCHEMA_RELATIVE_LOCATION = "xsd";
        ctx.setDirectory(WizardWSDLUtil.m_wcontext._project.getBaseDirectory());
        String wsdlSchemaRelativePath = null;
        if (ctx.getMDSConnectionName() != null) {
            wsdlSchemaRelativePath = ctx.getDocumentDefinition().getDefinitionFilename();
        } else if (!ctx.isOpaque() && !ctx.isAny()) {
            if (!ctx.isFileSystem()) {
                String schemaURL = ctx.getDocumentDefinition().getDefinitionFilename();
                List xsdDirStructure = ctx.getXSDDirStructure(schemaURL);
                String relativeSchemaPath = ctx.getRelativeXsdDirStr(xsdDirStructure, false);
                String relativeSchemaPathForWSDL = ctx.getRelativeXsdDirStr(xsdDirStructure, true);
                String schemaFilename = ctx.getSchemaFilename(schemaURL);
                String fullSchemaFilename = ctx.getSchemaDirectory() + relativeSchemaPath + schemaFilename;
                wsdlSchemaRelativePath = "xsd" + relativeSchemaPathForWSDL + schemaFilename;
                ctx.setFullSchemaFilename(fullSchemaFilename);
                this.createXsdDirStructure(ctx, xsdDirStructure);
                FileWriter schemaFW = new FileWriter(new File(ctx.getFullSchemaFilename()));
                schemaFW.write(ctx.getSchemaContent());
                schemaFW.flush();
                schemaFW.close();
            } else {
                SCAProject m_scaproj = SCAProject.getSCAProject((Project)WizardWSDLUtil.m_wcontext._project);
                URL m_xsdDirURL = m_scaproj.getXSDRoot();
                String fullSchemaFilename = m_xsdDirURL.getPath() + File.separator + ctx.getRelativeBrowseSchemaPath();
                wsdlSchemaRelativePath = "xsd/" + ctx.getRelativeBrowseSchemaPath();
                ctx.setFullSchemaFilename(fullSchemaFilename);
            }
        }
    }

    static {
        m_bInit = false;
        s_wsdlFactory = null;
        m_lock = new Boolean(true);
    }
}

